/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QEventWrapper::QEventWrapper(::QEvent::Type type) : QEvent(type)
{
    resetPyMethodCache();
    // ... middle
}

QEventWrapper::~QEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QEvent >()))
        return -1;

    ::QEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QEvent", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QEvent::QEvent(QEvent::Type)
    // 1: QEvent::QEvent(QEvent)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QEvent(QEvent)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QEvent(QEvent::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QEvent(QEvent::Type type)
        {
            ::QEvent::Type cppArg0{QEvent::None};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QEvent(QEvent::Type)
                cptr = new ::QEventWrapper(cppArg0);
            }
            break;
        }
        case 1: // QEvent(const QEvent & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QEvent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QEvent(QEvent)
                cptr = new ::QEventWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QEventFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.accept";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accept()
            cppSelf->accept();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QEventFunc_ignore(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.ignore";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ignore()
            cppSelf->ignore();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QEventFunc_isAccepted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.isAccepted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAccepted()const
            bool cppResult = const_cast<const ::QEvent *>(cppSelf)->isAccepted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEventFunc_registerEventType(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.registerEventType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QEventFunc_registerEventType_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:registerEventType", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QEvent::registerEventType(int)
    if (numArgs == 0) {
        overloadId = 0; // registerEventType(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // registerEventType(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventFunc_registerEventType_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_hint = Shiboken::String::createStaticString("hint");
            if (PyDict_Contains(kwds, key_hint)) {
                value = PyDict_GetItem(kwds, key_hint);
                if (value && pyArgs[0]) {
                    errInfo = key_hint;
                    Py_INCREF(errInfo);
                    goto Sbk_QEventFunc_registerEventType_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QEventFunc_registerEventType_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_hint);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QEventFunc_registerEventType_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // registerEventType(int)
            int cppResult = ::QEvent::registerEventType(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QEventFunc_registerEventType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEventFunc_setAccepted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.setAccepted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEvent::setAccepted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAccepted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventFunc_setAccepted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccepted(bool)
            cppSelf->setAccepted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEventFunc_setAccepted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEventFunc_spontaneous(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.spontaneous";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spontaneous()const
            bool cppResult = const_cast<const ::QEvent *>(cppSelf)->spontaneous();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEventFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEvent.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QEvent::Type cppResult = const_cast<const ::QEvent *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QEvent_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_accept), METH_NOARGS},
    {"ignore", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_ignore), METH_NOARGS},
    {"isAccepted", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_isAccepted), METH_NOARGS},
    {"registerEventType", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_registerEventType), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setAccepted", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_setAccepted), METH_O},
    {"spontaneous", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_spontaneous), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QEventFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QEvent_Type = nullptr;
static SbkObjectType *Sbk_QEvent_TypeF(void)
{
    return _Sbk_QEvent_Type;
}

static PyType_Slot Sbk_QEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QEvent_spec = {
    "2:PySide2.QtCore.QEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QEvent_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QEvent_Type_PythonToCpp_QEvent_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QEvent::Type *>(cppOut) =
        static_cast<::QEvent::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QEvent_Type_PythonToCpp_QEvent_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX]))
        return QEvent_Type_PythonToCpp_QEvent_Type;
    return {};
}
static PyObject *QEvent_Type_CppToPython_QEvent_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QEvent::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QEvent_PythonToCpp_QEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QEvent_PythonToCpp_QEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QEvent_TypeF())))
        return QEvent_PythonToCpp_QEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QEvent_PTR_CppToPython_QEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QEvent_SignatureStrings[] = {
    "1:PySide2.QtCore.QEvent(self,type:PySide2.QtCore.QEvent.Type)",
    "0:PySide2.QtCore.QEvent(self,other:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QEvent.accept(self)",
    "PySide2.QtCore.QEvent.ignore(self)",
    "PySide2.QtCore.QEvent.isAccepted(self)->bool",
    "PySide2.QtCore.QEvent.registerEventType(hint:int=-1)->int",
    "PySide2.QtCore.QEvent.setAccepted(self,accepted:bool)",
    "PySide2.QtCore.QEvent.spontaneous(self)->bool",
    "PySide2.QtCore.QEvent.type(self)->PySide2.QtCore.QEvent.Type",
    nullptr}; // Sentinel

void init_QEvent(PyObject *module)
{
    _Sbk_QEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QEvent",
        "QEvent*",
        &Sbk_QEvent_spec,
        &Shiboken::callCppDestructor< ::QEvent >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QEvent_Type);
    InitSignatureStrings(pyType, QEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QEvent_Type), Sbk_QEvent_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QEvent_TypeF(),
        QEvent_PythonToCpp_QEvent_PTR,
        is_QEvent_PythonToCpp_QEvent_PTR_Convertible,
        QEvent_PTR_CppToPython_QEvent);

    Shiboken::Conversions::registerConverterName(converter, "QEvent");
    Shiboken::Conversions::registerConverterName(converter, "QEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QEventWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QEvent_TypeF(),
        "Type",
        "2:PySide2.QtCore.QEvent.Type",
        "QEvent::Type");
    if (!SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "None_", (long) QEvent::Type::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Timer", (long) QEvent::Type::Timer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MouseButtonPress", (long) QEvent::Type::MouseButtonPress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MouseButtonRelease", (long) QEvent::Type::MouseButtonRelease))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MouseButtonDblClick", (long) QEvent::Type::MouseButtonDblClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MouseMove", (long) QEvent::Type::MouseMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "KeyPress", (long) QEvent::Type::KeyPress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "KeyRelease", (long) QEvent::Type::KeyRelease))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "FocusIn", (long) QEvent::Type::FocusIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "FocusOut", (long) QEvent::Type::FocusOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "FocusAboutToChange", (long) QEvent::Type::FocusAboutToChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Enter", (long) QEvent::Type::Enter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Leave", (long) QEvent::Type::Leave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Paint", (long) QEvent::Type::Paint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Move", (long) QEvent::Type::Move))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Resize", (long) QEvent::Type::Resize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Create", (long) QEvent::Type::Create))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Destroy", (long) QEvent::Type::Destroy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Show", (long) QEvent::Type::Show))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Hide", (long) QEvent::Type::Hide))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Close", (long) QEvent::Type::Close))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Quit", (long) QEvent::Type::Quit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ParentChange", (long) QEvent::Type::ParentChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ParentAboutToChange", (long) QEvent::Type::ParentAboutToChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ThreadChange", (long) QEvent::Type::ThreadChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowActivate", (long) QEvent::Type::WindowActivate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowDeactivate", (long) QEvent::Type::WindowDeactivate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ShowToParent", (long) QEvent::Type::ShowToParent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "HideToParent", (long) QEvent::Type::HideToParent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Wheel", (long) QEvent::Type::Wheel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowTitleChange", (long) QEvent::Type::WindowTitleChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowIconChange", (long) QEvent::Type::WindowIconChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationWindowIconChange", (long) QEvent::Type::ApplicationWindowIconChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationFontChange", (long) QEvent::Type::ApplicationFontChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationLayoutDirectionChange", (long) QEvent::Type::ApplicationLayoutDirectionChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationPaletteChange", (long) QEvent::Type::ApplicationPaletteChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "PaletteChange", (long) QEvent::Type::PaletteChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Clipboard", (long) QEvent::Type::Clipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Speech", (long) QEvent::Type::Speech))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MetaCall", (long) QEvent::Type::MetaCall))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "SockAct", (long) QEvent::Type::SockAct))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WinEventAct", (long) QEvent::Type::WinEventAct))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DeferredDelete", (long) QEvent::Type::DeferredDelete))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DragEnter", (long) QEvent::Type::DragEnter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DragMove", (long) QEvent::Type::DragMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DragLeave", (long) QEvent::Type::DragLeave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Drop", (long) QEvent::Type::Drop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DragResponse", (long) QEvent::Type::DragResponse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ChildAdded", (long) QEvent::Type::ChildAdded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ChildPolished", (long) QEvent::Type::ChildPolished))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ChildRemoved", (long) QEvent::Type::ChildRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ShowWindowRequest", (long) QEvent::Type::ShowWindowRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "PolishRequest", (long) QEvent::Type::PolishRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Polish", (long) QEvent::Type::Polish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "LayoutRequest", (long) QEvent::Type::LayoutRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "UpdateRequest", (long) QEvent::Type::UpdateRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "UpdateLater", (long) QEvent::Type::UpdateLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "EmbeddingControl", (long) QEvent::Type::EmbeddingControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ActivateControl", (long) QEvent::Type::ActivateControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DeactivateControl", (long) QEvent::Type::DeactivateControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ContextMenu", (long) QEvent::Type::ContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "InputMethod", (long) QEvent::Type::InputMethod))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TabletMove", (long) QEvent::Type::TabletMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "LocaleChange", (long) QEvent::Type::LocaleChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "LanguageChange", (long) QEvent::Type::LanguageChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "LayoutDirectionChange", (long) QEvent::Type::LayoutDirectionChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Style", (long) QEvent::Type::Style))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TabletPress", (long) QEvent::Type::TabletPress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TabletRelease", (long) QEvent::Type::TabletRelease))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "OkRequest", (long) QEvent::Type::OkRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "HelpRequest", (long) QEvent::Type::HelpRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "IconDrag", (long) QEvent::Type::IconDrag))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "FontChange", (long) QEvent::Type::FontChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "EnabledChange", (long) QEvent::Type::EnabledChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ActivationChange", (long) QEvent::Type::ActivationChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "StyleChange", (long) QEvent::Type::StyleChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "IconTextChange", (long) QEvent::Type::IconTextChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ModifiedChange", (long) QEvent::Type::ModifiedChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MouseTrackingChange", (long) QEvent::Type::MouseTrackingChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowBlocked", (long) QEvent::Type::WindowBlocked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowUnblocked", (long) QEvent::Type::WindowUnblocked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowStateChange", (long) QEvent::Type::WindowStateChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ReadOnlyChange", (long) QEvent::Type::ReadOnlyChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ToolTip", (long) QEvent::Type::ToolTip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WhatsThis", (long) QEvent::Type::WhatsThis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "StatusTip", (long) QEvent::Type::StatusTip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ActionChanged", (long) QEvent::Type::ActionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ActionAdded", (long) QEvent::Type::ActionAdded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ActionRemoved", (long) QEvent::Type::ActionRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "FileOpen", (long) QEvent::Type::FileOpen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Shortcut", (long) QEvent::Type::Shortcut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ShortcutOverride", (long) QEvent::Type::ShortcutOverride))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WhatsThisClicked", (long) QEvent::Type::WhatsThisClicked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ToolBarChange", (long) QEvent::Type::ToolBarChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationActivate", (long) QEvent::Type::ApplicationActivate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationActivated", (long) QEvent::Type::ApplicationActivated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationDeactivate", (long) QEvent::Type::ApplicationDeactivate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationDeactivated", (long) QEvent::Type::ApplicationDeactivated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "QueryWhatsThis", (long) QEvent::Type::QueryWhatsThis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "EnterWhatsThisMode", (long) QEvent::Type::EnterWhatsThisMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "LeaveWhatsThisMode", (long) QEvent::Type::LeaveWhatsThisMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ZOrderChange", (long) QEvent::Type::ZOrderChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "HoverEnter", (long) QEvent::Type::HoverEnter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "HoverLeave", (long) QEvent::Type::HoverLeave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "HoverMove", (long) QEvent::Type::HoverMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "AcceptDropsChange", (long) QEvent::Type::AcceptDropsChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ZeroTimerEvent", (long) QEvent::Type::ZeroTimerEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneMouseMove", (long) QEvent::Type::GraphicsSceneMouseMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneMousePress", (long) QEvent::Type::GraphicsSceneMousePress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneMouseRelease", (long) QEvent::Type::GraphicsSceneMouseRelease))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneMouseDoubleClick", (long) QEvent::Type::GraphicsSceneMouseDoubleClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneContextMenu", (long) QEvent::Type::GraphicsSceneContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneHoverEnter", (long) QEvent::Type::GraphicsSceneHoverEnter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneHoverMove", (long) QEvent::Type::GraphicsSceneHoverMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneHoverLeave", (long) QEvent::Type::GraphicsSceneHoverLeave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneHelp", (long) QEvent::Type::GraphicsSceneHelp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneDragEnter", (long) QEvent::Type::GraphicsSceneDragEnter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneDragMove", (long) QEvent::Type::GraphicsSceneDragMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneDragLeave", (long) QEvent::Type::GraphicsSceneDragLeave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneDrop", (long) QEvent::Type::GraphicsSceneDrop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneWheel", (long) QEvent::Type::GraphicsSceneWheel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "KeyboardLayoutChange", (long) QEvent::Type::KeyboardLayoutChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "DynamicPropertyChange", (long) QEvent::Type::DynamicPropertyChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TabletEnterProximity", (long) QEvent::Type::TabletEnterProximity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TabletLeaveProximity", (long) QEvent::Type::TabletLeaveProximity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "NonClientAreaMouseMove", (long) QEvent::Type::NonClientAreaMouseMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "NonClientAreaMouseButtonPress", (long) QEvent::Type::NonClientAreaMouseButtonPress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "NonClientAreaMouseButtonRelease", (long) QEvent::Type::NonClientAreaMouseButtonRelease))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "NonClientAreaMouseButtonDblClick", (long) QEvent::Type::NonClientAreaMouseButtonDblClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MacSizeChange", (long) QEvent::Type::MacSizeChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ContentsRectChange", (long) QEvent::Type::ContentsRectChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MacGLWindowChange", (long) QEvent::Type::MacGLWindowChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "FutureCallOut", (long) QEvent::Type::FutureCallOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneResize", (long) QEvent::Type::GraphicsSceneResize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GraphicsSceneMove", (long) QEvent::Type::GraphicsSceneMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "CursorChange", (long) QEvent::Type::CursorChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ToolTipChange", (long) QEvent::Type::ToolTipChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "NetworkReplyUpdated", (long) QEvent::Type::NetworkReplyUpdated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GrabMouse", (long) QEvent::Type::GrabMouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "UngrabMouse", (long) QEvent::Type::UngrabMouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GrabKeyboard", (long) QEvent::Type::GrabKeyboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "UngrabKeyboard", (long) QEvent::Type::UngrabKeyboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MacGLClearDrawable", (long) QEvent::Type::MacGLClearDrawable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "StateMachineSignal", (long) QEvent::Type::StateMachineSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "StateMachineWrapped", (long) QEvent::Type::StateMachineWrapped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TouchBegin", (long) QEvent::Type::TouchBegin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TouchUpdate", (long) QEvent::Type::TouchUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TouchEnd", (long) QEvent::Type::TouchEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "NativeGesture", (long) QEvent::Type::NativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "RequestSoftwareInputPanel", (long) QEvent::Type::RequestSoftwareInputPanel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "CloseSoftwareInputPanel", (long) QEvent::Type::CloseSoftwareInputPanel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WinIdChange", (long) QEvent::Type::WinIdChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Gesture", (long) QEvent::Type::Gesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "GestureOverride", (long) QEvent::Type::GestureOverride))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ScrollPrepare", (long) QEvent::Type::ScrollPrepare))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Scroll", (long) QEvent::Type::Scroll))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Expose", (long) QEvent::Type::Expose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "InputMethodQuery", (long) QEvent::Type::InputMethodQuery))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "OrientationChange", (long) QEvent::Type::OrientationChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TouchCancel", (long) QEvent::Type::TouchCancel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ThemeChange", (long) QEvent::Type::ThemeChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "SockClose", (long) QEvent::Type::SockClose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "PlatformPanel", (long) QEvent::Type::PlatformPanel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "StyleAnimationUpdate", (long) QEvent::Type::StyleAnimationUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ApplicationStateChange", (long) QEvent::Type::ApplicationStateChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "WindowChangeInternal", (long) QEvent::Type::WindowChangeInternal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "ScreenChangeInternal", (long) QEvent::Type::ScreenChangeInternal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "PlatformSurface", (long) QEvent::Type::PlatformSurface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "Pointer", (long) QEvent::Type::Pointer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "TabletTrackingChange", (long) QEvent::Type::TabletTrackingChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "User", (long) QEvent::Type::User))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
        Sbk_QEvent_TypeF(), "MaxUser", (long) QEvent::Type::MaxUser))
        return;
    // Register converter for enum 'QEvent::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX],
            QEvent_Type_CppToPython_QEvent_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QEvent_Type_PythonToCpp_QEvent_Type,
            is_QEvent_Type_PythonToCpp_QEvent_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QEvent::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::QEvent::Type >("QEvent::Type");
}
