/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qeventloop_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QEventLoopWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QEventLoopWrapper::QEventLoopWrapper(::QObject * parent) : QEventLoop(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QEventLoopWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QEventLoopWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QEventLoopWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QEventLoopWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QEventLoopWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QEventLoop::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QEventLoop::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QEventLoop.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QEventLoopWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QEventLoop.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QEventLoopWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QEventLoopWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QEventLoop::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QEventLoopWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QEventLoop::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QEventLoopWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QEventLoopWrapper *>(this));
        return QEventLoop::qt_metacast(_clname);
}

QEventLoopWrapper::~QEventLoopWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QEventLoop_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QEventLoop >()))
        return -1;

    ::QEventLoopWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QEventLoop", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QEventLoop::QEventLoop(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QEventLoop(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QEventLoop(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventLoop_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QEventLoop_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QEventLoop_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QEventLoop(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QEventLoopWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QEventLoopWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QEventLoop >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QEventLoop_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QEventLoop_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QEventLoop_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QEventLoopFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventLoopFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QEventLoop::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QEventLoopFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEventLoopFunc_exec_(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.exec_";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QEventLoopFunc_exec__TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:exec_", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QEventLoop::exec(QFlags<QEventLoop::ProcessEventsFlag>)
    if (numArgs == 0) {
        overloadId = 0; // exec(QFlags<QEventLoop::ProcessEventsFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // exec(QFlags<QEventLoop::ProcessEventsFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventLoopFunc_exec__TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[0]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QEventLoopFunc_exec__TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QEventLoopFunc_exec__TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QEventLoopFunc_exec__TypeError;
            }
        }
        ::QFlags<QEventLoop::ProcessEventsFlag> cppArg0 = QEventLoop::AllEvents;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // exec(QFlags<QEventLoop::ProcessEventsFlag>)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            int cppResult = cppSelf->exec(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QEventLoopFunc_exec__TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEventLoopFunc_exit(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.exit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QEventLoopFunc_exit_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:exit", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QEventLoop::exit(int)
    if (numArgs == 0) {
        overloadId = 0; // exit(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // exit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventLoopFunc_exit_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_returnCode = Shiboken::String::createStaticString("returnCode");
            if (PyDict_Contains(kwds, key_returnCode)) {
                value = PyDict_GetItem(kwds, key_returnCode);
                if (value && pyArgs[0]) {
                    errInfo = key_returnCode;
                    Py_INCREF(errInfo);
                    goto Sbk_QEventLoopFunc_exit_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QEventLoopFunc_exit_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_returnCode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QEventLoopFunc_exit_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // exit(int)
            cppSelf->exit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEventLoopFunc_exit_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEventLoopFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.isRunning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunning()const
            bool cppResult = const_cast<const ::QEventLoop *>(cppSelf)->isRunning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEventLoopFunc_processEvents(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.processEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QEventLoopFunc_processEvents_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:processEvents", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QEventLoop::processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
    // 1: QEventLoop::processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
    if (numArgs == 0) {
        overloadId = 0; // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEventLoopFunc_processEvents_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[0]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QEventLoopFunc_processEvents_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QEventLoopFunc_processEvents_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QEventLoopFunc_processEvents_TypeError;
                }
            }
            ::QFlags<QEventLoop::ProcessEventsFlag> cppArg0 = QEventLoop::AllEvents;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->processEvents(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags, int maximumTime)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QEventLoopFunc_processEvents_TypeError;
            }
            ::QFlags<QEventLoop::ProcessEventsFlag> cppArg0 = QFlags<QEventLoop::ProcessEventsFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                cppSelf->processEvents(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QEventLoopFunc_processEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEventLoopFunc_quit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.quit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quit()
            cppSelf->quit();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QEventLoopFunc_wakeUp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEventLoop.wakeUp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wakeUp()
            cppSelf->wakeUp();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QEventLoop_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QEventLoop_methods[] = {
    {"event", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_event), METH_O},
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_exec_), METH_VARARGS|METH_KEYWORDS},
    {"exit", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_exit), METH_VARARGS|METH_KEYWORDS},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_isRunning), METH_NOARGS},
    {"processEvents", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_processEvents), METH_VARARGS|METH_KEYWORDS},
    {"quit", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_quit), METH_NOARGS},
    {"wakeUp", reinterpret_cast<PyCFunction>(Sbk_QEventLoopFunc_wakeUp), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QEventLoop_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QEventLoop *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QEventLoopWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QEventLoop_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QEventLoop_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QEventLoop_Type = nullptr;
static SbkObjectType *Sbk_QEventLoop_TypeF(void)
{
    return _Sbk_QEventLoop_Type;
}

static PyType_Slot Sbk_QEventLoop_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QEventLoop_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QEventLoop_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QEventLoop_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QEventLoop_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QEventLoop_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QEventLoop_spec = {
    "2:PySide2.QtCore.QEventLoop",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QEventLoop_slots
};

} //extern "C"

static void *Sbk_QEventLoop_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QEventLoop *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QEventLoop::ProcessEventsFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QEventLoop::ProcessEventsFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QEventLoop::ProcessEventsFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QEventLoop::ProcessEventsFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QEventLoop::ProcessEventsFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QEventLoop::ProcessEventsFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QEventLoop::ProcessEventsFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QEventLoop::ProcessEventsFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QEventLoop::ProcessEventsFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QEventLoop::ProcessEventsFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QEventLoop::ProcessEventsFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QEventLoop::ProcessEventsFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QEventLoop::ProcessEventsFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QEventLoop::ProcessEventsFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QEventLoop::ProcessEventsFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QEventLoop::ProcessEventsFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, self, &cppSelf);
    ::QEventLoop::ProcessEventsFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QEventLoop_ProcessEventsFlag_PythonToCpp_QEventLoop_ProcessEventsFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QEventLoop::ProcessEventsFlag *>(cppOut) =
        static_cast<::QEventLoop::ProcessEventsFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QEventLoop_ProcessEventsFlag_PythonToCpp_QEventLoop_ProcessEventsFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]))
        return QEventLoop_ProcessEventsFlag_PythonToCpp_QEventLoop_ProcessEventsFlag;
    return {};
}
static PyObject *QEventLoop_ProcessEventsFlag_CppToPython_QEventLoop_ProcessEventsFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QEventLoop::ProcessEventsFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX], castCppIn);

}

static void QFlags_QEventLoop_ProcessEventsFlag__PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QEventLoop::ProcessEventsFlag> *>(cppOut) =
        ::QFlags<QEventLoop::ProcessEventsFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QEventLoop_ProcessEventsFlag__PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]))
        return QFlags_QEventLoop_ProcessEventsFlag__PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_;
    return {};
}
static PyObject *QFlags_QEventLoop_ProcessEventsFlag__CppToPython_QFlags_QEventLoop_ProcessEventsFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QEventLoop::ProcessEventsFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]));

}

static void QEventLoop_ProcessEventsFlag_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QEventLoop::ProcessEventsFlag> *>(cppOut) =
        ::QFlags<QEventLoop::ProcessEventsFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QEventLoop_ProcessEventsFlag_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]))
        return QEventLoop_ProcessEventsFlag_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QEventLoop::ProcessEventsFlag> *>(cppOut) =
        ::QFlags<QEventLoop::ProcessEventsFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]))
        return number_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QEventLoop_PythonToCpp_QEventLoop_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QEventLoop_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QEventLoop_PythonToCpp_QEventLoop_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QEventLoop_TypeF())))
        return QEventLoop_PythonToCpp_QEventLoop_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QEventLoop_PTR_CppToPython_QEventLoop(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QEventLoop *>(const_cast<void *>(cppIn)), Sbk_QEventLoop_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QEventLoop_SignatureStrings[] = {
    "PySide2.QtCore.QEventLoop(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QEventLoop.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QEventLoop.exec_(self,flags:PySide2.QtCore.QEventLoop.ProcessEventsFlags=QEventLoop.AllEvents)->int",
    "PySide2.QtCore.QEventLoop.exit(self,returnCode:int=0)",
    "PySide2.QtCore.QEventLoop.isRunning(self)->bool",
    "1:PySide2.QtCore.QEventLoop.processEvents(self,flags:PySide2.QtCore.QEventLoop.ProcessEventsFlags=QEventLoop.AllEvents)->bool",
    "0:PySide2.QtCore.QEventLoop.processEvents(self,flags:PySide2.QtCore.QEventLoop.ProcessEventsFlags,maximumTime:int)",
    "PySide2.QtCore.QEventLoop.quit(self)",
    "PySide2.QtCore.QEventLoop.wakeUp(self)",
    nullptr}; // Sentinel

void init_QEventLoop(PyObject *module)
{
    _Sbk_QEventLoop_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QEventLoop",
        "QEventLoop*",
        &Sbk_QEventLoop_spec,
        &Shiboken::callCppDestructor< ::QEventLoop >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QEventLoop_Type);
    InitSignatureStrings(pyType, QEventLoop_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QEventLoop_Type), Sbk_QEventLoop_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QEventLoop_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QEventLoop_TypeF(),
        QEventLoop_PythonToCpp_QEventLoop_PTR,
        is_QEventLoop_PythonToCpp_QEventLoop_PTR_Convertible,
        QEventLoop_PTR_CppToPython_QEventLoop);

    Shiboken::Conversions::registerConverterName(converter, "QEventLoop");
    Shiboken::Conversions::registerConverterName(converter, "QEventLoop*");
    Shiboken::Conversions::registerConverterName(converter, "QEventLoop&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QEventLoop).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QEventLoopWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QEventLoop_TypeF(), &Sbk_QEventLoop_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ProcessEventsFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QEventLoop.ProcessEventsFlags", SbkPySide2_QtCore_QEventLoop_ProcessEventsFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QEventLoop_TypeF(),
        "ProcessEventsFlag",
        "2:PySide2.QtCore.QEventLoop.ProcessEventsFlag",
        "QEventLoop::ProcessEventsFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "AllEvents", (long) QEventLoop::ProcessEventsFlag::AllEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "ExcludeUserInputEvents", (long) QEventLoop::ProcessEventsFlag::ExcludeUserInputEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "ExcludeSocketNotifiers", (long) QEventLoop::ProcessEventsFlag::ExcludeSocketNotifiers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "WaitForMoreEvents", (long) QEventLoop::ProcessEventsFlag::WaitForMoreEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "X11ExcludeTimers", (long) QEventLoop::ProcessEventsFlag::X11ExcludeTimers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "EventLoopExec", (long) QEventLoop::ProcessEventsFlag::EventLoopExec))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
        Sbk_QEventLoop_TypeF(), "DialogExec", (long) QEventLoop::ProcessEventsFlag::DialogExec))
        return;
    // Register converter for enum 'QEventLoop::ProcessEventsFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
            QEventLoop_ProcessEventsFlag_CppToPython_QEventLoop_ProcessEventsFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QEventLoop_ProcessEventsFlag_PythonToCpp_QEventLoop_ProcessEventsFlag,
            is_QEventLoop_ProcessEventsFlag_PythonToCpp_QEventLoop_ProcessEventsFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QEventLoop::ProcessEventsFlag");
        Shiboken::Conversions::registerConverterName(converter, "ProcessEventsFlag");
    }
    // Register converter for flag 'QFlags<QEventLoop::ProcessEventsFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX],
            QFlags_QEventLoop_ProcessEventsFlag__CppToPython_QFlags_QEventLoop_ProcessEventsFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QEventLoop_ProcessEventsFlag_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_,
            is_QEventLoop_ProcessEventsFlag_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QEventLoop_ProcessEventsFlag__PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_,
            is_QFlags_QEventLoop_ProcessEventsFlag__PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag_,
            is_number_PythonToCpp_QFlags_QEventLoop_ProcessEventsFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QEventLoop::ProcessEventsFlags");
        Shiboken::Conversions::registerConverterName(converter, "ProcessEventsFlags");
    }
    // End of 'ProcessEventsFlag' enum/flags.

    PySide::Signal::registerSignals(Sbk_QEventLoop_TypeF(), &::QEventLoop::staticMetaObject);
    qRegisterMetaType< ::QEventLoop::ProcessEventsFlag >("QEventLoop::ProcessEventsFlag");
    qRegisterMetaType< ::QEventLoop::ProcessEventsFlags >("QEventLoop::ProcessEventsFlags");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QEventLoop_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QEventLoop_TypeF(), &::QEventLoop::staticMetaObject, sizeof(QEventLoopWrapper));
}
