/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qfiledevice_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QFileDeviceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QFileDeviceWrapper::QFileDeviceWrapper() : QFileDevice()
{
    resetPyMethodCache();
    // ... middle
}

QFileDeviceWrapper::QFileDeviceWrapper(::QObject * parent) : QFileDevice(parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QFileDeviceWrapper::atEnd() const
{
    if (m_PyMethodCache[0])
        return this->::QFileDevice::atEnd();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "atEnd";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QFileDevice::atEnd();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.atEnd", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileDeviceWrapper::bytesAvailable() const
{
    if (m_PyMethodCache[1])
        return this->::QIODevice::bytesAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QIODevice::bytesAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.bytesAvailable", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileDeviceWrapper::bytesToWrite() const
{
    if (m_PyMethodCache[2])
        return this->::QIODevice::bytesToWrite();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesToWrite";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QIODevice::bytesToWrite();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.bytesToWrite", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::canReadLine() const
{
    if (m_PyMethodCache[3])
        return this->::QIODevice::canReadLine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canReadLine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QIODevice::canReadLine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.canReadLine", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDeviceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDeviceWrapper::close()
{
    if (m_PyMethodCache[5]) {
        return this->::QFileDevice::close();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QFileDevice::close();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDeviceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDeviceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDeviceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QFileDeviceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QFileDeviceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QString QFileDeviceWrapper::fileName() const
{
    if (m_PyMethodCache[11])
        return this->::QFileDevice::fileName();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "fileName";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QFileDevice::fileName();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.fileName", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::isSequential() const
{
    if (m_PyMethodCache[12])
        return this->::QFileDevice::isSequential();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSequential";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QFileDevice::isSequential();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.isSequential", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::open(::QFlags<QIODevice::OpenModeFlag> mode)
{
    if (m_PyMethodCache[14])
        return this->::QIODevice::open(mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QFileDevice::Permission> QFileDeviceWrapper::permissions() const
{
    if (m_PyMethodCache[15])
        return this->::QFileDevice::permissions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QFileDevice::Permission>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "permissions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QFileDevice::permissions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QFileDevice::Permission>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.permissions", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QFileDevice::Permission> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QFileDevice::Permission>(0);
    }
    ::QFlags<QFileDevice::Permission> cppResult = QFlags<QFileDevice::Permission>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileDeviceWrapper::pos() const
{
    if (m_PyMethodCache[16])
        return this->::QFileDevice::pos();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pos";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QFileDevice::pos();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.pos", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileDeviceWrapper::readData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[17]) {
        return this->::QFileDevice::readData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QFileDevice::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

qint64 QFileDeviceWrapper::readLineData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[18]) {
        return this->::QFileDevice::readLineData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readLineData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QFileDevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

bool QFileDeviceWrapper::reset()
{
    if (m_PyMethodCache[19])
        return this->::QIODevice::reset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QIODevice::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.reset", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::resize(qint64 sz)
{
    if (m_PyMethodCache[20])
        return this->::QFileDevice::resize(sz);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QFileDevice::resize(sz);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    sz
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.resize", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::seek(qint64 offset)
{
    if (m_PyMethodCache[21])
        return this->::QFileDevice::seek(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "seek";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QFileDevice::seek(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    offset
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.seek", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::setPermissions(::QFlags<QFileDevice::Permission> permissionSpec)
{
    if (m_PyMethodCache[22])
        return this->::QFileDevice::setPermissions(permissionSpec);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPermissions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QFileDevice::setPermissions(permissionSpec);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &permissionSpec)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.setPermissions", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileDeviceWrapper::size() const
{
    if (m_PyMethodCache[23])
        return this->::QFileDevice::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QFileDevice::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.size", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDeviceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[24]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QFileDeviceWrapper::waitForBytesWritten(int msecs)
{
    if (m_PyMethodCache[25])
        return this->::QIODevice::waitForBytesWritten(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForBytesWritten";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QIODevice::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.waitForBytesWritten", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileDeviceWrapper::waitForReadyRead(int msecs)
{
    if (m_PyMethodCache[26])
        return this->::QIODevice::waitForReadyRead(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForReadyRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QIODevice::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.waitForReadyRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileDeviceWrapper::writeData(const char * data, qint64 len)
{
    if (m_PyMethodCache[27])
        return this->::QFileDevice::writeData(data, len);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "writeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QFileDevice::writeData(data, len);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    len
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDevice.writeData", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QFileDeviceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QFileDevice::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QFileDeviceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QFileDevice::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QFileDeviceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QFileDeviceWrapper *>(this));
        return QFileDevice::qt_metacast(_clname);
}

QFileDeviceWrapper::~QFileDeviceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFileDevice_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFileDevice >()))
        return -1;

    ::QFileDeviceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFileDevice", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QFileDevice::QFileDevice()
    // 1: QFileDevice::QFileDevice(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QFileDevice()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFileDevice(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDevice_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFileDevice()
        {

            if (!PyErr_Occurred()) {
                // QFileDevice()
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileDeviceWrapper();
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileDeviceWrapper();
                }

            }
            break;
        }
        case 1: // QFileDevice(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFileDevice(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileDeviceWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileDeviceWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFileDevice >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFileDevice_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QFileDevice_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QFileDevice_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFileDeviceFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileDevice *>(cppSelf)->::QFileDevice::atEnd()
                : const_cast<const ::QFileDevice *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDevice::close()
                : cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFileDeviceFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QFileDevice::FileError cppResult = const_cast<const ::QFileDevice *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileDevice *>(cppSelf)->::QFileDevice::fileName()
                : const_cast<const ::QFileDevice *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_fileTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.fileTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDevice::fileTime(QFileDevice::FileTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX])->converter, (pyArg)))) {
        overloadId = 0; // fileTime(QFileDevice::FileTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_fileTime_TypeError;

    // Call function/method
    {
        ::QFileDevice::FileTime cppArg0{QFileDevice::FileAccessTime};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fileTime(QFileDevice::FileTime)const
            QDateTime cppResult = const_cast<const ::QFileDevice *>(cppSelf)->fileTime(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_fileTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_flush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.flush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flush()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->flush();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            int cppResult = const_cast<const ::QFileDevice *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_isSequential(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.isSequential";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSequential()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileDevice *>(cppSelf)->::QFileDevice::isSequential()
                : const_cast<const ::QFileDevice *>(cppSelf)->isSequential();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_map(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.map";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDeviceFunc_map_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFileDeviceFunc_map_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:map", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QFileDevice::map(qint64,qint64,QFileDevice::MemoryMapFlags)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // map(qint64,qint64,QFileDevice::MemoryMapFlags)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // map(qint64,qint64,QFileDevice::MemoryMapFlags)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_map_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[2]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDeviceFunc_map_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QFileDeviceFunc_map_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDeviceFunc_map_TypeError;
            }
        }
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFileDevice::MemoryMapFlags cppArg2 = QFileDevice::MemoryMapFlags::NoOptions;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // map(qint64,qint64,QFileDevice::MemoryMapFlags)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qfiledevice-map)]
            pyResult = Shiboken::Buffer::newObject(cppSelf->map(cppArg0, cppArg1, cppArg2), cppArg1, Shiboken::Buffer::ReadWrite);
            // END of custom code block [file: ../glue/qtcore.cpp (qfiledevice-map)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_map_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_permissions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.permissions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // permissions()const
            QFlags<QFileDevice::Permission> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileDevice *>(cppSelf)->::QFileDevice::permissions()
                : const_cast<const ::QFileDevice *>(cppSelf)->permissions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileDevice *>(cppSelf)->::QFileDevice::pos()
                : const_cast<const ::QFileDevice *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_readData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.readData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_readData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QFileDevice::readData(ba.data(), int(cppArg0)) : cppSelf->readData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_readData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_readLineData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.readLineData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readLineData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readLineData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_readLineData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readLineData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QFileDevice::readLineData(ba.data(), int(cppArg0)) : cppSelf->readLineData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_readLineData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_resize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.resize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDevice::resize(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // resize(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_resize_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resize(qint64)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDevice::resize(cppArg0)
                : cppSelf->resize(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_resize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_seek(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.seek";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::seek(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // seek(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_seek_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // seek(qint64)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDevice::seek(cppArg0)
                : cppSelf->seek(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_seek_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_setFileTime(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.setFileTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFileTime", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileDevice::setFileTime(QDateTime,QFileDevice::FileTime)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setFileTime(QDateTime,QFileDevice::FileTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_setFileTime_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFileDevice::FileTime cppArg1{QFileDevice::FileAccessTime};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFileTime(QDateTime,QFileDevice::FileTime)
            bool cppResult = cppSelf->setFileTime(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_setFileTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_setPermissions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.setPermissions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDevice::setPermissions(QFlags<QFileDevice::Permission>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPermissions(QFlags<QFileDevice::Permission>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_setPermissions_TypeError;

    // Call function/method
    {
        ::QFlags<QFileDevice::Permission> cppArg0 = QFlags<QFileDevice::Permission>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPermissions(QFlags<QFileDevice::Permission>)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDevice::setPermissions(cppArg0)
                : cppSelf->setPermissions(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_setPermissions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileDevice *>(cppSelf)->::QFileDevice::size()
                : const_cast<const ::QFileDevice *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDeviceFunc_unmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.unmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDevice::unmap(uchar*)
    if (Shiboken::Buffer::checkType(pyArg)) {
        overloadId = 0; // unmap(uchar*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_unmap_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unmap(uchar*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qfiledevice-unmap)]
            uchar *ptr = reinterpret_cast<uchar *>(Shiboken::Buffer::getPointer(pyArg));
            bool cppResult = cppSelf->unmap(ptr);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qfiledevice-unmap)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_unmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDeviceFunc_unsetError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.unsetError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unsetError()
            cppSelf->unsetError();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFileDeviceFunc_writeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileDevice.writeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::writeData(const char*,qint64)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // writeData(const char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDeviceFunc_writeData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // writeData(const char*,qint64)
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDevice::writeData(cppArg0, cppArg1)
                : cppSelf->writeData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDeviceFunc_writeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QFileDevice_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFileDevice_methods[] = {
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_atEnd), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_close), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_error), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_fileName), METH_NOARGS},
    {"fileTime", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_fileTime), METH_O},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_flush), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_handle), METH_NOARGS},
    {"isSequential", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_isSequential), METH_NOARGS},
    {"map", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_map), METH_VARARGS|METH_KEYWORDS},
    {"permissions", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_permissions), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_pos), METH_NOARGS},
    {"readData", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_readData), METH_O},
    {"readLineData", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_readLineData), METH_O},
    {"resize", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_resize), METH_O},
    {"seek", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_seek), METH_O},
    {"setFileTime", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_setFileTime), METH_VARARGS},
    {"setPermissions", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_setPermissions), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_size), METH_NOARGS},
    {"unmap", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_unmap), METH_O},
    {"unsetError", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_unsetError), METH_NOARGS},
    {"writeData", reinterpret_cast<PyCFunction>(Sbk_QFileDeviceFunc_writeData), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QFileDevice_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QFileDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QFileDeviceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QFileDevice_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFileDevice_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFileDevice_Type = nullptr;
static SbkObjectType *Sbk_QFileDevice_TypeF(void)
{
    return _Sbk_QFileDevice_Type;
}

static PyType_Slot Sbk_QFileDevice_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QFileDevice_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFileDevice_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFileDevice_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFileDevice_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFileDevice_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFileDevice_spec = {
    "2:PySide2.QtCore.QFileDevice",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFileDevice_slots
};

} //extern "C"

static void *Sbk_QFileDevice_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QFileDevice *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtCore_QFileDevice_Permission___and__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::Permissions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDevice::Permissions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDevice::Permissions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDevice::Permissions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDevice::Permissions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QFileDevice_Permission___or__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::Permissions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDevice::Permissions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDevice::Permissions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDevice::Permissions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDevice::Permissions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QFileDevice_Permission___xor__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::Permissions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDevice::Permissions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDevice::Permissions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDevice::Permissions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDevice::Permissions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QFileDevice_Permission___invert__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::Permissions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, self, &cppSelf);
    ::QFileDevice::Permissions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QFileDevice_Permission_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QFileDevice_Permission__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QFileDevice_Permission_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_Permission_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_QFileDevice_FileHandleFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::FileHandleFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDevice::FileHandleFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDevice::FileHandleFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDevice::FileHandleFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDevice::FileHandleFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QFileDevice_FileHandleFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::FileHandleFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDevice::FileHandleFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDevice::FileHandleFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDevice::FileHandleFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDevice::FileHandleFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QFileDevice_FileHandleFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::FileHandleFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDevice::FileHandleFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDevice::FileHandleFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDevice::FileHandleFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDevice::FileHandleFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QFileDevice_FileHandleFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QFileDevice::FileHandleFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, self, &cppSelf);
    ::QFileDevice::FileHandleFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QFileDevice_FileHandleFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QFileDevice_FileHandleFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QFileDevice_FileHandleFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QFileDevice_FileHandleFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QFileDevice_FileError_PythonToCpp_QFileDevice_FileError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDevice::FileError *>(cppOut) =
        static_cast<::QFileDevice::FileError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDevice_FileError_PythonToCpp_QFileDevice_FileError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX]))
        return QFileDevice_FileError_PythonToCpp_QFileDevice_FileError;
    return {};
}
static PyObject *QFileDevice_FileError_CppToPython_QFileDevice_FileError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDevice::FileError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX], castCppIn);

}

static void QFileDevice_FileTime_PythonToCpp_QFileDevice_FileTime(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDevice::FileTime *>(cppOut) =
        static_cast<::QFileDevice::FileTime>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDevice_FileTime_PythonToCpp_QFileDevice_FileTime_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX]))
        return QFileDevice_FileTime_PythonToCpp_QFileDevice_FileTime;
    return {};
}
static PyObject *QFileDevice_FileTime_CppToPython_QFileDevice_FileTime(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDevice::FileTime *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX], castCppIn);

}

static void QFileDevice_Permission_PythonToCpp_QFileDevice_Permission(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDevice::Permission *>(cppOut) =
        static_cast<::QFileDevice::Permission>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDevice_Permission_PythonToCpp_QFileDevice_Permission_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX]))
        return QFileDevice_Permission_PythonToCpp_QFileDevice_Permission;
    return {};
}
static PyObject *QFileDevice_Permission_CppToPython_QFileDevice_Permission(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDevice::Permission *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX], castCppIn);

}

static void QFlags_QFileDevice_Permission__PythonToCpp_QFlags_QFileDevice_Permission_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileDevice::Permission> *>(cppOut) =
        ::QFlags<QFileDevice::Permission>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QFileDevice_Permission__PythonToCpp_QFlags_QFileDevice_Permission__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX]))
        return QFlags_QFileDevice_Permission__PythonToCpp_QFlags_QFileDevice_Permission_;
    return {};
}
static PyObject *QFlags_QFileDevice_Permission__CppToPython_QFlags_QFileDevice_Permission_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QFileDevice::Permission> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX]));

}

static void QFileDevice_Permission_PythonToCpp_QFlags_QFileDevice_Permission_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileDevice::Permission> *>(cppOut) =
        ::QFlags<QFileDevice::Permission>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QFileDevice_Permission_PythonToCpp_QFlags_QFileDevice_Permission__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX]))
        return QFileDevice_Permission_PythonToCpp_QFlags_QFileDevice_Permission_;
    return {};
}
static void number_PythonToCpp_QFlags_QFileDevice_Permission_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QFileDevice::Permission> *>(cppOut) =
        ::QFlags<QFileDevice::Permission>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QFileDevice_Permission__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX]))
        return number_PythonToCpp_QFlags_QFileDevice_Permission_;
    return {};
}
static void QFileDevice_FileHandleFlag_PythonToCpp_QFileDevice_FileHandleFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDevice::FileHandleFlag *>(cppOut) =
        static_cast<::QFileDevice::FileHandleFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDevice_FileHandleFlag_PythonToCpp_QFileDevice_FileHandleFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX]))
        return QFileDevice_FileHandleFlag_PythonToCpp_QFileDevice_FileHandleFlag;
    return {};
}
static PyObject *QFileDevice_FileHandleFlag_CppToPython_QFileDevice_FileHandleFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDevice::FileHandleFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX], castCppIn);

}

static void QFlags_QFileDevice_FileHandleFlag__PythonToCpp_QFlags_QFileDevice_FileHandleFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileDevice::FileHandleFlag> *>(cppOut) =
        ::QFlags<QFileDevice::FileHandleFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QFileDevice_FileHandleFlag__PythonToCpp_QFlags_QFileDevice_FileHandleFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX]))
        return QFlags_QFileDevice_FileHandleFlag__PythonToCpp_QFlags_QFileDevice_FileHandleFlag_;
    return {};
}
static PyObject *QFlags_QFileDevice_FileHandleFlag__CppToPython_QFlags_QFileDevice_FileHandleFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QFileDevice::FileHandleFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX]));

}

static void QFileDevice_FileHandleFlag_PythonToCpp_QFlags_QFileDevice_FileHandleFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileDevice::FileHandleFlag> *>(cppOut) =
        ::QFlags<QFileDevice::FileHandleFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QFileDevice_FileHandleFlag_PythonToCpp_QFlags_QFileDevice_FileHandleFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX]))
        return QFileDevice_FileHandleFlag_PythonToCpp_QFlags_QFileDevice_FileHandleFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QFileDevice_FileHandleFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QFileDevice::FileHandleFlag> *>(cppOut) =
        ::QFlags<QFileDevice::FileHandleFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QFileDevice_FileHandleFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QFileDevice_FileHandleFlag_;
    return {};
}
static void QFileDevice_MemoryMapFlags_PythonToCpp_QFileDevice_MemoryMapFlags(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDevice::MemoryMapFlags *>(cppOut) =
        static_cast<::QFileDevice::MemoryMapFlags>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDevice_MemoryMapFlags_PythonToCpp_QFileDevice_MemoryMapFlags_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX]))
        return QFileDevice_MemoryMapFlags_PythonToCpp_QFileDevice_MemoryMapFlags;
    return {};
}
static PyObject *QFileDevice_MemoryMapFlags_CppToPython_QFileDevice_MemoryMapFlags(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDevice::MemoryMapFlags *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFileDevice_PythonToCpp_QFileDevice_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFileDevice_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFileDevice_PythonToCpp_QFileDevice_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFileDevice_TypeF())))
        return QFileDevice_PythonToCpp_QFileDevice_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFileDevice_PTR_CppToPython_QFileDevice(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QFileDevice *>(const_cast<void *>(cppIn)), Sbk_QFileDevice_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFileDevice_SignatureStrings[] = {
    "1:PySide2.QtCore.QFileDevice(self)",
    "0:PySide2.QtCore.QFileDevice(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtCore.QFileDevice.atEnd(self)->bool",
    "PySide2.QtCore.QFileDevice.close(self)",
    "PySide2.QtCore.QFileDevice.error(self)->PySide2.QtCore.QFileDevice.FileError",
    "PySide2.QtCore.QFileDevice.fileName(self)->QString",
    "PySide2.QtCore.QFileDevice.fileTime(self,time:PySide2.QtCore.QFileDevice.FileTime)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileDevice.flush(self)->bool",
    "PySide2.QtCore.QFileDevice.handle(self)->int",
    "PySide2.QtCore.QFileDevice.isSequential(self)->bool",
    "PySide2.QtCore.QFileDevice.map(self,offset:qint64,size:qint64,flags:PySide2.QtCore.QFileDevice.MemoryMapFlags=NoOptions)->uchar*",
    "PySide2.QtCore.QFileDevice.permissions(self)->PySide2.QtCore.QFileDevice.Permissions",
    "PySide2.QtCore.QFileDevice.pos(self)->qint64",
    "PySide2.QtCore.QFileDevice.readData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtCore.QFileDevice.readLineData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtCore.QFileDevice.resize(self,sz:qint64)->bool",
    "PySide2.QtCore.QFileDevice.seek(self,offset:qint64)->bool",
    "PySide2.QtCore.QFileDevice.setFileTime(self,newDate:PySide2.QtCore.QDateTime,fileTime:PySide2.QtCore.QFileDevice.FileTime)->bool",
    "PySide2.QtCore.QFileDevice.setPermissions(self,permissionSpec:PySide2.QtCore.QFileDevice.Permissions)->bool",
    "PySide2.QtCore.QFileDevice.size(self)->qint64",
    "PySide2.QtCore.QFileDevice.unmap(self,address:uchar*)->bool",
    "PySide2.QtCore.QFileDevice.unsetError(self)",
    "PySide2.QtCore.QFileDevice.writeData(self,data:char*,len:qint64)->qint64",
    nullptr}; // Sentinel

void init_QFileDevice(PyObject *module)
{
    _Sbk_QFileDevice_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFileDevice",
        "QFileDevice*",
        &Sbk_QFileDevice_spec,
        &Shiboken::callCppDestructor< ::QFileDevice >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFileDevice_Type);
    InitSignatureStrings(pyType, QFileDevice_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFileDevice_Type), Sbk_QFileDevice_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFileDevice_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFileDevice_TypeF(),
        QFileDevice_PythonToCpp_QFileDevice_PTR,
        is_QFileDevice_PythonToCpp_QFileDevice_PTR_Convertible,
        QFileDevice_PTR_CppToPython_QFileDevice);

    Shiboken::Conversions::registerConverterName(converter, "QFileDevice");
    Shiboken::Conversions::registerConverterName(converter, "QFileDevice*");
    Shiboken::Conversions::registerConverterName(converter, "QFileDevice&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileDevice).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileDeviceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QFileDevice_TypeF(), &Sbk_QFileDevice_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'FileError'.
    SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDevice_TypeF(),
        "FileError",
        "2:PySide2.QtCore.QFileDevice.FileError",
        "QFileDevice::FileError");
    if (!SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "NoError", (long) QFileDevice::FileError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "ReadError", (long) QFileDevice::FileError::ReadError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "WriteError", (long) QFileDevice::FileError::WriteError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "FatalError", (long) QFileDevice::FileError::FatalError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "ResourceError", (long) QFileDevice::FileError::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "OpenError", (long) QFileDevice::FileError::OpenError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "AbortError", (long) QFileDevice::FileError::AbortError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "TimeOutError", (long) QFileDevice::FileError::TimeOutError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "UnspecifiedError", (long) QFileDevice::FileError::UnspecifiedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "RemoveError", (long) QFileDevice::FileError::RemoveError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "RenameError", (long) QFileDevice::FileError::RenameError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "PositionError", (long) QFileDevice::FileError::PositionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "ResizeError", (long) QFileDevice::FileError::ResizeError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "PermissionsError", (long) QFileDevice::FileError::PermissionsError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
        Sbk_QFileDevice_TypeF(), "CopyError", (long) QFileDevice::FileError::CopyError))
        return;
    // Register converter for enum 'QFileDevice::FileError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX],
            QFileDevice_FileError_CppToPython_QFileDevice_FileError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_FileError_PythonToCpp_QFileDevice_FileError,
            is_QFileDevice_FileError_PythonToCpp_QFileDevice_FileError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::FileError");
        Shiboken::Conversions::registerConverterName(converter, "FileError");
    }
    // End of 'FileError' enum.

    // Initialization of enum 'FileTime'.
    SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDevice_TypeF(),
        "FileTime",
        "2:PySide2.QtCore.QFileDevice.FileTime",
        "QFileDevice::FileTime");
    if (!SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX],
        Sbk_QFileDevice_TypeF(), "FileAccessTime", (long) QFileDevice::FileTime::FileAccessTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX],
        Sbk_QFileDevice_TypeF(), "FileBirthTime", (long) QFileDevice::FileTime::FileBirthTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX],
        Sbk_QFileDevice_TypeF(), "FileMetadataChangeTime", (long) QFileDevice::FileTime::FileMetadataChangeTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX],
        Sbk_QFileDevice_TypeF(), "FileModificationTime", (long) QFileDevice::FileTime::FileModificationTime))
        return;
    // Register converter for enum 'QFileDevice::FileTime'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX],
            QFileDevice_FileTime_CppToPython_QFileDevice_FileTime);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_FileTime_PythonToCpp_QFileDevice_FileTime,
            is_QFileDevice_FileTime_PythonToCpp_QFileDevice_FileTime_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::FileTime");
        Shiboken::Conversions::registerConverterName(converter, "FileTime");
    }
    // End of 'FileTime' enum.

    // Initialization of enum 'Permission'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QFileDevice.Permissions", SbkPySide2_QtCore_QFileDevice_Permission_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDevice_TypeF(),
        "Permission",
        "2:PySide2.QtCore.QFileDevice.Permission",
        "QFileDevice::Permission",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ReadOwner", (long) QFileDevice::Permission::ReadOwner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "WriteOwner", (long) QFileDevice::Permission::WriteOwner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ExeOwner", (long) QFileDevice::Permission::ExeOwner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ReadUser", (long) QFileDevice::Permission::ReadUser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "WriteUser", (long) QFileDevice::Permission::WriteUser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ExeUser", (long) QFileDevice::Permission::ExeUser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ReadGroup", (long) QFileDevice::Permission::ReadGroup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "WriteGroup", (long) QFileDevice::Permission::WriteGroup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ExeGroup", (long) QFileDevice::Permission::ExeGroup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ReadOther", (long) QFileDevice::Permission::ReadOther))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "WriteOther", (long) QFileDevice::Permission::WriteOther))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
        Sbk_QFileDevice_TypeF(), "ExeOther", (long) QFileDevice::Permission::ExeOther))
        return;
    // Register converter for enum 'QFileDevice::Permission'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX],
            QFileDevice_Permission_CppToPython_QFileDevice_Permission);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_Permission_PythonToCpp_QFileDevice_Permission,
            is_QFileDevice_Permission_PythonToCpp_QFileDevice_Permission_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_PERMISSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::Permission");
        Shiboken::Conversions::registerConverterName(converter, "Permission");
    }
    // Register converter for flag 'QFlags<QFileDevice::Permission>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX],
            QFlags_QFileDevice_Permission__CppToPython_QFlags_QFileDevice_Permission_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_Permission_PythonToCpp_QFlags_QFileDevice_Permission_,
            is_QFileDevice_Permission_PythonToCpp_QFlags_QFileDevice_Permission__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QFileDevice_Permission__PythonToCpp_QFlags_QFileDevice_Permission_,
            is_QFlags_QFileDevice_Permission__PythonToCpp_QFlags_QFileDevice_Permission__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QFileDevice_Permission_,
            is_number_PythonToCpp_QFlags_QFileDevice_Permission__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::Permissions");
        Shiboken::Conversions::registerConverterName(converter, "Permissions");
    }
    // End of 'Permission' enum/flags.

    // Initialization of enum 'FileHandleFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QFileDevice.FileHandleFlags", SbkPySide2_QtCore_QFileDevice_FileHandleFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDevice_TypeF(),
        "FileHandleFlag",
        "2:PySide2.QtCore.QFileDevice.FileHandleFlag",
        "QFileDevice::FileHandleFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX],
        Sbk_QFileDevice_TypeF(), "AutoCloseHandle", (long) QFileDevice::FileHandleFlag::AutoCloseHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX],
        Sbk_QFileDevice_TypeF(), "DontCloseHandle", (long) QFileDevice::FileHandleFlag::DontCloseHandle))
        return;
    // Register converter for enum 'QFileDevice::FileHandleFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX],
            QFileDevice_FileHandleFlag_CppToPython_QFileDevice_FileHandleFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_FileHandleFlag_PythonToCpp_QFileDevice_FileHandleFlag,
            is_QFileDevice_FileHandleFlag_PythonToCpp_QFileDevice_FileHandleFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILEHANDLEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::FileHandleFlag");
        Shiboken::Conversions::registerConverterName(converter, "FileHandleFlag");
    }
    // Register converter for flag 'QFlags<QFileDevice::FileHandleFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX],
            QFlags_QFileDevice_FileHandleFlag__CppToPython_QFlags_QFileDevice_FileHandleFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_FileHandleFlag_PythonToCpp_QFlags_QFileDevice_FileHandleFlag_,
            is_QFileDevice_FileHandleFlag_PythonToCpp_QFlags_QFileDevice_FileHandleFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QFileDevice_FileHandleFlag__PythonToCpp_QFlags_QFileDevice_FileHandleFlag_,
            is_QFlags_QFileDevice_FileHandleFlag__PythonToCpp_QFlags_QFileDevice_FileHandleFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QFileDevice_FileHandleFlag_,
            is_number_PythonToCpp_QFlags_QFileDevice_FileHandleFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::FileHandleFlags");
        Shiboken::Conversions::registerConverterName(converter, "FileHandleFlags");
    }
    // End of 'FileHandleFlag' enum/flags.

    // Initialization of enum 'MemoryMapFlags'.
    SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDevice_TypeF(),
        "MemoryMapFlags",
        "2:PySide2.QtCore.QFileDevice.MemoryMapFlags",
        "QFileDevice::MemoryMapFlags");
    if (!SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX],
        Sbk_QFileDevice_TypeF(), "NoOptions", (long) QFileDevice::MemoryMapFlags::NoOptions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX],
        Sbk_QFileDevice_TypeF(), "MapPrivateOption", (long) QFileDevice::MemoryMapFlags::MapPrivateOption))
        return;
    // Register converter for enum 'QFileDevice::MemoryMapFlags'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX],
            QFileDevice_MemoryMapFlags_CppToPython_QFileDevice_MemoryMapFlags);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDevice_MemoryMapFlags_PythonToCpp_QFileDevice_MemoryMapFlags,
            is_QFileDevice_MemoryMapFlags_PythonToCpp_QFileDevice_MemoryMapFlags_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_MEMORYMAPFLAGS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDevice::MemoryMapFlags");
        Shiboken::Conversions::registerConverterName(converter, "MemoryMapFlags");
    }
    // End of 'MemoryMapFlags' enum.

    PySide::Signal::registerSignals(Sbk_QFileDevice_TypeF(), &::QFileDevice::staticMetaObject);
    qRegisterMetaType< ::QFileDevice::FileError >("QFileDevice::FileError");
    qRegisterMetaType< ::QFileDevice::FileTime >("QFileDevice::FileTime");
    qRegisterMetaType< ::QFileDevice::Permission >("QFileDevice::Permission");
    qRegisterMetaType< ::QFileDevice::Permissions >("QFileDevice::Permissions");
    qRegisterMetaType< ::QFileDevice::FileHandleFlag >("QFileDevice::FileHandleFlag");
    qRegisterMetaType< ::QFileDevice::FileHandleFlags >("QFileDevice::FileHandleFlags");
    qRegisterMetaType< ::QFileDevice::MemoryMapFlags >("QFileDevice::MemoryMapFlags");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QFileDevice_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QFileDevice_TypeF(), &::QFileDevice::staticMetaObject, sizeof(QFileDeviceWrapper));
}
