/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qgenericargument_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGenericArgument_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGenericArgument >()))
        return -1;

    ::QGenericArgument *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QGenericArgument.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGenericArgument_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QGenericArgument", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGenericArgument::QGenericArgument(QGenericArgument)
    // 1: QGenericArgument::QGenericArgument(const char*,const void*)
    if (numArgs == 0) {
        overloadId = 1; // QGenericArgument(const char*,const void*)
    } else if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QGenericArgument(const char*,const void*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
            overloadId = 1; // QGenericArgument(const char*,const void*)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGenericArgument(QGenericArgument)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGenericArgument_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGenericArgument(const QGenericArgument & QGenericArgument)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGenericArgument_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGenericArgument cppArg0_local;
            ::QGenericArgument *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGenericArgument(QGenericArgument)
                cptr = new ::QGenericArgument(*cppArg0);
            }
            break;
        }
        case 1: // QGenericArgument(const char * aName, const void * aData)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_aName = Shiboken::String::createStaticString("aName");
                if (PyDict_Contains(kwds, key_aName)) {
                    value = PyDict_GetItem(kwds, key_aName);
                    if (value && pyArgs[0]) {
                        errInfo = key_aName;
                        Py_INCREF(errInfo);
                        goto Sbk_QGenericArgument_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0]))))
                            goto Sbk_QGenericArgument_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aName);
                }
                static PyObject *const key_aData = Shiboken::String::createStaticString("aData");
                if (PyDict_Contains(kwds, key_aData)) {
                    value = PyDict_GetItem(kwds, key_aData);
                    if (value && pyArgs[1]) {
                        errInfo = key_aData;
                        Py_INCREF(errInfo);
                        goto Sbk_QGenericArgument_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1]))))
                            goto Sbk_QGenericArgument_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aData);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGenericArgument_Init_TypeError;
                }
            }
            const char* cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            void* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGenericArgument(const char*,const void*)
                cptr = new ::QGenericArgument(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGenericArgument >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGenericArgument_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGenericArgument_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGenericArgumentFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGenericArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QGenericArgument.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            void * cppResult = const_cast<const ::QGenericArgument *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGenericArgumentFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGenericArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QGenericArgument.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            const char * cppResult = const_cast<const ::QGenericArgument *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGenericArgument___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGenericArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGenericArgument_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGenericArgument_methods[] = {
    {"data", reinterpret_cast<PyCFunction>(Sbk_QGenericArgumentFunc_data), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QGenericArgumentFunc_name), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGenericArgument___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QGenericArgument_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGenericArgument_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGenericArgument_Type = nullptr;
static SbkObjectType *Sbk_QGenericArgument_TypeF(void)
{
    return _Sbk_QGenericArgument_Type;
}

static PyType_Slot Sbk_QGenericArgument_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGenericArgument_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGenericArgument_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGenericArgument_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGenericArgument_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGenericArgument_spec = {
    "2:PySide2.QtCore.QGenericArgument",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGenericArgument_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGenericArgument_PythonToCpp_QGenericArgument_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGenericArgument_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGenericArgument_PythonToCpp_QGenericArgument_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGenericArgument_TypeF())))
        return QGenericArgument_PythonToCpp_QGenericArgument_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGenericArgument_PTR_CppToPython_QGenericArgument(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGenericArgument *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGenericArgument_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGenericArgument_COPY_CppToPython_QGenericArgument(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGenericArgument_TypeF(), new ::QGenericArgument(*reinterpret_cast<const ::QGenericArgument *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGenericArgument_PythonToCpp_QGenericArgument_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGenericArgument *>(cppOut) = *reinterpret_cast< ::QGenericArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGenericArgument_PythonToCpp_QGenericArgument_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGenericArgument_TypeF())))
        return QGenericArgument_PythonToCpp_QGenericArgument_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGenericArgument_SignatureStrings[] = {
    "1:PySide2.QtCore.QGenericArgument(self,QGenericArgument:PySide2.QtCore.QGenericArgument)",
    "0:PySide2.QtCore.QGenericArgument(self,aName:char*=nullptr,aData:void=nullptr)",
    "PySide2.QtCore.QGenericArgument.data(self)->void",
    "PySide2.QtCore.QGenericArgument.name(self)->char*",
    "PySide2.QtCore.QGenericArgument.__copy__()",
    nullptr}; // Sentinel

void init_QGenericArgument(PyObject *module)
{
    _Sbk_QGenericArgument_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGenericArgument",
        "QGenericArgument",
        &Sbk_QGenericArgument_spec,
        &Shiboken::callCppDestructor< ::QGenericArgument >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGenericArgument_Type);
    InitSignatureStrings(pyType, QGenericArgument_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGenericArgument_Type), Sbk_QGenericArgument_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGenericArgument_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGenericArgument_TypeF(),
        QGenericArgument_PythonToCpp_QGenericArgument_PTR,
        is_QGenericArgument_PythonToCpp_QGenericArgument_PTR_Convertible,
        QGenericArgument_PTR_CppToPython_QGenericArgument,
        QGenericArgument_COPY_CppToPython_QGenericArgument);

    Shiboken::Conversions::registerConverterName(converter, "QGenericArgument");
    Shiboken::Conversions::registerConverterName(converter, "QGenericArgument*");
    Shiboken::Conversions::registerConverterName(converter, "QGenericArgument&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGenericArgument).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGenericArgument_PythonToCpp_QGenericArgument_COPY,
        is_QGenericArgument_PythonToCpp_QGenericArgument_COPY_Convertible);

}
