/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qiodevice_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QIODeviceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QIODeviceWrapper::QIODeviceWrapper() : QIODevice()
{
    resetPyMethodCache();
    // ... middle
}

QIODeviceWrapper::QIODeviceWrapper(::QObject * parent) : QIODevice(parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QIODeviceWrapper::atEnd() const
{
    if (m_PyMethodCache[0])
        return this->::QIODevice::atEnd();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "atEnd";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QIODevice::atEnd();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.atEnd", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QIODeviceWrapper::bytesAvailable() const
{
    if (m_PyMethodCache[1])
        return this->::QIODevice::bytesAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QIODevice::bytesAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.bytesAvailable", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QIODeviceWrapper::bytesToWrite() const
{
    if (m_PyMethodCache[2])
        return this->::QIODevice::bytesToWrite();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesToWrite";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QIODevice::bytesToWrite();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.bytesToWrite", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QIODeviceWrapper::canReadLine() const
{
    if (m_PyMethodCache[3])
        return this->::QIODevice::canReadLine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canReadLine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QIODevice::canReadLine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.canReadLine", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QIODeviceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QIODeviceWrapper::close()
{
    if (m_PyMethodCache[5]) {
        return this->::QIODevice::close();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QIODevice::close();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QIODeviceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QIODeviceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QIODeviceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QIODeviceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QIODeviceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QIODeviceWrapper::isSequential() const
{
    if (m_PyMethodCache[11])
        return this->::QIODevice::isSequential();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSequential";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QIODevice::isSequential();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.isSequential", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QIODeviceWrapper::open(::QFlags<QIODevice::OpenModeFlag> mode)
{
    if (m_PyMethodCache[13])
        return this->::QIODevice::open(mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QIODeviceWrapper::pos() const
{
    if (m_PyMethodCache[14])
        return this->::QIODevice::pos();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pos";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QIODevice::pos();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.pos", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QIODeviceWrapper::readData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[15]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.readData()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.readData()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

qint64 QIODeviceWrapper::readLineData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[16]) {
        return this->::QIODevice::readLineData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readLineData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QIODevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

bool QIODeviceWrapper::reset()
{
    if (m_PyMethodCache[17])
        return this->::QIODevice::reset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QIODevice::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.reset", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QIODeviceWrapper::seek(qint64 pos)
{
    if (m_PyMethodCache[18])
        return this->::QIODevice::seek(pos);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "seek";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    pos
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.seek", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QIODeviceWrapper::size() const
{
    if (m_PyMethodCache[19])
        return this->::QIODevice::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QIODevice::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.size", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QIODeviceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[20]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QIODeviceWrapper::waitForBytesWritten(int msecs)
{
    if (m_PyMethodCache[21])
        return this->::QIODevice::waitForBytesWritten(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForBytesWritten";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QIODevice::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.waitForBytesWritten", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QIODeviceWrapper::waitForReadyRead(int msecs)
{
    if (m_PyMethodCache[22])
        return this->::QIODevice::waitForReadyRead(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForReadyRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QIODevice::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.waitForReadyRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QIODeviceWrapper::writeData(const char * data, qint64 len)
{
    if (m_PyMethodCache[23]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.writeData()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "writeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.writeData()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    len
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QIODevice.writeData", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QIODeviceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QIODevice::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QIODeviceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QIODevice::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QIODeviceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QIODeviceWrapper *>(this));
        return QIODevice::qt_metacast(_clname);
}

QIODeviceWrapper::~QIODeviceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QIODevice_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QIODevice' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QIODevice >()))
        return -1;

    ::QIODeviceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QIODevice", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QIODevice::QIODevice()
    // 1: QIODevice::QIODevice(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QIODevice()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QIODevice(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODevice_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QIODevice()
        {

            if (!PyErr_Occurred()) {
                // QIODevice()
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QIODeviceWrapper();
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QIODeviceWrapper();
                }

            }
            break;
        }
        case 1: // QIODevice(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QIODevice(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QIODeviceWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QIODeviceWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QIODevice >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QIODevice_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QIODevice_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QIODevice_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QIODeviceFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::atEnd()
                : const_cast<const ::QIODevice *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_bytesAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.bytesAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesAvailable()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::bytesAvailable()
                : const_cast<const ::QIODevice *>(cppSelf)->bytesAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_bytesToWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.bytesToWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesToWrite()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::bytesToWrite()
                : const_cast<const ::QIODevice *>(cppSelf)->bytesToWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_canReadLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.canReadLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canReadLine()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::canReadLine()
                : const_cast<const ::QIODevice *>(cppSelf)->canReadLine();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QIODevice::close()
                : cppSelf->close();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QIODeviceFunc_commitTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.commitTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // commitTransaction()
            cppSelf->commitTransaction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QIODeviceFunc_currentReadChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.currentReadChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentReadChannel()const
            int cppResult = const_cast<const ::QIODevice *>(cppSelf)->currentReadChannel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_currentWriteChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.currentWriteChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentWriteChannel()const
            int cppResult = const_cast<const ::QIODevice *>(cppSelf)->currentWriteChannel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QIODevice *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_getChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.getChar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getChar(char*)
            // Begin code injection
            // TEMPLATE - fix_char* - START
            char val_{};
            bool retval_ = cppSelf->getChar(&val_);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<char>(), &val_));
            // TEMPLATE - fix_char* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_isOpen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.isOpen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpen()const
            bool cppResult = const_cast<const ::QIODevice *>(cppSelf)->isOpen();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_isReadable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.isReadable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadable()const
            bool cppResult = const_cast<const ::QIODevice *>(cppSelf)->isReadable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_isSequential(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.isSequential";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSequential()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::isSequential()
                : const_cast<const ::QIODevice *>(cppSelf)->isSequential();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_isTextModeEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.isTextModeEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTextModeEnabled()const
            bool cppResult = const_cast<const ::QIODevice *>(cppSelf)->isTextModeEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_isTransactionStarted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.isTransactionStarted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTransactionStarted()const
            bool cppResult = const_cast<const ::QIODevice *>(cppSelf)->isTransactionStarted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_isWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.isWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWritable()const
            bool cppResult = const_cast<const ::QIODevice *>(cppSelf)->isWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_open(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::open(QFlags<QIODevice::OpenModeFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // open(QFlags<QIODevice::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_open_TypeError;

    // Call function/method
    {
        ::QFlags<QIODevice::OpenModeFlag> cppArg0 = QFlags<QIODevice::OpenModeFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // open(QFlags<QIODevice::OpenModeFlag>)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QIODevice::open(cppArg0)
                : cppSelf->open(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_openMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.openMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // openMode()const
            QFlags<QIODevice::OpenModeFlag> cppResult = const_cast<const ::QIODevice *>(cppSelf)->openMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_peek(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.peek";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::peek(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // peek(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_peek_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // peek(qint64)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QByteArray cppResult = cppSelf->peek(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_peek_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::pos()
                : const_cast<const ::QIODevice *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_putChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.putChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::putChar(char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // putChar(char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_putChar_TypeError;

    // Call function/method
    {
        char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // putChar(char)
            bool cppResult = cppSelf->putChar(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_putChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_read(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::read(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // read(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_read_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // read(qint64)
            QByteArray cppResult = cppSelf->read(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_readAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.readAll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readAll()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QByteArray cppResult = cppSelf->readAll();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_readChannelCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.readChannelCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readChannelCount()const
            int cppResult = const_cast<const ::QIODevice *>(cppSelf)->readChannelCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_readData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.readData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_readData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readData(char*,qint64)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.readData()' not implemented.");
                return {};
            }
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            cppSelf->readData(ba.data(), int(cppArg0));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_readData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_readLine(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.readLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIODeviceFunc_readLine_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:readLine", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::readLine(qint64)
    if (numArgs == 0) {
        overloadId = 0; // readLine(qint64)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 0; // readLine(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_readLine_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_maxlen = Shiboken::String::createStaticString("maxlen");
            if (PyDict_Contains(kwds, key_maxlen)) {
                value = PyDict_GetItem(kwds, key_maxlen);
                if (value && pyArgs[0]) {
                    errInfo = key_maxlen;
                    Py_INCREF(errInfo);
                    goto Sbk_QIODeviceFunc_readLine_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0]))))
                        goto Sbk_QIODeviceFunc_readLine_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_maxlen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QIODeviceFunc_readLine_TypeError;
            }
        }
        qint64 cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // readLine(qint64)
            QByteArray cppResult = cppSelf->readLine(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_readLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_readLineData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.readLineData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readLineData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readLineData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_readLineData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readLineData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QIODevice::readLineData(ba.data(), int(cppArg0)) : cppSelf->readLineData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_readLineData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QIODevice::reset()
                : cppSelf->reset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_rollbackTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.rollbackTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rollbackTransaction()
            cppSelf->rollbackTransaction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QIODeviceFunc_seek(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.seek";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::seek(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // seek(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_seek_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // seek(qint64)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QIODevice::seek(cppArg0)
                : cppSelf->seek(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_seek_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_setCurrentReadChannel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.setCurrentReadChannel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::setCurrentReadChannel(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentReadChannel(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_setCurrentReadChannel_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentReadChannel(int)
            cppSelf->setCurrentReadChannel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIODeviceFunc_setCurrentReadChannel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_setCurrentWriteChannel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.setCurrentWriteChannel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::setCurrentWriteChannel(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentWriteChannel(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_setCurrentWriteChannel_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentWriteChannel(int)
            cppSelf->setCurrentWriteChannel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIODeviceFunc_setCurrentWriteChannel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_setErrorString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.setErrorString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::setErrorString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setErrorString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_setErrorString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setErrorString(QString)
            cppSelf->setErrorString(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIODeviceFunc_setErrorString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_setOpenMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.setOpenMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::setOpenMode(QFlags<QIODevice::OpenModeFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOpenMode(QFlags<QIODevice::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_setOpenMode_TypeError;

    // Call function/method
    {
        ::QFlags<QIODevice::OpenModeFlag> cppArg0 = QFlags<QIODevice::OpenModeFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpenMode(QFlags<QIODevice::OpenModeFlag>)
            cppSelf->setOpenMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIODeviceFunc_setOpenMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_setTextModeEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.setTextModeEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::setTextModeEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTextModeEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_setTextModeEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextModeEnabled(bool)
            cppSelf->setTextModeEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIODeviceFunc_setTextModeEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QIODevice *>(cppSelf)->::QIODevice::size()
                : const_cast<const ::QIODevice *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_skip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.skip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::skip(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // skip(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_skip_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // skip(qint64)
            qint64 cppResult = cppSelf->skip(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_skip_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_startTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.startTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startTransaction()
            cppSelf->startTransaction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QIODeviceFunc_ungetChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.ungetChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::ungetChar(char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // ungetChar(char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_ungetChar_TypeError;

    // Call function/method
    {
        char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // ungetChar(char)
            cppSelf->ungetChar(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIODeviceFunc_ungetChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_waitForBytesWritten(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.waitForBytesWritten";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::waitForBytesWritten(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // waitForBytesWritten(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_waitForBytesWritten_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForBytesWritten(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QIODevice::waitForBytesWritten(cppArg0)
                : cppSelf->waitForBytesWritten(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_waitForBytesWritten_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_waitForReadyRead(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.waitForReadyRead";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::waitForReadyRead(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // waitForReadyRead(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_waitForReadyRead_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForReadyRead(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QIODevice::waitForReadyRead(cppArg0)
                : cppSelf->waitForReadyRead(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_waitForReadyRead_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_write(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::write(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // write(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_write_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // write(QByteArray)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            qint64 cppResult = cppSelf->write(*cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIODeviceFunc_writeChannelCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.writeChannelCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // writeChannelCount()const
            int cppResult = const_cast<const ::QIODevice *>(cppSelf)->writeChannelCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIODeviceFunc_writeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QIODevice.writeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::writeData(const char*,qint64)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // writeData(const char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIODeviceFunc_writeData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // writeData(const char*,qint64)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.writeData()' not implemented.");
                return {};
            }
            qint64 cppResult = cppSelf->writeData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIODeviceFunc_writeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QIODevice_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QIODevice_methods[] = {
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_atEnd), METH_NOARGS},
    {"bytesAvailable", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_bytesAvailable), METH_NOARGS},
    {"bytesToWrite", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_bytesToWrite), METH_NOARGS},
    {"canReadLine", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_canReadLine), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_close), METH_NOARGS},
    {"commitTransaction", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_commitTransaction), METH_NOARGS},
    {"currentReadChannel", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_currentReadChannel), METH_NOARGS},
    {"currentWriteChannel", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_currentWriteChannel), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_errorString), METH_NOARGS},
    {"getChar", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_getChar), METH_NOARGS},
    {"isOpen", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_isOpen), METH_NOARGS},
    {"isReadable", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_isReadable), METH_NOARGS},
    {"isSequential", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_isSequential), METH_NOARGS},
    {"isTextModeEnabled", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_isTextModeEnabled), METH_NOARGS},
    {"isTransactionStarted", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_isTransactionStarted), METH_NOARGS},
    {"isWritable", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_isWritable), METH_NOARGS},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_open), METH_O},
    {"openMode", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_openMode), METH_NOARGS},
    {"peek", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_peek), METH_O},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_pos), METH_NOARGS},
    {"putChar", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_putChar), METH_O},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_read), METH_O},
    {"readAll", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_readAll), METH_NOARGS},
    {"readChannelCount", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_readChannelCount), METH_NOARGS},
    {"readData", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_readData), METH_O},
    {"readLine", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_readLine), METH_VARARGS|METH_KEYWORDS},
    {"readLineData", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_readLineData), METH_O},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_reset), METH_NOARGS},
    {"rollbackTransaction", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_rollbackTransaction), METH_NOARGS},
    {"seek", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_seek), METH_O},
    {"setCurrentReadChannel", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_setCurrentReadChannel), METH_O},
    {"setCurrentWriteChannel", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_setCurrentWriteChannel), METH_O},
    {"setErrorString", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_setErrorString), METH_O},
    {"setOpenMode", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_setOpenMode), METH_O},
    {"setTextModeEnabled", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_setTextModeEnabled), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_size), METH_NOARGS},
    {"skip", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_skip), METH_O},
    {"startTransaction", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_startTransaction), METH_NOARGS},
    {"ungetChar", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_ungetChar), METH_O},
    {"waitForBytesWritten", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_waitForBytesWritten), METH_O},
    {"waitForReadyRead", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_waitForReadyRead), METH_O},
    {"write", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_write), METH_O},
    {"writeChannelCount", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_writeChannelCount), METH_NOARGS},
    {"writeData", reinterpret_cast<PyCFunction>(Sbk_QIODeviceFunc_writeData), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QIODevice_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QIODeviceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QIODevice_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QIODevice_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QIODevice_Type = nullptr;
static SbkObjectType *Sbk_QIODevice_TypeF(void)
{
    return _Sbk_QIODevice_Type;
}

static PyType_Slot Sbk_QIODevice_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QIODevice_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QIODevice_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QIODevice_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QIODevice_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QIODevice_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QIODevice_spec = {
    "2:PySide2.QtCore.QIODevice",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QIODevice_slots
};

} //extern "C"

static void *Sbk_QIODevice_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QIODevice *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtCore_QIODevice_OpenModeFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QIODevice::OpenMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QIODevice::OpenMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QIODevice::OpenMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QIODevice::OpenMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QIODevice::OpenMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QIODevice_OpenModeFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QIODevice::OpenMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QIODevice::OpenMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QIODevice::OpenMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QIODevice::OpenMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QIODevice::OpenMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QIODevice_OpenModeFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QIODevice::OpenMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QIODevice::OpenMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QIODevice::OpenMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QIODevice::OpenMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QIODevice::OpenMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QIODevice_OpenModeFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QIODevice::OpenMode cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, self, &cppSelf);
    ::QIODevice::OpenMode cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QIODevice_OpenModeFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QIODevice_OpenModeFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QIODevice_OpenModeFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QIODevice_OpenModeFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QIODevice_OpenModeFlag_PythonToCpp_QIODevice_OpenModeFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QIODevice::OpenModeFlag *>(cppOut) =
        static_cast<::QIODevice::OpenModeFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QIODevice_OpenModeFlag_PythonToCpp_QIODevice_OpenModeFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX]))
        return QIODevice_OpenModeFlag_PythonToCpp_QIODevice_OpenModeFlag;
    return {};
}
static PyObject *QIODevice_OpenModeFlag_CppToPython_QIODevice_OpenModeFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QIODevice::OpenModeFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX], castCppIn);

}

static void QFlags_QIODevice_OpenModeFlag__PythonToCpp_QFlags_QIODevice_OpenModeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QIODevice::OpenModeFlag> *>(cppOut) =
        ::QFlags<QIODevice::OpenModeFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QIODevice_OpenModeFlag__PythonToCpp_QFlags_QIODevice_OpenModeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX]))
        return QFlags_QIODevice_OpenModeFlag__PythonToCpp_QFlags_QIODevice_OpenModeFlag_;
    return {};
}
static PyObject *QFlags_QIODevice_OpenModeFlag__CppToPython_QFlags_QIODevice_OpenModeFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QIODevice::OpenModeFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX]));

}

static void QIODevice_OpenModeFlag_PythonToCpp_QFlags_QIODevice_OpenModeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QIODevice::OpenModeFlag> *>(cppOut) =
        ::QFlags<QIODevice::OpenModeFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QIODevice_OpenModeFlag_PythonToCpp_QFlags_QIODevice_OpenModeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX]))
        return QIODevice_OpenModeFlag_PythonToCpp_QFlags_QIODevice_OpenModeFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QIODevice_OpenModeFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QIODevice::OpenModeFlag> *>(cppOut) =
        ::QFlags<QIODevice::OpenModeFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QIODevice_OpenModeFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QIODevice_OpenModeFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QIODevice_PythonToCpp_QIODevice_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QIODevice_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QIODevice_PythonToCpp_QIODevice_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QIODevice_TypeF())))
        return QIODevice_PythonToCpp_QIODevice_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QIODevice_PTR_CppToPython_QIODevice(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QIODevice *>(const_cast<void *>(cppIn)), Sbk_QIODevice_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QIODevice_SignatureStrings[] = {
    "1:PySide2.QtCore.QIODevice(self)",
    "0:PySide2.QtCore.QIODevice(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtCore.QIODevice.atEnd(self)->bool",
    "PySide2.QtCore.QIODevice.bytesAvailable(self)->qint64",
    "PySide2.QtCore.QIODevice.bytesToWrite(self)->qint64",
    "PySide2.QtCore.QIODevice.canReadLine(self)->bool",
    "PySide2.QtCore.QIODevice.close(self)",
    "PySide2.QtCore.QIODevice.commitTransaction(self)",
    "PySide2.QtCore.QIODevice.currentReadChannel(self)->int",
    "PySide2.QtCore.QIODevice.currentWriteChannel(self)->int",
    "PySide2.QtCore.QIODevice.errorString(self)->QString",
    "PySide2.QtCore.QIODevice.getChar(self,c:char*)->bool",
    "PySide2.QtCore.QIODevice.isOpen(self)->bool",
    "PySide2.QtCore.QIODevice.isReadable(self)->bool",
    "PySide2.QtCore.QIODevice.isSequential(self)->bool",
    "PySide2.QtCore.QIODevice.isTextModeEnabled(self)->bool",
    "PySide2.QtCore.QIODevice.isTransactionStarted(self)->bool",
    "PySide2.QtCore.QIODevice.isWritable(self)->bool",
    "PySide2.QtCore.QIODevice.open(self,mode:PySide2.QtCore.QIODevice.OpenMode)->bool",
    "PySide2.QtCore.QIODevice.openMode(self)->PySide2.QtCore.QIODevice.OpenMode",
    "PySide2.QtCore.QIODevice.peek(self,maxlen:qint64)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QIODevice.pos(self)->qint64",
    "PySide2.QtCore.QIODevice.putChar(self,c:char)->bool",
    "PySide2.QtCore.QIODevice.read(self,maxlen:qint64)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QIODevice.readAll(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QIODevice.readChannelCount(self)->int",
    "PySide2.QtCore.QIODevice.readData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtCore.QIODevice.readLine(self,maxlen:qint64=0)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QIODevice.readLineData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtCore.QIODevice.reset(self)->bool",
    "PySide2.QtCore.QIODevice.rollbackTransaction(self)",
    "PySide2.QtCore.QIODevice.seek(self,pos:qint64)->bool",
    "PySide2.QtCore.QIODevice.setCurrentReadChannel(self,channel:int)",
    "PySide2.QtCore.QIODevice.setCurrentWriteChannel(self,channel:int)",
    "PySide2.QtCore.QIODevice.setErrorString(self,errorString:QString)",
    "PySide2.QtCore.QIODevice.setOpenMode(self,openMode:PySide2.QtCore.QIODevice.OpenMode)",
    "PySide2.QtCore.QIODevice.setTextModeEnabled(self,enabled:bool)",
    "PySide2.QtCore.QIODevice.size(self)->qint64",
    "PySide2.QtCore.QIODevice.skip(self,maxSize:qint64)->qint64",
    "PySide2.QtCore.QIODevice.startTransaction(self)",
    "PySide2.QtCore.QIODevice.ungetChar(self,c:char)",
    "PySide2.QtCore.QIODevice.waitForBytesWritten(self,msecs:int)->bool",
    "PySide2.QtCore.QIODevice.waitForReadyRead(self,msecs:int)->bool",
    "PySide2.QtCore.QIODevice.write(self,data:PySide2.QtCore.QByteArray)->qint64",
    "PySide2.QtCore.QIODevice.writeChannelCount(self)->int",
    "PySide2.QtCore.QIODevice.writeData(self,data:char*,len:qint64)->qint64",
    nullptr}; // Sentinel

void init_QIODevice(PyObject *module)
{
    _Sbk_QIODevice_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QIODevice",
        "QIODevice*",
        &Sbk_QIODevice_spec,
        &Shiboken::callCppDestructor< ::QIODevice >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QIODevice_Type);
    InitSignatureStrings(pyType, QIODevice_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QIODevice_Type), Sbk_QIODevice_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QIODevice_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QIODevice_TypeF(),
        QIODevice_PythonToCpp_QIODevice_PTR,
        is_QIODevice_PythonToCpp_QIODevice_PTR_Convertible,
        QIODevice_PTR_CppToPython_QIODevice);

    Shiboken::Conversions::registerConverterName(converter, "QIODevice");
    Shiboken::Conversions::registerConverterName(converter, "QIODevice*");
    Shiboken::Conversions::registerConverterName(converter, "QIODevice&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QIODevice).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QIODeviceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QIODevice_TypeF(), &Sbk_QIODevice_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'OpenModeFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QIODevice.OpenMode", SbkPySide2_QtCore_QIODevice_OpenModeFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QIODevice_TypeF(),
        "OpenModeFlag",
        "2:PySide2.QtCore.QIODevice.OpenModeFlag",
        "QIODevice::OpenModeFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "NotOpen", (long) QIODevice::OpenModeFlag::NotOpen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "ReadOnly", (long) QIODevice::OpenModeFlag::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "WriteOnly", (long) QIODevice::OpenModeFlag::WriteOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "ReadWrite", (long) QIODevice::OpenModeFlag::ReadWrite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "Append", (long) QIODevice::OpenModeFlag::Append))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "Truncate", (long) QIODevice::OpenModeFlag::Truncate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "Text", (long) QIODevice::OpenModeFlag::Text))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "Unbuffered", (long) QIODevice::OpenModeFlag::Unbuffered))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "NewOnly", (long) QIODevice::OpenModeFlag::NewOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
        Sbk_QIODevice_TypeF(), "ExistingOnly", (long) QIODevice::OpenModeFlag::ExistingOnly))
        return;
    // Register converter for enum 'QIODevice::OpenModeFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX],
            QIODevice_OpenModeFlag_CppToPython_QIODevice_OpenModeFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QIODevice_OpenModeFlag_PythonToCpp_QIODevice_OpenModeFlag,
            is_QIODevice_OpenModeFlag_PythonToCpp_QIODevice_OpenModeFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QIODevice::OpenModeFlag");
        Shiboken::Conversions::registerConverterName(converter, "OpenModeFlag");
    }
    // Register converter for flag 'QFlags<QIODevice::OpenModeFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX],
            QFlags_QIODevice_OpenModeFlag__CppToPython_QFlags_QIODevice_OpenModeFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QIODevice_OpenModeFlag_PythonToCpp_QFlags_QIODevice_OpenModeFlag_,
            is_QIODevice_OpenModeFlag_PythonToCpp_QFlags_QIODevice_OpenModeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QIODevice_OpenModeFlag__PythonToCpp_QFlags_QIODevice_OpenModeFlag_,
            is_QFlags_QIODevice_OpenModeFlag__PythonToCpp_QFlags_QIODevice_OpenModeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QIODevice_OpenModeFlag_,
            is_number_PythonToCpp_QFlags_QIODevice_OpenModeFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QIODevice::OpenMode");
        Shiboken::Conversions::registerConverterName(converter, "OpenMode");
    }
    // End of 'OpenModeFlag' enum/flags.

    PySide::Signal::registerSignals(Sbk_QIODevice_TypeF(), &::QIODevice::staticMetaObject);
    qRegisterMetaType< ::QIODevice::OpenModeFlag >("QIODevice::OpenModeFlag");
    qRegisterMetaType< ::QIODevice::OpenMode >("QIODevice::OpenMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QIODevice_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QIODevice_TypeF(), &::QIODevice::staticMetaObject, sizeof(QIODeviceWrapper));
}
