/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qlinef_wrapper.h"

// inner classes

// Extra includes
#include <qline.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLineF_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLineF >()))
        return -1;

    ::QLineF *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto Sbk_QLineF_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QLineF", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QLineF::QLineF()
    // 1: QLineF::QLineF(QLine)
    // 2: QLineF::QLineF(QLineF)
    // 3: QLineF::QLineF(QPointF,QPointF)
    // 4: QLineF::QLineF(qreal,qreal,qreal,qreal)
    if (numArgs == 0) {
        overloadId = 0; // QLineF()
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 4; // QLineF(qreal,qreal,qreal,qreal)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 3; // QLineF(QPointF,QPointF)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QLineF(QLine)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QLineF(QLineF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineF_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QLineF()
        {

            if (!PyErr_Occurred()) {
                // QLineF()
                cptr = new ::QLineF();
            }
            break;
        }
        case 1: // QLineF(const QLine & line)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QLine cppArg0_local;
            ::QLine *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QLineF(QLine)
                cptr = new ::QLineF(*cppArg0);
            }
            break;
        }
        case 2: // QLineF(const QLineF & QLineF)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QLineF cppArg0_local;
            ::QLineF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QLineF(QLineF)
                cptr = new ::QLineF(*cppArg0);
            }
            break;
        }
        case 3: // QLineF(const QPointF & pt1, const QPointF & pt2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QLineF(QPointF,QPointF)
                cptr = new ::QLineF(*cppArg0, *cppArg1);
            }
            break;
        }
        case 4: // QLineF(qreal x1, qreal y1, qreal x2, qreal y2)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QLineF(qreal,qreal,qreal,qreal)
                cptr = new ::QLineF(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLineF >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QLineF_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QLineF_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QLineFFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(dddd))", PyObject_Type(self), cppSelf->x1(), cppSelf->y1(), cppSelf->x2(), cppSelf->y2());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%f, %f, %f, %f)",
                Py_TYPE(self)->tp_name, cppSelf->x1(), cppSelf->y1(), cppSelf->x2(), cppSelf->y2());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_angle(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.angle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "angle", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QLineF::angle()const
    // 1: QLineF::angle(QLineF)const
    if (numArgs == 0) {
        overloadId = 0; // angle()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // angle(QLineF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_angle_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // angle() const
        {

            if (!PyErr_Occurred()) {
                // angle()const
                qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->angle();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
        case 1: // angle(const QLineF & l) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLineF cppArg0_local;
            ::QLineF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // angle(QLineF)const
                qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->angle(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QLineF.angle(const QLineF & l) const is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_angle_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_angleTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.angleTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::angleTo(QLineF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArg)))) {
        overloadId = 0; // angleTo(QLineF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_angleTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLineF cppArg0_local;
        ::QLineF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // angleTo(QLineF)const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->angleTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_angleTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_center(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.center";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // center()const
            QPointF cppResult = const_cast<const ::QLineF *>(cppSelf)->center();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_dx(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.dx";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dx()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->dx();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_dy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.dy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dy()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->dy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_fromPolar(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.fromPolar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "fromPolar", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QLineF::fromPolar(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // fromPolar(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_fromPolar_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromPolar(qreal,qreal)
            QLineF cppResult = ::QLineF::fromPolar(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_fromPolar_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_intersect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.intersect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::intersect(QLineF,QPointF*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArg)))) {
        overloadId = 0; // intersect(QLineF,QPointF*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_intersect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLineF cppArg0_local;
        ::QLineF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // intersect(QLineF,QPointF*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qlinef-intersect)]
            QPointF p;
            ::QLineF::IntersectType retval = cppSelf->intersect(*cppArg0, &p);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX])->converter, &retval));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &p));
            // END of custom code block [file: ../glue/qtcore.cpp (qlinef-intersect)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_intersect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_intersects(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.intersects";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "intersects", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLineF::intersects(QLineF,QPointF*)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // intersects(QLineF,QPointF*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_intersects_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLineF cppArg0_local;
        ::QLineF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // intersects(QLineF,QPointF*)const
            QLineF::IntersectType cppResult = const_cast<const ::QLineF *>(cppSelf)->intersects(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_intersects_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QLineF *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_normalVector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.normalVector";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalVector()const
            QLineF cppResult = const_cast<const ::QLineF *>(cppSelf)->normalVector();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_p1(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.p1";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // p1()const
            QPointF cppResult = const_cast<const ::QLineF *>(cppSelf)->p1();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_p2(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.p2";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // p2()const
            QPointF cppResult = const_cast<const ::QLineF *>(cppSelf)->p2();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_pointAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.pointAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::pointAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // pointAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_pointAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // pointAt(qreal)const
            QPointF cppResult = const_cast<const ::QLineF *>(cppSelf)->pointAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_pointAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_setAngle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.setAngle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::setAngle(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setAngle(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_setAngle_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAngle(qreal)
            cppSelf->setAngle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_setAngle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_setLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.setLength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::setLength(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLength(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_setLength_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLength(qreal)
            cppSelf->setLength(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_setLength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_setLine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.setLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setLine", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QLineF::setLine(qreal,qreal,qreal,qreal)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 0; // setLine(qreal,qreal,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_setLine_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setLine(qreal,qreal,qreal,qreal)
            cppSelf->setLine(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_setLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_setP1(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.setP1";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::setP1(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setP1(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_setP1_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setP1(QPointF)
            cppSelf->setP1(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_setP1_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_setP2(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.setP2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLineF::setP2(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setP2(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_setP2_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setP2(QPointF)
            cppSelf->setP2(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_setP2_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_setPoints(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.setPoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPoints", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLineF::setPoints(QPointF,QPointF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setPoints(QPointF,QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_setPoints_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setPoints(QPointF,QPointF)
            cppSelf->setPoints(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_setPoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_toLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.toLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toLine()const
            QLine cppResult = const_cast<const ::QLineF *>(cppSelf)->toLine();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_toTuple(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.toTuple";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTuple()
            // Begin code injection
            // TEMPLATE - to_tuple - START
            pyResult = Py_BuildValue("dddd", cppSelf->x1(), cppSelf->y1(), cppSelf->x2(), cppSelf->y2());
            // TEMPLATE - to_tuple - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_translate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.translate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLineF::translate(QPointF)
    // 1: QLineF::translate(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // translate(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // translate(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_translate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // translate(const QPointF & p)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // translate(QPointF)
                cppSelf->translate(*cppArg0);
            }
            break;
        }
        case 1: // translate(qreal dx, qreal dy)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // translate(qreal,qreal)
                cppSelf->translate(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLineFFunc_translate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_translated(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.translated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLineF::translated(QPointF)const
    // 1: QLineF::translated(qreal,qreal)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // translated(qreal,qreal)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // translated(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLineFFunc_translated_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // translated(const QPointF & p) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // translated(QPointF)const
                QLineF cppResult = const_cast<const ::QLineF *>(cppSelf)->translated(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // translated(qreal dx, qreal dy) const
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // translated(qreal,qreal)const
                QLineF cppResult = const_cast<const ::QLineF *>(cppSelf)->translated(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLineFFunc_translated_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLineFFunc_unitVector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.unitVector";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unitVector()const
            QLineF cppResult = const_cast<const ::QLineF *>(cppSelf)->unitVector();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_x1(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.x1";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x1()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->x1();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_x2(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.x2";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x2()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->x2();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_y1(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.y1";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y1()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->y1();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineFFunc_y2(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLineF.y2";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y2()const
            qreal cppResult = const_cast<const ::QLineF *>(cppSelf)->y2();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLineF___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QLineF_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLineF_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc___reduce__), METH_NOARGS},
    {"angle", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_angle), METH_VARARGS},
    {"angleTo", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_angleTo), METH_O},
    {"center", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_center), METH_NOARGS},
    {"dx", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_dx), METH_NOARGS},
    {"dy", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_dy), METH_NOARGS},
    {"fromPolar", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_fromPolar), METH_VARARGS|METH_STATIC},
    {"intersect", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_intersect), METH_O},
    {"intersects", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_intersects), METH_VARARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_isNull), METH_NOARGS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_length), METH_NOARGS},
    {"normalVector", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_normalVector), METH_NOARGS},
    {"p1", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_p1), METH_NOARGS},
    {"p2", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_p2), METH_NOARGS},
    {"pointAt", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_pointAt), METH_O},
    {"setAngle", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_setAngle), METH_O},
    {"setLength", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_setLength), METH_O},
    {"setLine", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_setLine), METH_VARARGS},
    {"setP1", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_setP1), METH_O},
    {"setP2", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_setP2), METH_O},
    {"setPoints", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_setPoints), METH_VARARGS},
    {"toLine", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_toLine), METH_NOARGS},
    {"toTuple", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_toTuple), METH_NOARGS},
    {"translate", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_translate), METH_VARARGS},
    {"translated", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_translated), METH_VARARGS},
    {"unitVector", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_unitVector), METH_NOARGS},
    {"x1", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_x1), METH_NOARGS},
    {"x2", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_x2), METH_NOARGS},
    {"y1", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_y1), METH_NOARGS},
    {"y2", reinterpret_cast<PyCFunction>(Sbk_QLineFFunc_y2), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QLineF___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QLineF___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QLineF_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArg)))) {
                // operator!=(const QLineF & d) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLineF cppArg0_local;
                ::QLineF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArg)))) {
                // operator==(const QLineF & d) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLineF cppArg0_local;
                ::QLineF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QLineF_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QLineF_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QLineF_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLineF_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLineF_Type = nullptr;
static SbkObjectType *Sbk_QLineF_TypeF(void)
{
    return _Sbk_QLineF_Type;
}

static PyType_Slot Sbk_QLineF_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QLineFFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLineF_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLineF_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QLineF_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLineF_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLineF_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QLineF___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QLineF___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QLineF_spec = {
    "2:PySide2.QtCore.QLineF",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLineF_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QLineF_IntersectType_PythonToCpp_QLineF_IntersectType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLineF::IntersectType *>(cppOut) =
        static_cast<::QLineF::IntersectType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLineF_IntersectType_PythonToCpp_QLineF_IntersectType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX]))
        return QLineF_IntersectType_PythonToCpp_QLineF_IntersectType;
    return {};
}
static PyObject *QLineF_IntersectType_CppToPython_QLineF_IntersectType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLineF::IntersectType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLineF_PythonToCpp_QLineF_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLineF_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLineF_PythonToCpp_QLineF_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLineF_TypeF())))
        return QLineF_PythonToCpp_QLineF_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLineF_PTR_CppToPython_QLineF(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QLineF *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QLineF_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QLineF_COPY_CppToPython_QLineF(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QLineF_TypeF(), new ::QLineF(*reinterpret_cast<const ::QLineF *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QLineF_PythonToCpp_QLineF_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLineF *>(cppOut) = *reinterpret_cast< ::QLineF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QLineF_PythonToCpp_QLineF_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLineF_TypeF())))
        return QLineF_PythonToCpp_QLineF_COPY;
    return {};
}

// Implicit conversions.
static void constQLineREF_PythonToCpp_QLineF(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLineF *>(cppOut) = ::QLineF( *reinterpret_cast< ::QLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQLineREF_PythonToCpp_QLineF_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX], pyIn))
        return constQLineREF_PythonToCpp_QLineF;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLineF_SignatureStrings[] = {
    "4:PySide2.QtCore.QLineF(self)",
    "3:PySide2.QtCore.QLineF(self,line:PySide2.QtCore.QLine)",
    "2:PySide2.QtCore.QLineF(self,QLineF:PySide2.QtCore.QLineF)",
    "1:PySide2.QtCore.QLineF(self,pt1:PySide2.QtCore.QPointF,pt2:PySide2.QtCore.QPointF)",
    "0:PySide2.QtCore.QLineF(self,x1:qreal,y1:qreal,x2:qreal,y2:qreal)",
    "PySide2.QtCore.QLineF.__reduce__(self)->PyObject",
    "PySide2.QtCore.QLineF.__repr__(self)->PyObject",
    "1:PySide2.QtCore.QLineF.angle(self)->qreal",
    "0:PySide2.QtCore.QLineF.angle(self,l:PySide2.QtCore.QLineF)->qreal",
    "PySide2.QtCore.QLineF.angleTo(self,l:PySide2.QtCore.QLineF)->qreal",
    "PySide2.QtCore.QLineF.center(self)->PySide2.QtCore.QPointF",
    "PySide2.QtCore.QLineF.dx(self)->qreal",
    "PySide2.QtCore.QLineF.dy(self)->qreal",
    "PySide2.QtCore.QLineF.fromPolar(length:qreal,angle:qreal)->PySide2.QtCore.QLineF",
    "PySide2.QtCore.QLineF.intersect(self,l:PySide2.QtCore.QLineF,intersectionPoint:PySide2.QtCore.QPointF)->PySide2.QtCore.QLineF.IntersectType",
    "PySide2.QtCore.QLineF.intersects(self,l:PySide2.QtCore.QLineF,intersectionPoint:PySide2.QtCore.QPointF)->PySide2.QtCore.QLineF.IntersectType",
    "PySide2.QtCore.QLineF.isNull(self)->bool",
    "PySide2.QtCore.QLineF.length(self)->qreal",
    "PySide2.QtCore.QLineF.normalVector(self)->PySide2.QtCore.QLineF",
    "PySide2.QtCore.QLineF.p1(self)->PySide2.QtCore.QPointF",
    "PySide2.QtCore.QLineF.p2(self)->PySide2.QtCore.QPointF",
    "PySide2.QtCore.QLineF.pointAt(self,t:qreal)->PySide2.QtCore.QPointF",
    "PySide2.QtCore.QLineF.setAngle(self,angle:qreal)",
    "PySide2.QtCore.QLineF.setLength(self,len:qreal)",
    "PySide2.QtCore.QLineF.setLine(self,x1:qreal,y1:qreal,x2:qreal,y2:qreal)",
    "PySide2.QtCore.QLineF.setP1(self,p1:PySide2.QtCore.QPointF)",
    "PySide2.QtCore.QLineF.setP2(self,p2:PySide2.QtCore.QPointF)",
    "PySide2.QtCore.QLineF.setPoints(self,p1:PySide2.QtCore.QPointF,p2:PySide2.QtCore.QPointF)",
    "PySide2.QtCore.QLineF.toLine(self)->PySide2.QtCore.QLine",
    "PySide2.QtCore.QLineF.toTuple(self)->PyObject",
    "1:PySide2.QtCore.QLineF.translate(self,p:PySide2.QtCore.QPointF)",
    "0:PySide2.QtCore.QLineF.translate(self,dx:qreal,dy:qreal)",
    "1:PySide2.QtCore.QLineF.translated(self,p:PySide2.QtCore.QPointF)->PySide2.QtCore.QLineF",
    "0:PySide2.QtCore.QLineF.translated(self,dx:qreal,dy:qreal)->PySide2.QtCore.QLineF",
    "PySide2.QtCore.QLineF.unitVector(self)->PySide2.QtCore.QLineF",
    "PySide2.QtCore.QLineF.x1(self)->qreal",
    "PySide2.QtCore.QLineF.x2(self)->qreal",
    "PySide2.QtCore.QLineF.y1(self)->qreal",
    "PySide2.QtCore.QLineF.y2(self)->qreal",
    "PySide2.QtCore.QLineF.__copy__()",
    nullptr}; // Sentinel

void init_QLineF(PyObject *module)
{
    _Sbk_QLineF_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLineF",
        "QLineF",
        &Sbk_QLineF_spec,
        &Shiboken::callCppDestructor< ::QLineF >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLineF_Type);
    InitSignatureStrings(pyType, QLineF_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLineF_Type), Sbk_QLineF_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLineF_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLineF_TypeF(),
        QLineF_PythonToCpp_QLineF_PTR,
        is_QLineF_PythonToCpp_QLineF_PTR_Convertible,
        QLineF_PTR_CppToPython_QLineF,
        QLineF_COPY_CppToPython_QLineF);

    Shiboken::Conversions::registerConverterName(converter, "QLineF");
    Shiboken::Conversions::registerConverterName(converter, "QLineF*");
    Shiboken::Conversions::registerConverterName(converter, "QLineF&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLineF).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QLineF_PythonToCpp_QLineF_COPY,
        is_QLineF_PythonToCpp_QLineF_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQLineREF_PythonToCpp_QLineF,
        is_constQLineREF_PythonToCpp_QLineF_Convertible);

    // Initialization of enums.

    // Initialization of enum 'IntersectType'.
    SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLineF_TypeF(),
        "IntersectType",
        "2:PySide2.QtCore.QLineF.IntersectType",
        "QLineF::IntersectType");
    if (!SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX],
        Sbk_QLineF_TypeF(), "NoIntersection", (long) QLineF::IntersectType::NoIntersection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX],
        Sbk_QLineF_TypeF(), "BoundedIntersection", (long) QLineF::IntersectType::BoundedIntersection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX],
        Sbk_QLineF_TypeF(), "UnboundedIntersection", (long) QLineF::IntersectType::UnboundedIntersection))
        return;
    // Register converter for enum 'QLineF::IntersectType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX],
            QLineF_IntersectType_CppToPython_QLineF_IntersectType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLineF_IntersectType_PythonToCpp_QLineF_IntersectType,
            is_QLineF_IntersectType_PythonToCpp_QLineF_IntersectType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLineF::IntersectType");
        Shiboken::Conversions::registerConverterName(converter, "IntersectType");
    }
    // End of 'IntersectType' enum.

    qRegisterMetaType< ::QLineF >("QLineF");
    qRegisterMetaType< ::QLineF::IntersectType >("QLineF::IntersectType");
}
