/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmarginsf_wrapper.h"

// inner classes

// Extra includes
#include <qmargins.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMarginsF_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMarginsF >()))
        return -1;

    ::QMarginsF *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QMarginsF_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QMarginsF", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QMarginsF::QMarginsF()
    // 1: QMarginsF::QMarginsF(QMargins)
    // 2: QMarginsF::QMarginsF(QMarginsF)
    // 3: QMarginsF::QMarginsF(qreal,qreal,qreal,qreal)
    if (numArgs == 0) {
        overloadId = 0; // QMarginsF()
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 3; // QMarginsF(qreal,qreal,qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMarginsF(QMargins)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QMarginsF(QMarginsF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsF_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMarginsF()
        {

            if (!PyErr_Occurred()) {
                // QMarginsF()
                cptr = new ::QMarginsF();
            }
            break;
        }
        case 1: // QMarginsF(const QMargins & margins)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMargins cppArg0_local;
            ::QMargins *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMarginsF(QMargins)
                cptr = new ::QMarginsF(*cppArg0);
            }
            break;
        }
        case 2: // QMarginsF(const QMarginsF & QMarginsF)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMarginsF(QMarginsF)
                cptr = new ::QMarginsF(*cppArg0);
            }
            break;
        }
        case 3: // QMarginsF(qreal left, qreal top, qreal right, qreal bottom)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QMarginsF(qreal,qreal,qreal,qreal)
                cptr = new ::QMarginsF(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMarginsF >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMarginsF_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMarginsF_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMarginsFFunc_bottom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.bottom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottom()const
            qreal cppResult = const_cast<const ::QMarginsF *>(cppSelf)->bottom();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QMarginsF *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc_left(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.left";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // left()const
            qreal cppResult = const_cast<const ::QMarginsF *>(cppSelf)->left();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc_right(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.right";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // right()const
            qreal cppResult = const_cast<const ::QMarginsF *>(cppSelf)->right();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc_setBottom(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.setBottom";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::setBottom(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBottom(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc_setBottom_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottom(qreal)
            cppSelf->setBottom(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMarginsFFunc_setBottom_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc_setLeft(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.setLeft";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::setLeft(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLeft(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc_setLeft_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeft(qreal)
            cppSelf->setLeft(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMarginsFFunc_setLeft_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc_setRight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.setRight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::setRight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRight(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc_setRight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRight(qreal)
            cppSelf->setRight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMarginsFFunc_setRight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc_setTop(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.setTop";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::setTop(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTop(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc_setTop_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTop(qreal)
            cppSelf->setTop(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMarginsFFunc_setTop_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc_toMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.toMargins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toMargins()const
            QMargins cppResult = const_cast<const ::QMarginsF *>(cppSelf)->toMargins();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc_top(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.top";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // top()const
            qreal cppResult = const_cast<const ::QMarginsF *>(cppSelf)->top();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsF___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMarginsF_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMarginsF_methods[] = {
    {"bottom", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_bottom), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_isNull), METH_NOARGS},
    {"left", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_left), METH_NOARGS},
    {"right", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_right), METH_NOARGS},
    {"setBottom", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_setBottom), METH_O},
    {"setLeft", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_setLeft), METH_O},
    {"setRight", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_setRight), METH_O},
    {"setTop", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_setTop), METH_O},
    {"toMargins", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_toMargins), METH_NOARGS},
    {"top", reinterpret_cast<PyCFunction>(Sbk_QMarginsFFunc_top), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMarginsF___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMarginsF___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QMarginsFFunc___mul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__mul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator*(qreal,QMarginsF)
    // 1: QMarginsF::operator*(QMarginsF,qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // operator*(QMarginsF,qreal)
    } else if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // operator*(qreal,QMarginsF)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___mul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*(qreal lhs)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(qreal,QMarginsF) [reverse operator]
                QMarginsF cppResult = cppArg0 * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator*(qreal rhs)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(QMarginsF,qreal)
                QMarginsF cppResult = (*cppSelf) * cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMarginsFFunc___mul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___imul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__imul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator*=(qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // operator*=(qreal)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___imul___TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator*=(qreal)
            (*cppSelf) *= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMarginsFFunc___imul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___pos__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__pos__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operator+(QMarginsF)
            QMarginsF cppResult = + (*cppSelf);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator+(QMarginsF,QMarginsF)
    // 1: QMarginsF::operator+(qreal,QMarginsF)
    // 2: QMarginsF::operator+(QMarginsF,qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 2; // operator+(QMarginsF,qreal)
    } else if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // operator+(qreal,QMarginsF)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
        overloadId = 0; // operator+(QMarginsF,QMarginsF)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___add___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator+(const QMarginsF & rhs)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+(QMarginsF,QMarginsF)
                QMarginsF cppResult = (*cppSelf) + (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator+(qreal lhs)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator+(qreal,QMarginsF) [reverse operator]
                QMarginsF cppResult = cppArg0 + (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
        case 2: // operator+(qreal rhs)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator+(QMarginsF,qreal)
                QMarginsF cppResult = (*cppSelf) + cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMarginsFFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator+=(QMarginsF)
    // 1: QMarginsF::operator+=(qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // operator+=(qreal)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QMarginsF)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___iadd___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator+=(const QMarginsF & margins)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+=(QMarginsF)
                (*cppSelf) += (*cppArg0);
            }
            break;
        }
        case 1: // operator+=(qreal addend)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator+=(qreal)
                (*cppSelf) += cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMarginsFFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___neg__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__neg__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operator-(QMarginsF)
            QMarginsF cppResult = - (*cppSelf);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMarginsFFunc___sub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__sub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator-(QMarginsF,QMarginsF)
    // 1: QMarginsF::operator-(QMarginsF,qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // operator-(QMarginsF,qreal)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
        overloadId = 0; // operator-(QMarginsF,QMarginsF)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___sub___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator-(const QMarginsF & rhs)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator-(QMarginsF,QMarginsF)
                QMarginsF cppResult = (*cppSelf) - (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator-(qreal rhs)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator-(QMarginsF,qreal)
                QMarginsF cppResult = (*cppSelf) - cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMarginsFFunc___sub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator-=(QMarginsF)
    // 1: QMarginsF::operator-=(qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // operator-=(qreal)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
        overloadId = 0; // operator-=(QMarginsF)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___isub___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator-=(const QMarginsF & margins)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator-=(QMarginsF)
                (*cppSelf) -= (*cppArg0);
            }
            break;
        }
        case 1: // operator-=(qreal subtrahend)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator-=(qreal)
                (*cppSelf) -= cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMarginsFFunc___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___div__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__div__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator/(QMarginsF,qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // operator/(QMarginsF,qreal)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___div___TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/(QMarginsF,qreal)
            QMarginsF cppResult = (*cppSelf) / cppArg0;
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMarginsFFunc___div___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMarginsFFunc___idiv__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMarginsF.__idiv__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMarginsF::operator/=(qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // operator/=(qreal)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMarginsFFunc___idiv___TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/=(qreal)
            (*cppSelf) /= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMarginsFFunc___idiv___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QMarginsF_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
                // operator!=(const QMarginsF & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMarginsF cppArg0_local;
                ::QMarginsF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
                // operator==(const QMarginsF & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMarginsF cppArg0_local;
                ::QMarginsF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMarginsF_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMarginsF_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMarginsF_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMarginsF_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QMarginsF__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMarginsF_Type = nullptr;
static SbkObjectType *Sbk_QMarginsF_TypeF(void)
{
    return _Sbk_QMarginsF_Type;
}

static PyType_Slot Sbk_QMarginsF_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QMarginsF__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMarginsF_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMarginsF_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMarginsF_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMarginsF_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMarginsF_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_multiply, (void *)Sbk_QMarginsFFunc___imul__},
    {Py_nb_inplace_add, (void *)Sbk_QMarginsFFunc___iadd__},
    {Py_nb_positive, (void *)Sbk_QMarginsFFunc___pos__},
    {Py_nb_multiply, (void *)Sbk_QMarginsFFunc___mul__},
    {Py_nb_add, (void *)Sbk_QMarginsFFunc___add__},
    {Py_nb_inplace_subtract, (void *)Sbk_QMarginsFFunc___isub__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QMarginsF___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QMarginsF___nb_bool},
#endif
    {Py_nb_subtract, (void *)Sbk_QMarginsFFunc___sub__},
    {Py_nb_negative, (void *)Sbk_QMarginsFFunc___neg__},
    {Py_nb_true_divide, (void *)Sbk_QMarginsFFunc___div__},
#ifndef IS_PY3K
    {Py_nb_divide, (void *)Sbk_QMarginsFFunc___div__},
#endif
    // This function is unused in Python 3. We reference it here.
    {0, (void *)Sbk_QMarginsFFunc___idiv__},
    // This list is ending at the first 0 entry.
    // Therefore, we need to put the unused functions at the very end.
    {0, nullptr}
};
static PyType_Spec Sbk_QMarginsF_spec = {
    "2:PySide2.QtCore.QMarginsF",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMarginsF_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMarginsF_PythonToCpp_QMarginsF_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMarginsF_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMarginsF_PythonToCpp_QMarginsF_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMarginsF_TypeF())))
        return QMarginsF_PythonToCpp_QMarginsF_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMarginsF_PTR_CppToPython_QMarginsF(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMarginsF *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMarginsF_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMarginsF_COPY_CppToPython_QMarginsF(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMarginsF_TypeF(), new ::QMarginsF(*reinterpret_cast<const ::QMarginsF *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMarginsF_PythonToCpp_QMarginsF_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMarginsF *>(cppOut) = *reinterpret_cast< ::QMarginsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMarginsF_PythonToCpp_QMarginsF_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMarginsF_TypeF())))
        return QMarginsF_PythonToCpp_QMarginsF_COPY;
    return {};
}

// Implicit conversions.
static void constQMarginsREF_PythonToCpp_QMarginsF(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMarginsF *>(cppOut) = ::QMarginsF( *reinterpret_cast< ::QMargins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQMarginsREF_PythonToCpp_QMarginsF_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX], pyIn))
        return constQMarginsREF_PythonToCpp_QMarginsF;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMarginsF_SignatureStrings[] = {
    "3:PySide2.QtCore.QMarginsF(self)",
    "2:PySide2.QtCore.QMarginsF(self,margins:PySide2.QtCore.QMargins)",
    "1:PySide2.QtCore.QMarginsF(self,QMarginsF:PySide2.QtCore.QMarginsF)",
    "0:PySide2.QtCore.QMarginsF(self,left:qreal,top:qreal,right:qreal,bottom:qreal)",
    "PySide2.QtCore.QMarginsF.bottom(self)->qreal",
    "PySide2.QtCore.QMarginsF.isNull(self)->bool",
    "PySide2.QtCore.QMarginsF.left(self)->qreal",
    "PySide2.QtCore.QMarginsF.right(self)->qreal",
    "PySide2.QtCore.QMarginsF.setBottom(self,bottom:qreal)",
    "PySide2.QtCore.QMarginsF.setLeft(self,left:qreal)",
    "PySide2.QtCore.QMarginsF.setRight(self,right:qreal)",
    "PySide2.QtCore.QMarginsF.setTop(self,top:qreal)",
    "PySide2.QtCore.QMarginsF.toMargins(self)->PySide2.QtCore.QMargins",
    "PySide2.QtCore.QMarginsF.top(self)->qreal",
    "PySide2.QtCore.QMarginsF.__copy__()",
    "1:PySide2.QtCore.QMarginsF.__mul__(self,lhs:qreal)->PySide2.QtCore.QMarginsF",
    "0:PySide2.QtCore.QMarginsF.__mul__(self,rhs:qreal)->PySide2.QtCore.QMarginsF",
    "PySide2.QtCore.QMarginsF.__imul__(self,factor:qreal)->PySide2.QtCore.QMarginsF",
    "PySide2.QtCore.QMarginsF.__pos__(self)->PySide2.QtCore.QMarginsF",
    "2:PySide2.QtCore.QMarginsF.__add__(self,rhs:PySide2.QtCore.QMarginsF)->PySide2.QtCore.QMarginsF",
    "1:PySide2.QtCore.QMarginsF.__add__(self,lhs:qreal)->PySide2.QtCore.QMarginsF",
    "0:PySide2.QtCore.QMarginsF.__add__(self,rhs:qreal)->PySide2.QtCore.QMarginsF",
    "1:PySide2.QtCore.QMarginsF.__iadd__(self,margins:PySide2.QtCore.QMarginsF)->PySide2.QtCore.QMarginsF",
    "0:PySide2.QtCore.QMarginsF.__iadd__(self,addend:qreal)->PySide2.QtCore.QMarginsF",
    "PySide2.QtCore.QMarginsF.__neg__(self)->PySide2.QtCore.QMarginsF",
    "1:PySide2.QtCore.QMarginsF.__sub__(self,rhs:PySide2.QtCore.QMarginsF)->PySide2.QtCore.QMarginsF",
    "0:PySide2.QtCore.QMarginsF.__sub__(self,rhs:qreal)->PySide2.QtCore.QMarginsF",
    "1:PySide2.QtCore.QMarginsF.__isub__(self,margins:PySide2.QtCore.QMarginsF)->PySide2.QtCore.QMarginsF",
    "0:PySide2.QtCore.QMarginsF.__isub__(self,subtrahend:qreal)->PySide2.QtCore.QMarginsF",
    "PySide2.QtCore.QMarginsF.__div__(self,divisor:qreal)->PySide2.QtCore.QMarginsF",
    "PySide2.QtCore.QMarginsF.__idiv__(self,divisor:qreal)->PySide2.QtCore.QMarginsF",
    nullptr}; // Sentinel

void init_QMarginsF(PyObject *module)
{
    _Sbk_QMarginsF_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMarginsF",
        "QMarginsF",
        &Sbk_QMarginsF_spec,
        &Shiboken::callCppDestructor< ::QMarginsF >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMarginsF_Type);
    InitSignatureStrings(pyType, QMarginsF_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMarginsF_Type), Sbk_QMarginsF_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMarginsF_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMarginsF_TypeF(),
        QMarginsF_PythonToCpp_QMarginsF_PTR,
        is_QMarginsF_PythonToCpp_QMarginsF_PTR_Convertible,
        QMarginsF_PTR_CppToPython_QMarginsF,
        QMarginsF_COPY_CppToPython_QMarginsF);

    Shiboken::Conversions::registerConverterName(converter, "QMarginsF");
    Shiboken::Conversions::registerConverterName(converter, "QMarginsF*");
    Shiboken::Conversions::registerConverterName(converter, "QMarginsF&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMarginsF).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMarginsF_PythonToCpp_QMarginsF_COPY,
        is_QMarginsF_PythonToCpp_QMarginsF_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQMarginsREF_PythonToCpp_QMarginsF,
        is_constQMarginsREF_PythonToCpp_QMarginsF_Convertible);

    qRegisterMetaType< ::QMarginsF >("QMarginsF");
}
