/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmessagelogcontext_wrapper.h"

// inner classes

// Extra includes
#include <qlogging.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMessageLogContext_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMessageLogContext >()))
        return -1;

    ::QMessageLogContext *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMessageLogContext.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 2 || numArgs == 3)
        goto Sbk_QMessageLogContext_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QMessageLogContext", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QMessageLogContext::QMessageLogContext()
    // 1: QMessageLogContext::QMessageLogContext(const char*,int,const char*,const char*)
    if (numArgs == 0) {
        overloadId = 0; // QMessageLogContext()
    } else if (numArgs == 4
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
        overloadId = 1; // QMessageLogContext(const char*,int,const char*,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMessageLogContext_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMessageLogContext()
        {

            if (!PyErr_Occurred()) {
                // QMessageLogContext()
                cptr = new ::QMessageLogContext();
            }
            break;
        }
        case 1: // QMessageLogContext(const char * fileName, int lineNumber, const char * functionName, const char * categoryName)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            const char* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            const char* cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QMessageLogContext(const char*,int,const char*,const char*)
                cptr = new ::QMessageLogContext(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMessageLogContext >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMessageLogContext_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMessageLogContext_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QMessageLogContext_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMessageLogContext_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QMessageLogContext_get_version(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->version;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QMessageLogContext_set_version(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'version' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'version', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->version;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->version = cppOut_local;

    return 0;
}

static PyObject *Sbk_QMessageLogContext_get_line(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->line;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QMessageLogContext_set_line(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'line' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'line', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->line;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->line = cppOut_local;

    return 0;
}

static PyObject *Sbk_QMessageLogContext_get_file(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    const char* cppOut_local = cppSelf->file;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppOut_local);
    return pyOut;
}
static int Sbk_QMessageLogContext_set_file(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'file' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!Shiboken::String::check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'file', 'char' or convertible type expected");
        return -1;
    }

    const char* cppOut_local = cppSelf->file;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->file = cppOut_local;

    return 0;
}

static PyObject *Sbk_QMessageLogContext_get_function(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    const char* cppOut_local = cppSelf->function;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppOut_local);
    return pyOut;
}
static int Sbk_QMessageLogContext_set_function(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'function' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!Shiboken::String::check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'function', 'char' or convertible type expected");
        return -1;
    }

    const char* cppOut_local = cppSelf->function;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->function = cppOut_local;

    return 0;
}

static PyObject *Sbk_QMessageLogContext_get_category(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    const char* cppOut_local = cppSelf->category;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppOut_local);
    return pyOut;
}
static int Sbk_QMessageLogContext_set_category(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QMessageLogContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'category' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!Shiboken::String::check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'category', 'char' or convertible type expected");
        return -1;
    }

    const char* cppOut_local = cppSelf->category;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->category = cppOut_local;

    return 0;
}

// Getters and Setters for QMessageLogContext
static PyGetSetDef Sbk_QMessageLogContext_getsetlist[] = {
    {const_cast<char *>("version"), Sbk_QMessageLogContext_get_version, Sbk_QMessageLogContext_set_version},
    {const_cast<char *>("line"), Sbk_QMessageLogContext_get_line, Sbk_QMessageLogContext_set_line},
    {const_cast<char *>("file"), Sbk_QMessageLogContext_get_file, Sbk_QMessageLogContext_set_file},
    {const_cast<char *>("function"), Sbk_QMessageLogContext_get_function, Sbk_QMessageLogContext_set_function},
    {const_cast<char *>("category"), Sbk_QMessageLogContext_get_category, Sbk_QMessageLogContext_set_category},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMessageLogContext_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMessageLogContext_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMessageLogContext_Type = nullptr;
static SbkObjectType *Sbk_QMessageLogContext_TypeF(void)
{
    return _Sbk_QMessageLogContext_Type;
}

static PyType_Slot Sbk_QMessageLogContext_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMessageLogContext_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMessageLogContext_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMessageLogContext_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QMessageLogContext_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMessageLogContext_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMessageLogContext_spec = {
    "2:PySide2.QtCore.QMessageLogContext",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMessageLogContext_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMessageLogContext_PythonToCpp_QMessageLogContext_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMessageLogContext_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMessageLogContext_PythonToCpp_QMessageLogContext_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMessageLogContext_TypeF())))
        return QMessageLogContext_PythonToCpp_QMessageLogContext_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMessageLogContext_PTR_CppToPython_QMessageLogContext(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMessageLogContext *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMessageLogContext_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMessageLogContext_SignatureStrings[] = {
    "1:PySide2.QtCore.QMessageLogContext(self)",
    "0:PySide2.QtCore.QMessageLogContext(self,fileName:char*,lineNumber:int,functionName:char*,categoryName:char*)",
    nullptr}; // Sentinel

void init_QMessageLogContext(PyObject *module)
{
    _Sbk_QMessageLogContext_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMessageLogContext",
        "QMessageLogContext*",
        &Sbk_QMessageLogContext_spec,
        &Shiboken::callCppDestructor< ::QMessageLogContext >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMessageLogContext_Type);
    InitSignatureStrings(pyType, QMessageLogContext_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMessageLogContext_Type), Sbk_QMessageLogContext_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMessageLogContext_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMessageLogContext_TypeF(),
        QMessageLogContext_PythonToCpp_QMessageLogContext_PTR,
        is_QMessageLogContext_PythonToCpp_QMessageLogContext_PTR_Convertible,
        QMessageLogContext_PTR_CppToPython_QMessageLogContext);

    Shiboken::Conversions::registerConverterName(converter, "QMessageLogContext");
    Shiboken::Conversions::registerConverterName(converter, "QMessageLogContext*");
    Shiboken::Conversions::registerConverterName(converter, "QMessageLogContext&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMessageLogContext).name());


}
