/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmetaenum_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMetaEnum_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMetaEnum >()))
        return -1;

    ::QMetaEnum *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMetaEnum", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMetaEnum::QMetaEnum()
    // 1: QMetaEnum::QMetaEnum(QMetaEnum)
    if (numArgs == 0) {
        overloadId = 0; // QMetaEnum()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMetaEnum(QMetaEnum)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnum_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMetaEnum()
        {

            if (!PyErr_Occurred()) {
                // QMetaEnum()
                cptr = new ::QMetaEnum();
            }
            break;
        }
        case 1: // QMetaEnum(const QMetaEnum & QMetaEnum)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMetaEnum cppArg0_local;
            ::QMetaEnum *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMetaEnum(QMetaEnum)
                cptr = new ::QMetaEnum(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMetaEnum >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMetaEnum_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMetaEnum_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMetaEnumFunc_enumName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.enumName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enumName()const
            const char * cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->enumName();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_isFlag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.isFlag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFlag()const
            bool cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->isFlag();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_isScoped(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.isScoped";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isScoped()const
            bool cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->isScoped();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_key(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.key";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaEnum::key(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // key(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnumFunc_key_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // key(int)const
            const char * cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->key(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaEnumFunc_key_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaEnumFunc_keyCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.keyCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyCount()const
            int cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->keyCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_keyToValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.keyToValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaEnum::keyToValue(const char*,bool*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // keyToValue(const char*,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnumFunc_keyToValue_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        bool* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // keyToValue(const char*,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            int retval_ = cppSelf->keyToValue(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaEnumFunc_keyToValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaEnumFunc_keysToValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.keysToValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaEnum::keysToValue(const char*,bool*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // keysToValue(const char*,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnumFunc_keysToValue_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        bool* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // keysToValue(const char*,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            int retval_ = cppSelf->keysToValue(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaEnumFunc_keysToValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaEnumFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            const char * cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_scope(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.scope";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scope()const
            const char * cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->scope();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaEnumFunc_value(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaEnum::value(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // value(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnumFunc_value_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // value(int)const
            int cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->value(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaEnumFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaEnumFunc_valueToKey(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.valueToKey";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaEnum::valueToKey(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // valueToKey(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnumFunc_valueToKey_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // valueToKey(int)const
            const char * cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->valueToKey(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaEnumFunc_valueToKey_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaEnumFunc_valueToKeys(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaEnum.valueToKeys";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaEnum::valueToKeys(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // valueToKeys(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaEnumFunc_valueToKeys_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // valueToKeys(int)const
            QByteArray cppResult = const_cast<const ::QMetaEnum *>(cppSelf)->valueToKeys(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaEnumFunc_valueToKeys_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaEnum___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMetaEnum_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMetaEnum_methods[] = {
    {"enumName", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_enumName), METH_NOARGS},
    {"isFlag", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_isFlag), METH_NOARGS},
    {"isScoped", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_isScoped), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_isValid), METH_NOARGS},
    {"key", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_key), METH_O},
    {"keyCount", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_keyCount), METH_NOARGS},
    {"keyToValue", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_keyToValue), METH_O},
    {"keysToValue", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_keysToValue), METH_O},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_name), METH_NOARGS},
    {"scope", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_scope), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_value), METH_O},
    {"valueToKey", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_valueToKey), METH_O},
    {"valueToKeys", reinterpret_cast<PyCFunction>(Sbk_QMetaEnumFunc_valueToKeys), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMetaEnum___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMetaEnum_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMetaEnum_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMetaEnum_Type = nullptr;
static SbkObjectType *Sbk_QMetaEnum_TypeF(void)
{
    return _Sbk_QMetaEnum_Type;
}

static PyType_Slot Sbk_QMetaEnum_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMetaEnum_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMetaEnum_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMetaEnum_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMetaEnum_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMetaEnum_spec = {
    "2:PySide2.QtCore.QMetaEnum",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMetaEnum_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMetaEnum_PythonToCpp_QMetaEnum_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMetaEnum_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMetaEnum_PythonToCpp_QMetaEnum_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaEnum_TypeF())))
        return QMetaEnum_PythonToCpp_QMetaEnum_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMetaEnum_PTR_CppToPython_QMetaEnum(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMetaEnum *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMetaEnum_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMetaEnum_COPY_CppToPython_QMetaEnum(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMetaEnum_TypeF(), new ::QMetaEnum(*reinterpret_cast<const ::QMetaEnum *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMetaEnum_PythonToCpp_QMetaEnum_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMetaEnum *>(cppOut) = *reinterpret_cast< ::QMetaEnum *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMetaEnum_PythonToCpp_QMetaEnum_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaEnum_TypeF())))
        return QMetaEnum_PythonToCpp_QMetaEnum_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMetaEnum_SignatureStrings[] = {
    "1:PySide2.QtCore.QMetaEnum(self)",
    "0:PySide2.QtCore.QMetaEnum(self,QMetaEnum:PySide2.QtCore.QMetaEnum)",
    "PySide2.QtCore.QMetaEnum.enumName(self)->char*",
    "PySide2.QtCore.QMetaEnum.isFlag(self)->bool",
    "PySide2.QtCore.QMetaEnum.isScoped(self)->bool",
    "PySide2.QtCore.QMetaEnum.isValid(self)->bool",
    "PySide2.QtCore.QMetaEnum.key(self,index:int)->char*",
    "PySide2.QtCore.QMetaEnum.keyCount(self)->int",
    "PySide2.QtCore.QMetaEnum.keyToValue(self,key:char*,ok:bool*=nullptr)->int",
    "PySide2.QtCore.QMetaEnum.keysToValue(self,keys:char*,ok:bool*=nullptr)->int",
    "PySide2.QtCore.QMetaEnum.name(self)->char*",
    "PySide2.QtCore.QMetaEnum.scope(self)->char*",
    "PySide2.QtCore.QMetaEnum.value(self,index:int)->int",
    "PySide2.QtCore.QMetaEnum.valueToKey(self,value:int)->char*",
    "PySide2.QtCore.QMetaEnum.valueToKeys(self,value:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QMetaEnum.__copy__()",
    nullptr}; // Sentinel

void init_QMetaEnum(PyObject *module)
{
    _Sbk_QMetaEnum_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMetaEnum",
        "QMetaEnum",
        &Sbk_QMetaEnum_spec,
        &Shiboken::callCppDestructor< ::QMetaEnum >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMetaEnum_Type);
    InitSignatureStrings(pyType, QMetaEnum_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMetaEnum_Type), Sbk_QMetaEnum_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMetaEnum_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMetaEnum_TypeF(),
        QMetaEnum_PythonToCpp_QMetaEnum_PTR,
        is_QMetaEnum_PythonToCpp_QMetaEnum_PTR_Convertible,
        QMetaEnum_PTR_CppToPython_QMetaEnum,
        QMetaEnum_COPY_CppToPython_QMetaEnum);

    Shiboken::Conversions::registerConverterName(converter, "QMetaEnum");
    Shiboken::Conversions::registerConverterName(converter, "QMetaEnum*");
    Shiboken::Conversions::registerConverterName(converter, "QMetaEnum&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMetaEnum).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMetaEnum_PythonToCpp_QMetaEnum_COPY,
        is_QMetaEnum_PythonToCpp_QMetaEnum_COPY_Convertible);

    qRegisterMetaType< ::QMetaEnum >("QMetaEnum");
}
