/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmimetype_wrapper.h"

// inner classes

// Extra includes
#include <qmimetype.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMimeType_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMimeType >()))
        return -1;

    ::QMimeType *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMimeType", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMimeType::QMimeType()
    // 1: QMimeType::QMimeType(QMimeType)
    if (numArgs == 0) {
        overloadId = 0; // QMimeType()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMimeType(QMimeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeType_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMimeType()
        {

            if (!PyErr_Occurred()) {
                // QMimeType()
                cptr = new ::QMimeType();
            }
            break;
        }
        case 1: // QMimeType(const QMimeType & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMimeType cppArg0_local;
            ::QMimeType *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMimeType(QMimeType)
                cptr = new ::QMimeType(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMimeType >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMimeType_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMimeType_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMimeTypeFunc_aliases(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.aliases";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // aliases()const
            QStringList cppResult = const_cast<const ::QMimeType *>(cppSelf)->aliases();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_allAncestors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.allAncestors";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allAncestors()const
            QStringList cppResult = const_cast<const ::QMimeType *>(cppSelf)->allAncestors();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_comment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.comment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comment()const
            QString cppResult = const_cast<const ::QMimeType *>(cppSelf)->comment();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_filterString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.filterString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filterString()const
            QString cppResult = const_cast<const ::QMimeType *>(cppSelf)->filterString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_genericIconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.genericIconName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // genericIconName()const
            QString cppResult = const_cast<const ::QMimeType *>(cppSelf)->genericIconName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_globPatterns(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.globPatterns";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globPatterns()const
            QStringList cppResult = const_cast<const ::QMimeType *>(cppSelf)->globPatterns();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_iconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.iconName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iconName()const
            QString cppResult = const_cast<const ::QMimeType *>(cppSelf)->iconName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_inherits(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.inherits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeType::inherits(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // inherits(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeTypeFunc_inherits_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inherits(QString)const
            bool cppResult = const_cast<const ::QMimeType *>(cppSelf)->inherits(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeTypeFunc_inherits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeTypeFunc_isDefault(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.isDefault";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDefault()const
            bool cppResult = const_cast<const ::QMimeType *>(cppSelf)->isDefault();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QMimeType *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QMimeType *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_parentMimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.parentMimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentMimeTypes()const
            QStringList cppResult = const_cast<const ::QMimeType *>(cppSelf)->parentMimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_preferredSuffix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.preferredSuffix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredSuffix()const
            QString cppResult = const_cast<const ::QMimeType *>(cppSelf)->preferredSuffix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_suffixes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.suffixes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // suffixes()const
            QStringList cppResult = const_cast<const ::QMimeType *>(cppSelf)->suffixes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeTypeFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeType.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeType::swap(QMimeType&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QMimeType&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeTypeFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMimeType cppArg0_local;
        ::QMimeType *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QMimeType&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMimeTypeFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeType___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMimeType_PropertyStrings[] = {
    "aliases:",
    "allAncestors:",
    "comment:",
    "filterString:",
    "genericIconName:",
    "globPatterns:",
    "iconName:",
    "isDefault:",
    "name:",
    "parentMimeTypes:",
    "preferredSuffix:",
    "suffixes:",
    "valid:isValid",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMimeType_methods[] = {
    {"aliases", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_aliases), METH_NOARGS},
    {"allAncestors", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_allAncestors), METH_NOARGS},
    {"comment", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_comment), METH_NOARGS},
    {"filterString", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_filterString), METH_NOARGS},
    {"genericIconName", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_genericIconName), METH_NOARGS},
    {"globPatterns", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_globPatterns), METH_NOARGS},
    {"iconName", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_iconName), METH_NOARGS},
    {"inherits", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_inherits), METH_O},
    {"isDefault", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_isDefault), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_isValid), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_name), METH_NOARGS},
    {"parentMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_parentMimeTypes), METH_NOARGS},
    {"preferredSuffix", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_preferredSuffix), METH_NOARGS},
    {"suffixes", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_suffixes), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QMimeTypeFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMimeType___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QMimeType_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), (pyArg)))) {
                // operator!=(const QMimeType & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMimeType cppArg0_local;
                ::QMimeType *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), (pyArg)))) {
                // operator==(const QMimeType & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMimeType cppArg0_local;
                ::QMimeType *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMimeType_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMimeType_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMimeType_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMimeType_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QMimeType__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMimeType_Type = nullptr;
static SbkObjectType *Sbk_QMimeType_TypeF(void)
{
    return _Sbk_QMimeType_Type;
}

static PyType_Slot Sbk_QMimeType_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QMimeType__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMimeType_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMimeType_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMimeType_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMimeType_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMimeType_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMimeType_spec = {
    "2:PySide2.QtCore.QMimeType",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMimeType_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMimeType_PythonToCpp_QMimeType_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMimeType_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMimeType_PythonToCpp_QMimeType_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMimeType_TypeF())))
        return QMimeType_PythonToCpp_QMimeType_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMimeType_PTR_CppToPython_QMimeType(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMimeType *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMimeType_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMimeType_COPY_CppToPython_QMimeType(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMimeType_TypeF(), new ::QMimeType(*reinterpret_cast<const ::QMimeType *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMimeType_PythonToCpp_QMimeType_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMimeType *>(cppOut) = *reinterpret_cast< ::QMimeType *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMimeType_PythonToCpp_QMimeType_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMimeType_TypeF())))
        return QMimeType_PythonToCpp_QMimeType_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMimeType_SignatureStrings[] = {
    "1:PySide2.QtCore.QMimeType(self)",
    "0:PySide2.QtCore.QMimeType(self,other:PySide2.QtCore.QMimeType)",
    "PySide2.QtCore.QMimeType.aliases(self)->QStringList",
    "PySide2.QtCore.QMimeType.allAncestors(self)->QStringList",
    "PySide2.QtCore.QMimeType.comment(self)->QString",
    "PySide2.QtCore.QMimeType.filterString(self)->QString",
    "PySide2.QtCore.QMimeType.genericIconName(self)->QString",
    "PySide2.QtCore.QMimeType.globPatterns(self)->QStringList",
    "PySide2.QtCore.QMimeType.iconName(self)->QString",
    "PySide2.QtCore.QMimeType.inherits(self,mimeTypeName:QString)->bool",
    "PySide2.QtCore.QMimeType.isDefault(self)->bool",
    "PySide2.QtCore.QMimeType.isValid(self)->bool",
    "PySide2.QtCore.QMimeType.name(self)->QString",
    "PySide2.QtCore.QMimeType.parentMimeTypes(self)->QStringList",
    "PySide2.QtCore.QMimeType.preferredSuffix(self)->QString",
    "PySide2.QtCore.QMimeType.suffixes(self)->QStringList",
    "PySide2.QtCore.QMimeType.swap(self,other:PySide2.QtCore.QMimeType)",
    "PySide2.QtCore.QMimeType.__copy__()",
    nullptr}; // Sentinel

void init_QMimeType(PyObject *module)
{
    _Sbk_QMimeType_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMimeType",
        "QMimeType",
        &Sbk_QMimeType_spec,
        &Shiboken::callCppDestructor< ::QMimeType >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMimeType_Type);
    InitSignatureStrings(pyType, QMimeType_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMimeType_Type), Sbk_QMimeType_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMimeType_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMimeType_TypeF(),
        QMimeType_PythonToCpp_QMimeType_PTR,
        is_QMimeType_PythonToCpp_QMimeType_PTR_Convertible,
        QMimeType_PTR_CppToPython_QMimeType,
        QMimeType_COPY_CppToPython_QMimeType);

    Shiboken::Conversions::registerConverterName(converter, "QMimeType");
    Shiboken::Conversions::registerConverterName(converter, "QMimeType*");
    Shiboken::Conversions::registerConverterName(converter, "QMimeType&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMimeType).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMimeType_PythonToCpp_QMimeType_COPY,
        is_QMimeType_PythonToCpp_QMimeType_COPY_Convertible);

    qRegisterMetaType< ::QMimeType >("QMimeType");
}
