/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmutex_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMutex_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMutex >()))
        return -1;

    ::QMutex *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMutex.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMutex", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMutex::QMutex()
    // 1: QMutex::QMutex(QMutex::RecursionMode)
    if (numArgs == 0) {
        overloadId = 0; // QMutex()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QMutex(QMutex::RecursionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMutex_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMutex()
        {

            if (!PyErr_Occurred()) {
                // QMutex()
                cptr = new ::QMutex();
            }
            break;
        }
        case 1: // QMutex(QMutex::RecursionMode mode)
        {
            ::QMutex::RecursionMode cppArg0{QMutex::NonRecursive};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QMutex(QMutex::RecursionMode)
                cptr = new ::QMutex(cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QMutex.QMutex(QMutex::RecursionMode mode) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMutex >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMutex_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMutex_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMutexFunc_isRecursive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMutex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMutex.isRecursive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRecursive()
            bool cppResult = reinterpret_cast<QBasicMutex *>(cppSelf)->isRecursive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMutexFunc_lock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMutex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMutex.lock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lock()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->lock();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMutexFunc_tryLock(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMutex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMutex.tryLock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMutexFunc_tryLock_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:tryLock", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMutex::tryLock(int)
    // 1: QBasicMutex::tryLock()
    if (numArgs == 0) {
        overloadId = 0; // tryLock(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // tryLock(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMutexFunc_tryLock_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // tryLock(int timeout)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
                if (PyDict_Contains(kwds, key_timeout)) {
                    value = PyDict_GetItem(kwds, key_timeout);
                    if (value && pyArgs[0]) {
                        errInfo = key_timeout;
                        Py_INCREF(errInfo);
                        goto Sbk_QMutexFunc_tryLock_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QMutexFunc_tryLock_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_timeout);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMutexFunc_tryLock_TypeError;
                }
            }
            int cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // tryLock(int)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->tryLock(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // tryLock()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMutexFunc_tryLock_TypeError;
            }

            if (!PyErr_Occurred()) {
                // tryLock()
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = reinterpret_cast<QBasicMutex *>(cppSelf)->tryLock();
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMutexFunc_tryLock_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMutexFunc_try_lock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMutex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMutex.try_lock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // try_lock()
            bool cppResult = cppSelf->try_lock();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMutexFunc_unlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMutex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMutex.unlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unlock()
            cppSelf->unlock();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QMutex_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMutex_methods[] = {
    {"isRecursive", reinterpret_cast<PyCFunction>(Sbk_QMutexFunc_isRecursive), METH_NOARGS},
    {"lock", reinterpret_cast<PyCFunction>(Sbk_QMutexFunc_lock), METH_NOARGS},
    {"tryLock", reinterpret_cast<PyCFunction>(Sbk_QMutexFunc_tryLock), METH_VARARGS|METH_KEYWORDS},
    {"try_lock", reinterpret_cast<PyCFunction>(Sbk_QMutexFunc_try_lock), METH_NOARGS},
    {"unlock", reinterpret_cast<PyCFunction>(Sbk_QMutexFunc_unlock), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMutex_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMutex_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMutex_Type = nullptr;
static SbkObjectType *Sbk_QMutex_TypeF(void)
{
    return _Sbk_QMutex_Type;
}

static PyType_Slot Sbk_QMutex_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMutex_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMutex_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMutex_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMutex_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMutex_spec = {
    "2:PySide2.QtCore.QMutex",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMutex_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QMutex_RecursionMode_PythonToCpp_QMutex_RecursionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMutex::RecursionMode *>(cppOut) =
        static_cast<::QMutex::RecursionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMutex_RecursionMode_PythonToCpp_QMutex_RecursionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX]))
        return QMutex_RecursionMode_PythonToCpp_QMutex_RecursionMode;
    return {};
}
static PyObject *QMutex_RecursionMode_CppToPython_QMutex_RecursionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMutex::RecursionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMutex_PythonToCpp_QMutex_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMutex_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMutex_PythonToCpp_QMutex_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMutex_TypeF())))
        return QMutex_PythonToCpp_QMutex_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMutex_PTR_CppToPython_QMutex(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMutex *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMutex_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMutex_SignatureStrings[] = {
    "1:PySide2.QtCore.QMutex(self)",
    "0:PySide2.QtCore.QMutex(self,mode:PySide2.QtCore.QMutex.RecursionMode)",
    "1:PySide2.QtCore.QMutex.isRecursive(self)->bool",
    "0:PySide2.QtCore.QMutex.isRecursive(self)->bool",
    "PySide2.QtCore.QMutex.lock(self)",
    "1:PySide2.QtCore.QMutex.tryLock(self,timeout:int=0)->bool",
    "0:PySide2.QtCore.QMutex.tryLock(self)->bool",
    "PySide2.QtCore.QMutex.try_lock(self)->bool",
    "PySide2.QtCore.QMutex.unlock(self)",
    nullptr}; // Sentinel

void init_QMutex(PyObject *module)
{
    _Sbk_QMutex_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMutex",
        "QMutex*",
        &Sbk_QMutex_spec,
        &Shiboken::callCppDestructor< ::QMutex >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBASICMUTEX_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMutex_Type);
    InitSignatureStrings(pyType, QMutex_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMutex_Type), Sbk_QMutex_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMutex_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMutex_TypeF(),
        QMutex_PythonToCpp_QMutex_PTR,
        is_QMutex_PythonToCpp_QMutex_PTR_Convertible,
        QMutex_PTR_CppToPython_QMutex);

    Shiboken::Conversions::registerConverterName(converter, "QMutex");
    Shiboken::Conversions::registerConverterName(converter, "QMutex*");
    Shiboken::Conversions::registerConverterName(converter, "QMutex&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMutex).name());


    // Initialization of enums.

    // Initialization of enum 'RecursionMode'.
    SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMutex_TypeF(),
        "RecursionMode",
        "2:PySide2.QtCore.QMutex.RecursionMode",
        "QMutex::RecursionMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX],
        Sbk_QMutex_TypeF(), "NonRecursive", (long) QMutex::RecursionMode::NonRecursive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX],
        Sbk_QMutex_TypeF(), "Recursive", (long) QMutex::RecursionMode::Recursive))
        return;
    // Register converter for enum 'QMutex::RecursionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX],
            QMutex_RecursionMode_CppToPython_QMutex_RecursionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMutex_RecursionMode_PythonToCpp_QMutex_RecursionMode,
            is_QMutex_RecursionMode_PythonToCpp_QMutex_RecursionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMutex::RecursionMode");
        Shiboken::Conversions::registerConverterName(converter, "RecursionMode");
    }
    // End of 'RecursionMode' enum.

    qRegisterMetaType< ::QMutex::RecursionMode >("QMutex::RecursionMode");
}
