/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qoperatingsystemversion_wrapper.h"

// inner classes

// Extra includes
#include <qoperatingsystemversion.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOperatingSystemVersion_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOperatingSystemVersion >()))
        return -1;

    ::QOperatingSystemVersion *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOperatingSystemVersion_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOperatingSystemVersion_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QOperatingSystemVersion", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QOperatingSystemVersion::QOperatingSystemVersion(QOperatingSystemVersion::OSType,int,int,int)
    // 1: QOperatingSystemVersion::QOperatingSystemVersion(QOperatingSystemVersion)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QOperatingSystemVersion(QOperatingSystemVersion)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QOperatingSystemVersion(QOperatingSystemVersion::OSType,int,int,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // QOperatingSystemVersion(QOperatingSystemVersion::OSType,int,int,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 0; // QOperatingSystemVersion(QOperatingSystemVersion::OSType,int,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOperatingSystemVersion_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOperatingSystemVersion(QOperatingSystemVersion::OSType osType, int vmajor, int vminor, int vmicro)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_vminor = Shiboken::String::createStaticString("vminor");
                if (PyDict_Contains(kwds, key_vminor)) {
                    value = PyDict_GetItem(kwds, key_vminor);
                    if (value && pyArgs[2]) {
                        errInfo = key_vminor;
                        Py_INCREF(errInfo);
                        goto Sbk_QOperatingSystemVersion_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QOperatingSystemVersion_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_vminor);
                }
                static PyObject *const key_vmicro = Shiboken::String::createStaticString("vmicro");
                if (PyDict_Contains(kwds, key_vmicro)) {
                    value = PyDict_GetItem(kwds, key_vmicro);
                    if (value && pyArgs[3]) {
                        errInfo = key_vmicro;
                        Py_INCREF(errInfo);
                        goto Sbk_QOperatingSystemVersion_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QOperatingSystemVersion_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_vmicro);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOperatingSystemVersion_Init_TypeError;
                }
            }
            ::QOperatingSystemVersion::OSType cppArg0{QOperatingSystemVersion::Unknown};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QOperatingSystemVersion(QOperatingSystemVersion::OSType,int,int,int)
                cptr = new ::QOperatingSystemVersion(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // QOperatingSystemVersion(const QOperatingSystemVersion & QOperatingSystemVersion)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOperatingSystemVersion_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QOperatingSystemVersion cppArg0_local = ::QOperatingSystemVersion(QOperatingSystemVersion::Unknown, int(0));
            ::QOperatingSystemVersion *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QOperatingSystemVersion(QOperatingSystemVersion)
                cptr = new ::QOperatingSystemVersion(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOperatingSystemVersion >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOperatingSystemVersion_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOperatingSystemVersion_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_current(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.current";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // current()
            QOperatingSystemVersion cppResult = ::QOperatingSystemVersion::current();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_currentType(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.currentType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentType()
            QOperatingSystemVersion::OSType cppResult = ::QOperatingSystemVersion::currentType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_majorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.majorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = const_cast<const ::QOperatingSystemVersion *>(cppSelf)->majorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_microVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.microVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // microVersion()const
            int cppResult = const_cast<const ::QOperatingSystemVersion *>(cppSelf)->microVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_minorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.minorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = const_cast<const ::QOperatingSystemVersion *>(cppSelf)->minorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QOperatingSystemVersion *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_segmentCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.segmentCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // segmentCount()const
            int cppResult = const_cast<const ::QOperatingSystemVersion *>(cppSelf)->segmentCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersionFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QOperatingSystemVersion.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QOperatingSystemVersion::OSType cppResult = const_cast<const ::QOperatingSystemVersion *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOperatingSystemVersion___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOperatingSystemVersion_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOperatingSystemVersion_methods[] = {
    {"current", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_current), METH_NOARGS|METH_STATIC},
    {"currentType", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_currentType), METH_NOARGS|METH_STATIC},
    {"majorVersion", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_majorVersion), METH_NOARGS},
    {"microVersion", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_microVersion), METH_NOARGS},
    {"minorVersion", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_minorVersion), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_name), METH_NOARGS},
    {"segmentCount", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_segmentCount), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersionFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QOperatingSystemVersion___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QOperatingSystemVersion_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOperatingSystemVersion_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QOperatingSystemVersion__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOperatingSystemVersion_Type = nullptr;
static SbkObjectType *Sbk_QOperatingSystemVersion_TypeF(void)
{
    return _Sbk_QOperatingSystemVersion_Type;
}

static PyType_Slot Sbk_QOperatingSystemVersion_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QOperatingSystemVersion__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOperatingSystemVersion_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOperatingSystemVersion_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOperatingSystemVersion_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOperatingSystemVersion_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOperatingSystemVersion_spec = {
    "2:PySide2.QtCore.QOperatingSystemVersion",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOperatingSystemVersion_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QOperatingSystemVersion_OSType_PythonToCpp_QOperatingSystemVersion_OSType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOperatingSystemVersion::OSType *>(cppOut) =
        static_cast<::QOperatingSystemVersion::OSType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOperatingSystemVersion_OSType_PythonToCpp_QOperatingSystemVersion_OSType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX]))
        return QOperatingSystemVersion_OSType_PythonToCpp_QOperatingSystemVersion_OSType;
    return {};
}
static PyObject *QOperatingSystemVersion_OSType_CppToPython_QOperatingSystemVersion_OSType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOperatingSystemVersion::OSType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOperatingSystemVersion_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOperatingSystemVersion_TypeF())))
        return QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOperatingSystemVersion_PTR_CppToPython_QOperatingSystemVersion(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOperatingSystemVersion *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOperatingSystemVersion_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QOperatingSystemVersion_COPY_CppToPython_QOperatingSystemVersion(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QOperatingSystemVersion_TypeF(), new ::QOperatingSystemVersion(*reinterpret_cast<const ::QOperatingSystemVersion *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOperatingSystemVersion *>(cppOut) = *reinterpret_cast< ::QOperatingSystemVersion *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOperatingSystemVersion_TypeF())))
        return QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOperatingSystemVersion_SignatureStrings[] = {
    "1:PySide2.QtCore.QOperatingSystemVersion(self,osType:PySide2.QtCore.QOperatingSystemVersion.OSType,vmajor:int,vminor:int=-1,vmicro:int=-1)",
    "0:PySide2.QtCore.QOperatingSystemVersion(self,QOperatingSystemVersion:PySide2.QtCore.QOperatingSystemVersion)",
    "PySide2.QtCore.QOperatingSystemVersion.current()->PySide2.QtCore.QOperatingSystemVersion",
    "PySide2.QtCore.QOperatingSystemVersion.currentType()->PySide2.QtCore.QOperatingSystemVersion.OSType",
    "PySide2.QtCore.QOperatingSystemVersion.majorVersion(self)->int",
    "PySide2.QtCore.QOperatingSystemVersion.microVersion(self)->int",
    "PySide2.QtCore.QOperatingSystemVersion.minorVersion(self)->int",
    "PySide2.QtCore.QOperatingSystemVersion.name(self)->QString",
    "PySide2.QtCore.QOperatingSystemVersion.segmentCount(self)->int",
    "PySide2.QtCore.QOperatingSystemVersion.type(self)->PySide2.QtCore.QOperatingSystemVersion.OSType",
    "PySide2.QtCore.QOperatingSystemVersion.__copy__()",
    nullptr}; // Sentinel

void init_QOperatingSystemVersion(PyObject *module)
{
    _Sbk_QOperatingSystemVersion_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOperatingSystemVersion",
        "QOperatingSystemVersion",
        &Sbk_QOperatingSystemVersion_spec,
        &Shiboken::callCppDestructor< ::QOperatingSystemVersion >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOperatingSystemVersion_Type);
    InitSignatureStrings(pyType, QOperatingSystemVersion_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOperatingSystemVersion_Type), Sbk_QOperatingSystemVersion_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOperatingSystemVersion_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOperatingSystemVersion_TypeF(),
        QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_PTR,
        is_QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_PTR_Convertible,
        QOperatingSystemVersion_PTR_CppToPython_QOperatingSystemVersion,
        QOperatingSystemVersion_COPY_CppToPython_QOperatingSystemVersion);

    Shiboken::Conversions::registerConverterName(converter, "QOperatingSystemVersion");
    Shiboken::Conversions::registerConverterName(converter, "QOperatingSystemVersion*");
    Shiboken::Conversions::registerConverterName(converter, "QOperatingSystemVersion&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOperatingSystemVersion).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_COPY,
        is_QOperatingSystemVersion_PythonToCpp_QOperatingSystemVersion_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'OSType'.
    SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOperatingSystemVersion_TypeF(),
        "OSType",
        "2:PySide2.QtCore.QOperatingSystemVersion.OSType",
        "QOperatingSystemVersion::OSType");
    if (!SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "Unknown", (long) QOperatingSystemVersion::OSType::Unknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "Windows", (long) QOperatingSystemVersion::OSType::Windows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "MacOS", (long) QOperatingSystemVersion::OSType::MacOS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "IOS", (long) QOperatingSystemVersion::OSType::IOS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "TvOS", (long) QOperatingSystemVersion::OSType::TvOS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "WatchOS", (long) QOperatingSystemVersion::OSType::WatchOS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
        Sbk_QOperatingSystemVersion_TypeF(), "Android", (long) QOperatingSystemVersion::OSType::Android))
        return;
    // Register converter for enum 'QOperatingSystemVersion::OSType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX],
            QOperatingSystemVersion_OSType_CppToPython_QOperatingSystemVersion_OSType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOperatingSystemVersion_OSType_PythonToCpp_QOperatingSystemVersion_OSType,
            is_QOperatingSystemVersion_OSType_PythonToCpp_QOperatingSystemVersion_OSType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_OSTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOperatingSystemVersion::OSType");
        Shiboken::Conversions::registerConverterName(converter, "OSType");
    }
    // End of 'OSType' enum.

    qRegisterMetaType< ::QOperatingSystemVersion::OSType >("QOperatingSystemVersion::OSType");
}

void init_QOperatingSystemVersionStaticFields()
{
    auto dict = reinterpret_cast<PyTypeObject *>(Sbk_QOperatingSystemVersion_TypeF())->tp_dict;
    PyDict_SetItemString(dict, "Windows7",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::Windows7));
    PyDict_SetItemString(dict, "Windows8",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::Windows8));
    PyDict_SetItemString(dict, "Windows8_1",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::Windows8_1));
    PyDict_SetItemString(dict, "Windows10",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::Windows10));
    PyDict_SetItemString(dict, "OSXMavericks",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::OSXMavericks));
    PyDict_SetItemString(dict, "OSXYosemite",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::OSXYosemite));
    PyDict_SetItemString(dict, "OSXElCapitan",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::OSXElCapitan));
    PyDict_SetItemString(dict, "MacOSSierra",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::MacOSSierra));
    PyDict_SetItemString(dict, "MacOSHighSierra",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::MacOSHighSierra));
    PyDict_SetItemString(dict, "MacOSMojave",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::MacOSMojave));
    PyDict_SetItemString(dict, "MacOSCatalina",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::MacOSCatalina));
    PyDict_SetItemString(dict, "MacOSBigSur",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::MacOSBigSur));
    PyDict_SetItemString(dict, "AndroidJellyBean",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidJellyBean));
    PyDict_SetItemString(dict, "AndroidJellyBean_MR1",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidJellyBean_MR1));
    PyDict_SetItemString(dict, "AndroidJellyBean_MR2",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidJellyBean_MR2));
    PyDict_SetItemString(dict, "AndroidKitKat",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidKitKat));
    PyDict_SetItemString(dict, "AndroidLollipop",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidLollipop));
    PyDict_SetItemString(dict, "AndroidLollipop_MR1",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidLollipop_MR1));
    PyDict_SetItemString(dict, "AndroidMarshmallow",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidMarshmallow));
    PyDict_SetItemString(dict, "AndroidNougat",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidNougat));
    PyDict_SetItemString(dict, "AndroidNougat_MR1",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidNougat_MR1));
    PyDict_SetItemString(dict, "AndroidOreo",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOPERATINGSYSTEMVERSION_IDX]), &QOperatingSystemVersion::AndroidOreo));

}
