/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qpoint_wrapper.h"

// inner classes

// Extra includes
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtcore.cpp (qpoint)]
namespace PySide {
    template<> inline Py_ssize_t hash(const QPoint &v) {
        return qHash(qMakePair(v.x(), v.y()));
    }
};
// END of custom code block [file: ../glue/qtcore.cpp (qpoint)]
// ========================================================================

// End of code injection



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPoint_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPoint >()))
        return -1;

    ::QPoint *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPoint", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QPoint::QPoint()
    // 1: QPoint::QPoint(QPoint)
    // 2: QPoint::QPoint(int,int)
    if (numArgs == 0) {
        overloadId = 0; // QPoint()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 2; // QPoint(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPoint(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPoint_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPoint()
        {

            if (!PyErr_Occurred()) {
                // QPoint()
                cptr = new ::QPoint();
            }
            break;
        }
        case 1: // QPoint(const QPoint & QPoint)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPoint(QPoint)
                cptr = new ::QPoint(*cppArg0);
            }
            break;
        }
        case 2: // QPoint(int xpos, int ypos)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QPoint(int,int)
                cptr = new ::QPoint(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPoint >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPoint_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPoint_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPointFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(ii))", PyObject_Type(self), cppSelf->x(), cppSelf->y());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%i, %i)",
                Py_TYPE(self)->tp_name, cppSelf->x(), cppSelf->y());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc_dotProduct(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.dotProduct";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "dotProduct", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPoint::dotProduct(QPoint,QPoint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // dotProduct(QPoint,QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc_dotProduct_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPoint cppArg1_local;
        ::QPoint *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // dotProduct(QPoint,QPoint)
            int cppResult = ::QPoint::dotProduct(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPointFunc_dotProduct_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QPoint *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc_manhattanLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.manhattanLength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // manhattanLength()const
            int cppResult = const_cast<const ::QPoint *>(cppSelf)->manhattanLength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc_setX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.setX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::setX(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setX(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc_setX_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setX(int)
            cppSelf->setX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPointFunc_setX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc_setY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.setY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::setY(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setY(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc_setY_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setY(int)
            cppSelf->setY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPointFunc_setY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc_toTuple(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.toTuple";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTuple()
            // Begin code injection
            // TEMPLATE - to_tuple - START
            pyResult = Py_BuildValue("ii", cppSelf->x(), cppSelf->y());
            // TEMPLATE - to_tuple - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc_transposed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.transposed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transposed()const
            QPoint cppResult = const_cast<const ::QPoint *>(cppSelf)->transposed();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            int cppResult = const_cast<const ::QPoint *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            int cppResult = const_cast<const ::QPoint *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPoint___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPoint_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPoint_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QPointFunc___reduce__), METH_NOARGS},
    {"dotProduct", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_dotProduct), METH_VARARGS|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_isNull), METH_NOARGS},
    {"manhattanLength", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_manhattanLength), METH_NOARGS},
    {"setX", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_setX), METH_O},
    {"setY", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_setY), METH_O},
    {"toTuple", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_toTuple), METH_NOARGS},
    {"transposed", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_transposed), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QPointFunc_y), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPoint___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPoint___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QPointFunc___mul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__mul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator*(QPoint,double)
    // 1: QPoint::operator*(double,QPoint)
    // 2: QPoint::operator*(QPoint,float)
    // 3: QPoint::operator*(float,QPoint)
    // 4: QPoint::operator*(int,QPoint)
    // 5: QPoint::operator*(QPoint,int)
    if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 4; // operator*(int,QPoint)
    } else if (isReverse
        && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 3; // operator*(float,QPoint)
    } else if (!isReverse
        && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 2; // operator*(QPoint,float)
    } else if (isReverse
        && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 1; // operator*(double,QPoint)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 5; // operator*(QPoint,int)
    } else if (!isReverse
        && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // operator*(QPoint,double)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___mul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*(double factor)
        {
            double cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(QPoint,double)
                const QPoint cppResult = (*cppSelf) * cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator*(double factor)
        {
            double cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(double,QPoint) [reverse operator]
                const QPoint cppResult = cppArg0 * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 2: // operator*(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(QPoint,float)
                const QPoint cppResult = (*cppSelf) * cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 3: // operator*(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(float,QPoint) [reverse operator]
                const QPoint cppResult = cppArg0 * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 4: // operator*(int factor)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(int,QPoint) [reverse operator]
                const QPoint cppResult = cppArg0 * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 5: // operator*(int factor)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(QPoint,int)
                const QPoint cppResult = (*cppSelf) * cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPointFunc___mul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___imul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__imul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator*=(double)
    // 1: QPoint::operator*=(float)
    // 2: QPoint::operator*=(int)
    if (!isReverse
        && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 1; // operator*=(float)
    } else if (!isReverse
        && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // operator*=(double)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 2; // operator*=(int)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___imul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*=(double factor)
        {
            double cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*=(double)
                (*cppSelf) *= cppArg0;
            }
            break;
        }
        case 1: // operator*=(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*=(float)
                (*cppSelf) *= cppArg0;
            }
            break;
        }
        case 2: // operator*=(int factor)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*=(int)
                (*cppSelf) *= cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QPointFunc___imul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___pos__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__pos__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operator+(QPoint)
            const QPoint cppResult = + (*cppSelf);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator+(QPoint,QPoint)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // operator+(QPoint,QPoint)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___add___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+(QPoint,QPoint)
            const QPoint cppResult = (*cppSelf) + (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPointFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator+=(QPoint)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QPoint)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___iadd___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+=(QPoint)
            (*cppSelf) += (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QPointFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___neg__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__neg__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operator-(QPoint)
            const QPoint cppResult = - (*cppSelf);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointFunc___sub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__sub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator-(QPoint,QPoint)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // operator-(QPoint,QPoint)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___sub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-(QPoint,QPoint)
            const QPoint cppResult = (*cppSelf) - (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPointFunc___sub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator-=(QPoint)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // operator-=(QPoint)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___isub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-=(QPoint)
            (*cppSelf) -= (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QPointFunc___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___div__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__div__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator/(QPoint,qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // operator/(QPoint,qreal)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___div___TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/(QPoint,qreal)
            const QPoint cppResult = (*cppSelf) / cppArg0;
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPointFunc___div___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointFunc___idiv__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QPoint.__idiv__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPoint::operator/=(qreal)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // operator/=(qreal)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointFunc___idiv___TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/=(qreal)
            (*cppSelf) /= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QPointFunc___idiv___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QPoint_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
                // operator!=(const QPoint & p2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPoint cppArg0_local;
                ::QPoint *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
                // operator==(const QPoint & p2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPoint cppArg0_local;
                ::QPoint *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPoint_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPoint_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QPoint_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(PySide::hash(*cppSelf));
}

static int Sbk_QPoint_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPoint_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPoint_Type = nullptr;
static SbkObjectType *Sbk_QPoint_TypeF(void)
{
    return _Sbk_QPoint_Type;
}

static PyType_Slot Sbk_QPoint_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QPointFunc___repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QPoint_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPoint_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPoint_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPoint_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPoint_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPoint_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_multiply, (void *)Sbk_QPointFunc___imul__},
    {Py_nb_inplace_add, (void *)Sbk_QPointFunc___iadd__},
    {Py_nb_positive, (void *)Sbk_QPointFunc___pos__},
    {Py_nb_multiply, (void *)Sbk_QPointFunc___mul__},
    {Py_nb_add, (void *)Sbk_QPointFunc___add__},
    {Py_nb_inplace_subtract, (void *)Sbk_QPointFunc___isub__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QPoint___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QPoint___nb_bool},
#endif
    {Py_nb_subtract, (void *)Sbk_QPointFunc___sub__},
    {Py_nb_negative, (void *)Sbk_QPointFunc___neg__},
    {Py_nb_true_divide, (void *)Sbk_QPointFunc___div__},
#ifndef IS_PY3K
    {Py_nb_divide, (void *)Sbk_QPointFunc___div__},
#endif
    // This function is unused in Python 3. We reference it here.
    {0, (void *)Sbk_QPointFunc___idiv__},
    // This list is ending at the first 0 entry.
    // Therefore, we need to put the unused functions at the very end.
    {0, nullptr}
};
static PyType_Spec Sbk_QPoint_spec = {
    "2:PySide2.QtCore.QPoint",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPoint_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPoint_PythonToCpp_QPoint_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPoint_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPoint_PythonToCpp_QPoint_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPoint_TypeF())))
        return QPoint_PythonToCpp_QPoint_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPoint_PTR_CppToPython_QPoint(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPoint *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPoint_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPoint_COPY_CppToPython_QPoint(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPoint_TypeF(), new ::QPoint(*reinterpret_cast<const ::QPoint *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPoint_PythonToCpp_QPoint_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPoint *>(cppOut) = *reinterpret_cast< ::QPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPoint_PythonToCpp_QPoint_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPoint_TypeF())))
        return QPoint_PythonToCpp_QPoint_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPoint_SignatureStrings[] = {
    "2:PySide2.QtCore.QPoint(self)",
    "1:PySide2.QtCore.QPoint(self,QPoint:PySide2.QtCore.QPoint)",
    "0:PySide2.QtCore.QPoint(self,xpos:int,ypos:int)",
    "PySide2.QtCore.QPoint.__reduce__(self)->PyObject",
    "PySide2.QtCore.QPoint.__repr__(self)->PyObject",
    "PySide2.QtCore.QPoint.dotProduct(p1:PySide2.QtCore.QPoint,p2:PySide2.QtCore.QPoint)->int",
    "PySide2.QtCore.QPoint.isNull(self)->bool",
    "PySide2.QtCore.QPoint.manhattanLength(self)->int",
    "PySide2.QtCore.QPoint.setX(self,x:int)",
    "PySide2.QtCore.QPoint.setY(self,y:int)",
    "PySide2.QtCore.QPoint.toTuple(self)->PyObject",
    "PySide2.QtCore.QPoint.transposed(self)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.x(self)->int",
    "PySide2.QtCore.QPoint.y(self)->int",
    "PySide2.QtCore.QPoint.__copy__()",
    "5:PySide2.QtCore.QPoint.__mul__(self,factor:double)->PySide2.QtCore.QPoint",
    "4:PySide2.QtCore.QPoint.__mul__(self,factor:double)->PySide2.QtCore.QPoint",
    "3:PySide2.QtCore.QPoint.__mul__(self,factor:float)->PySide2.QtCore.QPoint",
    "2:PySide2.QtCore.QPoint.__mul__(self,factor:float)->PySide2.QtCore.QPoint",
    "1:PySide2.QtCore.QPoint.__mul__(self,factor:int)->PySide2.QtCore.QPoint",
    "0:PySide2.QtCore.QPoint.__mul__(self,factor:int)->PySide2.QtCore.QPoint",
    "2:PySide2.QtCore.QPoint.__imul__(self,factor:double)->PySide2.QtCore.QPoint",
    "1:PySide2.QtCore.QPoint.__imul__(self,factor:float)->PySide2.QtCore.QPoint",
    "0:PySide2.QtCore.QPoint.__imul__(self,factor:int)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__pos__(self)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__add__(self,p2:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__iadd__(self,p:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__neg__(self)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__sub__(self,p2:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__isub__(self,p:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__div__(self,c:qreal)->PySide2.QtCore.QPoint",
    "PySide2.QtCore.QPoint.__idiv__(self,divisor:qreal)->PySide2.QtCore.QPoint",
    nullptr}; // Sentinel

void init_QPoint(PyObject *module)
{
    _Sbk_QPoint_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPoint",
        "QPoint",
        &Sbk_QPoint_spec,
        &Shiboken::callCppDestructor< ::QPoint >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPoint_Type);
    InitSignatureStrings(pyType, QPoint_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPoint_Type), Sbk_QPoint_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPoint_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPoint_TypeF(),
        QPoint_PythonToCpp_QPoint_PTR,
        is_QPoint_PythonToCpp_QPoint_PTR_Convertible,
        QPoint_PTR_CppToPython_QPoint,
        QPoint_COPY_CppToPython_QPoint);

    Shiboken::Conversions::registerConverterName(converter, "QPoint");
    Shiboken::Conversions::registerConverterName(converter, "QPoint*");
    Shiboken::Conversions::registerConverterName(converter, "QPoint&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPoint).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPoint_PythonToCpp_QPoint_COPY,
        is_QPoint_PythonToCpp_QPoint_COPY_Convertible);



    qRegisterMetaType< ::QPoint >("QPoint");
}

