/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qrandomgenerator64_wrapper.h"

// inner classes

// Extra includes
#include <qrandom.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRandomGenerator64_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRandomGenerator64 >()))
        return -1;

    ::QRandomGenerator64 *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRandomGenerator64_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QRandomGenerator64", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QRandomGenerator64::QRandomGenerator64(QRandomGenerator)
    // 1: QRandomGenerator64::QRandomGenerator64(const quint32*,const quint32*)
    // 2: QRandomGenerator64::QRandomGenerator64(const quint32*,long long)
    // 3: QRandomGenerator64::QRandomGenerator64(quint32)
    if (numArgs == 0) {
        overloadId = 3; // QRandomGenerator64(quint32)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QRandomGenerator64(quint32)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
            overloadId = 2; // QRandomGenerator64(const quint32*,long long)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1])))) {
            overloadId = 1; // QRandomGenerator64(const quint32*,const quint32*)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QRandomGenerator64(QRandomGenerator)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRandomGenerator64_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRandomGenerator64(const QRandomGenerator & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRandomGenerator64_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRandomGenerator *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QRandomGenerator64(QRandomGenerator)
                cptr = new ::QRandomGenerator64(*cppArg0);
            }
            break;
        }
        case 1: // QRandomGenerator64(const quint32 * begin, const quint32 * end)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRandomGenerator64_Init_TypeError;
            }
            quint32 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint32 *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRandomGenerator64(const quint32*,const quint32*)
                cptr = new ::QRandomGenerator64(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QRandomGenerator64(const quint32 * seedBuffer, long long len)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRandomGenerator64_Init_TypeError;
            }
            quint32 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRandomGenerator64(const quint32*,long long)
                cptr = new ::QRandomGenerator64(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QRandomGenerator64(quint32 seedValue)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_seedValue = Shiboken::String::createStaticString("seedValue");
                if (PyDict_Contains(kwds, key_seedValue)) {
                    value = PyDict_GetItem(kwds, key_seedValue);
                    if (value && pyArgs[0]) {
                        errInfo = key_seedValue;
                        Py_INCREF(errInfo);
                        goto Sbk_QRandomGenerator64_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0]))))
                            goto Sbk_QRandomGenerator64_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_seedValue);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRandomGenerator64_Init_TypeError;
                }
            }
            quint32 cppArg0 = 1;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QRandomGenerator64(quint32)
                cptr = new ::QRandomGenerator64(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRandomGenerator64 >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRandomGenerator64_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRandomGenerator64_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRandomGenerator64Func_discard(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator64 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR64_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.discard";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRandomGenerator::discard(unsigned long long)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // discard(unsigned long long)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRandomGenerator64Func_discard_TypeError;

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // discard(unsigned long long)
            cppSelf->discard(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRandomGenerator64Func_discard_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRandomGenerator64Func_generate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator64 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR64_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.generate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generate()
            quint64 cppResult = cppSelf->generate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGenerator64Func_global_(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.global_";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // global()
            QRandomGenerator64 * cppResult = ::QRandomGenerator64::global();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR64_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGenerator64Func_max(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.max";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // max()
            unsigned long long cppResult = ::QRandomGenerator64::max();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGenerator64Func_min(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.min";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // min()
            unsigned long long cppResult = ::QRandomGenerator64::min();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGenerator64Func_securelySeeded(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.securelySeeded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // securelySeeded()
            QRandomGenerator64* cppResult = new QRandomGenerator64(::QRandomGenerator64::securelySeeded());
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR64_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGenerator64Func_system(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator64.system";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // system()
            QRandomGenerator64 * cppResult = ::QRandomGenerator64::system();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR64_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRandomGenerator64_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRandomGenerator64_methods[] = {
    {"discard", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_discard), METH_O},
    {"generate", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_generate), METH_NOARGS},
    {"global_", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_global_), METH_NOARGS|METH_STATIC},
    {"max", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_max), METH_NOARGS|METH_STATIC},
    {"min", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_min), METH_NOARGS|METH_STATIC},
    {"securelySeeded", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_securelySeeded), METH_NOARGS|METH_STATIC},
    {"system", reinterpret_cast<PyCFunction>(Sbk_QRandomGenerator64Func_system), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QRandomGenerator64_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRandomGenerator64_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRandomGenerator64_Type = nullptr;
static SbkObjectType *Sbk_QRandomGenerator64_TypeF(void)
{
    return _Sbk_QRandomGenerator64_Type;
}

static PyType_Slot Sbk_QRandomGenerator64_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRandomGenerator64_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRandomGenerator64_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRandomGenerator64_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRandomGenerator64_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRandomGenerator64_spec = {
    "2:PySide2.QtCore.QRandomGenerator64",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRandomGenerator64_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRandomGenerator64_PythonToCpp_QRandomGenerator64_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRandomGenerator64_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRandomGenerator64_PythonToCpp_QRandomGenerator64_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRandomGenerator64_TypeF())))
        return QRandomGenerator64_PythonToCpp_QRandomGenerator64_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRandomGenerator64_PTR_CppToPython_QRandomGenerator64(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRandomGenerator64 *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRandomGenerator64_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRandomGenerator64_SignatureStrings[] = {
    "3:PySide2.QtCore.QRandomGenerator64(self,other:PySide2.QtCore.QRandomGenerator)",
    "2:PySide2.QtCore.QRandomGenerator64(self,begin:quint32*,end:quint32*)",
    "1:PySide2.QtCore.QRandomGenerator64(self,seedBuffer:quint32*,len:long long)",
    "0:PySide2.QtCore.QRandomGenerator64(self,seedValue:quint32=1)",
    "PySide2.QtCore.QRandomGenerator64.discard(self,z:unsigned long long)",
    "PySide2.QtCore.QRandomGenerator64.generate(self)->quint64",
    "PySide2.QtCore.QRandomGenerator64.global_()->PySide2.QtCore.QRandomGenerator64",
    "PySide2.QtCore.QRandomGenerator64.max()->unsigned long long",
    "PySide2.QtCore.QRandomGenerator64.min()->unsigned long long",
    "PySide2.QtCore.QRandomGenerator64.securelySeeded()->PySide2.QtCore.QRandomGenerator64",
    "PySide2.QtCore.QRandomGenerator64.system()->PySide2.QtCore.QRandomGenerator64",
    nullptr}; // Sentinel

void init_QRandomGenerator64(PyObject *module)
{
    _Sbk_QRandomGenerator64_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRandomGenerator64",
        "QRandomGenerator64*",
        &Sbk_QRandomGenerator64_spec,
        &Shiboken::callCppDestructor< ::QRandomGenerator64 >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRandomGenerator64_Type);
    InitSignatureStrings(pyType, QRandomGenerator64_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRandomGenerator64_Type), Sbk_QRandomGenerator64_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR64_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRandomGenerator64_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRandomGenerator64_TypeF(),
        QRandomGenerator64_PythonToCpp_QRandomGenerator64_PTR,
        is_QRandomGenerator64_PythonToCpp_QRandomGenerator64_PTR_Convertible,
        QRandomGenerator64_PTR_CppToPython_QRandomGenerator64);

    Shiboken::Conversions::registerConverterName(converter, "QRandomGenerator64");
    Shiboken::Conversions::registerConverterName(converter, "QRandomGenerator64*");
    Shiboken::Conversions::registerConverterName(converter, "QRandomGenerator64&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRandomGenerator64).name());


}
