/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qreadlocker_wrapper.h"

// inner classes

// Extra includes
#include <qreadwritelock.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QReadLocker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QReadLocker >()))
        return -1;

    ::QReadLocker *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadLocker.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QReadLocker", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QReadLocker::QReadLocker(QReadWriteLock*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QReadLocker(QReadWriteLock*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QReadLocker_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QReadWriteLock *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QReadLocker(QReadWriteLock*)
            cptr = new ::QReadLocker(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "QReadLocker(QReadWriteLock*)1", pyArgs[0]);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QReadLocker >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QReadLocker_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QReadLocker_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QReadLockerFunc___enter__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadLocker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADLOCKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadLocker.__enter__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __enter__()
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QReadLockerFunc___exit__(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadLocker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADLOCKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadLocker.__exit__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "__exit__", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QReadLocker::__exit__(PyObject*,PyObject*,PyObject*)
    if (numArgs == 3
        && PyObject_Check(pyArgs[0])
        && PyObject_Check(pyArgs[1])
        && PyObject_Check(pyArgs[2])) {
        overloadId = 0; // __exit__(PyObject*,PyObject*,PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QReadLockerFunc___exit___TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __exit__(PyObject*,PyObject*,PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (unlock)]
            cppSelf->unlock();
            // END of custom code block [file: ../glue/qtcore.cpp (unlock)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QReadLockerFunc___exit___TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QReadLockerFunc_readWriteLock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadLocker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADLOCKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadLocker.readWriteLock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readWriteLock()const
            QReadWriteLock * cppResult = const_cast<const ::QReadLocker *>(cppSelf)->readWriteLock();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QReadLockerFunc_relock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadLocker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADLOCKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadLocker.relock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // relock()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->relock();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QReadLockerFunc_unlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadLocker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADLOCKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadLocker.unlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unlock()
            cppSelf->unlock();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QReadLocker_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QReadLocker_methods[] = {
    {"__enter__", reinterpret_cast<PyCFunction>(Sbk_QReadLockerFunc___enter__), METH_NOARGS},
    {"__exit__", reinterpret_cast<PyCFunction>(Sbk_QReadLockerFunc___exit__), METH_VARARGS},
    {"readWriteLock", reinterpret_cast<PyCFunction>(Sbk_QReadLockerFunc_readWriteLock), METH_NOARGS},
    {"relock", reinterpret_cast<PyCFunction>(Sbk_QReadLockerFunc_relock), METH_NOARGS},
    {"unlock", reinterpret_cast<PyCFunction>(Sbk_QReadLockerFunc_unlock), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QReadLocker_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QReadLocker_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QReadLocker_Type = nullptr;
static SbkObjectType *Sbk_QReadLocker_TypeF(void)
{
    return _Sbk_QReadLocker_Type;
}

static PyType_Slot Sbk_QReadLocker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QReadLocker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QReadLocker_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QReadLocker_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QReadLocker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QReadLocker_spec = {
    "2:PySide2.QtCore.QReadLocker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QReadLocker_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QReadLocker_PythonToCpp_QReadLocker_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QReadLocker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QReadLocker_PythonToCpp_QReadLocker_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QReadLocker_TypeF())))
        return QReadLocker_PythonToCpp_QReadLocker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QReadLocker_PTR_CppToPython_QReadLocker(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QReadLocker *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QReadLocker_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QReadLocker_SignatureStrings[] = {
    "PySide2.QtCore.QReadLocker(self,readWriteLock:PySide2.QtCore.QReadWriteLock)",
    "PySide2.QtCore.QReadLocker.__enter__(self)",
    "PySide2.QtCore.QReadLocker.__exit__(self,arg__1:PyObject,arg__2:PyObject,arg__3:PyObject)",
    "PySide2.QtCore.QReadLocker.readWriteLock(self)->PySide2.QtCore.QReadWriteLock",
    "PySide2.QtCore.QReadLocker.relock(self)",
    "PySide2.QtCore.QReadLocker.unlock(self)",
    nullptr}; // Sentinel

void init_QReadLocker(PyObject *module)
{
    _Sbk_QReadLocker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QReadLocker",
        "QReadLocker*",
        &Sbk_QReadLocker_spec,
        &Shiboken::callCppDestructor< ::QReadLocker >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QReadLocker_Type);
    InitSignatureStrings(pyType, QReadLocker_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QReadLocker_Type), Sbk_QReadLocker_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QREADLOCKER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QReadLocker_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QReadLocker_TypeF(),
        QReadLocker_PythonToCpp_QReadLocker_PTR,
        is_QReadLocker_PythonToCpp_QReadLocker_PTR_Convertible,
        QReadLocker_PTR_CppToPython_QReadLocker);

    Shiboken::Conversions::registerConverterName(converter, "QReadLocker");
    Shiboken::Conversions::registerConverterName(converter, "QReadLocker*");
    Shiboken::Conversions::registerConverterName(converter, "QReadLocker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QReadLocker).name());


}
