/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qregexp_wrapper.h"

// inner classes

// Extra includes
#include <QStringList>
#include <qregexp.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRegExp_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRegExp >()))
        return -1;

    ::QRegExp *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegExp_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QRegExp", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QRegExp::QRegExp()
    // 1: QRegExp::QRegExp(QRegExp)
    // 2: QRegExp::QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
    if (numArgs == 0) {
        overloadId = 0; // QRegExp()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])->converter, (pyArgs[2])))) {
                overloadId = 2; // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QRegExp(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExp_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRegExp()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegExp_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QRegExp()
                cptr = new ::QRegExp();
            }
            break;
        }
        case 1: // QRegExp(const QRegExp & rx)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegExp_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRegExp cppArg0_local;
            ::QRegExp *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRegExp(QRegExp)
                cptr = new ::QRegExp(*cppArg0);
            }
            break;
        }
        case 2: // QRegExp(const QString & pattern, Qt::CaseSensitivity cs, QRegExp::PatternSyntax syntax)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_cs = Shiboken::String::createStaticString("cs");
                if (PyDict_Contains(kwds, key_cs)) {
                    value = PyDict_GetItem(kwds, key_cs);
                    if (value && pyArgs[1]) {
                        errInfo = key_cs;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegExp_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QRegExp_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cs);
                }
                static PyObject *const key_syntax = Shiboken::String::createStaticString("syntax");
                if (PyDict_Contains(kwds, key_syntax)) {
                    value = PyDict_GetItem(kwds, key_syntax);
                    if (value && pyArgs[2]) {
                        errInfo = key_syntax;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegExp_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRegExp_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_syntax);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegExp_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::CaseSensitivity cppArg1 = Qt::CaseSensitive;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QRegExp::PatternSyntax cppArg2 = QRegExp::PatternSyntax::RegExp;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
                cptr = new ::QRegExp(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRegExp >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRegExp_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRegExp_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRegExpFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(sii))", PyObject_Type(self), qPrintable(cppSelf->pattern()), (int)cppSelf->caseSensitivity(), (int)cppSelf->patternSyntax());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s('%s', %i, %i)",
                Py_TYPE(self)->tp_name, qPrintable(cppSelf->pattern()), (int)cppSelf->caseSensitivity(), (int)cppSelf->patternSyntax());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_cap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.cap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegExpFunc_cap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:cap", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegExp::cap(int)
    if (numArgs == 0) {
        overloadId = 0; // cap(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // cap(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_cap_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
            if (PyDict_Contains(kwds, key_nth)) {
                value = PyDict_GetItem(kwds, key_nth);
                if (value && pyArgs[0]) {
                    errInfo = key_nth;
                    Py_INCREF(errInfo);
                    goto Sbk_QRegExpFunc_cap_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QRegExpFunc_cap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_nth);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRegExpFunc_cap_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // cap(int)
            QString cppResult = cppSelf->cap(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_cap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_captureCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.captureCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // captureCount()const
            int cppResult = const_cast<const ::QRegExp *>(cppSelf)->captureCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_capturedTexts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.capturedTexts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capturedTexts()
            QStringList cppResult = cppSelf->capturedTexts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_caseSensitivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.caseSensitivity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // caseSensitivity()const
            Qt::CaseSensitivity cppResult = const_cast<const ::QRegExp *>(cppSelf)->caseSensitivity();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()
            QString cppResult = cppSelf->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_escape(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.escape";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QRegExp::escape(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // escape(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_escape_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // escape(QString)
            QString cppResult = ::QRegExp::escape(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_escape_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_exactMatch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.exactMatch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegExp::exactMatch(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // exactMatch(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_exactMatch_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // exactMatch(QString)const
            bool cppResult = const_cast<const ::QRegExp *>(cppSelf)->exactMatch(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_exactMatch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_indexIn(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.indexIn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegExpFunc_indexIn_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRegExpFunc_indexIn_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:indexIn", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRegExp::indexIn(QString,int,QRegExp::CaretMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // indexIn(QString,int,QRegExp::CaretMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // indexIn(QString,int,QRegExp::CaretMode)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // indexIn(QString,int,QRegExp::CaretMode)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_indexIn_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
            if (PyDict_Contains(kwds, key_offset)) {
                value = PyDict_GetItem(kwds, key_offset);
                if (value && pyArgs[1]) {
                    errInfo = key_offset;
                    Py_INCREF(errInfo);
                    goto Sbk_QRegExpFunc_indexIn_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QRegExpFunc_indexIn_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_offset);
            }
            static PyObject *const key_caretMode = Shiboken::String::createStaticString("caretMode");
            if (PyDict_Contains(kwds, key_caretMode)) {
                value = PyDict_GetItem(kwds, key_caretMode);
                if (value && pyArgs[2]) {
                    errInfo = key_caretMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QRegExpFunc_indexIn_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QRegExpFunc_indexIn_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caretMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRegExpFunc_indexIn_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QRegExp::CaretMode cppArg2 = QRegExp::CaretMode::CaretAtZero;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // indexIn(QString,int,QRegExp::CaretMode)const
            int cppResult = const_cast<const ::QRegExp *>(cppSelf)->indexIn(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_indexIn_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QRegExp *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_isMinimal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.isMinimal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMinimal()const
            bool cppResult = const_cast<const ::QRegExp *>(cppSelf)->isMinimal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QRegExp *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_lastIndexIn(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.lastIndexIn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:lastIndexIn", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRegExp::lastIndexIn(QString,int,QRegExp::CaretMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // lastIndexIn(QString,int,QRegExp::CaretMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // lastIndexIn(QString,int,QRegExp::CaretMode)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // lastIndexIn(QString,int,QRegExp::CaretMode)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_lastIndexIn_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
            if (PyDict_Contains(kwds, key_offset)) {
                value = PyDict_GetItem(kwds, key_offset);
                if (value && pyArgs[1]) {
                    errInfo = key_offset;
                    Py_INCREF(errInfo);
                    goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_offset);
            }
            static PyObject *const key_caretMode = Shiboken::String::createStaticString("caretMode");
            if (PyDict_Contains(kwds, key_caretMode)) {
                value = PyDict_GetItem(kwds, key_caretMode);
                if (value && pyArgs[2]) {
                    errInfo = key_caretMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caretMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRegExpFunc_lastIndexIn_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QRegExp::CaretMode cppArg2 = QRegExp::CaretMode::CaretAtZero;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // lastIndexIn(QString,int,QRegExp::CaretMode)const
            int cppResult = const_cast<const ::QRegExp *>(cppSelf)->lastIndexIn(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_lastIndexIn_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_matchedLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.matchedLength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matchedLength()const
            int cppResult = const_cast<const ::QRegExp *>(cppSelf)->matchedLength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_pattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.pattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pattern()const
            QString cppResult = const_cast<const ::QRegExp *>(cppSelf)->pattern();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_patternSyntax(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.patternSyntax";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // patternSyntax()const
            QRegExp::PatternSyntax cppResult = const_cast<const ::QRegExp *>(cppSelf)->patternSyntax();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegExpFunc_pos(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.pos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegExpFunc_pos_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:pos", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegExp::pos(int)
    if (numArgs == 0) {
        overloadId = 0; // pos(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // pos(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_pos_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
            if (PyDict_Contains(kwds, key_nth)) {
                value = PyDict_GetItem(kwds, key_nth);
                if (value && pyArgs[0]) {
                    errInfo = key_nth;
                    Py_INCREF(errInfo);
                    goto Sbk_QRegExpFunc_pos_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QRegExpFunc_pos_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_nth);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRegExpFunc_pos_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // pos(int)
            int cppResult = cppSelf->pos(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_pos_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_replace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRegExp::replace(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // replace(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_replace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        SBK_UNUSED(cppArg1)

        if (!PyErr_Occurred()) {
            // replace(QString,QString)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qregexp-replace)]
            cppArg0.replace(*cppSelf, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg0);
            // END of custom code block [file: ../glue/qtcore.cpp (qregexp-replace)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegExpFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_setCaseSensitivity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.setCaseSensitivity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegExp::setCaseSensitivity(Qt::CaseSensitivity)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCaseSensitivity(Qt::CaseSensitivity)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_setCaseSensitivity_TypeError;

    // Call function/method
    {
        ::Qt::CaseSensitivity cppArg0{Qt::CaseInsensitive};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCaseSensitivity(Qt::CaseSensitivity)
            cppSelf->setCaseSensitivity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegExpFunc_setCaseSensitivity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_setMinimal(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.setMinimal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegExp::setMinimal(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMinimal(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_setMinimal_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinimal(bool)
            cppSelf->setMinimal(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegExpFunc_setMinimal_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_setPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.setPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegExp::setPattern(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPattern(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_setPattern_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPattern(QString)
            cppSelf->setPattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegExpFunc_setPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_setPatternSyntax(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.setPatternSyntax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegExp::setPatternSyntax(QRegExp::PatternSyntax)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPatternSyntax(QRegExp::PatternSyntax)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_setPatternSyntax_TypeError;

    // Call function/method
    {
        ::QRegExp::PatternSyntax cppArg0{QRegExp::RegExp};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPatternSyntax(QRegExp::PatternSyntax)
            cppSelf->setPatternSyntax(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegExpFunc_setPatternSyntax_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExpFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegExp.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegExp::swap(QRegExp&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QRegExp&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegExpFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QRegExp&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegExpFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegExp___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRegExp_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRegExp_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc___reduce__), METH_NOARGS},
    {"cap", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_cap), METH_VARARGS|METH_KEYWORDS},
    {"captureCount", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_captureCount), METH_NOARGS},
    {"capturedTexts", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_capturedTexts), METH_NOARGS},
    {"caseSensitivity", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_caseSensitivity), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_errorString), METH_NOARGS},
    {"escape", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_escape), METH_O|METH_STATIC},
    {"exactMatch", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_exactMatch), METH_O},
    {"indexIn", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_indexIn), METH_VARARGS|METH_KEYWORDS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_isEmpty), METH_NOARGS},
    {"isMinimal", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_isMinimal), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_isValid), METH_NOARGS},
    {"lastIndexIn", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_lastIndexIn), METH_VARARGS|METH_KEYWORDS},
    {"matchedLength", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_matchedLength), METH_NOARGS},
    {"pattern", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_pattern), METH_NOARGS},
    {"patternSyntax", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_patternSyntax), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_pos), METH_VARARGS|METH_KEYWORDS},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_replace), METH_VARARGS},
    {"setCaseSensitivity", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_setCaseSensitivity), METH_O},
    {"setMinimal", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_setMinimal), METH_O},
    {"setPattern", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_setPattern), METH_O},
    {"setPatternSyntax", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_setPatternSyntax), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QRegExpFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QRegExp___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QRegExp_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
                // operator!=(const QRegExp & rx) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegExp cppArg0_local;
                ::QRegExp *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
                // operator==(const QRegExp & rx) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegExp cppArg0_local;
                ::QRegExp *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QRegExp_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QRegExp_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QRegExp_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRegExp_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRegExp_Type = nullptr;
static SbkObjectType *Sbk_QRegExp_TypeF(void)
{
    return _Sbk_QRegExp_Type;
}

static PyType_Slot Sbk_QRegExp_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QRegExpFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRegExp_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRegExp_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QRegExp_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRegExp_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRegExp_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRegExp_spec = {
    "2:PySide2.QtCore.QRegExp",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRegExp_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QRegExp_PatternSyntax_PythonToCpp_QRegExp_PatternSyntax(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegExp::PatternSyntax *>(cppOut) =
        static_cast<::QRegExp::PatternSyntax>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRegExp_PatternSyntax_PythonToCpp_QRegExp_PatternSyntax_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX]))
        return QRegExp_PatternSyntax_PythonToCpp_QRegExp_PatternSyntax;
    return {};
}
static PyObject *QRegExp_PatternSyntax_CppToPython_QRegExp_PatternSyntax(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRegExp::PatternSyntax *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX], castCppIn);

}

static void QRegExp_CaretMode_PythonToCpp_QRegExp_CaretMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegExp::CaretMode *>(cppOut) =
        static_cast<::QRegExp::CaretMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRegExp_CaretMode_PythonToCpp_QRegExp_CaretMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX]))
        return QRegExp_CaretMode_PythonToCpp_QRegExp_CaretMode;
    return {};
}
static PyObject *QRegExp_CaretMode_CppToPython_QRegExp_CaretMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRegExp::CaretMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRegExp_PythonToCpp_QRegExp_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRegExp_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRegExp_PythonToCpp_QRegExp_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegExp_TypeF())))
        return QRegExp_PythonToCpp_QRegExp_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRegExp_PTR_CppToPython_QRegExp(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRegExp *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRegExp_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRegExp_COPY_CppToPython_QRegExp(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QRegExp_TypeF(), new ::QRegExp(*reinterpret_cast<const ::QRegExp *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRegExp_PythonToCpp_QRegExp_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegExp *>(cppOut) = *reinterpret_cast< ::QRegExp *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRegExp_PythonToCpp_QRegExp_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegExp_TypeF())))
        return QRegExp_PythonToCpp_QRegExp_COPY;
    return {};
}

// Implicit conversions.
static void constQStringREF_PythonToCpp_QRegExp(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QRegExp *>(cppOut) = ::QRegExp(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QRegExp_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QRegExp;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRegExp_SignatureStrings[] = {
    "2:PySide2.QtCore.QRegExp(self)",
    "1:PySide2.QtCore.QRegExp(self,rx:PySide2.QtCore.QRegExp)",
    "0:PySide2.QtCore.QRegExp(self,pattern:QString,cs:PySide2.QtCore.Qt.CaseSensitivity=Qt.CaseSensitive,syntax:PySide2.QtCore.QRegExp.PatternSyntax=RegExp)",
    "PySide2.QtCore.QRegExp.__reduce__(self)->PyObject",
    "PySide2.QtCore.QRegExp.__repr__(self)->PyObject",
    "1:PySide2.QtCore.QRegExp.cap(self,nth:int=0)->QString",
    "0:PySide2.QtCore.QRegExp.cap(self,nth:int=0)->QString",
    "PySide2.QtCore.QRegExp.captureCount(self)->int",
    "1:PySide2.QtCore.QRegExp.capturedTexts(self)->QStringList",
    "0:PySide2.QtCore.QRegExp.capturedTexts(self)->QStringList",
    "PySide2.QtCore.QRegExp.caseSensitivity(self)->PySide2.QtCore.Qt.CaseSensitivity",
    "1:PySide2.QtCore.QRegExp.errorString(self)->QString",
    "0:PySide2.QtCore.QRegExp.errorString(self)->QString",
    "PySide2.QtCore.QRegExp.escape(str:QString)->QString",
    "PySide2.QtCore.QRegExp.exactMatch(self,str:QString)->bool",
    "PySide2.QtCore.QRegExp.indexIn(self,str:QString,offset:int=0,caretMode:PySide2.QtCore.QRegExp.CaretMode=CaretAtZero)->int",
    "PySide2.QtCore.QRegExp.isEmpty(self)->bool",
    "PySide2.QtCore.QRegExp.isMinimal(self)->bool",
    "PySide2.QtCore.QRegExp.isValid(self)->bool",
    "PySide2.QtCore.QRegExp.lastIndexIn(self,str:QString,offset:int=-1,caretMode:PySide2.QtCore.QRegExp.CaretMode=CaretAtZero)->int",
    "PySide2.QtCore.QRegExp.matchedLength(self)->int",
    "PySide2.QtCore.QRegExp.pattern(self)->QString",
    "PySide2.QtCore.QRegExp.patternSyntax(self)->PySide2.QtCore.QRegExp.PatternSyntax",
    "1:PySide2.QtCore.QRegExp.pos(self,nth:int=0)->int",
    "0:PySide2.QtCore.QRegExp.pos(self,nth:int=0)->int",
    "PySide2.QtCore.QRegExp.replace(self,sourceString:QString,after:QString)->QString",
    "PySide2.QtCore.QRegExp.setCaseSensitivity(self,cs:PySide2.QtCore.Qt.CaseSensitivity)",
    "PySide2.QtCore.QRegExp.setMinimal(self,minimal:bool)",
    "PySide2.QtCore.QRegExp.setPattern(self,pattern:QString)",
    "PySide2.QtCore.QRegExp.setPatternSyntax(self,syntax:PySide2.QtCore.QRegExp.PatternSyntax)",
    "PySide2.QtCore.QRegExp.swap(self,other:PySide2.QtCore.QRegExp)",
    "PySide2.QtCore.QRegExp.__copy__()",
    nullptr}; // Sentinel

void init_QRegExp(PyObject *module)
{
    _Sbk_QRegExp_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRegExp",
        "QRegExp",
        &Sbk_QRegExp_spec,
        &Shiboken::callCppDestructor< ::QRegExp >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRegExp_Type);
    InitSignatureStrings(pyType, QRegExp_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRegExp_Type), Sbk_QRegExp_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRegExp_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRegExp_TypeF(),
        QRegExp_PythonToCpp_QRegExp_PTR,
        is_QRegExp_PythonToCpp_QRegExp_PTR_Convertible,
        QRegExp_PTR_CppToPython_QRegExp,
        QRegExp_COPY_CppToPython_QRegExp);

    Shiboken::Conversions::registerConverterName(converter, "QRegExp");
    Shiboken::Conversions::registerConverterName(converter, "QRegExp*");
    Shiboken::Conversions::registerConverterName(converter, "QRegExp&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRegExp).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRegExp_PythonToCpp_QRegExp_COPY,
        is_QRegExp_PythonToCpp_QRegExp_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QRegExp,
        is_constQStringREF_PythonToCpp_QRegExp_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PatternSyntax'.
    SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRegExp_TypeF(),
        "PatternSyntax",
        "2:PySide2.QtCore.QRegExp.PatternSyntax",
        "QRegExp::PatternSyntax");
    if (!SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
        Sbk_QRegExp_TypeF(), "RegExp", (long) QRegExp::PatternSyntax::RegExp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
        Sbk_QRegExp_TypeF(), "Wildcard", (long) QRegExp::PatternSyntax::Wildcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
        Sbk_QRegExp_TypeF(), "FixedString", (long) QRegExp::PatternSyntax::FixedString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
        Sbk_QRegExp_TypeF(), "RegExp2", (long) QRegExp::PatternSyntax::RegExp2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
        Sbk_QRegExp_TypeF(), "WildcardUnix", (long) QRegExp::PatternSyntax::WildcardUnix))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
        Sbk_QRegExp_TypeF(), "W3CXmlSchema11", (long) QRegExp::PatternSyntax::W3CXmlSchema11))
        return;
    // Register converter for enum 'QRegExp::PatternSyntax'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX],
            QRegExp_PatternSyntax_CppToPython_QRegExp_PatternSyntax);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegExp_PatternSyntax_PythonToCpp_QRegExp_PatternSyntax,
            is_QRegExp_PatternSyntax_PythonToCpp_QRegExp_PatternSyntax_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegExp::PatternSyntax");
        Shiboken::Conversions::registerConverterName(converter, "PatternSyntax");
    }
    // End of 'PatternSyntax' enum.

    // Initialization of enum 'CaretMode'.
    SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRegExp_TypeF(),
        "CaretMode",
        "2:PySide2.QtCore.QRegExp.CaretMode",
        "QRegExp::CaretMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX],
        Sbk_QRegExp_TypeF(), "CaretAtZero", (long) QRegExp::CaretMode::CaretAtZero))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX],
        Sbk_QRegExp_TypeF(), "CaretAtOffset", (long) QRegExp::CaretMode::CaretAtOffset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX],
        Sbk_QRegExp_TypeF(), "CaretWontMatch", (long) QRegExp::CaretMode::CaretWontMatch))
        return;
    // Register converter for enum 'QRegExp::CaretMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX],
            QRegExp_CaretMode_CppToPython_QRegExp_CaretMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegExp_CaretMode_PythonToCpp_QRegExp_CaretMode,
            is_QRegExp_CaretMode_PythonToCpp_QRegExp_CaretMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegExp::CaretMode");
        Shiboken::Conversions::registerConverterName(converter, "CaretMode");
    }
    // End of 'CaretMode' enum.

    qRegisterMetaType< ::QRegExp >("QRegExp");
    qRegisterMetaType< ::QRegExp::PatternSyntax >("QRegExp::PatternSyntax");
    qRegisterMetaType< ::QRegExp::CaretMode >("QRegExp::CaretMode");
}
