/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qsocketdescriptor_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtcore.cpp (qsocketdescriptor)]
#ifdef WIN32
using DescriptorType = Qt::HANDLE;
#else
using DescriptorType = int;
#endif
// END of custom code block [file: ../glue/qtcore.cpp (qsocketdescriptor)]
// ========================================================================

// End of code injection



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSocketDescriptor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSocketDescriptor >()))
        return -1;

    ::QSocketDescriptor *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSocketDescriptor.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSocketDescriptor_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QSocketDescriptor", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSocketDescriptor::QSocketDescriptor(QSocketDescriptor)
    // 1: QSocketDescriptor::QSocketDescriptor(int)
    if (numArgs == 0) {
        overloadId = 1; // QSocketDescriptor(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // QSocketDescriptor(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSocketDescriptor(QSocketDescriptor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSocketDescriptor_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSocketDescriptor(const QSocketDescriptor & QSocketDescriptor)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSocketDescriptor_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSocketDescriptor cppArg0_local;
            ::QSocketDescriptor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSocketDescriptor(QSocketDescriptor)
                cptr = new ::QSocketDescriptor(*cppArg0);
            }
            break;
        }
        case 1: // QSocketDescriptor(int descriptor)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_descriptor = Shiboken::String::createStaticString("descriptor");
                if (PyDict_Contains(kwds, key_descriptor)) {
                    value = PyDict_GetItem(kwds, key_descriptor);
                    if (value && pyArgs[0]) {
                        errInfo = key_descriptor;
                        Py_INCREF(errInfo);
                        goto Sbk_QSocketDescriptor_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QSocketDescriptor_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_descriptor);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSocketDescriptor_Init_TypeError;
                }
            }
            int cppArg0 = DescriptorType(-1);
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSocketDescriptor(int)
                cptr = new ::QSocketDescriptor(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSocketDescriptor >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSocketDescriptor_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSocketDescriptor_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSocketDescriptorFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSocketDescriptor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSocketDescriptor.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QSocketDescriptor *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSocketDescriptor___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSocketDescriptor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSocketDescriptor_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSocketDescriptor_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QSocketDescriptorFunc_isValid), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSocketDescriptor___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSocketDescriptor_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSocketDescriptor_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSocketDescriptor_Type = nullptr;
static SbkObjectType *Sbk_QSocketDescriptor_TypeF(void)
{
    return _Sbk_QSocketDescriptor_Type;
}

static PyType_Slot Sbk_QSocketDescriptor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSocketDescriptor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSocketDescriptor_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSocketDescriptor_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSocketDescriptor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSocketDescriptor_spec = {
    "2:PySide2.QtCore.QSocketDescriptor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSocketDescriptor_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSocketDescriptor_PythonToCpp_QSocketDescriptor_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSocketDescriptor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSocketDescriptor_PythonToCpp_QSocketDescriptor_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSocketDescriptor_TypeF())))
        return QSocketDescriptor_PythonToCpp_QSocketDescriptor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSocketDescriptor_PTR_CppToPython_QSocketDescriptor(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSocketDescriptor *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSocketDescriptor_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSocketDescriptor_COPY_CppToPython_QSocketDescriptor(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSocketDescriptor_TypeF(), new ::QSocketDescriptor(*reinterpret_cast<const ::QSocketDescriptor *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSocketDescriptor_PythonToCpp_QSocketDescriptor_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSocketDescriptor *>(cppOut) = *reinterpret_cast< ::QSocketDescriptor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSocketDescriptor_PythonToCpp_QSocketDescriptor_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSocketDescriptor_TypeF())))
        return QSocketDescriptor_PythonToCpp_QSocketDescriptor_COPY;
    return {};
}

// Implicit conversions.
static void int_PythonToCpp_QSocketDescriptor(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QSocketDescriptor *>(cppOut) = ::QSocketDescriptor(cppIn);
}
static PythonToCppFunc is_int_PythonToCpp_QSocketDescriptor_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return int_PythonToCpp_QSocketDescriptor;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSocketDescriptor_SignatureStrings[] = {
    "1:PySide2.QtCore.QSocketDescriptor(self,QSocketDescriptor:PySide2.QtCore.QSocketDescriptor)",
    "0:PySide2.QtCore.QSocketDescriptor(self,descriptor:int=DescriptorType(-1))",
    "PySide2.QtCore.QSocketDescriptor.isValid(self)->bool",
    "PySide2.QtCore.QSocketDescriptor.__copy__()",
    nullptr}; // Sentinel

void init_QSocketDescriptor(PyObject *module)
{
    _Sbk_QSocketDescriptor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSocketDescriptor",
        "QSocketDescriptor",
        &Sbk_QSocketDescriptor_spec,
        &Shiboken::callCppDestructor< ::QSocketDescriptor >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSocketDescriptor_Type);
    InitSignatureStrings(pyType, QSocketDescriptor_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSocketDescriptor_Type), Sbk_QSocketDescriptor_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSOCKETDESCRIPTOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSocketDescriptor_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSocketDescriptor_TypeF(),
        QSocketDescriptor_PythonToCpp_QSocketDescriptor_PTR,
        is_QSocketDescriptor_PythonToCpp_QSocketDescriptor_PTR_Convertible,
        QSocketDescriptor_PTR_CppToPython_QSocketDescriptor,
        QSocketDescriptor_COPY_CppToPython_QSocketDescriptor);

    Shiboken::Conversions::registerConverterName(converter, "QSocketDescriptor");
    Shiboken::Conversions::registerConverterName(converter, "QSocketDescriptor*");
    Shiboken::Conversions::registerConverterName(converter, "QSocketDescriptor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSocketDescriptor).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSocketDescriptor_PythonToCpp_QSocketDescriptor_COPY,
        is_QSocketDescriptor_PythonToCpp_QSocketDescriptor_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        int_PythonToCpp_QSocketDescriptor,
        is_int_PythonToCpp_QSocketDescriptor_Convertible);



}

