/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qstate_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QStateWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QStateWrapper::QStateWrapper(::QState * parent) : QState(parent)
{
    resetPyMethodCache();
    // ... middle
}

QStateWrapper::QStateWrapper(::QState::ChildMode childMode, ::QState * parent) : QState(childMode, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QStateWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStateWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStateWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QStateWrapper::event(::QEvent * e)
{
    if (m_PyMethodCache[4])
        return this->::QState::event(e);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QState::event(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QState.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QStateWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QState.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QStateWrapper::onEntry(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QState::onEntry(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "onEntry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QState::onEntry(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateWrapper::onExit(::QEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QState::onExit(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "onExit";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QState::onExit(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QStateWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QState::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QStateWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QState::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QStateWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QStateWrapper *>(this));
        return QState::qt_metacast(_clname);
}

QStateWrapper::~QStateWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QState_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QState >()))
        return -1;

    ::QStateWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QState", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QState::QState(QState*)
    // 1: QState::QState(QState::ChildMode,QState*)
    if (numArgs == 0) {
        overloadId = 0; // QState(QState*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QState(QState::ChildMode,QState*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QState(QState::ChildMode,QState*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QState(QState*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QState_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QState(QState * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QState_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX]), (pyArgs[0]))))
                            goto Sbk_QState_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QState *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QState(QState*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QStateWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QStateWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QState(QState::ChildMode childMode, QState * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QState_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX]), (pyArgs[1]))))
                            goto Sbk_QState_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QState::ChildMode cppArg0{QState::ExclusiveStates};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QState *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QState(QState::ChildMode,QState*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QStateWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QStateWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QState >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QState_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QState_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QState_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStateFunc_addTransition(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.addTransition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addTransition", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QState::addTransition(PyObject*,QAbstractState*)
    // 1: QState::addTransition(QAbstractState*)
    // 2: QState::addTransition(QAbstractTransition*)
    // 3: QState::addTransition(const QObject*,const char*,QAbstractState*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]), (pyArgs[0])))) {
        overloadId = 2; // addTransition(QAbstractTransition*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // addTransition(QAbstractState*)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArgs[2])))) {
        overloadId = 3; // addTransition(const QObject*,const char*,QAbstractState*)
    } else if (numArgs == 2
        && PyObject_Check(pyArgs[0])
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addTransition(PyObject*,QAbstractState*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_addTransition_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addTransition(PyObject * arg__1, QAbstractState * arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QAbstractState *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // addTransition(PyObject*,QAbstractState*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qstate-addtransition-2)]
                // Obviously the label used by the following goto is a very awkward solution,
                // since it refers to a name very tied to the generator implementation.
                // Check bug #362 for more information on this
                // http://bugs.openbossa.org/show_bug.cgi?id=362
                if (!PyObject_TypeCheck(pyArgs[0], PySideSignalInstanceTypeF()))
                    goto Sbk_QStateFunc_addTransition_TypeError;
                PySideSignalInstance *signalInstance = reinterpret_cast<PySideSignalInstance *>(pyArgs[0]);
                ::QObject* sender{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), PySide::Signal::getObject(signalInstance), &(sender));
                QSignalTransition *cppResult = cppSelf->addTransition(sender, PySide::Signal::getSignature(signalInstance),cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIGNALTRANSITION_IDX]), cppResult);
                // END of custom code block [file: ../glue/qtcore.cpp (qstate-addtransition-2)]
                // ========================================================================

                // End of code injection

                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // addTransition(QAbstractState * target)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QAbstractState *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addTransition(QAbstractState*)
                QAbstractTransition * cppResult = cppSelf->addTransition(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyArgs[0]);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 2: // addTransition(QAbstractTransition * transition)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QAbstractTransition *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addTransition(QAbstractTransition*)
                cppSelf->addTransition(cppArg0);
                Shiboken::Object::setParent(self, pyArgs[0]);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 3: // addTransition(const QObject * sender, const char * signal, QAbstractState * target)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QAbstractState *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // addTransition(const QObject*,const char*,QAbstractState*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qstate-addtransition-1)]
                QString signalName(cppArg1);
                if (PySide::SignalManager::registerMetaMethod(cppArg0, signalName.mid(1).toLatin1().data(), QMetaMethod::Signal)) {
                    QSignalTransition *cppResult = cppSelf->addTransition(cppArg0, cppArg1, cppArg2);
                    pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIGNALTRANSITION_IDX]), cppResult);
                } else {
                    Py_INCREF(Py_None);
                    pyResult = Py_None;
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qstate-addtransition-1)]
                // ========================================================================

                // End of code injection

                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStateFunc_addTransition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_assignProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.assignProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "assignProperty", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QState::assignProperty(QObject*,const char*,QVariant)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[2])))) {
        overloadId = 0; // assignProperty(QObject*,const char*,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_assignProperty_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QVariant cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // assignProperty(QObject*,const char*,QVariant)
            cppSelf->assignProperty(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_assignProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_childMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.childMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childMode()const
            QState::ChildMode cppResult = const_cast<const ::QState *>(cppSelf)->childMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateFunc_errorState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.errorState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorState()const
            QAbstractState * cppResult = const_cast<const ::QState *>(cppSelf)->errorState();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QState::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStateFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_initialState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.initialState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialState()const
            QAbstractState * cppResult = const_cast<const ::QState *>(cppSelf)->initialState();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateFunc_onEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.onEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractState::onEntry(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // onEntry(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_onEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // onEntry(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QState::onEntry(cppArg0)
                : cppSelf->onEntry(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_onEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_onExit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.onExit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractState::onExit(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // onExit(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_onExit_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // onExit(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QState::onExit(cppArg0)
                : cppSelf->onExit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_onExit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_removeTransition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.removeTransition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QState::removeTransition(QAbstractTransition*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]), (pyArg)))) {
        overloadId = 0; // removeTransition(QAbstractTransition*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_removeTransition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractTransition *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeTransition(QAbstractTransition*)
            cppSelf->removeTransition(cppArg0);
            Shiboken::Object::setParent(Py_None, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_removeTransition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_setChildMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.setChildMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QState::setChildMode(QState::ChildMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setChildMode(QState::ChildMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_setChildMode_TypeError;

    // Call function/method
    {
        ::QState::ChildMode cppArg0{QState::ExclusiveStates};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setChildMode(QState::ChildMode)
            cppSelf->setChildMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_setChildMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_setErrorState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.setErrorState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QState::setErrorState(QAbstractState*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArg)))) {
        overloadId = 0; // setErrorState(QAbstractState*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_setErrorState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractState *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setErrorState(QAbstractState*)
            cppSelf->setErrorState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_setErrorState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_setInitialState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.setInitialState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QState::setInitialState(QAbstractState*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArg)))) {
        overloadId = 0; // setInitialState(QAbstractState*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateFunc_setInitialState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractState *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInitialState(QAbstractState*)
            cppSelf->setInitialState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateFunc_setInitialState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateFunc_transitions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QState.transitions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transitions()const
            QList<QAbstractTransition* > cppResult = const_cast<const ::QState *>(cppSelf)->transitions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTTRANSITIONPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QState_PropertyStrings[] = {
    "childMode::",
    "errorState::",
    "initialState::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QState_methods[] = {
    {"addTransition", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_addTransition), METH_VARARGS},
    {"assignProperty", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_assignProperty), METH_VARARGS},
    {"childMode", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_childMode), METH_NOARGS},
    {"errorState", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_errorState), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_event), METH_O},
    {"initialState", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_initialState), METH_NOARGS},
    {"onEntry", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_onEntry), METH_O},
    {"onExit", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_onExit), METH_O},
    {"removeTransition", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_removeTransition), METH_O},
    {"setChildMode", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_setChildMode), METH_O},
    {"setErrorState", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_setErrorState), METH_O},
    {"setInitialState", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_setInitialState), METH_O},
    {"transitions", reinterpret_cast<PyCFunction>(Sbk_QStateFunc_transitions), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QState_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QStateWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QState_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QState_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QState_Type = nullptr;
static SbkObjectType *Sbk_QState_TypeF(void)
{
    return _Sbk_QState_Type;
}

static PyType_Slot Sbk_QState_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QState_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QState_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QState_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QState_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QState_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QState_spec = {
    "2:PySide2.QtCore.QState",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QState_slots
};

} //extern "C"

static void *Sbk_QState_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QState *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QState_ChildMode_PythonToCpp_QState_ChildMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QState::ChildMode *>(cppOut) =
        static_cast<::QState::ChildMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QState_ChildMode_PythonToCpp_QState_ChildMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX]))
        return QState_ChildMode_PythonToCpp_QState_ChildMode;
    return {};
}
static PyObject *QState_ChildMode_CppToPython_QState_ChildMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QState::ChildMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX], castCppIn);

}

static void QState_RestorePolicy_PythonToCpp_QState_RestorePolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QState::RestorePolicy *>(cppOut) =
        static_cast<::QState::RestorePolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QState_RestorePolicy_PythonToCpp_QState_RestorePolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX]))
        return QState_RestorePolicy_PythonToCpp_QState_RestorePolicy;
    return {};
}
static PyObject *QState_RestorePolicy_CppToPython_QState_RestorePolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QState::RestorePolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QState_PythonToCpp_QState_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QState_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QState_PythonToCpp_QState_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QState_TypeF())))
        return QState_PythonToCpp_QState_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QState_PTR_CppToPython_QState(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QState *>(const_cast<void *>(cppIn)), Sbk_QState_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QState_SignatureStrings[] = {
    "1:PySide2.QtCore.QState(self,parent:PySide2.QtCore.QState=nullptr)",
    "0:PySide2.QtCore.QState(self,childMode:PySide2.QtCore.QState.ChildMode,parent:PySide2.QtCore.QState=nullptr)",
    "3:PySide2.QtCore.QState.addTransition(self,arg__1:PyObject,arg__2:PySide2.QtCore.QAbstractState)->PySide2.QtCore.QSignalTransition",
    "2:PySide2.QtCore.QState.addTransition(self,target:PySide2.QtCore.QAbstractState)->PySide2.QtCore.QAbstractTransition",
    "1:PySide2.QtCore.QState.addTransition(self,transition:PySide2.QtCore.QAbstractTransition)",
    "0:PySide2.QtCore.QState.addTransition(self,sender:PySide2.QtCore.QObject,signal:char*,target:PySide2.QtCore.QAbstractState)->PySide2.QtCore.QSignalTransition",
    "PySide2.QtCore.QState.assignProperty(self,object:PySide2.QtCore.QObject,name:char*,value:QVariant)",
    "PySide2.QtCore.QState.childMode(self)->PySide2.QtCore.QState.ChildMode",
    "PySide2.QtCore.QState.errorState(self)->PySide2.QtCore.QAbstractState",
    "PySide2.QtCore.QState.event(self,e:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QState.initialState(self)->PySide2.QtCore.QAbstractState",
    "PySide2.QtCore.QState.onEntry(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QState.onExit(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QState.removeTransition(self,transition:PySide2.QtCore.QAbstractTransition)",
    "PySide2.QtCore.QState.setChildMode(self,mode:PySide2.QtCore.QState.ChildMode)",
    "PySide2.QtCore.QState.setErrorState(self,state:PySide2.QtCore.QAbstractState)",
    "PySide2.QtCore.QState.setInitialState(self,state:PySide2.QtCore.QAbstractState)",
    "PySide2.QtCore.QState.transitions(self)->QList[PySide2.QtCore.QAbstractTransition]",
    nullptr}; // Sentinel

void init_QState(PyObject *module)
{
    _Sbk_QState_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QState",
        "QState*",
        &Sbk_QState_spec,
        &Shiboken::callCppDestructor< ::QState >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QState_Type);
    InitSignatureStrings(pyType, QState_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QState_Type), Sbk_QState_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QState_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QState_TypeF(),
        QState_PythonToCpp_QState_PTR,
        is_QState_PythonToCpp_QState_PTR_Convertible,
        QState_PTR_CppToPython_QState);

    Shiboken::Conversions::registerConverterName(converter, "QState");
    Shiboken::Conversions::registerConverterName(converter, "QState*");
    Shiboken::Conversions::registerConverterName(converter, "QState&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QState).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStateWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QState_TypeF(), &Sbk_QState_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ChildMode'.
    SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QState_TypeF(),
        "ChildMode",
        "2:PySide2.QtCore.QState.ChildMode",
        "QState::ChildMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX],
        Sbk_QState_TypeF(), "ExclusiveStates", (long) QState::ChildMode::ExclusiveStates))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX],
        Sbk_QState_TypeF(), "ParallelStates", (long) QState::ChildMode::ParallelStates))
        return;
    // Register converter for enum 'QState::ChildMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX],
            QState_ChildMode_CppToPython_QState_ChildMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QState_ChildMode_PythonToCpp_QState_ChildMode,
            is_QState_ChildMode_PythonToCpp_QState_ChildMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QState::ChildMode");
        Shiboken::Conversions::registerConverterName(converter, "ChildMode");
    }
    // End of 'ChildMode' enum.

    // Initialization of enum 'RestorePolicy'.
    SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QState_TypeF(),
        "RestorePolicy",
        "2:PySide2.QtCore.QState.RestorePolicy",
        "QState::RestorePolicy");
    if (!SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX],
        Sbk_QState_TypeF(), "DontRestoreProperties", (long) QState::RestorePolicy::DontRestoreProperties))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX],
        Sbk_QState_TypeF(), "RestoreProperties", (long) QState::RestorePolicy::RestoreProperties))
        return;
    // Register converter for enum 'QState::RestorePolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX],
            QState_RestorePolicy_CppToPython_QState_RestorePolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QState_RestorePolicy_PythonToCpp_QState_RestorePolicy,
            is_QState_RestorePolicy_PythonToCpp_QState_RestorePolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QState::RestorePolicy");
        Shiboken::Conversions::registerConverterName(converter, "RestorePolicy");
    }
    // End of 'RestorePolicy' enum.

    PySide::Signal::registerSignals(Sbk_QState_TypeF(), &::QState::staticMetaObject);
    qRegisterMetaType< ::QState::ChildMode >("QState::ChildMode");
    qRegisterMetaType< ::QState::RestorePolicy >("QState::RestorePolicy");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QState_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QState_TypeF(), &::QState::staticMetaObject, sizeof(QStateWrapper));
}
