/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qstatemachine_wrappedevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void WrappedEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

WrappedEventWrapper::WrappedEventWrapper(::QObject * object, ::QEvent * event) : QStateMachine::WrappedEvent(object, event)
{
    resetPyMethodCache();
    // ... middle
}

WrappedEventWrapper::~WrappedEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStateMachine_WrappedEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStateMachine::WrappedEvent >()))
        return -1;

    ::WrappedEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.WrappedEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "WrappedEvent", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: WrappedEvent::WrappedEvent(QObject*,QEvent*)
    // 1: WrappedEvent::WrappedEvent(QStateMachine::WrappedEvent)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // WrappedEvent(QStateMachine::WrappedEvent)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // WrappedEvent(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachine_WrappedEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // WrappedEvent(QObject * object, QEvent * event)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QEvent *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // WrappedEvent(QObject*,QEvent*)
                cptr = new ::WrappedEventWrapper(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // WrappedEvent(const QStateMachine::WrappedEvent & WrappedEvent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStateMachine::WrappedEvent cppArg0_local = ::QStateMachine::WrappedEvent(static_cast<::QObject*>(nullptr), static_cast<::QEvent*>(nullptr));
            ::QStateMachine::WrappedEvent *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // WrappedEvent(QStateMachine::WrappedEvent)
                cptr = new ::WrappedEventWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStateMachine::WrappedEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStateMachine_WrappedEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStateMachine_WrappedEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStateMachine_WrappedEventFunc_event(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine::WrappedEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.WrappedEvent.event";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // event()const
            QEvent * cppResult = const_cast<const ::QStateMachine::WrappedEvent *>(cppSelf)->event();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachine_WrappedEventFunc_object(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine::WrappedEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.WrappedEvent.object";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // object()const
            QObject * cppResult = const_cast<const ::QStateMachine::WrappedEvent *>(cppSelf)->object();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachine_WrappedEvent___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QStateMachine::WrappedEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QStateMachine_WrappedEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStateMachine_WrappedEvent_methods[] = {
    {"event", reinterpret_cast<PyCFunction>(Sbk_QStateMachine_WrappedEventFunc_event), METH_NOARGS},
    {"object", reinterpret_cast<PyCFunction>(Sbk_QStateMachine_WrappedEventFunc_object), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QStateMachine_WrappedEvent___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QStateMachine_WrappedEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QStateMachine::WrappedEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<WrappedEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QStateMachine_WrappedEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStateMachine_WrappedEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStateMachine_WrappedEvent_Type = nullptr;
static SbkObjectType *Sbk_QStateMachine_WrappedEvent_TypeF(void)
{
    return _Sbk_QStateMachine_WrappedEvent_Type;
}

static PyType_Slot Sbk_QStateMachine_WrappedEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QStateMachine_WrappedEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStateMachine_WrappedEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStateMachine_WrappedEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStateMachine_WrappedEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStateMachine_WrappedEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStateMachine_WrappedEvent_spec = {
    "2:PySide2.QtCore.QStateMachine.WrappedEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStateMachine_WrappedEvent_slots
};

} //extern "C"

static void *Sbk_QStateMachine_WrappedEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QEvent >()))
        return dynamic_cast< ::QStateMachine::WrappedEvent *>(reinterpret_cast< ::QEvent *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WrappedEvent_PythonToCpp_WrappedEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStateMachine_WrappedEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WrappedEvent_PythonToCpp_WrappedEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStateMachine_WrappedEvent_TypeF())))
        return WrappedEvent_PythonToCpp_WrappedEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WrappedEvent_PTR_CppToPython_WrappedEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStateMachine::WrappedEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStateMachine_WrappedEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *WrappedEvent_COPY_CppToPython_WrappedEvent(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QStateMachine_WrappedEvent_TypeF(), new ::WrappedEventWrapper(*reinterpret_cast<const ::QStateMachine::WrappedEvent *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void WrappedEvent_PythonToCpp_WrappedEvent_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStateMachine::WrappedEvent *>(cppOut) = *reinterpret_cast< ::QStateMachine::WrappedEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_WrappedEvent_PythonToCpp_WrappedEvent_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStateMachine_WrappedEvent_TypeF())))
        return WrappedEvent_PythonToCpp_WrappedEvent_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStateMachine_WrappedEvent_SignatureStrings[] = {
    "1:PySide2.QtCore.QStateMachine.WrappedEvent(self,object:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent)",
    "0:PySide2.QtCore.QStateMachine.WrappedEvent(self,WrappedEvent:PySide2.QtCore.QStateMachine.WrappedEvent)",
    "PySide2.QtCore.QStateMachine.WrappedEvent.event(self)->PySide2.QtCore.QEvent",
    "PySide2.QtCore.QStateMachine.WrappedEvent.object(self)->PySide2.QtCore.QObject",
    "PySide2.QtCore.QStateMachine.WrappedEvent.__copy__()",
    nullptr}; // Sentinel

void init_QStateMachine_WrappedEvent(PyObject *enclosingClass)
{
    _Sbk_QStateMachine_WrappedEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "WrappedEvent",
        "QStateMachine::WrappedEvent",
        &Sbk_QStateMachine_WrappedEvent_spec,
        &Shiboken::callCppDestructor< ::WrappedEventWrapper >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStateMachine_WrappedEvent_Type);
    InitSignatureStrings(pyType, QStateMachine_WrappedEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStateMachine_WrappedEvent_Type), Sbk_QStateMachine_WrappedEvent_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStateMachine_WrappedEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStateMachine_WrappedEvent_TypeF(),
        WrappedEvent_PythonToCpp_WrappedEvent_PTR,
        is_WrappedEvent_PythonToCpp_WrappedEvent_PTR_Convertible,
        WrappedEvent_PTR_CppToPython_WrappedEvent,
        WrappedEvent_COPY_CppToPython_WrappedEvent);

    Shiboken::Conversions::registerConverterName(converter, "QStateMachine::WrappedEvent");
    Shiboken::Conversions::registerConverterName(converter, "QStateMachine::WrappedEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QStateMachine::WrappedEvent&");
    Shiboken::Conversions::registerConverterName(converter, "WrappedEvent");
    Shiboken::Conversions::registerConverterName(converter, "WrappedEvent*");
    Shiboken::Conversions::registerConverterName(converter, "WrappedEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStateMachine::WrappedEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::WrappedEventWrapper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WrappedEvent_PythonToCpp_WrappedEvent_COPY,
        is_WrappedEvent_PythonToCpp_WrappedEvent_COPY_Convertible);

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QStateMachine_WrappedEvent_TypeF(), &Sbk_QStateMachine_WrappedEvent_typeDiscovery);

}
