/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qsystemsemaphore_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSystemSemaphore_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSystemSemaphore >()))
        return -1;

    ::QSystemSemaphore *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSystemSemaphore_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSystemSemaphore_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QSystemSemaphore", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QSystemSemaphore::QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSystemSemaphore_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_initialValue = Shiboken::String::createStaticString("initialValue");
            if (PyDict_Contains(kwds, key_initialValue)) {
                value = PyDict_GetItem(kwds, key_initialValue);
                if (value && pyArgs[1]) {
                    errInfo = key_initialValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QSystemSemaphore_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QSystemSemaphore_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_initialValue);
            }
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[2]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QSystemSemaphore_Init_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QSystemSemaphore_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSystemSemaphore_Init_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QSystemSemaphore::AccessMode cppArg2 = QSystemSemaphore::AccessMode::Open;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
            cptr = new ::QSystemSemaphore(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSystemSemaphore >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSystemSemaphore_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSystemSemaphore_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSystemSemaphoreFunc_acquire(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSystemSemaphore *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.acquire";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // acquire()
            bool cppResult = cppSelf->acquire();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSystemSemaphoreFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSystemSemaphore *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QSystemSemaphore::SystemSemaphoreError cppResult = const_cast<const ::QSystemSemaphore *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSystemSemaphoreFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSystemSemaphore *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QSystemSemaphore *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSystemSemaphoreFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSystemSemaphore *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.key";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // key()const
            QString cppResult = const_cast<const ::QSystemSemaphore *>(cppSelf)->key();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSystemSemaphoreFunc_release(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSystemSemaphore *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.release";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSystemSemaphoreFunc_release_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:release", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSystemSemaphore::release(int)
    if (numArgs == 0) {
        overloadId = 0; // release(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // release(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSystemSemaphoreFunc_release_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_n = Shiboken::String::createStaticString("n");
            if (PyDict_Contains(kwds, key_n)) {
                value = PyDict_GetItem(kwds, key_n);
                if (value && pyArgs[0]) {
                    errInfo = key_n;
                    Py_INCREF(errInfo);
                    goto Sbk_QSystemSemaphoreFunc_release_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QSystemSemaphoreFunc_release_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_n);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSystemSemaphoreFunc_release_TypeError;
            }
        }
        int cppArg0 = 1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // release(int)
            bool cppResult = cppSelf->release(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSystemSemaphoreFunc_release_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSystemSemaphoreFunc_setKey(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSystemSemaphore *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSystemSemaphore.setKey";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setKey", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QSystemSemaphore::setKey(QString,int,QSystemSemaphore::AccessMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setKey(QString,int,QSystemSemaphore::AccessMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setKey(QString,int,QSystemSemaphore::AccessMode)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // setKey(QString,int,QSystemSemaphore::AccessMode)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_initialValue = Shiboken::String::createStaticString("initialValue");
            if (PyDict_Contains(kwds, key_initialValue)) {
                value = PyDict_GetItem(kwds, key_initialValue);
                if (value && pyArgs[1]) {
                    errInfo = key_initialValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_initialValue);
            }
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[2]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSystemSemaphoreFunc_setKey_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QSystemSemaphore::AccessMode cppArg2 = QSystemSemaphore::AccessMode::Open;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setKey(QString,int,QSystemSemaphore::AccessMode)
            cppSelf->setKey(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSystemSemaphoreFunc_setKey_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSystemSemaphore_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSystemSemaphore_methods[] = {
    {"acquire", reinterpret_cast<PyCFunction>(Sbk_QSystemSemaphoreFunc_acquire), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QSystemSemaphoreFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QSystemSemaphoreFunc_errorString), METH_NOARGS},
    {"key", reinterpret_cast<PyCFunction>(Sbk_QSystemSemaphoreFunc_key), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QSystemSemaphoreFunc_release), METH_VARARGS|METH_KEYWORDS},
    {"setKey", reinterpret_cast<PyCFunction>(Sbk_QSystemSemaphoreFunc_setKey), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSystemSemaphore_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSystemSemaphore_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSystemSemaphore_Type = nullptr;
static SbkObjectType *Sbk_QSystemSemaphore_TypeF(void)
{
    return _Sbk_QSystemSemaphore_Type;
}

static PyType_Slot Sbk_QSystemSemaphore_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSystemSemaphore_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSystemSemaphore_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSystemSemaphore_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSystemSemaphore_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSystemSemaphore_spec = {
    "2:PySide2.QtCore.QSystemSemaphore",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSystemSemaphore_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSystemSemaphore_AccessMode_PythonToCpp_QSystemSemaphore_AccessMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSystemSemaphore::AccessMode *>(cppOut) =
        static_cast<::QSystemSemaphore::AccessMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSystemSemaphore_AccessMode_PythonToCpp_QSystemSemaphore_AccessMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX]))
        return QSystemSemaphore_AccessMode_PythonToCpp_QSystemSemaphore_AccessMode;
    return {};
}
static PyObject *QSystemSemaphore_AccessMode_CppToPython_QSystemSemaphore_AccessMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSystemSemaphore::AccessMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX], castCppIn);

}

static void QSystemSemaphore_SystemSemaphoreError_PythonToCpp_QSystemSemaphore_SystemSemaphoreError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSystemSemaphore::SystemSemaphoreError *>(cppOut) =
        static_cast<::QSystemSemaphore::SystemSemaphoreError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSystemSemaphore_SystemSemaphoreError_PythonToCpp_QSystemSemaphore_SystemSemaphoreError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX]))
        return QSystemSemaphore_SystemSemaphoreError_PythonToCpp_QSystemSemaphore_SystemSemaphoreError;
    return {};
}
static PyObject *QSystemSemaphore_SystemSemaphoreError_CppToPython_QSystemSemaphore_SystemSemaphoreError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSystemSemaphore::SystemSemaphoreError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSystemSemaphore_PythonToCpp_QSystemSemaphore_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSystemSemaphore_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSystemSemaphore_PythonToCpp_QSystemSemaphore_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSystemSemaphore_TypeF())))
        return QSystemSemaphore_PythonToCpp_QSystemSemaphore_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSystemSemaphore_PTR_CppToPython_QSystemSemaphore(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSystemSemaphore *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSystemSemaphore_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSystemSemaphore_SignatureStrings[] = {
    "PySide2.QtCore.QSystemSemaphore(self,key:QString,initialValue:int=0,mode:PySide2.QtCore.QSystemSemaphore.AccessMode=Open)",
    "PySide2.QtCore.QSystemSemaphore.acquire(self)->bool",
    "PySide2.QtCore.QSystemSemaphore.error(self)->PySide2.QtCore.QSystemSemaphore.SystemSemaphoreError",
    "PySide2.QtCore.QSystemSemaphore.errorString(self)->QString",
    "PySide2.QtCore.QSystemSemaphore.key(self)->QString",
    "PySide2.QtCore.QSystemSemaphore.release(self,n:int=1)->bool",
    "PySide2.QtCore.QSystemSemaphore.setKey(self,key:QString,initialValue:int=0,mode:PySide2.QtCore.QSystemSemaphore.AccessMode=Open)",
    nullptr}; // Sentinel

void init_QSystemSemaphore(PyObject *module)
{
    _Sbk_QSystemSemaphore_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSystemSemaphore",
        "QSystemSemaphore*",
        &Sbk_QSystemSemaphore_spec,
        &Shiboken::callCppDestructor< ::QSystemSemaphore >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSystemSemaphore_Type);
    InitSignatureStrings(pyType, QSystemSemaphore_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSystemSemaphore_Type), Sbk_QSystemSemaphore_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSystemSemaphore_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSystemSemaphore_TypeF(),
        QSystemSemaphore_PythonToCpp_QSystemSemaphore_PTR,
        is_QSystemSemaphore_PythonToCpp_QSystemSemaphore_PTR_Convertible,
        QSystemSemaphore_PTR_CppToPython_QSystemSemaphore);

    Shiboken::Conversions::registerConverterName(converter, "QSystemSemaphore");
    Shiboken::Conversions::registerConverterName(converter, "QSystemSemaphore*");
    Shiboken::Conversions::registerConverterName(converter, "QSystemSemaphore&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSystemSemaphore).name());


    // Initialization of enums.

    // Initialization of enum 'AccessMode'.
    SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSystemSemaphore_TypeF(),
        "AccessMode",
        "2:PySide2.QtCore.QSystemSemaphore.AccessMode",
        "QSystemSemaphore::AccessMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX],
        Sbk_QSystemSemaphore_TypeF(), "Open", (long) QSystemSemaphore::AccessMode::Open))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX],
        Sbk_QSystemSemaphore_TypeF(), "Create", (long) QSystemSemaphore::AccessMode::Create))
        return;
    // Register converter for enum 'QSystemSemaphore::AccessMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX],
            QSystemSemaphore_AccessMode_CppToPython_QSystemSemaphore_AccessMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSystemSemaphore_AccessMode_PythonToCpp_QSystemSemaphore_AccessMode,
            is_QSystemSemaphore_AccessMode_PythonToCpp_QSystemSemaphore_AccessMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSystemSemaphore::AccessMode");
        Shiboken::Conversions::registerConverterName(converter, "AccessMode");
    }
    // End of 'AccessMode' enum.

    // Initialization of enum 'SystemSemaphoreError'.
    SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSystemSemaphore_TypeF(),
        "SystemSemaphoreError",
        "2:PySide2.QtCore.QSystemSemaphore.SystemSemaphoreError",
        "QSystemSemaphore::SystemSemaphoreError");
    if (!SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "NoError", (long) QSystemSemaphore::SystemSemaphoreError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "PermissionDenied", (long) QSystemSemaphore::SystemSemaphoreError::PermissionDenied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "KeyError", (long) QSystemSemaphore::SystemSemaphoreError::KeyError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "AlreadyExists", (long) QSystemSemaphore::SystemSemaphoreError::AlreadyExists))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "NotFound", (long) QSystemSemaphore::SystemSemaphoreError::NotFound))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "OutOfResources", (long) QSystemSemaphore::SystemSemaphoreError::OutOfResources))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
        Sbk_QSystemSemaphore_TypeF(), "UnknownError", (long) QSystemSemaphore::SystemSemaphoreError::UnknownError))
        return;
    // Register converter for enum 'QSystemSemaphore::SystemSemaphoreError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX],
            QSystemSemaphore_SystemSemaphoreError_CppToPython_QSystemSemaphore_SystemSemaphoreError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSystemSemaphore_SystemSemaphoreError_PythonToCpp_QSystemSemaphore_SystemSemaphoreError,
            is_QSystemSemaphore_SystemSemaphoreError_PythonToCpp_QSystemSemaphore_SystemSemaphoreError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSystemSemaphore::SystemSemaphoreError");
        Shiboken::Conversions::registerConverterName(converter, "SystemSemaphoreError");
    }
    // End of 'SystemSemaphoreError' enum.

    qRegisterMetaType< ::QSystemSemaphore::AccessMode >("QSystemSemaphore::AccessMode");
    qRegisterMetaType< ::QSystemSemaphore::SystemSemaphoreError >("QSystemSemaphore::SystemSemaphoreError");
}
