/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtcore_python.h"

#include <qmath.h>
#include <qbytearray.h>
#include <qglobal.h>
#include <qnumeric.h>


// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtCoreTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtCoreModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtCoreTypeConverters = nullptr;
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (include-pyside)]
#include <pyside.h>
#include <limits>
    // END of custom code block [file: ../glue/qtcore.cpp (include-pyside)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (pystring-check)]
    bool py2kStrCheck(PyObject *obj)
    {
#ifdef IS_PY3K
        return false;
#else
        return PyString_Check(obj);
#endif
    }
    // END of custom code block [file: ../glue/qtcore.cpp (pystring-check)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qvariant-conversion)]
    static const char *QVariant_resolveMetaType(PyTypeObject *type, int *typeId)
    {
        if (PyObject_TypeCheck(type, SbkObjectType_TypeF())) {
            auto sbkType = reinterpret_cast<SbkObjectType *>(type);
            const char *typeName = Shiboken::ObjectType::getOriginalName(sbkType);
            if (!typeName)
                return nullptr;
            const bool valueType = '*' != typeName[qstrlen(typeName) - 1];
            // Do not convert user type of value
            if (valueType && Shiboken::ObjectType::isUserType(type))
                return nullptr;
            int obTypeId = QMetaType::type(typeName);
            if (obTypeId) {
                *typeId = obTypeId;
                return typeName;
            }
            // Do not resolve types to value type
            if (valueType)
                return nullptr;
            // Find in base types. First check tp_bases, and only after check tp_base, because
            // tp_base does not always point to the first base class, but rather to the first
            // that has added any python fields or slots to its object layout.
            // See https://mail.python.org/pipermail/python-list/2009-January/520733.html
            if (type->tp_bases) {
                for (int i = 0, size = PyTuple_GET_SIZE(type->tp_bases); i < size; ++i) {
                    const char *derivedName = QVariant_resolveMetaType(reinterpret_cast<PyTypeObject *>(PyTuple_GET_ITEM(
                                              type->tp_bases, i)), typeId);
                    if (derivedName)
                        return derivedName;
                }
            }
            else if (type->tp_base) {
                return QVariant_resolveMetaType(type->tp_base, typeId);
            }
        }
        *typeId = 0;
        return nullptr;
    }
    static QVariant QVariant_convertToValueList(PyObject *list)
    {
        if (PySequence_Size(list) < 0) {
             // clear the error if < 0 which means no length at all
             PyErr_Clear();
             return QVariant();
        }

        Shiboken::AutoDecRef element(PySequence_GetItem(list, 0));
        int typeId;
        const char *typeName = QVariant_resolveMetaType(element.cast<PyTypeObject *>(), &typeId);
        if (typeName) {
            QByteArray listTypeName("QList<");
            listTypeName += typeName;
            listTypeName += '>';
            typeId = QMetaType::type(listTypeName);
            if (typeId > 0) {
                Shiboken::Conversions::SpecificConverter converter(listTypeName);
                if (converter) {
                    QVariant var(typeId, nullptr);
                    converter.toCpp(list, &var);
                    return var;
                }
                qWarning() << "Type converter for :" << listTypeName << "not registered.";
            }
        }
        return QVariant();
    }
    static bool QVariant_isStringList(PyObject *list)
    {
        if (!PySequence_Check(list)) {
            // If it is not a list or a derived list class
            // we assume that will not be a String list neither.
            return false;
        }

        if (PySequence_Size(list) < 0) {
            // clear the error if < 0 which means no length at all
            PyErr_Clear();
            return false;
        }

        Shiboken::AutoDecRef fast(PySequence_Fast(list, "Failed to convert QVariantList"));
        const Py_ssize_t size = PySequence_Fast_GET_SIZE(fast.object());
        for (Py_ssize_t i = 0; i < size; ++i) {
            PyObject *item = PySequence_Fast_GET_ITEM(fast.object(), i);
            if (!Shiboken::String::check(item))
                return false;
        }
        return true;
    }
    static QVariant QVariant_convertToVariantMap(PyObject *map)
    {
        Py_ssize_t pos = 0;
        Shiboken::AutoDecRef keys(PyDict_Keys(map));
        if (!QVariant_isStringList(keys))
            return QVariant();
        PyObject *key;
        PyObject *value;
        QMap<QString,QVariant> ret;
        while (PyDict_Next(map, &pos, &key, &value)) {
            ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
            ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
            ret.insert(cppKey, cppValue);
        }
        return QVariant(ret);
    }
    static QVariant QVariant_convertToVariantList(PyObject *list)
    {
        if (QVariant_isStringList(list)) {
            ::QList<QString > lst;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTRING_IDX], list, &(lst));
            return QVariant(QStringList(lst));
        }
        QVariant valueList = QVariant_convertToValueList(list);
        if (valueList.isValid())
            return valueList;

        if (PySequence_Size(list) < 0) {
            // clear the error if < 0 which means no length at all
            PyErr_Clear();
            return QVariant();
        }

        QList<QVariant> lst;
        Shiboken::AutoDecRef fast(PySequence_Fast(list, "Failed to convert QVariantList"));
        const Py_ssize_t size = PySequence_Fast_GET_SIZE(fast.object());
        for (Py_ssize_t i = 0; i < size; ++i) {
            PyObject *pyItem = PySequence_Fast_GET_ITEM(fast.object(), i);
            ::QVariant item;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(item));
            lst.append(item);
        }
        return QVariant(lst);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qvariant-conversion)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qvariantmap-check)]
    static bool QVariantType_isStringList(PyObject *list)
    {
        Shiboken::AutoDecRef fast(PySequence_Fast(list, "Failed to convert QVariantList"));
        const Py_ssize_t size = PySequence_Fast_GET_SIZE(fast.object());
        for (Py_ssize_t i=0; i < size; i++) {
            PyObject *item = PySequence_Fast_GET_ITEM(fast.object(), i);
            if (!Shiboken::String::check(item))
                return false;
        }
        return true;
    }
    static bool QVariantType_checkAllStringKeys(PyObject *dict)
    {
        Shiboken::AutoDecRef keys(PyDict_Keys(dict));
        return QVariantType_isStringList(keys);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qvariantmap-check)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-postroutine)]
    namespace PySide {
    static QStack<PyObject *> globalPostRoutineFunctions;
    void globalPostRoutineCallback()
    {
        Shiboken::GilState state;
        for (auto *callback : globalPostRoutineFunctions) {
            Shiboken::AutoDecRef result(PyObject_CallObject(callback, nullptr));
            Py_DECREF(callback);
        }
        globalPostRoutineFunctions.clear();
    }
    void addPostRoutine(PyObject *callback)
    {
        if (PyCallable_Check(callback)) {
            globalPostRoutineFunctions << callback;
            Py_INCREF(callback);
        } else {
            PyErr_SetString(PyExc_TypeError, "qAddPostRoutine: The argument must be a callable object.");
        }
    }
    } // namespace
    // END of custom code block [file: ../glue/qtcore.cpp (qt-postroutine)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-messagehandler)]
    // Define a global variable to handle qInstallMessageHandler callback
    static PyObject *qtmsghandler = nullptr;

    static void msgHandlerCallback(QtMsgType type, const QMessageLogContext &ctx, const QString &msg)
    {
        Shiboken::GilState state;
        Shiboken::AutoDecRef arglist(PyTuple_New(3));
        PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX])->converter, &type));
        PyTuple_SET_ITEM(arglist, 1, Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMESSAGELOGCONTEXT_IDX]), &ctx));
        QByteArray array = msg.toUtf8();  // Python handler requires UTF-8
        char *data = array.data();
        PyTuple_SET_ITEM(arglist, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data));
        Shiboken::AutoDecRef ret(PyObject_CallObject(qtmsghandler, arglist));
    }
    static void QtCoreModuleExit()
    {
        PySide::SignalManager::instance().clear();
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qt-messagehandler)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-registerresourcedata)]
    QT_BEGIN_NAMESPACE
    extern bool
    qRegisterResourceData(int,
                          const unsigned char *,
                          const unsigned char *,
                          const unsigned char *);

    extern bool
    qUnregisterResourceData(int,
                            const unsigned char *,
                            const unsigned char *,
                            const unsigned char *);
    QT_END_NAMESPACE
    // END of custom code block [file: ../glue/qtcore.cpp (qt-registerresourcedata)]
    // ========================================================================

    // End of code injection

void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtCore_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------
static PyObject *SbkQtCoreModule_QEnum(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEnum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEnum(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // QEnum(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QEnum_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QEnum(PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-qenum)]
            pyResult = PySide::QEnum::QEnumMacro(pyArg, false);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-qenum)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QEnum_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_QFlag(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFlag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFlag(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // QFlag(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QFlag_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QFlag(PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-qflag)]
            pyResult = PySide::QEnum::QEnumMacro(pyArg, true);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-qflag)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QFlag_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_QT_TRANSLATE_NOOP(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QT_TRANSLATE_NOOP";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QT_TRANSLATE_NOOP", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QT_TRANSLATE_NOOP(PyObject,PyObject)
    if (numArgs == 2
        && PyObject_Check(pyArgs[0])
        && PyObject_Check(pyArgs[1])) {
        overloadId = 0; // QT_TRANSLATE_NOOP(PyObject,PyObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QT_TRANSLATE_NOOP_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QT_TRANSLATE_NOOP(PyObject,PyObject)
            // Begin code injection
            // TEMPLATE - return_argument - START
            Py_INCREF(pyArgs[2-1]);
            pyResult = pyArgs[2-1];
            // TEMPLATE - return_argument - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QT_TRANSLATE_NOOP_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_QT_TRANSLATE_NOOP3(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QT_TRANSLATE_NOOP3";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QT_TRANSLATE_NOOP3", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QT_TRANSLATE_NOOP3(PyObject,PyObject,PyObject)
    if (numArgs == 3
        && PyObject_Check(pyArgs[0])
        && PyObject_Check(pyArgs[1])
        && PyObject_Check(pyArgs[2])) {
        overloadId = 0; // QT_TRANSLATE_NOOP3(PyObject,PyObject,PyObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QT_TRANSLATE_NOOP3_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QT_TRANSLATE_NOOP3(PyObject,PyObject,PyObject)
            // Begin code injection
            // TEMPLATE - return_argument - START
            Py_INCREF(pyArgs[2-1]);
            pyResult = pyArgs[2-1];
            // TEMPLATE - return_argument - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QT_TRANSLATE_NOOP3_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QT_TRANSLATE_NOOP_UTF8";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QT_TRANSLATE_NOOP_UTF8(PyObject)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // QT_TRANSLATE_NOOP_UTF8(PyObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QT_TRANSLATE_NOOP_UTF8(PyObject)
            // Begin code injection
            // TEMPLATE - return_argument - START
            Py_INCREF(pyArg);
            pyResult = pyArg;
            // TEMPLATE - return_argument - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_QT_TR_NOOP(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QT_TR_NOOP";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QT_TR_NOOP(PyObject)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // QT_TR_NOOP(PyObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QT_TR_NOOP_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QT_TR_NOOP(PyObject)
            // Begin code injection
            // TEMPLATE - return_argument - START
            Py_INCREF(pyArg);
            pyResult = pyArg;
            // TEMPLATE - return_argument - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QT_TR_NOOP_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_QT_TR_NOOP_UTF8(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QT_TR_NOOP_UTF8";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QT_TR_NOOP_UTF8(PyObject)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // QT_TR_NOOP_UTF8(PyObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_QT_TR_NOOP_UTF8_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QT_TR_NOOP_UTF8(PyObject)
            // Begin code injection
            // TEMPLATE - return_argument - START
            Py_INCREF(pyArg);
            pyResult = pyArg;
            // TEMPLATE - return_argument - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_QT_TR_NOOP_UTF8_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_SIGNAL(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.SIGNAL";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SIGNAL(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // SIGNAL(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_SIGNAL_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // SIGNAL(const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-signal)]
            pyResult = Shiboken::String::fromFormat("2%s",QMetaObject::normalizedSignature(cppArg0).constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qt-signal)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_SIGNAL_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_SLOT(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.SLOT";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SLOT(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // SLOT(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_SLOT_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // SLOT(const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-slot)]
            pyResult = Shiboken::String::fromFormat("1%s",QMetaObject::normalizedSignature(cppArg0).constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qt-slot)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_SLOT_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule___init_feature__(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.__init_feature__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __init_feature__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-init-feature)]
            PySide::Feature::init();
            // END of custom code block [file: ../glue/qtcore.cpp (qt-init-feature)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *SbkQtCoreModule___moduleShutdown(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.__moduleShutdown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __moduleShutdown()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (moduleshutdown)]
            PySide::runCleanupFunctions();
            // END of custom code block [file: ../glue/qtcore.cpp (moduleshutdown)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *SbkQtCoreModule_qAbs(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qAbs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qAbs(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // qAbs(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qAbs_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qAbs(double)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-qabs)]
            double _abs = qAbs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &_abs);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-qabs)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qAbs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qAcos(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qAcos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qAcos(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qAcos(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qAcos_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qAcos(qreal)
            qreal cppResult = qAcos(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qAcos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qAddPostRoutine(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qAddPostRoutine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qAddPostRoutine(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // qAddPostRoutine(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qAddPostRoutine_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qAddPostRoutine(PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-addpostroutine)]
            PySide::addPostRoutine(pyArg);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-addpostroutine)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qAddPostRoutine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qAsin(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qAsin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qAsin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qAsin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qAsin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qAsin(qreal)
            qreal cppResult = qAsin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qAsin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qAtan(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qAtan";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qAtan(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qAtan(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qAtan_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qAtan(qreal)
            qreal cppResult = qAtan(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qAtan_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qAtan2(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qAtan2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qAtan2", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: qAtan2(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // qAtan2(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qAtan2_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qAtan2(qreal,qreal)
            qreal cppResult = qAtan2(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qAtan2_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qChecksum(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qChecksum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qChecksum", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: qChecksum(const char*,uint)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))) {
        overloadId = 0; // qChecksum(const char*,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qChecksum_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        uint cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qChecksum(const char*,uint)
            quint16 cppResult = qChecksum(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qChecksum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qCompress(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qCompress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto SbkQtCoreModule_qCompress_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto SbkQtCoreModule_qCompress_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:qCompress", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: qCompress(QByteArray,int)
    // 1: qCompress(const uchar*,int,int)
    if (numArgs >= 2
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // qCompress(const uchar*,int,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // qCompress(const uchar*,int,int)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // qCompress(QByteArray,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // qCompress(QByteArray,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qCompress_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // qCompress(const QByteArray & data, int compressionLevel)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_compressionLevel = Shiboken::String::createStaticString("compressionLevel");
                if (PyDict_Contains(kwds, key_compressionLevel)) {
                    value = PyDict_GetItem(kwds, key_compressionLevel);
                    if (value && pyArgs[1]) {
                        errInfo = key_compressionLevel;
                        Py_INCREF(errInfo);
                        goto SbkQtCoreModule_qCompress_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto SbkQtCoreModule_qCompress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_compressionLevel);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto SbkQtCoreModule_qCompress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // qCompress(QByteArray,int)
                QByteArray cppResult = qCompress(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // qCompress(const uchar * data, int nbytes, int compressionLevel)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_compressionLevel = Shiboken::String::createStaticString("compressionLevel");
                if (PyDict_Contains(kwds, key_compressionLevel)) {
                    value = PyDict_GetItem(kwds, key_compressionLevel);
                    if (value && pyArgs[2]) {
                        errInfo = key_compressionLevel;
                        Py_INCREF(errInfo);
                        goto SbkQtCoreModule_qCompress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto SbkQtCoreModule_qCompress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_compressionLevel);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto SbkQtCoreModule_qCompress_TypeError;
                }
            }
            uchar *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // qCompress(const uchar*,int,int)
                QByteArray cppResult = qCompress(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qCompress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qCritical(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qCritical";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qCritical(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // qCritical(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qCritical_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qCritical(const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (use-stream-for-format-security)]
            // Uses the stream version for security reasons
            // see gcc man page at -Wformat-security
            Py_BEGIN_ALLOW_THREADS
            qCritical() << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (use-stream-for-format-security)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qCritical_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qDebug(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qDebug";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qDebug(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // qDebug(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qDebug_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qDebug(const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (use-stream-for-format-security)]
            // Uses the stream version for security reasons
            // see gcc man page at -Wformat-security
            Py_BEGIN_ALLOW_THREADS
            qDebug() << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (use-stream-for-format-security)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qDebug_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qExp(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qExp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qExp(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qExp(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qExp_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qExp(qreal)
            qreal cppResult = qExp(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qExp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qFabs(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qFabs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qFabs(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qFabs(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qFabs_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qFabs(qreal)
            qreal cppResult = qFabs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qFabs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qFastCos(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qFastCos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qFastCos(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qFastCos(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qFastCos_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qFastCos(qreal)
            qreal cppResult = qFastCos(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qFastCos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qFastSin(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qFastSin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qFastSin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qFastSin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qFastSin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qFastSin(qreal)
            qreal cppResult = qFastSin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qFastSin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qFatal(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qFatal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qFatal(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // qFatal(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qFatal_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qFatal(const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qfatal)]
            // qFatal doesn't have a stream version, so we do a
            // qWarning call followed by a qFatal() call using a
            // literal.
            Py_BEGIN_ALLOW_THREADS
            qWarning() << cppArg0;
            qFatal("[A qFatal() call was made from Python code]");
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (qfatal)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qFatal_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qFuzzyCompare(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qFuzzyCompare";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qFuzzyCompare", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static qFuzzyCompare(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // qFuzzyCompare(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qFuzzyCompare_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qFuzzyCompare(double,double)
            bool cppResult = qFuzzyCompare(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qFuzzyCompare_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qFuzzyIsNull(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qFuzzyIsNull";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static qFuzzyIsNull(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // qFuzzyIsNull(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qFuzzyIsNull_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qFuzzyIsNull(double)
            bool cppResult = qFuzzyIsNull(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qFuzzyIsNull_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qInstallMessageHandler(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qInstallMessageHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qInstallMessageHandler(PyObject)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // qInstallMessageHandler(PyObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qInstallMessageHandler_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qInstallMessageHandler(PyObject)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-installmessagehandler)]
            if (pyArg == Py_None) {
              qInstallMessageHandler(0);
              pyResult = qtmsghandler ? qtmsghandler : Py_None;
              qtmsghandler = 0;
            } else if (!PyCallable_Check(pyArg)) {
              PyErr_SetString(PyExc_TypeError, "parameter must be callable");
            } else {
              pyResult = qtmsghandler ? qtmsghandler : Py_None;
              Py_INCREF(pyArg);
              qtmsghandler = pyArg;
              qInstallMessageHandler(msgHandlerCallback);
            }

            if (pyResult == Py_None)
                Py_INCREF(pyResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-installmessagehandler)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qInstallMessageHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qIsFinite(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qIsFinite";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qIsFinite(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // qIsFinite(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qIsFinite_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qIsFinite(double)
            bool cppResult = qIsFinite(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qIsFinite_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qIsInf(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qIsInf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qIsInf(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // qIsInf(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qIsInf_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qIsInf(double)
            bool cppResult = qIsInf(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qIsInf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qIsNaN(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qIsNaN";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qIsNaN(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // qIsNaN(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qIsNaN_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qIsNaN(double)
            bool cppResult = qIsNaN(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qIsNaN_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qIsNull(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qIsNull";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static qIsNull(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // qIsNull(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qIsNull_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qIsNull(double)
            bool cppResult = qIsNull(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qIsNull_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qRegisterResourceData(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qRegisterResourceData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qRegisterResourceData", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: qRegisterResourceData(int,PyBytes,PyBytes,PyBytes)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && PyBytes_Check(pyArgs[1])
        && PyBytes_Check(pyArgs[2])
        && PyBytes_Check(pyArgs[3])) {
        overloadId = 0; // qRegisterResourceData(int,PyBytes,PyBytes,PyBytes)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qRegisterResourceData_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qRegisterResourceData(int,PyBytes,PyBytes,PyBytes)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-qregisterresourcedata)]
            bool cppResult = qRegisterResourceData(cppArg0, reinterpret_cast<uchar *>(PyBytes_AS_STRING(pyArgs[2-1])),
                                                 reinterpret_cast<uchar *>(PyBytes_AS_STRING(pyArgs[3-1])),
                                                 reinterpret_cast<uchar *>(PyBytes_AS_STRING(pyArgs[4-1])));
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-qregisterresourcedata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qRegisterResourceData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qTan(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qTan";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qTan(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // qTan(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qTan_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qTan(qreal)
            qreal cppResult = qTan(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qTan_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qUncompress(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qUncompress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qUncompress", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: qUncompress(QByteArray)
    // 1: qUncompress(const uchar*,int)
    if (numArgs == 2
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // qUncompress(const uchar*,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // qUncompress(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qUncompress_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // qUncompress(const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // qUncompress(QByteArray)
                QByteArray cppResult = qUncompress(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // qUncompress(const uchar * data, int nbytes)
        {
            uchar *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // qUncompress(const uchar*,int)
                QByteArray cppResult = qUncompress(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qUncompress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qUnregisterResourceData(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qUnregisterResourceData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qUnregisterResourceData", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: qUnregisterResourceData(int,PyBytes,PyBytes,PyBytes)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && PyBytes_Check(pyArgs[1])
        && PyBytes_Check(pyArgs[2])
        && PyBytes_Check(pyArgs[3])) {
        overloadId = 0; // qUnregisterResourceData(int,PyBytes,PyBytes,PyBytes)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qUnregisterResourceData_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qUnregisterResourceData(int,PyBytes,PyBytes,PyBytes)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qt-qunregisterresourcedata)]
            bool cppResult = qUnregisterResourceData(cppArg0, reinterpret_cast<uchar *>(PyBytes_AS_STRING(pyArgs[2-1])),
                                                 reinterpret_cast<uchar *>(PyBytes_AS_STRING(pyArgs[3-1])),
                                                 reinterpret_cast<uchar *>(PyBytes_AS_STRING(pyArgs[4-1])));
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qt-qunregisterresourcedata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qUnregisterResourceData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qVersion(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qVersion()
            const char * cppResult = qVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *SbkQtCoreModule_qWarning(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qWarning";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qWarning(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // qWarning(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qWarning_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // qWarning(const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (use-stream-for-format-security)]
            // Uses the stream version for security reasons
            // see gcc man page at -Wformat-security
            Py_BEGIN_ALLOW_THREADS
            qWarning() << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (use-stream-for-format-security)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qWarning_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qrand(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qrand";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qrand()
            int cppResult = qrand();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *SbkQtCoreModule_qsrand(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qsrand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qsrand(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // qsrand(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qsrand_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qsrand(uint)
            qsrand(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qsrand_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtCoreModule_qtTrId(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.qtTrId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto SbkQtCoreModule_qtTrId_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto SbkQtCoreModule_qtTrId_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:qtTrId", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: qtTrId(const char*,int)
    if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // qtTrId(const char*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // qtTrId(const char*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtCoreModule_qtTrId_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_n = Shiboken::String::createStaticString("n");
            if (PyDict_Contains(kwds, key_n)) {
                value = PyDict_GetItem(kwds, key_n);
                if (value && pyArgs[1]) {
                    errInfo = key_n;
                    Py_INCREF(errInfo);
                    goto SbkQtCoreModule_qtTrId_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto SbkQtCoreModule_qtTrId_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_n);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto SbkQtCoreModule_qtTrId_TypeError;
            }
        }
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qtTrId(const char*,int)
            QString cppResult = qtTrId(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtCoreModule_qtTrId_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static PyMethodDef QtCore_methods[] = {
    {"QEnum", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QEnum), METH_O},
    {"QFlag", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QFlag), METH_O},
    {"QT_TRANSLATE_NOOP", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QT_TRANSLATE_NOOP), METH_VARARGS},
    {"QT_TRANSLATE_NOOP3", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QT_TRANSLATE_NOOP3), METH_VARARGS},
    {"QT_TRANSLATE_NOOP_UTF8", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8), METH_O},
    {"QT_TR_NOOP", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QT_TR_NOOP), METH_O},
    {"QT_TR_NOOP_UTF8", reinterpret_cast<PyCFunction>(SbkQtCoreModule_QT_TR_NOOP_UTF8), METH_O},
    {"SIGNAL", reinterpret_cast<PyCFunction>(SbkQtCoreModule_SIGNAL), METH_O},
    {"SLOT", reinterpret_cast<PyCFunction>(SbkQtCoreModule_SLOT), METH_O},
    {"__init_feature__", reinterpret_cast<PyCFunction>(SbkQtCoreModule___init_feature__), METH_NOARGS},
    {"__moduleShutdown", reinterpret_cast<PyCFunction>(SbkQtCoreModule___moduleShutdown), METH_NOARGS},
    {"qAbs", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qAbs), METH_O},
    {"qAcos", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qAcos), METH_O},
    {"qAddPostRoutine", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qAddPostRoutine), METH_O},
    {"qAsin", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qAsin), METH_O},
    {"qAtan", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qAtan), METH_O},
    {"qAtan2", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qAtan2), METH_VARARGS},
    {"qChecksum", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qChecksum), METH_VARARGS},
    {"qCompress", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qCompress), METH_VARARGS|METH_KEYWORDS},
    {"qCritical", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qCritical), METH_O},
    {"qDebug", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qDebug), METH_O},
    {"qExp", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qExp), METH_O},
    {"qFabs", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qFabs), METH_O},
    {"qFastCos", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qFastCos), METH_O},
    {"qFastSin", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qFastSin), METH_O},
    {"qFatal", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qFatal), METH_O},
    {"qFuzzyCompare", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qFuzzyCompare), METH_VARARGS},
    {"qFuzzyIsNull", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qFuzzyIsNull), METH_O},
    {"qInstallMessageHandler", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qInstallMessageHandler), METH_O},
    {"qIsFinite", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qIsFinite), METH_O},
    {"qIsInf", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qIsInf), METH_O},
    {"qIsNaN", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qIsNaN), METH_O},
    {"qIsNull", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qIsNull), METH_O},
    {"qRegisterResourceData", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qRegisterResourceData), METH_VARARGS},
    {"qTan", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qTan), METH_O},
    {"qUncompress", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qUncompress), METH_VARARGS},
    {"qUnregisterResourceData", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qUnregisterResourceData), METH_VARARGS},
    {"qVersion", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qVersion), METH_NOARGS},
    {"qWarning", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qWarning), METH_O},
    {"qrand", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qrand), METH_NOARGS},
    {"qsrand", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qsrand), METH_O},
    {"qtTrId", reinterpret_cast<PyCFunction>(SbkQtCoreModule_qtTrId), METH_VARARGS|METH_KEYWORDS},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtCoreQt(PyObject *module);
void init_QXmlStreamWriter(PyObject *module);
void init_QXmlStreamReader(PyObject *module);
void init_QXmlStreamNotationDeclaration(PyObject *module);
void init_QXmlStreamNamespaceDeclaration(PyObject *module);
void init_QXmlStreamEntityResolver(PyObject *module);
void init_QXmlStreamEntityDeclaration(PyObject *module);
void init_QXmlStreamAttributes(PyObject *module);
void init_QXmlStreamAttribute(PyObject *module);
void init_QWriteLocker(PyObject *module);
void init_QVersionNumber(PyObject *module);
void init_QUuid(PyObject *module);
void init_QUrlQuery(PyObject *module);
void init_QTime(PyObject *module);
void init_QTextStreamManipulator(PyObject *module);
void init_QTextStream(PyObject *module);
void init_QTextEncoder(PyObject *module);
void init_QTextDecoder(PyObject *module);
void init_QTextCodec(PyObject *module);
void init_QTextCodec_ConverterState(PyObject *enclosingClass);
void init_QTextBoundaryFinder(PyObject *module);
void init_QTemporaryDir(PyObject *module);
void init_QSystemSemaphore(PyObject *module);
void init_QSysInfo(PyObject *module);
void init_QStorageInfo(PyObject *module);
void init_QStandardPaths(PyObject *module);
void init_QSocketDescriptor(PyObject *module);
void init_QSizeF(PyObject *module);
void init_QSize(PyObject *module);
void init_QSignalBlocker(PyObject *module);
void init_QSemaphoreReleaser(PyObject *module);
void init_QSemaphore(PyObject *module);
void init_QRunnable(PyObject *module);
void init_QRegularExpressionMatchIterator(PyObject *module);
void init_QRegularExpressionMatch(PyObject *module);
void init_QRegularExpression(PyObject *module);
void init_QRegExp(PyObject *module);
void init_QRecursiveMutex(PyObject *module);
void init_QRectF(PyObject *module);
void init_QRect(PyObject *module);
void init_QReadWriteLock(PyObject *module);
void init_QReadLocker(PyObject *module);
void init_QRandomGenerator(PyObject *module);
void init_QRandomGenerator64(PyObject *module);
void init_QProcessEnvironment(PyObject *module);
void init_QPointF(PyObject *module);
void init_QPoint(PyObject *module);
void init_QPersistentModelIndex(PyObject *module);
void init_QOperatingSystemVersion(PyObject *module);
void init_QOperatingSystemVersionStaticFields();
void init_QMutexLocker(PyObject *module);
void init_QModelIndex(PyObject *module);
void init_QMimeType(PyObject *module);
void init_QMimeDatabase(PyObject *module);
void init_QMetaProperty(PyObject *module);
void init_QMetaEnum(PyObject *module);
void init_QMetaClassInfo(PyObject *module);
void init_QMessageLogContext(PyObject *module);
void init_QMarginsF(PyObject *module);
void init_QMargins(PyObject *module);
void init_QLockFile(PyObject *module);
void init_QLocale(PyObject *module);
void init_QResource(PyObject *module);
void init_QTimeZone(PyObject *module);
void init_QLineF(PyObject *module);
void init_QLine(PyObject *module);
void init_QLibraryInfo(PyObject *module);
void init_QJsonValue(PyObject *module);
void init_QJsonParseError(PyObject *module);
void init_QJsonDocument(PyObject *module);
void init_QJsonArray(PyObject *module);
void init_QItemSelectionRange(PyObject *module);
void init_QItemSelection(PyObject *module);
void init_QGenericArgument(PyObject *module);
void init_QGenericReturnArgument(PyObject *module);
void init_QMetaObject(PyObject *module);
void init_QObject(PyObject *module);
void init_QItemSelectionModel(PyObject *module);
void init_QIODevice(PyObject *module);
void init_QProcess(PyObject *module);
void init_QPluginLoader(PyObject *module);
void init_QSocketNotifier(PyObject *module);
void init_QMimeData(PyObject *module);
void init_QSignalMapper(PyObject *module);
void init_QSettings(PyObject *module);
void init_QTranslator(PyObject *module);
void init_QTimer(PyObject *module);
void init_QTimeLine(PyObject *module);
void init_QThreadPool(PyObject *module);
void init_QMetaObject_Connection(PyObject *enclosingClass);
void init_QMetaMethod(PyObject *module);
void init_QFutureInterfaceBase(PyObject *module);
void init_QFileSystemWatcher(PyObject *module);
void init_QFileSelector(PyObject *module);
void init_QFileInfo(PyObject *module);
void init_QFileDevice(PyObject *module);
void init_QSaveFile(PyObject *module);
void init_QFile(PyObject *module);
void init_QTemporaryFile(PyObject *module);
void init_QFactoryInterface(PyObject *module);
void init_QEventLoop(PyObject *module);
void init_QEvent(PyObject *module);
void init_QTimerEvent(PyObject *module);
void init_QElapsedTimer(PyObject *module);
void init_QEasingCurve(PyObject *module);
void init_QDynamicPropertyChangeEvent(PyObject *module);
void init_QDirIterator(PyObject *module);
void init_QDir(PyObject *module);
void init_QDeadlineTimer(PyObject *module);
void init_QThread(PyObject *module);
void init_QWaitCondition(PyObject *module);
void init_QDateTime(PyObject *module);
void init_QTimeZone_OffsetData(PyObject *enclosingClass);
void init_QDate(PyObject *module);
void init_QDataStream(PyObject *module);
void init_QCryptographicHash(PyObject *module);
void init_QCoreApplication(PyObject *module);
void init_QCommandLineParser(PyObject *module);
void init_QCommandLineOption(PyObject *module);
void init_QCollatorSortKey(PyObject *module);
void init_QCollator(PyObject *module);
void init_QChildEvent(PyObject *module);
void init_QCborStreamWriter(PyObject *module);
void init_QCborStreamReader(PyObject *module);
void init_QCborStringResultString(PyObject *module);
void init_QCborMap(PyObject *module);
void init_QCborError(PyObject *module);
void init_QCborParserError(PyObject *module);
void init_QCborArray(PyObject *module);
void init_QCalendar(PyObject *module);
void init_QCalendar_YearMonthDay(PyObject *enclosingClass);
void init_QByteArrayMatcher(PyObject *module);
void init_QByteArray(PyObject *module);
void init_QByteArray_FromBase64Result(PyObject *enclosingClass);
void init_QMessageAuthenticationCode(PyObject *module);
void init_QCborStringResultByteArray(PyObject *module);
void init_QUrl(PyObject *module);
void init_QCborValue(PyObject *module);
void init_QBuffer(PyObject *module);
void init_QBitArray(PyObject *module);
void init_QBasicTimer(PyObject *module);
void init_QBasicMutex(PyObject *module);
void init_QMutex(PyObject *module);
void init_QAbstractTransition(PyObject *module);
void init_QEventTransition(PyObject *module);
void init_QSignalTransition(PyObject *module);
void init_QAbstractState(PyObject *module);
void init_QState(PyObject *module);
void init_QStateMachine(PyObject *module);
void init_QStateMachine_WrappedEvent(PyObject *enclosingClass);
void init_QStateMachine_SignalEvent(PyObject *enclosingClass);
void init_QHistoryState(PyObject *module);
void init_QFinalState(PyObject *module);
void init_QAbstractNativeEventFilter(PyObject *module);
void init_QAbstractItemModel(PyObject *module);
void init_QAbstractTableModel(PyObject *module);
void init_QAbstractProxyModel(PyObject *module);
void init_QIdentityProxyModel(PyObject *module);
void init_QSortFilterProxyModel(PyObject *module);
void init_QTransposeProxyModel(PyObject *module);
void init_QAbstractListModel(PyObject *module);
void init_QStringListModel(PyObject *module);
void init_QConcatenateTablesProxyModel(PyObject *module);
void init_QAbstractEventDispatcher(PyObject *module);
void init_QAbstractEventDispatcher_TimerInfo(PyObject *enclosingClass);
void init_QAbstractAnimation(PyObject *module);
void init_QPauseAnimation(PyObject *module);
void init_QVariantAnimation(PyObject *module);
void init_QPropertyAnimation(PyObject *module);
void init_QAnimationGroup(PyObject *module);
void init_QParallelAnimationGroup(PyObject *module);
void init_QSequentialAnimationGroup(PyObject *module);

// Enum definitions ------------------------------------------------------------
static void QCborKnownTags_PythonToCpp_QCborKnownTags(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborKnownTags *>(cppOut) =
        static_cast<::QCborKnownTags>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborKnownTags_PythonToCpp_QCborKnownTags_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX]))
        return QCborKnownTags_PythonToCpp_QCborKnownTags;
    return {};
}
static PyObject *QCborKnownTags_CppToPython_QCborKnownTags(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborKnownTags *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], castCppIn);

}


static void QCborSimpleType_PythonToCpp_QCborSimpleType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborSimpleType *>(cppOut) =
        static_cast<::QCborSimpleType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborSimpleType_PythonToCpp_QCborSimpleType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX]))
        return QCborSimpleType_PythonToCpp_QCborSimpleType;
    return {};
}
static PyObject *QCborSimpleType_CppToPython_QCborSimpleType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborSimpleType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], castCppIn);

}


static void QtMsgType_PythonToCpp_QtMsgType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtMsgType *>(cppOut) =
        static_cast<::QtMsgType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtMsgType_PythonToCpp_QtMsgType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX]))
        return QtMsgType_PythonToCpp_QtMsgType;
    return {};
}
static PyObject *QtMsgType_CppToPython_QtMsgType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtMsgType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX], castCppIn);

}




// Module initialization ------------------------------------------------------------

// Primitive Type converters.

// C++ to Python conversion for type 'QChar'.
static PyObject *QChar_CppToPython_QChar(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QChar *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-pyunicode-qchar)]
    wchar_t c = (wchar_t)cppInRef.unicode();
    return PyUnicode_FromWideChar(&c, 1);
    // END of custom code block [file: ../glue/qtcore.cpp (return-pyunicode-qchar)]
    // ========================================================================

}
// Python to C++ conversions for type 'QChar'.
static void PyString_PythonToCpp_QChar(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pystring-char)]
    char c;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<char>(), pyIn, &(c));
    *reinterpret_cast<::QChar *>(cppOut) = QChar(c);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pystring-char)]
    // ========================================================================

}
static PythonToCppFunc is_PyString_PythonToCpp_QChar_Convertible(PyObject *pyIn) {
    if (Shiboken::String::checkChar(pyIn))
        return PyString_PythonToCpp_QChar;
    return {};
}
static void PyInt_PythonToCpp_QChar(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pyint)]
    int i;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &(i));
    *reinterpret_cast<::QChar *>(cppOut) = QChar(i);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pyint)]
    // ========================================================================

}
static PythonToCppFunc is_PyInt_PythonToCpp_QChar_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PyInt_PythonToCpp_QChar;
    return {};
}
static void Py_None_PythonToCpp_QChar(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QChar *>(cppOut) = QChar();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QChar_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QChar;
    return {};
}

// C++ to Python conversion for type 'QJsonObject'.
static PyObject *QJsonObject_CppToPython_QJsonObject(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QJsonObject *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qjsonobject)]
    // The QVariantMap returned by QJsonObject seems to cause a segfault, so
    // using QJsonObject.toVariantMap() won't work.
    // Wrapping it in a QJsonValue first allows it to work
    QJsonValue val(cppInRef);
    QVariant ret = val.toVariant();

    return Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &ret);
    // END of custom code block [file: ../glue/qtcore.cpp (return-qjsonobject)]
    // ========================================================================

}
// Python to C++ conversions for type 'QJsonObject'.
static void PyDict_PythonToCpp_QJsonObject(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qjsonobject-pydict)]
    QVariant dict = QVariant_convertToVariantMap(pyIn);
    QJsonValue val = QJsonValue::fromVariant(dict);
    *reinterpret_cast<::QJsonObject *>(cppOut) = val.toObject();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qjsonobject-pydict)]
    // ========================================================================

}
static PythonToCppFunc is_PyDict_PythonToCpp_QJsonObject_Convertible(PyObject *pyIn) {
    if (PyDict_Check(pyIn))
        return PyDict_PythonToCpp_QJsonObject;
    return {};
}

// C++ to Python conversion for type 'QModelIndexList'.
static PyObject *QModelIndexList_CppToPython_QModelIndexList(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QModelIndexList *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QModelIndexList::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        QModelIndex cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
// Python to C++ conversions for type 'QModelIndexList'.
static void PySequence_PythonToCpp_QModelIndexList(PyObject *pyIn, void *cppOut) {
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QModelIndex cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyItem, &(cppItem));
        *reinterpret_cast<::QModelIndexList *>(cppOut) << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_QModelIndexList_Convertible(PyObject *pyIn) {
    if (Shiboken::String::checkIterable(pyIn))
        return PySequence_PythonToCpp_QModelIndexList;
    return {};
}

// C++ to Python conversion for type 'QString'.
static PyObject *QString_CppToPython_QString(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QString *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-pyunicode)]
    QByteArray ba = cppInRef.toUtf8();
    return PyUnicode_FromStringAndSize(ba.constData(), ba.size());
    // END of custom code block [file: ../glue/qtcore.cpp (return-pyunicode)]
    // ========================================================================

}
// Python to C++ conversions for type 'QString'.
static void PyUnicode_PythonToCpp_QString(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pyunicode)]
#if defined(Py_LIMITED_API)
        wchar_t *temp = PyUnicode_AsWideCharString(pyIn, NULL);
        *reinterpret_cast<::QString *>(cppOut) = QString::fromWCharArray(temp);
        PyMem_Free(temp);
#elif defined(IS_PY3K)
        void *data = PyUnicode_DATA(pyIn);
        Py_ssize_t len = PyUnicode_GetLength(pyIn);
        switch (PyUnicode_KIND(pyIn)) {
            case PyUnicode_1BYTE_KIND:
                *reinterpret_cast<::QString *>(cppOut) = QString::fromLatin1(reinterpret_cast<const char *>(data));
                break;
            case PyUnicode_2BYTE_KIND:
                *reinterpret_cast<::QString *>(cppOut) = QString::fromUtf16(reinterpret_cast<const char16_t *>(data), len);
                break;
            case PyUnicode_4BYTE_KIND:
                *reinterpret_cast<::QString *>(cppOut) = QString::fromUcs4(reinterpret_cast<const char32_t *>(data), len);
                break;
        }
#else // IS_PY3K
    Py_UNICODE *unicode = PyUnicode_AS_UNICODE(pyIn);
#  if defined(Py_UNICODE_WIDE)
    // cast as Py_UNICODE can be a different type
#    if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    *reinterpret_cast<::QString *>(cppOut) = QString::fromUcs4(reinterpret_cast<const char32_t *>(unicode));
#    else
    *reinterpret_cast<::QString *>(cppOut) = QString::fromUcs4(reinterpret_cast<const uint *>(unicode));
#    endif // Qt 6
#  else // Py_UNICODE_WIDE
#    if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    *reinterpret_cast<::QString *>(cppOut) = QString::fromUtf16(reinterpret_cast<const char16_t *>(unicode), PepUnicode_GetLength(pyIn));
#    else
    *reinterpret_cast<::QString *>(cppOut) = QString::fromUtf16(reinterpret_cast<const ushort *>(unicode), PepUnicode_GetLength(pyIn));
#    endif // Qt 6
# endif
#endif // !IS_PY3K
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pyunicode)]
    // ========================================================================

}
static PythonToCppFunc is_PyUnicode_PythonToCpp_QString_Convertible(PyObject *pyIn) {
    if (PyUnicode_Check(pyIn))
        return PyUnicode_PythonToCpp_QString;
    return {};
}
static void PyString_PythonToCpp_QString(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pystring)]
#ifndef IS_PY3K
    const char* str;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), pyIn, &(str));
    //XXX      /|\ omitting this space crashes shiboken!
    *reinterpret_cast<::QString *>(cppOut) = QString(str);
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pystring)]
    // ========================================================================

}
static PythonToCppFunc is_PyString_PythonToCpp_QString_Convertible(PyObject *pyIn) {
    if (py2kStrCheck(pyIn))
        return PyString_PythonToCpp_QString;
    return {};
}
static void Py_None_PythonToCpp_QString(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QString *>(cppOut) = QString();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QString_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QString;
    return {};
}

// C++ to Python conversion for type 'QStringList'.
static PyObject *QStringList_CppToPython_QStringList(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QStringList *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QStringList::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
// Python to C++ conversions for type 'QStringList'.
static void PySequence_PythonToCpp_QStringList(PyObject *pyIn, void *cppOut) {
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        *reinterpret_cast<::QStringList *>(cppOut) << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_QStringList_Convertible(PyObject *pyIn) {
    if (Shiboken::String::checkIterable(pyIn))
        return PySequence_PythonToCpp_QStringList;
    return {};
}

// C++ to Python conversion for type 'QStringRef'.
static PyObject *QStringRef_CppToPython_QStringRef(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QStringRef *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-pyunicode-qstringref)]
    const int N = cppInRef.length();
    wchar_t *str = new wchar_t[N];
    cppInRef.toString().toWCharArray(str);
    PyObject *pyOut = PyUnicode_FromWideChar(str, N);
    delete[] str;
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-pyunicode-qstringref)]
    // ========================================================================

}
// C++ to Python conversion for type 'QVariant'.
static PyObject *QVariant_CppToPython_QVariant(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVariant *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qvariant)]
    if (!cppInRef.isValid())
        Py_RETURN_NONE;

    if (qstrcmp(cppInRef.typeName(), "QVariantList") == 0) {
        QList<QVariant> var = cppInRef.value<QVariantList>();
        return Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QVARIANT_IDX], &var);
    }

    if (qstrcmp(cppInRef.typeName(), "QStringList") == 0) {
        QStringList var = cppInRef.value<QStringList>();
        return Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTRING_IDX], &var);
    }

    if (qstrcmp(cppInRef.typeName(), "QVariantMap") == 0) {
        QMap<QString, QVariant> var = cppInRef.value<QVariantMap>();
        return Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_QSTRING_QVARIANT_IDX], &var);
    }

    Shiboken::Conversions::SpecificConverter converter(cppInRef.typeName());
    if (converter) {
       void *ptr = cppInRef.data();
       return converter.toPython(ptr);
    }
    PyErr_Format(PyExc_RuntimeError, "Can't find converter for '%s'.", cppInRef.typeName());
    return 0;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qvariant)]
    // ========================================================================

}
// Python to C++ conversions for type 'QVariant'.
static void PyBool_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pybool)]
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant(pyIn == Py_True);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pybool)]
    // ========================================================================

}
static PythonToCppFunc is_PyBool_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyBool_Check(pyIn))
        return PyBool_PythonToCpp_QVariant;
    return {};
}
static void Py_None_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QVariant;
    return {};
}
static void QString_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qstring)]
    ::QString in;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &(in));
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant(in);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qstring)]
    // ========================================================================

}
static PythonToCppFunc is_QString_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return QString_PythonToCpp_QVariant;
    return {};
}
static void QByteArray_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray)]
    ::QByteArray in;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn, &(in));
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant(in);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray)]
    // ========================================================================

}
static PythonToCppFunc is_QByteArray_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]))
        return QByteArray_PythonToCpp_QVariant;
    return {};
}
static void PyFloat_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pyfloat)]
    double in;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<double>(), pyIn, &(in));
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant(in);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pyfloat)]
    // ========================================================================

}
static PythonToCppFunc is_PyFloat_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyFloat_CheckExact(pyIn))
        return PyFloat_PythonToCpp_QVariant;
    return {};
}
static void PyInt_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qlonglong)]
    // PYSIDE-1250: For QVariant, if the type fits into an int; use int preferably.
    qlonglong in;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), pyIn, &(in));
    constexpr qlonglong intMax = qint64(std::numeric_limits<int>::max());
    constexpr qlonglong intMin = qint64(std::numeric_limits<int>::min());
    *reinterpret_cast<::QVariant *>(cppOut) = in >= intMin && in <= intMax ? QVariant(int(in)) : QVariant(in);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qlonglong)]
    // ========================================================================

}
static PythonToCppFunc is_PyInt_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyInt_CheckExact(pyIn))
        return PyInt_PythonToCpp_QVariant;
    return {};
}
static void PyLong_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qlonglong)]
    // PYSIDE-1250: For QVariant, if the type fits into an int; use int preferably.
    qlonglong in;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), pyIn, &(in));
    constexpr qlonglong intMax = qint64(std::numeric_limits<int>::max());
    constexpr qlonglong intMin = qint64(std::numeric_limits<int>::min());
    *reinterpret_cast<::QVariant *>(cppOut) = in >= intMin && in <= intMax ? QVariant(int(in)) : QVariant(in);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qlonglong)]
    // ========================================================================

}
static PythonToCppFunc is_PyLong_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyLong_CheckExact(pyIn))
        return PyLong_PythonToCpp_QVariant;
    return {};
}
static void SbkEnumType_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pyint)]
    int i;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &(i));
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant(i);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pyint)]
    // ========================================================================

}
static PythonToCppFunc is_SbkEnumType_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (Shiboken::isShibokenEnum(pyIn))
        return SbkEnumType_PythonToCpp_QVariant;
    return {};
}
static void SbkObject_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-sbkobject)]
    // a class supported by QVariant?
    int typeCode;
    const char *typeName = QVariant_resolveMetaType(Py_TYPE(pyIn), &typeCode);
    if (!typeCode || !typeName) {
        // If the type was not encountered, return a default PyObjectWrapper
        *reinterpret_cast<::QVariant *>(cppOut) = QVariant::fromValue(PySide::PyObjectWrapper(pyIn));
    }
    else {
        QVariant var(typeCode, nullptr);
        Shiboken::Conversions::SpecificConverter converter(typeName);
        converter.toCpp(pyIn, var.data());
        *reinterpret_cast<::QVariant *>(cppOut) = var;
    }
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-sbkobject)]
    // ========================================================================

}
static PythonToCppFunc is_SbkObject_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (Shiboken::Object::checkType(pyIn))
        return SbkObject_PythonToCpp_QVariant;
    return {};
}
static void PyDict_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pydict)]
    QVariant ret = QVariant_convertToVariantMap(pyIn);
    *reinterpret_cast<::QVariant *>(cppOut) = ret.isValid() ? ret : QVariant::fromValue(PySide::PyObjectWrapper(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pydict)]
    // ========================================================================

}
static PythonToCppFunc is_PyDict_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyDict_CheckExact(pyIn))
        return PyDict_PythonToCpp_QVariant;
    return {};
}
static void PyList_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pylist)]
    QVariant ret = QVariant_convertToVariantList(pyIn);
    *reinterpret_cast<::QVariant *>(cppOut) = ret.isValid() ? ret : QVariant::fromValue(PySide::PyObjectWrapper(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pylist)]
    // ========================================================================

}
static PythonToCppFunc is_PyList_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyList_Check(pyIn))
        return PyList_PythonToCpp_QVariant;
    return {};
}
static void PyObject_PythonToCpp_QVariant(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pyobject)]
    // Is a shiboken type not known by Qt
    *reinterpret_cast<::QVariant *>(cppOut) = QVariant::fromValue(PySide::PyObjectWrapper(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pyobject)]
    // ========================================================================

}
static PythonToCppFunc is_PyObject_PythonToCpp_QVariant_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, &PyBaseObject_Type))
        return PyObject_PythonToCpp_QVariant;
    return {};
}

// C++ to Python conversion for type 'QVariant::Type'.
static PyObject *QVariant_Type_CppToPython_QVariant_Type(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVariant::Type *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qvariant-type)]
    const char *typeName = QVariant::typeToName(cppInRef);
    PyObject *pyOut;
    PyTypeObject *pyType = nullptr;
    if (typeName)
        pyType = Shiboken::Conversions::getPythonTypeObject(typeName);
    pyOut = pyType ? (reinterpret_cast<PyObject *>(pyType)) : Py_None;
    Py_INCREF(pyOut);
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qvariant-type)]
    // ========================================================================

}
// Python to C++ conversions for type 'QVariant::Type'.
static void Py_None_PythonToCpp_QVariant_Type(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-invalid)]
    *reinterpret_cast<::QVariant::Type *>(cppOut) = QVariant::Invalid;
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-invalid)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QVariant_Type_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QVariant_Type;
    return {};
}
static void PyTypeObject_PythonToCpp_QVariant_Type(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pytypeobject)]
    const char *typeName;
    if (Shiboken::String::checkType(reinterpret_cast<PyTypeObject *>(pyIn)))
        typeName = "QString";
    else if (pyIn == reinterpret_cast<PyObject *>(&PyFloat_Type))
        typeName = "double"; // float is a UserType in QVariant.
    else if (pyIn == reinterpret_cast<PyObject *>(&PyLong_Type))
        typeName = "int";    // long is a UserType in QVariant.
    else if (Py_TYPE(pyIn) == SbkObjectType_TypeF())
        typeName = Shiboken::ObjectType::getOriginalName((SbkObjectType *)pyIn);
    else
        typeName = reinterpret_cast<PyTypeObject *>(pyIn)->tp_name;
    *reinterpret_cast<::QVariant::Type *>(cppOut) = QVariant::nameToType(typeName);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pytypeobject)]
    // ========================================================================

}
static PythonToCppFunc is_PyTypeObject_PythonToCpp_QVariant_Type_Convertible(PyObject *pyIn) {
    if (PyType_Check(pyIn))
        return PyTypeObject_PythonToCpp_QVariant_Type;
    return {};
}
static void PyString_PythonToCpp_QVariant_Type(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pystring)]
    *reinterpret_cast<::QVariant::Type *>(cppOut) = QVariant::nameToType(Shiboken::String::toCString(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pystring)]
    // ========================================================================

}
static PythonToCppFunc is_PyString_PythonToCpp_QVariant_Type_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PyString_PythonToCpp_QVariant_Type;
    return {};
}
static void PyDict_PythonToCpp_QVariant_Type(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pydict)]
    *reinterpret_cast<::QVariant::Type *>(cppOut) = QVariant::nameToType("QVariantMap");
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pydict)]
    // ========================================================================

}
static PythonToCppFunc is_PyDict_PythonToCpp_QVariant_Type_Convertible(PyObject *pyIn) {
    if (PyDict_Check(pyIn) && QVariantType_checkAllStringKeys(pyIn))
        return PyDict_PythonToCpp_QVariant_Type;
    return {};
}
static void PySequence_PythonToCpp_QVariant_Type(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pysequence)]
    *reinterpret_cast<::QVariant::Type *>(cppOut) = QVariantType_isStringList(pyIn) ? QVariant::StringList : QVariant::List;
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qvariant-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is_PySequence_PythonToCpp_QVariant_Type_Convertible(PyObject *pyIn) {
    if (Shiboken::String::checkIterable(pyIn))
        return PySequence_PythonToCpp_QVariant_Type;
    return {};
}

// C++ to Python conversion for type 'qintptr'.
static PyObject *qintptr_CppToPython_qintptr(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::qintptr *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-pylong)]
    return PyLong_FromLong(cppInRef);
    // END of custom code block [file: ../glue/qtcore.cpp (return-pylong)]
    // ========================================================================

}
// Python to C++ conversions for type 'qintptr'.
static void PyLong_PythonToCpp_qintptr(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pylong)]
    *reinterpret_cast<::qintptr *>(cppOut) = qintptr(PyLong_AsLong(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pylong)]
    // ========================================================================

}
static PythonToCppFunc is_PyLong_PythonToCpp_qintptr_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return PyLong_PythonToCpp_qintptr;
    return {};
}

// C++ to Python conversion for type 'qptrdiff'.
static PyObject *qptrdiff_CppToPython_qptrdiff(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::qptrdiff *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-pylong)]
    return PyLong_FromLong(cppInRef);
    // END of custom code block [file: ../glue/qtcore.cpp (return-pylong)]
    // ========================================================================

}
// Python to C++ conversions for type 'qptrdiff'.
static void PyLong_PythonToCpp_qptrdiff(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pylong)]
    *reinterpret_cast<::qptrdiff *>(cppOut) = qptrdiff(PyLong_AsLong(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pylong)]
    // ========================================================================

}
static PythonToCppFunc is_PyLong_PythonToCpp_qptrdiff_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return PyLong_PythonToCpp_qptrdiff;
    return {};
}

// C++ to Python conversion for type 'quintptr'.
static PyObject *quintptr_CppToPython_quintptr(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::quintptr *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-pylong-quintptr)]
#if defined(IS_PY3K) && QT_POINTER_SIZE == 8
    return PyLong_FromUnsignedLongLong(cppInRef);
#else
    return PyLong_FromUnsignedLong(cppInRef);
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (return-pylong-quintptr)]
    // ========================================================================

}
// Python to C++ conversions for type 'quintptr'.
static void PyLong_PythonToCpp_quintptr(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pylong-quintptr)]
#if defined(IS_PY3K) && QT_POINTER_SIZE == 8
    *reinterpret_cast<::quintptr *>(cppOut) = quintptr(PyLong_AsUnsignedLongLong(pyIn));
#else
    *reinterpret_cast<::quintptr *>(cppOut) = quintptr(PyLong_AsUnsignedLong(pyIn));
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pylong-quintptr)]
    // ========================================================================

}
static PythonToCppFunc is_PyLong_PythonToCpp_quintptr_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return PyLong_PythonToCpp_quintptr;
    return {};
}


// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *constQList_QObjectPTR_REF_CppToPython_constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QObjectPTR_REF_PythonToCpp_constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QObjectPTR_REF_PythonToCpp_constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return constQList_QObjectPTR_REF_PythonToCpp_constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *QList_QByteArray__CppToPython_QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QByteArray__PythonToCpp_QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QByteArray__PythonToCpp_QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return QList_QByteArray__PythonToCpp_QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QAbstractEventDispatcher::TimerInfo >'.
static PyObject *QList_QAbstractEventDispatcher_TimerInfo__CppToPython_QList_QAbstractEventDispatcher_TimerInfo_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractEventDispatcher::TimerInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractEventDispatcher::TimerInfo >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractEventDispatcher::TimerInfo cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QAbstractEventDispatcher_TimerInfo__PythonToCpp_QList_QAbstractEventDispatcher_TimerInfo_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractEventDispatcher::TimerInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractEventDispatcher::TimerInfo cppItem = ::QAbstractEventDispatcher::TimerInfo(int(0), int(0), Qt::PreciseTimer);
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QAbstractEventDispatcher_TimerInfo__PythonToCpp_QList_QAbstractEventDispatcher_TimerInfo__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX]), pyIn))
        return QList_QAbstractEventDispatcher_TimerInfo__PythonToCpp_QList_QAbstractEventDispatcher_TimerInfo_;
    return {};
}

// C++ to Python conversion for type 'const QVector<int > &'.
static PyObject *constQVector_int_REF_CppToPython_constQVector_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<int >::size_type idx = 0; idx < vectorSize; ++idx) {
        int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void constQVector_int_REF_PythonToCpp_constQVector_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_constQVector_int_REF_PythonToCpp_constQVector_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return constQVector_int_REF_PythonToCpp_constQVector_int_REF;
    return {};
}

// C++ to Python conversion for type 'const QHash<int,QByteArray > &'.
static PyObject *constQHash_int_QByteArray_REF_CppToPython_constQHash_int_QByteArray_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<int,QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<int,QByteArray >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QByteArray value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void constQHash_int_QByteArray_REF_PythonToCpp_constQHash_int_QByteArray_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<int,QByteArray > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QByteArray cppValue;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is_constQHash_int_QByteArray_REF_PythonToCpp_constQHash_int_QByteArray_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, pyIn))
        return constQHash_int_QByteArray_REF_PythonToCpp_constQHash_int_QByteArray_REF;
    return {};
}

// C++ to Python conversion for type 'QMap<int,QVariant >'.
static PyObject *QMap_int_QVariant__CppToPython_QMap_int_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<int,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<int,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void QMap_int_QVariant__PythonToCpp_QMap_int_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is_QMap_int_QVariant__PythonToCpp_QMap_int_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return QMap_int_QVariant__PythonToCpp_QMap_int_QVariant_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPersistentModelIndex > &'.
static PyObject *constQList_QPersistentModelIndex_REF_CppToPython_constQList_QPersistentModelIndex_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPersistentModelIndex >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPersistentModelIndex cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QPersistentModelIndex_REF_PythonToCpp_constQList_QPersistentModelIndex_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPersistentModelIndex cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QPersistentModelIndex_REF_PythonToCpp_constQList_QPersistentModelIndex_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyIn))
        return constQList_QPersistentModelIndex_REF_PythonToCpp_constQList_QPersistentModelIndex_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QAbstractAnimation* >'.
static PyObject *QList_QAbstractAnimationPTR__CppToPython_QList_QAbstractAnimationPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractAnimation* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractAnimation* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractAnimation* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QAbstractAnimationPTR__PythonToCpp_QList_QAbstractAnimationPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractAnimation* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractAnimation* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QAbstractAnimationPTR__PythonToCpp_QList_QAbstractAnimationPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], pyIn))
        return QList_QAbstractAnimationPTR__PythonToCpp_QList_QAbstractAnimationPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QAbstractState* > &'.
static PyObject *constQList_QAbstractStatePTR_REF_CppToPython_constQList_QAbstractStatePTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractState* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractState* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractState* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QAbstractStatePTR_REF_PythonToCpp_constQList_QAbstractStatePTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractState* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractState* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QAbstractStatePTR_REF_PythonToCpp_constQList_QAbstractStatePTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX], pyIn))
        return constQList_QAbstractStatePTR_REF_PythonToCpp_constQList_QAbstractStatePTR_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QVariant > &'.
static PyObject *constQList_QVariant_REF_CppToPython_constQList_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QVariant_REF_PythonToCpp_constQList_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QVariant_REF_PythonToCpp_constQList_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return constQList_QVariant_REF_PythonToCpp_constQList_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'const QHash<QString,QVariant > &'.
static PyObject *constQHash_QString_QVariant_REF_CppToPython_constQHash_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void constQHash_QString_QVariant_REF_PythonToCpp_constQHash_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is_constQHash_QString_QVariant_REF_PythonToCpp_constQHash_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return constQHash_QString_QVariant_REF_PythonToCpp_constQHash_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'const QMap<QString,QVariant > &'.
static PyObject *constQMap_QString_QVariant_REF_CppToPython_constQMap_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void constQMap_QString_QVariant_REF_PythonToCpp_constQMap_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is_constQMap_QString_QVariant_REF_PythonToCpp_constQMap_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return constQMap_QString_QVariant_REF_PythonToCpp_constQMap_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<QCborValue >'.
static PyObject *QVector_QCborValue__CppToPython_QVector_QCborValue_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QCborValue > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QCborValue >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QCborValue >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QCborValue cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QCborValue__PythonToCpp_QVector_QCborValue_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QCborValue > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QCborValue cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QCborValue__PythonToCpp_QVector_QCborValue__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pyIn))
        return QVector_QCborValue__PythonToCpp_QVector_QCborValue_;
    return {};
}

// C++ to Python conversion for type 'const QList<QCommandLineOption > &'.
static PyObject *constQList_QCommandLineOption_REF_CppToPython_constQList_QCommandLineOption_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QCommandLineOption > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QCommandLineOption >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QCommandLineOption cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QCommandLineOption_REF_PythonToCpp_constQList_QCommandLineOption_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QCommandLineOption > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QCommandLineOption cppItem = ::QCommandLineOption(::QStringList());
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QCommandLineOption_REF_PythonToCpp_constQList_QCommandLineOption_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), pyIn))
        return constQList_QCommandLineOption_REF_PythonToCpp_constQList_QCommandLineOption_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QAbstractItemModel* >'.
static PyObject *QList_QAbstractItemModelPTR__CppToPython_QList_QAbstractItemModelPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractItemModel* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractItemModel* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractItemModel* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QAbstractItemModelPTR__PythonToCpp_QList_QAbstractItemModelPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractItemModel* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractItemModel* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QAbstractItemModelPTR__PythonToCpp_QList_QAbstractItemModelPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX], pyIn))
        return QList_QAbstractItemModelPTR__PythonToCpp_QList_QAbstractItemModelPTR_;
    return {};
}

// C++ to Python conversion for type 'QPair<qint64,unsigned int >'.
static PyObject *QPair_qint64_unsignedint__CppToPython_QPair_qint64_unsignedint_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<qint64,unsigned int > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void QPair_qint64_unsignedint__PythonToCpp_QPair_qint64_unsignedint_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<qint64,unsigned int > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is_QPair_qint64_unsignedint__PythonToCpp_QPair_qint64_unsignedint__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), false, Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), false, pyIn))
        return QPair_qint64_unsignedint__PythonToCpp_QPair_qint64_unsignedint_;
    return {};
}

// C++ to Python conversion for type 'QList<QFileInfo >'.
static PyObject *QList_QFileInfo__CppToPython_QList_QFileInfo_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QFileInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QFileInfo >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QFileInfo cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QFileInfo__PythonToCpp_QList_QFileInfo_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QFileInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QFileInfo cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QFileInfo__PythonToCpp_QList_QFileInfo__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pyIn))
        return QList_QFileInfo__PythonToCpp_QList_QFileInfo_;
    return {};
}

// C++ to Python conversion for type 'QVector<QPointF >'.
static PyObject *QVector_QPointF__CppToPython_QVector_QPointF_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPointF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPointF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPointF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPointF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QPointF__PythonToCpp_QVector_QPointF_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPointF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPointF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QPointF__PythonToCpp_QVector_QPointF__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyIn))
        return QVector_QPointF__PythonToCpp_QVector_QPointF_;
    return {};
}

// C++ to Python conversion for type 'const QList<QItemSelectionRange > &'.
static PyObject *constQList_QItemSelectionRange_REF_CppToPython_constQList_QItemSelectionRange_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QItemSelectionRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QItemSelectionRange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QItemSelectionRange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QItemSelectionRange_REF_PythonToCpp_constQList_QItemSelectionRange_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QItemSelectionRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QItemSelectionRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QItemSelectionRange_REF_PythonToCpp_constQList_QItemSelectionRange_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pyIn))
        return constQList_QItemSelectionRange_REF_PythonToCpp_constQList_QItemSelectionRange_REF;
    return {};
}

// C++ to Python conversion for type 'const QSet<QItemSelectionRange > &'.
static PyObject *constQSet_QItemSelectionRange_REF_CppToPython_constQSet_QItemSelectionRange_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QSet<QItemSelectionRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QSet<QItemSelectionRange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QItemSelectionRange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQSet_QItemSelectionRange_REF_PythonToCpp_constQSet_QItemSelectionRange_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QSet<QItemSelectionRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QItemSelectionRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQSet_QItemSelectionRange_REF_PythonToCpp_constQSet_QItemSelectionRange_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pyIn))
        return constQSet_QItemSelectionRange_REF_PythonToCpp_constQSet_QItemSelectionRange_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QItemSelectionRange > &'.
static PyObject *constQVector_QItemSelectionRange_REF_CppToPython_constQVector_QItemSelectionRange_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QItemSelectionRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QItemSelectionRange >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QItemSelectionRange >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QItemSelectionRange cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void constQVector_QItemSelectionRange_REF_PythonToCpp_constQVector_QItemSelectionRange_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QItemSelectionRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QItemSelectionRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_constQVector_QItemSelectionRange_REF_PythonToCpp_constQVector_QItemSelectionRange_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pyIn))
        return constQVector_QItemSelectionRange_REF_PythonToCpp_constQVector_QItemSelectionRange_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QLocale::Country >'.
static PyObject *QList_QLocale_Country__CppToPython_QList_QLocale_Country_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QLocale::Country > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QLocale::Country >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QLocale::Country cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QLocale_Country__PythonToCpp_QList_QLocale_Country_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QLocale::Country > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLocale::Country cppItem{QLocale::AnyCountry};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QLocale_Country__PythonToCpp_QList_QLocale_Country__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, pyIn))
        return QList_QLocale_Country__PythonToCpp_QList_QLocale_Country_;
    return {};
}

// C++ to Python conversion for type 'QList<QLocale >'.
static PyObject *QList_QLocale__CppToPython_QList_QLocale_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QLocale > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QLocale >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QLocale cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QLocale__PythonToCpp_QList_QLocale_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QLocale > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLocale cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QLocale__PythonToCpp_QList_QLocale__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pyIn))
        return QList_QLocale__PythonToCpp_QList_QLocale_;
    return {};
}

// C++ to Python conversion for type 'QList<Qt::DayOfWeek >'.
static PyObject *QList_Qt_DayOfWeek__CppToPython_QList_Qt_DayOfWeek_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<Qt::DayOfWeek > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<Qt::DayOfWeek >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::Qt::DayOfWeek cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_Qt_DayOfWeek__PythonToCpp_QList_Qt_DayOfWeek_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<Qt::DayOfWeek > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt::DayOfWeek cppItem = static_cast< ::Qt::DayOfWeek>(0);
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_Qt_DayOfWeek__PythonToCpp_QList_Qt_DayOfWeek__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX])->converter, pyIn))
        return QList_Qt_DayOfWeek__PythonToCpp_QList_Qt_DayOfWeek_;
    return {};
}

// C++ to Python conversion for type 'const QList<QUrl > &'.
static PyObject *constQList_QUrl_REF_CppToPython_constQList_QUrl_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QUrl > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QUrl >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QUrl cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QUrl_REF_PythonToCpp_constQList_QUrl_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QUrl > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QUrl cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QUrl_REF_PythonToCpp_constQList_QUrl_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyIn))
        return constQList_QUrl_REF_PythonToCpp_constQList_QUrl_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QMimeType >'.
static PyObject *QList_QMimeType__CppToPython_QList_QMimeType_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QMimeType > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QMimeType >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QMimeType cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QMimeType__PythonToCpp_QList_QMimeType_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QMimeType > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QMimeType cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QMimeType__PythonToCpp_QList_QMimeType__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), pyIn))
        return QList_QMimeType__PythonToCpp_QList_QMimeType_;
    return {};
}

// C++ to Python conversion for type 'QPair<qreal,QVariant >'.
static PyObject *QPair_qreal_QVariant__CppToPython_QPair_qreal_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<qreal,QVariant > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void QPair_qreal_QVariant__PythonToCpp_QPair_qreal_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<qreal,QVariant > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is_QPair_qreal_QVariant__PythonToCpp_QPair_qreal_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return QPair_qreal_QVariant__PythonToCpp_QPair_qreal_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QVector<QPair< qreal,QVariant > >'.
static PyObject *QVector_QPair_qreal_QVariant___CppToPython_QVector_QPair_qreal_QVariant__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPair< qreal,QVariant > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPair< qreal,QVariant > >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPair< qreal,QVariant > >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPair<qreal,QVariant > cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QREAL_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QPair_qreal_QVariant___PythonToCpp_QVector_QPair_qreal_QVariant__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPair< qreal,QVariant > > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<qreal,QVariant > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QREAL_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QPair_qreal_QVariant___PythonToCpp_QVector_QPair_qreal_QVariant___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QREAL_QVARIANT_IDX], pyIn))
        return QVector_QPair_qreal_QVariant___PythonToCpp_QVector_QPair_qreal_QVariant__;
    return {};
}

// C++ to Python conversion for type 'QList<QAbstractTransition* >'.
static PyObject *QList_QAbstractTransitionPTR__CppToPython_QList_QAbstractTransitionPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractTransition* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractTransition* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractTransition* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QAbstractTransitionPTR__PythonToCpp_QList_QAbstractTransitionPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractTransition* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractTransition* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QAbstractTransitionPTR__PythonToCpp_QList_QAbstractTransitionPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX], pyIn))
        return QList_QAbstractTransitionPTR__PythonToCpp_QList_QAbstractTransitionPTR_;
    return {};
}

// C++ to Python conversion for type 'QSet<QAbstractState* >'.
static PyObject *QSet_QAbstractStatePTR__CppToPython_QSet_QAbstractStatePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QSet<QAbstractState* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QSet<QAbstractState* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractState* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QSet_QAbstractStatePTR__PythonToCpp_QSet_QAbstractStatePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QSet<QAbstractState* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractState* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QSet_QAbstractStatePTR__PythonToCpp_QSet_QAbstractStatePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX], pyIn))
        return QSet_QAbstractStatePTR__PythonToCpp_QSet_QAbstractStatePTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QStorageInfo >'.
static PyObject *QList_QStorageInfo__CppToPython_QList_QStorageInfo_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QStorageInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QStorageInfo >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QStorageInfo cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QStorageInfo__PythonToCpp_QList_QStorageInfo_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QStorageInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QStorageInfo cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QStorageInfo__PythonToCpp_QList_QStorageInfo__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), pyIn))
        return QList_QStorageInfo__PythonToCpp_QList_QStorageInfo_;
    return {};
}

// C++ to Python conversion for type 'QList<int >'.
static PyObject *QList_int__CppToPython_QList_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<int >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        int cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_int__PythonToCpp_QList_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_int__PythonToCpp_QList_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return QList_int__PythonToCpp_QList_int_;
    return {};
}

// C++ to Python conversion for type 'QVector<QTimeZone::OffsetData >'.
static PyObject *QVector_QTimeZone_OffsetData__CppToPython_QVector_QTimeZone_OffsetData_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QTimeZone::OffsetData > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QTimeZone::OffsetData >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QTimeZone::OffsetData >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QTimeZone::OffsetData cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QTimeZone_OffsetData__PythonToCpp_QVector_QTimeZone_OffsetData_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QTimeZone::OffsetData > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTimeZone::OffsetData cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QTimeZone_OffsetData__PythonToCpp_QVector_QTimeZone_OffsetData__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), pyIn))
        return QVector_QTimeZone_OffsetData__PythonToCpp_QVector_QTimeZone_OffsetData_;
    return {};
}

// C++ to Python conversion for type 'QPair<QString,QString >'.
static PyObject *QPair_QString_QString__CppToPython_QPair_QString_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QString,QString > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void QPair_QString_QString__PythonToCpp_QPair_QString_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QString,QString > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is_QPair_QString_QString__PythonToCpp_QPair_QString_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, pyIn))
        return QPair_QString_QString__PythonToCpp_QPair_QString_QString_;
    return {};
}

// C++ to Python conversion for type 'QList<QPair< QString,QString > >'.
static PyObject *QList_QPair_QString_QString___CppToPython_QList_QPair_QString_QString__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPair< QString,QString > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPair< QString,QString > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPair<QString,QString > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QSTRING_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QPair_QString_QString___PythonToCpp_QList_QPair_QString_QString__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPair< QString,QString > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<QString,QString > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QSTRING_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QPair_QString_QString___PythonToCpp_QList_QPair_QString_QString___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QSTRING_QSTRING_IDX], pyIn))
        return QList_QPair_QString_QString___PythonToCpp_QList_QPair_QString_QString__;
    return {};
}

// C++ to Python conversion for type 'QVector<QXmlStreamAttribute > &'.
static PyObject *QVector_QXmlStreamAttribute_REF_CppToPython_QVector_QXmlStreamAttribute_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QXmlStreamAttribute > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QXmlStreamAttribute >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QXmlStreamAttribute >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QXmlStreamAttribute cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QXmlStreamAttribute_REF_PythonToCpp_QVector_QXmlStreamAttribute_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QXmlStreamAttribute > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QXmlStreamAttribute cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QXmlStreamAttribute_REF_PythonToCpp_QVector_QXmlStreamAttribute_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pyIn))
        return QVector_QXmlStreamAttribute_REF_PythonToCpp_QVector_QXmlStreamAttribute_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QXmlStreamAttribute > &'.
static PyObject *constQList_QXmlStreamAttribute_REF_CppToPython_constQList_QXmlStreamAttribute_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QXmlStreamAttribute > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QXmlStreamAttribute >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QXmlStreamAttribute cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void constQList_QXmlStreamAttribute_REF_PythonToCpp_constQList_QXmlStreamAttribute_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QXmlStreamAttribute > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QXmlStreamAttribute cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_constQList_QXmlStreamAttribute_REF_PythonToCpp_constQList_QXmlStreamAttribute_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pyIn))
        return constQList_QXmlStreamAttribute_REF_PythonToCpp_constQList_QXmlStreamAttribute_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QXmlStreamNamespaceDeclaration > &'.
static PyObject *constQVector_QXmlStreamNamespaceDeclaration_REF_CppToPython_constQVector_QXmlStreamNamespaceDeclaration_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QXmlStreamNamespaceDeclaration > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QXmlStreamNamespaceDeclaration >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QXmlStreamNamespaceDeclaration >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QXmlStreamNamespaceDeclaration cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void constQVector_QXmlStreamNamespaceDeclaration_REF_PythonToCpp_constQVector_QXmlStreamNamespaceDeclaration_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QXmlStreamNamespaceDeclaration > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QXmlStreamNamespaceDeclaration cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_constQVector_QXmlStreamNamespaceDeclaration_REF_PythonToCpp_constQVector_QXmlStreamNamespaceDeclaration_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX]), pyIn))
        return constQVector_QXmlStreamNamespaceDeclaration_REF_PythonToCpp_constQVector_QXmlStreamNamespaceDeclaration_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<QXmlStreamEntityDeclaration >'.
static PyObject *QVector_QXmlStreamEntityDeclaration__CppToPython_QVector_QXmlStreamEntityDeclaration_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QXmlStreamEntityDeclaration > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QXmlStreamEntityDeclaration >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QXmlStreamEntityDeclaration >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QXmlStreamEntityDeclaration cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QXmlStreamEntityDeclaration__PythonToCpp_QVector_QXmlStreamEntityDeclaration_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QXmlStreamEntityDeclaration > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QXmlStreamEntityDeclaration cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QXmlStreamEntityDeclaration__PythonToCpp_QVector_QXmlStreamEntityDeclaration__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), pyIn))
        return QVector_QXmlStreamEntityDeclaration__PythonToCpp_QVector_QXmlStreamEntityDeclaration_;
    return {};
}

// C++ to Python conversion for type 'QVector<QXmlStreamNotationDeclaration >'.
static PyObject *QVector_QXmlStreamNotationDeclaration__CppToPython_QVector_QXmlStreamNotationDeclaration_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QXmlStreamNotationDeclaration > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QXmlStreamNotationDeclaration >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QXmlStreamNotationDeclaration >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QXmlStreamNotationDeclaration cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNOTATIONDECLARATION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void QVector_QXmlStreamNotationDeclaration__PythonToCpp_QVector_QXmlStreamNotationDeclaration_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QXmlStreamNotationDeclaration > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QXmlStreamNotationDeclaration cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNOTATIONDECLARATION_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is_QVector_QXmlStreamNotationDeclaration__PythonToCpp_QVector_QXmlStreamNotationDeclaration__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNOTATIONDECLARATION_IDX]), pyIn))
        return QVector_QXmlStreamNotationDeclaration__PythonToCpp_QVector_QXmlStreamNotationDeclaration_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *QList_QString__CppToPython_QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void QList_QString__PythonToCpp_QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is_QList_QString__PythonToCpp_QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return QList_QString__PythonToCpp_QList_QString_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtCore",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtCore_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCore_SignatureStrings[] = {
    "PySide2.QtCore.QEnum(arg__1:PyObject)->PyObject",
    "PySide2.QtCore.QFlag(arg__1:PyObject)->PyObject",
    "PySide2.QtCore.QT_TRANSLATE_NOOP(arg__1:PyObject,arg__2:PyObject)->PyObject",
    "PySide2.QtCore.QT_TRANSLATE_NOOP3(arg__1:PyObject,arg__2:PyObject,arg__3:PyObject)->PyObject",
    "PySide2.QtCore.QT_TRANSLATE_NOOP_UTF8(arg__1:PyObject)->PyObject",
    "PySide2.QtCore.QT_TR_NOOP(arg__1:PyObject)->PyObject",
    "PySide2.QtCore.QT_TR_NOOP_UTF8(arg__1:PyObject)->PyObject",
    "PySide2.QtCore.SIGNAL(arg__1:char*)->str",
    "PySide2.QtCore.SLOT(arg__1:char*)->str",
    "PySide2.QtCore.__init_feature__()",
    "PySide2.QtCore.__moduleShutdown()",
    "PySide2.QtCore.qAbs(arg__1:double)->double",
    "PySide2.QtCore.qAcos(v:qreal)->qreal",
    "PySide2.QtCore.qAddPostRoutine(arg__1:PyObject)",
    "PySide2.QtCore.qAsin(v:qreal)->qreal",
    "PySide2.QtCore.qAtan(v:qreal)->qreal",
    "PySide2.QtCore.qAtan2(y:qreal,x:qreal)->qreal",
    "PySide2.QtCore.qChecksum(s:char*,len:uint)->quint16",
    "1:PySide2.QtCore.qCompress(data:PySide2.QtCore.QByteArray,compressionLevel:int=-1)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.qCompress(data:uchar*,nbytes:int,compressionLevel:int=-1)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.qCritical(arg__1:char*)",
    "PySide2.QtCore.qDebug(arg__1:char*)",
    "PySide2.QtCore.qExp(v:qreal)->qreal",
    "PySide2.QtCore.qFabs(v:qreal)->qreal",
    "PySide2.QtCore.qFastCos(x:qreal)->qreal",
    "PySide2.QtCore.qFastSin(x:qreal)->qreal",
    "PySide2.QtCore.qFatal(arg__1:char*)",
    "PySide2.QtCore.qFuzzyCompare(p1:double,p2:double)->bool",
    "PySide2.QtCore.qFuzzyIsNull(d:double)->bool",
    "PySide2.QtCore.qInstallMessageHandler(arg__1:PyObject)->PyObject",
    "PySide2.QtCore.qIsFinite(d:double)->bool",
    "PySide2.QtCore.qIsInf(d:double)->bool",
    "PySide2.QtCore.qIsNaN(d:double)->bool",
    "PySide2.QtCore.qIsNull(d:double)->bool",
    "PySide2.QtCore.qRegisterResourceData(arg__1:int,arg__2:PyBytes,arg__3:PyBytes,arg__4:PyBytes)->bool",
    "PySide2.QtCore.qTan(v:qreal)->qreal",
    "1:PySide2.QtCore.qUncompress(data:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.qUncompress(data:uchar*,nbytes:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.qUnregisterResourceData(arg__1:int,arg__2:PyBytes,arg__3:PyBytes,arg__4:PyBytes)->bool",
    "PySide2.QtCore.qVersion()->char*",
    "PySide2.QtCore.qWarning(arg__1:char*)",
    "PySide2.QtCore.qrand()->int",
    "PySide2.QtCore.qsrand(seed:uint)",
    "PySide2.QtCore.qtTrId(id:char*,n:int=-1)->QString",
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtCore)
    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtCore_IDX_COUNT];
    SbkPySide2_QtCoreTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtCore_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtCoreTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtCore", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtCore", QtCore_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtCoreModuleObject = module;

    // Initialize classes in the type system
    init_QtCoreQt(module);
    init_QXmlStreamWriter(module);
    init_QXmlStreamReader(module);
    init_QXmlStreamNotationDeclaration(module);
    init_QXmlStreamNamespaceDeclaration(module);
    init_QXmlStreamEntityResolver(module);
    init_QXmlStreamEntityDeclaration(module);
    init_QXmlStreamAttributes(module);
    init_QXmlStreamAttribute(module);
    init_QWriteLocker(module);
    init_QVersionNumber(module);
    init_QUuid(module);
    init_QUrlQuery(module);
    init_QTime(module);
    init_QTextStreamManipulator(module);
    init_QTextStream(module);
    init_QTextEncoder(module);
    init_QTextDecoder(module);
    init_QTextCodec(module);
    init_QTextCodec_ConverterState(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX])->tp_dict);
    init_QTextBoundaryFinder(module);
    init_QTemporaryDir(module);
    init_QSystemSemaphore(module);
    init_QSysInfo(module);
    init_QStorageInfo(module);
    init_QStandardPaths(module);
    init_QSocketDescriptor(module);
    init_QSizeF(module);
    init_QSize(module);
    init_QSignalBlocker(module);
    init_QSemaphoreReleaser(module);
    init_QSemaphore(module);
    init_QRunnable(module);
    init_QRegularExpressionMatchIterator(module);
    init_QRegularExpressionMatch(module);
    init_QRegularExpression(module);
    init_QRegExp(module);
    init_QRecursiveMutex(module);
    init_QRectF(module);
    init_QRect(module);
    init_QReadWriteLock(module);
    init_QReadLocker(module);
    init_QRandomGenerator(module);
    init_QRandomGenerator64(module);
    init_QProcessEnvironment(module);
    init_QPointF(module);
    init_QPoint(module);
    init_QPersistentModelIndex(module);
    init_QOperatingSystemVersion(module);
    init_QMutexLocker(module);
    init_QModelIndex(module);
    init_QMimeType(module);
    init_QMimeDatabase(module);
    init_QMetaProperty(module);
    init_QMetaEnum(module);
    init_QMetaClassInfo(module);
    init_QMessageLogContext(module);
    init_QMarginsF(module);
    init_QMargins(module);
    init_QLockFile(module);
    init_QLocale(module);
    init_QResource(module);
    init_QTimeZone(module);
    init_QLineF(module);
    init_QLine(module);
    init_QLibraryInfo(module);
    init_QJsonValue(module);
    init_QJsonParseError(module);
    init_QJsonDocument(module);
    init_QJsonArray(module);
    init_QItemSelectionRange(module);
    init_QItemSelection(module);
    init_QGenericArgument(module);
    init_QGenericReturnArgument(module);
    init_QMetaObject(module);
    init_QObject(module);
    init_QItemSelectionModel(module);
    init_QIODevice(module);
    init_QProcess(module);
    init_QPluginLoader(module);
    init_QSocketNotifier(module);
    init_QMimeData(module);
    init_QSignalMapper(module);
    init_QSettings(module);
    init_QTranslator(module);
    init_QTimer(module);
    init_QTimeLine(module);
    init_QThreadPool(module);
    init_QMetaObject_Connection(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX])->tp_dict);
    init_QMetaMethod(module);
    init_QFutureInterfaceBase(module);
    init_QFileSystemWatcher(module);
    init_QFileSelector(module);
    init_QFileInfo(module);
    init_QFileDevice(module);
    init_QSaveFile(module);
    init_QFile(module);
    init_QTemporaryFile(module);
    init_QFactoryInterface(module);
    init_QEventLoop(module);
    init_QEvent(module);
    init_QTimerEvent(module);
    init_QElapsedTimer(module);
    init_QEasingCurve(module);
    init_QDynamicPropertyChangeEvent(module);
    init_QDirIterator(module);
    init_QDir(module);
    init_QDeadlineTimer(module);
    init_QThread(module);
    init_QWaitCondition(module);
    init_QDateTime(module);
    init_QTimeZone_OffsetData(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX])->tp_dict);
    init_QDate(module);
    init_QDataStream(module);
    init_QCryptographicHash(module);
    init_QCoreApplication(module);
    init_QCommandLineParser(module);
    init_QCommandLineOption(module);
    init_QCollatorSortKey(module);
    init_QCollator(module);
    init_QChildEvent(module);
    init_QCborStreamWriter(module);
    init_QCborStreamReader(module);
    init_QCborStringResultString(module);
    init_QCborMap(module);
    init_QCborError(module);
    init_QCborParserError(module);
    init_QCborArray(module);
    init_QCalendar(module);
    init_QCalendar_YearMonthDay(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX])->tp_dict);
    init_QByteArrayMatcher(module);
    init_QByteArray(module);
    init_QByteArray_FromBase64Result(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->tp_dict);
    init_QMessageAuthenticationCode(module);
    init_QCborStringResultByteArray(module);
    init_QUrl(module);
    init_QCborValue(module);
    init_QBuffer(module);
    init_QBitArray(module);
    init_QBasicTimer(module);
    init_QBasicMutex(module);
    init_QMutex(module);
    init_QAbstractTransition(module);
    init_QEventTransition(module);
    init_QSignalTransition(module);
    init_QAbstractState(module);
    init_QState(module);
    init_QStateMachine(module);
    init_QStateMachine_WrappedEvent(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX])->tp_dict);
    init_QStateMachine_SignalEvent(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX])->tp_dict);
    init_QHistoryState(module);
    init_QFinalState(module);
    init_QAbstractNativeEventFilter(module);
    init_QAbstractItemModel(module);
    init_QAbstractTableModel(module);
    init_QAbstractProxyModel(module);
    init_QIdentityProxyModel(module);
    init_QSortFilterProxyModel(module);
    init_QTransposeProxyModel(module);
    init_QAbstractListModel(module);
    init_QStringListModel(module);
    init_QConcatenateTablesProxyModel(module);
    init_QAbstractEventDispatcher(module);
    init_QAbstractEventDispatcher_TimerInfo(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX])->tp_dict);
    init_QAbstractAnimation(module);
    init_QPauseAnimation(module);
    init_QVariantAnimation(module);
    init_QPropertyAnimation(module);
    init_QAnimationGroup(module);
    init_QParallelAnimationGroup(module);
    init_QSequentialAnimationGroup(module);

    // Register converter for type 'PySide2.QtCore.QChar'.
    SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX] = Shiboken::Conversions::createConverter(0, QChar_CppToPython_QChar);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], "QChar");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX],
        PyString_PythonToCpp_QChar,
        is_PyString_PythonToCpp_QChar_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX],
        PyInt_PythonToCpp_QChar,
        is_PyInt_PythonToCpp_QChar_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX],
        Py_None_PythonToCpp_QChar,
        is_Py_None_PythonToCpp_QChar_Convertible);

    // Register converter for type 'PySide2.QtCore.QJsonObject'.
    SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX] = Shiboken::Conversions::createConverter(0, QJsonObject_CppToPython_QJsonObject);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], "QJsonObject");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX],
        PyDict_PythonToCpp_QJsonObject,
        is_PyDict_PythonToCpp_QJsonObject_Convertible);

    // Register converter for type 'PySide2.QtCore.QModelIndexList'.
    SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX] = Shiboken::Conversions::createConverter(0, QModelIndexList_CppToPython_QModelIndexList);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], "QModelIndexList");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX],
        PySequence_PythonToCpp_QModelIndexList,
        is_PySequence_PythonToCpp_QModelIndexList_Convertible);

    // Register converter for type 'PySide2.QtCore.QString'.
    SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyUnicode_Type, QString_CppToPython_QString);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], "QString");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX],
        PyUnicode_PythonToCpp_QString,
        is_PyUnicode_PythonToCpp_QString_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX],
        PyString_PythonToCpp_QString,
        is_PyString_PythonToCpp_QString_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX],
        Py_None_PythonToCpp_QString,
        is_Py_None_PythonToCpp_QString_Convertible);

    // Register converter for type 'PySide2.QtCore.QStringList'.
    SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX] = Shiboken::Conversions::createConverter(0, QStringList_CppToPython_QStringList);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], "QStringList");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX],
        PySequence_PythonToCpp_QStringList,
        is_PySequence_PythonToCpp_QStringList_Convertible);

    // Register converter for type 'PySide2.QtCore.QStringRef'.
    SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX] = Shiboken::Conversions::createConverter(0, QStringRef_CppToPython_QStringRef);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], "QStringRef");

    // Register converter for type 'PySide2.QtCore.QVariant'.
    SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyBaseObject_Type, QVariant_CppToPython_QVariant);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], "QVariant");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyBool_PythonToCpp_QVariant,
        is_PyBool_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        Py_None_PythonToCpp_QVariant,
        is_Py_None_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        QString_PythonToCpp_QVariant,
        is_QString_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        QByteArray_PythonToCpp_QVariant,
        is_QByteArray_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyFloat_PythonToCpp_QVariant,
        is_PyFloat_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyInt_PythonToCpp_QVariant,
        is_PyInt_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyLong_PythonToCpp_QVariant,
        is_PyLong_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        SbkEnumType_PythonToCpp_QVariant,
        is_SbkEnumType_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        SbkObject_PythonToCpp_QVariant,
        is_SbkObject_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyDict_PythonToCpp_QVariant,
        is_PyDict_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyList_PythonToCpp_QVariant,
        is_PyList_PythonToCpp_QVariant_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX],
        PyObject_PythonToCpp_QVariant,
        is_PyObject_PythonToCpp_QVariant_Convertible);

    // Register converter for type 'PySide2.QtCore.QVariant::Type'.
    SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX] = Shiboken::Conversions::createConverter(0, QVariant_Type_CppToPython_QVariant_Type);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX], "QVariant::Type");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX],
        Py_None_PythonToCpp_QVariant_Type,
        is_Py_None_PythonToCpp_QVariant_Type_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX],
        PyTypeObject_PythonToCpp_QVariant_Type,
        is_PyTypeObject_PythonToCpp_QVariant_Type_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX],
        PyString_PythonToCpp_QVariant_Type,
        is_PyString_PythonToCpp_QVariant_Type_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX],
        PyDict_PythonToCpp_QVariant_Type,
        is_PyDict_PythonToCpp_QVariant_Type_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX],
        PySequence_PythonToCpp_QVariant_Type,
        is_PySequence_PythonToCpp_QVariant_Type_Convertible);

    // Register converter for type 'PySide2.QtCore.qintptr'.
    SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX] = Shiboken::Conversions::createConverter(&PyLong_Type, qintptr_CppToPython_qintptr);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], "qintptr");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX],
        PyLong_PythonToCpp_qintptr,
        is_PyLong_PythonToCpp_qintptr_Convertible);

    // Register converter for type 'PySide2.QtCore.qptrdiff'.
    SbkPySide2_QtCoreTypeConverters[SBK_QPTRDIFF_IDX] = Shiboken::Conversions::createConverter(&PyLong_Type, qptrdiff_CppToPython_qptrdiff);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QPTRDIFF_IDX], "qptrdiff");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QPTRDIFF_IDX],
        PyLong_PythonToCpp_qptrdiff,
        is_PyLong_PythonToCpp_qptrdiff_Convertible);

    // Register converter for type 'PySide2.QtCore.quintptr'.
    SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX] = Shiboken::Conversions::createConverter(&PyLong_Type, quintptr_CppToPython_quintptr);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX], "quintptr");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX],
        PyLong_PythonToCpp_quintptr,
        is_PyLong_PythonToCpp_quintptr_Convertible);


    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QObjectPTR_REF_CppToPython_constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QOBJECTPTR_IDX],
        constQList_QObjectPTR_REF_PythonToCpp_constQList_QObjectPTR_REF,
        is_constQList_QObjectPTR_REF_PythonToCpp_constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QByteArray__CppToPython_QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX],
        QList_QByteArray__PythonToCpp_QList_QByteArray_,
        is_QList_QByteArray__PythonToCpp_QList_QByteArray__Convertible);

    // Register converter for type 'QList<QAbstractEventDispatcher::TimerInfo>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QAbstractEventDispatcher_TimerInfo__CppToPython_QList_QAbstractEventDispatcher_TimerInfo_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], "QList<QAbstractEventDispatcher::TimerInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX],
        QList_QAbstractEventDispatcher_TimerInfo__PythonToCpp_QList_QAbstractEventDispatcher_TimerInfo_,
        is_QList_QAbstractEventDispatcher_TimerInfo__PythonToCpp_QList_QAbstractEventDispatcher_TimerInfo__Convertible);

    // Register converter for type 'const QVector<int>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQVector_int_REF_CppToPython_constQVector_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_INT_IDX], "const QVector<int>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_INT_IDX], "QVector<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_INT_IDX],
        constQVector_int_REF_PythonToCpp_constQVector_int_REF,
        is_constQVector_int_REF_PythonToCpp_constQVector_int_REF_Convertible);

    // Register converter for type 'const QHash<int,QByteArray>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_INT_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, constQHash_int_QByteArray_REF_CppToPython_constQHash_int_QByteArray_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_INT_QBYTEARRAY_IDX], "const QHash<int,QByteArray>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_INT_QBYTEARRAY_IDX], "QHash<int,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_INT_QBYTEARRAY_IDX],
        constQHash_int_QByteArray_REF_PythonToCpp_constQHash_int_QByteArray_REF,
        is_constQHash_int_QByteArray_REF_PythonToCpp_constQHash_int_QByteArray_REF_Convertible);

    // Register converter for type 'QMap<int,QVariant>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, QMap_int_QVariant__CppToPython_QMap_int_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX], "QMap<int,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX],
        QMap_int_QVariant__PythonToCpp_QMap_int_QVariant_,
        is_QMap_int_QVariant__PythonToCpp_QMap_int_QVariant__Convertible);

    // Register converter for type 'const QList<QPersistentModelIndex>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPERSISTENTMODELINDEX_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QPersistentModelIndex_REF_CppToPython_constQList_QPersistentModelIndex_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPERSISTENTMODELINDEX_IDX], "const QList<QPersistentModelIndex>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPERSISTENTMODELINDEX_IDX], "QList<QPersistentModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPERSISTENTMODELINDEX_IDX],
        constQList_QPersistentModelIndex_REF_PythonToCpp_constQList_QPersistentModelIndex_REF,
        is_constQList_QPersistentModelIndex_REF_PythonToCpp_constQList_QPersistentModelIndex_REF_Convertible);

    // Register converter for type 'QList<QAbstractAnimation*>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTANIMATIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QAbstractAnimationPTR__CppToPython_QList_QAbstractAnimationPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTANIMATIONPTR_IDX], "QList<QAbstractAnimation*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTANIMATIONPTR_IDX],
        QList_QAbstractAnimationPTR__PythonToCpp_QList_QAbstractAnimationPTR_,
        is_QList_QAbstractAnimationPTR__PythonToCpp_QList_QAbstractAnimationPTR__Convertible);

    // Register converter for type 'const QList<QAbstractState*>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTSTATEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QAbstractStatePTR_REF_CppToPython_constQList_QAbstractStatePTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTSTATEPTR_IDX], "const QList<QAbstractState*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTSTATEPTR_IDX], "QList<QAbstractState*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTSTATEPTR_IDX],
        constQList_QAbstractStatePTR_REF_PythonToCpp_constQList_QAbstractStatePTR_REF,
        is_constQList_QAbstractStatePTR_REF_PythonToCpp_constQList_QAbstractStatePTR_REF_Convertible);

    // Register converter for type 'const QList<QVariant>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QVariant_REF_CppToPython_constQList_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QVARIANT_IDX], "const QList<QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QVARIANT_IDX],
        constQList_QVariant_REF_PythonToCpp_constQList_QVariant_REF,
        is_constQList_QVariant_REF_PythonToCpp_constQList_QVariant_REF_Convertible);

    // Register converter for type 'const QHash<QString,QVariant>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, constQHash_QString_QVariant_REF_CppToPython_constQHash_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_QSTRING_QVARIANT_IDX], "const QHash<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_QSTRING_QVARIANT_IDX], "QHash<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_QSTRING_QVARIANT_IDX],
        constQHash_QString_QVariant_REF_PythonToCpp_constQHash_QString_QVariant_REF,
        is_constQHash_QString_QVariant_REF_PythonToCpp_constQHash_QString_QVariant_REF_Convertible);

    // Register converter for type 'const QMap<QString,QVariant>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, constQMap_QString_QVariant_REF_CppToPython_constQMap_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_QSTRING_QVARIANT_IDX], "const QMap<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_QSTRING_QVARIANT_IDX],
        constQMap_QString_QVariant_REF_PythonToCpp_constQMap_QString_QVariant_REF,
        is_constQMap_QString_QVariant_REF_PythonToCpp_constQMap_QString_QVariant_REF_Convertible);

    // Register converter for type 'QVector<QCborValue>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QCBORVALUE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QCborValue__CppToPython_QVector_QCborValue_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QCBORVALUE_IDX], "QVector<QCborValue>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QCBORVALUE_IDX],
        QVector_QCborValue__PythonToCpp_QVector_QCborValue_,
        is_QVector_QCborValue__PythonToCpp_QVector_QCborValue__Convertible);

    // Register converter for type 'const QList<QCommandLineOption>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QCOMMANDLINEOPTION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QCommandLineOption_REF_CppToPython_constQList_QCommandLineOption_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QCOMMANDLINEOPTION_IDX], "const QList<QCommandLineOption>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QCOMMANDLINEOPTION_IDX], "QList<QCommandLineOption>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QCOMMANDLINEOPTION_IDX],
        constQList_QCommandLineOption_REF_PythonToCpp_constQList_QCommandLineOption_REF,
        is_constQList_QCommandLineOption_REF_PythonToCpp_constQList_QCommandLineOption_REF_Convertible);

    // Register converter for type 'QList<QAbstractItemModel*>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTITEMMODELPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QAbstractItemModelPTR__CppToPython_QList_QAbstractItemModelPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTITEMMODELPTR_IDX], "QList<QAbstractItemModel*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTITEMMODELPTR_IDX],
        QList_QAbstractItemModelPTR__PythonToCpp_QList_QAbstractItemModelPTR_,
        is_QList_QAbstractItemModelPTR__PythonToCpp_QList_QAbstractItemModelPTR__Convertible);

    // Register converter for type 'QPair<qint64,unsigned int>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QINT64_UNSIGNEDINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QPair_qint64_unsignedint__CppToPython_QPair_qint64_unsignedint_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QINT64_UNSIGNEDINT_IDX], "QPair<qint64,unsigned int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QINT64_UNSIGNEDINT_IDX],
        QPair_qint64_unsignedint__PythonToCpp_QPair_qint64_unsignedint_,
        is_QPair_qint64_unsignedint__PythonToCpp_QPair_qint64_unsignedint__Convertible);

    // Register converter for type 'QList<QFileInfo>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QFILEINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QFileInfo__CppToPython_QList_QFileInfo_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QFILEINFO_IDX], "QList<QFileInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QFILEINFO_IDX],
        QList_QFileInfo__PythonToCpp_QList_QFileInfo_,
        is_QList_QFileInfo__PythonToCpp_QList_QFileInfo__Convertible);

    // Register converter for type 'QVector<QPointF>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QPointF__CppToPython_QVector_QPointF_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPOINTF_IDX], "QVector<QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPOINTF_IDX],
        QVector_QPointF__PythonToCpp_QVector_QPointF_,
        is_QVector_QPointF__PythonToCpp_QVector_QPointF__Convertible);

    // Register converter for type 'const QList<QItemSelectionRange>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QItemSelectionRange_REF_CppToPython_constQList_QItemSelectionRange_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], "const QList<QItemSelectionRange>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], "QList<QItemSelectionRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX],
        constQList_QItemSelectionRange_REF_PythonToCpp_constQList_QItemSelectionRange_REF,
        is_constQList_QItemSelectionRange_REF_PythonToCpp_constQList_QItemSelectionRange_REF_Convertible);

    // Register converter for type 'const QSet<QItemSelectionRange>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QITEMSELECTIONRANGE_IDX] = Shiboken::Conversions::createConverter(&PySet_Type, constQSet_QItemSelectionRange_REF_CppToPython_constQSet_QItemSelectionRange_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QITEMSELECTIONRANGE_IDX], "const QSet<QItemSelectionRange>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QITEMSELECTIONRANGE_IDX], "QSet<QItemSelectionRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QITEMSELECTIONRANGE_IDX],
        constQSet_QItemSelectionRange_REF_PythonToCpp_constQSet_QItemSelectionRange_REF,
        is_constQSet_QItemSelectionRange_REF_PythonToCpp_constQSet_QItemSelectionRange_REF_Convertible);

    // Register converter for type 'const QVector<QItemSelectionRange>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QITEMSELECTIONRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQVector_QItemSelectionRange_REF_CppToPython_constQVector_QItemSelectionRange_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QITEMSELECTIONRANGE_IDX], "const QVector<QItemSelectionRange>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QITEMSELECTIONRANGE_IDX], "QVector<QItemSelectionRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QITEMSELECTIONRANGE_IDX],
        constQVector_QItemSelectionRange_REF_PythonToCpp_constQVector_QItemSelectionRange_REF,
        is_constQVector_QItemSelectionRange_REF_PythonToCpp_constQVector_QItemSelectionRange_REF_Convertible);

    // Register converter for type 'QList<QLocale::Country>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_COUNTRY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QLocale_Country__CppToPython_QList_QLocale_Country_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_COUNTRY_IDX], "QList<QLocale::Country>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_COUNTRY_IDX],
        QList_QLocale_Country__PythonToCpp_QList_QLocale_Country_,
        is_QList_QLocale_Country__PythonToCpp_QList_QLocale_Country__Convertible);

    // Register converter for type 'QList<QLocale>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QLocale__CppToPython_QList_QLocale_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_IDX], "QList<QLocale>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_IDX],
        QList_QLocale__PythonToCpp_QList_QLocale_,
        is_QList_QLocale__PythonToCpp_QList_QLocale__Convertible);

    // Register converter for type 'QList<Qt::DayOfWeek>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QT_DAYOFWEEK_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_Qt_DayOfWeek__CppToPython_QList_Qt_DayOfWeek_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QT_DAYOFWEEK_IDX], "QList<Qt::DayOfWeek>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QT_DAYOFWEEK_IDX],
        QList_Qt_DayOfWeek__PythonToCpp_QList_Qt_DayOfWeek_,
        is_QList_Qt_DayOfWeek__PythonToCpp_QList_Qt_DayOfWeek__Convertible);

    // Register converter for type 'const QList<QUrl>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QURL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QUrl_REF_CppToPython_constQList_QUrl_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QURL_IDX], "const QList<QUrl>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QURL_IDX], "QList<QUrl>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QURL_IDX],
        constQList_QUrl_REF_PythonToCpp_constQList_QUrl_REF,
        is_constQList_QUrl_REF_PythonToCpp_constQList_QUrl_REF_Convertible);

    // Register converter for type 'QList<QMimeType>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QMIMETYPE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QMimeType__CppToPython_QList_QMimeType_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QMIMETYPE_IDX], "QList<QMimeType>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QMIMETYPE_IDX],
        QList_QMimeType__PythonToCpp_QList_QMimeType_,
        is_QList_QMimeType__PythonToCpp_QList_QMimeType__Convertible);

    // Register converter for type 'QPair<qreal,QVariant>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QREAL_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QPair_qreal_QVariant__CppToPython_QPair_qreal_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QREAL_QVARIANT_IDX], "QPair<qreal,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QREAL_QVARIANT_IDX],
        QPair_qreal_QVariant__PythonToCpp_QPair_qreal_QVariant_,
        is_QPair_qreal_QVariant__PythonToCpp_QPair_qreal_QVariant__Convertible);

    // Register converter for type 'QVector<QPair<qreal,QVariant>>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPAIR_QREAL_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QPair_qreal_QVariant___CppToPython_QVector_QPair_qreal_QVariant__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPAIR_QREAL_QVARIANT_IDX], "QVector<QPair<qreal,QVariant>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPAIR_QREAL_QVARIANT_IDX],
        QVector_QPair_qreal_QVariant___PythonToCpp_QVector_QPair_qreal_QVariant__,
        is_QVector_QPair_qreal_QVariant___PythonToCpp_QVector_QPair_qreal_QVariant___Convertible);

    // Register converter for type 'QList<QAbstractTransition*>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTTRANSITIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QAbstractTransitionPTR__CppToPython_QList_QAbstractTransitionPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTTRANSITIONPTR_IDX], "QList<QAbstractTransition*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QABSTRACTTRANSITIONPTR_IDX],
        QList_QAbstractTransitionPTR__PythonToCpp_QList_QAbstractTransitionPTR_,
        is_QList_QAbstractTransitionPTR__PythonToCpp_QList_QAbstractTransitionPTR__Convertible);

    // Register converter for type 'QSet<QAbstractState*>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QABSTRACTSTATEPTR_IDX] = Shiboken::Conversions::createConverter(&PySet_Type, QSet_QAbstractStatePTR__CppToPython_QSet_QAbstractStatePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QABSTRACTSTATEPTR_IDX], "QSet<QAbstractState*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QABSTRACTSTATEPTR_IDX],
        QSet_QAbstractStatePTR__PythonToCpp_QSet_QAbstractStatePTR_,
        is_QSet_QAbstractStatePTR__PythonToCpp_QSet_QAbstractStatePTR__Convertible);

    // Register converter for type 'QList<QStorageInfo>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTORAGEINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QStorageInfo__CppToPython_QList_QStorageInfo_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTORAGEINFO_IDX], "QList<QStorageInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTORAGEINFO_IDX],
        QList_QStorageInfo__PythonToCpp_QList_QStorageInfo_,
        is_QList_QStorageInfo__PythonToCpp_QList_QStorageInfo__Convertible);

    // Register converter for type 'QList<int>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_int__CppToPython_QList_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_INT_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_INT_IDX],
        QList_int__PythonToCpp_QList_int_,
        is_QList_int__PythonToCpp_QList_int__Convertible);

    // Register converter for type 'QVector<QTimeZone::OffsetData>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QTIMEZONE_OFFSETDATA_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QTimeZone_OffsetData__CppToPython_QVector_QTimeZone_OffsetData_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QTIMEZONE_OFFSETDATA_IDX], "QVector<QTimeZone::OffsetData>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QTIMEZONE_OFFSETDATA_IDX],
        QVector_QTimeZone_OffsetData__PythonToCpp_QVector_QTimeZone_OffsetData_,
        is_QVector_QTimeZone_OffsetData__PythonToCpp_QVector_QTimeZone_OffsetData__Convertible);

    // Register converter for type 'QPair<QString,QString>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QSTRING_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QPair_QString_QString__CppToPython_QPair_QString_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QSTRING_QSTRING_IDX], "QPair<QString,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QSTRING_QSTRING_IDX],
        QPair_QString_QString__PythonToCpp_QPair_QString_QString_,
        is_QPair_QString_QString__PythonToCpp_QPair_QString_QString__Convertible);

    // Register converter for type 'QList<QPair<QString,QString>>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPAIR_QSTRING_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QPair_QString_QString___CppToPython_QList_QPair_QString_QString__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPAIR_QSTRING_QSTRING_IDX], "QList<QPair<QString,QString>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPAIR_QSTRING_QSTRING_IDX],
        QList_QPair_QString_QString___PythonToCpp_QList_QPair_QString_QString__,
        is_QList_QPair_QString_QString___PythonToCpp_QList_QPair_QString_QString___Convertible);

    // Register converter for type 'QVector<QXmlStreamAttribute>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QXmlStreamAttribute_REF_CppToPython_QVector_QXmlStreamAttribute_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], "QVector<QXmlStreamAttribute>&");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX],
        QVector_QXmlStreamAttribute_REF_PythonToCpp_QVector_QXmlStreamAttribute_REF,
        is_QVector_QXmlStreamAttribute_REF_PythonToCpp_QVector_QXmlStreamAttribute_REF_Convertible);

    // Register converter for type 'const QList<QXmlStreamAttribute>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QXMLSTREAMATTRIBUTE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQList_QXmlStreamAttribute_REF_CppToPython_constQList_QXmlStreamAttribute_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QXMLSTREAMATTRIBUTE_IDX], "const QList<QXmlStreamAttribute>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QXMLSTREAMATTRIBUTE_IDX], "QList<QXmlStreamAttribute>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QXMLSTREAMATTRIBUTE_IDX],
        constQList_QXmlStreamAttribute_REF_PythonToCpp_constQList_QXmlStreamAttribute_REF,
        is_constQList_QXmlStreamAttribute_REF_PythonToCpp_constQList_QXmlStreamAttribute_REF_Convertible);

    // Register converter for type 'const QVector<QXmlStreamNamespaceDeclaration>&'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNAMESPACEDECLARATION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, constQVector_QXmlStreamNamespaceDeclaration_REF_CppToPython_constQVector_QXmlStreamNamespaceDeclaration_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNAMESPACEDECLARATION_IDX], "const QVector<QXmlStreamNamespaceDeclaration>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNAMESPACEDECLARATION_IDX], "QVector<QXmlStreamNamespaceDeclaration>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNAMESPACEDECLARATION_IDX],
        constQVector_QXmlStreamNamespaceDeclaration_REF_PythonToCpp_constQVector_QXmlStreamNamespaceDeclaration_REF,
        is_constQVector_QXmlStreamNamespaceDeclaration_REF_PythonToCpp_constQVector_QXmlStreamNamespaceDeclaration_REF_Convertible);

    // Register converter for type 'QVector<QXmlStreamEntityDeclaration>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMENTITYDECLARATION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QXmlStreamEntityDeclaration__CppToPython_QVector_QXmlStreamEntityDeclaration_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMENTITYDECLARATION_IDX], "QVector<QXmlStreamEntityDeclaration>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMENTITYDECLARATION_IDX],
        QVector_QXmlStreamEntityDeclaration__PythonToCpp_QVector_QXmlStreamEntityDeclaration_,
        is_QVector_QXmlStreamEntityDeclaration__PythonToCpp_QVector_QXmlStreamEntityDeclaration__Convertible);

    // Register converter for type 'QVector<QXmlStreamNotationDeclaration>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNOTATIONDECLARATION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QVector_QXmlStreamNotationDeclaration__CppToPython_QVector_QXmlStreamNotationDeclaration_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNOTATIONDECLARATION_IDX], "QVector<QXmlStreamNotationDeclaration>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNOTATIONDECLARATION_IDX],
        QVector_QXmlStreamNotationDeclaration__PythonToCpp_QVector_QXmlStreamNotationDeclaration_,
        is_QVector_QXmlStreamNotationDeclaration__PythonToCpp_QVector_QXmlStreamNotationDeclaration__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, QList_QString__CppToPython_QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTRING_IDX],
        QList_QString__PythonToCpp_QList_QString_,
        is_QList_QString__PythonToCpp_QList_QString__Convertible);

    // Initialization of enums.

    // Initialization of enum 'QCborKnownTags'.
    SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX] = Shiboken::Enum::createGlobalEnum(module,
        "QCborKnownTags",
        "2:PySide2.QtCore.QCborKnownTags",
        "QCborKnownTags");
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX])
        return SBK_MODULE_INIT_ERROR;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "DateTimeString", (long) QCborKnownTags::DateTimeString))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "UnixTime_t", (long) QCborKnownTags::UnixTime_t))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "PositiveBignum", (long) QCborKnownTags::PositiveBignum))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "NegativeBignum", (long) QCborKnownTags::NegativeBignum))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Decimal", (long) QCborKnownTags::Decimal))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Bigfloat", (long) QCborKnownTags::Bigfloat))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "COSE_Encrypt0", (long) QCborKnownTags::COSE_Encrypt0))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "COSE_Mac0", (long) QCborKnownTags::COSE_Mac0))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "COSE_Sign1", (long) QCborKnownTags::COSE_Sign1))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "ExpectedBase64url", (long) QCborKnownTags::ExpectedBase64url))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "ExpectedBase64", (long) QCborKnownTags::ExpectedBase64))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "ExpectedBase16", (long) QCborKnownTags::ExpectedBase16))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "EncodedCbor", (long) QCborKnownTags::EncodedCbor))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Url", (long) QCborKnownTags::Url))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Base64url", (long) QCborKnownTags::Base64url))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Base64", (long) QCborKnownTags::Base64))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "RegularExpression", (long) QCborKnownTags::RegularExpression))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "MimeMessage", (long) QCborKnownTags::MimeMessage))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Uuid", (long) QCborKnownTags::Uuid))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "COSE_Encrypt", (long) QCborKnownTags::COSE_Encrypt))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "COSE_Mac", (long) QCborKnownTags::COSE_Mac))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "COSE_Sign", (long) QCborKnownTags::COSE_Sign))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], "Signature", (long) QCborKnownTags::Signature))
        return SBK_MODULE_INIT_ERROR;
    // Register converter for enum 'QCborKnownTags'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX],
            QCborKnownTags_CppToPython_QCborKnownTags);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborKnownTags_PythonToCpp_QCborKnownTags,
            is_QCborKnownTags_PythonToCpp_QCborKnownTags_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborKnownTags");
    }
    // End of 'QCborKnownTags' enum.

    // Initialization of enum 'QCborSimpleType'.
    SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX] = Shiboken::Enum::createGlobalEnum(module,
        "QCborSimpleType",
        "2:PySide2.QtCore.QCborSimpleType",
        "QCborSimpleType");
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])
        return SBK_MODULE_INIT_ERROR;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], "False_", (long) QCborSimpleType::False))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], "True_", (long) QCborSimpleType::True))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], "Null", (long) QCborSimpleType::Null))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], "Undefined", (long) QCborSimpleType::Undefined))
        return SBK_MODULE_INIT_ERROR;
    // Register converter for enum 'QCborSimpleType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX],
            QCborSimpleType_CppToPython_QCborSimpleType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborSimpleType_PythonToCpp_QCborSimpleType,
            is_QCborSimpleType_PythonToCpp_QCborSimpleType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborSimpleType");
    }
    // End of 'QCborSimpleType' enum.

    // Initialization of enum 'QtMsgType'.
    SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX] = Shiboken::Enum::createGlobalEnum(module,
        "QtMsgType",
        "2:PySide2.QtCore.QtMsgType",
        "QtMsgType");
    if (!SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX])
        return SBK_MODULE_INIT_ERROR;

    if (!Shiboken::Enum::createGlobalEnumItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
        module, "QtDebugMsg", (long) QtMsgType::QtDebugMsg))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createGlobalEnumItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
        module, "QtWarningMsg", (long) QtMsgType::QtWarningMsg))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createGlobalEnumItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
        module, "QtCriticalMsg", (long) QtMsgType::QtCriticalMsg))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createGlobalEnumItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
        module, "QtFatalMsg", (long) QtMsgType::QtFatalMsg))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createGlobalEnumItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
        module, "QtInfoMsg", (long) QtMsgType::QtInfoMsg))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createGlobalEnumItem(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
        module, "QtSystemMsg", (long) QtMsgType::QtSystemMsg))
        return SBK_MODULE_INIT_ERROR;
    // Register converter for enum 'QtMsgType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX],
            QtMsgType_CppToPython_QtMsgType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtMsgType_PythonToCpp_QtMsgType,
            is_QtMsgType_PythonToCpp_QtMsgType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtMsgType");
    }
    // End of 'QtMsgType' enum.

    // Register primitive types converters.
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "qint16");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "qint32");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), "qint64");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "qint8");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), "qlonglong");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<double>(), "qreal");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "quint16");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "quint32");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "quint64");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "quint8");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "qulonglong");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uchar");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uint");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ulong");
    Shiboken::Conversions::registerConverterName(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "ushort");

    Shiboken::Module::registerTypes(module, SbkPySide2_QtCoreTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtCoreTypeConverters);

// Static field initialization
init_QOperatingSystemVersionStaticFields();

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtCore");
    }
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-qaddpostroutine)]
    qAddPostRoutine(PySide::globalPostRoutineCallback);
    // END of custom code block [file: ../glue/qtcore.cpp (qt-qaddpostroutine)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-version)]
    QList<QByteArray> version = QByteArray(qVersion()).split('.');
    PyObject *pyQtVersion = PyTuple_New(3);
    for (int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(pyQtVersion, i, PyInt_FromLong(version[i].toInt()));
    PyModule_AddObject(module, "__version_info__", pyQtVersion);
    PyModule_AddStringConstant(module, "__version__", qVersion());
    // END of custom code block [file: ../glue/qtcore.cpp (qt-version)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-module-shutdown)]
    { // Avoid name clash
        Shiboken::AutoDecRef regFunc(static_cast<PyObject *>(nullptr));
        Shiboken::AutoDecRef atexit(Shiboken::Module::import("atexit"));
        if (atexit.isNull()) {
            qWarning("Module atexit not found for registering __moduleShutdown");
            PyErr_Clear();
        }else{
            regFunc.reset(PyObject_GetAttrString(atexit, "register"));
            if (regFunc.isNull()) {
                qWarning("Function atexit.register not found for registering __moduleShutdown");
                PyErr_Clear();
            }
        }
        if (!atexit.isNull() && !regFunc.isNull()){
            PyObject *shutDownFunc = PyObject_GetAttrString(module, "__moduleShutdown");
            Shiboken::AutoDecRef args(PyTuple_New(1));
            PyTuple_SET_ITEM(args, 0, shutDownFunc);
            Shiboken::AutoDecRef retval(PyObject_Call(regFunc, args, 0));
            Q_ASSERT(!retval.isNull());
        }
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qt-module-shutdown)]
    // ========================================================================

    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qt-pysideinit)]
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], "unicode");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], "str");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QVARIANT_IDX], "QVariantList");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_QSTRING_QVARIANT_IDX], "QVariantMap");

    PySide::registerInternalQtConf();
    PySide::init(module);
    Py_AtExit(QtCoreModuleExit);
    // END of custom code block [file: ../glue/qtcore.cpp (qt-pysideinit)]
    // ========================================================================

    // End of code injection

    qRegisterMetaType< ::QCborKnownTags >("QCborKnownTags");
    qRegisterMetaType< ::QCborSimpleType >("QCborSimpleType");
    qRegisterMetaType< ::QtMsgType >("QtMsgType");
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtCore_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
