/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtextcodec_wrapper.h"

// inner classes
#include "qtextcodec_converterstate_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTextCodecWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTextCodecWrapper::QTextCodecWrapper() : QTextCodec()
{
    resetPyMethodCache();
    // ... middle
}

::QList<QByteArray > QTextCodecWrapper::aliases() const
{
    if (m_PyMethodCache[0])
        return this->::QTextCodec::aliases();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "aliases";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QTextCodec::aliases();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextCodec.aliases", "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QByteArray > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QByteArray QTextCodecWrapper::convertFromUnicode(const ::QChar * in, int length, ::QTextCodec::ConverterState * state) const
{
    return {};
}

::QString QTextCodecWrapper::convertToUnicode(const char * in, int length, ::QTextCodec::ConverterState * state) const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.convertToUnicode()' not implemented.");
        return ::QString();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "convertToUnicode";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.convertToUnicode()' not implemented.");
        return ::QString();
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiN)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), in),
    length,
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX]), state)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextCodec.convertToUnicode", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QTextCodecWrapper::mibEnum() const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.mibEnum()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mibEnum";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.mibEnum()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextCodec.mibEnum", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QByteArray QTextCodecWrapper::name() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.name()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "name";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.name()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextCodec.name", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QByteArray >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QByteArray cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QTextCodecWrapper::~QTextCodecWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextCodec_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QTextCodec' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextCodec >()))
        return -1;

    ::QTextCodecWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QTextCodec()
            cptr = new ::QTextCodecWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextCodec >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QTextCodecFunc_aliases(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.aliases";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // aliases()const
            QList<QByteArray > cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QTextCodec *>(cppSelf)->::QTextCodec::aliases()
                : const_cast<const ::QTextCodec *>(cppSelf)->aliases();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCodecFunc_availableCodecs(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.availableCodecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableCodecs()
            QList<QByteArray > cppResult = ::QTextCodec::availableCodecs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCodecFunc_availableMibs(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.availableMibs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableMibs()
            QList<int > cppResult = ::QTextCodec::availableMibs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCodecFunc_canEncode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.canEncode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCodec::canEncode(QChar)const
    // 1: QTextCodec::canEncode(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // canEncode(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // canEncode(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_canEncode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // canEncode(QChar arg__1) const
        {
            ::QChar cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // canEncode(QChar)const
                bool cppResult = const_cast<const ::QTextCodec *>(cppSelf)->canEncode(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // canEncode(const QString & arg__1) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // canEncode(QString)const
                bool cppResult = const_cast<const ::QTextCodec *>(cppSelf)->canEncode(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_canEncode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_codecForHtml(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.codecForHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "codecForHtml", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTextCodec::codecForHtml(QByteArray)
    // 1: static QTextCodec::codecForHtml(QByteArray,QTextCodec*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // codecForHtml(QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), (pyArgs[1])))) {
            overloadId = 1; // codecForHtml(QByteArray,QTextCodec*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_codecForHtml_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // codecForHtml(const QByteArray & ba)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // codecForHtml(QByteArray)
                QTextCodec * cppResult = ::QTextCodec::codecForHtml(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            }
            break;
        }
        case 1: // codecForHtml(const QByteArray & ba, QTextCodec * defaultCodec)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCodec *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // codecForHtml(QByteArray,QTextCodec*)
                QTextCodec * cppResult = ::QTextCodec::codecForHtml(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_codecForHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_codecForLocale(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.codecForLocale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codecForLocale()
            QTextCodec * cppResult = ::QTextCodec::codecForLocale();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCodecFunc_codecForMib(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.codecForMib";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTextCodec::codecForMib(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // codecForMib(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_codecForMib_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // codecForMib(int)
            QTextCodec * cppResult = ::QTextCodec::codecForMib(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_codecForMib_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_codecForName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.codecForName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTextCodec::codecForName(QByteArray)
    // 1: static QTextCodec::codecForName(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // codecForName(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // codecForName(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_codecForName_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // codecForName(const QByteArray & name)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // codecForName(QByteArray)
                QTextCodec * cppResult = ::QTextCodec::codecForName(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            }
            break;
        }
        case 1: // codecForName(const char * name)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // codecForName(const char*)
                QTextCodec * cppResult = ::QTextCodec::codecForName(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_codecForName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_codecForUtfText(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.codecForUtfText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "codecForUtfText", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTextCodec::codecForUtfText(QByteArray)
    // 1: static QTextCodec::codecForUtfText(QByteArray,QTextCodec*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // codecForUtfText(QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), (pyArgs[1])))) {
            overloadId = 1; // codecForUtfText(QByteArray,QTextCodec*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_codecForUtfText_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // codecForUtfText(const QByteArray & ba)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // codecForUtfText(QByteArray)
                QTextCodec * cppResult = ::QTextCodec::codecForUtfText(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            }
            break;
        }
        case 1: // codecForUtfText(const QByteArray & ba, QTextCodec * defaultCodec)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCodec *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // codecForUtfText(QByteArray,QTextCodec*)
                QTextCodec * cppResult = ::QTextCodec::codecForUtfText(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_codecForUtfText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_convertToUnicode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.convertToUnicode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "convertToUnicode", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextCodec::convertToUnicode(const char*,int,QTextCodec::ConverterState*)const
    if (numArgs == 3
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX]), (pyArgs[2])))) {
        overloadId = 0; // convertToUnicode(const char*,int,QTextCodec::ConverterState*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_convertToUnicode_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QTextCodec::ConverterState *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // convertToUnicode(const char*,int,QTextCodec::ConverterState*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.convertToUnicode()' not implemented.");
                return {};
            }
            QString cppResult = const_cast<const ::QTextCodec *>(cppSelf)->convertToUnicode(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_convertToUnicode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_fromUnicode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.fromUnicode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCodec::fromUnicode(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromUnicode(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_fromUnicode_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromUnicode(QString)const
            QByteArray cppResult = const_cast<const ::QTextCodec *>(cppSelf)->fromUnicode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_fromUnicode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_makeDecoder(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.makeDecoder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCodecFunc_makeDecoder_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:makeDecoder", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextCodec::makeDecoder(QFlags<QTextCodec::ConversionFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // makeDecoder(QFlags<QTextCodec::ConversionFlag>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // makeDecoder(QFlags<QTextCodec::ConversionFlag>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_makeDecoder_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[0]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCodecFunc_makeDecoder_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QTextCodecFunc_makeDecoder_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextCodecFunc_makeDecoder_TypeError;
            }
        }
        ::QFlags<QTextCodec::ConversionFlag> cppArg0 = QTextCodec::DefaultConversion;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // makeDecoder(QFlags<QTextCodec::ConversionFlag>)const
            QTextDecoder * cppResult = const_cast<const ::QTextCodec *>(cppSelf)->makeDecoder(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTDECODER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_makeDecoder_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_makeEncoder(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.makeEncoder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCodecFunc_makeEncoder_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:makeEncoder", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextCodec::makeEncoder(QFlags<QTextCodec::ConversionFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // makeEncoder(QFlags<QTextCodec::ConversionFlag>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // makeEncoder(QFlags<QTextCodec::ConversionFlag>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_makeEncoder_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[0]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCodecFunc_makeEncoder_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QTextCodecFunc_makeEncoder_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextCodecFunc_makeEncoder_TypeError;
            }
        }
        ::QFlags<QTextCodec::ConversionFlag> cppArg0 = QTextCodec::DefaultConversion;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // makeEncoder(QFlags<QTextCodec::ConversionFlag>)const
            QTextEncoder * cppResult = const_cast<const ::QTextCodec *>(cppSelf)->makeEncoder(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTENCODER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_makeEncoder_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_mibEnum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.mibEnum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mibEnum()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.mibEnum()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QTextCodec *>(cppSelf)->mibEnum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCodecFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextCodec.name()' not implemented.");
                return {};
            }
            QByteArray cppResult = const_cast<const ::QTextCodec *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCodecFunc_setCodecForLocale(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.setCodecForLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTextCodec::setCodecForLocale(QTextCodec*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), (pyArg)))) {
        overloadId = 0; // setCodecForLocale(QTextCodec*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_setCodecForLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCodec *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCodecForLocale(QTextCodec*)
            ::QTextCodec::setCodecForLocale(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCodecFunc_setCodecForLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCodecFunc_toUnicode(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.toUnicode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCodecFunc_toUnicode_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextCodecFunc_toUnicode_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toUnicode", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextCodec::toUnicode(QByteArray)const
    // 1: QTextCodec::toUnicode(const char*)const
    // 2: QTextCodec::toUnicode(const char*,int,QTextCodec::ConverterState*)const
    if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // toUnicode(const char*)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // toUnicode(const char*,int,QTextCodec::ConverterState*)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX]), (pyArgs[2])))) {
                overloadId = 2; // toUnicode(const char*,int,QTextCodec::ConverterState*)const
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toUnicode(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodecFunc_toUnicode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toUnicode(const QByteArray & arg__1) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextCodecFunc_toUnicode_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // toUnicode(QByteArray)const
                QString cppResult = const_cast<const ::QTextCodec *>(cppSelf)->toUnicode(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toUnicode(const char * chars) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextCodecFunc_toUnicode_TypeError;
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toUnicode(const char*)const
                QString cppResult = const_cast<const ::QTextCodec *>(cppSelf)->toUnicode(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 2: // toUnicode(const char * in, int length, QTextCodec::ConverterState * state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[2]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextCodecFunc_toUnicode_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX]), (pyArgs[2]))))
                            goto Sbk_QTextCodecFunc_toUnicode_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextCodecFunc_toUnicode_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTextCodec::ConverterState *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toUnicode(const char*,int,QTextCodec::ConverterState*)const
                QString cppResult = const_cast<const ::QTextCodec *>(cppSelf)->toUnicode(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCodecFunc_toUnicode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QTextCodec_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextCodec_methods[] = {
    {"aliases", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_aliases), METH_NOARGS},
    {"availableCodecs", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_availableCodecs), METH_NOARGS|METH_STATIC},
    {"availableMibs", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_availableMibs), METH_NOARGS|METH_STATIC},
    {"canEncode", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_canEncode), METH_O},
    {"codecForHtml", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_codecForHtml), METH_VARARGS|METH_STATIC},
    {"codecForLocale", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_codecForLocale), METH_NOARGS|METH_STATIC},
    {"codecForMib", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_codecForMib), METH_O|METH_STATIC},
    {"codecForName", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_codecForName), METH_O|METH_STATIC},
    {"codecForUtfText", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_codecForUtfText), METH_VARARGS|METH_STATIC},
    {"convertToUnicode", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_convertToUnicode), METH_VARARGS},
    {"fromUnicode", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_fromUnicode), METH_O},
    {"makeDecoder", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_makeDecoder), METH_VARARGS|METH_KEYWORDS},
    {"makeEncoder", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_makeEncoder), METH_VARARGS|METH_KEYWORDS},
    {"mibEnum", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_mibEnum), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_name), METH_NOARGS},
    {"setCodecForLocale", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_setCodecForLocale), METH_O|METH_STATIC},
    {"toUnicode", reinterpret_cast<PyCFunction>(Sbk_QTextCodecFunc_toUnicode), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTextCodec_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTextCodec *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTextCodecWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTextCodec_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextCodec_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextCodec_Type = nullptr;
static SbkObjectType *Sbk_QTextCodec_TypeF(void)
{
    return _Sbk_QTextCodec_Type;
}

static PyType_Slot Sbk_QTextCodec_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTextCodec_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextCodec_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextCodec_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextCodec_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextCodec_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextCodec_spec = {
    "2:PySide2.QtCore.QTextCodec",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextCodec_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QTextCodec_ConversionFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextCodec::ConversionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextCodec::ConversionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextCodec::ConversionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextCodec::ConversionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextCodec::ConversionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextCodec_ConversionFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextCodec::ConversionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextCodec::ConversionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextCodec::ConversionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextCodec::ConversionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextCodec::ConversionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextCodec_ConversionFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextCodec::ConversionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextCodec::ConversionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextCodec::ConversionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextCodec::ConversionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextCodec::ConversionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextCodec_ConversionFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextCodec::ConversionFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, self, &cppSelf);
    ::QTextCodec::ConversionFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QTextCodec_ConversionFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QTextCodec_ConversionFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QTextCodec_ConversionFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextCodec_ConversionFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextCodec_ConversionFlag_PythonToCpp_QTextCodec_ConversionFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCodec::ConversionFlag *>(cppOut) =
        static_cast<::QTextCodec::ConversionFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCodec_ConversionFlag_PythonToCpp_QTextCodec_ConversionFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX]))
        return QTextCodec_ConversionFlag_PythonToCpp_QTextCodec_ConversionFlag;
    return {};
}
static PyObject *QTextCodec_ConversionFlag_CppToPython_QTextCodec_ConversionFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCodec::ConversionFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX], castCppIn);

}

static void QFlags_QTextCodec_ConversionFlag__PythonToCpp_QFlags_QTextCodec_ConversionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextCodec::ConversionFlag> *>(cppOut) =
        ::QFlags<QTextCodec::ConversionFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextCodec_ConversionFlag__PythonToCpp_QFlags_QTextCodec_ConversionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX]))
        return QFlags_QTextCodec_ConversionFlag__PythonToCpp_QFlags_QTextCodec_ConversionFlag_;
    return {};
}
static PyObject *QFlags_QTextCodec_ConversionFlag__CppToPython_QFlags_QTextCodec_ConversionFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextCodec::ConversionFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX]));

}

static void QTextCodec_ConversionFlag_PythonToCpp_QFlags_QTextCodec_ConversionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextCodec::ConversionFlag> *>(cppOut) =
        ::QFlags<QTextCodec::ConversionFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextCodec_ConversionFlag_PythonToCpp_QFlags_QTextCodec_ConversionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX]))
        return QTextCodec_ConversionFlag_PythonToCpp_QFlags_QTextCodec_ConversionFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextCodec_ConversionFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextCodec::ConversionFlag> *>(cppOut) =
        ::QFlags<QTextCodec::ConversionFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextCodec_ConversionFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTextCodec_ConversionFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextCodec_PythonToCpp_QTextCodec_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextCodec_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextCodec_PythonToCpp_QTextCodec_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextCodec_TypeF())))
        return QTextCodec_PythonToCpp_QTextCodec_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextCodec_PTR_CppToPython_QTextCodec(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextCodec *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextCodec_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextCodec_SignatureStrings[] = {
    "PySide2.QtCore.QTextCodec(self)",
    "PySide2.QtCore.QTextCodec.aliases(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QTextCodec.availableCodecs()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QTextCodec.availableMibs()->QList[int]",
    "1:PySide2.QtCore.QTextCodec.canEncode(self,arg__1:QChar)->bool",
    "0:PySide2.QtCore.QTextCodec.canEncode(self,arg__1:QString)->bool",
    "1:PySide2.QtCore.QTextCodec.codecForHtml(ba:PySide2.QtCore.QByteArray)->PySide2.QtCore.QTextCodec",
    "0:PySide2.QtCore.QTextCodec.codecForHtml(ba:PySide2.QtCore.QByteArray,defaultCodec:PySide2.QtCore.QTextCodec)->PySide2.QtCore.QTextCodec",
    "PySide2.QtCore.QTextCodec.codecForLocale()->PySide2.QtCore.QTextCodec",
    "PySide2.QtCore.QTextCodec.codecForMib(mib:int)->PySide2.QtCore.QTextCodec",
    "1:PySide2.QtCore.QTextCodec.codecForName(name:PySide2.QtCore.QByteArray)->PySide2.QtCore.QTextCodec",
    "0:PySide2.QtCore.QTextCodec.codecForName(name:char*)->PySide2.QtCore.QTextCodec",
    "1:PySide2.QtCore.QTextCodec.codecForUtfText(ba:PySide2.QtCore.QByteArray)->PySide2.QtCore.QTextCodec",
    "0:PySide2.QtCore.QTextCodec.codecForUtfText(ba:PySide2.QtCore.QByteArray,defaultCodec:PySide2.QtCore.QTextCodec)->PySide2.QtCore.QTextCodec",
    "PySide2.QtCore.QTextCodec.convertToUnicode(self,in:char*,length:int,state:PySide2.QtCore.QTextCodec.ConverterState)->QString",
    "PySide2.QtCore.QTextCodec.fromUnicode(self,uc:QString)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QTextCodec.makeDecoder(self,flags:PySide2.QtCore.QTextCodec.ConversionFlags=QTextCodec.DefaultConversion)->PySide2.QtCore.QTextDecoder",
    "PySide2.QtCore.QTextCodec.makeEncoder(self,flags:PySide2.QtCore.QTextCodec.ConversionFlags=QTextCodec.DefaultConversion)->PySide2.QtCore.QTextEncoder",
    "PySide2.QtCore.QTextCodec.mibEnum(self)->int",
    "PySide2.QtCore.QTextCodec.name(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QTextCodec.setCodecForLocale(c:PySide2.QtCore.QTextCodec)",
    "2:PySide2.QtCore.QTextCodec.toUnicode(self,arg__1:PySide2.QtCore.QByteArray)->QString",
    "1:PySide2.QtCore.QTextCodec.toUnicode(self,chars:char*)->QString",
    "0:PySide2.QtCore.QTextCodec.toUnicode(self,in:char*,length:int,state:PySide2.QtCore.QTextCodec.ConverterState=nullptr)->QString",
    nullptr}; // Sentinel

void init_QTextCodec(PyObject *module)
{
    _Sbk_QTextCodec_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextCodec",
        "QTextCodec*",
        &Sbk_QTextCodec_spec,
        &Shiboken::callCppDestructor< ::QTextCodec >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextCodec_Type);
    InitSignatureStrings(pyType, QTextCodec_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextCodec_Type), Sbk_QTextCodec_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextCodec_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextCodec_TypeF(),
        QTextCodec_PythonToCpp_QTextCodec_PTR,
        is_QTextCodec_PythonToCpp_QTextCodec_PTR_Convertible,
        QTextCodec_PTR_CppToPython_QTextCodec);

    Shiboken::Conversions::registerConverterName(converter, "QTextCodec");
    Shiboken::Conversions::registerConverterName(converter, "QTextCodec*");
    Shiboken::Conversions::registerConverterName(converter, "QTextCodec&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextCodec).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextCodecWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'ConversionFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QTextCodec.ConversionFlags", SbkPySide2_QtCore_QTextCodec_ConversionFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCodec_TypeF(),
        "ConversionFlag",
        "2:PySide2.QtCore.QTextCodec.ConversionFlag",
        "QTextCodec::ConversionFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX],
        Sbk_QTextCodec_TypeF(), "DefaultConversion", (long) QTextCodec::ConversionFlag::DefaultConversion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX],
        Sbk_QTextCodec_TypeF(), "ConvertInvalidToNull", (long) QTextCodec::ConversionFlag::ConvertInvalidToNull))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX],
        Sbk_QTextCodec_TypeF(), "IgnoreHeader", (long) QTextCodec::ConversionFlag::IgnoreHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX],
        Sbk_QTextCodec_TypeF(), "FreeFunction", (long) QTextCodec::ConversionFlag::FreeFunction))
        return;
    // Register converter for enum 'QTextCodec::ConversionFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX],
            QTextCodec_ConversionFlag_CppToPython_QTextCodec_ConversionFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCodec_ConversionFlag_PythonToCpp_QTextCodec_ConversionFlag,
            is_QTextCodec_ConversionFlag_PythonToCpp_QTextCodec_ConversionFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCodec::ConversionFlag");
        Shiboken::Conversions::registerConverterName(converter, "ConversionFlag");
    }
    // Register converter for flag 'QFlags<QTextCodec::ConversionFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX],
            QFlags_QTextCodec_ConversionFlag__CppToPython_QFlags_QTextCodec_ConversionFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCodec_ConversionFlag_PythonToCpp_QFlags_QTextCodec_ConversionFlag_,
            is_QTextCodec_ConversionFlag_PythonToCpp_QFlags_QTextCodec_ConversionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextCodec_ConversionFlag__PythonToCpp_QFlags_QTextCodec_ConversionFlag_,
            is_QFlags_QTextCodec_ConversionFlag__PythonToCpp_QFlags_QTextCodec_ConversionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextCodec_ConversionFlag_,
            is_number_PythonToCpp_QFlags_QTextCodec_ConversionFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCodec::ConversionFlags");
        Shiboken::Conversions::registerConverterName(converter, "ConversionFlags");
    }
    // End of 'ConversionFlag' enum/flags.

    qRegisterMetaType< ::QTextCodec::ConversionFlag >("QTextCodec::ConversionFlag");
    qRegisterMetaType< ::QTextCodec::ConversionFlags >("QTextCodec::ConversionFlags");
}
