/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qthread_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtcore.cpp (qthread_pthread_cleanup)]
#ifdef Q_OS_UNIX
#  include <stdio.h>
#  include <pthread.h>
static void qthread_pthread_cleanup(void *arg)
{
    // PYSIDE 1282: When terminating a thread using QThread::terminate()
    // (pthread_cancel()), QThread::run() is aborted and the lock is released,
    // but ~GilState() is still executed for some reason. Prevent it from
    // releasing.
    auto gil = reinterpret_cast<Shiboken::GilState *>(arg);
    gil->abandon();
}
#endif // Q_OS_UNIX
// END of custom code block [file: ../glue/qtcore.cpp (qthread_pthread_cleanup)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QThreadWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QThreadWrapper::QThreadWrapper(::QObject * parent) : QThread(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QThreadWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QThreadWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QThreadWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QThreadWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QThreadWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QThread::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QThread::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QThread.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QThreadWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QThread.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QThreadWrapper::run()
{
    if (m_PyMethodCache[7]) {
        return this->::QThread::run();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "run";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QThread::run();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qthread_pthread_cleanup_install)]
#ifdef Q_OS_UNIX
    pthread_cleanup_push(qthread_pthread_cleanup, &gil);
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (qthread_pthread_cleanup_install)]
    // ========================================================================

    // End of code injection

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qthread_pthread_cleanup_uninstall)]
#ifdef Q_OS_UNIX
    pthread_cleanup_pop(0);
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (qthread_pthread_cleanup_uninstall)]
    // ========================================================================

    // End of code injection

}

void QThreadWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QThreadWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QThread::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QThreadWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QThread::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QThreadWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QThreadWrapper *>(this));
        return QThread::qt_metacast(_clname);
}

QThreadWrapper::~QThreadWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QThread_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QThread >()))
        return -1;

    ::QThreadWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QThread", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QThread::QThread(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QThread(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QThread(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThread_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QThread_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QThread_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QThread(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QThreadWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QThreadWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QThread >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QThread_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QThread_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QThread_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QThreadFunc_currentThread(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.currentThread";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentThread()
            QThread * cppResult = ::QThread::currentThread();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QThread::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QThreadFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_eventDispatcher(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.eventDispatcher";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // eventDispatcher()const
            QAbstractEventDispatcher * cppResult = const_cast<const ::QThread *>(cppSelf)->eventDispatcher();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_exec_(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.exec_";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exec()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            int cppResult = cppSelf->exec();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_exit(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.exit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QThreadFunc_exit_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:exit", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QThread::exit(int)
    if (numArgs == 0) {
        overloadId = 0; // exit(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // exit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_exit_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_retcode = Shiboken::String::createStaticString("retcode");
            if (PyDict_Contains(kwds, key_retcode)) {
                value = PyDict_GetItem(kwds, key_retcode);
                if (value && pyArgs[0]) {
                    errInfo = key_retcode;
                    Py_INCREF(errInfo);
                    goto Sbk_QThreadFunc_exit_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QThreadFunc_exit_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_retcode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QThreadFunc_exit_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // exit(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->exit(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_exit_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_idealThreadCount(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.idealThreadCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // idealThreadCount()
            int cppResult = ::QThread::idealThreadCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QThread *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_isInterruptionRequested(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.isInterruptionRequested";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInterruptionRequested()const
            bool cppResult = const_cast<const ::QThread *>(cppSelf)->isInterruptionRequested();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.isRunning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunning()const
            bool cppResult = const_cast<const ::QThread *>(cppSelf)->isRunning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_loopLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.loopLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopLevel()const
            int cppResult = const_cast<const ::QThread *>(cppSelf)->loopLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_msleep(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.msleep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QThread::msleep(ulong)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // msleep(ulong)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_msleep_TypeError;

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // msleep(ulong)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QThread::msleep(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_msleep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_priority(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.priority";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // priority()const
            QThread::Priority cppResult = const_cast<const ::QThread *>(cppSelf)->priority();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_quit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.quit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quit()
            cppSelf->quit();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QThreadFunc_requestInterruption(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.requestInterruption";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestInterruption()
            cppSelf->requestInterruption();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QThreadFunc_run(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.run";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // run()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QThread::run()
                : cppSelf->run();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QThreadFunc_setEventDispatcher(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.setEventDispatcher";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QThread::setEventDispatcher(QAbstractEventDispatcher*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX]), (pyArg)))) {
        overloadId = 0; // setEventDispatcher(QAbstractEventDispatcher*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_setEventDispatcher_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractEventDispatcher *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEventDispatcher(QAbstractEventDispatcher*)
            cppSelf->setEventDispatcher(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_setEventDispatcher_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_setPriority(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.setPriority";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QThread::setPriority(QThread::Priority)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPriority(QThread::Priority)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_setPriority_TypeError;

    // Call function/method
    {
        ::QThread::Priority cppArg0{QThread::IdlePriority};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPriority(QThread::Priority)
            cppSelf->setPriority(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_setPriority_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_setStackSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.setStackSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QThread::setStackSize(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setStackSize(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_setStackSize_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStackSize(uint)
            cppSelf->setStackSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_setStackSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_setTerminationEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.setTerminationEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QThreadFunc_setTerminationEnabled_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setTerminationEnabled", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QThread::setTerminationEnabled(bool)
    if (numArgs == 0) {
        overloadId = 0; // setTerminationEnabled(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setTerminationEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_setTerminationEnabled_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_enabled = Shiboken::String::createStaticString("enabled");
            if (PyDict_Contains(kwds, key_enabled)) {
                value = PyDict_GetItem(kwds, key_enabled);
                if (value && pyArgs[0]) {
                    errInfo = key_enabled;
                    Py_INCREF(errInfo);
                    goto Sbk_QThreadFunc_setTerminationEnabled_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QThreadFunc_setTerminationEnabled_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_enabled);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QThreadFunc_setTerminationEnabled_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setTerminationEnabled(bool)
            ::QThread::setTerminationEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_setTerminationEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_sleep(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.sleep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QThread::sleep(ulong)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // sleep(ulong)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_sleep_TypeError;

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // sleep(ulong)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QThread::sleep(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_sleep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_stackSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.stackSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stackSize()const
            uint cppResult = const_cast<const ::QThread *>(cppSelf)->stackSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QThreadFunc_start(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.start";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QThreadFunc_start_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:start", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QThread::start(QThread::Priority)
    if (numArgs == 0) {
        overloadId = 0; // start(QThread::Priority)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // start(QThread::Priority)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_start_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_priority = Shiboken::String::createStaticString("priority");
            if (PyDict_Contains(kwds, key_priority)) {
                value = PyDict_GetItem(kwds, key_priority);
                if (value && pyArgs[0]) {
                    errInfo = key_priority;
                    Py_INCREF(errInfo);
                    goto Sbk_QThreadFunc_start_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QThreadFunc_start_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_priority);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QThreadFunc_start_TypeError;
            }
        }
        ::QThread::Priority cppArg0 = QThread::Priority::InheritPriority;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // start(QThread::Priority)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->start(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_start_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_terminate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.terminate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // terminate()
            cppSelf->terminate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QThreadFunc_usleep(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.usleep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QThread::usleep(ulong)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // usleep(ulong)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_usleep_TypeError;

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // usleep(ulong)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QThread::usleep(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QThreadFunc_usleep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_wait(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.wait";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QThreadFunc_wait_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:wait", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QThread::wait(QDeadlineTimer)
    // 1: QThread::wait(ulong)
    if (numArgs == 0) {
        overloadId = 0; // wait(QDeadlineTimer)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[0])))) {
        overloadId = 1; // wait(ulong)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[0])))) {
        overloadId = 0; // wait(QDeadlineTimer)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QThreadFunc_wait_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // wait(QDeadlineTimer deadline)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_deadline = Shiboken::String::createStaticString("deadline");
                if (PyDict_Contains(kwds, key_deadline)) {
                    value = PyDict_GetItem(kwds, key_deadline);
                    if (value && pyArgs[0]) {
                        errInfo = key_deadline;
                        Py_INCREF(errInfo);
                        goto Sbk_QThreadFunc_wait_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[0]))))
                            goto Sbk_QThreadFunc_wait_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deadline);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QThreadFunc_wait_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDeadlineTimer cppArg0 = QDeadlineTimer(QDeadlineTimer::Forever);
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // wait(QDeadlineTimer)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->wait(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // wait(unsigned long time)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QThreadFunc_wait_TypeError;
            }
            unsigned long cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // wait(ulong)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->wait(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QThreadFunc_wait_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QThreadFunc_yieldCurrentThread(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QThread.yieldCurrentThread";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yieldCurrentThread()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QThread::yieldCurrentThread();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QThread_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QThread_methods[] = {
    {"currentThread", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_currentThread), METH_NOARGS|METH_STATIC},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_event), METH_O},
    {"eventDispatcher", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_eventDispatcher), METH_NOARGS},
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_exec_), METH_NOARGS},
    {"exit", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_exit), METH_VARARGS|METH_KEYWORDS},
    {"idealThreadCount", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_idealThreadCount), METH_NOARGS|METH_STATIC},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_isFinished), METH_NOARGS},
    {"isInterruptionRequested", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_isInterruptionRequested), METH_NOARGS},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_isRunning), METH_NOARGS},
    {"loopLevel", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_loopLevel), METH_NOARGS},
    {"msleep", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_msleep), METH_O|METH_STATIC},
    {"priority", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_priority), METH_NOARGS},
    {"quit", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_quit), METH_NOARGS},
    {"requestInterruption", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_requestInterruption), METH_NOARGS},
    {"run", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_run), METH_NOARGS},
    {"setEventDispatcher", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_setEventDispatcher), METH_O},
    {"setPriority", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_setPriority), METH_O},
    {"setStackSize", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_setStackSize), METH_O},
    {"setTerminationEnabled", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_setTerminationEnabled), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"sleep", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_sleep), METH_O|METH_STATIC},
    {"stackSize", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_stackSize), METH_NOARGS},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_start), METH_VARARGS|METH_KEYWORDS},
    {"terminate", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_terminate), METH_NOARGS},
    {"usleep", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_usleep), METH_O|METH_STATIC},
    {"wait", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_wait), METH_VARARGS|METH_KEYWORDS},
    {"yieldCurrentThread", reinterpret_cast<PyCFunction>(Sbk_QThreadFunc_yieldCurrentThread), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QThread_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QThread *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QThreadWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QThread_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QThread_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QThread_Type = nullptr;
static SbkObjectType *Sbk_QThread_TypeF(void)
{
    return _Sbk_QThread_Type;
}

static PyType_Slot Sbk_QThread_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QThread_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QThread_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QThread_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QThread_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QThread_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QThread_spec = {
    "2:PySide2.QtCore.QThread",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QThread_slots
};

} //extern "C"

static void *Sbk_QThread_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QThread *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QThread_Priority_PythonToCpp_QThread_Priority(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QThread::Priority *>(cppOut) =
        static_cast<::QThread::Priority>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QThread_Priority_PythonToCpp_QThread_Priority_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX]))
        return QThread_Priority_PythonToCpp_QThread_Priority;
    return {};
}
static PyObject *QThread_Priority_CppToPython_QThread_Priority(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QThread::Priority *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QThread_PythonToCpp_QThread_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QThread_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QThread_PythonToCpp_QThread_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QThread_TypeF())))
        return QThread_PythonToCpp_QThread_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QThread_PTR_CppToPython_QThread(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QThread *>(const_cast<void *>(cppIn)), Sbk_QThread_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QThread_SignatureStrings[] = {
    "PySide2.QtCore.QThread(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QThread.currentThread()->PySide2.QtCore.QThread",
    "PySide2.QtCore.QThread.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QThread.eventDispatcher(self)->PySide2.QtCore.QAbstractEventDispatcher",
    "PySide2.QtCore.QThread.exec_(self)->int",
    "PySide2.QtCore.QThread.exit(self,retcode:int=0)",
    "PySide2.QtCore.QThread.idealThreadCount()->int",
    "PySide2.QtCore.QThread.isFinished(self)->bool",
    "PySide2.QtCore.QThread.isInterruptionRequested(self)->bool",
    "PySide2.QtCore.QThread.isRunning(self)->bool",
    "PySide2.QtCore.QThread.loopLevel(self)->int",
    "PySide2.QtCore.QThread.msleep(arg__1:unsigned long)",
    "PySide2.QtCore.QThread.priority(self)->PySide2.QtCore.QThread.Priority",
    "PySide2.QtCore.QThread.quit(self)",
    "PySide2.QtCore.QThread.requestInterruption(self)",
    "PySide2.QtCore.QThread.run(self)",
    "PySide2.QtCore.QThread.setEventDispatcher(self,eventDispatcher:PySide2.QtCore.QAbstractEventDispatcher)",
    "PySide2.QtCore.QThread.setPriority(self,priority:PySide2.QtCore.QThread.Priority)",
    "PySide2.QtCore.QThread.setStackSize(self,stackSize:uint)",
    "PySide2.QtCore.QThread.setTerminationEnabled(enabled:bool=true)",
    "PySide2.QtCore.QThread.sleep(arg__1:unsigned long)",
    "PySide2.QtCore.QThread.stackSize(self)->uint",
    "PySide2.QtCore.QThread.start(self,priority:PySide2.QtCore.QThread.Priority=InheritPriority)",
    "PySide2.QtCore.QThread.terminate(self)",
    "PySide2.QtCore.QThread.usleep(arg__1:unsigned long)",
    "1:PySide2.QtCore.QThread.wait(self,deadline:PySide2.QtCore.QDeadlineTimer=QDeadlineTimer(QDeadlineTimer.Forever))->bool",
    "0:PySide2.QtCore.QThread.wait(self,time:unsigned long)->bool",
    "PySide2.QtCore.QThread.yieldCurrentThread()",
    nullptr}; // Sentinel

void init_QThread(PyObject *module)
{
    _Sbk_QThread_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QThread",
        "QThread*",
        &Sbk_QThread_spec,
        &Shiboken::callCppDestructor< ::QThread >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QThread_Type);
    InitSignatureStrings(pyType, QThread_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QThread_Type), Sbk_QThread_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QThread_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QThread_TypeF(),
        QThread_PythonToCpp_QThread_PTR,
        is_QThread_PythonToCpp_QThread_PTR_Convertible,
        QThread_PTR_CppToPython_QThread);

    Shiboken::Conversions::registerConverterName(converter, "QThread");
    Shiboken::Conversions::registerConverterName(converter, "QThread*");
    Shiboken::Conversions::registerConverterName(converter, "QThread&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QThread).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QThreadWrapper).name());



    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QThread_TypeF(), &Sbk_QThread_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Priority'.
    SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QThread_TypeF(),
        "Priority",
        "2:PySide2.QtCore.QThread.Priority",
        "QThread::Priority");
    if (!SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "IdlePriority", (long) QThread::Priority::IdlePriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "LowestPriority", (long) QThread::Priority::LowestPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "LowPriority", (long) QThread::Priority::LowPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "NormalPriority", (long) QThread::Priority::NormalPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "HighPriority", (long) QThread::Priority::HighPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "HighestPriority", (long) QThread::Priority::HighestPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "TimeCriticalPriority", (long) QThread::Priority::TimeCriticalPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
        Sbk_QThread_TypeF(), "InheritPriority", (long) QThread::Priority::InheritPriority))
        return;
    // Register converter for enum 'QThread::Priority'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX],
            QThread_Priority_CppToPython_QThread_Priority);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QThread_Priority_PythonToCpp_QThread_Priority,
            is_QThread_Priority_PythonToCpp_QThread_Priority_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QThread::Priority");
        Shiboken::Conversions::registerConverterName(converter, "Priority");
    }
    // End of 'Priority' enum.

    PySide::Signal::registerSignals(Sbk_QThread_TypeF(), &::QThread::staticMetaObject);

    qRegisterMetaType< ::QThread::Priority >("QThread::Priority");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QThread_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QThread_TypeF(), &::QThread::staticMetaObject, sizeof(QThreadWrapper));
}

