/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtime_wrapper.h"

// inner classes

// Extra includes
#include <datetime.h>
#include <qdatetime.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// TEMPLATE - pydatetime_importandcheck_function - START
#ifdef IS_PY3K
#define PySideDateTime_IMPORT PyDateTime_IMPORT
#else
#define PySideDateTime_IMPORT \
            (PyDateTimeAPI = (PyDateTime_CAPI*) PyCObject_Import((char*)"datetime", \
                                                             (char*)"datetime_CAPI"))
#endif
static bool PyDateTime_ImportAndCheck(PyObject *pyIn) {
    if (!PyDateTimeAPI) PySideDateTime_IMPORT;
    return PyTime_Check(pyIn);
}
// TEMPLATE - pydatetime_importandcheck_function - END

// End of code injection



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTime_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTime >()))
        return -1;

    ::QTime *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTime_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QTime", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QTime::QTime()
    // 1: QTime::QTime(QTime)
    // 2: QTime::QTime(int,int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // QTime()
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QTime(int,int,int,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 2; // QTime(int,int,int,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 2; // QTime(int,int,int,int)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTime(QTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTime_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTime()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTime_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QTime()
                cptr = new ::QTime();
            }
            break;
        }
        case 1: // QTime(const QTime & QTime)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTime_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTime cppArg0_local;
            ::QTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTime(QTime)
                cptr = new ::QTime(*cppArg0);
            }
            break;
        }
        case 2: // QTime(int h, int m, int s, int ms)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_s = Shiboken::String::createStaticString("s");
                if (PyDict_Contains(kwds, key_s)) {
                    value = PyDict_GetItem(kwds, key_s);
                    if (value && pyArgs[2]) {
                        errInfo = key_s;
                        Py_INCREF(errInfo);
                        goto Sbk_QTime_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QTime_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_s);
                }
                static PyObject *const key_ms = Shiboken::String::createStaticString("ms");
                if (PyDict_Contains(kwds, key_ms)) {
                    value = PyDict_GetItem(kwds, key_ms);
                    if (value && pyArgs[3]) {
                        errInfo = key_ms;
                        Py_INCREF(errInfo);
                        goto Sbk_QTime_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTime_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ms);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTime_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QTime(int,int,int,int)
                cptr = new ::QTime(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTime >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTime_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTime_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTimeFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(iiii))", PyObject_Type(self), cppSelf->hour(), cppSelf->minute(), cppSelf->second(), cppSelf->msec());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%i, %i, %i, %i)",
                Py_TYPE(self)->tp_name, cppSelf->hour(), cppSelf->minute(), cppSelf->second(), cppSelf->msec());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_addMSecs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.addMSecs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTime::addMSecs(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // addMSecs(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_addMSecs_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addMSecs(int)const
            QTime cppResult = const_cast<const ::QTime *>(cppSelf)->addMSecs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_addMSecs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_addSecs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.addSecs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTime::addSecs(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // addSecs(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_addSecs_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addSecs(int)const
            QTime cppResult = const_cast<const ::QTime *>(cppSelf)->addSecs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_addSecs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_currentTime(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.currentTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentTime()
            QTime cppResult = ::QTime::currentTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_elapsed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.elapsed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // elapsed()const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->elapsed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_fromMSecsSinceStartOfDay(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.fromMSecsSinceStartOfDay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTime::fromMSecsSinceStartOfDay(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // fromMSecsSinceStartOfDay(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_fromMSecsSinceStartOfDay_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromMSecsSinceStartOfDay(int)
            QTime cppResult = ::QTime::fromMSecsSinceStartOfDay(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_fromMSecsSinceStartOfDay_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_fromString(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.fromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTimeFunc_fromString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTimeFunc_fromString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTime::fromString(QString,Qt::DateFormat)
    // 1: static QTime::fromString(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromString(QString,Qt::DateFormat)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // fromString(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromString(QString,Qt::DateFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_fromString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromString(const QString & s, Qt::DateFormat f)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeFunc_fromString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QTimeFunc_fromString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTimeFunc_fromString_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::DateFormat cppArg1 = Qt::TextDate;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromString(QString,Qt::DateFormat)
                QTime cppResult = ::QTime::fromString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromString(const QString & s, const QString & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeFunc_fromString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromString(QString,QString)
                QTime cppResult = ::QTime::fromString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_fromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_hour(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.hour";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hour()const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->hour();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QTime *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_isValid(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QTime *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.isValid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTimeFunc_isValid_TypeError;
    } else if (numArgs == 1 || numArgs == 2)
        goto Sbk_QTimeFunc_isValid_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:isValid", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QTime::isValid()const
    // 1: static QTime::isValid(int,int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // isValid()const
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 1; // isValid(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 1; // isValid(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_isValid_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isValid() const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeFunc_isValid_TypeError;
            }

            if (!PyErr_Occurred()) {
                // isValid()const
                bool cppResult = const_cast<const ::QTime *>(cppSelf)->isValid();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isValid(int h, int m, int s, int ms)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ms = Shiboken::String::createStaticString("ms");
                if (PyDict_Contains(kwds, key_ms)) {
                    value = PyDict_GetItem(kwds, key_ms);
                    if (value && pyArgs[3]) {
                        errInfo = key_ms;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeFunc_isValid_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTimeFunc_isValid_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ms);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTimeFunc_isValid_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // isValid(int,int,int,int)
                bool cppResult = ::QTime::isValid(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_isValid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_minute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.minute";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minute()const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->minute();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_msec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.msec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // msec()const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->msec();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_msecsSinceStartOfDay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.msecsSinceStartOfDay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // msecsSinceStartOfDay()const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->msecsSinceStartOfDay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_msecsTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.msecsTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTime::msecsTo(QTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
        overloadId = 0; // msecsTo(QTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_msecsTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // msecsTo(QTime)const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->msecsTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_msecsTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_restart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.restart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restart()
            int cppResult = cppSelf->restart();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_second(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.second";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // second()const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->second();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_secsTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.secsTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTime::secsTo(QTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
        overloadId = 0; // secsTo(QTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_secsTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // secsTo(QTime)const
            int cppResult = const_cast<const ::QTime *>(cppSelf)->secsTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_secsTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_setHMS(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.setHMS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTimeFunc_setHMS_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTimeFunc_setHMS_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setHMS", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QTime::setHMS(int,int,int,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setHMS(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // setHMS(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_setHMS_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_ms = Shiboken::String::createStaticString("ms");
            if (PyDict_Contains(kwds, key_ms)) {
                value = PyDict_GetItem(kwds, key_ms);
                if (value && pyArgs[3]) {
                    errInfo = key_ms;
                    Py_INCREF(errInfo);
                    goto Sbk_QTimeFunc_setHMS_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QTimeFunc_setHMS_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_ms);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTimeFunc_setHMS_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setHMS(int,int,int,int)
            bool cppResult = cppSelf->setHMS(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_setHMS_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            cppSelf->start();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTimeFunc_toPython(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.toPython";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPython()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qtime-topython)]
            if (!PyDateTimeAPI)
                PySideDateTime_IMPORT;
            pyResult = PyTime_FromTime(cppSelf->hour(), cppSelf->minute(), cppSelf->second(), cppSelf->msec()*1000);
            // END of custom code block [file: ../glue/qtcore.cpp (qtime-topython)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTime.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTimeFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTime::toString(Qt::DateFormat)const
    // 1: QTime::toString(QString)const
    if (numArgs == 0) {
        overloadId = 0; // toString(Qt::DateFormat)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // toString(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toString(Qt::DateFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeFunc_toString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toString(Qt::DateFormat f) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[0]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QTimeFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTimeFunc_toString_TypeError;
                }
            }
            ::Qt::DateFormat cppArg0 = Qt::TextDate;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(Qt::DateFormat)const
                QString cppResult = const_cast<const ::QTime *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toString(const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeFunc_toString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(QString)const
                QString cppResult = const_cast<const ::QTime *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTime___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyMethodDef Sbk_QTimeMethod_isValid = {
    "isValid", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_isValid), METH_VARARGS|METH_KEYWORDS|METH_STATIC
};


static const char *Sbk_QTime_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTime_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc___reduce__), METH_NOARGS},
    {"addMSecs", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_addMSecs), METH_O},
    {"addSecs", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_addSecs), METH_O},
    {"currentTime", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_currentTime), METH_NOARGS|METH_STATIC},
    {"elapsed", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_elapsed), METH_NOARGS},
    {"fromMSecsSinceStartOfDay", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_fromMSecsSinceStartOfDay), METH_O|METH_STATIC},
    {"fromString", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_fromString), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"hour", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_hour), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_isNull), METH_NOARGS},
    Sbk_QTimeMethod_isValid,
    {"minute", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_minute), METH_NOARGS},
    {"msec", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_msec), METH_NOARGS},
    {"msecsSinceStartOfDay", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_msecsSinceStartOfDay), METH_NOARGS},
    {"msecsTo", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_msecsTo), METH_O},
    {"restart", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_restart), METH_NOARGS},
    {"second", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_second), METH_NOARGS},
    {"secsTo", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_secsTo), METH_O},
    {"setHMS", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_setHMS), METH_VARARGS|METH_KEYWORDS},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_start), METH_NOARGS},
    {"toPython", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_toPython), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QTimeFunc_toString), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTime___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTime_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QTimeMethod_isValid = {
        Sbk_QTimeMethod_isValid.ml_name,
        Sbk_QTimeMethod_isValid.ml_meth,
        Sbk_QTimeMethod_isValid.ml_flags & (~METH_STATIC),
        Sbk_QTimeMethod_isValid.ml_doc,
    };
    if (Shiboken::String::compare(name, "isValid") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QTimeMethod_isValid, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

static int Sbk_QTime___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QTime_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
                // operator!=(const QTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
                // operator<(const QTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTime_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
                // operator<=(const QTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTime_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
                // operator==(const QTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
                // operator>(const QTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTime_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
                // operator>=(const QTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTime_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QTime_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QTime_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QTime_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(PySide::hash(*cppSelf));
}

static int Sbk_QTime_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTime_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTime_Type = nullptr;
static SbkObjectType *Sbk_QTime_TypeF(void)
{
    return _Sbk_QTime_Type;
}

static PyType_Slot Sbk_QTime_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QTimeFunc___repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QTime_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QTime_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTime_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTime_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QTime_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTime_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTime_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QTime___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QTime___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QTime_spec = {
    "2:PySide2.QtCore.QTime",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTime_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTime_PythonToCpp_QTime_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTime_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTime_PythonToCpp_QTime_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTime_TypeF())))
        return QTime_PythonToCpp_QTime_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTime_PTR_CppToPython_QTime(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTime *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTime_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTime_COPY_CppToPython_QTime(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTime_TypeF(), new ::QTime(*reinterpret_cast<const ::QTime *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTime_PythonToCpp_QTime_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTime *>(cppOut) = *reinterpret_cast< ::QTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTime_PythonToCpp_QTime_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTime_TypeF())))
        return QTime_PythonToCpp_QTime_COPY;
    return {};
}

// Python to C++ conversions for type 'QTime'.
static void Py_None_PythonToCpp_QTime(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QTime *>(cppOut) = QTime();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QTime_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QTime;
    return {};
}
static void PyTime_PythonToCpp_QTime(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qtime-pytime)]
    int hour = PyDateTime_TIME_GET_HOUR(pyIn);
    int min = PyDateTime_TIME_GET_MINUTE(pyIn);
    int sec = PyDateTime_TIME_GET_SECOND(pyIn);
    int usec = PyDateTime_TIME_GET_MICROSECOND(pyIn);
    *reinterpret_cast<::QTime *>(cppOut) = QTime(hour, min, sec, usec/1000);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qtime-pytime)]
    // ========================================================================

}
static PythonToCppFunc is_PyTime_PythonToCpp_QTime_Convertible(PyObject *pyIn) {
    if (PyDateTime_ImportAndCheck(pyIn))
        return PyTime_PythonToCpp_QTime;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTime_SignatureStrings[] = {
    "2:PySide2.QtCore.QTime(self)",
    "1:PySide2.QtCore.QTime(self,QTime:PySide2.QtCore.QTime)",
    "0:PySide2.QtCore.QTime(self,h:int,m:int,s:int=0,ms:int=0)",
    "PySide2.QtCore.QTime.__reduce__(self)->PyObject",
    "PySide2.QtCore.QTime.__repr__(self)->PyObject",
    "PySide2.QtCore.QTime.addMSecs(self,ms:int)->PySide2.QtCore.QTime",
    "PySide2.QtCore.QTime.addSecs(self,secs:int)->PySide2.QtCore.QTime",
    "PySide2.QtCore.QTime.currentTime()->PySide2.QtCore.QTime",
    "PySide2.QtCore.QTime.elapsed(self)->int",
    "PySide2.QtCore.QTime.fromMSecsSinceStartOfDay(msecs:int)->PySide2.QtCore.QTime",
    "1:PySide2.QtCore.QTime.fromString(s:QString,f:PySide2.QtCore.Qt.DateFormat=Qt.TextDate)->PySide2.QtCore.QTime",
    "0:PySide2.QtCore.QTime.fromString(s:QString,format:QString)->PySide2.QtCore.QTime",
    "PySide2.QtCore.QTime.hour(self)->int",
    "PySide2.QtCore.QTime.isNull(self)->bool",
    "1:PySide2.QtCore.QTime.isValid(self)->bool",
    "0:PySide2.QtCore.QTime.isValid(h:int,m:int,s:int,ms:int=0)->bool",
    "PySide2.QtCore.QTime.minute(self)->int",
    "PySide2.QtCore.QTime.msec(self)->int",
    "PySide2.QtCore.QTime.msecsSinceStartOfDay(self)->int",
    "PySide2.QtCore.QTime.msecsTo(self,arg__1:PySide2.QtCore.QTime)->int",
    "PySide2.QtCore.QTime.restart(self)->int",
    "PySide2.QtCore.QTime.second(self)->int",
    "PySide2.QtCore.QTime.secsTo(self,arg__1:PySide2.QtCore.QTime)->int",
    "PySide2.QtCore.QTime.setHMS(self,h:int,m:int,s:int,ms:int=0)->bool",
    "PySide2.QtCore.QTime.start(self)",
    "PySide2.QtCore.QTime.toPython(self)->PyObject",
    "1:PySide2.QtCore.QTime.toString(self,f:PySide2.QtCore.Qt.DateFormat=Qt.TextDate)->QString",
    "0:PySide2.QtCore.QTime.toString(self,format:QString)->QString",
    "PySide2.QtCore.QTime.__copy__()",
    nullptr}; // Sentinel

void init_QTime(PyObject *module)
{
    _Sbk_QTime_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTime",
        "QTime",
        &Sbk_QTime_spec,
        &Shiboken::callCppDestructor< ::QTime >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTime_Type);
    InitSignatureStrings(pyType, QTime_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTime_Type), Sbk_QTime_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTime_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTime_TypeF(),
        QTime_PythonToCpp_QTime_PTR,
        is_QTime_PythonToCpp_QTime_PTR_Convertible,
        QTime_PTR_CppToPython_QTime,
        QTime_COPY_CppToPython_QTime);

    Shiboken::Conversions::registerConverterName(converter, "QTime");
    Shiboken::Conversions::registerConverterName(converter, "QTime*");
    Shiboken::Conversions::registerConverterName(converter, "QTime&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTime).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTime_PythonToCpp_QTime_COPY,
        is_QTime_PythonToCpp_QTime_COPY_Convertible);
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Py_None_PythonToCpp_QTime,
        is_Py_None_PythonToCpp_QTime_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PyTime_PythonToCpp_QTime,
        is_PyTime_PythonToCpp_QTime_Convertible);


    // Initialization of enums.


    qRegisterMetaType< ::QTime >("QTime");
}

