/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtimezone_offsetdata_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTimeZone_OffsetData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTimeZone::OffsetData >()))
        return -1;

    ::QTimeZone::OffsetData *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.OffsetData.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "OffsetData", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: OffsetData::OffsetData()
    // 1: OffsetData::OffsetData(QTimeZone::OffsetData)
    if (numArgs == 0) {
        overloadId = 0; // OffsetData()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), (pyArgs[0])))) {
        overloadId = 1; // OffsetData(QTimeZone::OffsetData)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZone_OffsetData_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // OffsetData()
        {

            if (!PyErr_Occurred()) {
                // OffsetData()
                cptr = new ::QTimeZone::OffsetData();
            }
            break;
        }
        case 1: // OffsetData(const QTimeZone::OffsetData & OffsetData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTimeZone::OffsetData cppArg0_local;
            ::QTimeZone::OffsetData *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // OffsetData(QTimeZone::OffsetData)
                cptr = new ::QTimeZone::OffsetData(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTimeZone::OffsetData >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTimeZone_OffsetData_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTimeZone_OffsetData_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTimeZone_OffsetData___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTimeZone_OffsetData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTimeZone_OffsetData_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTimeZone_OffsetData___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTimeZone_OffsetData_get_abbreviation(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->abbreviation);
    return pyOut;
}
static int Sbk_QTimeZone_OffsetData_set_abbreviation(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'abbreviation' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'abbreviation', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->abbreviation;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QTimeZone_OffsetData_get_atUtc(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->atUtc)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->atUtc))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->atUtc)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &(cppSelf->atUtc), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QTimeZone_OffsetData_set_atUtc(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'atUtc' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'atUtc', 'QDateTime' or convertible type expected");
        return -1;
    }

    ::QDateTime& cppOut_ptr = cppSelf->atUtc;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QTimeZone_OffsetData_get_offsetFromUtc(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->offsetFromUtc;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QTimeZone_OffsetData_set_offsetFromUtc(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'offsetFromUtc' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'offsetFromUtc', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->offsetFromUtc;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->offsetFromUtc = cppOut_local;

    return 0;
}

static PyObject *Sbk_QTimeZone_OffsetData_get_standardTimeOffset(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->standardTimeOffset;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QTimeZone_OffsetData_set_standardTimeOffset(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'standardTimeOffset' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'standardTimeOffset', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->standardTimeOffset;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->standardTimeOffset = cppOut_local;

    return 0;
}

static PyObject *Sbk_QTimeZone_OffsetData_get_daylightTimeOffset(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->daylightTimeOffset;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QTimeZone_OffsetData_set_daylightTimeOffset(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'daylightTimeOffset' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'daylightTimeOffset', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->daylightTimeOffset;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->daylightTimeOffset = cppOut_local;

    return 0;
}

// Getters and Setters for OffsetData
static PyGetSetDef Sbk_QTimeZone_OffsetData_getsetlist[] = {
    {const_cast<char *>("abbreviation"), Sbk_QTimeZone_OffsetData_get_abbreviation, Sbk_QTimeZone_OffsetData_set_abbreviation},
    {const_cast<char *>("atUtc"), Sbk_QTimeZone_OffsetData_get_atUtc, Sbk_QTimeZone_OffsetData_set_atUtc},
    {const_cast<char *>("offsetFromUtc"), Sbk_QTimeZone_OffsetData_get_offsetFromUtc, Sbk_QTimeZone_OffsetData_set_offsetFromUtc},
    {const_cast<char *>("standardTimeOffset"), Sbk_QTimeZone_OffsetData_get_standardTimeOffset, Sbk_QTimeZone_OffsetData_set_standardTimeOffset},
    {const_cast<char *>("daylightTimeOffset"), Sbk_QTimeZone_OffsetData_get_daylightTimeOffset, Sbk_QTimeZone_OffsetData_set_daylightTimeOffset},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTimeZone_OffsetData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTimeZone_OffsetData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTimeZone_OffsetData_Type = nullptr;
static SbkObjectType *Sbk_QTimeZone_OffsetData_TypeF(void)
{
    return _Sbk_QTimeZone_OffsetData_Type;
}

static PyType_Slot Sbk_QTimeZone_OffsetData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTimeZone_OffsetData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTimeZone_OffsetData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTimeZone_OffsetData_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QTimeZone_OffsetData_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTimeZone_OffsetData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTimeZone_OffsetData_spec = {
    "2:PySide2.QtCore.QTimeZone.OffsetData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTimeZone_OffsetData_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void OffsetData_PythonToCpp_OffsetData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTimeZone_OffsetData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_OffsetData_PythonToCpp_OffsetData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTimeZone_OffsetData_TypeF())))
        return OffsetData_PythonToCpp_OffsetData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *OffsetData_PTR_CppToPython_OffsetData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTimeZone::OffsetData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTimeZone_OffsetData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *OffsetData_COPY_CppToPython_OffsetData(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTimeZone_OffsetData_TypeF(), new ::QTimeZone::OffsetData(*reinterpret_cast<const ::QTimeZone::OffsetData *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void OffsetData_PythonToCpp_OffsetData_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeZone::OffsetData *>(cppOut) = *reinterpret_cast< ::QTimeZone::OffsetData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_OffsetData_PythonToCpp_OffsetData_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTimeZone_OffsetData_TypeF())))
        return OffsetData_PythonToCpp_OffsetData_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTimeZone_OffsetData_SignatureStrings[] = {
    "1:PySide2.QtCore.QTimeZone.OffsetData(self)",
    "0:PySide2.QtCore.QTimeZone.OffsetData(self,OffsetData:PySide2.QtCore.QTimeZone.OffsetData)",
    "PySide2.QtCore.QTimeZone.OffsetData.__copy__()",
    nullptr}; // Sentinel

void init_QTimeZone_OffsetData(PyObject *enclosingClass)
{
    _Sbk_QTimeZone_OffsetData_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "OffsetData",
        "QTimeZone::OffsetData",
        &Sbk_QTimeZone_OffsetData_spec,
        &Shiboken::callCppDestructor< ::QTimeZone::OffsetData >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTimeZone_OffsetData_Type);
    InitSignatureStrings(pyType, QTimeZone_OffsetData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTimeZone_OffsetData_Type), Sbk_QTimeZone_OffsetData_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTimeZone_OffsetData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTimeZone_OffsetData_TypeF(),
        OffsetData_PythonToCpp_OffsetData_PTR,
        is_OffsetData_PythonToCpp_OffsetData_PTR_Convertible,
        OffsetData_PTR_CppToPython_OffsetData,
        OffsetData_COPY_CppToPython_OffsetData);

    Shiboken::Conversions::registerConverterName(converter, "QTimeZone::OffsetData");
    Shiboken::Conversions::registerConverterName(converter, "QTimeZone::OffsetData*");
    Shiboken::Conversions::registerConverterName(converter, "QTimeZone::OffsetData&");
    Shiboken::Conversions::registerConverterName(converter, "OffsetData");
    Shiboken::Conversions::registerConverterName(converter, "OffsetData*");
    Shiboken::Conversions::registerConverterName(converter, "OffsetData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTimeZone::OffsetData).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        OffsetData_PythonToCpp_OffsetData_COPY,
        is_OffsetData_PythonToCpp_OffsetData_COPY_Convertible);

    qRegisterMetaType< ::QTimeZone::OffsetData >("OffsetData");
    qRegisterMetaType< ::QTimeZone::OffsetData >("QTimeZone::OffsetData");
}
