/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qurl_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qurl.h>
#include <qurlquery.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QUrl_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QUrl >()))
        return -1;

    ::QUrl *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrl_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QUrl", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QUrl::QUrl()
    // 1: QUrl::QUrl(QString,QUrl::ParsingMode)
    // 2: QUrl::QUrl(QUrl)
    if (numArgs == 0) {
        overloadId = 0; // QUrl()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QUrl(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QUrl(QString,QUrl::ParsingMode)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrl_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QUrl()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QUrl_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QUrl()
                cptr = new ::QUrl();
            }
            break;
        }
        case 1: // QUrl(const QString & url, QUrl::ParsingMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QUrl_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QUrl_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QUrl_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QUrl(QString,QUrl::ParsingMode)
                cptr = new ::QUrl(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QUrl(const QUrl & copy)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QUrl_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QUrl(QUrl)
                cptr = new ::QUrl(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QUrl >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QUrl_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QUrl_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QUrlFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(s))", PyObject_Type(self), qPrintable(cppSelf->toString()));
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s('%s')",
                Py_TYPE(self)->tp_name, qPrintable(cppSelf->toString()));
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_adjusted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.adjusted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrl::adjusted(QFlags<QUrl::ComponentFormattingOption>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // adjusted(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_adjusted_TypeError;

    // Call function/method
    {
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QFlags<QUrl::ComponentFormattingOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // adjusted(QFlags<QUrl::ComponentFormattingOption>)const
            QUrl cppResult = const_cast<const ::QUrl *>(cppSelf)->adjusted(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_adjusted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_authority(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.authority";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_authority_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:authority", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::authority(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // authority(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // authority(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_authority_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_authority_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_authority_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_authority_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // authority(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->authority(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_authority_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QUrlFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_fileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fileName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:fileName", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::fileName(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // fileName(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // fileName(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fileName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_fileName_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_fileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_fileName_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // fileName(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->fileName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fragment(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fragment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fragment_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:fragment", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::fragment(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // fragment(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // fragment(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fragment_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_fragment_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_fragment_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_fragment_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // fragment(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->fragment(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fragment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fromAce(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fromAce";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QUrl::fromAce(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // fromAce(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fromAce_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromAce(QByteArray)
            QString cppResult = ::QUrl::fromAce(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fromAce_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fromEncoded(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fromEncoded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fromEncoded_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fromEncoded_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromEncoded", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QUrl::fromEncoded(QByteArray,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromEncoded(QByteArray,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromEncoded(QByteArray,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fromEncoded_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_fromEncoded_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_fromEncoded_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_fromEncoded_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromEncoded(QByteArray,QUrl::ParsingMode)
            QUrl cppResult = ::QUrl::fromEncoded(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fromEncoded_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fromLocalFile(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fromLocalFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QUrl::fromLocalFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromLocalFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fromLocalFile_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromLocalFile(QString)
            QUrl cppResult = ::QUrl::fromLocalFile(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fromLocalFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fromPercentEncoding(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fromPercentEncoding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QUrl::fromPercentEncoding(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // fromPercentEncoding(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fromPercentEncoding_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromPercentEncoding(QByteArray)
            QString cppResult = ::QUrl::fromPercentEncoding(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fromPercentEncoding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fromStringList(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fromStringList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fromStringList_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fromStringList_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromStringList", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QUrl::fromStringList(QStringList,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromStringList(QStringList,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromStringList(QStringList,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fromStringList_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_fromStringList_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_fromStringList_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_fromStringList_TypeError;
            }
        }
        ::QStringList cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromStringList(QStringList,QUrl::ParsingMode)
            QList<QUrl > cppResult = ::QUrl::fromStringList(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QURL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fromStringList_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_fromUserInput(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.fromUserInput";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fromUserInput_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_fromUserInput_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromUserInput", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QUrl::fromUserInput(QString)
    // 1: static QUrl::fromUserInput(QString,QString,QFlags<QUrl::UserInputResolutionOption>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromUserInput(QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // fromUserInput(QString,QString,QFlags<QUrl::UserInputResolutionOption>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // fromUserInput(QString,QString,QFlags<QUrl::UserInputResolutionOption>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_fromUserInput_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromUserInput(const QString & userInput)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QUrlFunc_fromUserInput_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromUserInput(QString)
                QUrl cppResult = ::QUrl::fromUserInput(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromUserInput(const QString & userInput, const QString & workingDirectory, QFlags<QUrl::UserInputResolutionOption> options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QUrlFunc_fromUserInput_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QUrlFunc_fromUserInput_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QUrlFunc_fromUserInput_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QUrl::UserInputResolutionOption> cppArg2 = QUrl::DefaultResolution;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromUserInput(QString,QString,QFlags<QUrl::UserInputResolutionOption>)
                QUrl cppResult = ::QUrl::fromUserInput(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_fromUserInput_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_hasFragment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.hasFragment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasFragment()const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->hasFragment();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_hasQuery(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.hasQuery";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasQuery()const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->hasQuery();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_host(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.host";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_host_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:host", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::host(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // host(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // host(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_host_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_host_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_host_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_host_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // host(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->host(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_host_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_idnWhitelist(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.idnWhitelist";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // idnWhitelist()
            QStringList cppResult = ::QUrl::idnWhitelist();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_isLocalFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.isLocalFile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLocalFile()const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->isLocalFile();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_isParentOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.isParentOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrl::isParentOf(QUrl)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // isParentOf(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_isParentOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isParentOf(QUrl)const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->isParentOf(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_isParentOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_isRelative(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.isRelative";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRelative()const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->isRelative();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_matches(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.matches";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "matches", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::matches(QUrl,QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // matches(QUrl,QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_matches_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<QUrl::ComponentFormattingOption> cppArg1 = QFlags<QUrl::ComponentFormattingOption>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // matches(QUrl,QFlags<QUrl::ComponentFormattingOption>)const
            bool cppResult = const_cast<const ::QUrl *>(cppSelf)->matches(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_matches_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_password(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.password";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_password_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:password", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::password(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // password(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // password(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_password_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_password_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_password_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_password_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // password(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->password(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_password_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_path(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.path";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_path_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:path", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::path(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // path(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // path(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_path_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_path_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_path_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_path_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // path(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->path(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_path_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_port(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.port";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_port_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:port", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::port(int)const
    if (numArgs == 0) {
        overloadId = 0; // port(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // port(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_port_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultPort = Shiboken::String::createStaticString("defaultPort");
            if (PyDict_Contains(kwds, key_defaultPort)) {
                value = PyDict_GetItem(kwds, key_defaultPort);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultPort;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_port_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QUrlFunc_port_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultPort);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_port_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // port(int)const
            int cppResult = const_cast<const ::QUrl *>(cppSelf)->port(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_port_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_query(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.query";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_query_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:query", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::query(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // query(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // query(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_query_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_query_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_query_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_query_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // query(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->query(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_query_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_resolved(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.resolved";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrl::resolved(QUrl)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // resolved(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_resolved_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // resolved(QUrl)const
            QUrl cppResult = const_cast<const ::QUrl *>(cppSelf)->resolved(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_resolved_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_scheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.scheme";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scheme()const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->scheme();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_setAuthority(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setAuthority";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setAuthority_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setAuthority_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setAuthority", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setAuthority(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setAuthority(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setAuthority(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setAuthority_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setAuthority_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setAuthority_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setAuthority_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAuthority(QString,QUrl::ParsingMode)
            cppSelf->setAuthority(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setAuthority_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setFragment(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setFragment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setFragment_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setFragment_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFragment", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setFragment(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFragment(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setFragment(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setFragment_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setFragment_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setFragment_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setFragment_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFragment(QString,QUrl::ParsingMode)
            cppSelf->setFragment(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setFragment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setHost(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setHost";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setHost_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setHost_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setHost", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setHost(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setHost(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setHost(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setHost_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setHost_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setHost_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setHost_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::DecodedMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setHost(QString,QUrl::ParsingMode)
            cppSelf->setHost(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setHost_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setIdnWhitelist(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setIdnWhitelist";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QUrl::setIdnWhitelist(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setIdnWhitelist(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setIdnWhitelist_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIdnWhitelist(QStringList)
            ::QUrl::setIdnWhitelist(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setIdnWhitelist_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setPassword(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setPassword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setPassword_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setPassword_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPassword", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setPassword(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPassword(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setPassword(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setPassword_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setPassword_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setPassword_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setPassword_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::DecodedMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setPassword(QString,QUrl::ParsingMode)
            cppSelf->setPassword(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setPassword_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setPath(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setPath_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setPath_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPath", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setPath(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPath(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setPath(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setPath_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setPath_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setPath_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setPath_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::DecodedMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setPath(QString,QUrl::ParsingMode)
            cppSelf->setPath(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrl::setPort(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPort(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setPort_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPort(int)
            cppSelf->setPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setQuery(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setQuery_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setQuery_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setQuery", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setQuery(QString,QUrl::ParsingMode)
    // 1: QUrl::setQuery(QUrlQuery)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // setQuery(QUrlQuery)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setQuery(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setQuery(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setQuery_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setQuery(const QString & query, QUrl::ParsingMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QUrlFunc_setQuery_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QUrlFunc_setQuery_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QUrlFunc_setQuery_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setQuery(QString,QUrl::ParsingMode)
                cppSelf->setQuery(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setQuery(const QUrlQuery & query)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QUrlFunc_setQuery_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrlQuery cppArg0_local;
            ::QUrlQuery *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setQuery(QUrlQuery)
                cppSelf->setQuery(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setScheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setScheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrl::setScheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setScheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setScheme_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScheme(QString)
            cppSelf->setScheme(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setScheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setUrl_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setUrl", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setUrl(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setUrl(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setUrl(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setUrl_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setUrl_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setUrl(QString,QUrl::ParsingMode)
            cppSelf->setUrl(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setUserInfo(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setUserInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setUserInfo_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setUserInfo_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setUserInfo", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setUserInfo(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setUserInfo(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setUserInfo(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setUserInfo_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setUserInfo_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setUserInfo_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setUserInfo_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::TolerantMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setUserInfo(QString,QUrl::ParsingMode)
            cppSelf->setUserInfo(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setUserInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_setUserName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.setUserName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setUserName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_setUserName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setUserName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::setUserName(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setUserName(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setUserName(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_setUserName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_setUserName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_setUserName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_setUserName_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::ParsingMode::DecodedMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setUserName(QString,QUrl::ParsingMode)
            cppSelf->setUserName(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_setUserName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrl::swap(QUrl&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QUrl&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QUrl&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_toAce(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toAce";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QUrl::toAce(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toAce(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_toAce_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toAce(QString)
            QByteArray cppResult = ::QUrl::toAce(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_toAce_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_toDisplayString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toDisplayString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toDisplayString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toDisplayString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::toDisplayString(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // toDisplayString(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toDisplayString(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_toDisplayString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_toDisplayString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_toDisplayString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_toDisplayString_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FormattingOptions(QUrl::ComponentFormattingOption::PrettyDecoded);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toDisplayString(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->toDisplayString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_toDisplayString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_toEncoded(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toEncoded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toEncoded_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toEncoded", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::toEncoded(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // toEncoded(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toEncoded(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_toEncoded_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_toEncoded_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_toEncoded_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_toEncoded_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyEncoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toEncoded(QFlags<QUrl::ComponentFormattingOption>)const
            QByteArray cppResult = const_cast<const ::QUrl *>(cppSelf)->toEncoded(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_toEncoded_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_toLocalFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toLocalFile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toLocalFile()const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->toLocalFile();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlFunc_toPercentEncoding(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toPercentEncoding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toPercentEncoding", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QUrl::toPercentEncoding(QString,QByteArray,QByteArray)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toPercentEncoding(QString,QByteArray,QByteArray)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toPercentEncoding(QString,QByteArray,QByteArray)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[2])))) {
                overloadId = 0; // toPercentEncoding(QString,QByteArray,QByteArray)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_toPercentEncoding_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_exclude = Shiboken::String::createStaticString("exclude");
            if (PyDict_Contains(kwds, key_exclude)) {
                value = PyDict_GetItem(kwds, key_exclude);
                if (value && pyArgs[1]) {
                    errInfo = key_exclude;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1]))))
                        goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_exclude);
            }
            static PyObject *const key_include = Shiboken::String::createStaticString("include");
            if (PyDict_Contains(kwds, key_include)) {
                value = PyDict_GetItem(kwds, key_include);
                if (value && pyArgs[2]) {
                    errInfo = key_include;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[2]))))
                        goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_include);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_toPercentEncoding_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local = QByteArray();
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QByteArray cppArg2_local = QByteArray();
        ::QByteArray *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }

        if (!PyErr_Occurred()) {
            // toPercentEncoding(QString,QByteArray,QByteArray)
            QByteArray cppResult = ::QUrl::toPercentEncoding(cppArg0, *cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_toPercentEncoding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::toString(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // toString(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toString(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_toString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_toString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_toString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_toString_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FormattingOptions(QUrl::ComponentFormattingOption::PrettyDecoded);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toString(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->toString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_toStringList(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.toStringList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toStringList_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_toStringList_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:toStringList", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QUrl::toStringList(QList<QUrl>,QFlags<QUrl::ComponentFormattingOption>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QURL_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toStringList(QList<QUrl>,QFlags<QUrl::ComponentFormattingOption>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // toStringList(QList<QUrl>,QFlags<QUrl::ComponentFormattingOption>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_toStringList_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[1]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_toStringList_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlFunc_toStringList_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_toStringList_TypeError;
            }
        }
        ::QList<QUrl > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QUrl::ComponentFormattingOption> cppArg1 = QUrl::FormattingOptions(QUrl::ComponentFormattingOption::PrettyDecoded);
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // toStringList(QList<QUrl>,QFlags<QUrl::ComponentFormattingOption>)
            QStringList cppResult = ::QUrl::toStringList(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_toStringList_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_topLevelDomain(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.topLevelDomain";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_topLevelDomain_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:topLevelDomain", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::topLevelDomain(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // topLevelDomain(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // topLevelDomain(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_topLevelDomain_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_topLevelDomain_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_topLevelDomain_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_topLevelDomain_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // topLevelDomain(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->topLevelDomain(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_topLevelDomain_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_url(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.url";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_url_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:url", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::url(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // url(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // url(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_url_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_url_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_url_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_url_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FormattingOptions(QUrl::ComponentFormattingOption::PrettyDecoded);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // url(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->url(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_url_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_userInfo(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.userInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_userInfo_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:userInfo", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::userInfo(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // userInfo(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // userInfo(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_userInfo_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_userInfo_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_userInfo_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_userInfo_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // userInfo(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->userInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_userInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlFunc_userName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrl.userName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlFunc_userName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:userName", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrl::userName(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // userName(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // userName(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlFunc_userName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlFunc_userName_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlFunc_userName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlFunc_userName_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // userName(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrl *>(cppSelf)->userName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlFunc_userName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrl___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QUrl_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QUrl_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc___reduce__), METH_NOARGS},
    {"adjusted", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_adjusted), METH_O},
    {"authority", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_authority), METH_VARARGS|METH_KEYWORDS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_clear), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_errorString), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fileName), METH_VARARGS|METH_KEYWORDS},
    {"fragment", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fragment), METH_VARARGS|METH_KEYWORDS},
    {"fromAce", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fromAce), METH_O|METH_STATIC},
    {"fromEncoded", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fromEncoded), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromLocalFile", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fromLocalFile), METH_O|METH_STATIC},
    {"fromPercentEncoding", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fromPercentEncoding), METH_O|METH_STATIC},
    {"fromStringList", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fromStringList), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromUserInput", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_fromUserInput), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"hasFragment", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_hasFragment), METH_NOARGS},
    {"hasQuery", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_hasQuery), METH_NOARGS},
    {"host", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_host), METH_VARARGS|METH_KEYWORDS},
    {"idnWhitelist", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_idnWhitelist), METH_NOARGS|METH_STATIC},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_isEmpty), METH_NOARGS},
    {"isLocalFile", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_isLocalFile), METH_NOARGS},
    {"isParentOf", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_isParentOf), METH_O},
    {"isRelative", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_isRelative), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_isValid), METH_NOARGS},
    {"matches", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_matches), METH_VARARGS},
    {"password", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_password), METH_VARARGS|METH_KEYWORDS},
    {"path", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_path), METH_VARARGS|METH_KEYWORDS},
    {"port", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_port), METH_VARARGS|METH_KEYWORDS},
    {"query", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_query), METH_VARARGS|METH_KEYWORDS},
    {"resolved", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_resolved), METH_O},
    {"scheme", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_scheme), METH_NOARGS},
    {"setAuthority", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setAuthority), METH_VARARGS|METH_KEYWORDS},
    {"setFragment", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setFragment), METH_VARARGS|METH_KEYWORDS},
    {"setHost", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setHost), METH_VARARGS|METH_KEYWORDS},
    {"setIdnWhitelist", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setIdnWhitelist), METH_O|METH_STATIC},
    {"setPassword", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setPassword), METH_VARARGS|METH_KEYWORDS},
    {"setPath", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setPath), METH_VARARGS|METH_KEYWORDS},
    {"setPort", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setPort), METH_O},
    {"setQuery", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setQuery), METH_VARARGS|METH_KEYWORDS},
    {"setScheme", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setScheme), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setUrl), METH_VARARGS|METH_KEYWORDS},
    {"setUserInfo", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setUserInfo), METH_VARARGS|METH_KEYWORDS},
    {"setUserName", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_setUserName), METH_VARARGS|METH_KEYWORDS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_swap), METH_O},
    {"toAce", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toAce), METH_O|METH_STATIC},
    {"toDisplayString", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toDisplayString), METH_VARARGS|METH_KEYWORDS},
    {"toEncoded", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toEncoded), METH_VARARGS|METH_KEYWORDS},
    {"toLocalFile", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toLocalFile), METH_NOARGS},
    {"toPercentEncoding", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toPercentEncoding), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toString), METH_VARARGS|METH_KEYWORDS},
    {"toStringList", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_toStringList), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"topLevelDomain", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_topLevelDomain), METH_VARARGS|METH_KEYWORDS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_url), METH_VARARGS|METH_KEYWORDS},
    {"userInfo", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_userInfo), METH_VARARGS|METH_KEYWORDS},
    {"userName", reinterpret_cast<PyCFunction>(Sbk_QUrlFunc_userName), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QUrl___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QUrl_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
                // operator!=(const QUrl & url) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrl cppArg0_local;
                ::QUrl *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
                // operator<(const QUrl & url) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrl cppArg0_local;
                ::QUrl *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QUrl_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
                // operator==(const QUrl & url) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrl cppArg0_local;
                ::QUrl *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QUrl_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QUrl_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QUrl_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(PySide::hash(*cppSelf));
}

static int Sbk_QUrl_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QUrl_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QUrl_Type = nullptr;
static SbkObjectType *Sbk_QUrl_TypeF(void)
{
    return _Sbk_QUrl_Type;
}

static PyType_Slot Sbk_QUrl_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QUrlFunc___repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QUrl_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QUrl_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QUrl_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QUrl_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QUrl_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QUrl_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QUrl_spec = {
    "2:PySide2.QtCore.QUrl",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QUrl_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QUrl_ComponentFormattingOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::FormattingOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QUrl::FormattingOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QUrl::FormattingOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QUrl::FormattingOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QUrl::FormattingOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QUrl_ComponentFormattingOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::FormattingOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QUrl::FormattingOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QUrl::FormattingOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QUrl::FormattingOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QUrl::FormattingOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QUrl_ComponentFormattingOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::FormattingOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QUrl::FormattingOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QUrl::FormattingOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QUrl::FormattingOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QUrl::FormattingOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QUrl_ComponentFormattingOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::FormattingOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, self, &cppSelf);
    ::QUrl::FormattingOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QUrl_ComponentFormattingOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QUrl_ComponentFormattingOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QUrl_ComponentFormattingOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_ComponentFormattingOption_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_QUrl_UserInputResolutionOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::UserInputResolutionOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QUrl::UserInputResolutionOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QUrl::UserInputResolutionOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QUrl::UserInputResolutionOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QUrl::UserInputResolutionOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QUrl_UserInputResolutionOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::UserInputResolutionOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QUrl::UserInputResolutionOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QUrl::UserInputResolutionOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QUrl::UserInputResolutionOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QUrl::UserInputResolutionOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QUrl_UserInputResolutionOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::UserInputResolutionOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QUrl::UserInputResolutionOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QUrl::UserInputResolutionOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QUrl::UserInputResolutionOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QUrl::UserInputResolutionOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QUrl_UserInputResolutionOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QUrl::UserInputResolutionOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, self, &cppSelf);
    ::QUrl::UserInputResolutionOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QUrl_UserInputResolutionOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QUrl_UserInputResolutionOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QUrl_UserInputResolutionOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QUrl_UserInputResolutionOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QUrl_ParsingMode_PythonToCpp_QUrl_ParsingMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUrl::ParsingMode *>(cppOut) =
        static_cast<::QUrl::ParsingMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUrl_ParsingMode_PythonToCpp_QUrl_ParsingMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX]))
        return QUrl_ParsingMode_PythonToCpp_QUrl_ParsingMode;
    return {};
}
static PyObject *QUrl_ParsingMode_CppToPython_QUrl_ParsingMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUrl::ParsingMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX], castCppIn);

}

static void QUrl_UrlFormattingOption_PythonToCpp_QUrl_UrlFormattingOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUrl::UrlFormattingOption *>(cppOut) =
        static_cast<::QUrl::UrlFormattingOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUrl_UrlFormattingOption_PythonToCpp_QUrl_UrlFormattingOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX]))
        return QUrl_UrlFormattingOption_PythonToCpp_QUrl_UrlFormattingOption;
    return {};
}
static PyObject *QUrl_UrlFormattingOption_CppToPython_QUrl_UrlFormattingOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUrl::UrlFormattingOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX], castCppIn);

}

static void QUrl_ComponentFormattingOption_PythonToCpp_QUrl_ComponentFormattingOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUrl::ComponentFormattingOption *>(cppOut) =
        static_cast<::QUrl::ComponentFormattingOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUrl_ComponentFormattingOption_PythonToCpp_QUrl_ComponentFormattingOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX]))
        return QUrl_ComponentFormattingOption_PythonToCpp_QUrl_ComponentFormattingOption;
    return {};
}
static PyObject *QUrl_ComponentFormattingOption_CppToPython_QUrl_ComponentFormattingOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUrl::ComponentFormattingOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX], castCppIn);

}

static void QFlags_QUrl_ComponentFormattingOption__PythonToCpp_QFlags_QUrl_ComponentFormattingOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QUrl::ComponentFormattingOption> *>(cppOut) =
        ::QFlags<QUrl::ComponentFormattingOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QUrl_ComponentFormattingOption__PythonToCpp_QFlags_QUrl_ComponentFormattingOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX]))
        return QFlags_QUrl_ComponentFormattingOption__PythonToCpp_QFlags_QUrl_ComponentFormattingOption_;
    return {};
}
static PyObject *QFlags_QUrl_ComponentFormattingOption__CppToPython_QFlags_QUrl_ComponentFormattingOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QUrl::ComponentFormattingOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX]));

}

static void QUrl_ComponentFormattingOption_PythonToCpp_QFlags_QUrl_ComponentFormattingOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QUrl::ComponentFormattingOption> *>(cppOut) =
        ::QFlags<QUrl::ComponentFormattingOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QUrl_ComponentFormattingOption_PythonToCpp_QFlags_QUrl_ComponentFormattingOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX]))
        return QUrl_ComponentFormattingOption_PythonToCpp_QFlags_QUrl_ComponentFormattingOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QUrl_ComponentFormattingOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QUrl::ComponentFormattingOption> *>(cppOut) =
        ::QFlags<QUrl::ComponentFormattingOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QUrl_ComponentFormattingOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX]))
        return number_PythonToCpp_QFlags_QUrl_ComponentFormattingOption_;
    return {};
}
static void QUrl_UserInputResolutionOption_PythonToCpp_QUrl_UserInputResolutionOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUrl::UserInputResolutionOption *>(cppOut) =
        static_cast<::QUrl::UserInputResolutionOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUrl_UserInputResolutionOption_PythonToCpp_QUrl_UserInputResolutionOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX]))
        return QUrl_UserInputResolutionOption_PythonToCpp_QUrl_UserInputResolutionOption;
    return {};
}
static PyObject *QUrl_UserInputResolutionOption_CppToPython_QUrl_UserInputResolutionOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUrl::UserInputResolutionOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX], castCppIn);

}

static void QFlags_QUrl_UserInputResolutionOption__PythonToCpp_QFlags_QUrl_UserInputResolutionOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QUrl::UserInputResolutionOption> *>(cppOut) =
        ::QFlags<QUrl::UserInputResolutionOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QUrl_UserInputResolutionOption__PythonToCpp_QFlags_QUrl_UserInputResolutionOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX]))
        return QFlags_QUrl_UserInputResolutionOption__PythonToCpp_QFlags_QUrl_UserInputResolutionOption_;
    return {};
}
static PyObject *QFlags_QUrl_UserInputResolutionOption__CppToPython_QFlags_QUrl_UserInputResolutionOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QUrl::UserInputResolutionOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX]));

}

static void QUrl_UserInputResolutionOption_PythonToCpp_QFlags_QUrl_UserInputResolutionOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QUrl::UserInputResolutionOption> *>(cppOut) =
        ::QFlags<QUrl::UserInputResolutionOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QUrl_UserInputResolutionOption_PythonToCpp_QFlags_QUrl_UserInputResolutionOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX]))
        return QUrl_UserInputResolutionOption_PythonToCpp_QFlags_QUrl_UserInputResolutionOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QUrl_UserInputResolutionOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QUrl::UserInputResolutionOption> *>(cppOut) =
        ::QFlags<QUrl::UserInputResolutionOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QUrl_UserInputResolutionOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX]))
        return number_PythonToCpp_QFlags_QUrl_UserInputResolutionOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QUrl_PythonToCpp_QUrl_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QUrl_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QUrl_PythonToCpp_QUrl_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QUrl_TypeF())))
        return QUrl_PythonToCpp_QUrl_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QUrl_PTR_CppToPython_QUrl(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QUrl *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QUrl_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QUrl_COPY_CppToPython_QUrl(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QUrl_TypeF(), new ::QUrl(*reinterpret_cast<const ::QUrl *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QUrl_PythonToCpp_QUrl_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUrl *>(cppOut) = *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QUrl_PythonToCpp_QUrl_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QUrl_TypeF())))
        return QUrl_PythonToCpp_QUrl_COPY;
    return {};
}

// Implicit conversions.
static void constQStringREF_PythonToCpp_QUrl(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QUrl *>(cppOut) = ::QUrl(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QUrl_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QUrl;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QUrl_SignatureStrings[] = {
    "2:PySide2.QtCore.QUrl(self)",
    "1:PySide2.QtCore.QUrl(self,url:QString,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)",
    "0:PySide2.QtCore.QUrl(self,copy:PySide2.QtCore.QUrl)",
    "PySide2.QtCore.QUrl.__reduce__(self)->PyObject",
    "PySide2.QtCore.QUrl.__repr__(self)->PyObject",
    "PySide2.QtCore.QUrl.adjusted(self,options:PySide2.QtCore.QUrl.FormattingOptions)->PySide2.QtCore.QUrl",
    "PySide2.QtCore.QUrl.authority(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrl.clear(self)",
    "PySide2.QtCore.QUrl.errorString(self)->QString",
    "PySide2.QtCore.QUrl.fileName(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtCore.QUrl.fragment(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrl.fromAce(arg__1:PySide2.QtCore.QByteArray)->QString",
    "PySide2.QtCore.QUrl.fromEncoded(url:PySide2.QtCore.QByteArray,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)->PySide2.QtCore.QUrl",
    "PySide2.QtCore.QUrl.fromLocalFile(localfile:QString)->PySide2.QtCore.QUrl",
    "PySide2.QtCore.QUrl.fromPercentEncoding(arg__1:PySide2.QtCore.QByteArray)->QString",
    "PySide2.QtCore.QUrl.fromStringList(uris:QStringList,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)->QList[PySide2.QtCore.QUrl]",
    "1:PySide2.QtCore.QUrl.fromUserInput(userInput:QString)->PySide2.QtCore.QUrl",
    "0:PySide2.QtCore.QUrl.fromUserInput(userInput:QString,workingDirectory:QString,options:PySide2.QtCore.QUrl.UserInputResolutionOptions=QUrl.DefaultResolution)->PySide2.QtCore.QUrl",
    "PySide2.QtCore.QUrl.hasFragment(self)->bool",
    "PySide2.QtCore.QUrl.hasQuery(self)->bool",
    "PySide2.QtCore.QUrl.host(self,arg__1:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtCore.QUrl.idnWhitelist()->QStringList",
    "PySide2.QtCore.QUrl.isEmpty(self)->bool",
    "PySide2.QtCore.QUrl.isLocalFile(self)->bool",
    "PySide2.QtCore.QUrl.isParentOf(self,url:PySide2.QtCore.QUrl)->bool",
    "PySide2.QtCore.QUrl.isRelative(self)->bool",
    "PySide2.QtCore.QUrl.isValid(self)->bool",
    "PySide2.QtCore.QUrl.matches(self,url:PySide2.QtCore.QUrl,options:PySide2.QtCore.QUrl.FormattingOptions)->bool",
    "PySide2.QtCore.QUrl.password(self,arg__1:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtCore.QUrl.path(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtCore.QUrl.port(self,defaultPort:int=-1)->int",
    "PySide2.QtCore.QUrl.query(self,arg__1:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrl.resolved(self,relative:PySide2.QtCore.QUrl)->PySide2.QtCore.QUrl",
    "PySide2.QtCore.QUrl.scheme(self)->QString",
    "PySide2.QtCore.QUrl.setAuthority(self,authority:QString,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)",
    "PySide2.QtCore.QUrl.setFragment(self,fragment:QString,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)",
    "PySide2.QtCore.QUrl.setHost(self,host:QString,mode:PySide2.QtCore.QUrl.ParsingMode=DecodedMode)",
    "PySide2.QtCore.QUrl.setIdnWhitelist(arg__1:QStringList)",
    "PySide2.QtCore.QUrl.setPassword(self,password:QString,mode:PySide2.QtCore.QUrl.ParsingMode=DecodedMode)",
    "PySide2.QtCore.QUrl.setPath(self,path:QString,mode:PySide2.QtCore.QUrl.ParsingMode=DecodedMode)",
    "PySide2.QtCore.QUrl.setPort(self,port:int)",
    "1:PySide2.QtCore.QUrl.setQuery(self,query:QString,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)",
    "0:PySide2.QtCore.QUrl.setQuery(self,query:PySide2.QtCore.QUrlQuery)",
    "PySide2.QtCore.QUrl.setScheme(self,scheme:QString)",
    "PySide2.QtCore.QUrl.setUrl(self,url:QString,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)",
    "PySide2.QtCore.QUrl.setUserInfo(self,userInfo:QString,mode:PySide2.QtCore.QUrl.ParsingMode=TolerantMode)",
    "PySide2.QtCore.QUrl.setUserName(self,userName:QString,mode:PySide2.QtCore.QUrl.ParsingMode=DecodedMode)",
    "PySide2.QtCore.QUrl.swap(self,other:PySide2.QtCore.QUrl)",
    "PySide2.QtCore.QUrl.toAce(arg__1:QString)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QUrl.toDisplayString(self,options:PySide2.QtCore.QUrl.FormattingOptions=QUrl.FormattingOptions(PrettyDecoded))->QString",
    "PySide2.QtCore.QUrl.toEncoded(self,options:PySide2.QtCore.QUrl.FormattingOptions=QUrl.FullyEncoded)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QUrl.toLocalFile(self)->QString",
    "PySide2.QtCore.QUrl.toPercentEncoding(arg__1:QString,exclude:PySide2.QtCore.QByteArray=QByteArray(),include:PySide2.QtCore.QByteArray=QByteArray())->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QUrl.toString(self,options:PySide2.QtCore.QUrl.FormattingOptions=QUrl.FormattingOptions(PrettyDecoded))->QString",
    "PySide2.QtCore.QUrl.toStringList(uris:QList[PySide2.QtCore.QUrl],options:PySide2.QtCore.QUrl.FormattingOptions=QUrl.FormattingOptions(PrettyDecoded))->QStringList",
    "PySide2.QtCore.QUrl.topLevelDomain(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtCore.QUrl.url(self,options:PySide2.QtCore.QUrl.FormattingOptions=QUrl.FormattingOptions(PrettyDecoded))->QString",
    "PySide2.QtCore.QUrl.userInfo(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrl.userName(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtCore.QUrl.__copy__()",
    nullptr}; // Sentinel

void init_QUrl(PyObject *module)
{
    _Sbk_QUrl_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QUrl",
        "QUrl",
        &Sbk_QUrl_spec,
        &Shiboken::callCppDestructor< ::QUrl >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QUrl_Type);
    InitSignatureStrings(pyType, QUrl_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QUrl_Type), Sbk_QUrl_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QURL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QUrl_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QUrl_TypeF(),
        QUrl_PythonToCpp_QUrl_PTR,
        is_QUrl_PythonToCpp_QUrl_PTR_Convertible,
        QUrl_PTR_CppToPython_QUrl,
        QUrl_COPY_CppToPython_QUrl);

    Shiboken::Conversions::registerConverterName(converter, "QUrl");
    Shiboken::Conversions::registerConverterName(converter, "QUrl*");
    Shiboken::Conversions::registerConverterName(converter, "QUrl&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QUrl).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QUrl_PythonToCpp_QUrl_COPY,
        is_QUrl_PythonToCpp_QUrl_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QUrl,
        is_constQStringREF_PythonToCpp_QUrl_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ParsingMode'.
    SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUrl_TypeF(),
        "ParsingMode",
        "2:PySide2.QtCore.QUrl.ParsingMode",
        "QUrl::ParsingMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX],
        Sbk_QUrl_TypeF(), "TolerantMode", (long) QUrl::ParsingMode::TolerantMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX],
        Sbk_QUrl_TypeF(), "StrictMode", (long) QUrl::ParsingMode::StrictMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX],
        Sbk_QUrl_TypeF(), "DecodedMode", (long) QUrl::ParsingMode::DecodedMode))
        return;
    // Register converter for enum 'QUrl::ParsingMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX],
            QUrl_ParsingMode_CppToPython_QUrl_ParsingMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUrl_ParsingMode_PythonToCpp_QUrl_ParsingMode,
            is_QUrl_ParsingMode_PythonToCpp_QUrl_ParsingMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUrl::ParsingMode");
        Shiboken::Conversions::registerConverterName(converter, "ParsingMode");
    }
    // End of 'ParsingMode' enum.

    // Initialization of enum 'UrlFormattingOption'.
    SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUrl_TypeF(),
        "UrlFormattingOption",
        "2:PySide2.QtCore.QUrl.UrlFormattingOption",
        "QUrl::UrlFormattingOption");
    if (!SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "None_", (long) QUrl::UrlFormattingOption::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemoveScheme", (long) QUrl::UrlFormattingOption::RemoveScheme))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemovePassword", (long) QUrl::UrlFormattingOption::RemovePassword))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemoveUserInfo", (long) QUrl::UrlFormattingOption::RemoveUserInfo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemovePort", (long) QUrl::UrlFormattingOption::RemovePort))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemoveAuthority", (long) QUrl::UrlFormattingOption::RemoveAuthority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemovePath", (long) QUrl::UrlFormattingOption::RemovePath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemoveQuery", (long) QUrl::UrlFormattingOption::RemoveQuery))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemoveFragment", (long) QUrl::UrlFormattingOption::RemoveFragment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "PreferLocalFile", (long) QUrl::UrlFormattingOption::PreferLocalFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "StripTrailingSlash", (long) QUrl::UrlFormattingOption::StripTrailingSlash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "RemoveFilename", (long) QUrl::UrlFormattingOption::RemoveFilename))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "NormalizePathSegments", (long) QUrl::UrlFormattingOption::NormalizePathSegments))
        return;
    // Register converter for enum 'QUrl::UrlFormattingOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX],
            QUrl_UrlFormattingOption_CppToPython_QUrl_UrlFormattingOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUrl_UrlFormattingOption_PythonToCpp_QUrl_UrlFormattingOption,
            is_QUrl_UrlFormattingOption_PythonToCpp_QUrl_UrlFormattingOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QURL_URLFORMATTINGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUrl::UrlFormattingOption");
        Shiboken::Conversions::registerConverterName(converter, "UrlFormattingOption");
    }
    // End of 'UrlFormattingOption' enum.

    // Initialization of enum 'ComponentFormattingOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QUrl.FormattingOptions", SbkPySide2_QtCore_QUrl_ComponentFormattingOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUrl_TypeF(),
        "ComponentFormattingOption",
        "2:PySide2.QtCore.QUrl.ComponentFormattingOption",
        "QUrl::ComponentFormattingOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "PrettyDecoded", (long) QUrl::ComponentFormattingOption::PrettyDecoded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "EncodeSpaces", (long) QUrl::ComponentFormattingOption::EncodeSpaces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "EncodeUnicode", (long) QUrl::ComponentFormattingOption::EncodeUnicode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "EncodeDelimiters", (long) QUrl::ComponentFormattingOption::EncodeDelimiters))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "EncodeReserved", (long) QUrl::ComponentFormattingOption::EncodeReserved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "DecodeReserved", (long) QUrl::ComponentFormattingOption::DecodeReserved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "FullyEncoded", (long) QUrl::ComponentFormattingOption::FullyEncoded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
        Sbk_QUrl_TypeF(), "FullyDecoded", (long) QUrl::ComponentFormattingOption::FullyDecoded))
        return;
    // Register converter for enum 'QUrl::ComponentFormattingOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX],
            QUrl_ComponentFormattingOption_CppToPython_QUrl_ComponentFormattingOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUrl_ComponentFormattingOption_PythonToCpp_QUrl_ComponentFormattingOption,
            is_QUrl_ComponentFormattingOption_PythonToCpp_QUrl_ComponentFormattingOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QURL_COMPONENTFORMATTINGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUrl::ComponentFormattingOption");
        Shiboken::Conversions::registerConverterName(converter, "ComponentFormattingOption");
    }
    // Register converter for flag 'QFlags<QUrl::ComponentFormattingOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX],
            QFlags_QUrl_ComponentFormattingOption__CppToPython_QFlags_QUrl_ComponentFormattingOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUrl_ComponentFormattingOption_PythonToCpp_QFlags_QUrl_ComponentFormattingOption_,
            is_QUrl_ComponentFormattingOption_PythonToCpp_QFlags_QUrl_ComponentFormattingOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QUrl_ComponentFormattingOption__PythonToCpp_QFlags_QUrl_ComponentFormattingOption_,
            is_QFlags_QUrl_ComponentFormattingOption__PythonToCpp_QFlags_QUrl_ComponentFormattingOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QUrl_ComponentFormattingOption_,
            is_number_PythonToCpp_QFlags_QUrl_ComponentFormattingOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUrl::FormattingOptions");
        Shiboken::Conversions::registerConverterName(converter, "FormattingOptions");
    }
    // End of 'ComponentFormattingOption' enum/flags.

    // Initialization of enum 'UserInputResolutionOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QUrl.UserInputResolutionOptions", SbkPySide2_QtCore_QUrl_UserInputResolutionOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUrl_TypeF(),
        "UserInputResolutionOption",
        "2:PySide2.QtCore.QUrl.UserInputResolutionOption",
        "QUrl::UserInputResolutionOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX],
        Sbk_QUrl_TypeF(), "DefaultResolution", (long) QUrl::UserInputResolutionOption::DefaultResolution))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX],
        Sbk_QUrl_TypeF(), "AssumeLocalFile", (long) QUrl::UserInputResolutionOption::AssumeLocalFile))
        return;
    // Register converter for enum 'QUrl::UserInputResolutionOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX],
            QUrl_UserInputResolutionOption_CppToPython_QUrl_UserInputResolutionOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUrl_UserInputResolutionOption_PythonToCpp_QUrl_UserInputResolutionOption,
            is_QUrl_UserInputResolutionOption_PythonToCpp_QUrl_UserInputResolutionOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QURL_USERINPUTRESOLUTIONOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUrl::UserInputResolutionOption");
        Shiboken::Conversions::registerConverterName(converter, "UserInputResolutionOption");
    }
    // Register converter for flag 'QFlags<QUrl::UserInputResolutionOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX],
            QFlags_QUrl_UserInputResolutionOption__CppToPython_QFlags_QUrl_UserInputResolutionOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUrl_UserInputResolutionOption_PythonToCpp_QFlags_QUrl_UserInputResolutionOption_,
            is_QUrl_UserInputResolutionOption_PythonToCpp_QFlags_QUrl_UserInputResolutionOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QUrl_UserInputResolutionOption__PythonToCpp_QFlags_QUrl_UserInputResolutionOption_,
            is_QFlags_QUrl_UserInputResolutionOption__PythonToCpp_QFlags_QUrl_UserInputResolutionOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QUrl_UserInputResolutionOption_,
            is_number_PythonToCpp_QFlags_QUrl_UserInputResolutionOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_USERINPUTRESOLUTIONOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUrl::UserInputResolutionOptions");
        Shiboken::Conversions::registerConverterName(converter, "UserInputResolutionOptions");
    }
    // End of 'UserInputResolutionOption' enum/flags.

    qRegisterMetaType< ::QUrl >("QUrl");
    qRegisterMetaType< ::QUrl::ParsingMode >("QUrl::ParsingMode");
    qRegisterMetaType< ::QUrl::UrlFormattingOption >("QUrl::UrlFormattingOption");
    qRegisterMetaType< ::QUrl::ComponentFormattingOption >("QUrl::ComponentFormattingOption");
    qRegisterMetaType< ::QUrl::FormattingOptions >("QUrl::FormattingOptions");
    qRegisterMetaType< ::QUrl::UserInputResolutionOption >("QUrl::UserInputResolutionOption");
    qRegisterMetaType< ::QUrl::UserInputResolutionOptions >("QUrl::UserInputResolutionOptions");
}
