/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qxmlstreamattribute_wrapper.h"

// inner classes

// Extra includes
#include <qxmlstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlStreamAttribute_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlStreamAttribute >()))
        return -1;

    ::QXmlStreamAttribute *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlStreamAttribute", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlStreamAttribute::QXmlStreamAttribute()
    // 1: QXmlStreamAttribute::QXmlStreamAttribute(QString,QString,QString)
    // 2: QXmlStreamAttribute::QXmlStreamAttribute(QString,QString)
    // 3: QXmlStreamAttribute::QXmlStreamAttribute(QXmlStreamAttribute)
    if (numArgs == 0) {
        overloadId = 0; // QXmlStreamAttribute()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QXmlStreamAttribute(QXmlStreamAttribute)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QXmlStreamAttribute(QString,QString)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 1; // QXmlStreamAttribute(QString,QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttribute_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlStreamAttribute()
        {

            if (!PyErr_Occurred()) {
                // QXmlStreamAttribute()
                cptr = new ::QXmlStreamAttribute();
            }
            break;
        }
        case 1: // QXmlStreamAttribute(const QString & namespaceUri, const QString & name, const QString & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QXmlStreamAttribute(QString,QString,QString)
                cptr = new ::QXmlStreamAttribute(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QXmlStreamAttribute(const QString & qualifiedName, const QString & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QXmlStreamAttribute(QString,QString)
                cptr = new ::QXmlStreamAttribute(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QXmlStreamAttribute(const QXmlStreamAttribute & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlStreamAttribute cppArg0_local;
            ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlStreamAttribute(QXmlStreamAttribute)
                cptr = new ::QXmlStreamAttribute(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlStreamAttribute >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlStreamAttribute_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlStreamAttribute_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlStreamAttributeFunc_isDefault(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.isDefault";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDefault()const
            bool cppResult = const_cast<const ::QXmlStreamAttribute *>(cppSelf)->isDefault();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributeFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QStringRef cppResult = const_cast<const ::QXmlStreamAttribute *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributeFunc_namespaceUri(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.namespaceUri";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceUri()const
            QStringRef cppResult = const_cast<const ::QXmlStreamAttribute *>(cppSelf)->namespaceUri();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributeFunc_prefix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.prefix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prefix()const
            QStringRef cppResult = const_cast<const ::QXmlStreamAttribute *>(cppSelf)->prefix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributeFunc_qualifiedName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.qualifiedName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qualifiedName()const
            QStringRef cppResult = const_cast<const ::QXmlStreamAttribute *>(cppSelf)->qualifiedName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributeFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttribute.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            QStringRef cppResult = const_cast<const ::QXmlStreamAttribute *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttribute___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlStreamAttribute_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlStreamAttribute_methods[] = {
    {"isDefault", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributeFunc_isDefault), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributeFunc_name), METH_NOARGS},
    {"namespaceUri", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributeFunc_namespaceUri), METH_NOARGS},
    {"prefix", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributeFunc_prefix), METH_NOARGS},
    {"qualifiedName", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributeFunc_qualifiedName), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributeFunc_value), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttribute___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QXmlStreamAttribute_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
                // operator!=(const QXmlStreamAttribute & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlStreamAttribute cppArg0_local;
                ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
                // operator==(const QXmlStreamAttribute & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlStreamAttribute cppArg0_local;
                ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QXmlStreamAttribute_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QXmlStreamAttribute_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QXmlStreamAttribute_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlStreamAttribute_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlStreamAttribute_Type = nullptr;
static SbkObjectType *Sbk_QXmlStreamAttribute_TypeF(void)
{
    return _Sbk_QXmlStreamAttribute_Type;
}

static PyType_Slot Sbk_QXmlStreamAttribute_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlStreamAttribute_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlStreamAttribute_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QXmlStreamAttribute_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlStreamAttribute_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlStreamAttribute_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlStreamAttribute_spec = {
    "2:PySide2.QtCore.QXmlStreamAttribute",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlStreamAttribute_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlStreamAttribute_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamAttribute_TypeF())))
        return QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlStreamAttribute_PTR_CppToPython_QXmlStreamAttribute(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlStreamAttribute *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlStreamAttribute_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlStreamAttribute_COPY_CppToPython_QXmlStreamAttribute(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlStreamAttribute_TypeF(), new ::QXmlStreamAttribute(*reinterpret_cast<const ::QXmlStreamAttribute *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlStreamAttribute *>(cppOut) = *reinterpret_cast< ::QXmlStreamAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamAttribute_TypeF())))
        return QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlStreamAttribute_SignatureStrings[] = {
    "3:PySide2.QtCore.QXmlStreamAttribute(self)",
    "2:PySide2.QtCore.QXmlStreamAttribute(self,namespaceUri:QString,name:QString,value:QString)",
    "1:PySide2.QtCore.QXmlStreamAttribute(self,qualifiedName:QString,value:QString)",
    "0:PySide2.QtCore.QXmlStreamAttribute(self,arg__1:PySide2.QtCore.QXmlStreamAttribute)",
    "PySide2.QtCore.QXmlStreamAttribute.isDefault(self)->bool",
    "PySide2.QtCore.QXmlStreamAttribute.name(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamAttribute.namespaceUri(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamAttribute.prefix(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamAttribute.qualifiedName(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamAttribute.value(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamAttribute.__copy__()",
    nullptr}; // Sentinel

void init_QXmlStreamAttribute(PyObject *module)
{
    _Sbk_QXmlStreamAttribute_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlStreamAttribute",
        "QXmlStreamAttribute",
        &Sbk_QXmlStreamAttribute_spec,
        &Shiboken::callCppDestructor< ::QXmlStreamAttribute >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamAttribute_Type);
    InitSignatureStrings(pyType, QXmlStreamAttribute_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamAttribute_Type), Sbk_QXmlStreamAttribute_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamAttribute_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlStreamAttribute_TypeF(),
        QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_PTR,
        is_QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_PTR_Convertible,
        QXmlStreamAttribute_PTR_CppToPython_QXmlStreamAttribute,
        QXmlStreamAttribute_COPY_CppToPython_QXmlStreamAttribute);

    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamAttribute");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamAttribute*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamAttribute&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlStreamAttribute).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_COPY,
        is_QXmlStreamAttribute_PythonToCpp_QXmlStreamAttribute_COPY_Convertible);

    qRegisterMetaType< ::QXmlStreamAttribute >("QXmlStreamAttribute");
}
