/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qxmlstreamentitydeclaration_wrapper.h"

// inner classes

// Extra includes
#include <qxmlstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlStreamEntityDeclaration_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlStreamEntityDeclaration >()))
        return -1;

    ::QXmlStreamEntityDeclaration *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamEntityDeclaration.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlStreamEntityDeclaration", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlStreamEntityDeclaration::QXmlStreamEntityDeclaration()
    // 1: QXmlStreamEntityDeclaration::QXmlStreamEntityDeclaration(QXmlStreamEntityDeclaration)
    if (numArgs == 0) {
        overloadId = 0; // QXmlStreamEntityDeclaration()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QXmlStreamEntityDeclaration(QXmlStreamEntityDeclaration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamEntityDeclaration_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlStreamEntityDeclaration()
        {

            if (!PyErr_Occurred()) {
                // QXmlStreamEntityDeclaration()
                cptr = new ::QXmlStreamEntityDeclaration();
            }
            break;
        }
        case 1: // QXmlStreamEntityDeclaration(const QXmlStreamEntityDeclaration & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlStreamEntityDeclaration cppArg0_local;
            ::QXmlStreamEntityDeclaration *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlStreamEntityDeclaration(QXmlStreamEntityDeclaration)
                cptr = new ::QXmlStreamEntityDeclaration(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlStreamEntityDeclaration >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlStreamEntityDeclaration_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlStreamEntityDeclaration_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlStreamEntityDeclarationFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamEntityDeclaration.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QStringRef cppResult = const_cast<const ::QXmlStreamEntityDeclaration *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamEntityDeclarationFunc_notationName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamEntityDeclaration.notationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notationName()const
            QStringRef cppResult = const_cast<const ::QXmlStreamEntityDeclaration *>(cppSelf)->notationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamEntityDeclarationFunc_publicId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamEntityDeclaration.publicId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // publicId()const
            QStringRef cppResult = const_cast<const ::QXmlStreamEntityDeclaration *>(cppSelf)->publicId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamEntityDeclarationFunc_systemId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamEntityDeclaration.systemId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemId()const
            QStringRef cppResult = const_cast<const ::QXmlStreamEntityDeclaration *>(cppSelf)->systemId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamEntityDeclarationFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamEntityDeclaration.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            QStringRef cppResult = const_cast<const ::QXmlStreamEntityDeclaration *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamEntityDeclaration___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlStreamEntityDeclaration_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlStreamEntityDeclaration_methods[] = {
    {"name", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamEntityDeclarationFunc_name), METH_NOARGS},
    {"notationName", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamEntityDeclarationFunc_notationName), METH_NOARGS},
    {"publicId", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamEntityDeclarationFunc_publicId), METH_NOARGS},
    {"systemId", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamEntityDeclarationFunc_systemId), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamEntityDeclarationFunc_value), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamEntityDeclaration___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QXmlStreamEntityDeclaration_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), (pyArg)))) {
                // operator!=(const QXmlStreamEntityDeclaration & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlStreamEntityDeclaration cppArg0_local;
                ::QXmlStreamEntityDeclaration *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), (pyArg)))) {
                // operator==(const QXmlStreamEntityDeclaration & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlStreamEntityDeclaration cppArg0_local;
                ::QXmlStreamEntityDeclaration *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QXmlStreamEntityDeclaration_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QXmlStreamEntityDeclaration_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QXmlStreamEntityDeclaration_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlStreamEntityDeclaration_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlStreamEntityDeclaration_Type = nullptr;
static SbkObjectType *Sbk_QXmlStreamEntityDeclaration_TypeF(void)
{
    return _Sbk_QXmlStreamEntityDeclaration_Type;
}

static PyType_Slot Sbk_QXmlStreamEntityDeclaration_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlStreamEntityDeclaration_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlStreamEntityDeclaration_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QXmlStreamEntityDeclaration_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlStreamEntityDeclaration_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlStreamEntityDeclaration_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlStreamEntityDeclaration_spec = {
    "2:PySide2.QtCore.QXmlStreamEntityDeclaration",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlStreamEntityDeclaration_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlStreamEntityDeclaration_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamEntityDeclaration_TypeF())))
        return QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlStreamEntityDeclaration_PTR_CppToPython_QXmlStreamEntityDeclaration(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlStreamEntityDeclaration *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlStreamEntityDeclaration_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlStreamEntityDeclaration_COPY_CppToPython_QXmlStreamEntityDeclaration(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlStreamEntityDeclaration_TypeF(), new ::QXmlStreamEntityDeclaration(*reinterpret_cast<const ::QXmlStreamEntityDeclaration *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlStreamEntityDeclaration *>(cppOut) = *reinterpret_cast< ::QXmlStreamEntityDeclaration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamEntityDeclaration_TypeF())))
        return QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlStreamEntityDeclaration_SignatureStrings[] = {
    "1:PySide2.QtCore.QXmlStreamEntityDeclaration(self)",
    "0:PySide2.QtCore.QXmlStreamEntityDeclaration(self,arg__1:PySide2.QtCore.QXmlStreamEntityDeclaration)",
    "PySide2.QtCore.QXmlStreamEntityDeclaration.name(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamEntityDeclaration.notationName(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamEntityDeclaration.publicId(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamEntityDeclaration.systemId(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamEntityDeclaration.value(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamEntityDeclaration.__copy__()",
    nullptr}; // Sentinel

void init_QXmlStreamEntityDeclaration(PyObject *module)
{
    _Sbk_QXmlStreamEntityDeclaration_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlStreamEntityDeclaration",
        "QXmlStreamEntityDeclaration",
        &Sbk_QXmlStreamEntityDeclaration_spec,
        &Shiboken::callCppDestructor< ::QXmlStreamEntityDeclaration >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamEntityDeclaration_Type);
    InitSignatureStrings(pyType, QXmlStreamEntityDeclaration_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamEntityDeclaration_Type), Sbk_QXmlStreamEntityDeclaration_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamEntityDeclaration_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlStreamEntityDeclaration_TypeF(),
        QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_PTR,
        is_QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_PTR_Convertible,
        QXmlStreamEntityDeclaration_PTR_CppToPython_QXmlStreamEntityDeclaration,
        QXmlStreamEntityDeclaration_COPY_CppToPython_QXmlStreamEntityDeclaration);

    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamEntityDeclaration");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamEntityDeclaration*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamEntityDeclaration&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlStreamEntityDeclaration).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_COPY,
        is_QXmlStreamEntityDeclaration_PythonToCpp_QXmlStreamEntityDeclaration_COPY_Convertible);

    qRegisterMetaType< ::QXmlStreamEntityDeclaration >("QXmlStreamEntityDeclaration");
}
