/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessible_wrapper.h"

// inner classes
#include "qaccessible_state_wrapper.h"

// Extra includes
#include <QPair>
#include <QtGui/qaccessible.h>
#include <QtGui/qtextcursor.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QAccessibleFunc_accessibleInterface(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.accessibleInterface";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::accessibleInterface(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // accessibleInterface(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_accessibleInterface_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // accessibleInterface(uint)
            QAccessibleInterface * cppResult = ::QAccessible::accessibleInterface(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAccessibleFunc_accessibleInterface_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_cleanup(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.cleanup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cleanup()
            ::QAccessible::cleanup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAccessibleFunc_deleteAccessibleInterface(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.deleteAccessibleInterface";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::deleteAccessibleInterface(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // deleteAccessibleInterface(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_deleteAccessibleInterface_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // deleteAccessibleInterface(uint)
            ::QAccessible::deleteAccessibleInterface(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleFunc_deleteAccessibleInterface_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_isActive(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()
            bool cppResult = ::QAccessible::isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleFunc_qAccessibleTextBoundaryHelper(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.qAccessibleTextBoundaryHelper";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qAccessibleTextBoundaryHelper", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QAccessible::qAccessibleTextBoundaryHelper(QTextCursor,QAccessible::TextBoundaryType)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // qAccessibleTextBoundaryHelper(QTextCursor,QAccessible::TextBoundaryType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_qAccessibleTextBoundaryHelper_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTextCursor cppArg0_local;
        ::QTextCursor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QAccessible::TextBoundaryType cppArg1{QAccessible::CharBoundary};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qAccessibleTextBoundaryHelper(QTextCursor,QAccessible::TextBoundaryType)
            QPair<int,int > cppResult = ::QAccessible::qAccessibleTextBoundaryHelper(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAccessibleFunc_qAccessibleTextBoundaryHelper_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_queryAccessibleInterface(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.queryAccessibleInterface";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::queryAccessibleInterface(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // queryAccessibleInterface(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_queryAccessibleInterface_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // queryAccessibleInterface(QObject*)
            QAccessibleInterface * cppResult = ::QAccessible::queryAccessibleInterface(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAccessibleFunc_queryAccessibleInterface_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_registerAccessibleInterface(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.registerAccessibleInterface";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::registerAccessibleInterface(QAccessibleInterface*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), (pyArg)))) {
        overloadId = 0; // registerAccessibleInterface(QAccessibleInterface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_registerAccessibleInterface_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAccessibleInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // registerAccessibleInterface(QAccessibleInterface*)
            unsigned int cppResult = ::QAccessible::registerAccessibleInterface(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAccessibleFunc_registerAccessibleInterface_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_setActive(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.setActive";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_setActive_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActive(bool)
            ::QAccessible::setActive(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleFunc_setActive_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_setRootObject(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.setRootObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::setRootObject(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setRootObject(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_setRootObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRootObject(QObject*)
            ::QAccessible::setRootObject(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleFunc_setRootObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_uniqueId(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.uniqueId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::uniqueId(QAccessibleInterface*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), (pyArg)))) {
        overloadId = 0; // uniqueId(QAccessibleInterface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_uniqueId_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAccessibleInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // uniqueId(QAccessibleInterface*)
            unsigned int cppResult = ::QAccessible::uniqueId(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAccessibleFunc_uniqueId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleFunc_updateAccessibility(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.updateAccessibility";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAccessible::updateAccessibility(QAccessibleEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // updateAccessibility(QAccessibleEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleFunc_updateAccessibility_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAccessibleEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // updateAccessibility(QAccessibleEvent*)
            ::QAccessible::updateAccessibility(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleFunc_updateAccessibility_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessible___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAccessible *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAccessible_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessible_methods[] = {
    {"accessibleInterface", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_accessibleInterface), METH_O|METH_STATIC},
    {"cleanup", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_cleanup), METH_NOARGS|METH_STATIC},
    {"deleteAccessibleInterface", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_deleteAccessibleInterface), METH_O|METH_STATIC},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_isActive), METH_NOARGS|METH_STATIC},
    {"qAccessibleTextBoundaryHelper", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_qAccessibleTextBoundaryHelper), METH_VARARGS|METH_STATIC},
    {"queryAccessibleInterface", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_queryAccessibleInterface), METH_O|METH_STATIC},
    {"registerAccessibleInterface", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_registerAccessibleInterface), METH_O|METH_STATIC},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_setActive), METH_O|METH_STATIC},
    {"setRootObject", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_setRootObject), METH_O|METH_STATIC},
    {"uniqueId", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_uniqueId), METH_O|METH_STATIC},
    {"updateAccessibility", reinterpret_cast<PyCFunction>(Sbk_QAccessibleFunc_updateAccessibility), METH_O|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAccessible___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAccessible_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessible_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessible_Type = nullptr;
static SbkObjectType *Sbk_QAccessible_TypeF(void)
{
    return _Sbk_QAccessible_Type;
}

static PyType_Slot Sbk_QAccessible_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessible_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessible_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessible_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessible_spec = {
    "2:PySide2.QtGui.QAccessible",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessible_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QAccessible_RelationFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QAccessible::Relation cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAccessible::Relation>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAccessible::Relation>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAccessible::Relation>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAccessible::Relation>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QAccessible_RelationFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QAccessible::Relation cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAccessible::Relation>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAccessible::Relation>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAccessible::Relation>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAccessible::Relation>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QAccessible_RelationFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QAccessible::Relation cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAccessible::Relation>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAccessible::Relation>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAccessible::Relation>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAccessible::Relation>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QAccessible_RelationFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QAccessible::Relation cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, self, &cppSelf);
    ::QAccessible::Relation cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QAccessible_RelationFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QAccessible_RelationFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QAccessible_RelationFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QAccessible_RelationFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QAccessible_Event_PythonToCpp_QAccessible_Event(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::Event *>(cppOut) =
        static_cast<::QAccessible::Event>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessible_Event_PythonToCpp_QAccessible_Event_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX]))
        return QAccessible_Event_PythonToCpp_QAccessible_Event;
    return {};
}
static PyObject *QAccessible_Event_CppToPython_QAccessible_Event(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessible::Event *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX], castCppIn);

}

static void QAccessible_Role_PythonToCpp_QAccessible_Role(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::Role *>(cppOut) =
        static_cast<::QAccessible::Role>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessible_Role_PythonToCpp_QAccessible_Role_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX]))
        return QAccessible_Role_PythonToCpp_QAccessible_Role;
    return {};
}
static PyObject *QAccessible_Role_CppToPython_QAccessible_Role(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessible::Role *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX], castCppIn);

}

static void QAccessible_Text_PythonToCpp_QAccessible_Text(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::Text *>(cppOut) =
        static_cast<::QAccessible::Text>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessible_Text_PythonToCpp_QAccessible_Text_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX]))
        return QAccessible_Text_PythonToCpp_QAccessible_Text;
    return {};
}
static PyObject *QAccessible_Text_CppToPython_QAccessible_Text(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessible::Text *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX], castCppIn);

}

static void QAccessible_RelationFlag_PythonToCpp_QAccessible_RelationFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::RelationFlag *>(cppOut) =
        static_cast<::QAccessible::RelationFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessible_RelationFlag_PythonToCpp_QAccessible_RelationFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX]))
        return QAccessible_RelationFlag_PythonToCpp_QAccessible_RelationFlag;
    return {};
}
static PyObject *QAccessible_RelationFlag_CppToPython_QAccessible_RelationFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessible::RelationFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX], castCppIn);

}

static void QFlags_QAccessible_RelationFlag__PythonToCpp_QFlags_QAccessible_RelationFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAccessible::RelationFlag> *>(cppOut) =
        ::QFlags<QAccessible::RelationFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QAccessible_RelationFlag__PythonToCpp_QFlags_QAccessible_RelationFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX]))
        return QFlags_QAccessible_RelationFlag__PythonToCpp_QFlags_QAccessible_RelationFlag_;
    return {};
}
static PyObject *QFlags_QAccessible_RelationFlag__CppToPython_QFlags_QAccessible_RelationFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QAccessible::RelationFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX]));

}

static void QAccessible_RelationFlag_PythonToCpp_QFlags_QAccessible_RelationFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAccessible::RelationFlag> *>(cppOut) =
        ::QFlags<QAccessible::RelationFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QAccessible_RelationFlag_PythonToCpp_QFlags_QAccessible_RelationFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX]))
        return QAccessible_RelationFlag_PythonToCpp_QFlags_QAccessible_RelationFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QAccessible_RelationFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QAccessible::RelationFlag> *>(cppOut) =
        ::QFlags<QAccessible::RelationFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QAccessible_RelationFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX]))
        return number_PythonToCpp_QFlags_QAccessible_RelationFlag_;
    return {};
}
static void QAccessible_InterfaceType_PythonToCpp_QAccessible_InterfaceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::InterfaceType *>(cppOut) =
        static_cast<::QAccessible::InterfaceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessible_InterfaceType_PythonToCpp_QAccessible_InterfaceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX]))
        return QAccessible_InterfaceType_PythonToCpp_QAccessible_InterfaceType;
    return {};
}
static PyObject *QAccessible_InterfaceType_CppToPython_QAccessible_InterfaceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessible::InterfaceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX], castCppIn);

}

static void QAccessible_TextBoundaryType_PythonToCpp_QAccessible_TextBoundaryType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::TextBoundaryType *>(cppOut) =
        static_cast<::QAccessible::TextBoundaryType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessible_TextBoundaryType_PythonToCpp_QAccessible_TextBoundaryType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX]))
        return QAccessible_TextBoundaryType_PythonToCpp_QAccessible_TextBoundaryType;
    return {};
}
static PyObject *QAccessible_TextBoundaryType_CppToPython_QAccessible_TextBoundaryType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessible::TextBoundaryType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAccessible_PythonToCpp_QAccessible_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessible_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAccessible_PythonToCpp_QAccessible_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessible_TypeF())))
        return QAccessible_PythonToCpp_QAccessible_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAccessible_PTR_CppToPython_QAccessible(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessible *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessible_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QAccessible_COPY_CppToPython_QAccessible(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAccessible_TypeF(), new ::QAccessible(*reinterpret_cast<const ::QAccessible *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QAccessible_PythonToCpp_QAccessible_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible *>(cppOut) = *reinterpret_cast< ::QAccessible *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QAccessible_PythonToCpp_QAccessible_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessible_TypeF())))
        return QAccessible_PythonToCpp_QAccessible_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessible_SignatureStrings[] = {
    "PySide2.QtGui.QAccessible.accessibleInterface(uniqueId:unsigned int)->PySide2.QtGui.QAccessibleInterface",
    "PySide2.QtGui.QAccessible.cleanup()",
    "PySide2.QtGui.QAccessible.deleteAccessibleInterface(uniqueId:unsigned int)",
    "PySide2.QtGui.QAccessible.isActive()->bool",
    "PySide2.QtGui.QAccessible.qAccessibleTextBoundaryHelper(cursor:PySide2.QtGui.QTextCursor,boundaryType:PySide2.QtGui.QAccessible.TextBoundaryType)->QPair[int, int]",
    "PySide2.QtGui.QAccessible.queryAccessibleInterface(arg__1:PySide2.QtCore.QObject)->PySide2.QtGui.QAccessibleInterface",
    "PySide2.QtGui.QAccessible.registerAccessibleInterface(iface:PySide2.QtGui.QAccessibleInterface)->unsigned int",
    "PySide2.QtGui.QAccessible.setActive(active:bool)",
    "PySide2.QtGui.QAccessible.setRootObject(object:PySide2.QtCore.QObject)",
    "PySide2.QtGui.QAccessible.uniqueId(iface:PySide2.QtGui.QAccessibleInterface)->unsigned int",
    "PySide2.QtGui.QAccessible.updateAccessibility(event:PySide2.QtGui.QAccessibleEvent)",
    "PySide2.QtGui.QAccessible.__copy__()",
    nullptr}; // Sentinel

void init_QAccessible(PyObject *module)
{
    _Sbk_QAccessible_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAccessible",
        "QAccessible",
        &Sbk_QAccessible_spec,
        &Shiboken::callCppDestructor< ::QAccessible >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessible_Type);
    InitSignatureStrings(pyType, QAccessible_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessible_Type), Sbk_QAccessible_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessible_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessible_TypeF(),
        QAccessible_PythonToCpp_QAccessible_PTR,
        is_QAccessible_PythonToCpp_QAccessible_PTR_Convertible,
        QAccessible_PTR_CppToPython_QAccessible,
        QAccessible_COPY_CppToPython_QAccessible);

    Shiboken::Conversions::registerConverterName(converter, "QAccessible");
    Shiboken::Conversions::registerConverterName(converter, "QAccessible*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessible&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessible).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QAccessible_PythonToCpp_QAccessible_COPY,
        is_QAccessible_PythonToCpp_QAccessible_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Event'.
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessible_TypeF(),
        "Event",
        "2:PySide2.QtGui.QAccessible.Event",
        "QAccessible::Event");
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "SoundPlayed", (long) QAccessible::Event::SoundPlayed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "Alert", (long) QAccessible::Event::Alert))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ForegroundChanged", (long) QAccessible::Event::ForegroundChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "MenuStart", (long) QAccessible::Event::MenuStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "MenuEnd", (long) QAccessible::Event::MenuEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "PopupMenuStart", (long) QAccessible::Event::PopupMenuStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "PopupMenuEnd", (long) QAccessible::Event::PopupMenuEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ContextHelpStart", (long) QAccessible::Event::ContextHelpStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ContextHelpEnd", (long) QAccessible::Event::ContextHelpEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DragDropStart", (long) QAccessible::Event::DragDropStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DragDropEnd", (long) QAccessible::Event::DragDropEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DialogStart", (long) QAccessible::Event::DialogStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DialogEnd", (long) QAccessible::Event::DialogEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ScrollingStart", (long) QAccessible::Event::ScrollingStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ScrollingEnd", (long) QAccessible::Event::ScrollingEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "MenuCommand", (long) QAccessible::Event::MenuCommand))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ActionChanged", (long) QAccessible::Event::ActionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ActiveDescendantChanged", (long) QAccessible::Event::ActiveDescendantChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "AttributeChanged", (long) QAccessible::Event::AttributeChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DocumentContentChanged", (long) QAccessible::Event::DocumentContentChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DocumentLoadComplete", (long) QAccessible::Event::DocumentLoadComplete))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DocumentLoadStopped", (long) QAccessible::Event::DocumentLoadStopped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DocumentReload", (long) QAccessible::Event::DocumentReload))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HyperlinkEndIndexChanged", (long) QAccessible::Event::HyperlinkEndIndexChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HyperlinkNumberOfAnchorsChanged", (long) QAccessible::Event::HyperlinkNumberOfAnchorsChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HyperlinkSelectedLinkChanged", (long) QAccessible::Event::HyperlinkSelectedLinkChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HypertextLinkActivated", (long) QAccessible::Event::HypertextLinkActivated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HypertextLinkSelected", (long) QAccessible::Event::HypertextLinkSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HyperlinkStartIndexChanged", (long) QAccessible::Event::HyperlinkStartIndexChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HypertextChanged", (long) QAccessible::Event::HypertextChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HypertextNLinksChanged", (long) QAccessible::Event::HypertextNLinksChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ObjectAttributeChanged", (long) QAccessible::Event::ObjectAttributeChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "PageChanged", (long) QAccessible::Event::PageChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "SectionChanged", (long) QAccessible::Event::SectionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableCaptionChanged", (long) QAccessible::Event::TableCaptionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableColumnDescriptionChanged", (long) QAccessible::Event::TableColumnDescriptionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableColumnHeaderChanged", (long) QAccessible::Event::TableColumnHeaderChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableModelChanged", (long) QAccessible::Event::TableModelChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableRowDescriptionChanged", (long) QAccessible::Event::TableRowDescriptionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableRowHeaderChanged", (long) QAccessible::Event::TableRowHeaderChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TableSummaryChanged", (long) QAccessible::Event::TableSummaryChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextAttributeChanged", (long) QAccessible::Event::TextAttributeChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextCaretMoved", (long) QAccessible::Event::TextCaretMoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextColumnChanged", (long) QAccessible::Event::TextColumnChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextInserted", (long) QAccessible::Event::TextInserted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextRemoved", (long) QAccessible::Event::TextRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextUpdated", (long) QAccessible::Event::TextUpdated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "TextSelectionChanged", (long) QAccessible::Event::TextSelectionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "VisibleDataChanged", (long) QAccessible::Event::VisibleDataChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ObjectCreated", (long) QAccessible::Event::ObjectCreated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ObjectDestroyed", (long) QAccessible::Event::ObjectDestroyed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ObjectShow", (long) QAccessible::Event::ObjectShow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ObjectHide", (long) QAccessible::Event::ObjectHide))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ObjectReorder", (long) QAccessible::Event::ObjectReorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "Focus", (long) QAccessible::Event::Focus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "Selection", (long) QAccessible::Event::Selection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "SelectionAdd", (long) QAccessible::Event::SelectionAdd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "SelectionRemove", (long) QAccessible::Event::SelectionRemove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "SelectionWithin", (long) QAccessible::Event::SelectionWithin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "StateChanged", (long) QAccessible::Event::StateChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "LocationChanged", (long) QAccessible::Event::LocationChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "NameChanged", (long) QAccessible::Event::NameChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DescriptionChanged", (long) QAccessible::Event::DescriptionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ValueChanged", (long) QAccessible::Event::ValueChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "ParentChanged", (long) QAccessible::Event::ParentChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "HelpChanged", (long) QAccessible::Event::HelpChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "DefaultActionChanged", (long) QAccessible::Event::DefaultActionChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "AcceleratorChanged", (long) QAccessible::Event::AcceleratorChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
        Sbk_QAccessible_TypeF(), "InvalidEvent", (long) QAccessible::Event::InvalidEvent))
        return;
    // Register converter for enum 'QAccessible::Event'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX],
            QAccessible_Event_CppToPython_QAccessible_Event);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_Event_PythonToCpp_QAccessible_Event,
            is_QAccessible_Event_PythonToCpp_QAccessible_Event_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_EVENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::Event");
        Shiboken::Conversions::registerConverterName(converter, "Event");
    }
    // End of 'Event' enum.

    // Initialization of enum 'Role'.
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessible_TypeF(),
        "Role",
        "2:PySide2.QtGui.QAccessible.Role",
        "QAccessible::Role");
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "NoRole", (long) QAccessible::Role::NoRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "TitleBar", (long) QAccessible::Role::TitleBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "MenuBar", (long) QAccessible::Role::MenuBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ScrollBar", (long) QAccessible::Role::ScrollBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Grip", (long) QAccessible::Role::Grip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Sound", (long) QAccessible::Role::Sound))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Cursor", (long) QAccessible::Role::Cursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Caret", (long) QAccessible::Role::Caret))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "AlertMessage", (long) QAccessible::Role::AlertMessage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Window", (long) QAccessible::Role::Window))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Client", (long) QAccessible::Role::Client))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "PopupMenu", (long) QAccessible::Role::PopupMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "MenuItem", (long) QAccessible::Role::MenuItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ToolTip", (long) QAccessible::Role::ToolTip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Application", (long) QAccessible::Role::Application))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Document", (long) QAccessible::Role::Document))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Pane", (long) QAccessible::Role::Pane))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Chart", (long) QAccessible::Role::Chart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Dialog", (long) QAccessible::Role::Dialog))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Border", (long) QAccessible::Role::Border))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Grouping", (long) QAccessible::Role::Grouping))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Separator", (long) QAccessible::Role::Separator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ToolBar", (long) QAccessible::Role::ToolBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "StatusBar", (long) QAccessible::Role::StatusBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Table", (long) QAccessible::Role::Table))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ColumnHeader", (long) QAccessible::Role::ColumnHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "RowHeader", (long) QAccessible::Role::RowHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Column", (long) QAccessible::Role::Column))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Row", (long) QAccessible::Role::Row))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Cell", (long) QAccessible::Role::Cell))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Link", (long) QAccessible::Role::Link))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "HelpBalloon", (long) QAccessible::Role::HelpBalloon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Assistant", (long) QAccessible::Role::Assistant))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "List", (long) QAccessible::Role::List))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ListItem", (long) QAccessible::Role::ListItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Tree", (long) QAccessible::Role::Tree))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "TreeItem", (long) QAccessible::Role::TreeItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "PageTab", (long) QAccessible::Role::PageTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "PropertyPage", (long) QAccessible::Role::PropertyPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Indicator", (long) QAccessible::Role::Indicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Graphic", (long) QAccessible::Role::Graphic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "StaticText", (long) QAccessible::Role::StaticText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "EditableText", (long) QAccessible::Role::EditableText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Button", (long) QAccessible::Role::Button))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "PushButton", (long) QAccessible::Role::PushButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "CheckBox", (long) QAccessible::Role::CheckBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "RadioButton", (long) QAccessible::Role::RadioButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ComboBox", (long) QAccessible::Role::ComboBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ProgressBar", (long) QAccessible::Role::ProgressBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Dial", (long) QAccessible::Role::Dial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "HotkeyField", (long) QAccessible::Role::HotkeyField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Slider", (long) QAccessible::Role::Slider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "SpinBox", (long) QAccessible::Role::SpinBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Canvas", (long) QAccessible::Role::Canvas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Animation", (long) QAccessible::Role::Animation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Equation", (long) QAccessible::Role::Equation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ButtonDropDown", (long) QAccessible::Role::ButtonDropDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ButtonMenu", (long) QAccessible::Role::ButtonMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ButtonDropGrid", (long) QAccessible::Role::ButtonDropGrid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Whitespace", (long) QAccessible::Role::Whitespace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "PageTabList", (long) QAccessible::Role::PageTabList))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Clock", (long) QAccessible::Role::Clock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Splitter", (long) QAccessible::Role::Splitter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "LayeredPane", (long) QAccessible::Role::LayeredPane))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Terminal", (long) QAccessible::Role::Terminal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Desktop", (long) QAccessible::Role::Desktop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Paragraph", (long) QAccessible::Role::Paragraph))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "WebDocument", (long) QAccessible::Role::WebDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Section", (long) QAccessible::Role::Section))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Notification", (long) QAccessible::Role::Notification))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ColorChooser", (long) QAccessible::Role::ColorChooser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Footer", (long) QAccessible::Role::Footer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Form", (long) QAccessible::Role::Form))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Heading", (long) QAccessible::Role::Heading))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "Note", (long) QAccessible::Role::Note))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "ComplementaryContent", (long) QAccessible::Role::ComplementaryContent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
        Sbk_QAccessible_TypeF(), "UserRole", (long) QAccessible::Role::UserRole))
        return;
    // Register converter for enum 'QAccessible::Role'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX],
            QAccessible_Role_CppToPython_QAccessible_Role);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_Role_PythonToCpp_QAccessible_Role,
            is_QAccessible_Role_PythonToCpp_QAccessible_Role_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_ROLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::Role");
        Shiboken::Conversions::registerConverterName(converter, "Role");
    }
    // End of 'Role' enum.

    // Initialization of enum 'Text'.
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessible_TypeF(),
        "Text",
        "2:PySide2.QtGui.QAccessible.Text",
        "QAccessible::Text");
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "Name", (long) QAccessible::Text::Name))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "Description", (long) QAccessible::Text::Description))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "Value", (long) QAccessible::Text::Value))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "Help", (long) QAccessible::Text::Help))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "Accelerator", (long) QAccessible::Text::Accelerator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "DebugDescription", (long) QAccessible::Text::DebugDescription))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
        Sbk_QAccessible_TypeF(), "UserText", (long) QAccessible::Text::UserText))
        return;
    // Register converter for enum 'QAccessible::Text'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX],
            QAccessible_Text_CppToPython_QAccessible_Text);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_Text_PythonToCpp_QAccessible_Text,
            is_QAccessible_Text_PythonToCpp_QAccessible_Text_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::Text");
        Shiboken::Conversions::registerConverterName(converter, "Text");
    }
    // End of 'Text' enum.

    // Initialization of enum 'RelationFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QAccessible.Relation", SbkPySide2_QtGui_QAccessible_RelationFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessible_TypeF(),
        "RelationFlag",
        "2:PySide2.QtGui.QAccessible.RelationFlag",
        "QAccessible::RelationFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX],
        Sbk_QAccessible_TypeF(), "Label", (long) QAccessible::RelationFlag::Label))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX],
        Sbk_QAccessible_TypeF(), "Labelled", (long) QAccessible::RelationFlag::Labelled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX],
        Sbk_QAccessible_TypeF(), "Controller", (long) QAccessible::RelationFlag::Controller))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX],
        Sbk_QAccessible_TypeF(), "Controlled", (long) QAccessible::RelationFlag::Controlled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX],
        Sbk_QAccessible_TypeF(), "AllRelations", (long) QAccessible::RelationFlag::AllRelations))
        return;
    // Register converter for enum 'QAccessible::RelationFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX],
            QAccessible_RelationFlag_CppToPython_QAccessible_RelationFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_RelationFlag_PythonToCpp_QAccessible_RelationFlag,
            is_QAccessible_RelationFlag_PythonToCpp_QAccessible_RelationFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_RELATIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::RelationFlag");
        Shiboken::Conversions::registerConverterName(converter, "RelationFlag");
    }
    // Register converter for flag 'QFlags<QAccessible::RelationFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX],
            QFlags_QAccessible_RelationFlag__CppToPython_QFlags_QAccessible_RelationFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_RelationFlag_PythonToCpp_QFlags_QAccessible_RelationFlag_,
            is_QAccessible_RelationFlag_PythonToCpp_QFlags_QAccessible_RelationFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QAccessible_RelationFlag__PythonToCpp_QFlags_QAccessible_RelationFlag_,
            is_QFlags_QAccessible_RelationFlag__PythonToCpp_QFlags_QAccessible_RelationFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QAccessible_RelationFlag_,
            is_number_PythonToCpp_QFlags_QAccessible_RelationFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::Relation");
        Shiboken::Conversions::registerConverterName(converter, "Relation");
    }
    // End of 'RelationFlag' enum/flags.

    // Initialization of enum 'InterfaceType'.
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessible_TypeF(),
        "InterfaceType",
        "2:PySide2.QtGui.QAccessible.InterfaceType",
        "QAccessible::InterfaceType");
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "TextInterface", (long) QAccessible::InterfaceType::TextInterface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "EditableTextInterface", (long) QAccessible::InterfaceType::EditableTextInterface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "ValueInterface", (long) QAccessible::InterfaceType::ValueInterface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "ActionInterface", (long) QAccessible::InterfaceType::ActionInterface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "ImageInterface", (long) QAccessible::InterfaceType::ImageInterface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "TableInterface", (long) QAccessible::InterfaceType::TableInterface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
        Sbk_QAccessible_TypeF(), "TableCellInterface", (long) QAccessible::InterfaceType::TableCellInterface))
        return;
    // Register converter for enum 'QAccessible::InterfaceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX],
            QAccessible_InterfaceType_CppToPython_QAccessible_InterfaceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_InterfaceType_PythonToCpp_QAccessible_InterfaceType,
            is_QAccessible_InterfaceType_PythonToCpp_QAccessible_InterfaceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_INTERFACETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::InterfaceType");
        Shiboken::Conversions::registerConverterName(converter, "InterfaceType");
    }
    // End of 'InterfaceType' enum.

    // Initialization of enum 'TextBoundaryType'.
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessible_TypeF(),
        "TextBoundaryType",
        "2:PySide2.QtGui.QAccessible.TextBoundaryType",
        "QAccessible::TextBoundaryType");
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
        Sbk_QAccessible_TypeF(), "CharBoundary", (long) QAccessible::TextBoundaryType::CharBoundary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
        Sbk_QAccessible_TypeF(), "WordBoundary", (long) QAccessible::TextBoundaryType::WordBoundary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
        Sbk_QAccessible_TypeF(), "SentenceBoundary", (long) QAccessible::TextBoundaryType::SentenceBoundary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
        Sbk_QAccessible_TypeF(), "ParagraphBoundary", (long) QAccessible::TextBoundaryType::ParagraphBoundary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
        Sbk_QAccessible_TypeF(), "LineBoundary", (long) QAccessible::TextBoundaryType::LineBoundary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
        Sbk_QAccessible_TypeF(), "NoBoundary", (long) QAccessible::TextBoundaryType::NoBoundary))
        return;
    // Register converter for enum 'QAccessible::TextBoundaryType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX],
            QAccessible_TextBoundaryType_CppToPython_QAccessible_TextBoundaryType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessible_TextBoundaryType_PythonToCpp_QAccessible_TextBoundaryType,
            is_QAccessible_TextBoundaryType_PythonToCpp_QAccessible_TextBoundaryType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_TEXTBOUNDARYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessible::TextBoundaryType");
        Shiboken::Conversions::registerConverterName(converter, "TextBoundaryType");
    }
    // End of 'TextBoundaryType' enum.

    qRegisterMetaType< ::QAccessible::Event >("QAccessible::Event");
    qRegisterMetaType< ::QAccessible::Role >("QAccessible::Role");
    qRegisterMetaType< ::QAccessible::Text >("QAccessible::Text");
    qRegisterMetaType< ::QAccessible::RelationFlag >("QAccessible::RelationFlag");
    qRegisterMetaType< ::QAccessible::Relation >("QAccessible::Relation");
    qRegisterMetaType< ::QAccessible::InterfaceType >("QAccessible::InterfaceType");
    qRegisterMetaType< ::QAccessible::TextBoundaryType >("QAccessible::TextBoundaryType");
}
