/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QACCESSIBLETEXTINTERFACEWRAPPER_H
#define SBK_QACCESSIBLETEXTINTERFACEWRAPPER_H

#define protected public

#include <QtGui/qaccessible.h>


// Extra includes
#include <qrect.h>
#include <qpoint.h>
class QAccessibleTextInterfaceWrapper : public QAccessibleTextInterface
{
public:
    QAccessibleTextInterfaceWrapper();
    void addSelection(int startOffset, int endOffset) override;
    ::QString attributes(int offset, int * startOffset, int * endOffset) const override;
    int characterCount() const override;
    ::QRect characterRect(int offset) const override;
    int cursorPosition() const override;
    int offsetAtPoint(const ::QPoint & point) const override;
    void removeSelection(int selectionIndex) override;
    void scrollToSubstring(int startIndex, int endIndex) override;
    void selection(int selectionIndex, int * startOffset, int * endOffset) const override;
    int selectionCount() const override;
    void setCursorPosition(int position) override;
    void setSelection(int selectionIndex, int startOffset, int endOffset) override;
    ::QString text(int startOffset, int endOffset) const override;
    ::QString textAfterOffset(int offset, ::QAccessible::TextBoundaryType boundaryType, int * startOffset, int * endOffset) const override;
    ::QString textAtOffset(int offset, ::QAccessible::TextBoundaryType boundaryType, int * startOffset, int * endOffset) const override;
    ::QString textBeforeOffset(int offset, ::QAccessible::TextBoundaryType boundaryType, int * startOffset, int * endOffset) const override;
    ~QAccessibleTextInterfaceWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[16];
};

#endif // SBK_QACCESSIBLETEXTINTERFACEWRAPPER_H

