/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessibletextremoveevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAccessibleTextRemoveEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAccessibleTextRemoveEventWrapper::QAccessibleTextRemoveEventWrapper(::QAccessibleInterface * iface, int position, const ::QString & text) : QAccessibleTextRemoveEvent(iface, position, text)
{
    resetPyMethodCache();
    // ... middle
}

QAccessibleTextRemoveEventWrapper::QAccessibleTextRemoveEventWrapper(::QObject * obj, int position, const ::QString & text) : QAccessibleTextRemoveEvent(obj, position, text)
{
    resetPyMethodCache();
    // ... middle
}

::QAccessibleInterface * QAccessibleTextRemoveEventWrapper::accessibleInterface() const
{
    if (m_PyMethodCache[0])
        return this->::QAccessibleEvent::accessibleInterface();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accessibleInterface";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAccessibleEvent::accessibleInterface();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleTextRemoveEvent.accessibleInterface", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAccessibleInterface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAccessibleInterface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QAccessibleTextRemoveEventWrapper::~QAccessibleTextRemoveEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAccessibleTextRemoveEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAccessibleTextRemoveEvent >()))
        return -1;

    ::QAccessibleTextRemoveEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextRemoveEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAccessibleTextRemoveEvent", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QAccessibleTextRemoveEvent::QAccessibleTextRemoveEvent(QAccessibleInterface*,int,QString)
    // 1: QAccessibleTextRemoveEvent::QAccessibleTextRemoveEvent(QObject*,int,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 1; // QAccessibleTextRemoveEvent(QObject*,int,QString)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // QAccessibleTextRemoveEvent(QAccessibleInterface*,int,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTextRemoveEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAccessibleTextRemoveEvent(QAccessibleInterface * iface, int position, const QString & text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAccessibleInterface *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QAccessibleTextRemoveEvent(QAccessibleInterface*,int,QString)
                cptr = new ::QAccessibleTextRemoveEventWrapper(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // QAccessibleTextRemoveEvent(QObject * obj, int position, const QString & text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QAccessibleTextRemoveEvent(QObject*,int,QString)
                cptr = new ::QAccessibleTextRemoveEventWrapper(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAccessibleTextRemoveEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAccessibleTextRemoveEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAccessibleTextRemoveEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAccessibleTextRemoveEventFunc_changePosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextRemoveEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTREMOVEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextRemoveEvent.changePosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // changePosition()const
            int cppResult = const_cast<const ::QAccessibleTextRemoveEvent *>(cppSelf)->changePosition();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTextRemoveEventFunc_textRemoved(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextRemoveEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTREMOVEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextRemoveEvent.textRemoved";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textRemoved()const
            QString cppResult = const_cast<const ::QAccessibleTextRemoveEvent *>(cppSelf)->textRemoved();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAccessibleTextRemoveEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessibleTextRemoveEvent_methods[] = {
    {"changePosition", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextRemoveEventFunc_changePosition), METH_NOARGS},
    {"textRemoved", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextRemoveEventFunc_textRemoved), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAccessibleTextRemoveEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAccessibleTextRemoveEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTREMOVEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAccessibleTextRemoveEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAccessibleTextRemoveEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessibleTextRemoveEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessibleTextRemoveEvent_Type = nullptr;
static SbkObjectType *Sbk_QAccessibleTextRemoveEvent_TypeF(void)
{
    return _Sbk_QAccessibleTextRemoveEvent_Type;
}

static PyType_Slot Sbk_QAccessibleTextRemoveEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAccessibleTextRemoveEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessibleTextRemoveEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessibleTextRemoveEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessibleTextRemoveEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAccessibleTextRemoveEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessibleTextRemoveEvent_spec = {
    "2:PySide2.QtGui.QAccessibleTextRemoveEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessibleTextRemoveEvent_slots
};

} //extern "C"

static void *Sbk_QAccessibleTextRemoveEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QAccessibleTextRemoveEvent *>(cptr)->type() == QAccessible::TextRemoved)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAccessibleTextRemoveEvent_PythonToCpp_QAccessibleTextRemoveEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessibleTextRemoveEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAccessibleTextRemoveEvent_PythonToCpp_QAccessibleTextRemoveEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTextRemoveEvent_TypeF())))
        return QAccessibleTextRemoveEvent_PythonToCpp_QAccessibleTextRemoveEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAccessibleTextRemoveEvent_PTR_CppToPython_QAccessibleTextRemoveEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessibleTextRemoveEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessibleTextRemoveEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessibleTextRemoveEvent_SignatureStrings[] = {
    "1:PySide2.QtGui.QAccessibleTextRemoveEvent(self,iface:PySide2.QtGui.QAccessibleInterface,position:int,text:QString)",
    "0:PySide2.QtGui.QAccessibleTextRemoveEvent(self,obj:PySide2.QtCore.QObject,position:int,text:QString)",
    "PySide2.QtGui.QAccessibleTextRemoveEvent.changePosition(self)->int",
    "PySide2.QtGui.QAccessibleTextRemoveEvent.textRemoved(self)->QString",
    nullptr}; // Sentinel

void init_QAccessibleTextRemoveEvent(PyObject *module)
{
    _Sbk_QAccessibleTextRemoveEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAccessibleTextRemoveEvent",
        "QAccessibleTextRemoveEvent*",
        &Sbk_QAccessibleTextRemoveEvent_spec,
        &Shiboken::callCppDestructor< ::QAccessibleTextRemoveEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTCURSOREVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTextRemoveEvent_Type);
    InitSignatureStrings(pyType, QAccessibleTextRemoveEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTextRemoveEvent_Type), Sbk_QAccessibleTextRemoveEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTREMOVEEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTextRemoveEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessibleTextRemoveEvent_TypeF(),
        QAccessibleTextRemoveEvent_PythonToCpp_QAccessibleTextRemoveEvent_PTR,
        is_QAccessibleTextRemoveEvent_PythonToCpp_QAccessibleTextRemoveEvent_PTR_Convertible,
        QAccessibleTextRemoveEvent_PTR_CppToPython_QAccessibleTextRemoveEvent);

    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextRemoveEvent");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextRemoveEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextRemoveEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTextRemoveEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTextRemoveEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAccessibleTextRemoveEvent_TypeF(), &Sbk_QAccessibleTextRemoveEvent_typeDiscovery);

}
