/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessibletextupdateevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAccessibleTextUpdateEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAccessibleTextUpdateEventWrapper::QAccessibleTextUpdateEventWrapper(::QAccessibleInterface * iface, int position, const ::QString & oldText, const ::QString & text) : QAccessibleTextUpdateEvent(iface, position, oldText, text)
{
    resetPyMethodCache();
    // ... middle
}

QAccessibleTextUpdateEventWrapper::QAccessibleTextUpdateEventWrapper(::QObject * obj, int position, const ::QString & oldText, const ::QString & text) : QAccessibleTextUpdateEvent(obj, position, oldText, text)
{
    resetPyMethodCache();
    // ... middle
}

::QAccessibleInterface * QAccessibleTextUpdateEventWrapper::accessibleInterface() const
{
    if (m_PyMethodCache[0])
        return this->::QAccessibleEvent::accessibleInterface();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accessibleInterface";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAccessibleEvent::accessibleInterface();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleTextUpdateEvent.accessibleInterface", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAccessibleInterface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAccessibleInterface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QAccessibleTextUpdateEventWrapper::~QAccessibleTextUpdateEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAccessibleTextUpdateEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAccessibleTextUpdateEvent >()))
        return -1;

    ::QAccessibleTextUpdateEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextUpdateEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAccessibleTextUpdateEvent", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QAccessibleTextUpdateEvent::QAccessibleTextUpdateEvent(QAccessibleInterface*,int,QString,QString)
    // 1: QAccessibleTextUpdateEvent::QAccessibleTextUpdateEvent(QObject*,int,QString,QString)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 1; // QAccessibleTextUpdateEvent(QObject*,int,QString,QString)
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 0; // QAccessibleTextUpdateEvent(QAccessibleInterface*,int,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTextUpdateEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAccessibleTextUpdateEvent(QAccessibleInterface * iface, int position, const QString & oldText, const QString & text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAccessibleInterface *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QAccessibleTextUpdateEvent(QAccessibleInterface*,int,QString,QString)
                cptr = new ::QAccessibleTextUpdateEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // QAccessibleTextUpdateEvent(QObject * obj, int position, const QString & oldText, const QString & text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QAccessibleTextUpdateEvent(QObject*,int,QString,QString)
                cptr = new ::QAccessibleTextUpdateEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAccessibleTextUpdateEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAccessibleTextUpdateEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAccessibleTextUpdateEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAccessibleTextUpdateEventFunc_changePosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextUpdateEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTUPDATEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextUpdateEvent.changePosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // changePosition()const
            int cppResult = const_cast<const ::QAccessibleTextUpdateEvent *>(cppSelf)->changePosition();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTextUpdateEventFunc_textInserted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextUpdateEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTUPDATEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextUpdateEvent.textInserted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textInserted()const
            QString cppResult = const_cast<const ::QAccessibleTextUpdateEvent *>(cppSelf)->textInserted();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTextUpdateEventFunc_textRemoved(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextUpdateEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTUPDATEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextUpdateEvent.textRemoved";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textRemoved()const
            QString cppResult = const_cast<const ::QAccessibleTextUpdateEvent *>(cppSelf)->textRemoved();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAccessibleTextUpdateEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessibleTextUpdateEvent_methods[] = {
    {"changePosition", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextUpdateEventFunc_changePosition), METH_NOARGS},
    {"textInserted", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextUpdateEventFunc_textInserted), METH_NOARGS},
    {"textRemoved", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextUpdateEventFunc_textRemoved), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAccessibleTextUpdateEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAccessibleTextUpdateEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTUPDATEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAccessibleTextUpdateEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAccessibleTextUpdateEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessibleTextUpdateEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessibleTextUpdateEvent_Type = nullptr;
static SbkObjectType *Sbk_QAccessibleTextUpdateEvent_TypeF(void)
{
    return _Sbk_QAccessibleTextUpdateEvent_Type;
}

static PyType_Slot Sbk_QAccessibleTextUpdateEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAccessibleTextUpdateEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessibleTextUpdateEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessibleTextUpdateEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessibleTextUpdateEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAccessibleTextUpdateEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessibleTextUpdateEvent_spec = {
    "2:PySide2.QtGui.QAccessibleTextUpdateEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessibleTextUpdateEvent_slots
};

} //extern "C"

static void *Sbk_QAccessibleTextUpdateEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QAccessibleTextUpdateEvent *>(cptr)->type() == QAccessible::TextUpdated)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAccessibleTextUpdateEvent_PythonToCpp_QAccessibleTextUpdateEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessibleTextUpdateEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAccessibleTextUpdateEvent_PythonToCpp_QAccessibleTextUpdateEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTextUpdateEvent_TypeF())))
        return QAccessibleTextUpdateEvent_PythonToCpp_QAccessibleTextUpdateEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAccessibleTextUpdateEvent_PTR_CppToPython_QAccessibleTextUpdateEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessibleTextUpdateEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessibleTextUpdateEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessibleTextUpdateEvent_SignatureStrings[] = {
    "1:PySide2.QtGui.QAccessibleTextUpdateEvent(self,iface:PySide2.QtGui.QAccessibleInterface,position:int,oldText:QString,text:QString)",
    "0:PySide2.QtGui.QAccessibleTextUpdateEvent(self,obj:PySide2.QtCore.QObject,position:int,oldText:QString,text:QString)",
    "PySide2.QtGui.QAccessibleTextUpdateEvent.changePosition(self)->int",
    "PySide2.QtGui.QAccessibleTextUpdateEvent.textInserted(self)->QString",
    "PySide2.QtGui.QAccessibleTextUpdateEvent.textRemoved(self)->QString",
    nullptr}; // Sentinel

void init_QAccessibleTextUpdateEvent(PyObject *module)
{
    _Sbk_QAccessibleTextUpdateEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAccessibleTextUpdateEvent",
        "QAccessibleTextUpdateEvent*",
        &Sbk_QAccessibleTextUpdateEvent_spec,
        &Shiboken::callCppDestructor< ::QAccessibleTextUpdateEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTCURSOREVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTextUpdateEvent_Type);
    InitSignatureStrings(pyType, QAccessibleTextUpdateEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTextUpdateEvent_Type), Sbk_QAccessibleTextUpdateEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTUPDATEEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTextUpdateEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessibleTextUpdateEvent_TypeF(),
        QAccessibleTextUpdateEvent_PythonToCpp_QAccessibleTextUpdateEvent_PTR,
        is_QAccessibleTextUpdateEvent_PythonToCpp_QAccessibleTextUpdateEvent_PTR_Convertible,
        QAccessibleTextUpdateEvent_PTR_CppToPython_QAccessibleTextUpdateEvent);

    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextUpdateEvent");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextUpdateEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextUpdateEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTextUpdateEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTextUpdateEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAccessibleTextUpdateEvent_TypeF(), &Sbk_QAccessibleTextUpdateEvent_typeDiscovery);

}
