/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qbrush_wrapper.h"

// inner classes

// Extra includes
#include <QPixmap>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qimage.h>
#include <QtGui/qmatrix.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qtransform.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QBrush_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QBrush >()))
        return -1;

    ::QBrush *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBrush_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QBrush", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QBrush::QBrush()
    // 1: QBrush::QBrush(Qt::BrushStyle)
    // 2: QBrush::QBrush(Qt::GlobalColor,Qt::BrushStyle)
    // 3: QBrush::QBrush(Qt::GlobalColor,QPixmap)
    // 4: QBrush::QBrush(QBrush)
    // 5: QBrush::QBrush(QColor,Qt::BrushStyle)
    // 6: QBrush::QBrush(QColor,QPixmap)
    // 7: QBrush::QBrush(QGradient)
    // 8: QBrush::QBrush(QImage)
    // 9: QBrush::QBrush(QPixmap)
    if (numArgs == 0) {
        overloadId = 0; // QBrush()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        overloadId = 8; // QBrush(QImage)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        overloadId = 9; // QBrush(QPixmap)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), (pyArgs[0])))) {
        overloadId = 7; // QBrush(QGradient)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QBrush(Qt::GlobalColor,Qt::BrushStyle)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
            overloadId = 3; // QBrush(Qt::GlobalColor,QPixmap)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // QBrush(Qt::GlobalColor,Qt::BrushStyle)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QBrush(Qt::BrushStyle)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // QBrush(QColor,Qt::BrushStyle)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
            overloadId = 6; // QBrush(QColor,QPixmap)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 5; // QBrush(QColor,Qt::BrushStyle)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrush_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QBrush()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QBrush()
                cptr = new ::QBrush();
            }
            break;
        }
        case 1: // QBrush(Qt::BrushStyle bs)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            ::Qt::BrushStyle cppArg0{Qt::NoBrush};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QBrush(Qt::BrushStyle)
                cptr = new ::QBrush(cppArg0);
            }
            break;
        }
        case 2: // QBrush(Qt::GlobalColor color, Qt::BrushStyle bs)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_bs = Shiboken::String::createStaticString("bs");
                if (PyDict_Contains(kwds, key_bs)) {
                    value = PyDict_GetItem(kwds, key_bs);
                    if (value && pyArgs[1]) {
                        errInfo = key_bs;
                        Py_INCREF(errInfo);
                        goto Sbk_QBrush_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QBrush_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_bs);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QBrush_Init_TypeError;
                }
            }
            ::Qt::GlobalColor cppArg0{Qt::color0};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::BrushStyle cppArg1 = Qt::SolidPattern;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QBrush(Qt::GlobalColor,Qt::BrushStyle)
                cptr = new ::QBrush(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QBrush(Qt::GlobalColor color, const QPixmap & pixmap)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            ::Qt::GlobalColor cppArg0{Qt::color0};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QBrush(Qt::GlobalColor,QPixmap)
                cptr = new ::QBrush(cppArg0, *cppArg1);
            }
            break;
        }
        case 4: // QBrush(const QBrush & brush)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QBrush cppArg0_local;
            ::QBrush *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QBrush(QBrush)
                cptr = new ::QBrush(*cppArg0);
            }
            break;
        }
        case 5: // QBrush(const QColor & color, Qt::BrushStyle bs)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_bs = Shiboken::String::createStaticString("bs");
                if (PyDict_Contains(kwds, key_bs)) {
                    value = PyDict_GetItem(kwds, key_bs);
                    if (value && pyArgs[1]) {
                        errInfo = key_bs;
                        Py_INCREF(errInfo);
                        goto Sbk_QBrush_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QBrush_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_bs);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QBrush_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::BrushStyle cppArg1 = Qt::SolidPattern;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QBrush(QColor,Qt::BrushStyle)
                cptr = new ::QBrush(*cppArg0, cppArg1);
            }
            break;
        }
        case 6: // QBrush(const QColor & color, const QPixmap & pixmap)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QBrush(QColor,QPixmap)
                cptr = new ::QBrush(*cppArg0, *cppArg1);
            }
            break;
        }
        case 7: // QBrush(const QGradient & gradient)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGradient cppArg0_local;
            ::QGradient *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QBrush(QGradient)
                cptr = new ::QBrush(*cppArg0);
            }
            break;
        }
        case 8: // QBrush(const QImage & image)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QBrush(QImage)
                cptr = new ::QBrush(*cppArg0);
            }
            break;
        }
        case 9: // QBrush(const QPixmap & pixmap)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBrush_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QBrush(QPixmap)
                cptr = new ::QBrush(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QBrush >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QBrush_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QBrush_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QBrushFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.color";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // color()const
            const QColor & cppResult = const_cast<const ::QBrush *>(cppSelf)->color();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_gradient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.gradient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gradient()const
            const QGradient * cppResult = const_cast<const ::QBrush *>(cppSelf)->gradient();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_isOpaque(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.isOpaque";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpaque()const
            bool cppResult = const_cast<const ::QBrush *>(cppSelf)->isOpaque();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_matrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.matrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matrix()const
            const QMatrix & cppResult = const_cast<const ::QBrush *>(cppSelf)->matrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::setColor(Qt::GlobalColor)
    // 1: QBrush::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setColor(Qt::GlobalColor)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 1; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_setColor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setColor(Qt::GlobalColor color)
        {
            ::Qt::GlobalColor cppArg0{Qt::color0};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setColor(Qt::GlobalColor)
                cppSelf->setColor(cppArg0);
            }
            break;
        }
        case 1: // setColor(const QColor & color)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setColor(QColor)
                cppSelf->setColor(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_setMatrix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.setMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::setMatrix(QMatrix)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArg)))) {
        overloadId = 0; // setMatrix(QMatrix)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_setMatrix_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix cppArg0_local;
        ::QMatrix *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMatrix(QMatrix)
            cppSelf->setMatrix(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_setMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.setStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::setStyle(Qt::BrushStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStyle(Qt::BrushStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_setStyle_TypeError;

    // Call function/method
    {
        ::Qt::BrushStyle cppArg0{Qt::NoBrush};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyle(Qt::BrushStyle)
            cppSelf->setStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_setStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_setTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.setTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::setTexture(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArg)))) {
        overloadId = 0; // setTexture(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_setTexture_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTexture(QPixmap)
            cppSelf->setTexture(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_setTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_setTextureImage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.setTextureImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::setTextureImage(QImage)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // setTextureImage(QImage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_setTextureImage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTextureImage(QImage)
            cppSelf->setTextureImage(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_setTextureImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_setTransform(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.setTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::setTransform(QTransform)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArg)))) {
        overloadId = 0; // setTransform(QTransform)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_setTransform_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTransform cppArg0_local;
        ::QTransform *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTransform(QTransform)
            cppSelf->setTransform(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_setTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            Qt::BrushStyle cppResult = const_cast<const ::QBrush *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBrush::swap(QBrush&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QBrush&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBrushFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QBrush&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBrushFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc_texture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.texture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // texture()const
            QPixmap cppResult = const_cast<const ::QBrush *>(cppSelf)->texture();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_textureImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.textureImage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureImage()const
            QImage cppResult = const_cast<const ::QBrush *>(cppSelf)->textureImage();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrushFunc_transform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.transform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transform()const
            QTransform cppResult = const_cast<const ::QBrush *>(cppSelf)->transform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBrush___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QBrush_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QBrush_methods[] = {
    {"color", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_color), METH_NOARGS},
    {"gradient", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_gradient), METH_NOARGS},
    {"isOpaque", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_isOpaque), METH_NOARGS},
    {"matrix", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_matrix), METH_NOARGS},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_setColor), METH_O},
    {"setMatrix", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_setMatrix), METH_O},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_setStyle), METH_O},
    {"setTexture", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_setTexture), METH_O},
    {"setTextureImage", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_setTextureImage), METH_O},
    {"setTransform", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_setTransform), METH_O},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_style), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_swap), METH_O},
    {"texture", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_texture), METH_NOARGS},
    {"textureImage", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_textureImage), METH_NOARGS},
    {"transform", reinterpret_cast<PyCFunction>(Sbk_QBrushFunc_transform), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QBrush___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QBrushFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QBrush::operator<<(QDataStream&,QBrush)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QBrush)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QBrushFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QBrush) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBrushFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBrushFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QBrush.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QBrush::operator>>(QDataStream&,QBrush&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QBrush&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QBrushFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QBrush&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBrushFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QBrush_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
                // operator!=(const QBrush & b) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QBrush cppArg0_local;
                ::QBrush *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
                // operator==(const QBrush & b) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QBrush cppArg0_local;
                ::QBrush *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QBrush_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QBrush_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QBrush_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QBrush_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QBrush__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QBrush_Type = nullptr;
static SbkObjectType *Sbk_QBrush_TypeF(void)
{
    return _Sbk_QBrush_Type;
}

static PyType_Slot Sbk_QBrush_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QBrush__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QBrush_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QBrush_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QBrush_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QBrush_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QBrush_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QBrushFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QBrushFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QBrush_spec = {
    "2:PySide2.QtGui.QBrush",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QBrush_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBrush_PythonToCpp_QBrush_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QBrush_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBrush_PythonToCpp_QBrush_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QBrush_TypeF())))
        return QBrush_PythonToCpp_QBrush_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBrush_PTR_CppToPython_QBrush(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QBrush *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QBrush_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QBrush_COPY_CppToPython_QBrush(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QBrush_TypeF(), new ::QBrush(*reinterpret_cast<const ::QBrush *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QBrush_PythonToCpp_QBrush_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QBrush *>(cppOut) = *reinterpret_cast< ::QBrush *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QBrush_PythonToCpp_QBrush_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QBrush_TypeF())))
        return QBrush_PythonToCpp_QBrush_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_Qt_BrushStyle_PythonToCpp_QBrush(PyObject *pyIn, void *cppOut) {
    ::Qt::BrushStyle cppIn{Qt::NoBrush};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QBrush *>(cppOut) = ::QBrush(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_Qt_BrushStyle_PythonToCpp_QBrush_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX], pyIn))
        return PySide2_QtCore_Qt_BrushStyle_PythonToCpp_QBrush;
    return {};
}

static void PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QBrush(PyObject *pyIn, void *cppOut) {
    ::Qt::GlobalColor cppIn{Qt::color0};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QBrush *>(cppOut) = ::QBrush(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QBrush_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX], pyIn))
        return PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QBrush;
    return {};
}

static void constQColorREF_PythonToCpp_QBrush(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QBrush *>(cppOut) = ::QBrush( *reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQColorREF_PythonToCpp_QBrush_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], pyIn))
        return constQColorREF_PythonToCpp_QBrush;
    return {};
}

static void constQGradientREF_PythonToCpp_QBrush(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QBrush *>(cppOut) = ::QBrush( *reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQGradientREF_PythonToCpp_QBrush_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], pyIn))
        return constQGradientREF_PythonToCpp_QBrush;
    return {};
}

static void constQImageREF_PythonToCpp_QBrush(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QBrush *>(cppOut) = ::QBrush( *reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQImageREF_PythonToCpp_QBrush_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], pyIn))
        return constQImageREF_PythonToCpp_QBrush;
    return {};
}

static void constQPixmapREF_PythonToCpp_QBrush(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QBrush *>(cppOut) = ::QBrush( *reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQPixmapREF_PythonToCpp_QBrush_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], pyIn))
        return constQPixmapREF_PythonToCpp_QBrush;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QBrush_SignatureStrings[] = {
    "9:PySide2.QtGui.QBrush(self)",
    "8:PySide2.QtGui.QBrush(self,bs:PySide2.QtCore.Qt.BrushStyle)",
    "7:PySide2.QtGui.QBrush(self,color:PySide2.QtCore.Qt.GlobalColor,bs:PySide2.QtCore.Qt.BrushStyle=Qt.SolidPattern)",
    "6:PySide2.QtGui.QBrush(self,color:PySide2.QtCore.Qt.GlobalColor,pixmap:PySide2.QtGui.QPixmap)",
    "5:PySide2.QtGui.QBrush(self,brush:PySide2.QtGui.QBrush)",
    "4:PySide2.QtGui.QBrush(self,color:PySide2.QtGui.QColor,bs:PySide2.QtCore.Qt.BrushStyle=Qt.SolidPattern)",
    "3:PySide2.QtGui.QBrush(self,color:PySide2.QtGui.QColor,pixmap:PySide2.QtGui.QPixmap)",
    "2:PySide2.QtGui.QBrush(self,gradient:PySide2.QtGui.QGradient)",
    "1:PySide2.QtGui.QBrush(self,image:PySide2.QtGui.QImage)",
    "0:PySide2.QtGui.QBrush(self,pixmap:PySide2.QtGui.QPixmap)",
    "PySide2.QtGui.QBrush.color(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QBrush.gradient(self)->PySide2.QtGui.QGradient",
    "PySide2.QtGui.QBrush.isOpaque(self)->bool",
    "PySide2.QtGui.QBrush.matrix(self)->PySide2.QtGui.QMatrix",
    "1:PySide2.QtGui.QBrush.setColor(self,color:PySide2.QtCore.Qt.GlobalColor)",
    "0:PySide2.QtGui.QBrush.setColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QBrush.setMatrix(self,mat:PySide2.QtGui.QMatrix)",
    "PySide2.QtGui.QBrush.setStyle(self,arg__1:PySide2.QtCore.Qt.BrushStyle)",
    "PySide2.QtGui.QBrush.setTexture(self,pixmap:PySide2.QtGui.QPixmap)",
    "PySide2.QtGui.QBrush.setTextureImage(self,image:PySide2.QtGui.QImage)",
    "PySide2.QtGui.QBrush.setTransform(self,arg__1:PySide2.QtGui.QTransform)",
    "PySide2.QtGui.QBrush.style(self)->PySide2.QtCore.Qt.BrushStyle",
    "PySide2.QtGui.QBrush.swap(self,other:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QBrush.texture(self)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QBrush.textureImage(self)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QBrush.transform(self)->PySide2.QtGui.QTransform",
    "PySide2.QtGui.QBrush.__copy__()",
    "PySide2.QtGui.QBrush.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QBrush.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QBrush(PyObject *module)
{
    _Sbk_QBrush_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QBrush",
        "QBrush",
        &Sbk_QBrush_spec,
        &Shiboken::callCppDestructor< ::QBrush >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QBrush_Type);
    InitSignatureStrings(pyType, QBrush_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QBrush_Type), Sbk_QBrush_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QBrush_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QBrush_TypeF(),
        QBrush_PythonToCpp_QBrush_PTR,
        is_QBrush_PythonToCpp_QBrush_PTR_Convertible,
        QBrush_PTR_CppToPython_QBrush,
        QBrush_COPY_CppToPython_QBrush);

    Shiboken::Conversions::registerConverterName(converter, "QBrush");
    Shiboken::Conversions::registerConverterName(converter, "QBrush*");
    Shiboken::Conversions::registerConverterName(converter, "QBrush&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBrush).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QBrush_PythonToCpp_QBrush_COPY,
        is_QBrush_PythonToCpp_QBrush_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_Qt_BrushStyle_PythonToCpp_QBrush,
        is_PySide2_QtCore_Qt_BrushStyle_PythonToCpp_QBrush_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QBrush,
        is_PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QBrush_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQColorREF_PythonToCpp_QBrush,
        is_constQColorREF_PythonToCpp_QBrush_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQGradientREF_PythonToCpp_QBrush,
        is_constQGradientREF_PythonToCpp_QBrush_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQImageREF_PythonToCpp_QBrush,
        is_constQImageREF_PythonToCpp_QBrush_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQPixmapREF_PythonToCpp_QBrush,
        is_constQPixmapREF_PythonToCpp_QBrush_Convertible);

    qRegisterMetaType< ::QBrush >("QBrush");
}
