/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qcolorspace_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qcolorspace.h>
#include <qbytearray.h>
#include <qdatastream.h>
#include <qobject.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QColorSpace_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QColorSpace >()))
        return -1;

    ::QColorSpace *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorSpace_Init_TypeError;
    } else if (numArgs == 4)
        goto Sbk_QColorSpace_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:QColorSpace", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return -1;


    // Overloaded function decisor
    // 0: QColorSpace::QColorSpace()
    // 1: QColorSpace::QColorSpace(QColorSpace::NamedColorSpace)
    // 2: QColorSpace::QColorSpace(QColorSpace::Primaries,QColorSpace::TransferFunction,float)
    // 3: QColorSpace::QColorSpace(QColorSpace::Primaries,float)
    // 4: QColorSpace::QColorSpace(QColorSpace)
    // 5: QColorSpace::QColorSpace(QPointF,QPointF,QPointF,QPointF,QColorSpace::TransferFunction,float)
    if (numArgs == 0) {
        overloadId = 0; // QColorSpace()
    } else if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX])->converter, (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 5; // QColorSpace(QPointF,QPointF,QPointF,QPointF,QColorSpace::TransferFunction,float)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
            overloadId = 5; // QColorSpace(QPointF,QPointF,QPointF,QPointF,QColorSpace::TransferFunction,float)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX])->converter, (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QColorSpace(QColorSpace::Primaries,QColorSpace::TransferFunction,float)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
                overloadId = 2; // QColorSpace(QColorSpace::Primaries,QColorSpace::TransferFunction,float)
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            overloadId = 3; // QColorSpace(QColorSpace::Primaries,float)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QColorSpace(QColorSpace::NamedColorSpace)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QColorSpace(QColorSpace)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorSpace_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QColorSpace()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColorSpace_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QColorSpace()
                cptr = new ::QColorSpace();
            }
            break;
        }
        case 1: // QColorSpace(QColorSpace::NamedColorSpace namedColorSpace)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColorSpace_Init_TypeError;
            }
            ::QColorSpace::NamedColorSpace cppArg0 = static_cast< ::QColorSpace::NamedColorSpace>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QColorSpace(QColorSpace::NamedColorSpace)
                cptr = new ::QColorSpace(cppArg0);
            }
            break;
        }
        case 2: // QColorSpace(QColorSpace::Primaries primaries, QColorSpace::TransferFunction transferFunction, float gamma)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_gamma = Shiboken::String::createStaticString("gamma");
                if (PyDict_Contains(kwds, key_gamma)) {
                    value = PyDict_GetItem(kwds, key_gamma);
                    if (value && pyArgs[2]) {
                        errInfo = key_gamma;
                        Py_INCREF(errInfo);
                        goto Sbk_QColorSpace_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2]))))
                            goto Sbk_QColorSpace_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_gamma);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QColorSpace_Init_TypeError;
                }
            }
            ::QColorSpace::Primaries cppArg0{QColorSpace::Primaries::Custom};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QColorSpace::TransferFunction cppArg1{QColorSpace::TransferFunction::Custom};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2 = 0.0f;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QColorSpace(QColorSpace::Primaries,QColorSpace::TransferFunction,float)
                cptr = new ::QColorSpace(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 3: // QColorSpace(QColorSpace::Primaries primaries, float gamma)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColorSpace_Init_TypeError;
            }
            ::QColorSpace::Primaries cppArg0{QColorSpace::Primaries::Custom};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QColorSpace(QColorSpace::Primaries,float)
                cptr = new ::QColorSpace(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QColorSpace(const QColorSpace & colorSpace)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColorSpace_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColorSpace cppArg0_local;
            ::QColorSpace *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QColorSpace(QColorSpace)
                cptr = new ::QColorSpace(*cppArg0);
            }
            break;
        }
        case 5: // QColorSpace(const QPointF & whitePoint, const QPointF & redPoint, const QPointF & greenPoint, const QPointF & bluePoint, QColorSpace::TransferFunction transferFunction, float gamma)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_gamma = Shiboken::String::createStaticString("gamma");
                if (PyDict_Contains(kwds, key_gamma)) {
                    value = PyDict_GetItem(kwds, key_gamma);
                    if (value && pyArgs[5]) {
                        errInfo = key_gamma;
                        Py_INCREF(errInfo);
                        goto Sbk_QColorSpace_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5]))))
                            goto Sbk_QColorSpace_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_gamma);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QColorSpace_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPointF cppArg2_local;
            ::QPointF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QPointF cppArg3_local;
            ::QPointF *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            ::QColorSpace::TransferFunction cppArg4{QColorSpace::TransferFunction::Custom};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            float cppArg5 = 0.0f;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QColorSpace(QPointF,QPointF,QPointF,QPointF,QColorSpace::TransferFunction,float)
                cptr = new ::QColorSpace(*cppArg0, *cppArg1, *cppArg2, *cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QColorSpace >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QColorSpace_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QColorSpace_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QColorSpaceFunc_fromIccProfile(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.fromIccProfile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QColorSpace::fromIccProfile(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // fromIccProfile(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorSpaceFunc_fromIccProfile_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromIccProfile(QByteArray)
            QColorSpace cppResult = ::QColorSpace::fromIccProfile(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorSpaceFunc_fromIccProfile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorSpaceFunc_gamma(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.gamma";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gamma()const
            float cppResult = const_cast<const ::QColorSpace *>(cppSelf)->gamma();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorSpaceFunc_iccProfile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.iccProfile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iccProfile()const
            QByteArray cppResult = const_cast<const ::QColorSpace *>(cppSelf)->iccProfile();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorSpaceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QColorSpace *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorSpaceFunc_primaries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.primaries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // primaries()const
            QColorSpace::Primaries cppResult = const_cast<const ::QColorSpace *>(cppSelf)->primaries();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorSpaceFunc_setPrimaries(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.setPrimaries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QColorSpaceFunc_setPrimaries_TypeError;

    if (!PyArg_UnpackTuple(args, "setPrimaries", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColorSpace::setPrimaries(QColorSpace::Primaries)
    // 1: QColorSpace::setPrimaries(QPointF,QPointF,QPointF,QPointF)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[3])))) {
        overloadId = 1; // setPrimaries(QPointF,QPointF,QPointF,QPointF)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setPrimaries(QColorSpace::Primaries)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorSpaceFunc_setPrimaries_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPrimaries(QColorSpace::Primaries primariesId)
        {
            ::QColorSpace::Primaries cppArg0{QColorSpace::Primaries::Custom};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setPrimaries(QColorSpace::Primaries)
                cppSelf->setPrimaries(cppArg0);
            }
            break;
        }
        case 1: // setPrimaries(const QPointF & whitePoint, const QPointF & redPoint, const QPointF & greenPoint, const QPointF & bluePoint)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPointF cppArg2_local;
            ::QPointF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPointF cppArg3_local;
            ::QPointF *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);


            if (!PyErr_Occurred()) {
                // setPrimaries(QPointF,QPointF,QPointF,QPointF)
                cppSelf->setPrimaries(*cppArg0, *cppArg1, *cppArg2, *cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorSpaceFunc_setPrimaries_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorSpaceFunc_setTransferFunction(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.setTransferFunction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorSpaceFunc_setTransferFunction_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorSpaceFunc_setTransferFunction_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setTransferFunction", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QColorSpace::setTransferFunction(QColorSpace::TransferFunction,float)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setTransferFunction(QColorSpace::TransferFunction,float)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            overloadId = 0; // setTransferFunction(QColorSpace::TransferFunction,float)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorSpaceFunc_setTransferFunction_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_gamma = Shiboken::String::createStaticString("gamma");
            if (PyDict_Contains(kwds, key_gamma)) {
                value = PyDict_GetItem(kwds, key_gamma);
                if (value && pyArgs[1]) {
                    errInfo = key_gamma;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorSpaceFunc_setTransferFunction_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1]))))
                        goto Sbk_QColorSpaceFunc_setTransferFunction_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_gamma);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorSpaceFunc_setTransferFunction_TypeError;
            }
        }
        ::QColorSpace::TransferFunction cppArg0{QColorSpace::TransferFunction::Custom};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1 = 0.0f;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setTransferFunction(QColorSpace::TransferFunction,float)
            cppSelf->setTransferFunction(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorSpaceFunc_setTransferFunction_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorSpaceFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColorSpace::swap(QColorSpace&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QColorSpace&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorSpaceFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColorSpace cppArg0_local;
        ::QColorSpace *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QColorSpace&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorSpaceFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorSpaceFunc_transferFunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.transferFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transferFunction()const
            QColorSpace::TransferFunction cppResult = const_cast<const ::QColorSpace *>(cppSelf)->transferFunction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorSpaceFunc_withTransferFunction(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.withTransferFunction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorSpaceFunc_withTransferFunction_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorSpaceFunc_withTransferFunction_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:withTransferFunction", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QColorSpace::withTransferFunction(QColorSpace::TransferFunction,float)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // withTransferFunction(QColorSpace::TransferFunction,float)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            overloadId = 0; // withTransferFunction(QColorSpace::TransferFunction,float)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorSpaceFunc_withTransferFunction_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_gamma = Shiboken::String::createStaticString("gamma");
            if (PyDict_Contains(kwds, key_gamma)) {
                value = PyDict_GetItem(kwds, key_gamma);
                if (value && pyArgs[1]) {
                    errInfo = key_gamma;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorSpaceFunc_withTransferFunction_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1]))))
                        goto Sbk_QColorSpaceFunc_withTransferFunction_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_gamma);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorSpaceFunc_withTransferFunction_TypeError;
            }
        }
        ::QColorSpace::TransferFunction cppArg0{QColorSpace::TransferFunction::Custom};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1 = 0.0f;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // withTransferFunction(QColorSpace::TransferFunction,float)const
            QColorSpace cppResult = const_cast<const ::QColorSpace *>(cppSelf)->withTransferFunction(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorSpaceFunc_withTransferFunction_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorSpace___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QColorSpace_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QColorSpace_methods[] = {
    {"fromIccProfile", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_fromIccProfile), METH_O|METH_STATIC},
    {"gamma", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_gamma), METH_NOARGS},
    {"iccProfile", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_iccProfile), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_isValid), METH_NOARGS},
    {"primaries", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_primaries), METH_NOARGS},
    {"setPrimaries", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_setPrimaries), METH_VARARGS},
    {"setTransferFunction", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_setTransferFunction), METH_VARARGS|METH_KEYWORDS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_swap), METH_O},
    {"transferFunction", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_transferFunction), METH_NOARGS},
    {"withTransferFunction", reinterpret_cast<PyCFunction>(Sbk_QColorSpaceFunc_withTransferFunction), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QColorSpace___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QColorSpaceFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QColorSpace::operator<<(QDataStream&,QColorSpace)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QColorSpace)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QColorSpaceFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QColorSpace) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorSpaceFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorSpaceFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColorSpace.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QColorSpace::operator>>(QDataStream&,QColorSpace&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QColorSpace&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QColorSpaceFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QColorSpace&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorSpaceFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QColorSpace_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArg)))) {
                // operator!=(const QColorSpace & colorSpace2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QColorSpace cppArg0_local;
                ::QColorSpace *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArg)))) {
                // operator==(const QColorSpace & colorSpace2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QColorSpace cppArg0_local;
                ::QColorSpace *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QColorSpace_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QColorSpace_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QColorSpace_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QColorSpace_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QColorSpace__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QColorSpace_Type = nullptr;
static SbkObjectType *Sbk_QColorSpace_TypeF(void)
{
    return _Sbk_QColorSpace_Type;
}

static PyType_Slot Sbk_QColorSpace_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QColorSpace__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QColorSpace_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QColorSpace_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QColorSpace_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QColorSpace_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QColorSpace_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QColorSpaceFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QColorSpaceFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QColorSpace_spec = {
    "2:PySide2.QtGui.QColorSpace",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QColorSpace_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_NamedColorSpace(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColorSpace::NamedColorSpace *>(cppOut) =
        static_cast<::QColorSpace::NamedColorSpace>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_NamedColorSpace_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX]))
        return QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_NamedColorSpace;
    return {};
}
static PyObject *QColorSpace_NamedColorSpace_CppToPython_QColorSpace_NamedColorSpace(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QColorSpace::NamedColorSpace *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX], castCppIn);

}

static void QColorSpace_Primaries_PythonToCpp_QColorSpace_Primaries(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColorSpace::Primaries *>(cppOut) =
        static_cast<::QColorSpace::Primaries>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QColorSpace_Primaries_PythonToCpp_QColorSpace_Primaries_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX]))
        return QColorSpace_Primaries_PythonToCpp_QColorSpace_Primaries;
    return {};
}
static PyObject *QColorSpace_Primaries_CppToPython_QColorSpace_Primaries(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QColorSpace::Primaries *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], castCppIn);

}

static void QColorSpace_TransferFunction_PythonToCpp_QColorSpace_TransferFunction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColorSpace::TransferFunction *>(cppOut) =
        static_cast<::QColorSpace::TransferFunction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QColorSpace_TransferFunction_PythonToCpp_QColorSpace_TransferFunction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX]))
        return QColorSpace_TransferFunction_PythonToCpp_QColorSpace_TransferFunction;
    return {};
}
static PyObject *QColorSpace_TransferFunction_CppToPython_QColorSpace_TransferFunction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QColorSpace::TransferFunction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QColorSpace_PythonToCpp_QColorSpace_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QColorSpace_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QColorSpace_PythonToCpp_QColorSpace_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QColorSpace_TypeF())))
        return QColorSpace_PythonToCpp_QColorSpace_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QColorSpace_PTR_CppToPython_QColorSpace(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QColorSpace *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QColorSpace_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QColorSpace_COPY_CppToPython_QColorSpace(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QColorSpace_TypeF(), new ::QColorSpace(*reinterpret_cast<const ::QColorSpace *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QColorSpace_PythonToCpp_QColorSpace_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColorSpace *>(cppOut) = *reinterpret_cast< ::QColorSpace *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QColorSpace_PythonToCpp_QColorSpace_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QColorSpace_TypeF())))
        return QColorSpace_PythonToCpp_QColorSpace_COPY;
    return {};
}

// Implicit conversions.
static void QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace(PyObject *pyIn, void *cppOut) {
    ::QColorSpace::NamedColorSpace cppIn = static_cast< ::QColorSpace::NamedColorSpace>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QColorSpace *>(cppOut) = ::QColorSpace(cppIn);
}
static PythonToCppFunc is_QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX], pyIn))
        return QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QColorSpace_SignatureStrings[] = {
    "5:PySide2.QtGui.QColorSpace(self)",
    "4:PySide2.QtGui.QColorSpace(self,namedColorSpace:PySide2.QtGui.QColorSpace.NamedColorSpace)",
    "3:PySide2.QtGui.QColorSpace(self,primaries:PySide2.QtGui.QColorSpace.Primaries,transferFunction:PySide2.QtGui.QColorSpace.TransferFunction,gamma:float=0.0f)",
    "2:PySide2.QtGui.QColorSpace(self,primaries:PySide2.QtGui.QColorSpace.Primaries,gamma:float)",
    "1:PySide2.QtGui.QColorSpace(self,colorSpace:PySide2.QtGui.QColorSpace)",
    "0:PySide2.QtGui.QColorSpace(self,whitePoint:PySide2.QtCore.QPointF,redPoint:PySide2.QtCore.QPointF,greenPoint:PySide2.QtCore.QPointF,bluePoint:PySide2.QtCore.QPointF,transferFunction:PySide2.QtGui.QColorSpace.TransferFunction,gamma:float=0.0f)",
    "PySide2.QtGui.QColorSpace.fromIccProfile(iccProfile:PySide2.QtCore.QByteArray)->PySide2.QtGui.QColorSpace",
    "PySide2.QtGui.QColorSpace.gamma(self)->float",
    "PySide2.QtGui.QColorSpace.iccProfile(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QColorSpace.isValid(self)->bool",
    "PySide2.QtGui.QColorSpace.primaries(self)->PySide2.QtGui.QColorSpace.Primaries",
    "1:PySide2.QtGui.QColorSpace.setPrimaries(self,primariesId:PySide2.QtGui.QColorSpace.Primaries)",
    "0:PySide2.QtGui.QColorSpace.setPrimaries(self,whitePoint:PySide2.QtCore.QPointF,redPoint:PySide2.QtCore.QPointF,greenPoint:PySide2.QtCore.QPointF,bluePoint:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QColorSpace.setTransferFunction(self,transferFunction:PySide2.QtGui.QColorSpace.TransferFunction,gamma:float=0.0f)",
    "PySide2.QtGui.QColorSpace.swap(self,colorSpace:PySide2.QtGui.QColorSpace)",
    "PySide2.QtGui.QColorSpace.transferFunction(self)->PySide2.QtGui.QColorSpace.TransferFunction",
    "PySide2.QtGui.QColorSpace.withTransferFunction(self,transferFunction:PySide2.QtGui.QColorSpace.TransferFunction,gamma:float=0.0f)->PySide2.QtGui.QColorSpace",
    "PySide2.QtGui.QColorSpace.__copy__()",
    "PySide2.QtGui.QColorSpace.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QColorSpace.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QColorSpace(PyObject *module)
{
    _Sbk_QColorSpace_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QColorSpace",
        "QColorSpace",
        &Sbk_QColorSpace_spec,
        &Shiboken::callCppDestructor< ::QColorSpace >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QColorSpace_Type);
    InitSignatureStrings(pyType, QColorSpace_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QColorSpace_Type), Sbk_QColorSpace_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QColorSpace_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QColorSpace_TypeF(),
        QColorSpace_PythonToCpp_QColorSpace_PTR,
        is_QColorSpace_PythonToCpp_QColorSpace_PTR_Convertible,
        QColorSpace_PTR_CppToPython_QColorSpace,
        QColorSpace_COPY_CppToPython_QColorSpace);

    Shiboken::Conversions::registerConverterName(converter, "QColorSpace");
    Shiboken::Conversions::registerConverterName(converter, "QColorSpace*");
    Shiboken::Conversions::registerConverterName(converter, "QColorSpace&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QColorSpace).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QColorSpace_PythonToCpp_QColorSpace_COPY,
        is_QColorSpace_PythonToCpp_QColorSpace_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace,
        is_QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_Convertible);

    // Initialization of enums.

    // Initialization of enum 'NamedColorSpace'.
    SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QColorSpace_TypeF(),
        "NamedColorSpace",
        "2:PySide2.QtGui.QColorSpace.NamedColorSpace",
        "QColorSpace::NamedColorSpace");
    if (!SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX],
        Sbk_QColorSpace_TypeF(), "SRgb", (long) QColorSpace::NamedColorSpace::SRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX],
        Sbk_QColorSpace_TypeF(), "SRgbLinear", (long) QColorSpace::NamedColorSpace::SRgbLinear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX],
        Sbk_QColorSpace_TypeF(), "AdobeRgb", (long) QColorSpace::NamedColorSpace::AdobeRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX],
        Sbk_QColorSpace_TypeF(), "DisplayP3", (long) QColorSpace::NamedColorSpace::DisplayP3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX],
        Sbk_QColorSpace_TypeF(), "ProPhotoRgb", (long) QColorSpace::NamedColorSpace::ProPhotoRgb))
        return;
    // Register converter for enum 'QColorSpace::NamedColorSpace'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX],
            QColorSpace_NamedColorSpace_CppToPython_QColorSpace_NamedColorSpace);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_NamedColorSpace,
            is_QColorSpace_NamedColorSpace_PythonToCpp_QColorSpace_NamedColorSpace_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_NAMEDCOLORSPACE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QColorSpace::NamedColorSpace");
        Shiboken::Conversions::registerConverterName(converter, "NamedColorSpace");
    }
    // End of 'NamedColorSpace' enum.

    // Initialization of enum 'Primaries'.
    SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QColorSpace_TypeF(),
        "Primaries",
        "2:PySide2.QtGui.QColorSpace.Primaries",
        "QColorSpace::Primaries");
    if (!SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], "Custom", (long) QColorSpace::Primaries::Custom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], "SRgb", (long) QColorSpace::Primaries::SRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], "AdobeRgb", (long) QColorSpace::Primaries::AdobeRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], "DciP3D65", (long) QColorSpace::Primaries::DciP3D65))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], "ProPhotoRgb", (long) QColorSpace::Primaries::ProPhotoRgb))
        return;
    // Register converter for enum 'QColorSpace::Primaries'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX],
            QColorSpace_Primaries_CppToPython_QColorSpace_Primaries);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QColorSpace_Primaries_PythonToCpp_QColorSpace_Primaries,
            is_QColorSpace_Primaries_PythonToCpp_QColorSpace_Primaries_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_PRIMARIES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QColorSpace::Primaries");
        Shiboken::Conversions::registerConverterName(converter, "Primaries");
    }
    // End of 'Primaries' enum.

    // Initialization of enum 'TransferFunction'.
    SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QColorSpace_TypeF(),
        "TransferFunction",
        "2:PySide2.QtGui.QColorSpace.TransferFunction",
        "QColorSpace::TransferFunction");
    if (!SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], "Custom", (long) QColorSpace::TransferFunction::Custom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], "Linear", (long) QColorSpace::TransferFunction::Linear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], "Gamma", (long) QColorSpace::TransferFunction::Gamma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], "SRgb", (long) QColorSpace::TransferFunction::SRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX],
        SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], "ProPhotoRgb", (long) QColorSpace::TransferFunction::ProPhotoRgb))
        return;
    // Register converter for enum 'QColorSpace::TransferFunction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX],
            QColorSpace_TransferFunction_CppToPython_QColorSpace_TransferFunction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QColorSpace_TransferFunction_PythonToCpp_QColorSpace_TransferFunction,
            is_QColorSpace_TransferFunction_PythonToCpp_QColorSpace_TransferFunction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_TRANSFERFUNCTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QColorSpace::TransferFunction");
        Shiboken::Conversions::registerConverterName(converter, "TransferFunction");
    }
    // End of 'TransferFunction' enum.

    qRegisterMetaType< ::QColorSpace >("QColorSpace");
    qRegisterMetaType< ::QColorSpace::NamedColorSpace >("QColorSpace::NamedColorSpace");
    qRegisterMetaType< ::QColorSpace::Primaries >("QColorSpace::Primaries");
    qRegisterMetaType< ::QColorSpace::TransferFunction >("QColorSpace::TransferFunction");
}
