/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qconicalgradient_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <qobject.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QConicalGradient_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QConicalGradient >()))
        return -1;

    ::QConicalGradient *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QConicalGradient.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QConicalGradient", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QConicalGradient::QConicalGradient()
    // 1: QConicalGradient::QConicalGradient(QConicalGradient)
    // 2: QConicalGradient::QConicalGradient(QPointF,qreal)
    // 3: QConicalGradient::QConicalGradient(qreal,qreal,qreal)
    if (numArgs == 0) {
        overloadId = 0; // QConicalGradient()
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        overloadId = 3; // QConicalGradient(qreal,qreal,qreal)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 2; // QConicalGradient(QPointF,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QConicalGradient(QConicalGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QConicalGradient_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QConicalGradient()
        {

            if (!PyErr_Occurred()) {
                // QConicalGradient()
                cptr = new ::QConicalGradient();
            }
            break;
        }
        case 1: // QConicalGradient(const QConicalGradient & QConicalGradient)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QConicalGradient cppArg0_local;
            ::QConicalGradient *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QConicalGradient(QConicalGradient)
                cptr = new ::QConicalGradient(*cppArg0);
            }
            break;
        }
        case 2: // QConicalGradient(const QPointF & center, qreal startAngle)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QConicalGradient(QPointF,qreal)
                cptr = new ::QConicalGradient(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QConicalGradient(qreal cx, qreal cy, qreal startAngle)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QConicalGradient(qreal,qreal,qreal)
                cptr = new ::QConicalGradient(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QConicalGradient >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QConicalGradient_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QConicalGradient_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QConicalGradientFunc_angle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QConicalGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QConicalGradient.angle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // angle()const
            qreal cppResult = const_cast<const ::QConicalGradient *>(cppSelf)->angle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QConicalGradientFunc_center(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QConicalGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QConicalGradient.center";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // center()const
            QPointF cppResult = const_cast<const ::QConicalGradient *>(cppSelf)->center();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QConicalGradientFunc_setAngle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QConicalGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QConicalGradient.setAngle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QConicalGradient::setAngle(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setAngle(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QConicalGradientFunc_setAngle_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAngle(qreal)
            cppSelf->setAngle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QConicalGradientFunc_setAngle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QConicalGradientFunc_setCenter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QConicalGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QConicalGradient.setCenter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setCenter", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QConicalGradient::setCenter(QPointF)
    // 1: QConicalGradient::setCenter(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setCenter(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setCenter(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QConicalGradientFunc_setCenter_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setCenter(const QPointF & center)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setCenter(QPointF)
                cppSelf->setCenter(*cppArg0);
            }
            break;
        }
        case 1: // setCenter(qreal x, qreal y)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setCenter(qreal,qreal)
                cppSelf->setCenter(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QConicalGradientFunc_setCenter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QConicalGradient___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QConicalGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QConicalGradient_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QConicalGradient_methods[] = {
    {"angle", reinterpret_cast<PyCFunction>(Sbk_QConicalGradientFunc_angle), METH_NOARGS},
    {"center", reinterpret_cast<PyCFunction>(Sbk_QConicalGradientFunc_center), METH_NOARGS},
    {"setAngle", reinterpret_cast<PyCFunction>(Sbk_QConicalGradientFunc_setAngle), METH_O},
    {"setCenter", reinterpret_cast<PyCFunction>(Sbk_QConicalGradientFunc_setCenter), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QConicalGradient___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QConicalGradient_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QConicalGradient_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QConicalGradient_Type = nullptr;
static SbkObjectType *Sbk_QConicalGradient_TypeF(void)
{
    return _Sbk_QConicalGradient_Type;
}

static PyType_Slot Sbk_QConicalGradient_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QConicalGradient_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QConicalGradient_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QConicalGradient_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QConicalGradient_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QConicalGradient_spec = {
    "2:PySide2.QtGui.QConicalGradient",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QConicalGradient_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QConicalGradient_PythonToCpp_QConicalGradient_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QConicalGradient_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QConicalGradient_PythonToCpp_QConicalGradient_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QConicalGradient_TypeF())))
        return QConicalGradient_PythonToCpp_QConicalGradient_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QConicalGradient_PTR_CppToPython_QConicalGradient(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QConicalGradient *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QConicalGradient_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QConicalGradient_COPY_CppToPython_QConicalGradient(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QConicalGradient_TypeF(), new ::QConicalGradient(*reinterpret_cast<const ::QConicalGradient *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QConicalGradient_PythonToCpp_QConicalGradient_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QConicalGradient *>(cppOut) = *reinterpret_cast< ::QConicalGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QConicalGradient_PythonToCpp_QConicalGradient_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QConicalGradient_TypeF())))
        return QConicalGradient_PythonToCpp_QConicalGradient_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QConicalGradient_SignatureStrings[] = {
    "3:PySide2.QtGui.QConicalGradient(self)",
    "2:PySide2.QtGui.QConicalGradient(self,QConicalGradient:PySide2.QtGui.QConicalGradient)",
    "1:PySide2.QtGui.QConicalGradient(self,center:PySide2.QtCore.QPointF,startAngle:qreal)",
    "0:PySide2.QtGui.QConicalGradient(self,cx:qreal,cy:qreal,startAngle:qreal)",
    "PySide2.QtGui.QConicalGradient.angle(self)->qreal",
    "PySide2.QtGui.QConicalGradient.center(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QConicalGradient.setAngle(self,angle:qreal)",
    "1:PySide2.QtGui.QConicalGradient.setCenter(self,center:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QConicalGradient.setCenter(self,x:qreal,y:qreal)",
    "PySide2.QtGui.QConicalGradient.__copy__()",
    nullptr}; // Sentinel

void init_QConicalGradient(PyObject *module)
{
    _Sbk_QConicalGradient_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QConicalGradient",
        "QConicalGradient",
        &Sbk_QConicalGradient_spec,
        &Shiboken::callCppDestructor< ::QConicalGradient >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QConicalGradient_Type);
    InitSignatureStrings(pyType, QConicalGradient_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QConicalGradient_Type), Sbk_QConicalGradient_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QCONICALGRADIENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QConicalGradient_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QConicalGradient_TypeF(),
        QConicalGradient_PythonToCpp_QConicalGradient_PTR,
        is_QConicalGradient_PythonToCpp_QConicalGradient_PTR_Convertible,
        QConicalGradient_PTR_CppToPython_QConicalGradient,
        QConicalGradient_COPY_CppToPython_QConicalGradient);

    Shiboken::Conversions::registerConverterName(converter, "QConicalGradient");
    Shiboken::Conversions::registerConverterName(converter, "QConicalGradient*");
    Shiboken::Conversions::registerConverterName(converter, "QConicalGradient&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QConicalGradient).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QConicalGradient_PythonToCpp_QConicalGradient_COPY,
        is_QConicalGradient_PythonToCpp_QConicalGradient_COPY_Convertible);

    qRegisterMetaType< ::QConicalGradient >("QConicalGradient");
}
