/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qfont_wrapper.h"

// inner classes

// Extra includes
#include <QStringList>
#include <QtGui/qfont.h>
#include <QtGui/qpaintdevice.h>
#include <qdatastream.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFont_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFont >()))
        return -1;

    ::QFont *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFont_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QFont", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QFont::QFont()
    // 1: QFont::QFont(QFont)
    // 2: QFont::QFont(QFont,QPaintDevice*)
    // 3: QFont::QFont(QFont,const QPaintDevice*)
    // 4: QFont::QFont(QString,int,int,bool)
    if (numArgs == 0) {
        overloadId = 0; // QFont()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // QFont(QString,int,int,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QFont(QString,int,int,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 4; // QFont(QString,int,int,bool)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
                    overloadId = 4; // QFont(QString,int,int,bool)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QFont(QFont)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QFont(QFont,QPaintDevice*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFont_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFont()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFont_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QFont()
                cptr = new ::QFont();
            }
            break;
        }
        case 1: // QFont(const QFont & font)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFont_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFont(QFont)
                cptr = new ::QFont(*cppArg0);
            }
            break;
        }
        case 2: // QFont(const QFont & font, QPaintDevice * pd)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFont_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPaintDevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFont(QFont,QPaintDevice*)
                cptr = new ::QFont(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QFont(const QFont & font, const QPaintDevice * pd)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFont_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPaintDevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFont(QFont,const QPaintDevice*)
                cptr = new ::QFont(*cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QFont(const QString & family, int pointSize, int weight, bool italic)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pointSize = Shiboken::String::createStaticString("pointSize");
                if (PyDict_Contains(kwds, key_pointSize)) {
                    value = PyDict_GetItem(kwds, key_pointSize);
                    if (value && pyArgs[1]) {
                        errInfo = key_pointSize;
                        Py_INCREF(errInfo);
                        goto Sbk_QFont_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QFont_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pointSize);
                }
                static PyObject *const key_weight = Shiboken::String::createStaticString("weight");
                if (PyDict_Contains(kwds, key_weight)) {
                    value = PyDict_GetItem(kwds, key_weight);
                    if (value && pyArgs[2]) {
                        errInfo = key_weight;
                        Py_INCREF(errInfo);
                        goto Sbk_QFont_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QFont_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_weight);
                }
                static PyObject *const key_italic = Shiboken::String::createStaticString("italic");
                if (PyDict_Contains(kwds, key_italic)) {
                    value = PyDict_GetItem(kwds, key_italic);
                    if (value && pyArgs[3]) {
                        errInfo = key_italic;
                        Py_INCREF(errInfo);
                        goto Sbk_QFont_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3]))))
                            goto Sbk_QFont_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_italic);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFont_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            bool cppArg3 = false;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QFont(QString,int,int,bool)
                cptr = new ::QFont(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFont >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFont_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFont_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFontFunc_bold(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.bold";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bold()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->bold();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_cacheStatistics(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.cacheStatistics";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cacheStatistics()
            ::QFont::cacheStatistics();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFontFunc_capitalization(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.capitalization";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capitalization()const
            QFont::Capitalization cppResult = const_cast<const ::QFont *>(cppSelf)->capitalization();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_cleanup(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.cleanup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cleanup()
            ::QFont::cleanup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFontFunc_defaultFamily(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.defaultFamily";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFamily()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->defaultFamily();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_exactMatch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.exactMatch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exactMatch()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->exactMatch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_families(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.families";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // families()const
            QStringList cppResult = const_cast<const ::QFont *>(cppSelf)->families();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_family(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.family";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // family()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->family();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_fixedPitch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.fixedPitch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fixedPitch()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->fixedPitch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_fromString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.fromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::fromString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_fromString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromString(QString)
            bool cppResult = cppSelf->fromString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc_fromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_hintingPreference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.hintingPreference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hintingPreference()const
            QFont::HintingPreference cppResult = const_cast<const ::QFont *>(cppSelf)->hintingPreference();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_initialize(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.initialize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialize()
            ::QFont::initialize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFontFunc_insertSubstitution(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.insertSubstitution";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertSubstitution", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QFont::insertSubstitution(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // insertSubstitution(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_insertSubstitution_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertSubstitution(QString,QString)
            ::QFont::insertSubstitution(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_insertSubstitution_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_insertSubstitutions(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.insertSubstitutions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertSubstitutions", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QFont::insertSubstitutions(QString,QStringList)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
        overloadId = 0; // insertSubstitutions(QString,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_insertSubstitutions_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertSubstitutions(QString,QStringList)
            ::QFont::insertSubstitutions(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_insertSubstitutions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_isCopyOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.isCopyOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::isCopyOf(QFont)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // isCopyOf(QFont)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_isCopyOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isCopyOf(QFont)const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->isCopyOf(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc_isCopyOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_italic(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.italic";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // italic()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->italic();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_kerning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.kerning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // kerning()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->kerning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.key";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // key()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->key();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_lastResortFamily(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.lastResortFamily";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastResortFamily()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->lastResortFamily();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_lastResortFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.lastResortFont";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastResortFont()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->lastResortFont();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_letterSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.letterSpacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // letterSpacing()const
            qreal cppResult = const_cast<const ::QFont *>(cppSelf)->letterSpacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_letterSpacingType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.letterSpacingType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // letterSpacingType()const
            QFont::SpacingType cppResult = const_cast<const ::QFont *>(cppSelf)->letterSpacingType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_overline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.overline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overline()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->overline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_pixelSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.pixelSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelSize()const
            int cppResult = const_cast<const ::QFont *>(cppSelf)->pixelSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_pointSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.pointSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pointSize()const
            int cppResult = const_cast<const ::QFont *>(cppSelf)->pointSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_pointSizeF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.pointSizeF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pointSizeF()const
            qreal cppResult = const_cast<const ::QFont *>(cppSelf)->pointSizeF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_rawMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.rawMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rawMode()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->rawMode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_rawName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.rawName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rawName()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->rawName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_removeSubstitutions(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.removeSubstitutions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFont::removeSubstitutions(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeSubstitutions(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_removeSubstitutions_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeSubstitutions(QString)
            ::QFont::removeSubstitutions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_removeSubstitutions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_resolve(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.resolve";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "resolve", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFont::resolve()const
    // 1: QFont::resolve(QFont)const
    // 2: QFont::resolve(uint)
    if (numArgs == 0) {
        overloadId = 0; // resolve()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 2; // resolve(uint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // resolve(QFont)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_resolve_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // resolve() const
        {

            if (!PyErr_Occurred()) {
                // resolve()const
                uint cppResult = const_cast<const ::QFont *>(cppSelf)->resolve();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
            }
            break;
        }
        case 1: // resolve(const QFont & arg__1) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // resolve(QFont)const
                QFont cppResult = const_cast<const ::QFont *>(cppSelf)->resolve(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
            }
            break;
        }
        case 2: // resolve(uint mask)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // resolve(uint)
                cppSelf->resolve(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc_resolve_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setBold(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setBold";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setBold(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setBold(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setBold_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBold(bool)
            cppSelf->setBold(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setBold_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setCapitalization(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setCapitalization";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setCapitalization(QFont::Capitalization)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCapitalization(QFont::Capitalization)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setCapitalization_TypeError;

    // Call function/method
    {
        ::QFont::Capitalization cppArg0{QFont::MixedCase};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCapitalization(QFont::Capitalization)
            cppSelf->setCapitalization(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setCapitalization_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setFamilies(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setFamilies";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setFamilies(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setFamilies(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setFamilies_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFamilies(QStringList)
            cppSelf->setFamilies(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setFamilies_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setFamily(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setFamily(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFamily(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setFamily_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFamily(QString)
            cppSelf->setFamily(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setFixedPitch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setFixedPitch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setFixedPitch(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFixedPitch(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setFixedPitch_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFixedPitch(bool)
            cppSelf->setFixedPitch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setFixedPitch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setHintingPreference(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setHintingPreference";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setHintingPreference(QFont::HintingPreference)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHintingPreference(QFont::HintingPreference)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setHintingPreference_TypeError;

    // Call function/method
    {
        ::QFont::HintingPreference cppArg0{QFont::PreferDefaultHinting};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHintingPreference(QFont::HintingPreference)
            cppSelf->setHintingPreference(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setHintingPreference_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setItalic(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setItalic";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setItalic(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setItalic(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setItalic_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItalic(bool)
            cppSelf->setItalic(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setItalic_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setKerning(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setKerning";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setKerning(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKerning(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setKerning_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKerning(bool)
            cppSelf->setKerning(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setKerning_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setLetterSpacing(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setLetterSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setLetterSpacing", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFont::setLetterSpacing(QFont::SpacingType,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // setLetterSpacing(QFont::SpacingType,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setLetterSpacing_TypeError;

    // Call function/method
    {
        ::QFont::SpacingType cppArg0{QFont::PercentageSpacing};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setLetterSpacing(QFont::SpacingType,qreal)
            cppSelf->setLetterSpacing(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setLetterSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setOverline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setOverline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setOverline(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOverline(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setOverline_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOverline(bool)
            cppSelf->setOverline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setOverline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setPixelSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setPixelSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setPixelSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPixelSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setPixelSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPixelSize(int)
            cppSelf->setPixelSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setPixelSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setPointSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setPointSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setPointSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPointSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setPointSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPointSize(int)
            cppSelf->setPointSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setPointSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setPointSizeF(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setPointSizeF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setPointSizeF(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPointSizeF(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setPointSizeF_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPointSizeF(qreal)
            cppSelf->setPointSizeF(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setPointSizeF_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setRawMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setRawMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setRawMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRawMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setRawMode_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRawMode(bool)
            cppSelf->setRawMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setRawMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setRawName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setRawName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setRawName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRawName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setRawName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRawName(QString)
            cppSelf->setRawName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setRawName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setStretch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setStretch(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStretch(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setStretch_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStretch(int)
            cppSelf->setStretch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setStrikeOut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setStrikeOut";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setStrikeOut(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStrikeOut(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setStrikeOut_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStrikeOut(bool)
            cppSelf->setStrikeOut(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setStrikeOut_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setStyle(QFont::Style)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStyle(QFont::Style)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setStyle_TypeError;

    // Call function/method
    {
        ::QFont::Style cppArg0{QFont::StyleNormal};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyle(QFont::Style)
            cppSelf->setStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setStyleHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setStyleHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontFunc_setStyleHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontFunc_setStyleHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setStyleHint", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFont::setStyleHint(QFont::StyleHint,QFont::StyleStrategy)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setStyleHint(QFont::StyleHint,QFont::StyleStrategy)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setStyleHint(QFont::StyleHint,QFont::StyleStrategy)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setStyleHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_strategy = Shiboken::String::createStaticString("strategy");
            if (PyDict_Contains(kwds, key_strategy)) {
                value = PyDict_GetItem(kwds, key_strategy);
                if (value && pyArgs[1]) {
                    errInfo = key_strategy;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontFunc_setStyleHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QFontFunc_setStyleHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_strategy);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontFunc_setStyleHint_TypeError;
            }
        }
        ::QFont::StyleHint cppArg0{QFont::SansSerif};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFont::StyleStrategy cppArg1 = QFont::StyleStrategy::PreferDefault;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setStyleHint(QFont::StyleHint,QFont::StyleStrategy)
            cppSelf->setStyleHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setStyleHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setStyleName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setStyleName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setStyleName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setStyleName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setStyleName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyleName(QString)
            cppSelf->setStyleName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setStyleName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setStyleStrategy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setStyleStrategy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setStyleStrategy(QFont::StyleStrategy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStyleStrategy(QFont::StyleStrategy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setStyleStrategy_TypeError;

    // Call function/method
    {
        ::QFont::StyleStrategy cppArg0 = static_cast< ::QFont::StyleStrategy>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyleStrategy(QFont::StyleStrategy)
            cppSelf->setStyleStrategy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setStyleStrategy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setUnderline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setUnderline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setUnderline(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUnderline(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setUnderline_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUnderline(bool)
            cppSelf->setUnderline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setUnderline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setWeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setWeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setWeight(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWeight(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setWeight_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWeight(int)
            cppSelf->setWeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setWeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_setWordSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.setWordSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::setWordSpacing(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setWordSpacing(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_setWordSpacing_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWordSpacing(qreal)
            cppSelf->setWordSpacing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_setWordSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_stretch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.stretch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stretch()const
            int cppResult = const_cast<const ::QFont *>(cppSelf)->stretch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_strikeOut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.strikeOut";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // strikeOut()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->strikeOut();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            QFont::Style cppResult = const_cast<const ::QFont *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_styleHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.styleHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleHint()const
            QFont::StyleHint cppResult = const_cast<const ::QFont *>(cppSelf)->styleHint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_styleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.styleName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleName()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->styleName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_styleStrategy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.styleStrategy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleStrategy()const
            QFont::StyleStrategy cppResult = const_cast<const ::QFont *>(cppSelf)->styleStrategy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_substitute(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.substitute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFont::substitute(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // substitute(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_substitute_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // substitute(QString)
            QString cppResult = ::QFont::substitute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc_substitute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_substitutes(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.substitutes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFont::substitutes(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // substitutes(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_substitutes_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // substitutes(QString)
            QStringList cppResult = ::QFont::substitutes(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc_substitutes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_substitutions(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.substitutions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // substitutions()
            QStringList cppResult = ::QFont::substitutions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFont::swap(QFont&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QFont&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QFont&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QFont *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_underline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.underline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underline()const
            bool cppResult = const_cast<const ::QFont *>(cppSelf)->underline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_weight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.weight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // weight()const
            int cppResult = const_cast<const ::QFont *>(cppSelf)->weight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontFunc_wordSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.wordSpacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wordSpacing()const
            qreal cppResult = const_cast<const ::QFont *>(cppSelf)->wordSpacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFont___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFont_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFont_methods[] = {
    {"bold", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_bold), METH_NOARGS},
    {"cacheStatistics", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_cacheStatistics), METH_NOARGS|METH_STATIC},
    {"capitalization", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_capitalization), METH_NOARGS},
    {"cleanup", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_cleanup), METH_NOARGS|METH_STATIC},
    {"defaultFamily", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_defaultFamily), METH_NOARGS},
    {"exactMatch", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_exactMatch), METH_NOARGS},
    {"families", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_families), METH_NOARGS},
    {"family", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_family), METH_NOARGS},
    {"fixedPitch", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_fixedPitch), METH_NOARGS},
    {"fromString", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_fromString), METH_O},
    {"hintingPreference", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_hintingPreference), METH_NOARGS},
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_initialize), METH_NOARGS|METH_STATIC},
    {"insertSubstitution", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_insertSubstitution), METH_VARARGS|METH_STATIC},
    {"insertSubstitutions", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_insertSubstitutions), METH_VARARGS|METH_STATIC},
    {"isCopyOf", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_isCopyOf), METH_O},
    {"italic", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_italic), METH_NOARGS},
    {"kerning", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_kerning), METH_NOARGS},
    {"key", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_key), METH_NOARGS},
    {"lastResortFamily", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_lastResortFamily), METH_NOARGS},
    {"lastResortFont", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_lastResortFont), METH_NOARGS},
    {"letterSpacing", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_letterSpacing), METH_NOARGS},
    {"letterSpacingType", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_letterSpacingType), METH_NOARGS},
    {"overline", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_overline), METH_NOARGS},
    {"pixelSize", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_pixelSize), METH_NOARGS},
    {"pointSize", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_pointSize), METH_NOARGS},
    {"pointSizeF", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_pointSizeF), METH_NOARGS},
    {"rawMode", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_rawMode), METH_NOARGS},
    {"rawName", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_rawName), METH_NOARGS},
    {"removeSubstitutions", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_removeSubstitutions), METH_O|METH_STATIC},
    {"resolve", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_resolve), METH_VARARGS},
    {"setBold", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setBold), METH_O},
    {"setCapitalization", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setCapitalization), METH_O},
    {"setFamilies", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setFamilies), METH_O},
    {"setFamily", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setFamily), METH_O},
    {"setFixedPitch", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setFixedPitch), METH_O},
    {"setHintingPreference", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setHintingPreference), METH_O},
    {"setItalic", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setItalic), METH_O},
    {"setKerning", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setKerning), METH_O},
    {"setLetterSpacing", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setLetterSpacing), METH_VARARGS},
    {"setOverline", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setOverline), METH_O},
    {"setPixelSize", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setPixelSize), METH_O},
    {"setPointSize", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setPointSize), METH_O},
    {"setPointSizeF", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setPointSizeF), METH_O},
    {"setRawMode", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setRawMode), METH_O},
    {"setRawName", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setRawName), METH_O},
    {"setStretch", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setStretch), METH_O},
    {"setStrikeOut", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setStrikeOut), METH_O},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setStyle), METH_O},
    {"setStyleHint", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setStyleHint), METH_VARARGS|METH_KEYWORDS},
    {"setStyleName", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setStyleName), METH_O},
    {"setStyleStrategy", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setStyleStrategy), METH_O},
    {"setUnderline", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setUnderline), METH_O},
    {"setWeight", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setWeight), METH_O},
    {"setWordSpacing", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_setWordSpacing), METH_O},
    {"stretch", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_stretch), METH_NOARGS},
    {"strikeOut", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_strikeOut), METH_NOARGS},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_style), METH_NOARGS},
    {"styleHint", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_styleHint), METH_NOARGS},
    {"styleName", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_styleName), METH_NOARGS},
    {"styleStrategy", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_styleStrategy), METH_NOARGS},
    {"substitute", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_substitute), METH_O|METH_STATIC},
    {"substitutes", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_substitutes), METH_O|METH_STATIC},
    {"substitutions", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_substitutions), METH_NOARGS|METH_STATIC},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_swap), METH_O},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_toString), METH_NOARGS},
    {"underline", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_underline), METH_NOARGS},
    {"weight", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_weight), METH_NOARGS},
    {"wordSpacing", reinterpret_cast<PyCFunction>(Sbk_QFontFunc_wordSpacing), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFont___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QFontFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QFont::operator<<(QDataStream&,QFont)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QFont)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QFontFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QFont) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFont.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QFont::operator>>(QDataStream&,QFont&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QFont&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QFontFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QFont&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QFont_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
                // operator!=(const QFont & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFont cppArg0_local;
                ::QFont *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
                // operator<(const QFont & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFont cppArg0_local;
                ::QFont *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QFont_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
                // operator==(const QFont & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFont cppArg0_local;
                ::QFont *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QFont_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QFont_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QFont_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFont_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QFont__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFont_Type = nullptr;
static SbkObjectType *Sbk_QFont_TypeF(void)
{
    return _Sbk_QFont_Type;
}

static PyType_Slot Sbk_QFont_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QFont__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFont_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFont_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QFont_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFont_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFont_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QFontFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QFontFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QFont_spec = {
    "2:PySide2.QtGui.QFont",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFont_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QFont_StyleHint_PythonToCpp_QFont_StyleHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::StyleHint *>(cppOut) =
        static_cast<::QFont::StyleHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_StyleHint_PythonToCpp_QFont_StyleHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX]))
        return QFont_StyleHint_PythonToCpp_QFont_StyleHint;
    return {};
}
static PyObject *QFont_StyleHint_CppToPython_QFont_StyleHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::StyleHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX], castCppIn);

}

static void QFont_StyleStrategy_PythonToCpp_QFont_StyleStrategy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::StyleStrategy *>(cppOut) =
        static_cast<::QFont::StyleStrategy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_StyleStrategy_PythonToCpp_QFont_StyleStrategy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX]))
        return QFont_StyleStrategy_PythonToCpp_QFont_StyleStrategy;
    return {};
}
static PyObject *QFont_StyleStrategy_CppToPython_QFont_StyleStrategy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::StyleStrategy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX], castCppIn);

}

static void QFont_HintingPreference_PythonToCpp_QFont_HintingPreference(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::HintingPreference *>(cppOut) =
        static_cast<::QFont::HintingPreference>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_HintingPreference_PythonToCpp_QFont_HintingPreference_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX]))
        return QFont_HintingPreference_PythonToCpp_QFont_HintingPreference;
    return {};
}
static PyObject *QFont_HintingPreference_CppToPython_QFont_HintingPreference(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::HintingPreference *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX], castCppIn);

}

static void QFont_Weight_PythonToCpp_QFont_Weight(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::Weight *>(cppOut) =
        static_cast<::QFont::Weight>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_Weight_PythonToCpp_QFont_Weight_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX]))
        return QFont_Weight_PythonToCpp_QFont_Weight;
    return {};
}
static PyObject *QFont_Weight_CppToPython_QFont_Weight(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::Weight *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX], castCppIn);

}

static void QFont_Style_PythonToCpp_QFont_Style(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::Style *>(cppOut) =
        static_cast<::QFont::Style>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_Style_PythonToCpp_QFont_Style_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX]))
        return QFont_Style_PythonToCpp_QFont_Style;
    return {};
}
static PyObject *QFont_Style_CppToPython_QFont_Style(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::Style *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX], castCppIn);

}

static void QFont_Stretch_PythonToCpp_QFont_Stretch(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::Stretch *>(cppOut) =
        static_cast<::QFont::Stretch>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_Stretch_PythonToCpp_QFont_Stretch_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX]))
        return QFont_Stretch_PythonToCpp_QFont_Stretch;
    return {};
}
static PyObject *QFont_Stretch_CppToPython_QFont_Stretch(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::Stretch *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX], castCppIn);

}

static void QFont_Capitalization_PythonToCpp_QFont_Capitalization(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::Capitalization *>(cppOut) =
        static_cast<::QFont::Capitalization>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_Capitalization_PythonToCpp_QFont_Capitalization_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX]))
        return QFont_Capitalization_PythonToCpp_QFont_Capitalization;
    return {};
}
static PyObject *QFont_Capitalization_CppToPython_QFont_Capitalization(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::Capitalization *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX], castCppIn);

}

static void QFont_SpacingType_PythonToCpp_QFont_SpacingType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont::SpacingType *>(cppOut) =
        static_cast<::QFont::SpacingType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFont_SpacingType_PythonToCpp_QFont_SpacingType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX]))
        return QFont_SpacingType_PythonToCpp_QFont_SpacingType;
    return {};
}
static PyObject *QFont_SpacingType_CppToPython_QFont_SpacingType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFont::SpacingType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFont_PythonToCpp_QFont_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFont_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFont_PythonToCpp_QFont_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFont_TypeF())))
        return QFont_PythonToCpp_QFont_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFont_PTR_CppToPython_QFont(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFont *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFont_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFont_COPY_CppToPython_QFont(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFont_TypeF(), new ::QFont(*reinterpret_cast<const ::QFont *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFont_PythonToCpp_QFont_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFont *>(cppOut) = *reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFont_PythonToCpp_QFont_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFont_TypeF())))
        return QFont_PythonToCpp_QFont_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQStringREF_PythonToCpp_QFont(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QFont *>(cppOut) = ::QFont(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QFont_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QFont;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFont_SignatureStrings[] = {
    "4:PySide2.QtGui.QFont(self)",
    "3:PySide2.QtGui.QFont(self,font:PySide2.QtGui.QFont)",
    "2:PySide2.QtGui.QFont(self,font:PySide2.QtGui.QFont,pd:PySide2.QtGui.QPaintDevice)",
    "1:PySide2.QtGui.QFont(self,font:PySide2.QtGui.QFont,pd:PySide2.QtGui.QPaintDevice)",
    "0:PySide2.QtGui.QFont(self,family:QString,pointSize:int=-1,weight:int=-1,italic:bool=false)",
    "PySide2.QtGui.QFont.bold(self)->bool",
    "PySide2.QtGui.QFont.cacheStatistics()",
    "PySide2.QtGui.QFont.capitalization(self)->PySide2.QtGui.QFont.Capitalization",
    "PySide2.QtGui.QFont.cleanup()",
    "PySide2.QtGui.QFont.defaultFamily(self)->QString",
    "PySide2.QtGui.QFont.exactMatch(self)->bool",
    "PySide2.QtGui.QFont.families(self)->QStringList",
    "PySide2.QtGui.QFont.family(self)->QString",
    "PySide2.QtGui.QFont.fixedPitch(self)->bool",
    "PySide2.QtGui.QFont.fromString(self,arg__1:QString)->bool",
    "PySide2.QtGui.QFont.hintingPreference(self)->PySide2.QtGui.QFont.HintingPreference",
    "PySide2.QtGui.QFont.initialize()",
    "PySide2.QtGui.QFont.insertSubstitution(arg__1:QString,arg__2:QString)",
    "PySide2.QtGui.QFont.insertSubstitutions(arg__1:QString,arg__2:QStringList)",
    "PySide2.QtGui.QFont.isCopyOf(self,arg__1:PySide2.QtGui.QFont)->bool",
    "PySide2.QtGui.QFont.italic(self)->bool",
    "PySide2.QtGui.QFont.kerning(self)->bool",
    "PySide2.QtGui.QFont.key(self)->QString",
    "PySide2.QtGui.QFont.lastResortFamily(self)->QString",
    "PySide2.QtGui.QFont.lastResortFont(self)->QString",
    "PySide2.QtGui.QFont.letterSpacing(self)->qreal",
    "PySide2.QtGui.QFont.letterSpacingType(self)->PySide2.QtGui.QFont.SpacingType",
    "PySide2.QtGui.QFont.overline(self)->bool",
    "PySide2.QtGui.QFont.pixelSize(self)->int",
    "PySide2.QtGui.QFont.pointSize(self)->int",
    "PySide2.QtGui.QFont.pointSizeF(self)->qreal",
    "PySide2.QtGui.QFont.rawMode(self)->bool",
    "PySide2.QtGui.QFont.rawName(self)->QString",
    "PySide2.QtGui.QFont.removeSubstitutions(arg__1:QString)",
    "2:PySide2.QtGui.QFont.resolve(self)->uint",
    "1:PySide2.QtGui.QFont.resolve(self,arg__1:PySide2.QtGui.QFont)->PySide2.QtGui.QFont",
    "0:PySide2.QtGui.QFont.resolve(self,mask:uint)",
    "PySide2.QtGui.QFont.setBold(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setCapitalization(self,arg__1:PySide2.QtGui.QFont.Capitalization)",
    "PySide2.QtGui.QFont.setFamilies(self,arg__1:QStringList)",
    "PySide2.QtGui.QFont.setFamily(self,arg__1:QString)",
    "PySide2.QtGui.QFont.setFixedPitch(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setHintingPreference(self,hintingPreference:PySide2.QtGui.QFont.HintingPreference)",
    "PySide2.QtGui.QFont.setItalic(self,b:bool)",
    "PySide2.QtGui.QFont.setKerning(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setLetterSpacing(self,type:PySide2.QtGui.QFont.SpacingType,spacing:qreal)",
    "PySide2.QtGui.QFont.setOverline(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setPixelSize(self,arg__1:int)",
    "PySide2.QtGui.QFont.setPointSize(self,arg__1:int)",
    "PySide2.QtGui.QFont.setPointSizeF(self,arg__1:qreal)",
    "PySide2.QtGui.QFont.setRawMode(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setRawName(self,arg__1:QString)",
    "PySide2.QtGui.QFont.setStretch(self,arg__1:int)",
    "PySide2.QtGui.QFont.setStrikeOut(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setStyle(self,style:PySide2.QtGui.QFont.Style)",
    "PySide2.QtGui.QFont.setStyleHint(self,arg__1:PySide2.QtGui.QFont.StyleHint,strategy:PySide2.QtGui.QFont.StyleStrategy=PreferDefault)",
    "PySide2.QtGui.QFont.setStyleName(self,arg__1:QString)",
    "PySide2.QtGui.QFont.setStyleStrategy(self,s:PySide2.QtGui.QFont.StyleStrategy)",
    "PySide2.QtGui.QFont.setUnderline(self,arg__1:bool)",
    "PySide2.QtGui.QFont.setWeight(self,arg__1:int)",
    "PySide2.QtGui.QFont.setWordSpacing(self,spacing:qreal)",
    "PySide2.QtGui.QFont.stretch(self)->int",
    "PySide2.QtGui.QFont.strikeOut(self)->bool",
    "PySide2.QtGui.QFont.style(self)->PySide2.QtGui.QFont.Style",
    "PySide2.QtGui.QFont.styleHint(self)->PySide2.QtGui.QFont.StyleHint",
    "PySide2.QtGui.QFont.styleName(self)->QString",
    "PySide2.QtGui.QFont.styleStrategy(self)->PySide2.QtGui.QFont.StyleStrategy",
    "PySide2.QtGui.QFont.substitute(arg__1:QString)->QString",
    "PySide2.QtGui.QFont.substitutes(arg__1:QString)->QStringList",
    "PySide2.QtGui.QFont.substitutions()->QStringList",
    "PySide2.QtGui.QFont.swap(self,other:PySide2.QtGui.QFont)",
    "PySide2.QtGui.QFont.toString(self)->QString",
    "PySide2.QtGui.QFont.underline(self)->bool",
    "PySide2.QtGui.QFont.weight(self)->int",
    "PySide2.QtGui.QFont.wordSpacing(self)->qreal",
    "PySide2.QtGui.QFont.__copy__()",
    "PySide2.QtGui.QFont.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QFont.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QFont(PyObject *module)
{
    _Sbk_QFont_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFont",
        "QFont",
        &Sbk_QFont_spec,
        &Shiboken::callCppDestructor< ::QFont >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFont_Type);
    InitSignatureStrings(pyType, QFont_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFont_Type), Sbk_QFont_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFont_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFont_TypeF(),
        QFont_PythonToCpp_QFont_PTR,
        is_QFont_PythonToCpp_QFont_PTR_Convertible,
        QFont_PTR_CppToPython_QFont,
        QFont_COPY_CppToPython_QFont);

    Shiboken::Conversions::registerConverterName(converter, "QFont");
    Shiboken::Conversions::registerConverterName(converter, "QFont*");
    Shiboken::Conversions::registerConverterName(converter, "QFont&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFont).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFont_PythonToCpp_QFont_COPY,
        is_QFont_PythonToCpp_QFont_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QFont,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QFont_Convertible);

    // Initialization of enums.

    // Initialization of enum 'StyleHint'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "StyleHint",
        "2:PySide2.QtGui.QFont.StyleHint",
        "QFont::StyleHint");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Helvetica", (long) QFont::StyleHint::Helvetica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "SansSerif", (long) QFont::StyleHint::SansSerif))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Times", (long) QFont::StyleHint::Times))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Serif", (long) QFont::StyleHint::Serif))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Courier", (long) QFont::StyleHint::Courier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "TypeWriter", (long) QFont::StyleHint::TypeWriter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "OldEnglish", (long) QFont::StyleHint::OldEnglish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Decorative", (long) QFont::StyleHint::Decorative))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "System", (long) QFont::StyleHint::System))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "AnyStyle", (long) QFont::StyleHint::AnyStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Cursive", (long) QFont::StyleHint::Cursive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Monospace", (long) QFont::StyleHint::Monospace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
        Sbk_QFont_TypeF(), "Fantasy", (long) QFont::StyleHint::Fantasy))
        return;
    // Register converter for enum 'QFont::StyleHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX],
            QFont_StyleHint_CppToPython_QFont_StyleHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_StyleHint_PythonToCpp_QFont_StyleHint,
            is_QFont_StyleHint_PythonToCpp_QFont_StyleHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::StyleHint");
        Shiboken::Conversions::registerConverterName(converter, "StyleHint");
    }
    // End of 'StyleHint' enum.

    // Initialization of enum 'StyleStrategy'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "StyleStrategy",
        "2:PySide2.QtGui.QFont.StyleStrategy",
        "QFont::StyleStrategy");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferDefault", (long) QFont::StyleStrategy::PreferDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferBitmap", (long) QFont::StyleStrategy::PreferBitmap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferDevice", (long) QFont::StyleStrategy::PreferDevice))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferOutline", (long) QFont::StyleStrategy::PreferOutline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "ForceOutline", (long) QFont::StyleStrategy::ForceOutline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferMatch", (long) QFont::StyleStrategy::PreferMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferQuality", (long) QFont::StyleStrategy::PreferQuality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferAntialias", (long) QFont::StyleStrategy::PreferAntialias))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "NoAntialias", (long) QFont::StyleStrategy::NoAntialias))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "OpenGLCompatible", (long) QFont::StyleStrategy::OpenGLCompatible))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "ForceIntegerMetrics", (long) QFont::StyleStrategy::ForceIntegerMetrics))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "NoSubpixelAntialias", (long) QFont::StyleStrategy::NoSubpixelAntialias))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "PreferNoShaping", (long) QFont::StyleStrategy::PreferNoShaping))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
        Sbk_QFont_TypeF(), "NoFontMerging", (long) QFont::StyleStrategy::NoFontMerging))
        return;
    // Register converter for enum 'QFont::StyleStrategy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX],
            QFont_StyleStrategy_CppToPython_QFont_StyleStrategy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_StyleStrategy_PythonToCpp_QFont_StyleStrategy,
            is_QFont_StyleStrategy_PythonToCpp_QFont_StyleStrategy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::StyleStrategy");
        Shiboken::Conversions::registerConverterName(converter, "StyleStrategy");
    }
    // End of 'StyleStrategy' enum.

    // Initialization of enum 'HintingPreference'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "HintingPreference",
        "2:PySide2.QtGui.QFont.HintingPreference",
        "QFont::HintingPreference");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX],
        Sbk_QFont_TypeF(), "PreferDefaultHinting", (long) QFont::HintingPreference::PreferDefaultHinting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX],
        Sbk_QFont_TypeF(), "PreferNoHinting", (long) QFont::HintingPreference::PreferNoHinting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX],
        Sbk_QFont_TypeF(), "PreferVerticalHinting", (long) QFont::HintingPreference::PreferVerticalHinting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX],
        Sbk_QFont_TypeF(), "PreferFullHinting", (long) QFont::HintingPreference::PreferFullHinting))
        return;
    // Register converter for enum 'QFont::HintingPreference'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX],
            QFont_HintingPreference_CppToPython_QFont_HintingPreference);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_HintingPreference_PythonToCpp_QFont_HintingPreference,
            is_QFont_HintingPreference_PythonToCpp_QFont_HintingPreference_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::HintingPreference");
        Shiboken::Conversions::registerConverterName(converter, "HintingPreference");
    }
    // End of 'HintingPreference' enum.

    // Initialization of enum 'Weight'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "Weight",
        "2:PySide2.QtGui.QFont.Weight",
        "QFont::Weight");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "Thin", (long) QFont::Weight::Thin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "ExtraLight", (long) QFont::Weight::ExtraLight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "Light", (long) QFont::Weight::Light))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "Normal", (long) QFont::Weight::Normal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "Medium", (long) QFont::Weight::Medium))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "DemiBold", (long) QFont::Weight::DemiBold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "Bold", (long) QFont::Weight::Bold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "ExtraBold", (long) QFont::Weight::ExtraBold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
        Sbk_QFont_TypeF(), "Black", (long) QFont::Weight::Black))
        return;
    // Register converter for enum 'QFont::Weight'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX],
            QFont_Weight_CppToPython_QFont_Weight);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_Weight_PythonToCpp_QFont_Weight,
            is_QFont_Weight_PythonToCpp_QFont_Weight_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_WEIGHT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::Weight");
        Shiboken::Conversions::registerConverterName(converter, "Weight");
    }
    // End of 'Weight' enum.

    // Initialization of enum 'Style'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "Style",
        "2:PySide2.QtGui.QFont.Style",
        "QFont::Style");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX],
        Sbk_QFont_TypeF(), "StyleNormal", (long) QFont::Style::StyleNormal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX],
        Sbk_QFont_TypeF(), "StyleItalic", (long) QFont::Style::StyleItalic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX],
        Sbk_QFont_TypeF(), "StyleOblique", (long) QFont::Style::StyleOblique))
        return;
    // Register converter for enum 'QFont::Style'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX],
            QFont_Style_CppToPython_QFont_Style);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_Style_PythonToCpp_QFont_Style,
            is_QFont_Style_PythonToCpp_QFont_Style_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::Style");
        Shiboken::Conversions::registerConverterName(converter, "Style");
    }
    // End of 'Style' enum.

    // Initialization of enum 'Stretch'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "Stretch",
        "2:PySide2.QtGui.QFont.Stretch",
        "QFont::Stretch");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "AnyStretch", (long) QFont::Stretch::AnyStretch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "UltraCondensed", (long) QFont::Stretch::UltraCondensed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "ExtraCondensed", (long) QFont::Stretch::ExtraCondensed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "Condensed", (long) QFont::Stretch::Condensed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "SemiCondensed", (long) QFont::Stretch::SemiCondensed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "Unstretched", (long) QFont::Stretch::Unstretched))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "SemiExpanded", (long) QFont::Stretch::SemiExpanded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "Expanded", (long) QFont::Stretch::Expanded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "ExtraExpanded", (long) QFont::Stretch::ExtraExpanded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
        Sbk_QFont_TypeF(), "UltraExpanded", (long) QFont::Stretch::UltraExpanded))
        return;
    // Register converter for enum 'QFont::Stretch'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX],
            QFont_Stretch_CppToPython_QFont_Stretch);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_Stretch_PythonToCpp_QFont_Stretch,
            is_QFont_Stretch_PythonToCpp_QFont_Stretch_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_STRETCH_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::Stretch");
        Shiboken::Conversions::registerConverterName(converter, "Stretch");
    }
    // End of 'Stretch' enum.

    // Initialization of enum 'Capitalization'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "Capitalization",
        "2:PySide2.QtGui.QFont.Capitalization",
        "QFont::Capitalization");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX],
        Sbk_QFont_TypeF(), "MixedCase", (long) QFont::Capitalization::MixedCase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX],
        Sbk_QFont_TypeF(), "AllUppercase", (long) QFont::Capitalization::AllUppercase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX],
        Sbk_QFont_TypeF(), "AllLowercase", (long) QFont::Capitalization::AllLowercase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX],
        Sbk_QFont_TypeF(), "SmallCaps", (long) QFont::Capitalization::SmallCaps))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX],
        Sbk_QFont_TypeF(), "Capitalize", (long) QFont::Capitalization::Capitalize))
        return;
    // Register converter for enum 'QFont::Capitalization'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX],
            QFont_Capitalization_CppToPython_QFont_Capitalization);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_Capitalization_PythonToCpp_QFont_Capitalization,
            is_QFont_Capitalization_PythonToCpp_QFont_Capitalization_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::Capitalization");
        Shiboken::Conversions::registerConverterName(converter, "Capitalization");
    }
    // End of 'Capitalization' enum.

    // Initialization of enum 'SpacingType'.
    SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFont_TypeF(),
        "SpacingType",
        "2:PySide2.QtGui.QFont.SpacingType",
        "QFont::SpacingType");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX],
        Sbk_QFont_TypeF(), "PercentageSpacing", (long) QFont::SpacingType::PercentageSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX],
        Sbk_QFont_TypeF(), "AbsoluteSpacing", (long) QFont::SpacingType::AbsoluteSpacing))
        return;
    // Register converter for enum 'QFont::SpacingType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX],
            QFont_SpacingType_CppToPython_QFont_SpacingType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFont_SpacingType_PythonToCpp_QFont_SpacingType,
            is_QFont_SpacingType_PythonToCpp_QFont_SpacingType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFont::SpacingType");
        Shiboken::Conversions::registerConverterName(converter, "SpacingType");
    }
    // End of 'SpacingType' enum.

    qRegisterMetaType< ::QFont >("QFont");
    qRegisterMetaType< ::QFont::StyleHint >("QFont::StyleHint");
    qRegisterMetaType< ::QFont::StyleStrategy >("QFont::StyleStrategy");
    qRegisterMetaType< ::QFont::HintingPreference >("QFont::HintingPreference");
    qRegisterMetaType< ::QFont::Weight >("QFont::Weight");
    qRegisterMetaType< ::QFont::Style >("QFont::Style");
    qRegisterMetaType< ::QFont::Stretch >("QFont::Stretch");
    qRegisterMetaType< ::QFont::Capitalization >("QFont::Capitalization");
    qRegisterMetaType< ::QFont::SpacingType >("QFont::SpacingType");
}
