/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qfontmetrics_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qfont.h>
#include <QtGui/qfontmetrics.h>
#include <QtGui/qpaintdevice.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFontMetrics_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFontMetrics >()))
        return -1;

    ::QFontMetrics *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFontMetrics", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QFontMetrics::QFontMetrics(QFont)
    // 1: QFontMetrics::QFontMetrics(QFont,QPaintDevice*)
    // 2: QFontMetrics::QFontMetrics(QFontMetrics)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QFontMetrics(QFontMetrics)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QFontMetrics(QFont)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QFontMetrics(QFont,QPaintDevice*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetrics_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFontMetrics(const QFont & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontMetrics(QFont)
                cptr = new ::QFontMetrics(*cppArg0);
            }
            break;
        }
        case 1: // QFontMetrics(const QFont & font, QPaintDevice * pd)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPaintDevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFontMetrics(QFont,QPaintDevice*)
                cptr = new ::QFontMetrics(*cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QFontMetrics(const QFontMetrics & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
            ::QFontMetrics *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontMetrics(QFontMetrics)
                cptr = new ::QFontMetrics(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFontMetrics >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFontMetrics_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFontMetrics_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFontMetricsFunc_ascent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.ascent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ascent()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->ascent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_averageCharWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.averageCharWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // averageCharWidth()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->averageCharWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_boundingRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.boundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 8) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOO:boundingRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetrics::boundingRect(QRect,int,QString,int,int*)const
    // 1: QFontMetrics::boundingRect(QString)const
    // 2: QFontMetrics::boundingRect(int,int,int,int,int,QString,int,int*)const
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 2; // boundingRect(int,int,int,int,int,QString,int,int*)const
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 2; // boundingRect(int,int,int,int,int,QString,int,int*)const
            } else if (numArgs >= 8) {
                overloadId = 2; // boundingRect(int,int,int,int,int,QString,int,int*)const
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // boundingRect(QString)const
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // boundingRect(QRect,int,QString,int,int*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // boundingRect(QRect,int,QString,int,int*)const
            } else if (numArgs >= 5) {
                overloadId = 0; // boundingRect(QRect,int,QString,int,int*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_boundingRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // boundingRect(const QRect & r, int flags, const QString & text, int tabstops, int * tabarray) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_tabstops = Shiboken::String::createStaticString("tabstops");
                if (PyDict_Contains(kwds, key_tabstops)) {
                    value = PyDict_GetItem(kwds, key_tabstops);
                    if (value && pyArgs[3]) {
                        errInfo = key_tabstops;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tabstops);
                }
                static PyObject *const key_tabarray = Shiboken::String::createStaticString("tabarray");
                if (PyDict_Contains(kwds, key_tabarray)) {
                    value = PyDict_GetItem(kwds, key_tabarray);
                    if (value && pyArgs[4]) {
                        errInfo = key_tabarray;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!PyObject_Check(pyArgs[4]))
                            goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tabarray);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // boundingRect(QRect,int,QString,int,int*)const
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qfontmetrics-boundingrect-2)]
                int *array = nullptr;
                bool errorOccurred = false;

                if (numArgs == 5) {
                    array = Shiboken::sequenceToIntArray(pyArgs[5-1], true);
                    if (PyErr_Occurred()) {
                        delete [] array;
                        errorOccurred = true;
                    }
                }

                if (!errorOccurred) {
                    ::QRect retval = cppSelf->boundingRect(*cppArg0, cppArg1, cppArg2, cppArg3, array);

                    delete [] array;

                    pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &retval);
                }
                // END of custom code block [file: ../glue/qtgui.cpp (qfontmetrics-boundingrect-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // boundingRect(const QString & text) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // boundingRect(QString)const
                QRect cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->boundingRect(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            }
            break;
        }
        case 2: // boundingRect(int x, int y, int w, int h, int flags, const QString & text, int tabstops, int * tabarray) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_tabstops = Shiboken::String::createStaticString("tabstops");
                if (PyDict_Contains(kwds, key_tabstops)) {
                    value = PyDict_GetItem(kwds, key_tabstops);
                    if (value && pyArgs[6]) {
                        errInfo = key_tabstops;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6]))))
                            goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tabstops);
                }
                static PyObject *const key_tabarray = Shiboken::String::createStaticString("tabarray");
                if (PyDict_Contains(kwds, key_tabarray)) {
                    value = PyDict_GetItem(kwds, key_tabarray);
                    if (value && pyArgs[7]) {
                        errInfo = key_tabarray;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!PyObject_Check(pyArgs[7]))
                            goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tabarray);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFontMetricsFunc_boundingRect_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6 = 0;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // boundingRect(int,int,int,int,int,QString,int,int*)const
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qfontmetrics-boundingrect-1)]
                int *array = nullptr;
                bool errorOccurred = false;

                if (numArgs == 8) {
                    array = Shiboken::sequenceToIntArray(pyArgs[8-1], true);
                    if (PyErr_Occurred()) {
                        delete [] array;
                        errorOccurred = true;
                    }
                }

                if (!errorOccurred) {
                    ::QRect retval = cppSelf->boundingRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, array);

                    delete [] array;

                    pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &retval);
                }
                // END of custom code block [file: ../glue/qtgui.cpp (qfontmetrics-boundingrect-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_boundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_boundingRectChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.boundingRectChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::boundingRect(QChar)const
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // boundingRect(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_boundingRectChar_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundingRect(QChar)const
            // Begin code injection
            // TEMPLATE - QFontCharFix - START
            int size = Shiboken::String::len(pyArg);
            if (size == 1) {
                const char *str = Shiboken::String::toCString(pyArg);
                QChar ch(str[0]);
                ::QRect cppResult = cppSelf->boundingRect(ch);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            } else {
                PyErr_SetString(PyExc_TypeError, "String must have only one character");
            }
            // TEMPLATE - QFontCharFix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_boundingRectChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_capHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.capHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capHeight()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->capHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_charWidth(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.charWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "charWidth", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetrics::charWidth(QString,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // charWidth(QString,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_charWidth_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // charWidth(QString,int)const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->charWidth(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_charWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_descent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.descent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // descent()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->descent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_elidedText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.elidedText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_elidedText_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_elidedText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:elidedText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetrics::elidedText(QString,Qt::TextElideMode,int,int)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // elidedText(QString,Qt::TextElideMode,int,int)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // elidedText(QString,Qt::TextElideMode,int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_elidedText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[3]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontMetricsFunc_elidedText_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QFontMetricsFunc_elidedText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontMetricsFunc_elidedText_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TextElideMode cppArg1{Qt::ElideLeft};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // elidedText(QString,Qt::TextElideMode,int,int)const
            QString cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->elidedText(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_elidedText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_fontDpi(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.fontDpi";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontDpi()const
            qreal cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->fontDpi();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_horizontalAdvance(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.horizontalAdvance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:horizontalAdvance", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetrics::horizontalAdvance(QChar)const
    // 1: QFontMetrics::horizontalAdvance(QString,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // horizontalAdvance(QString,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // horizontalAdvance(QString,int)const
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArgs[0])))) {
        overloadId = 0; // horizontalAdvance(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // horizontalAdvance(QChar arg__1) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;
            }
            ::QChar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // horizontalAdvance(QChar)const
                int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->horizontalAdvance(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // horizontalAdvance(const QString & arg__1, int len) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_len = Shiboken::String::createStaticString("len");
                if (PyDict_Contains(kwds, key_len)) {
                    value = PyDict_GetItem(kwds, key_len);
                    if (value && pyArgs[1]) {
                        errInfo = key_len;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_len);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFontMetricsFunc_horizontalAdvance_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // horizontalAdvance(QString,int)const
                int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->horizontalAdvance(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_horizontalAdvance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_inFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.inFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::inFont(QChar)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // inFont(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_inFont_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inFont(QChar)const
            bool cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->inFont(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_inFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_inFontUcs4(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.inFontUcs4";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::inFontUcs4(uint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // inFontUcs4(uint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_inFontUcs4_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inFontUcs4(uint)const
            bool cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->inFontUcs4(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_inFontUcs4_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_leading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.leading";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leading()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->leading();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_leftBearing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.leftBearing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::leftBearing(QChar)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // leftBearing(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_leftBearing_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // leftBearing(QChar)const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->leftBearing(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_leftBearing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_lineSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.lineSpacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineSpacing()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->lineSpacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_lineWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.lineWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineWidth()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->lineWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_maxWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.maxWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWidth()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->maxWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_minLeftBearing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.minLeftBearing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minLeftBearing()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->minLeftBearing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_minRightBearing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.minRightBearing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minRightBearing()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->minRightBearing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_overlinePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.overlinePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overlinePos()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->overlinePos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_rightBearing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.rightBearing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::rightBearing(QChar)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // rightBearing(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_rightBearing_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rightBearing(QChar)const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->rightBearing(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_rightBearing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_size(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.size";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_size_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_size_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:size", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetrics::size(int,QString,int,int*)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // size(int,QString,int,int*)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // size(int,QString,int,int*)const
            } else if (numArgs >= 4) {
                overloadId = 0; // size(int,QString,int,int*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_size_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_tabstops = Shiboken::String::createStaticString("tabstops");
            if (PyDict_Contains(kwds, key_tabstops)) {
                value = PyDict_GetItem(kwds, key_tabstops);
                if (value && pyArgs[2]) {
                    errInfo = key_tabstops;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontMetricsFunc_size_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QFontMetricsFunc_size_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tabstops);
            }
            static PyObject *const key_tabarray = Shiboken::String::createStaticString("tabarray");
            if (PyDict_Contains(kwds, key_tabarray)) {
                value = PyDict_GetItem(kwds, key_tabarray);
                if (value && pyArgs[3]) {
                    errInfo = key_tabarray;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontMetricsFunc_size_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!PyObject_Check(pyArgs[3]))
                        goto Sbk_QFontMetricsFunc_size_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tabarray);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontMetricsFunc_size_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // size(int,QString,int,int*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qfontmetrics-size)]
            int *array = nullptr;
            bool errorOccurred = false;

            if (numArgs == 4) {
                array = Shiboken::sequenceToIntArray(pyArgs[4-1], true);
                if (PyErr_Occurred()) {
                    delete [] array;
                    errorOccurred = true;
                }
            }

            if (!errorOccurred) {
                ::QSize retval = cppSelf->size(cppArg0, cppArg1, cppArg2, array);

                delete [] array;

                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &retval);
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qfontmetrics-size)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_size_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_strikeOutPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.strikeOutPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // strikeOutPos()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->strikeOutPos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::swap(QFontMetrics&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QFontMetrics&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
        ::QFontMetrics *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QFontMetrics&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontMetricsFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_tightBoundingRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.tightBoundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::tightBoundingRect(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // tightBoundingRect(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_tightBoundingRect_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // tightBoundingRect(QString)const
            QRect cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->tightBoundingRect(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_tightBoundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_underlinePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.underlinePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underlinePos()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->underlinePos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFunc_width(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.width";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_width_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFunc_width_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:width", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetrics::width(QString,int)const
    // 1: QFontMetrics::width(QString,int,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // width(QString,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // width(QString,int)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // width(QString,int,int)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_width_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // width(const QString & arg__1, int len) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_len = Shiboken::String::createStaticString("len");
                if (PyDict_Contains(kwds, key_len)) {
                    value = PyDict_GetItem(kwds, key_len);
                    if (value && pyArgs[1]) {
                        errInfo = key_len;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFunc_width_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QFontMetricsFunc_width_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_len);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFontMetricsFunc_width_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // width(QString,int)const
                int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->width(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QFontMetrics.width(const QString & arg__1, int len) const is deprecated", 1);
            break;
        }
        case 1: // width(const QString & arg__1, int len, int flags) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFontMetricsFunc_width_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // width(QString,int,int)const
                int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->width(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QFontMetrics.width(const QString & arg__1, int len, int flags) const is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_width_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_widthChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.widthChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetrics::width(QChar)const
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // width(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFunc_widthChar_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width(QChar)const
            // Begin code injection
            // TEMPLATE - QFontCharFix - START
            int size = Shiboken::String::len(pyArg);
            if (size == 1) {
                const char *str = Shiboken::String::toCString(pyArg);
                QChar ch(str[0]);
                int cppResult = cppSelf->width(ch);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            } else {
                PyErr_SetString(PyExc_TypeError, "String must have only one character");
            }
            // TEMPLATE - QFontCharFix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFunc_widthChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFunc_xHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetrics.xHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xHeight()const
            int cppResult = const_cast<const ::QFontMetrics *>(cppSelf)->xHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetrics___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFontMetrics_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFontMetrics_methods[] = {
    {"ascent", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_ascent), METH_NOARGS},
    {"averageCharWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_averageCharWidth), METH_NOARGS},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_boundingRect), METH_VARARGS|METH_KEYWORDS},
    {"boundingRectChar", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_boundingRectChar), METH_O},
    {"capHeight", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_capHeight), METH_NOARGS},
    {"charWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_charWidth), METH_VARARGS},
    {"descent", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_descent), METH_NOARGS},
    {"elidedText", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_elidedText), METH_VARARGS|METH_KEYWORDS},
    {"fontDpi", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_fontDpi), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_height), METH_NOARGS},
    {"horizontalAdvance", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_horizontalAdvance), METH_VARARGS|METH_KEYWORDS},
    {"inFont", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_inFont), METH_O},
    {"inFontUcs4", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_inFontUcs4), METH_O},
    {"leading", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_leading), METH_NOARGS},
    {"leftBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_leftBearing), METH_O},
    {"lineSpacing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_lineSpacing), METH_NOARGS},
    {"lineWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_lineWidth), METH_NOARGS},
    {"maxWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_maxWidth), METH_NOARGS},
    {"minLeftBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_minLeftBearing), METH_NOARGS},
    {"minRightBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_minRightBearing), METH_NOARGS},
    {"overlinePos", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_overlinePos), METH_NOARGS},
    {"rightBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_rightBearing), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_size), METH_VARARGS|METH_KEYWORDS},
    {"strikeOutPos", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_strikeOutPos), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_swap), METH_O},
    {"tightBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_tightBoundingRect), METH_O},
    {"underlinePos", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_underlinePos), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_width), METH_VARARGS|METH_KEYWORDS},
    {"widthChar", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_widthChar), METH_O},
    {"xHeight", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFunc_xHeight), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFontMetrics___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QFontMetrics_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArg)))) {
                // operator!=(const QFontMetrics & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
                ::QFontMetrics *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArg)))) {
                // operator==(const QFontMetrics & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
                ::QFontMetrics *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QFontMetrics_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QFontMetrics_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QFontMetrics_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFontMetrics_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFontMetrics_Type = nullptr;
static SbkObjectType *Sbk_QFontMetrics_TypeF(void)
{
    return _Sbk_QFontMetrics_Type;
}

static PyType_Slot Sbk_QFontMetrics_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFontMetrics_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFontMetrics_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QFontMetrics_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFontMetrics_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFontMetrics_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFontMetrics_spec = {
    "2:PySide2.QtGui.QFontMetrics",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFontMetrics_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFontMetrics_PythonToCpp_QFontMetrics_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFontMetrics_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFontMetrics_PythonToCpp_QFontMetrics_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontMetrics_TypeF())))
        return QFontMetrics_PythonToCpp_QFontMetrics_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFontMetrics_PTR_CppToPython_QFontMetrics(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFontMetrics *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFontMetrics_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFontMetrics_COPY_CppToPython_QFontMetrics(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFontMetrics_TypeF(), new ::QFontMetrics(*reinterpret_cast<const ::QFontMetrics *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFontMetrics_PythonToCpp_QFontMetrics_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontMetrics *>(cppOut) = *reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFontMetrics_PythonToCpp_QFontMetrics_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontMetrics_TypeF())))
        return QFontMetrics_PythonToCpp_QFontMetrics_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFontMetrics_SignatureStrings[] = {
    "2:PySide2.QtGui.QFontMetrics(self,arg__1:PySide2.QtGui.QFont)",
    "1:PySide2.QtGui.QFontMetrics(self,font:PySide2.QtGui.QFont,pd:PySide2.QtGui.QPaintDevice)",
    "0:PySide2.QtGui.QFontMetrics(self,arg__1:PySide2.QtGui.QFontMetrics)",
    "PySide2.QtGui.QFontMetrics.ascent(self)->int",
    "PySide2.QtGui.QFontMetrics.averageCharWidth(self)->int",
    "2:PySide2.QtGui.QFontMetrics.boundingRect(self,r:PySide2.QtCore.QRect,flags:int,text:QString,tabstops:int=0,tabarray:array int*=nullptr)->PySide2.QtCore.QRect",
    "1:PySide2.QtGui.QFontMetrics.boundingRect(self,text:QString)->PySide2.QtCore.QRect",
    "0:PySide2.QtGui.QFontMetrics.boundingRect(self,x:int,y:int,w:int,h:int,flags:int,text:QString,tabstops:int=0,tabarray:array int*=nullptr)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QFontMetrics.boundingRectChar(self,arg__1:QChar)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QFontMetrics.capHeight(self)->int",
    "PySide2.QtGui.QFontMetrics.charWidth(self,str:QString,pos:int)->int",
    "PySide2.QtGui.QFontMetrics.descent(self)->int",
    "PySide2.QtGui.QFontMetrics.elidedText(self,text:QString,mode:PySide2.QtCore.Qt.TextElideMode,width:int,flags:int=0)->QString",
    "PySide2.QtGui.QFontMetrics.fontDpi(self)->qreal",
    "PySide2.QtGui.QFontMetrics.height(self)->int",
    "1:PySide2.QtGui.QFontMetrics.horizontalAdvance(self,arg__1:QChar)->int",
    "0:PySide2.QtGui.QFontMetrics.horizontalAdvance(self,arg__1:QString,len:int=-1)->int",
    "PySide2.QtGui.QFontMetrics.inFont(self,arg__1:QChar)->bool",
    "PySide2.QtGui.QFontMetrics.inFontUcs4(self,ucs4:uint)->bool",
    "PySide2.QtGui.QFontMetrics.leading(self)->int",
    "PySide2.QtGui.QFontMetrics.leftBearing(self,arg__1:QChar)->int",
    "PySide2.QtGui.QFontMetrics.lineSpacing(self)->int",
    "PySide2.QtGui.QFontMetrics.lineWidth(self)->int",
    "PySide2.QtGui.QFontMetrics.maxWidth(self)->int",
    "PySide2.QtGui.QFontMetrics.minLeftBearing(self)->int",
    "PySide2.QtGui.QFontMetrics.minRightBearing(self)->int",
    "PySide2.QtGui.QFontMetrics.overlinePos(self)->int",
    "PySide2.QtGui.QFontMetrics.rightBearing(self,arg__1:QChar)->int",
    "PySide2.QtGui.QFontMetrics.size(self,flags:int,str:QString,tabstops:int=0,tabarray:array int*=nullptr)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QFontMetrics.strikeOutPos(self)->int",
    "PySide2.QtGui.QFontMetrics.swap(self,other:PySide2.QtGui.QFontMetrics)",
    "PySide2.QtGui.QFontMetrics.tightBoundingRect(self,text:QString)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QFontMetrics.underlinePos(self)->int",
    "1:PySide2.QtGui.QFontMetrics.width(self,arg__1:QString,len:int=-1)->int",
    "0:PySide2.QtGui.QFontMetrics.width(self,arg__1:QString,len:int,flags:int)->int",
    "PySide2.QtGui.QFontMetrics.widthChar(self,arg__1:QChar)->int",
    "PySide2.QtGui.QFontMetrics.xHeight(self)->int",
    "PySide2.QtGui.QFontMetrics.__copy__()",
    nullptr}; // Sentinel

void init_QFontMetrics(PyObject *module)
{
    _Sbk_QFontMetrics_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFontMetrics",
        "QFontMetrics",
        &Sbk_QFontMetrics_spec,
        &Shiboken::callCppDestructor< ::QFontMetrics >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFontMetrics_Type);
    InitSignatureStrings(pyType, QFontMetrics_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFontMetrics_Type), Sbk_QFontMetrics_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFontMetrics_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFontMetrics_TypeF(),
        QFontMetrics_PythonToCpp_QFontMetrics_PTR,
        is_QFontMetrics_PythonToCpp_QFontMetrics_PTR_Convertible,
        QFontMetrics_PTR_CppToPython_QFontMetrics,
        QFontMetrics_COPY_CppToPython_QFontMetrics);

    Shiboken::Conversions::registerConverterName(converter, "QFontMetrics");
    Shiboken::Conversions::registerConverterName(converter, "QFontMetrics*");
    Shiboken::Conversions::registerConverterName(converter, "QFontMetrics&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFontMetrics).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFontMetrics_PythonToCpp_QFontMetrics_COPY,
        is_QFontMetrics_PythonToCpp_QFontMetrics_COPY_Convertible);

}
