/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qfontmetricsf_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qfont.h>
#include <QtGui/qfontmetrics.h>
#include <QtGui/qpaintdevice.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFontMetricsF_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFontMetricsF >()))
        return -1;

    ::QFontMetricsF *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFontMetricsF", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QFontMetricsF::QFontMetricsF(QFont)
    // 1: QFontMetricsF::QFontMetricsF(QFont,QPaintDevice*)
    // 2: QFontMetricsF::QFontMetricsF(QFontMetrics)
    // 3: QFontMetricsF::QFontMetricsF(QFontMetricsF)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QFontMetricsF(QFontMetrics)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QFontMetricsF(QFontMetricsF)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QFontMetricsF(QFont)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QFontMetricsF(QFont,QPaintDevice*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsF_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFontMetricsF(const QFont & font)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontMetricsF(QFont)
                cptr = new ::QFontMetricsF(*cppArg0);
            }
            break;
        }
        case 1: // QFontMetricsF(const QFont & font, QPaintDevice * pd)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPaintDevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFontMetricsF(QFont,QPaintDevice*)
                cptr = new ::QFontMetricsF(*cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QFontMetricsF(const QFontMetrics & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
            ::QFontMetrics *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontMetricsF(QFontMetrics)
                cptr = new ::QFontMetricsF(*cppArg0);
            }
            break;
        }
        case 3: // QFontMetricsF(const QFontMetricsF & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFontMetricsF cppArg0_local = ::QFontMetricsF(::QFontMetrics(::QFont()));
            ::QFontMetricsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontMetricsF(QFontMetricsF)
                cptr = new ::QFontMetricsF(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFontMetricsF >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFontMetricsF_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFontMetricsF_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFontMetricsFFunc_ascent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.ascent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ascent()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->ascent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_averageCharWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.averageCharWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // averageCharWidth()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->averageCharWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_boundingRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.boundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:boundingRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetricsF::boundingRect(QRectF,int,QString,int,int*)const
    // 1: QFontMetricsF::boundingRect(QString)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // boundingRect(QString)const
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // boundingRect(QRectF,int,QString,int,int*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // boundingRect(QRectF,int,QString,int,int*)const
            } else if (numArgs >= 5) {
                overloadId = 0; // boundingRect(QRectF,int,QString,int,int*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // boundingRect(const QRectF & r, int flags, const QString & string, int tabstops, int * tabarray) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_tabstops = Shiboken::String::createStaticString("tabstops");
                if (PyDict_Contains(kwds, key_tabstops)) {
                    value = PyDict_GetItem(kwds, key_tabstops);
                    if (value && pyArgs[3]) {
                        errInfo = key_tabstops;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tabstops);
                }
                static PyObject *const key_tabarray = Shiboken::String::createStaticString("tabarray");
                if (PyDict_Contains(kwds, key_tabarray)) {
                    value = PyDict_GetItem(kwds, key_tabarray);
                    if (value && pyArgs[4]) {
                        errInfo = key_tabarray;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!PyObject_Check(pyArgs[4]))
                            goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tabarray);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // boundingRect(QRectF,int,QString,int,int*)const
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qfontmetricsf-boundingrect)]
                int *array = nullptr;
                bool errorOccurred = false;

                if (numArgs == 5) {
                    array = Shiboken::sequenceToIntArray(pyArgs[5-1], true);
                    if (PyErr_Occurred()) {
                        delete [] array;
                        errorOccurred = true;
                    }
                }

                if (!errorOccurred) {
                    ::QRectF retval = cppSelf->boundingRect(*cppArg0, cppArg1, cppArg2, cppArg3, array);

                    delete [] array;

                    pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &retval);
                }
                // END of custom code block [file: ../glue/qtgui.cpp (qfontmetricsf-boundingrect)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // boundingRect(const QString & string) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFontMetricsFFunc_boundingRect_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // boundingRect(QString)const
                QRectF cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->boundingRect(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_boundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_boundingRectChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.boundingRectChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::boundingRect(QChar)const
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // boundingRect(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_boundingRectChar_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundingRect(QChar)const
            // Begin code injection
            // TEMPLATE - QFontCharFix - START
            int size = Shiboken::String::len(pyArg);
            if (size == 1) {
                const char *str = Shiboken::String::toCString(pyArg);
                QChar ch(str[0]);
                ::QRectF cppResult = cppSelf->boundingRect(ch);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            } else {
                PyErr_SetString(PyExc_TypeError, "String must have only one character");
            }
            // TEMPLATE - QFontCharFix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_boundingRectChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_capHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.capHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capHeight()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->capHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_descent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.descent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // descent()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->descent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_elidedText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.elidedText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_elidedText_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_elidedText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:elidedText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetricsF::elidedText(QString,Qt::TextElideMode,qreal,int)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // elidedText(QString,Qt::TextElideMode,qreal,int)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // elidedText(QString,Qt::TextElideMode,qreal,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_elidedText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[3]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontMetricsFFunc_elidedText_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QFontMetricsFFunc_elidedText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontMetricsFFunc_elidedText_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TextElideMode cppArg1{Qt::ElideLeft};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // elidedText(QString,Qt::TextElideMode,qreal,int)const
            QString cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->elidedText(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_elidedText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_fontDpi(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.fontDpi";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontDpi()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->fontDpi();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_horizontalAdvance(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.horizontalAdvance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:horizontalAdvance", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetricsF::horizontalAdvance(QChar)const
    // 1: QFontMetricsF::horizontalAdvance(QString,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // horizontalAdvance(QString,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // horizontalAdvance(QString,int)const
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArgs[0])))) {
        overloadId = 0; // horizontalAdvance(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // horizontalAdvance(QChar arg__1) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;
            }
            ::QChar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // horizontalAdvance(QChar)const
                qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->horizontalAdvance(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
        case 1: // horizontalAdvance(const QString & string, int length) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_length = Shiboken::String::createStaticString("length");
                if (PyDict_Contains(kwds, key_length)) {
                    value = PyDict_GetItem(kwds, key_length);
                    if (value && pyArgs[1]) {
                        errInfo = key_length;
                        Py_INCREF(errInfo);
                        goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_length);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // horizontalAdvance(QString,int)const
                qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->horizontalAdvance(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_horizontalAdvance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_inFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.inFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::inFont(QChar)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // inFont(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_inFont_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inFont(QChar)const
            bool cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->inFont(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_inFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_inFontUcs4(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.inFontUcs4";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::inFontUcs4(uint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // inFontUcs4(uint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_inFontUcs4_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inFontUcs4(uint)const
            bool cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->inFontUcs4(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_inFontUcs4_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_leading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.leading";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leading()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->leading();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_leftBearing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.leftBearing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::leftBearing(QChar)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // leftBearing(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_leftBearing_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // leftBearing(QChar)const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->leftBearing(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_leftBearing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_lineSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.lineSpacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineSpacing()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->lineSpacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_lineWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.lineWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineWidth()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->lineWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_maxWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.maxWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWidth()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->maxWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_minLeftBearing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.minLeftBearing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minLeftBearing()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->minLeftBearing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_minRightBearing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.minRightBearing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minRightBearing()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->minRightBearing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_overlinePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.overlinePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overlinePos()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->overlinePos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_rightBearing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.rightBearing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::rightBearing(QChar)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // rightBearing(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_rightBearing_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rightBearing(QChar)const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->rightBearing(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_rightBearing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_size(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.size";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_size_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontMetricsFFunc_size_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:size", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QFontMetricsF::size(int,QString,int,int*)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // size(int,QString,int,int*)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // size(int,QString,int,int*)const
            } else if (numArgs >= 4) {
                overloadId = 0; // size(int,QString,int,int*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_size_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_tabstops = Shiboken::String::createStaticString("tabstops");
            if (PyDict_Contains(kwds, key_tabstops)) {
                value = PyDict_GetItem(kwds, key_tabstops);
                if (value && pyArgs[2]) {
                    errInfo = key_tabstops;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontMetricsFFunc_size_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QFontMetricsFFunc_size_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tabstops);
            }
            static PyObject *const key_tabarray = Shiboken::String::createStaticString("tabarray");
            if (PyDict_Contains(kwds, key_tabarray)) {
                value = PyDict_GetItem(kwds, key_tabarray);
                if (value && pyArgs[3]) {
                    errInfo = key_tabarray;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontMetricsFFunc_size_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!PyObject_Check(pyArgs[3]))
                        goto Sbk_QFontMetricsFFunc_size_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tabarray);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontMetricsFFunc_size_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // size(int,QString,int,int*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qfontmetricsf-size)]
            int *array = nullptr;
            bool errorOccurred = false;

            if (numArgs == 4) {
                array = Shiboken::sequenceToIntArray(pyArgs[4-1], true);
                if (PyErr_Occurred()) {
                    delete [] array;
                    errorOccurred = true;
                }
            }

            if (!errorOccurred) {
                ::QSizeF retval = cppSelf->size(cppArg0, cppArg1, cppArg2, array);

                delete [] array;

                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &retval);
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qfontmetricsf-size)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_size_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_strikeOutPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.strikeOutPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // strikeOutPos()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->strikeOutPos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::swap(QFontMetricsF&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QFontMetricsF&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFontMetricsF cppArg0_local = ::QFontMetricsF(::QFontMetrics(::QFont()));
        ::QFontMetricsF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QFontMetricsF&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontMetricsFFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_tightBoundingRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.tightBoundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::tightBoundingRect(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // tightBoundingRect(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_tightBoundingRect_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // tightBoundingRect(QString)const
            QRectF cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->tightBoundingRect(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_tightBoundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_underlinePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.underlinePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underlinePos()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->underlinePos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsFFunc_width(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.width";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::width(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // width(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_width_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // width(QString)const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->width(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_width_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_widthChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.widthChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontMetricsF::width(QChar)const
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // width(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontMetricsFFunc_widthChar_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width(QChar)const
            // Begin code injection
            // TEMPLATE - QFontCharFix - START
            int size = Shiboken::String::len(pyArg);
            if (size == 1) {
                const char *str = Shiboken::String::toCString(pyArg);
                QChar ch(str[0]);
                qreal cppResult = cppSelf->width(ch);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            } else {
                PyErr_SetString(PyExc_TypeError, "String must have only one character");
            }
            // TEMPLATE - QFontCharFix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontMetricsFFunc_widthChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontMetricsFFunc_xHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontMetricsF.xHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xHeight()const
            qreal cppResult = const_cast<const ::QFontMetricsF *>(cppSelf)->xHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontMetricsF___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFontMetricsF_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFontMetricsF_methods[] = {
    {"ascent", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_ascent), METH_NOARGS},
    {"averageCharWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_averageCharWidth), METH_NOARGS},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_boundingRect), METH_VARARGS|METH_KEYWORDS},
    {"boundingRectChar", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_boundingRectChar), METH_O},
    {"capHeight", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_capHeight), METH_NOARGS},
    {"descent", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_descent), METH_NOARGS},
    {"elidedText", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_elidedText), METH_VARARGS|METH_KEYWORDS},
    {"fontDpi", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_fontDpi), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_height), METH_NOARGS},
    {"horizontalAdvance", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_horizontalAdvance), METH_VARARGS|METH_KEYWORDS},
    {"inFont", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_inFont), METH_O},
    {"inFontUcs4", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_inFontUcs4), METH_O},
    {"leading", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_leading), METH_NOARGS},
    {"leftBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_leftBearing), METH_O},
    {"lineSpacing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_lineSpacing), METH_NOARGS},
    {"lineWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_lineWidth), METH_NOARGS},
    {"maxWidth", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_maxWidth), METH_NOARGS},
    {"minLeftBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_minLeftBearing), METH_NOARGS},
    {"minRightBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_minRightBearing), METH_NOARGS},
    {"overlinePos", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_overlinePos), METH_NOARGS},
    {"rightBearing", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_rightBearing), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_size), METH_VARARGS|METH_KEYWORDS},
    {"strikeOutPos", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_strikeOutPos), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_swap), METH_O},
    {"tightBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_tightBoundingRect), METH_O},
    {"underlinePos", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_underlinePos), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_width), METH_O},
    {"widthChar", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_widthChar), METH_O},
    {"xHeight", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsFFunc_xHeight), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFontMetricsF___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QFontMetricsF_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), (pyArg)))) {
                // operator!=(const QFontMetricsF & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFontMetricsF cppArg0_local = ::QFontMetricsF(::QFontMetrics(::QFont()));
                ::QFontMetricsF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), (pyArg)))) {
                // operator==(const QFontMetricsF & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFontMetricsF cppArg0_local = ::QFontMetricsF(::QFontMetrics(::QFont()));
                ::QFontMetricsF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QFontMetricsF_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QFontMetricsF_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QFontMetricsF_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFontMetricsF_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFontMetricsF_Type = nullptr;
static SbkObjectType *Sbk_QFontMetricsF_TypeF(void)
{
    return _Sbk_QFontMetricsF_Type;
}

static PyType_Slot Sbk_QFontMetricsF_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFontMetricsF_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFontMetricsF_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QFontMetricsF_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFontMetricsF_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFontMetricsF_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFontMetricsF_spec = {
    "2:PySide2.QtGui.QFontMetricsF",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFontMetricsF_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFontMetricsF_PythonToCpp_QFontMetricsF_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFontMetricsF_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFontMetricsF_PythonToCpp_QFontMetricsF_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontMetricsF_TypeF())))
        return QFontMetricsF_PythonToCpp_QFontMetricsF_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFontMetricsF_PTR_CppToPython_QFontMetricsF(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFontMetricsF *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFontMetricsF_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFontMetricsF_COPY_CppToPython_QFontMetricsF(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFontMetricsF_TypeF(), new ::QFontMetricsF(*reinterpret_cast<const ::QFontMetricsF *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFontMetricsF_PythonToCpp_QFontMetricsF_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontMetricsF *>(cppOut) = *reinterpret_cast< ::QFontMetricsF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFontMetricsF_PythonToCpp_QFontMetricsF_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontMetricsF_TypeF())))
        return QFontMetricsF_PythonToCpp_QFontMetricsF_COPY;
    return {};
}

// Implicit conversions.
static void constQFontMetricsREF_PythonToCpp_QFontMetricsF(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontMetricsF *>(cppOut) = ::QFontMetricsF( *reinterpret_cast< ::QFontMetrics *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQFontMetricsREF_PythonToCpp_QFontMetricsF_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX], pyIn))
        return constQFontMetricsREF_PythonToCpp_QFontMetricsF;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFontMetricsF_SignatureStrings[] = {
    "3:PySide2.QtGui.QFontMetricsF(self,font:PySide2.QtGui.QFont)",
    "2:PySide2.QtGui.QFontMetricsF(self,font:PySide2.QtGui.QFont,pd:PySide2.QtGui.QPaintDevice)",
    "1:PySide2.QtGui.QFontMetricsF(self,arg__1:PySide2.QtGui.QFontMetrics)",
    "0:PySide2.QtGui.QFontMetricsF(self,arg__1:PySide2.QtGui.QFontMetricsF)",
    "PySide2.QtGui.QFontMetricsF.ascent(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.averageCharWidth(self)->qreal",
    "1:PySide2.QtGui.QFontMetricsF.boundingRect(self,r:PySide2.QtCore.QRectF,flags:int,string:QString,tabstops:int=0,tabarray:array int*=nullptr)->PySide2.QtCore.QRectF",
    "0:PySide2.QtGui.QFontMetricsF.boundingRect(self,string:QString)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QFontMetricsF.boundingRectChar(self,arg__1:QChar)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QFontMetricsF.capHeight(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.descent(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.elidedText(self,text:QString,mode:PySide2.QtCore.Qt.TextElideMode,width:qreal,flags:int=0)->QString",
    "PySide2.QtGui.QFontMetricsF.fontDpi(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.height(self)->qreal",
    "1:PySide2.QtGui.QFontMetricsF.horizontalAdvance(self,arg__1:QChar)->qreal",
    "0:PySide2.QtGui.QFontMetricsF.horizontalAdvance(self,string:QString,length:int=-1)->qreal",
    "PySide2.QtGui.QFontMetricsF.inFont(self,arg__1:QChar)->bool",
    "PySide2.QtGui.QFontMetricsF.inFontUcs4(self,ucs4:uint)->bool",
    "PySide2.QtGui.QFontMetricsF.leading(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.leftBearing(self,arg__1:QChar)->qreal",
    "PySide2.QtGui.QFontMetricsF.lineSpacing(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.lineWidth(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.maxWidth(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.minLeftBearing(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.minRightBearing(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.overlinePos(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.rightBearing(self,arg__1:QChar)->qreal",
    "PySide2.QtGui.QFontMetricsF.size(self,flags:int,str:QString,tabstops:int=0,tabarray:array int*=nullptr)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QFontMetricsF.strikeOutPos(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.swap(self,other:PySide2.QtGui.QFontMetricsF)",
    "PySide2.QtGui.QFontMetricsF.tightBoundingRect(self,text:QString)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QFontMetricsF.underlinePos(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.width(self,string:QString)->qreal",
    "PySide2.QtGui.QFontMetricsF.widthChar(self,arg__1:QChar)->qreal",
    "PySide2.QtGui.QFontMetricsF.xHeight(self)->qreal",
    "PySide2.QtGui.QFontMetricsF.__copy__()",
    nullptr}; // Sentinel

void init_QFontMetricsF(PyObject *module)
{
    _Sbk_QFontMetricsF_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFontMetricsF",
        "QFontMetricsF",
        &Sbk_QFontMetricsF_spec,
        &Shiboken::callCppDestructor< ::QFontMetricsF >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFontMetricsF_Type);
    InitSignatureStrings(pyType, QFontMetricsF_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFontMetricsF_Type), Sbk_QFontMetricsF_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QFONTMETRICSF_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFontMetricsF_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFontMetricsF_TypeF(),
        QFontMetricsF_PythonToCpp_QFontMetricsF_PTR,
        is_QFontMetricsF_PythonToCpp_QFontMetricsF_PTR_Convertible,
        QFontMetricsF_PTR_CppToPython_QFontMetricsF,
        QFontMetricsF_COPY_CppToPython_QFontMetricsF);

    Shiboken::Conversions::registerConverterName(converter, "QFontMetricsF");
    Shiboken::Conversions::registerConverterName(converter, "QFontMetricsF*");
    Shiboken::Conversions::registerConverterName(converter, "QFontMetricsF&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFontMetricsF).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFontMetricsF_PythonToCpp_QFontMetricsF_COPY,
        is_QFontMetricsF_PythonToCpp_QFontMetricsF_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQFontMetricsREF_PythonToCpp_QFontMetricsF,
        is_constQFontMetricsREF_PythonToCpp_QFontMetricsF_Convertible);

}
