/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qgradient_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGradient_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGradient >()))
        return -1;

    ::QGradient *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGradient", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGradient::QGradient()
    // 1: QGradient::QGradient(QGradient::Preset)
    // 2: QGradient::QGradient(QGradient)
    if (numArgs == 0) {
        overloadId = 0; // QGradient()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QGradient(QGradient::Preset)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QGradient(QGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGradient_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGradient()
        {

            if (!PyErr_Occurred()) {
                // QGradient()
                cptr = new ::QGradient();
            }
            break;
        }
        case 1: // QGradient(QGradient::Preset arg__1)
        {
            ::QGradient::Preset cppArg0 = static_cast< ::QGradient::Preset>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGradient(QGradient::Preset)
                cptr = new ::QGradient(cppArg0);
            }
            break;
        }
        case 2: // QGradient(const QGradient & QGradient)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGradient cppArg0_local;
            ::QGradient *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGradient(QGradient)
                cptr = new ::QGradient(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGradient >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGradient_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGradient_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGradientFunc_coordinateMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.coordinateMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // coordinateMode()const
            QGradient::CoordinateMode cppResult = const_cast<const ::QGradient *>(cppSelf)->coordinateMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGradientFunc_interpolationMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.interpolationMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interpolationMode()const
            QGradient::InterpolationMode cppResult = const_cast<const ::QGradient *>(cppSelf)->interpolationMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGradientFunc_setColorAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.setColorAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setColorAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGradient::setColorAt(qreal,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setColorAt(qreal,QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGradientFunc_setColorAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setColorAt(qreal,QColor)
            cppSelf->setColorAt(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGradientFunc_setColorAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGradientFunc_setCoordinateMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.setCoordinateMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGradient::setCoordinateMode(QGradient::CoordinateMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCoordinateMode(QGradient::CoordinateMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGradientFunc_setCoordinateMode_TypeError;

    // Call function/method
    {
        ::QGradient::CoordinateMode cppArg0{QGradient::LogicalMode};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCoordinateMode(QGradient::CoordinateMode)
            cppSelf->setCoordinateMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGradientFunc_setCoordinateMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGradientFunc_setInterpolationMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.setInterpolationMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGradient::setInterpolationMode(QGradient::InterpolationMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setInterpolationMode(QGradient::InterpolationMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGradientFunc_setInterpolationMode_TypeError;

    // Call function/method
    {
        ::QGradient::InterpolationMode cppArg0{QGradient::ColorInterpolation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInterpolationMode(QGradient::InterpolationMode)
            cppSelf->setInterpolationMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGradientFunc_setInterpolationMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGradientFunc_setSpread(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.setSpread";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGradient::setSpread(QGradient::Spread)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSpread(QGradient::Spread)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGradientFunc_setSpread_TypeError;

    // Call function/method
    {
        ::QGradient::Spread cppArg0{QGradient::PadSpread};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSpread(QGradient::Spread)
            cppSelf->setSpread(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGradientFunc_setSpread_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGradientFunc_setStops(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.setStops";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGradient::setStops(QVector<QPair<qreal,QColor> >)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QREAL_QCOLOR_IDX], (pyArg)))) {
        overloadId = 0; // setStops(QVector<QPair<qreal,QColor> >)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGradientFunc_setStops_TypeError;

    // Call function/method
    {
        ::QVector<QPair< qreal,QColor > > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStops(QVector<QPair<qreal,QColor> >)
            cppSelf->setStops(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGradientFunc_setStops_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGradientFunc_spread(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.spread";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spread()const
            QGradient::Spread cppResult = const_cast<const ::QGradient *>(cppSelf)->spread();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGradientFunc_stops(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.stops";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stops()const
            QVector<QPair< qreal,QColor > > cppResult = const_cast<const ::QGradient *>(cppSelf)->stops();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QREAL_QCOLOR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGradientFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGradient.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QGradient::Type cppResult = const_cast<const ::QGradient *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGradient___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGradient_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGradient_methods[] = {
    {"coordinateMode", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_coordinateMode), METH_NOARGS},
    {"interpolationMode", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_interpolationMode), METH_NOARGS},
    {"setColorAt", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_setColorAt), METH_VARARGS},
    {"setCoordinateMode", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_setCoordinateMode), METH_O},
    {"setInterpolationMode", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_setInterpolationMode), METH_O},
    {"setSpread", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_setSpread), METH_O},
    {"setStops", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_setStops), METH_O},
    {"spread", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_spread), METH_NOARGS},
    {"stops", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_stops), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QGradientFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGradient___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGradient_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), (pyArg)))) {
                // operator!=(const QGradient & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGradient cppArg0_local;
                ::QGradient *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), (pyArg)))) {
                // operator==(const QGradient & gradient) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGradient cppArg0_local;
                ::QGradient *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGradient_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGradient_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGradient_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGradient_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGradient_Type = nullptr;
static SbkObjectType *Sbk_QGradient_TypeF(void)
{
    return _Sbk_QGradient_Type;
}

static PyType_Slot Sbk_QGradient_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGradient_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGradient_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGradient_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGradient_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGradient_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGradient_spec = {
    "2:PySide2.QtGui.QGradient",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGradient_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QGradient_Type_PythonToCpp_QGradient_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGradient::Type *>(cppOut) =
        static_cast<::QGradient::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGradient_Type_PythonToCpp_QGradient_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX]))
        return QGradient_Type_PythonToCpp_QGradient_Type;
    return {};
}
static PyObject *QGradient_Type_CppToPython_QGradient_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGradient::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX], castCppIn);

}

static void QGradient_Spread_PythonToCpp_QGradient_Spread(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGradient::Spread *>(cppOut) =
        static_cast<::QGradient::Spread>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGradient_Spread_PythonToCpp_QGradient_Spread_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX]))
        return QGradient_Spread_PythonToCpp_QGradient_Spread;
    return {};
}
static PyObject *QGradient_Spread_CppToPython_QGradient_Spread(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGradient::Spread *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX], castCppIn);

}

static void QGradient_CoordinateMode_PythonToCpp_QGradient_CoordinateMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGradient::CoordinateMode *>(cppOut) =
        static_cast<::QGradient::CoordinateMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGradient_CoordinateMode_PythonToCpp_QGradient_CoordinateMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX]))
        return QGradient_CoordinateMode_PythonToCpp_QGradient_CoordinateMode;
    return {};
}
static PyObject *QGradient_CoordinateMode_CppToPython_QGradient_CoordinateMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGradient::CoordinateMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX], castCppIn);

}

static void QGradient_InterpolationMode_PythonToCpp_QGradient_InterpolationMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGradient::InterpolationMode *>(cppOut) =
        static_cast<::QGradient::InterpolationMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGradient_InterpolationMode_PythonToCpp_QGradient_InterpolationMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX]))
        return QGradient_InterpolationMode_PythonToCpp_QGradient_InterpolationMode;
    return {};
}
static PyObject *QGradient_InterpolationMode_CppToPython_QGradient_InterpolationMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGradient::InterpolationMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX], castCppIn);

}

static void QGradient_Preset_PythonToCpp_QGradient_Preset(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGradient::Preset *>(cppOut) =
        static_cast<::QGradient::Preset>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGradient_Preset_PythonToCpp_QGradient_Preset_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX]))
        return QGradient_Preset_PythonToCpp_QGradient_Preset;
    return {};
}
static PyObject *QGradient_Preset_CppToPython_QGradient_Preset(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGradient::Preset *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGradient_PythonToCpp_QGradient_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGradient_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGradient_PythonToCpp_QGradient_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGradient_TypeF())))
        return QGradient_PythonToCpp_QGradient_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGradient_PTR_CppToPython_QGradient(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGradient *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGradient_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGradient_COPY_CppToPython_QGradient(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGradient_TypeF(), new ::QGradient(*reinterpret_cast<const ::QGradient *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGradient_PythonToCpp_QGradient_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGradient *>(cppOut) = *reinterpret_cast< ::QGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGradient_PythonToCpp_QGradient_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGradient_TypeF())))
        return QGradient_PythonToCpp_QGradient_COPY;
    return {};
}

// Implicit conversions.
static void QGradient_Preset_PythonToCpp_QGradient(PyObject *pyIn, void *cppOut) {
    ::QGradient::Preset cppIn = static_cast< ::QGradient::Preset>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QGradient *>(cppOut) = ::QGradient(cppIn);
}
static PythonToCppFunc is_QGradient_Preset_PythonToCpp_QGradient_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX], pyIn))
        return QGradient_Preset_PythonToCpp_QGradient;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGradient_SignatureStrings[] = {
    "2:PySide2.QtGui.QGradient(self)",
    "1:PySide2.QtGui.QGradient(self,arg__1:PySide2.QtGui.QGradient.Preset)",
    "0:PySide2.QtGui.QGradient(self,QGradient:PySide2.QtGui.QGradient)",
    "PySide2.QtGui.QGradient.coordinateMode(self)->PySide2.QtGui.QGradient.CoordinateMode",
    "PySide2.QtGui.QGradient.interpolationMode(self)->PySide2.QtGui.QGradient.InterpolationMode",
    "PySide2.QtGui.QGradient.setColorAt(self,pos:qreal,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QGradient.setCoordinateMode(self,mode:PySide2.QtGui.QGradient.CoordinateMode)",
    "PySide2.QtGui.QGradient.setInterpolationMode(self,mode:PySide2.QtGui.QGradient.InterpolationMode)",
    "PySide2.QtGui.QGradient.setSpread(self,spread:PySide2.QtGui.QGradient.Spread)",
    "PySide2.QtGui.QGradient.setStops(self,stops:QVector[QPair[qreal, PySide2.QtGui.QColor]])",
    "PySide2.QtGui.QGradient.spread(self)->PySide2.QtGui.QGradient.Spread",
    "PySide2.QtGui.QGradient.stops(self)->QVector[QPair[qreal, PySide2.QtGui.QColor]]",
    "PySide2.QtGui.QGradient.type(self)->PySide2.QtGui.QGradient.Type",
    "PySide2.QtGui.QGradient.__copy__()",
    nullptr}; // Sentinel

void init_QGradient(PyObject *module)
{
    _Sbk_QGradient_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGradient",
        "QGradient",
        &Sbk_QGradient_spec,
        &Shiboken::callCppDestructor< ::QGradient >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGradient_Type);
    InitSignatureStrings(pyType, QGradient_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGradient_Type), Sbk_QGradient_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGradient_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGradient_TypeF(),
        QGradient_PythonToCpp_QGradient_PTR,
        is_QGradient_PythonToCpp_QGradient_PTR_Convertible,
        QGradient_PTR_CppToPython_QGradient,
        QGradient_COPY_CppToPython_QGradient);

    Shiboken::Conversions::registerConverterName(converter, "QGradient");
    Shiboken::Conversions::registerConverterName(converter, "QGradient*");
    Shiboken::Conversions::registerConverterName(converter, "QGradient&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGradient).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGradient_PythonToCpp_QGradient_COPY,
        is_QGradient_PythonToCpp_QGradient_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGradient_Preset_PythonToCpp_QGradient,
        is_QGradient_Preset_PythonToCpp_QGradient_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGradient_TypeF(),
        "Type",
        "2:PySide2.QtGui.QGradient.Type",
        "QGradient::Type");
    if (!SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX],
        Sbk_QGradient_TypeF(), "LinearGradient", (long) QGradient::Type::LinearGradient))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX],
        Sbk_QGradient_TypeF(), "RadialGradient", (long) QGradient::Type::RadialGradient))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX],
        Sbk_QGradient_TypeF(), "ConicalGradient", (long) QGradient::Type::ConicalGradient))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX],
        Sbk_QGradient_TypeF(), "NoGradient", (long) QGradient::Type::NoGradient))
        return;
    // Register converter for enum 'QGradient::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX],
            QGradient_Type_CppToPython_QGradient_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGradient_Type_PythonToCpp_QGradient_Type,
            is_QGradient_Type_PythonToCpp_QGradient_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGradient::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    // Initialization of enum 'Spread'.
    SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGradient_TypeF(),
        "Spread",
        "2:PySide2.QtGui.QGradient.Spread",
        "QGradient::Spread");
    if (!SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX],
        Sbk_QGradient_TypeF(), "PadSpread", (long) QGradient::Spread::PadSpread))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX],
        Sbk_QGradient_TypeF(), "ReflectSpread", (long) QGradient::Spread::ReflectSpread))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX],
        Sbk_QGradient_TypeF(), "RepeatSpread", (long) QGradient::Spread::RepeatSpread))
        return;
    // Register converter for enum 'QGradient::Spread'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX],
            QGradient_Spread_CppToPython_QGradient_Spread);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGradient_Spread_PythonToCpp_QGradient_Spread,
            is_QGradient_Spread_PythonToCpp_QGradient_Spread_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGradient::Spread");
        Shiboken::Conversions::registerConverterName(converter, "Spread");
    }
    // End of 'Spread' enum.

    // Initialization of enum 'CoordinateMode'.
    SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGradient_TypeF(),
        "CoordinateMode",
        "2:PySide2.QtGui.QGradient.CoordinateMode",
        "QGradient::CoordinateMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX],
        Sbk_QGradient_TypeF(), "LogicalMode", (long) QGradient::CoordinateMode::LogicalMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX],
        Sbk_QGradient_TypeF(), "StretchToDeviceMode", (long) QGradient::CoordinateMode::StretchToDeviceMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX],
        Sbk_QGradient_TypeF(), "ObjectBoundingMode", (long) QGradient::CoordinateMode::ObjectBoundingMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX],
        Sbk_QGradient_TypeF(), "ObjectMode", (long) QGradient::CoordinateMode::ObjectMode))
        return;
    // Register converter for enum 'QGradient::CoordinateMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX],
            QGradient_CoordinateMode_CppToPython_QGradient_CoordinateMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGradient_CoordinateMode_PythonToCpp_QGradient_CoordinateMode,
            is_QGradient_CoordinateMode_PythonToCpp_QGradient_CoordinateMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGradient::CoordinateMode");
        Shiboken::Conversions::registerConverterName(converter, "CoordinateMode");
    }
    // End of 'CoordinateMode' enum.

    // Initialization of enum 'InterpolationMode'.
    SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGradient_TypeF(),
        "InterpolationMode",
        "2:PySide2.QtGui.QGradient.InterpolationMode",
        "QGradient::InterpolationMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX],
        Sbk_QGradient_TypeF(), "ColorInterpolation", (long) QGradient::InterpolationMode::ColorInterpolation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX],
        Sbk_QGradient_TypeF(), "ComponentInterpolation", (long) QGradient::InterpolationMode::ComponentInterpolation))
        return;
    // Register converter for enum 'QGradient::InterpolationMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX],
            QGradient_InterpolationMode_CppToPython_QGradient_InterpolationMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGradient_InterpolationMode_PythonToCpp_QGradient_InterpolationMode,
            is_QGradient_InterpolationMode_PythonToCpp_QGradient_InterpolationMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGradient::InterpolationMode");
        Shiboken::Conversions::registerConverterName(converter, "InterpolationMode");
    }
    // End of 'InterpolationMode' enum.

    // Initialization of enum 'Preset'.
    SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGradient_TypeF(),
        "Preset",
        "2:PySide2.QtGui.QGradient.Preset",
        "QGradient::Preset");
    if (!SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "WarmFlame", (long) QGradient::Preset::WarmFlame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NightFade", (long) QGradient::Preset::NightFade))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SpringWarmth", (long) QGradient::Preset::SpringWarmth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "JuicyPeach", (long) QGradient::Preset::JuicyPeach))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "YoungPassion", (long) QGradient::Preset::YoungPassion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LadyLips", (long) QGradient::Preset::LadyLips))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SunnyMorning", (long) QGradient::Preset::SunnyMorning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RainyAshville", (long) QGradient::Preset::RainyAshville))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FrozenDreams", (long) QGradient::Preset::FrozenDreams))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "WinterNeva", (long) QGradient::Preset::WinterNeva))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "DustyGrass", (long) QGradient::Preset::DustyGrass))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "TemptingAzure", (long) QGradient::Preset::TemptingAzure))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HeavyRain", (long) QGradient::Preset::HeavyRain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AmyCrisp", (long) QGradient::Preset::AmyCrisp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MeanFruit", (long) QGradient::Preset::MeanFruit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "DeepBlue", (long) QGradient::Preset::DeepBlue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RipeMalinka", (long) QGradient::Preset::RipeMalinka))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "CloudyKnoxville", (long) QGradient::Preset::CloudyKnoxville))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MalibuBeach", (long) QGradient::Preset::MalibuBeach))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NewLife", (long) QGradient::Preset::NewLife))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "TrueSunset", (long) QGradient::Preset::TrueSunset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MorpheusDen", (long) QGradient::Preset::MorpheusDen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RareWind", (long) QGradient::Preset::RareWind))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NearMoon", (long) QGradient::Preset::NearMoon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "WildApple", (long) QGradient::Preset::WildApple))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SaintPetersburg", (long) QGradient::Preset::SaintPetersburg))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PlumPlate", (long) QGradient::Preset::PlumPlate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "EverlastingSky", (long) QGradient::Preset::EverlastingSky))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HappyFisher", (long) QGradient::Preset::HappyFisher))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "Blessing", (long) QGradient::Preset::Blessing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SharpeyeEagle", (long) QGradient::Preset::SharpeyeEagle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LadogaBottom", (long) QGradient::Preset::LadogaBottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LemonGate", (long) QGradient::Preset::LemonGate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ItmeoBranding", (long) QGradient::Preset::ItmeoBranding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ZeusMiracle", (long) QGradient::Preset::ZeusMiracle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "OldHat", (long) QGradient::Preset::OldHat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "StarWine", (long) QGradient::Preset::StarWine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HappyAcid", (long) QGradient::Preset::HappyAcid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AwesomePine", (long) QGradient::Preset::AwesomePine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NewYork", (long) QGradient::Preset::NewYork))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ShyRainbow", (long) QGradient::Preset::ShyRainbow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MixedHopes", (long) QGradient::Preset::MixedHopes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FlyHigh", (long) QGradient::Preset::FlyHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "StrongBliss", (long) QGradient::Preset::StrongBliss))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FreshMilk", (long) QGradient::Preset::FreshMilk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SnowAgain", (long) QGradient::Preset::SnowAgain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FebruaryInk", (long) QGradient::Preset::FebruaryInk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "KindSteel", (long) QGradient::Preset::KindSteel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SoftGrass", (long) QGradient::Preset::SoftGrass))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "GrownEarly", (long) QGradient::Preset::GrownEarly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SharpBlues", (long) QGradient::Preset::SharpBlues))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ShadyWater", (long) QGradient::Preset::ShadyWater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "DirtyBeauty", (long) QGradient::Preset::DirtyBeauty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "GreatWhale", (long) QGradient::Preset::GreatWhale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "TeenNotebook", (long) QGradient::Preset::TeenNotebook))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PoliteRumors", (long) QGradient::Preset::PoliteRumors))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SweetPeriod", (long) QGradient::Preset::SweetPeriod))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "WideMatrix", (long) QGradient::Preset::WideMatrix))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SoftCherish", (long) QGradient::Preset::SoftCherish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RedSalvation", (long) QGradient::Preset::RedSalvation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "BurningSpring", (long) QGradient::Preset::BurningSpring))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NightParty", (long) QGradient::Preset::NightParty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SkyGlider", (long) QGradient::Preset::SkyGlider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HeavenPeach", (long) QGradient::Preset::HeavenPeach))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PurpleDivision", (long) QGradient::Preset::PurpleDivision))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AquaSplash", (long) QGradient::Preset::AquaSplash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SpikyNaga", (long) QGradient::Preset::SpikyNaga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LoveKiss", (long) QGradient::Preset::LoveKiss))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "CleanMirror", (long) QGradient::Preset::CleanMirror))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PremiumDark", (long) QGradient::Preset::PremiumDark))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ColdEvening", (long) QGradient::Preset::ColdEvening))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "CochitiLake", (long) QGradient::Preset::CochitiLake))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SummerGames", (long) QGradient::Preset::SummerGames))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PassionateBed", (long) QGradient::Preset::PassionateBed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MountainRock", (long) QGradient::Preset::MountainRock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "DesertHump", (long) QGradient::Preset::DesertHump))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "JungleDay", (long) QGradient::Preset::JungleDay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PhoenixStart", (long) QGradient::Preset::PhoenixStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "OctoberSilence", (long) QGradient::Preset::OctoberSilence))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FarawayRiver", (long) QGradient::Preset::FarawayRiver))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AlchemistLab", (long) QGradient::Preset::AlchemistLab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "OverSun", (long) QGradient::Preset::OverSun))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PremiumWhite", (long) QGradient::Preset::PremiumWhite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MarsParty", (long) QGradient::Preset::MarsParty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "EternalConstance", (long) QGradient::Preset::EternalConstance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "JapanBlush", (long) QGradient::Preset::JapanBlush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SmilingRain", (long) QGradient::Preset::SmilingRain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "CloudyApple", (long) QGradient::Preset::CloudyApple))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "BigMango", (long) QGradient::Preset::BigMango))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HealthyWater", (long) QGradient::Preset::HealthyWater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AmourAmour", (long) QGradient::Preset::AmourAmour))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RiskyConcrete", (long) QGradient::Preset::RiskyConcrete))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "StrongStick", (long) QGradient::Preset::StrongStick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ViciousStance", (long) QGradient::Preset::ViciousStance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PaloAlto", (long) QGradient::Preset::PaloAlto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HappyMemories", (long) QGradient::Preset::HappyMemories))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MidnightBloom", (long) QGradient::Preset::MidnightBloom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "Crystalline", (long) QGradient::Preset::Crystalline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PartyBliss", (long) QGradient::Preset::PartyBliss))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ConfidentCloud", (long) QGradient::Preset::ConfidentCloud))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LeCocktail", (long) QGradient::Preset::LeCocktail))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RiverCity", (long) QGradient::Preset::RiverCity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FrozenBerry", (long) QGradient::Preset::FrozenBerry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ChildCare", (long) QGradient::Preset::ChildCare))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FlyingLemon", (long) QGradient::Preset::FlyingLemon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NewRetrowave", (long) QGradient::Preset::NewRetrowave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HiddenJaguar", (long) QGradient::Preset::HiddenJaguar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AboveTheSky", (long) QGradient::Preset::AboveTheSky))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "Nega", (long) QGradient::Preset::Nega))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "DenseWater", (long) QGradient::Preset::DenseWater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "Seashore", (long) QGradient::Preset::Seashore))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MarbleWall", (long) QGradient::Preset::MarbleWall))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "CheerfulCaramel", (long) QGradient::Preset::CheerfulCaramel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NightSky", (long) QGradient::Preset::NightSky))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MagicLake", (long) QGradient::Preset::MagicLake))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "YoungGrass", (long) QGradient::Preset::YoungGrass))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ColorfulPeach", (long) QGradient::Preset::ColorfulPeach))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "GentleCare", (long) QGradient::Preset::GentleCare))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PlumBath", (long) QGradient::Preset::PlumBath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HappyUnicorn", (long) QGradient::Preset::HappyUnicorn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AfricanField", (long) QGradient::Preset::AfricanField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SolidStone", (long) QGradient::Preset::SolidStone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "OrangeJuice", (long) QGradient::Preset::OrangeJuice))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "GlassWater", (long) QGradient::Preset::GlassWater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NorthMiracle", (long) QGradient::Preset::NorthMiracle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FruitBlend", (long) QGradient::Preset::FruitBlend))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MillenniumPine", (long) QGradient::Preset::MillenniumPine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "HighFlight", (long) QGradient::Preset::HighFlight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MoleHall", (long) QGradient::Preset::MoleHall))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SpaceShift", (long) QGradient::Preset::SpaceShift))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "ForestInei", (long) QGradient::Preset::ForestInei))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RoyalGarden", (long) QGradient::Preset::RoyalGarden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "RichMetal", (long) QGradient::Preset::RichMetal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "JuicyCake", (long) QGradient::Preset::JuicyCake))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SmartIndigo", (long) QGradient::Preset::SmartIndigo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SandStrike", (long) QGradient::Preset::SandStrike))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NorseBeauty", (long) QGradient::Preset::NorseBeauty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AquaGuidance", (long) QGradient::Preset::AquaGuidance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SunVeggie", (long) QGradient::Preset::SunVeggie))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SeaLord", (long) QGradient::Preset::SeaLord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "BlackSea", (long) QGradient::Preset::BlackSea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "GrassShampoo", (long) QGradient::Preset::GrassShampoo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LandingAircraft", (long) QGradient::Preset::LandingAircraft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "WitchDance", (long) QGradient::Preset::WitchDance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SleeplessNight", (long) QGradient::Preset::SleeplessNight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "AngelCare", (long) QGradient::Preset::AngelCare))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "CrystalRiver", (long) QGradient::Preset::CrystalRiver))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SoftLipstick", (long) QGradient::Preset::SoftLipstick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SaltMountain", (long) QGradient::Preset::SaltMountain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PerfectWhite", (long) QGradient::Preset::PerfectWhite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FreshOasis", (long) QGradient::Preset::FreshOasis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "StrictNovember", (long) QGradient::Preset::StrictNovember))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MorningSalad", (long) QGradient::Preset::MorningSalad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "DeepRelief", (long) QGradient::Preset::DeepRelief))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SeaStrike", (long) QGradient::Preset::SeaStrike))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NightCall", (long) QGradient::Preset::NightCall))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SupremeSky", (long) QGradient::Preset::SupremeSky))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LightBlue", (long) QGradient::Preset::LightBlue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MindCrawl", (long) QGradient::Preset::MindCrawl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "LilyMeadow", (long) QGradient::Preset::LilyMeadow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SugarLollipop", (long) QGradient::Preset::SugarLollipop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "SweetDessert", (long) QGradient::Preset::SweetDessert))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "MagicRay", (long) QGradient::Preset::MagicRay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "TeenParty", (long) QGradient::Preset::TeenParty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FrozenHeat", (long) QGradient::Preset::FrozenHeat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "GagarinView", (long) QGradient::Preset::GagarinView))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "FabledSunset", (long) QGradient::Preset::FabledSunset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "PerfectBlue", (long) QGradient::Preset::PerfectBlue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
        Sbk_QGradient_TypeF(), "NumPresets", (long) QGradient::Preset::NumPresets))
        return;
    // Register converter for enum 'QGradient::Preset'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX],
            QGradient_Preset_CppToPython_QGradient_Preset);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGradient_Preset_PythonToCpp_QGradient_Preset,
            is_QGradient_Preset_PythonToCpp_QGradient_Preset_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGradient::Preset");
        Shiboken::Conversions::registerConverterName(converter, "Preset");
    }
    // End of 'Preset' enum.

    qRegisterMetaType< ::QGradient >("QGradient");
    qRegisterMetaType< ::QGradient::Type >("QGradient::Type");
    qRegisterMetaType< ::QGradient::Spread >("QGradient::Spread");
    qRegisterMetaType< ::QGradient::CoordinateMode >("QGradient::CoordinateMode");
    qRegisterMetaType< ::QGradient::InterpolationMode >("QGradient::InterpolationMode");
    qRegisterMetaType< ::QGradient::Preset >("QGradient::Preset");
}
