/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qguiapplication_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtgui.cpp (qguiapplication-init)]
static void QGuiApplicationConstructor(PyObject *self, PyObject *pyargv, QGuiApplicationWrapper **cptr)
{
    static int argc;
    static char **argv;
    PyObject *stringlist = PyTuple_GET_ITEM(pyargv, 0);
    if (Shiboken::listToArgcArgv(stringlist, &argc, &argv, "PySideApp")) {
        *cptr = new QGuiApplicationWrapper(argc, argv, 0);
        Shiboken::Object::releaseOwnership(reinterpret_cast<SbkObject *>(self));
        PySide::registerCleanupFunction(&PySide::destroyQCoreApplication);
    }
}
// END of custom code block [file: ../glue/qtgui.cpp (qguiapplication-init)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QGuiApplicationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGuiApplicationWrapper::QGuiApplicationWrapper(int & argc, char ** argv, int arg__3) : QGuiApplication(argc, argv, arg__3)
{
    resetPyMethodCache();
    // ... middle
}

void QGuiApplicationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGuiApplicationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGuiApplicationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGuiApplicationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGuiApplicationWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QGuiApplication::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QGuiApplication::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGuiApplication.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGuiApplicationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGuiApplication.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QGuiApplicationWrapper::notify(::QObject * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[7])
        return this->::QGuiApplication::notify(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "notify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QGuiApplication::notify(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGuiApplication.notify", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGuiApplicationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGuiApplicationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGuiApplication::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGuiApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGuiApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGuiApplicationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGuiApplicationWrapper *>(this));
        return QGuiApplication::qt_metacast(_clname);
}

QGuiApplicationWrapper::~QGuiApplicationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGuiApplication_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGuiApplication >()))
        return -1;

    ::QGuiApplicationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGuiApplication", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGuiApplication::QGuiApplication()
    // 1: QGuiApplication::QGuiApplication(QStringList)
    if (numArgs == 0) {
        overloadId = 0; // QGuiApplication()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        overloadId = 1; // QGuiApplication(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplication_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGuiApplication()
        {

            if (!PyErr_Occurred()) {
                // QGuiApplication()
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qguiapplication-2)]
                PyObject *empty = PyTuple_New(2);
                if (!PyTuple_SetItem(empty, 0, PyList_New(0))) {
                    QGuiApplicationConstructor(self, empty, &cptr);
                }
                // END of custom code block [file: ../glue/qtgui.cpp (qguiapplication-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // QGuiApplication(QStringList arg__1)
        {
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // QGuiApplication(QStringList)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qguiapplication-1)]
                QGuiApplicationConstructor(self, args, &cptr);
                // END of custom code block [file: ../glue/qtgui.cpp (qguiapplication-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGuiApplication >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGuiApplication_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGuiApplication_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGuiApplication_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGuiApplicationFunc_allWindows(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.allWindows";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allWindows()
            QList<QWindow* > cppResult = ::QGuiApplication::allWindows();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QWINDOWPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_applicationDisplayName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.applicationDisplayName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationDisplayName()
            QString cppResult = ::QGuiApplication::applicationDisplayName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_applicationState(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.applicationState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationState()
            Qt::ApplicationState cppResult = ::QGuiApplication::applicationState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_changeOverrideCursor(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.changeOverrideCursor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::changeOverrideCursor(QCursor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), (pyArg)))) {
        overloadId = 0; // changeOverrideCursor(QCursor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_changeOverrideCursor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCursor cppArg0_local;
        ::QCursor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // changeOverrideCursor(QCursor)
            ::QGuiApplication::changeOverrideCursor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_changeOverrideCursor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_clipboard(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.clipboard";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipboard()
            QClipboard * cppResult = ::QGuiApplication::clipboard();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_desktopFileName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.desktopFileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // desktopFileName()
            QString cppResult = ::QGuiApplication::desktopFileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_desktopSettingsAware(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.desktopSettingsAware";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // desktopSettingsAware()
            bool cppResult = ::QGuiApplication::desktopSettingsAware();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_devicePixelRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.devicePixelRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devicePixelRatio()const
            qreal cppResult = const_cast<const ::QGuiApplication *>(cppSelf)->devicePixelRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGuiApplication::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGuiApplicationFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_exec_(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.exec_";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exec()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            int cppResult = ::QGuiApplication::exec();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_focusObject(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.focusObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusObject()
            QObject * cppResult = ::QGuiApplication::focusObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_focusWindow(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.focusWindow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusWindow()
            QWindow * cppResult = ::QGuiApplication::focusWindow();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_font(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()
            QFont cppResult = ::QGuiApplication::font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_highDpiScaleFactorRoundingPolicy(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.highDpiScaleFactorRoundingPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // highDpiScaleFactorRoundingPolicy()
            Qt::HighDpiScaleFactorRoundingPolicy cppResult = ::QGuiApplication::highDpiScaleFactorRoundingPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_inputMethod(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.inputMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputMethod()
            QInputMethod * cppResult = ::QGuiApplication::inputMethod();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_isFallbackSessionManagementEnabled(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.isFallbackSessionManagementEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFallbackSessionManagementEnabled()
            bool cppResult = ::QGuiApplication::isFallbackSessionManagementEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_isLeftToRight(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.isLeftToRight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLeftToRight()
            bool cppResult = ::QGuiApplication::isLeftToRight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_isRightToLeft(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.isRightToLeft";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRightToLeft()
            bool cppResult = ::QGuiApplication::isRightToLeft();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_isSavingSession(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.isSavingSession";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSavingSession()const
            bool cppResult = const_cast<const ::QGuiApplication *>(cppSelf)->isSavingSession();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_isSessionRestored(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.isSessionRestored";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSessionRestored()const
            bool cppResult = const_cast<const ::QGuiApplication *>(cppSelf)->isSessionRestored();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_keyboardModifiers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.keyboardModifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyboardModifiers()
            QFlags<Qt::KeyboardModifier> cppResult = ::QGuiApplication::keyboardModifiers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_layoutDirection(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.layoutDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layoutDirection()
            Qt::LayoutDirection cppResult = ::QGuiApplication::layoutDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_modalWindow(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.modalWindow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modalWindow()
            QWindow * cppResult = ::QGuiApplication::modalWindow();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_mouseButtons(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.mouseButtons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseButtons()
            QFlags<Qt::MouseButton> cppResult = ::QGuiApplication::mouseButtons();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_notify(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.notify";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "notify", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCoreApplication::notify(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // notify(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_notify_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // notify(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGuiApplication::notify(cppArg0, cppArg1)
                : cppSelf->notify(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGuiApplicationFunc_notify_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_overrideCursor(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.overrideCursor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overrideCursor()
            QCursor * cppResult = ::QGuiApplication::overrideCursor();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_palette(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.palette";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // palette()
            QPalette cppResult = ::QGuiApplication::palette();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_platformName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.platformName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // platformName()
            QString cppResult = ::QGuiApplication::platformName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_primaryScreen(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.primaryScreen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // primaryScreen()
            QScreen * cppResult = ::QGuiApplication::primaryScreen();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_queryKeyboardModifiers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.queryKeyboardModifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queryKeyboardModifiers()
            QFlags<Qt::KeyboardModifier> cppResult = ::QGuiApplication::queryKeyboardModifiers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_quitOnLastWindowClosed(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.quitOnLastWindowClosed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quitOnLastWindowClosed()
            bool cppResult = ::QGuiApplication::quitOnLastWindowClosed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_restoreOverrideCursor(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.restoreOverrideCursor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restoreOverrideCursor()
            ::QGuiApplication::restoreOverrideCursor();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGuiApplicationFunc_screenAt(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.screenAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::screenAt(QPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // screenAt(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_screenAt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // screenAt(QPoint)
            QScreen * cppResult = ::QGuiApplication::screenAt(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGuiApplicationFunc_screenAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_screens(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.screens";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // screens()
            QList<QScreen* > cppResult = ::QGuiApplication::screens();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSCREENPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_sessionId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.sessionId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionId()const
            QString cppResult = const_cast<const ::QGuiApplication *>(cppSelf)->sessionId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_sessionKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.sessionKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionKey()const
            QString cppResult = const_cast<const ::QGuiApplication *>(cppSelf)->sessionKey();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_setApplicationDisplayName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setApplicationDisplayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setApplicationDisplayName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setApplicationDisplayName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setApplicationDisplayName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setApplicationDisplayName(QString)
            ::QGuiApplication::setApplicationDisplayName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setApplicationDisplayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setDesktopFileName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setDesktopFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setDesktopFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDesktopFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setDesktopFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDesktopFileName(QString)
            ::QGuiApplication::setDesktopFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setDesktopFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setDesktopSettingsAware(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setDesktopSettingsAware";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setDesktopSettingsAware(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDesktopSettingsAware(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setDesktopSettingsAware_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDesktopSettingsAware(bool)
            ::QGuiApplication::setDesktopSettingsAware(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setDesktopSettingsAware_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setFallbackSessionManagementEnabled(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setFallbackSessionManagementEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setFallbackSessionManagementEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFallbackSessionManagementEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setFallbackSessionManagementEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFallbackSessionManagementEnabled(bool)
            ::QGuiApplication::setFallbackSessionManagementEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setFallbackSessionManagementEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setFont(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFont(QFont)
            ::QGuiApplication::setFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setHighDpiScaleFactorRoundingPolicy(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setHighDpiScaleFactorRoundingPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setHighDpiScaleFactorRoundingPolicy(Qt::HighDpiScaleFactorRoundingPolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHighDpiScaleFactorRoundingPolicy(Qt::HighDpiScaleFactorRoundingPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setHighDpiScaleFactorRoundingPolicy_TypeError;

    // Call function/method
    {
        ::Qt::HighDpiScaleFactorRoundingPolicy cppArg0{Qt::HighDpiScaleFactorRoundingPolicy::Unset};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHighDpiScaleFactorRoundingPolicy(Qt::HighDpiScaleFactorRoundingPolicy)
            ::QGuiApplication::setHighDpiScaleFactorRoundingPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setHighDpiScaleFactorRoundingPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setLayoutDirection(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setLayoutDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setLayoutDirection(Qt::LayoutDirection)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLayoutDirection(Qt::LayoutDirection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setLayoutDirection_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayoutDirection(Qt::LayoutDirection)
            ::QGuiApplication::setLayoutDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setLayoutDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setOverrideCursor(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setOverrideCursor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setOverrideCursor(QCursor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), (pyArg)))) {
        overloadId = 0; // setOverrideCursor(QCursor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setOverrideCursor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCursor cppArg0_local;
        ::QCursor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setOverrideCursor(QCursor)
            ::QGuiApplication::setOverrideCursor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setOverrideCursor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setPalette(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setPalette";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setPalette(QPalette)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
        overloadId = 0; // setPalette(QPalette)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setPalette_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPalette cppArg0_local;
        ::QPalette *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPalette(QPalette)
            ::QGuiApplication::setPalette(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setPalette_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setQuitOnLastWindowClosed(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setQuitOnLastWindowClosed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setQuitOnLastWindowClosed(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setQuitOnLastWindowClosed(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setQuitOnLastWindowClosed_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuitOnLastWindowClosed(bool)
            ::QGuiApplication::setQuitOnLastWindowClosed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setQuitOnLastWindowClosed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_setWindowIcon(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.setWindowIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setWindowIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArg)))) {
        overloadId = 0; // setWindowIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_setWindowIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setWindowIcon(QIcon)
            ::QGuiApplication::setWindowIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGuiApplicationFunc_setWindowIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_styleHints(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.styleHints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleHints()
            QStyleHints * cppResult = ::QGuiApplication::styleHints();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_sync(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.sync";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sync()
            ::QGuiApplication::sync();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGuiApplicationFunc_topLevelAt(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.topLevelAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::topLevelAt(QPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // topLevelAt(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGuiApplicationFunc_topLevelAt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // topLevelAt(QPoint)
            QWindow * cppResult = ::QGuiApplication::topLevelAt(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGuiApplicationFunc_topLevelAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGuiApplicationFunc_topLevelWindows(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.topLevelWindows";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topLevelWindows()
            QList<QWindow* > cppResult = ::QGuiApplication::topLevelWindows();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QWINDOWPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGuiApplicationFunc_windowIcon(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QGuiApplication.windowIcon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowIcon()
            QIcon cppResult = ::QGuiApplication::windowIcon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGuiApplication_PropertyStrings[] = {
    "applicationDisplayName::",
    "desktopFileName::",
    "layoutDirection::",
    "platformName:",
    "primaryScreen:",
    "quitOnLastWindowClosed::",
    "windowIcon::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGuiApplication_methods[] = {
    {"allWindows", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_allWindows), METH_NOARGS|METH_STATIC},
    {"applicationDisplayName", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_applicationDisplayName), METH_NOARGS|METH_STATIC},
    {"applicationState", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_applicationState), METH_NOARGS|METH_STATIC},
    {"changeOverrideCursor", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_changeOverrideCursor), METH_O|METH_STATIC},
    {"clipboard", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_clipboard), METH_NOARGS|METH_STATIC},
    {"desktopFileName", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_desktopFileName), METH_NOARGS|METH_STATIC},
    {"desktopSettingsAware", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_desktopSettingsAware), METH_NOARGS|METH_STATIC},
    {"devicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_devicePixelRatio), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_event), METH_O},
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_exec_), METH_NOARGS|METH_STATIC},
    {"focusObject", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_focusObject), METH_NOARGS|METH_STATIC},
    {"focusWindow", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_focusWindow), METH_NOARGS|METH_STATIC},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_font), METH_NOARGS|METH_STATIC},
    {"highDpiScaleFactorRoundingPolicy", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_highDpiScaleFactorRoundingPolicy), METH_NOARGS|METH_STATIC},
    {"inputMethod", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_inputMethod), METH_NOARGS|METH_STATIC},
    {"isFallbackSessionManagementEnabled", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_isFallbackSessionManagementEnabled), METH_NOARGS|METH_STATIC},
    {"isLeftToRight", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_isLeftToRight), METH_NOARGS|METH_STATIC},
    {"isRightToLeft", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_isRightToLeft), METH_NOARGS|METH_STATIC},
    {"isSavingSession", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_isSavingSession), METH_NOARGS},
    {"isSessionRestored", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_isSessionRestored), METH_NOARGS},
    {"keyboardModifiers", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_keyboardModifiers), METH_NOARGS|METH_STATIC},
    {"layoutDirection", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_layoutDirection), METH_NOARGS|METH_STATIC},
    {"modalWindow", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_modalWindow), METH_NOARGS|METH_STATIC},
    {"mouseButtons", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_mouseButtons), METH_NOARGS|METH_STATIC},
    {"notify", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_notify), METH_VARARGS},
    {"overrideCursor", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_overrideCursor), METH_NOARGS|METH_STATIC},
    {"palette", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_palette), METH_NOARGS|METH_STATIC},
    {"platformName", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_platformName), METH_NOARGS|METH_STATIC},
    {"primaryScreen", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_primaryScreen), METH_NOARGS|METH_STATIC},
    {"queryKeyboardModifiers", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_queryKeyboardModifiers), METH_NOARGS|METH_STATIC},
    {"quitOnLastWindowClosed", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_quitOnLastWindowClosed), METH_NOARGS|METH_STATIC},
    {"restoreOverrideCursor", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_restoreOverrideCursor), METH_NOARGS|METH_STATIC},
    {"screenAt", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_screenAt), METH_O|METH_STATIC},
    {"screens", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_screens), METH_NOARGS|METH_STATIC},
    {"sessionId", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_sessionId), METH_NOARGS},
    {"sessionKey", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_sessionKey), METH_NOARGS},
    {"setApplicationDisplayName", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setApplicationDisplayName), METH_O|METH_STATIC},
    {"setDesktopFileName", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setDesktopFileName), METH_O|METH_STATIC},
    {"setDesktopSettingsAware", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setDesktopSettingsAware), METH_O|METH_STATIC},
    {"setFallbackSessionManagementEnabled", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setFallbackSessionManagementEnabled), METH_O|METH_STATIC},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setFont), METH_O|METH_STATIC},
    {"setHighDpiScaleFactorRoundingPolicy", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setHighDpiScaleFactorRoundingPolicy), METH_O|METH_STATIC},
    {"setLayoutDirection", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setLayoutDirection), METH_O|METH_STATIC},
    {"setOverrideCursor", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setOverrideCursor), METH_O|METH_STATIC},
    {"setPalette", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setPalette), METH_O|METH_STATIC},
    {"setQuitOnLastWindowClosed", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setQuitOnLastWindowClosed), METH_O|METH_STATIC},
    {"setWindowIcon", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_setWindowIcon), METH_O|METH_STATIC},
    {"styleHints", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_styleHints), METH_NOARGS|METH_STATIC},
    {"sync", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_sync), METH_NOARGS|METH_STATIC},
    {"topLevelAt", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_topLevelAt), METH_O|METH_STATIC},
    {"topLevelWindows", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_topLevelWindows), METH_NOARGS|METH_STATIC},
    {"windowIcon", reinterpret_cast<PyCFunction>(Sbk_QGuiApplicationFunc_windowIcon), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGuiApplication_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGuiApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGuiApplicationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGuiApplication_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGuiApplication_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGuiApplication_Type = nullptr;
static SbkObjectType *Sbk_QGuiApplication_TypeF(void)
{
    return _Sbk_QGuiApplication_Type;
}

static PyType_Slot Sbk_QGuiApplication_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocQAppWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGuiApplication_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGuiApplication_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGuiApplication_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGuiApplication_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGuiApplication_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkQAppTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGuiApplication_spec = {
    "2:PySide2.QtGui.QGuiApplication",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGuiApplication_slots
};

} //extern "C"

static void *Sbk_QGuiApplication_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGuiApplication *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGuiApplication_PythonToCpp_QGuiApplication_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGuiApplication_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGuiApplication_PythonToCpp_QGuiApplication_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGuiApplication_TypeF())))
        return QGuiApplication_PythonToCpp_QGuiApplication_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGuiApplication_PTR_CppToPython_QGuiApplication(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGuiApplication *>(const_cast<void *>(cppIn)), Sbk_QGuiApplication_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGuiApplication_SignatureStrings[] = {
    "1:PySide2.QtGui.QGuiApplication(self)",
    "0:PySide2.QtGui.QGuiApplication(self,arg__1:QStringList)",
    "PySide2.QtGui.QGuiApplication.allWindows()->QList[PySide2.QtGui.QWindow]",
    "PySide2.QtGui.QGuiApplication.applicationDisplayName()->QString",
    "PySide2.QtGui.QGuiApplication.applicationState()->PySide2.QtCore.Qt.ApplicationState",
    "PySide2.QtGui.QGuiApplication.changeOverrideCursor(arg__1:PySide2.QtGui.QCursor)",
    "PySide2.QtGui.QGuiApplication.clipboard()->PySide2.QtGui.QClipboard",
    "PySide2.QtGui.QGuiApplication.desktopFileName()->QString",
    "PySide2.QtGui.QGuiApplication.desktopSettingsAware()->bool",
    "PySide2.QtGui.QGuiApplication.devicePixelRatio(self)->qreal",
    "PySide2.QtGui.QGuiApplication.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtGui.QGuiApplication.exec_()->int",
    "PySide2.QtGui.QGuiApplication.focusObject()->PySide2.QtCore.QObject",
    "PySide2.QtGui.QGuiApplication.focusWindow()->PySide2.QtGui.QWindow",
    "PySide2.QtGui.QGuiApplication.font()->PySide2.QtGui.QFont",
    "PySide2.QtGui.QGuiApplication.highDpiScaleFactorRoundingPolicy()->PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy",
    "PySide2.QtGui.QGuiApplication.inputMethod()->PySide2.QtGui.QInputMethod",
    "PySide2.QtGui.QGuiApplication.isFallbackSessionManagementEnabled()->bool",
    "PySide2.QtGui.QGuiApplication.isLeftToRight()->bool",
    "PySide2.QtGui.QGuiApplication.isRightToLeft()->bool",
    "PySide2.QtGui.QGuiApplication.isSavingSession(self)->bool",
    "PySide2.QtGui.QGuiApplication.isSessionRestored(self)->bool",
    "PySide2.QtGui.QGuiApplication.keyboardModifiers()->PySide2.QtCore.Qt.KeyboardModifiers",
    "PySide2.QtGui.QGuiApplication.layoutDirection()->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtGui.QGuiApplication.modalWindow()->PySide2.QtGui.QWindow",
    "PySide2.QtGui.QGuiApplication.mouseButtons()->PySide2.QtCore.Qt.MouseButtons",
    "PySide2.QtGui.QGuiApplication.notify(self,arg__1:PySide2.QtCore.QObject,arg__2:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtGui.QGuiApplication.overrideCursor()->PySide2.QtGui.QCursor",
    "PySide2.QtGui.QGuiApplication.palette()->PySide2.QtGui.QPalette",
    "PySide2.QtGui.QGuiApplication.platformName()->QString",
    "PySide2.QtGui.QGuiApplication.primaryScreen()->PySide2.QtGui.QScreen",
    "PySide2.QtGui.QGuiApplication.queryKeyboardModifiers()->PySide2.QtCore.Qt.KeyboardModifiers",
    "PySide2.QtGui.QGuiApplication.quitOnLastWindowClosed()->bool",
    "PySide2.QtGui.QGuiApplication.restoreOverrideCursor()",
    "PySide2.QtGui.QGuiApplication.screenAt(point:PySide2.QtCore.QPoint)->PySide2.QtGui.QScreen",
    "PySide2.QtGui.QGuiApplication.screens()->QList[PySide2.QtGui.QScreen]",
    "PySide2.QtGui.QGuiApplication.sessionId(self)->QString",
    "PySide2.QtGui.QGuiApplication.sessionKey(self)->QString",
    "PySide2.QtGui.QGuiApplication.setApplicationDisplayName(name:QString)",
    "PySide2.QtGui.QGuiApplication.setDesktopFileName(name:QString)",
    "PySide2.QtGui.QGuiApplication.setDesktopSettingsAware(on:bool)",
    "PySide2.QtGui.QGuiApplication.setFallbackSessionManagementEnabled(arg__1:bool)",
    "PySide2.QtGui.QGuiApplication.setFont(arg__1:PySide2.QtGui.QFont)",
    "PySide2.QtGui.QGuiApplication.setHighDpiScaleFactorRoundingPolicy(policy:PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy)",
    "PySide2.QtGui.QGuiApplication.setLayoutDirection(direction:PySide2.QtCore.Qt.LayoutDirection)",
    "PySide2.QtGui.QGuiApplication.setOverrideCursor(arg__1:PySide2.QtGui.QCursor)",
    "PySide2.QtGui.QGuiApplication.setPalette(pal:PySide2.QtGui.QPalette)",
    "PySide2.QtGui.QGuiApplication.setQuitOnLastWindowClosed(quit:bool)",
    "PySide2.QtGui.QGuiApplication.setWindowIcon(icon:PySide2.QtGui.QIcon)",
    "PySide2.QtGui.QGuiApplication.styleHints()->PySide2.QtGui.QStyleHints",
    "PySide2.QtGui.QGuiApplication.sync()",
    "PySide2.QtGui.QGuiApplication.topLevelAt(pos:PySide2.QtCore.QPoint)->PySide2.QtGui.QWindow",
    "PySide2.QtGui.QGuiApplication.topLevelWindows()->QList[PySide2.QtGui.QWindow]",
    "PySide2.QtGui.QGuiApplication.windowIcon()->PySide2.QtGui.QIcon",
    nullptr}; // Sentinel

void init_QGuiApplication(PyObject *module)
{
    _Sbk_QGuiApplication_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGuiApplication",
        "QGuiApplication*",
        &Sbk_QGuiApplication_spec,
        &Shiboken::callCppDestructor< ::QGuiApplication >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGuiApplication_Type);
    InitSignatureStrings(pyType, QGuiApplication_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGuiApplication_Type), Sbk_QGuiApplication_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGuiApplication_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGuiApplication_TypeF(),
        QGuiApplication_PythonToCpp_QGuiApplication_PTR,
        is_QGuiApplication_PythonToCpp_QGuiApplication_PTR_Convertible,
        QGuiApplication_PTR_CppToPython_QGuiApplication);

    Shiboken::Conversions::registerConverterName(converter, "QGuiApplication");
    Shiboken::Conversions::registerConverterName(converter, "QGuiApplication*");
    Shiboken::Conversions::registerConverterName(converter, "QGuiApplication&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGuiApplication).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGuiApplicationWrapper).name());



    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGuiApplication_TypeF(), &Sbk_QGuiApplication_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QGuiApplication_TypeF(), &::QGuiApplication::staticMetaObject);

    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGuiApplication_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGuiApplication_TypeF(), &::QGuiApplication::staticMetaObject, sizeof(QGuiApplicationWrapper));
}

