/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qinputmethodqueryevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QInputMethodQueryEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QInputMethodQueryEventWrapper::QInputMethodQueryEventWrapper(::QFlags<Qt::InputMethodQuery> queries) : QInputMethodQueryEvent(queries)
{
    resetPyMethodCache();
    // ... middle
}

QInputMethodQueryEventWrapper::~QInputMethodQueryEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QInputMethodQueryEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QInputMethodQueryEvent >()))
        return -1;

    ::QInputMethodQueryEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodQueryEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QInputMethodQueryEvent", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QInputMethodQueryEvent::QInputMethodQueryEvent(QFlags<Qt::InputMethodQuery>)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QInputMethodQueryEvent(QFlags<Qt::InputMethodQuery>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodQueryEvent_Init_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::InputMethodQuery> cppArg0 = QFlags<Qt::InputMethodQuery>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QInputMethodQueryEvent(QFlags<Qt::InputMethodQuery>)
            cptr = new ::QInputMethodQueryEventWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QInputMethodQueryEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QInputMethodQueryEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QInputMethodQueryEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QInputMethodQueryEventFunc_queries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodQueryEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODQUERYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodQueryEvent.queries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queries()const
            QFlags<Qt::InputMethodQuery> cppResult = const_cast<const ::QInputMethodQueryEvent *>(cppSelf)->queries();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodQueryEventFunc_setValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodQueryEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODQUERYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodQueryEvent.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QInputMethodQueryEvent::setValue(Qt::InputMethodQuery,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setValue(Qt::InputMethodQuery,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodQueryEventFunc_setValue_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setValue(Qt::InputMethodQuery,QVariant)
            cppSelf->setValue(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodQueryEventFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QInputMethodQueryEventFunc_value(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodQueryEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODQUERYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodQueryEvent.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QInputMethodQueryEvent::value(Qt::InputMethodQuery)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // value(Qt::InputMethodQuery)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodQueryEventFunc_value_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // value(Qt::InputMethodQuery)const
            QVariant cppResult = const_cast<const ::QInputMethodQueryEvent *>(cppSelf)->value(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QInputMethodQueryEventFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QInputMethodQueryEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QInputMethodQueryEvent_methods[] = {
    {"queries", reinterpret_cast<PyCFunction>(Sbk_QInputMethodQueryEventFunc_queries), METH_NOARGS},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_QInputMethodQueryEventFunc_setValue), METH_VARARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QInputMethodQueryEventFunc_value), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QInputMethodQueryEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QInputMethodQueryEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODQUERYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QInputMethodQueryEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QInputMethodQueryEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QInputMethodQueryEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QInputMethodQueryEvent_Type = nullptr;
static SbkObjectType *Sbk_QInputMethodQueryEvent_TypeF(void)
{
    return _Sbk_QInputMethodQueryEvent_Type;
}

static PyType_Slot Sbk_QInputMethodQueryEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QInputMethodQueryEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QInputMethodQueryEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QInputMethodQueryEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QInputMethodQueryEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QInputMethodQueryEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QInputMethodQueryEvent_spec = {
    "2:PySide2.QtGui.QInputMethodQueryEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QInputMethodQueryEvent_slots
};

} //extern "C"

static void *Sbk_QInputMethodQueryEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QInputMethodQueryEvent *>(cptr)->type() == QEvent::InputMethodQuery)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QInputMethodQueryEvent_PythonToCpp_QInputMethodQueryEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QInputMethodQueryEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QInputMethodQueryEvent_PythonToCpp_QInputMethodQueryEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodQueryEvent_TypeF())))
        return QInputMethodQueryEvent_PythonToCpp_QInputMethodQueryEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QInputMethodQueryEvent_PTR_CppToPython_QInputMethodQueryEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QInputMethodQueryEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QInputMethodQueryEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QInputMethodQueryEvent_SignatureStrings[] = {
    "PySide2.QtGui.QInputMethodQueryEvent(self,queries:PySide2.QtCore.Qt.InputMethodQueries)",
    "PySide2.QtGui.QInputMethodQueryEvent.queries(self)->PySide2.QtCore.Qt.InputMethodQueries",
    "PySide2.QtGui.QInputMethodQueryEvent.setValue(self,query:PySide2.QtCore.Qt.InputMethodQuery,value:QVariant)",
    "PySide2.QtGui.QInputMethodQueryEvent.value(self,query:PySide2.QtCore.Qt.InputMethodQuery)->QVariant",
    nullptr}; // Sentinel

void init_QInputMethodQueryEvent(PyObject *module)
{
    _Sbk_QInputMethodQueryEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QInputMethodQueryEvent",
        "QInputMethodQueryEvent*",
        &Sbk_QInputMethodQueryEvent_spec,
        &Shiboken::callCppDestructor< ::QInputMethodQueryEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethodQueryEvent_Type);
    InitSignatureStrings(pyType, QInputMethodQueryEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethodQueryEvent_Type), Sbk_QInputMethodQueryEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODQUERYEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodQueryEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QInputMethodQueryEvent_TypeF(),
        QInputMethodQueryEvent_PythonToCpp_QInputMethodQueryEvent_PTR,
        is_QInputMethodQueryEvent_PythonToCpp_QInputMethodQueryEvent_PTR_Convertible,
        QInputMethodQueryEvent_PTR_CppToPython_QInputMethodQueryEvent);

    Shiboken::Conversions::registerConverterName(converter, "QInputMethodQueryEvent");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethodQueryEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethodQueryEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QInputMethodQueryEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QInputMethodQueryEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QInputMethodQueryEvent_TypeF(), &Sbk_QInputMethodQueryEvent_typeDiscovery);

}
