/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qmatrix4x4_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtGui/qgenericmatrix.h>
#include <QtGui/qmatrix.h>
#include <QtGui/qmatrix4x4.h>
#include <QtGui/qquaternion.h>
#include <QtGui/qtransform.h>
#include <QtGui/qvector3d.h>
#include <QtGui/qvector4d.h>
#include <qdatastream.h>
#include <qpoint.h>
#include <qrect.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMatrix4x4_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMatrix4x4 >()))
        return -1;

    ::QMatrix4x4 *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8 || numArgs == 9 || numArgs == 10 || numArgs == 11 || numArgs == 12 || numArgs == 13 || numArgs == 14 || numArgs == 15)
        goto Sbk_QMatrix4x4_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QMatrix4x4", 0, 16, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12]), &(pyArgs[13]), &(pyArgs[14]), &(pyArgs[15])))
        return -1;


    // Overloaded function decisor
    // 0: QMatrix4x4::QMatrix4x4()
    // 1: QMatrix4x4::QMatrix4x4(QMatrix)
    // 2: QMatrix4x4::QMatrix4x4(QTransform)
    // 3: QMatrix4x4::QMatrix4x4(const float*)
    // 4: QMatrix4x4::QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)
    if (numArgs == 0) {
        overloadId = 0; // QMatrix4x4()
    } else if (numArgs == 16
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[10])))
        && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[11])))
        && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[12])))
        && (pythonToCpp[13] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[13])))
        && (pythonToCpp[14] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[14])))
        && (pythonToCpp[15] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[15])))) {
        overloadId = 4; // QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QMatrix4x4(QTransform)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMatrix4x4(QMatrix)
    } else if (numArgs == 1
        && Shiboken::String::checkIterable(pyArgs[0])) {
        overloadId = 3; // QMatrix4x4(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMatrix4x4()
        {

            if (!PyErr_Occurred()) {
                // QMatrix4x4()
                cptr = new ::QMatrix4x4();
            }
            break;
        }
        case 1: // QMatrix4x4(const QMatrix & matrix)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMatrix cppArg0_local;
            ::QMatrix *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMatrix4x4(QMatrix)
                cptr = new ::QMatrix4x4(*cppArg0);
            }
            break;
        }
        case 2: // QMatrix4x4(const QTransform & transform)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTransform cppArg0_local;
            ::QTransform *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMatrix4x4(QTransform)
                cptr = new ::QMatrix4x4(*cppArg0);
            }
            break;
        }
        case 3: // QMatrix4x4(const float * values)
        {

            if (!PyErr_Occurred()) {
                // QMatrix4x4(const float*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qmatrix4x4)]
                // PYSIDE-795: All PySequences can be made iterable with PySequence_Fast.
                Shiboken::AutoDecRef seq(PySequence_Fast(pyArgs[1-1], "Can't turn into sequence"));
                if (PySequence_Size(seq) == 16) {
                    float values[16];
                    for (int i=0; i < 16; ++i) {
                        PyObject *pv = PySequence_Fast_GET_ITEM(seq.object(), i);
                        values[i] = PyFloat_AsDouble(pv);
                    }

                    cptr = new QMatrix4x4(values[0], values[1], values[2], values[3],
                                   values[4], values[5], values[6], values[7],
                                   values[8], values[9], values[10], values[11],
                                   values[12], values[13], values[14], values[15]);
                }
                // END of custom code block [file: ../glue/qtgui.cpp (qmatrix4x4)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 4: // QMatrix4x4(float m11, float m12, float m13, float m14, float m21, float m22, float m23, float m24, float m31, float m32, float m33, float m34, float m41, float m42, float m43, float m44)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            float cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            float cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            float cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            float cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);
            float cppArg9;
            pythonToCpp[9](pyArgs[9], &cppArg9);
            float cppArg10;
            pythonToCpp[10](pyArgs[10], &cppArg10);
            float cppArg11;
            pythonToCpp[11](pyArgs[11], &cppArg11);
            float cppArg12;
            pythonToCpp[12](pyArgs[12], &cppArg12);
            float cppArg13;
            pythonToCpp[13](pyArgs[13], &cppArg13);
            float cppArg14;
            pythonToCpp[14](pyArgs[14], &cppArg14);
            float cppArg15;
            pythonToCpp[15](pyArgs[15], &cppArg15);

            if (!PyErr_Occurred()) {
                // QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)
                cptr = new ::QMatrix4x4(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12, cppArg13, cppArg14, cppArg15);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMatrix4x4 >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMatrix4x4_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMatrix4x4_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMatrix4x4Func___dummy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__dummy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::__dummy(QList<float>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_FLOAT_IDX], (pyArg)))) {
        overloadId = 0; // __dummy(QList<float>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___dummy_TypeError;

    // Call function/method
    {
        ::QList<float > cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // __dummy(QList<float>)
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func___dummy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code_matrix - START
            QList< float > cppArgs;
            float data[16];
            cppSelf->copyDataTo(data);
            int matrixSize = 16;
            for(int size=0; size < matrixSize; size++)
                cppArgs.append(data[size]);

            PyObject *type = PyObject_Type(self);
            PyObject *args = Py_BuildValue("(N)",
                Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_FLOAT_IDX], &cppArgs));
            pyResult = Py_BuildValue("(NN)", type, args);
            // TEMPLATE - reduce_code_matrix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code_matrix - START
            QByteArray format(Py_TYPE(self)->tp_name);
            format += QByteArray("((");

            QList< float > cppArgs;
            float data[16];
            cppSelf->copyDataTo(data);
            int matrixSize = 16;
            for(int size=0; size < matrixSize; size++) {
                if (size > 0)
                    format += ", ";
                format += QByteArray::number(data[size]);
            }
            format += "))";

            pyResult = Shiboken::String::fromStringAndSize(format, format.size());
            // TEMPLATE - repr_code_matrix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_column(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.column";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::column(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // column(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_column_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // column(int)const
            QVector4D cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->column(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func_column_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_copyDataTo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.copyDataTo";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // copyDataTo(float*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qmatrix4x4-copydatato)]
            float values[16];
            cppSelf->copyDataTo(values);
            pyResult = PyTuple_New(16);
            for (int i = 0; i < 16; ++i) {
              PyObject *v = PyFloat_FromDouble(values[i]);
              PyTuple_SET_ITEM(pyResult, i, v);
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qmatrix4x4-copydatato)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()
            // Begin code injection
            // TEMPLATE - matrix_data_function - START
            const float* data = cppSelf->constData();
            PyObject *pyData = PyTuple_New(16);
            if (data) {
                for(int i=0; i < 16; i++)
                    PyTuple_SET_ITEM(pyData, i, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &data[i]));
            }
            return pyData;
            // TEMPLATE - matrix_data_function - END

            // End of code injection

            float * cppResult = cppSelf->data();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_determinant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.determinant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // determinant()const
            double cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->determinant();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_fill(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.fill";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::fill(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // fill(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_fill_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fill(float)
            cppSelf->fill(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_fill_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_flipCoordinates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.flipCoordinates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flipCoordinates()
            cppSelf->flipCoordinates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMatrix4x4Func_frustum(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.frustum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "frustum", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::frustum(float,float,float,float,float,float)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
        overloadId = 0; // frustum(float,float,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_frustum_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        float cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // frustum(float,float,float,float,float,float)
            cppSelf->frustum(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_frustum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_inverted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.inverted";
    SBK_UNUSED(fullName)

    // Call function/method
    {
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)

        if (!PyErr_Occurred()) {
            // inverted(bool*)const
            // Begin code injection
            // TEMPLATE - fix_bool* - START
            bool ok_;
            ::QMatrix4x4 retval_ = cppSelf->inverted(&ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_isAffine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.isAffine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAffine()const
            bool cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->isAffine();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_isIdentity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.isIdentity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isIdentity()const
            bool cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->isIdentity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_lookAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.lookAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "lookAt", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::lookAt(QVector3D,QVector3D,QVector3D)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[2])))) {
        overloadId = 0; // lookAt(QVector3D,QVector3D,QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_lookAt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVector3D cppArg1_local;
        ::QVector3D *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QVector3D cppArg2_local;
        ::QVector3D *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // lookAt(QVector3D,QVector3D,QVector3D)
            cppSelf->lookAt(*cppArg0, *cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_lookAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_map(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.map";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::map(QPoint)const
    // 1: QMatrix4x4::map(QPointF)const
    // 2: QMatrix4x4::map(QVector3D)const
    // 3: QMatrix4x4::map(QVector4D)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 2; // map(QVector3D)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArg)))) {
        overloadId = 3; // map(QVector4D)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // map(QPoint)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 1; // map(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_map_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // map(const QPoint & point) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // map(QPoint)const
                QPoint cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->map(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // map(const QPointF & point) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // map(QPointF)const
                QPointF cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->map(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
            }
            break;
        }
        case 2: // map(const QVector3D & point) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // map(QVector3D)const
                QVector3D cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->map(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
            }
            break;
        }
        case 3: // map(const QVector4D & point) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QVector4D cppArg0_local;
            ::QVector4D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // map(QVector4D)const
                QVector4D cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->map(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func_map_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_mapRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.mapRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::mapRect(QRect)const
    // 1: QMatrix4x4::mapRect(QRectF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // mapRect(QRect)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 1; // mapRect(QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_mapRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mapRect(const QRect & rect) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // mapRect(QRect)const
                QRect cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->mapRect(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // mapRect(const QRectF & rect) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // mapRect(QRectF)const
                QRectF cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->mapRect(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func_mapRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_mapVector(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.mapVector";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::mapVector(QVector3D)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // mapVector(QVector3D)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_mapVector_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapVector(QVector3D)const
            QVector3D cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->mapVector(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func_mapVector_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_normalMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.normalMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalMatrix()const
            QMatrix3x3 cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->normalMatrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_optimize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.optimize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // optimize()
            cppSelf->optimize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMatrix4x4Func_ortho(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.ortho";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5)
        goto Sbk_QMatrix4x4Func_ortho_TypeError;

    if (!PyArg_UnpackTuple(args, "ortho", 1, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::ortho(QRect)
    // 1: QMatrix4x4::ortho(QRectF)
    // 2: QMatrix4x4::ortho(float,float,float,float,float,float)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
        overloadId = 2; // ortho(float,float,float,float,float,float)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ortho(QRect)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // ortho(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_ortho_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ortho(const QRect & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // ortho(QRect)
                cppSelf->ortho(*cppArg0);
            }
            break;
        }
        case 1: // ortho(const QRectF & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // ortho(QRectF)
                cppSelf->ortho(*cppArg0);
            }
            break;
        }
        case 2: // ortho(float left, float right, float bottom, float top, float nearPlane, float farPlane)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            float cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // ortho(float,float,float,float,float,float)
                cppSelf->ortho(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_ortho_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_perspective(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.perspective";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "perspective", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::perspective(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // perspective(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_perspective_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // perspective(float,float,float,float)
            cppSelf->perspective(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_perspective_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_rotate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.rotate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMatrix4x4Func_rotate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMatrix4x4Func_rotate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:rotate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::rotate(QQuaternion)
    // 1: QMatrix4x4::rotate(float,QVector3D)
    // 2: QMatrix4x4::rotate(float,float,float,float)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 2; // rotate(float,float,float,float)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
                overloadId = 2; // rotate(float,float,float,float)
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 1; // rotate(float,QVector3D)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), (pyArgs[0])))) {
        overloadId = 0; // rotate(QQuaternion)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_rotate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // rotate(const QQuaternion & quaternion)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMatrix4x4Func_rotate_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QQuaternion cppArg0_local;
            ::QQuaternion *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // rotate(QQuaternion)
                cppSelf->rotate(*cppArg0);
            }
            break;
        }
        case 1: // rotate(float angle, const QVector3D & vector)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMatrix4x4Func_rotate_TypeError;
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // rotate(float,QVector3D)
                cppSelf->rotate(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // rotate(float angle, float x, float y, float z)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_z = Shiboken::String::createStaticString("z");
                if (PyDict_Contains(kwds, key_z)) {
                    value = PyDict_GetItem(kwds, key_z);
                    if (value && pyArgs[3]) {
                        errInfo = key_z;
                        Py_INCREF(errInfo);
                        goto Sbk_QMatrix4x4Func_rotate_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3]))))
                            goto Sbk_QMatrix4x4Func_rotate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_z);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMatrix4x4Func_rotate_TypeError;
                }
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3 = 0.0f;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // rotate(float,float,float,float)
                cppSelf->rotate(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_rotate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_row(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.row";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::row(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // row(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_row_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // row(int)const
            QVector4D cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->row(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func_row_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_scale(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.scale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scale", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::scale(QVector3D)
    // 1: QMatrix4x4::scale(float)
    // 2: QMatrix4x4::scale(float,float)
    // 3: QMatrix4x4::scale(float,float,float)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // scale(float)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // scale(float,float)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
                overloadId = 3; // scale(float,float,float)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))) {
        overloadId = 0; // scale(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_scale_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // scale(const QVector3D & vector)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // scale(QVector3D)
                cppSelf->scale(*cppArg0);
            }
            break;
        }
        case 1: // scale(float factor)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // scale(float)
                cppSelf->scale(cppArg0);
            }
            break;
        }
        case 2: // scale(float x, float y)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // scale(float,float)
                cppSelf->scale(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // scale(float x, float y, float z)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // scale(float,float,float)
                cppSelf->scale(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_scale_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_setColumn(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.setColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setColumn", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::setColumn(int,QVector4D)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setColumn(int,QVector4D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_setColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVector4D cppArg1_local;
        ::QVector4D *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setColumn(int,QVector4D)
            cppSelf->setColumn(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_setColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_setRow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.setRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRow", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::setRow(int,QVector4D)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setRow(int,QVector4D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_setRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVector4D cppArg1_local;
        ::QVector4D *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setRow(int,QVector4D)
            cppSelf->setRow(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_setRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_setToIdentity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.setToIdentity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setToIdentity()
            cppSelf->setToIdentity();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMatrix4x4Func_toAffine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.toAffine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toAffine()const
            QMatrix cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->toAffine();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_toTransform(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.toTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toTransform", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::toTransform()const
    // 1: QMatrix4x4::toTransform(float)const
    if (numArgs == 0) {
        overloadId = 0; // toTransform()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        overloadId = 1; // toTransform(float)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_toTransform_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toTransform() const
        {

            if (!PyErr_Occurred()) {
                // toTransform()const
                QTransform cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->toTransform();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toTransform(float distanceToPlane) const
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toTransform(float)const
                QTransform cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->toTransform(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func_toTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_translate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.translate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "translate", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::translate(QVector3D)
    // 1: QMatrix4x4::translate(float,float)
    // 2: QMatrix4x4::translate(float,float,float)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // translate(float,float)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
            overloadId = 2; // translate(float,float,float)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))) {
        overloadId = 0; // translate(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_translate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // translate(const QVector3D & vector)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // translate(QVector3D)
                cppSelf->translate(*cppArg0);
            }
            break;
        }
        case 1: // translate(float x, float y)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // translate(float,float)
                cppSelf->translate(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // translate(float x, float y, float z)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // translate(float,float,float)
                cppSelf->translate(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_translate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func_transposed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.transposed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transposed()const
            QMatrix4x4 cppResult = const_cast<const ::QMatrix4x4 *>(cppSelf)->transposed();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func_viewport(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.viewport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMatrix4x4Func_viewport_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMatrix4x4Func_viewport_TypeError;
    } else if (numArgs == 2 || numArgs == 3)
        goto Sbk_QMatrix4x4Func_viewport_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:viewport", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x4::viewport(QRectF)
    // 1: QMatrix4x4::viewport(float,float,float,float,float,float)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // viewport(float,float,float,float,float,float)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 1; // viewport(float,float,float,float,float,float)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
                overloadId = 1; // viewport(float,float,float,float,float,float)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // viewport(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func_viewport_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // viewport(const QRectF & rect)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMatrix4x4Func_viewport_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // viewport(QRectF)
                cppSelf->viewport(*cppArg0);
            }
            break;
        }
        case 1: // viewport(float left, float bottom, float width, float height, float nearPlane, float farPlane)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nearPlane = Shiboken::String::createStaticString("nearPlane");
                if (PyDict_Contains(kwds, key_nearPlane)) {
                    value = PyDict_GetItem(kwds, key_nearPlane);
                    if (value && pyArgs[4]) {
                        errInfo = key_nearPlane;
                        Py_INCREF(errInfo);
                        goto Sbk_QMatrix4x4Func_viewport_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4]))))
                            goto Sbk_QMatrix4x4Func_viewport_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nearPlane);
                }
                static PyObject *const key_farPlane = Shiboken::String::createStaticString("farPlane");
                if (PyDict_Contains(kwds, key_farPlane)) {
                    value = PyDict_GetItem(kwds, key_farPlane);
                    if (value && pyArgs[5]) {
                        errInfo = key_farPlane;
                        Py_INCREF(errInfo);
                        goto Sbk_QMatrix4x4Func_viewport_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5]))))
                            goto Sbk_QMatrix4x4Func_viewport_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_farPlane);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMatrix4x4Func_viewport_TypeError;
                }
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4 = 0.0f;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            float cppArg5 = 1.0f;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // viewport(float,float,float,float,float,float)
                cppSelf->viewport(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x4Func_viewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMatrix4x4_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMatrix4x4_methods[] = {
    {"__dummy", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func___dummy), METH_O},
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func___reduce__), METH_NOARGS},
    {"column", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_column), METH_O},
    {"copyDataTo", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_copyDataTo), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_data), METH_NOARGS},
    {"determinant", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_determinant), METH_NOARGS},
    {"fill", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_fill), METH_O},
    {"flipCoordinates", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_flipCoordinates), METH_NOARGS},
    {"frustum", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_frustum), METH_VARARGS},
    {"inverted", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_inverted), METH_NOARGS},
    {"isAffine", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_isAffine), METH_NOARGS},
    {"isIdentity", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_isIdentity), METH_NOARGS},
    {"lookAt", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_lookAt), METH_VARARGS},
    {"map", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_map), METH_O},
    {"mapRect", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_mapRect), METH_O},
    {"mapVector", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_mapVector), METH_O},
    {"normalMatrix", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_normalMatrix), METH_NOARGS},
    {"optimize", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_optimize), METH_NOARGS},
    {"ortho", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_ortho), METH_VARARGS},
    {"perspective", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_perspective), METH_VARARGS},
    {"rotate", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_rotate), METH_VARARGS|METH_KEYWORDS},
    {"row", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_row), METH_O},
    {"scale", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_scale), METH_VARARGS},
    {"setColumn", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_setColumn), METH_VARARGS},
    {"setRow", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_setRow), METH_VARARGS},
    {"setToIdentity", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_setToIdentity), METH_NOARGS},
    {"toAffine", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_toAffine), METH_NOARGS},
    {"toTransform", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_toTransform), METH_VARARGS},
    {"translate", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_translate), METH_VARARGS},
    {"transposed", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_transposed), METH_NOARGS},
    {"viewport", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4Func_viewport), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x4___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QMatrix4x4Func___mul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__mul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator*(QMatrix4x4,QMatrix4x4)
    // 1: QMatrix4x4::operator*(QPoint,QMatrix4x4)
    // 2: QMatrix4x4::operator*(QPointF,QMatrix4x4)
    // 3: QMatrix4x4::operator*(float,QMatrix4x4)
    // 4: QMatrix4x4::operator*(QMatrix4x4,float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 4; // operator*(QMatrix4x4,float)
    } else if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 3; // operator*(float,QMatrix4x4)
    } else if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 1; // operator*(QPoint,QMatrix4x4)
    } else if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 2; // operator*(QPointF,QMatrix4x4)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // operator*(QMatrix4x4,QMatrix4x4)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___mul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*(const QMatrix4x4 & m2)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMatrix4x4 cppArg0_local;
            ::QMatrix4x4 *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator*(QMatrix4x4,QMatrix4x4)
                QMatrix4x4 cppResult = (*cppSelf) * (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator*(const QPoint & point)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator*(QPoint,QMatrix4x4) [reverse operator]
                QPoint cppResult = (*cppArg0) * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
            }
            break;
        }
        case 2: // operator*(const QPointF & point)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator*(QPointF,QMatrix4x4) [reverse operator]
                QPointF cppResult = (*cppArg0) * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
            }
            break;
        }
        case 3: // operator*(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(float,QMatrix4x4) [reverse operator]
                QMatrix4x4 cppResult = cppArg0 * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
            }
            break;
        }
        case 4: // operator*(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(QMatrix4x4,float)
                QMatrix4x4 cppResult = (*cppSelf) * cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func___mul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___imul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__imul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator*=(QMatrix4x4)
    // 1: QMatrix4x4::operator*=(float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 1; // operator*=(float)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // operator*=(QMatrix4x4)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___imul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*=(const QMatrix4x4 & other)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMatrix4x4 cppArg0_local;
            ::QMatrix4x4 *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator*=(QMatrix4x4)
                (*cppSelf) *= (*cppArg0);
            }
            break;
        }
        case 1: // operator*=(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*=(float)
                (*cppSelf) *= cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x4Func___imul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator+(QMatrix4x4,QMatrix4x4)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // operator+(QMatrix4x4,QMatrix4x4)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___add___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 cppArg0_local;
        ::QMatrix4x4 *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+(QMatrix4x4,QMatrix4x4)
            QMatrix4x4 cppResult = (*cppSelf) + (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator+=(QMatrix4x4)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QMatrix4x4)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___iadd___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 cppArg0_local;
        ::QMatrix4x4 *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+=(QMatrix4x4)
            (*cppSelf) += (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x4Func___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___neg__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__neg__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operator-(QMatrix4x4)
            QMatrix4x4 cppResult = - (*cppSelf);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x4Func___sub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__sub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator-(QMatrix4x4,QMatrix4x4)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // operator-(QMatrix4x4,QMatrix4x4)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___sub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 cppArg0_local;
        ::QMatrix4x4 *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-(QMatrix4x4,QMatrix4x4)
            QMatrix4x4 cppResult = (*cppSelf) - (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func___sub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator-=(QMatrix4x4)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // operator-=(QMatrix4x4)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___isub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 cppArg0_local;
        ::QMatrix4x4 *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-=(QMatrix4x4)
            (*cppSelf) -= (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x4Func___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___div__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__div__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator/(QMatrix4x4,float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // operator/(QMatrix4x4,float)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___div___TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/(QMatrix4x4,float)
            QMatrix4x4 cppResult = (*cppSelf) / cppArg0;
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func___div___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___idiv__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__idiv__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x4::operator/=(float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // operator/=(float)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x4Func___idiv___TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/=(float)
            (*cppSelf) /= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x4Func___idiv___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QMatrix4x4::operator<<(QDataStream&,QMatrix4x4)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QMatrix4x4)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QMatrix4x4Func___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QMatrix4x4) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x4Func___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x4.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QMatrix4x4::operator>>(QDataStream&,QMatrix4x4&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QMatrix4x4&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QMatrix4x4Func___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QMatrix4x4&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x4Func___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

PyObject* Sbk_QMatrix4x4Func___mgetitem__(PyObject *self, PyObject *_key)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtgui.cpp (qmatrix4x4-mgetitem)]
    if (PySequence_Check(_key)) {
        Shiboken::AutoDecRef key(PySequence_Fast(_key, "Invalid matrix index."));
        if (PySequence_Fast_GET_SIZE(key.object()) == 2) {
            PyObject *posx = PySequence_Fast_GET_ITEM(key.object(), 0);
            PyObject *posy = PySequence_Fast_GET_ITEM(key.object(), 1);
            Py_ssize_t x = PyInt_AsSsize_t(posx);
            Py_ssize_t y = PyInt_AsSsize_t(posy);
            float ret = (*cppSelf)(x,y);
            return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &ret);
        }
    }
    PyErr_SetString(PyExc_IndexError, "Invalid matrix index.");
    return 0;
    // END of custom code block [file: ../glue/qtgui.cpp (qmatrix4x4-mgetitem)]
    // ========================================================================

    // End of code injection

}

// Rich comparison
static PyObject * Sbk_QMatrix4x4_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
                // operator!=(const QMatrix4x4 & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMatrix4x4 cppArg0_local;
                ::QMatrix4x4 *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
                // operator==(const QMatrix4x4 & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMatrix4x4 cppArg0_local;
                ::QMatrix4x4 *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMatrix4x4_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMatrix4x4_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMatrix4x4_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMatrix4x4_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMatrix4x4_Type = nullptr;
static SbkObjectType *Sbk_QMatrix4x4_TypeF(void)
{
    return _Sbk_QMatrix4x4_Type;
}

static PyType_Slot Sbk_QMatrix4x4_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QMatrix4x4Func___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMatrix4x4_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMatrix4x4_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMatrix4x4_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMatrix4x4_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMatrix4x4_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports mapping protocol
    {Py_mp_subscript, (void *)&Sbk_QMatrix4x4Func___mgetitem__},
    {Py_mp_ass_subscript, (void *)0},
    {Py_mp_length, (void *)0},
    // type supports number protocol
    {Py_nb_inplace_multiply, (void *)Sbk_QMatrix4x4Func___imul__},
    {Py_nb_inplace_add, (void *)Sbk_QMatrix4x4Func___iadd__},
    {Py_nb_multiply, (void *)Sbk_QMatrix4x4Func___mul__},
    {Py_nb_rshift, (void *)Sbk_QMatrix4x4Func___rshift__},
    {Py_nb_add, (void *)Sbk_QMatrix4x4Func___add__},
    {Py_nb_inplace_subtract, (void *)Sbk_QMatrix4x4Func___isub__},
    {Py_nb_subtract, (void *)Sbk_QMatrix4x4Func___sub__},
    {Py_nb_lshift, (void *)Sbk_QMatrix4x4Func___lshift__},
    {Py_nb_negative, (void *)Sbk_QMatrix4x4Func___neg__},
    {Py_nb_true_divide, (void *)Sbk_QMatrix4x4Func___div__},
#ifndef IS_PY3K
    {Py_nb_divide, (void *)Sbk_QMatrix4x4Func___div__},
#endif
    // This function is unused in Python 3. We reference it here.
    {0, (void *)Sbk_QMatrix4x4Func___idiv__},
    // This list is ending at the first 0 entry.
    // Therefore, we need to put the unused functions at the very end.
    {0, nullptr}
};
static PyType_Spec Sbk_QMatrix4x4_spec = {
    "2:PySide2.QtGui.QMatrix4x4",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMatrix4x4_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMatrix4x4_PythonToCpp_QMatrix4x4_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMatrix4x4_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMatrix4x4_PythonToCpp_QMatrix4x4_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMatrix4x4_TypeF())))
        return QMatrix4x4_PythonToCpp_QMatrix4x4_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMatrix4x4_PTR_CppToPython_QMatrix4x4(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMatrix4x4 *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMatrix4x4_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMatrix4x4_COPY_CppToPython_QMatrix4x4(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMatrix4x4_TypeF(), new ::QMatrix4x4(*reinterpret_cast<const ::QMatrix4x4 *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMatrix4x4_PythonToCpp_QMatrix4x4_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMatrix4x4 *>(cppOut) = *reinterpret_cast< ::QMatrix4x4 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMatrix4x4_PythonToCpp_QMatrix4x4_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMatrix4x4_TypeF())))
        return QMatrix4x4_PythonToCpp_QMatrix4x4_COPY;
    return {};
}

// Implicit conversions.
static void constQMatrixREF_PythonToCpp_QMatrix4x4(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMatrix4x4 *>(cppOut) = ::QMatrix4x4( *reinterpret_cast< ::QMatrix *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQMatrixREF_PythonToCpp_QMatrix4x4_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX], pyIn))
        return constQMatrixREF_PythonToCpp_QMatrix4x4;
    return {};
}

static void constQTransformREF_PythonToCpp_QMatrix4x4(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMatrix4x4 *>(cppOut) = ::QMatrix4x4( *reinterpret_cast< ::QTransform *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQTransformREF_PythonToCpp_QMatrix4x4_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX], pyIn))
        return constQTransformREF_PythonToCpp_QMatrix4x4;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMatrix4x4_SignatureStrings[] = {
    "4:PySide2.QtGui.QMatrix4x4(self)",
    "3:PySide2.QtGui.QMatrix4x4(self,matrix:PySide2.QtGui.QMatrix)",
    "2:PySide2.QtGui.QMatrix4x4(self,transform:PySide2.QtGui.QTransform)",
    "1:PySide2.QtGui.QMatrix4x4(self,values:array float*)",
    "0:PySide2.QtGui.QMatrix4x4(self,m11:float,m12:float,m13:float,m14:float,m21:float,m22:float,m23:float,m24:float,m31:float,m32:float,m33:float,m34:float,m41:float,m42:float,m43:float,m44:float)",
    "PySide2.QtGui.QMatrix4x4.__dummy(self,arg__1:QList[float])",
    "PySide2.QtGui.QMatrix4x4.__reduce__(self)->PyObject",
    "PySide2.QtGui.QMatrix4x4.__repr__(self)->PyObject",
    "PySide2.QtGui.QMatrix4x4.column(self,index:int)->PySide2.QtGui.QVector4D",
    "PySide2.QtGui.QMatrix4x4.copyDataTo(self,values:float*)",
    "PySide2.QtGui.QMatrix4x4.data(self)->float*",
    "PySide2.QtGui.QMatrix4x4.determinant(self)->double",
    "PySide2.QtGui.QMatrix4x4.fill(self,value:float)",
    "PySide2.QtGui.QMatrix4x4.flipCoordinates(self)",
    "PySide2.QtGui.QMatrix4x4.frustum(self,left:float,right:float,bottom:float,top:float,nearPlane:float,farPlane:float)",
    "PySide2.QtGui.QMatrix4x4.inverted(self,invertible:bool*=nullptr)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.isAffine(self)->bool",
    "PySide2.QtGui.QMatrix4x4.isIdentity(self)->bool",
    "PySide2.QtGui.QMatrix4x4.lookAt(self,eye:PySide2.QtGui.QVector3D,center:PySide2.QtGui.QVector3D,up:PySide2.QtGui.QVector3D)",
    "3:PySide2.QtGui.QMatrix4x4.map(self,point:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "2:PySide2.QtGui.QMatrix4x4.map(self,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "1:PySide2.QtGui.QMatrix4x4.map(self,point:PySide2.QtGui.QVector3D)->PySide2.QtGui.QVector3D",
    "0:PySide2.QtGui.QMatrix4x4.map(self,point:PySide2.QtGui.QVector4D)->PySide2.QtGui.QVector4D",
    "1:PySide2.QtGui.QMatrix4x4.mapRect(self,rect:PySide2.QtCore.QRect)->PySide2.QtCore.QRect",
    "0:PySide2.QtGui.QMatrix4x4.mapRect(self,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QMatrix4x4.mapVector(self,vector:PySide2.QtGui.QVector3D)->PySide2.QtGui.QVector3D",
    "PySide2.QtGui.QMatrix4x4.normalMatrix(self)->PySide2.QtGui.QMatrix3x3",
    "PySide2.QtGui.QMatrix4x4.optimize(self)",
    "2:PySide2.QtGui.QMatrix4x4.ortho(self,rect:PySide2.QtCore.QRect)",
    "1:PySide2.QtGui.QMatrix4x4.ortho(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtGui.QMatrix4x4.ortho(self,left:float,right:float,bottom:float,top:float,nearPlane:float,farPlane:float)",
    "PySide2.QtGui.QMatrix4x4.perspective(self,verticalAngle:float,aspectRatio:float,nearPlane:float,farPlane:float)",
    "2:PySide2.QtGui.QMatrix4x4.rotate(self,quaternion:PySide2.QtGui.QQuaternion)",
    "1:PySide2.QtGui.QMatrix4x4.rotate(self,angle:float,vector:PySide2.QtGui.QVector3D)",
    "0:PySide2.QtGui.QMatrix4x4.rotate(self,angle:float,x:float,y:float,z:float=0.0f)",
    "PySide2.QtGui.QMatrix4x4.row(self,index:int)->PySide2.QtGui.QVector4D",
    "3:PySide2.QtGui.QMatrix4x4.scale(self,vector:PySide2.QtGui.QVector3D)",
    "2:PySide2.QtGui.QMatrix4x4.scale(self,factor:float)",
    "1:PySide2.QtGui.QMatrix4x4.scale(self,x:float,y:float)",
    "0:PySide2.QtGui.QMatrix4x4.scale(self,x:float,y:float,z:float)",
    "PySide2.QtGui.QMatrix4x4.setColumn(self,index:int,value:PySide2.QtGui.QVector4D)",
    "PySide2.QtGui.QMatrix4x4.setRow(self,index:int,value:PySide2.QtGui.QVector4D)",
    "PySide2.QtGui.QMatrix4x4.setToIdentity(self)",
    "PySide2.QtGui.QMatrix4x4.toAffine(self)->PySide2.QtGui.QMatrix",
    "1:PySide2.QtGui.QMatrix4x4.toTransform(self)->PySide2.QtGui.QTransform",
    "0:PySide2.QtGui.QMatrix4x4.toTransform(self,distanceToPlane:float)->PySide2.QtGui.QTransform",
    "2:PySide2.QtGui.QMatrix4x4.translate(self,vector:PySide2.QtGui.QVector3D)",
    "1:PySide2.QtGui.QMatrix4x4.translate(self,x:float,y:float)",
    "0:PySide2.QtGui.QMatrix4x4.translate(self,x:float,y:float,z:float)",
    "PySide2.QtGui.QMatrix4x4.transposed(self)->PySide2.QtGui.QMatrix4x4",
    "1:PySide2.QtGui.QMatrix4x4.viewport(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtGui.QMatrix4x4.viewport(self,left:float,bottom:float,width:float,height:float,nearPlane:float=0.0f,farPlane:float=1.0f)",
    "PySide2.QtGui.QMatrix4x4.__copy__()",
    "4:PySide2.QtGui.QMatrix4x4.__mul__(self,m2:PySide2.QtGui.QMatrix4x4)->PySide2.QtGui.QMatrix4x4",
    "3:PySide2.QtGui.QMatrix4x4.__mul__(self,point:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "2:PySide2.QtGui.QMatrix4x4.__mul__(self,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "1:PySide2.QtGui.QMatrix4x4.__mul__(self,factor:float)->PySide2.QtGui.QMatrix4x4",
    "0:PySide2.QtGui.QMatrix4x4.__mul__(self,factor:float)->PySide2.QtGui.QMatrix4x4",
    "1:PySide2.QtGui.QMatrix4x4.__imul__(self,other:PySide2.QtGui.QMatrix4x4)->PySide2.QtGui.QMatrix4x4",
    "0:PySide2.QtGui.QMatrix4x4.__imul__(self,factor:float)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__add__(self,m2:PySide2.QtGui.QMatrix4x4)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__iadd__(self,other:PySide2.QtGui.QMatrix4x4)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__neg__(self)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__sub__(self,m2:PySide2.QtGui.QMatrix4x4)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__isub__(self,other:PySide2.QtGui.QMatrix4x4)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__div__(self,divisor:float)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__idiv__(self,divisor:float)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtGui.QMatrix4x4.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QMatrix4x4.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QMatrix4x4(PyObject *module)
{
    _Sbk_QMatrix4x4_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMatrix4x4",
        "QMatrix4x4",
        &Sbk_QMatrix4x4_spec,
        &Shiboken::callCppDestructor< ::QMatrix4x4 >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMatrix4x4_Type);
    InitSignatureStrings(pyType, QMatrix4x4_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMatrix4x4_Type), Sbk_QMatrix4x4_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMatrix4x4_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMatrix4x4_TypeF(),
        QMatrix4x4_PythonToCpp_QMatrix4x4_PTR,
        is_QMatrix4x4_PythonToCpp_QMatrix4x4_PTR_Convertible,
        QMatrix4x4_PTR_CppToPython_QMatrix4x4,
        QMatrix4x4_COPY_CppToPython_QMatrix4x4);

    Shiboken::Conversions::registerConverterName(converter, "QMatrix4x4");
    Shiboken::Conversions::registerConverterName(converter, "QMatrix4x4*");
    Shiboken::Conversions::registerConverterName(converter, "QMatrix4x4&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMatrix4x4).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMatrix4x4_PythonToCpp_QMatrix4x4_COPY,
        is_QMatrix4x4_PythonToCpp_QMatrix4x4_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQMatrixREF_PythonToCpp_QMatrix4x4,
        is_constQMatrixREF_PythonToCpp_QMatrix4x4_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQTransformREF_PythonToCpp_QMatrix4x4,
        is_constQTransformREF_PythonToCpp_QMatrix4x4_Convertible);

    // Initialization of enums.

    qRegisterMetaType< ::QMatrix4x4 >("QMatrix4x4");
}
