/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglextrafunctions_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qopenglcontext.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLExtraFunctions_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLExtraFunctions >()))
        return -1;

    ::QOpenGLExtraFunctions *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QOpenGLExtraFunctions", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::QOpenGLExtraFunctions()
    // 1: QOpenGLExtraFunctions::QOpenGLExtraFunctions(QOpenGLContext*)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLExtraFunctions()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QOpenGLExtraFunctions(QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctions_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOpenGLExtraFunctions()
        {

            if (!PyErr_Occurred()) {
                // QOpenGLExtraFunctions()
                cptr = new ::QOpenGLExtraFunctions();
            }
            break;
        }
        case 1: // QOpenGLExtraFunctions(QOpenGLContext * context)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QOpenGLContext *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QOpenGLExtraFunctions(QOpenGLContext*)
                cptr = new ::QOpenGLExtraFunctions(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLExtraFunctions >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLExtraFunctions_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLExtraFunctions_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glActiveShaderProgram(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glActiveShaderProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glActiveShaderProgram", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glActiveShaderProgram(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glActiveShaderProgram(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glActiveShaderProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glActiveShaderProgram(uint,uint)
            cppSelf->glActiveShaderProgram(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glActiveShaderProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBeginQuery(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBeginQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginQuery", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBeginQuery(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginQuery(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBeginQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginQuery(uint,uint)
            cppSelf->glBeginQuery(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBeginQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBeginTransformFeedback(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBeginTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBeginTransformFeedback(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBeginTransformFeedback(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBeginTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBeginTransformFeedback(uint)
            cppSelf->glBeginTransformFeedback(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBeginTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBindBufferBase(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBindBufferBase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBufferBase", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBindBufferBase(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBindBufferBase(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBindBufferBase_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindBufferBase(uint,uint,uint)
            cppSelf->glBindBufferBase(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBindBufferBase_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBindImageTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBindImageTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindImageTexture", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBindImageTexture(uint,uint,int,unsigned char,int,uint,uint)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))) {
        overloadId = 0; // glBindImageTexture(uint,uint,int,unsigned char,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBindImageTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glBindImageTexture(uint,uint,int,unsigned char,int,uint,uint)
            cppSelf->glBindImageTexture(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBindImageTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBindProgramPipeline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBindProgramPipeline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBindProgramPipeline(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBindProgramPipeline(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBindProgramPipeline_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBindProgramPipeline(uint)
            cppSelf->glBindProgramPipeline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBindProgramPipeline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBindSampler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBindSampler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindSampler", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBindSampler(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindSampler(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBindSampler_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindSampler(uint,uint)
            cppSelf->glBindSampler(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBindSampler_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBindTransformFeedback(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBindTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindTransformFeedback", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBindTransformFeedback(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindTransformFeedback(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBindTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindTransformFeedback(uint,uint)
            cppSelf->glBindTransformFeedback(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBindTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBindVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBindVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBindVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBindVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBindVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBindVertexArray(uint)
            cppSelf->glBindVertexArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBindVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBlendBarrier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBlendBarrier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glBlendBarrier()
            cppSelf->glBlendBarrier();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationSeparatei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBlendEquationSeparatei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationSeparatei", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBlendEquationSeparatei(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBlendEquationSeparatei(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationSeparatei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBlendEquationSeparatei(uint,uint,uint)
            cppSelf->glBlendEquationSeparatei(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationSeparatei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBlendEquationi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBlendEquationi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendEquationi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendEquationi(uint,uint)
            cppSelf->glBlendEquationi(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBlendFuncSeparatei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBlendFuncSeparatei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFuncSeparatei", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBlendFuncSeparatei(uint,uint,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glBlendFuncSeparatei(uint,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBlendFuncSeparatei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glBlendFuncSeparatei(uint,uint,uint,uint,uint)
            cppSelf->glBlendFuncSeparatei(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBlendFuncSeparatei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBlendFunci(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBlendFunci";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFunci", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBlendFunci(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBlendFunci(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBlendFunci_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBlendFunci(uint,uint,uint)
            cppSelf->glBlendFunci(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBlendFunci_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glBlitFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glBlitFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlitFramebuffer", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))) {
        overloadId = 0; // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glBlitFramebuffer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
            cppSelf->glBlitFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glBlitFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferfi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfi", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glClearBufferfi(uint,int,float,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glClearBufferfi(uint,int,float,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearBufferfi(uint,int,float,int)
            cppSelf->glClearBufferfi(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glClearBufferfv(uint,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferfv(uint,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferfv(uint,int,const float*)
            cppSelf->glClearBufferfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glClearBufferiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glClearBufferiv(uint,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferiv(uint,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glClearBufferiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferiv(uint,int,const int*)
            cppSelf->glClearBufferiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glClearBufferiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glClearBufferuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glClearBufferuiv(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferuiv(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glClearBufferuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferuiv(uint,int,const uint*)
            cppSelf->glClearBufferuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glClearBufferuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glColorMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glColorMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMaski", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[4])))) {
        overloadId = 0; // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glColorMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned char cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMaski(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glColorMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glCompressedTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glCompressedTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glCopyImageSubData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glCopyImageSubData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyImageSubData", 15, 15, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12]), &(pyArgs[13]), &(pyArgs[14])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glCopyImageSubData(uint,uint,int,int,int,int,uint,uint,int,int,int,int,int,int,int)
    if (numArgs == 15
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[10])))
        && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[11])))
        && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[12])))
        && (pythonToCpp[13] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[13])))
        && (pythonToCpp[14] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[14])))) {
        overloadId = 0; // glCopyImageSubData(uint,uint,int,int,int,int,uint,uint,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glCopyImageSubData_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        int cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);
        int cppArg11;
        pythonToCpp[11](pyArgs[11], &cppArg11);
        int cppArg12;
        pythonToCpp[12](pyArgs[12], &cppArg12);
        int cppArg13;
        pythonToCpp[13](pyArgs[13], &cppArg13);
        int cppArg14;
        pythonToCpp[14](pyArgs[14], &cppArg14);

        if (!PyErr_Occurred()) {
            // glCopyImageSubData(uint,uint,int,int,int,int,uint,uint,int,int,int,int,int,int,int)
            cppSelf->glCopyImageSubData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12, cppArg13, cppArg14);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glCopyImageSubData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glCopyTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glCopyTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))) {
        overloadId = 0; // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glCopyTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glCopyTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageControl(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDebugMessageControl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDebugMessageControl", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDebugMessageControl(uint,uint,uint,int,const uint*,unsigned char)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[5])))) {
        overloadId = 0; // glDebugMessageControl(uint,uint,uint,int,const uint*,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageControl_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned char cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDebugMessageControl(uint,uint,uint,int,const uint*,unsigned char)
            cppSelf->glDebugMessageControl(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageControl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageInsert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDebugMessageInsert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDebugMessageInsert", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDebugMessageInsert(uint,uint,uint,uint,int,const char*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && Shiboken::String::check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[5])))) {
        overloadId = 0; // glDebugMessageInsert(uint,uint,uint,uint,int,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageInsert_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        const char* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDebugMessageInsert(uint,uint,uint,uint,int,const char*)
            cppSelf->glDebugMessageInsert(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageInsert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDeleteProgramPipelines(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteProgramPipelines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteProgramPipelines", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDeleteProgramPipelines(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteProgramPipelines(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDeleteProgramPipelines_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteProgramPipelines(int,const uint*)
            cppSelf->glDeleteProgramPipelines(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDeleteProgramPipelines_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDeleteQueries(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteQueries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteQueries", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDeleteQueries(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteQueries(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDeleteQueries_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteQueries(int,const uint*)
            cppSelf->glDeleteQueries(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDeleteQueries_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDeleteSamplers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteSamplers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteSamplers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDeleteSamplers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteSamplers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDeleteSamplers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteSamplers(int,const uint*)
            cppSelf->glDeleteSamplers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDeleteSamplers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDeleteTransformFeedbacks(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteTransformFeedbacks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteTransformFeedbacks", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDeleteTransformFeedbacks(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteTransformFeedbacks(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDeleteTransformFeedbacks_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteTransformFeedbacks(int,const uint*)
            cppSelf->glDeleteTransformFeedbacks(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDeleteTransformFeedbacks_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDeleteVertexArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteVertexArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteVertexArrays", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDeleteVertexArrays(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteVertexArrays(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDeleteVertexArrays_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteVertexArrays(int,const uint*)
            cppSelf->glDeleteVertexArrays(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDeleteVertexArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDisablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDisablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDisablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDisablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDisablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDisablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDisablei(uint,uint)
            cppSelf->glDisablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDisablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDispatchCompute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDispatchCompute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDispatchCompute", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDispatchCompute(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glDispatchCompute(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDispatchCompute_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDispatchCompute(uint,uint,uint)
            cppSelf->glDispatchCompute(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDispatchCompute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysIndirect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawArraysIndirect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysIndirect", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawArraysIndirect(uint,const void*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
        overloadId = 0; // glDrawArraysIndirect(uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysIndirect_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawArraysIndirect(uint,const void*)
            cppSelf->glDrawArraysIndirect(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysIndirect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawArraysInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysInstanced", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawArraysInstanced(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawArraysInstanced(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawArraysInstanced(uint,int,int,int)
            cppSelf->glDrawArraysInstanced(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDrawBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawBuffers(int,const uint*)
            cppSelf->glDrawBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsBaseVertex", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawElementsBaseVertex(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsBaseVertex(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsBaseVertex(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsIndirect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsIndirect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsIndirect", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawElementsIndirect(uint,uint,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawElementsIndirect(uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsIndirect_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawElementsIndirect(uint,uint,const void*)
            cppSelf->glDrawElementsIndirect(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsIndirect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstanced", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawElementsInstanced(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsInstanced(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstanced(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsInstanced(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstancedBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsInstancedBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstancedBaseVertex", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstancedBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
            cppSelf->glDrawElementsInstancedBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstancedBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawRangeElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElements", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
            cppSelf->glDrawRangeElements(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElementsBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glDrawRangeElementsBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElementsBaseVertex", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElementsBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
            cppSelf->glDrawRangeElementsBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElementsBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glEnablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glEnablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEnablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glEnablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glEnablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glEnablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEnablei(uint,uint)
            cppSelf->glEnablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glEnablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glEndQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glEndQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glEndQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEndQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glEndQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEndQuery(uint)
            cppSelf->glEndQuery(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glEndQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glFramebufferParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glFramebufferParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glFramebufferParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glFramebufferParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glFramebufferParameteri(uint,uint,int)
            cppSelf->glFramebufferParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glFramebufferParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glFramebufferTexture(uint,uint,uint,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glFramebufferTexture(uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture(uint,uint,uint,int)
            cppSelf->glFramebufferTexture(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTextureLayer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferTextureLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTextureLayer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glFramebufferTextureLayer(uint,uint,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTextureLayer(uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTextureLayer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTextureLayer(uint,uint,uint,int,int)
            cppSelf->glFramebufferTextureLayer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTextureLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGenProgramPipelines(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGenProgramPipelines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGenProgramPipelines", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGenProgramPipelines(int,uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glGenProgramPipelines(int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGenProgramPipelines_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGenProgramPipelines(int,uint*)
            cppSelf->glGenProgramPipelines(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGenProgramPipelines_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGenQueries(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGenQueries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGenQueries", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGenQueries(int,uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glGenQueries(int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGenQueries_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGenQueries(int,uint*)
            cppSelf->glGenQueries(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGenQueries_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGenSamplers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGenSamplers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGenSamplers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGenSamplers(int,uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glGenSamplers(int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGenSamplers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGenSamplers(int,uint*)
            cppSelf->glGenSamplers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGenSamplers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGenTransformFeedbacks(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGenTransformFeedbacks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGenTransformFeedbacks", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGenTransformFeedbacks(int,uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glGenTransformFeedbacks(int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGenTransformFeedbacks_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGenTransformFeedbacks(int,uint*)
            cppSelf->glGenTransformFeedbacks(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGenTransformFeedbacks_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGenVertexArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGenVertexArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGenVertexArrays", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGenVertexArrays(int,uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glGenVertexArrays(int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGenVertexArrays_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGenVertexArrays(int,uint*)
            cppSelf->glGenVertexArrays(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGenVertexArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformBlockiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetActiveUniformBlockiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetActiveUniformBlockiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetActiveUniformBlockiv(uint,uint,uint,int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glGetActiveUniformBlockiv(uint,uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformBlockiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetActiveUniformBlockiv(uint,uint,uint,int*)
            cppSelf->glGetActiveUniformBlockiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformBlockiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformsiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetActiveUniformsiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetActiveUniformsiv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetActiveUniformsiv(uint,int,const uint*,uint,int*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glGetActiveUniformsiv(uint,int,const uint*,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformsiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<int> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glGetActiveUniformsiv(uint,int,const uint*,uint,int*)
            cppSelf->glGetActiveUniformsiv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformsiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFragDataLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetFragDataLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetFragDataLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetFragDataLocation(uint,const char*)
            int cppResult = cppSelf->glGetFragDataLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glGetFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetFramebufferParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetFramebufferParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFramebufferParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetFramebufferParameteriv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetFramebufferParameteriv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetFramebufferParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetFramebufferParameteriv(uint,uint,int*)
            cppSelf->glGetFramebufferParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetFramebufferParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetGraphicsResetStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetGraphicsResetStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glGetGraphicsResetStatus()
            unsigned int cppResult = cppSelf->glGetGraphicsResetStatus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetIntegeri_v(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetIntegeri_v";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetIntegeri_v", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetIntegeri_v(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetIntegeri_v(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetIntegeri_v_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetIntegeri_v(uint,uint,int*)
            cppSelf->glGetIntegeri_v(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetIntegeri_v_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetInternalformativ(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetInternalformativ";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetInternalformativ", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetInternalformativ(uint,uint,uint,int,int*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glGetInternalformativ(uint,uint,uint,int,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetInternalformativ_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<int> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glGetInternalformativ(uint,uint,uint,int,int*)
            cppSelf->glGetInternalformativ(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetInternalformativ_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetMultisamplefv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetMultisamplefv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetMultisamplefv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetMultisamplefv(uint,uint,float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetMultisamplefv(uint,uint,float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetMultisamplefv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetMultisamplefv(uint,uint,float*)
            cppSelf->glGetMultisamplefv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetMultisamplefv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetProgramBinary(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramBinary";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramBinary", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetProgramBinary(uint,int,int*,uint*,void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glGetProgramBinary(uint,int,int*,uint*,void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetProgramBinary_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glGetProgramBinary(uint,int,int*,uint*,void*)
            cppSelf->glGetProgramBinary(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetProgramBinary_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetProgramInterfaceiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramInterfaceiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramInterfaceiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetProgramInterfaceiv(uint,uint,uint,int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glGetProgramInterfaceiv(uint,uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetProgramInterfaceiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetProgramInterfaceiv(uint,uint,uint,int*)
            cppSelf->glGetProgramInterfaceiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetProgramInterfaceiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetProgramPipelineiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramPipelineiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramPipelineiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetProgramPipelineiv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetProgramPipelineiv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetProgramPipelineiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetProgramPipelineiv(uint,uint,int*)
            cppSelf->glGetProgramPipelineiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetProgramPipelineiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramResourceIndex", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetProgramResourceIndex(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetProgramResourceIndex(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetProgramResourceIndex(uint,uint,const char*)
            unsigned int cppResult = cppSelf->glGetProgramResourceIndex(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramResourceLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetProgramResourceLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetProgramResourceLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetProgramResourceLocation(uint,uint,const char*)
            int cppResult = cppSelf->glGetProgramResourceLocation(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramResourceiv", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetProgramResourceiv(uint,uint,uint,int,const uint*,int,int*,int*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[7])))) {
        overloadId = 0; // glGetProgramResourceiv(uint,uint,uint,int,const uint*,int,int*,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        Shiboken::Conversions::ArrayHandle<int> cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        Shiboken::Conversions::ArrayHandle<int> cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glGetProgramResourceiv(uint,uint,uint,int,const uint*,int,int*,int*)
            cppSelf->glGetProgramResourceiv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetQueryObjectuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetQueryObjectuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetQueryObjectuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetQueryObjectuiv(uint,uint,uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetQueryObjectuiv(uint,uint,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetQueryObjectuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetQueryObjectuiv(uint,uint,uint*)
            cppSelf->glGetQueryObjectuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetQueryObjectuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetQueryiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetQueryiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetQueryiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetQueryiv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetQueryiv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetQueryiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetQueryiv(uint,uint,int*)
            cppSelf->glGetQueryiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetQueryiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetSamplerParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetSamplerParameterIiv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glGetSamplerParameterIiv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetSamplerParameterIiv(uint,uint,int*)
            cppSelf->glGetSamplerParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetSamplerParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetSamplerParameterIuiv(uint,uint,uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glGetSamplerParameterIuiv(uint,uint,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetSamplerParameterIuiv(uint,uint,uint*)
            cppSelf->glGetSamplerParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetSamplerParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetSamplerParameterfv(uint,uint,float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetSamplerParameterfv(uint,uint,float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetSamplerParameterfv(uint,uint,float*)
            cppSelf->glGetSamplerParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetSamplerParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetSamplerParameteriv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetSamplerParameteriv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetSamplerParameteriv(uint,uint,int*)
            cppSelf->glGetSamplerParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetStringi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetStringi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetStringi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetStringi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glGetStringi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetStringi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetStringi(uint,uint)
            const unsigned char * cppResult = cppSelf->glGetStringi(cppArg0, cppArg1);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (glgetstring-return)]
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
            // END of custom code block [file: ../glue/qtgui.cpp (glgetstring-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glGetStringi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexLevelParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetTexLevelParameterfv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetTexLevelParameterfv(uint,int,uint,float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glGetTexLevelParameterfv(uint,int,uint,float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetTexLevelParameterfv(uint,int,uint,float*)
            cppSelf->glGetTexLevelParameterfv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexLevelParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetTexLevelParameteriv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetTexLevelParameteriv(uint,int,uint,int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glGetTexLevelParameteriv(uint,int,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetTexLevelParameteriv(uint,int,uint,int*)
            cppSelf->glGetTexLevelParameteriv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetTexParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetTexParameterIiv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glGetTexParameterIiv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetTexParameterIiv(uint,uint,int*)
            cppSelf->glGetTexParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetTexParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetTexParameterIuiv(uint,uint,uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glGetTexParameterIuiv(uint,uint,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetTexParameterIuiv(uint,uint,uint*)
            cppSelf->glGetTexParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetUniformBlockIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetUniformBlockIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformBlockIndex", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetUniformBlockIndex(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformBlockIndex(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetUniformBlockIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformBlockIndex(uint,const char*)
            unsigned int cppResult = cppSelf->glGetUniformBlockIndex(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glGetUniformBlockIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetUniformuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetUniformuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetUniformuiv(uint,int,uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetUniformuiv(uint,int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetUniformuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetUniformuiv(uint,int,uint*)
            cppSelf->glGetUniformuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetUniformuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetVertexAttribIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetVertexAttribIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetVertexAttribIiv(uint,uint,int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetVertexAttribIiv(uint,uint,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetVertexAttribIiv(uint,uint,int*)
            cppSelf->glGetVertexAttribIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetVertexAttribIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetVertexAttribIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetVertexAttribIuiv(uint,uint,uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glGetVertexAttribIuiv(uint,uint,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetVertexAttribIuiv(uint,uint,uint*)
            cppSelf->glGetVertexAttribIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetnUniformfv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetnUniformfv(uint,int,int,float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glGetnUniformfv(uint,int,int,float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetnUniformfv(uint,int,int,float*)
            cppSelf->glGetnUniformfv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetnUniformiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetnUniformiv(uint,int,int,int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glGetnUniformiv(uint,int,int,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetnUniformiv(uint,int,int,int*)
            cppSelf->glGetnUniformiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetnUniformuiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glGetnUniformuiv(uint,int,int,uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glGetnUniformuiv(uint,int,int,uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glGetnUniformuiv(uint,int,int,uint*)
            cppSelf->glGetnUniformuiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glInvalidateFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glInvalidateFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInvalidateFramebuffer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glInvalidateFramebuffer(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glInvalidateFramebuffer(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glInvalidateFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glInvalidateFramebuffer(uint,int,const uint*)
            cppSelf->glInvalidateFramebuffer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glInvalidateFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glInvalidateSubFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glInvalidateSubFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInvalidateSubFramebuffer", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glInvalidateSubFramebuffer(uint,int,const uint*,int,int,int,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glInvalidateSubFramebuffer(uint,int,const uint*,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glInvalidateSubFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glInvalidateSubFramebuffer(uint,int,const uint*,int,int,int,int)
            cppSelf->glInvalidateSubFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glInvalidateSubFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glIsEnabledi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glIsEnabledi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glIsEnabledi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glIsEnabledi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glIsEnabledi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glIsEnabledi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glIsEnabledi(uint,uint)
            unsigned char cppResult = cppSelf->glIsEnabledi(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glIsEnabledi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glIsProgramPipeline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glIsProgramPipeline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glIsProgramPipeline(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsProgramPipeline(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glIsProgramPipeline_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsProgramPipeline(uint)
            unsigned char cppResult = cppSelf->glIsProgramPipeline(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glIsProgramPipeline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glIsQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glIsQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glIsQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glIsQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsQuery(uint)
            unsigned char cppResult = cppSelf->glIsQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glIsQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glIsSampler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glIsSampler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glIsSampler(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsSampler(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glIsSampler_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsSampler(uint)
            unsigned char cppResult = cppSelf->glIsSampler(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glIsSampler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glIsTransformFeedback(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glIsTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glIsTransformFeedback(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsTransformFeedback(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glIsTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsTransformFeedback(uint)
            unsigned char cppResult = cppSelf->glIsTransformFeedback(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glIsTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glIsVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glIsVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glIsVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glIsVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsVertexArray(uint)
            unsigned char cppResult = cppSelf->glIsVertexArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glIsVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrier(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glMemoryBarrier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glMemoryBarrier(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glMemoryBarrier(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrier_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMemoryBarrier(uint)
            cppSelf->glMemoryBarrier(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrier_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrierByRegion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glMemoryBarrierByRegion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glMemoryBarrierByRegion(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glMemoryBarrierByRegion(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrierByRegion_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMemoryBarrierByRegion(uint)
            cppSelf->glMemoryBarrierByRegion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrierByRegion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glMinSampleShading(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glMinSampleShading";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glMinSampleShading(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glMinSampleShading(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glMinSampleShading_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMinSampleShading(float)
            cppSelf->glMinSampleShading(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glMinSampleShading_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glObjectLabel(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glObjectLabel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glObjectLabel", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glObjectLabel(uint,uint,int,const char*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
        overloadId = 0; // glObjectLabel(uint,uint,int,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glObjectLabel_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glObjectLabel(uint,uint,int,const char*)
            cppSelf->glObjectLabel(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glObjectLabel_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glObjectPtrLabel(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glObjectPtrLabel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glObjectPtrLabel", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glObjectPtrLabel(const void*,int,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glObjectPtrLabel(const void*,int,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glObjectPtrLabel_TypeError;

    // Call function/method
    {
        void* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glObjectPtrLabel(const void*,int,const char*)
            cppSelf->glObjectPtrLabel(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glObjectPtrLabel_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glPatchParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glPatchParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPatchParameteri", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glPatchParameteri(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPatchParameteri(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glPatchParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPatchParameteri(uint,int)
            cppSelf->glPatchParameteri(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glPatchParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glPopDebugGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glPopDebugGroup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPopDebugGroup()
            cppSelf->glPopDebugGroup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glPrimitiveBoundingBox(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glPrimitiveBoundingBox";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPrimitiveBoundingBox", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glPrimitiveBoundingBox(float,float,float,float,float,float,float,float)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[7])))) {
        overloadId = 0; // glPrimitiveBoundingBox(float,float,float,float,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glPrimitiveBoundingBox_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        float cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        float cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        float cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glPrimitiveBoundingBox(float,float,float,float,float,float,float,float)
            cppSelf->glPrimitiveBoundingBox(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glPrimitiveBoundingBox_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramBinary(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramBinary";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramBinary", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramBinary(uint,uint,const void*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramBinary(uint,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramBinary_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramBinary(uint,uint,const void*,int)
            cppSelf->glProgramBinary(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramBinary_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramParameteri(uint,uint,int)
            cppSelf->glProgramParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform1f(uint,int,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1f(uint,int,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1f(uint,int,float)
            cppSelf->glProgramUniform1f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform1fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1fv(uint,int,int,const float*)
            cppSelf->glProgramUniform1fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform1i(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1i(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1i(uint,int,int)
            cppSelf->glProgramUniform1i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform1iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1iv(uint,int,int,const int*)
            cppSelf->glProgramUniform1iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform1ui(uint,int,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1ui(uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1ui(uint,int,uint)
            cppSelf->glProgramUniform1ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform1uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform1uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform2f(uint,int,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2f(uint,int,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2f(uint,int,float,float)
            cppSelf->glProgramUniform2f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform2fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2fv(uint,int,int,const float*)
            cppSelf->glProgramUniform2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform2i(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2i(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2i(uint,int,int,int)
            cppSelf->glProgramUniform2i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform2iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2iv(uint,int,int,const int*)
            cppSelf->glProgramUniform2iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform2ui(uint,int,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2ui(uint,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2ui(uint,int,uint,uint)
            cppSelf->glProgramUniform2ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform2uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform2uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3f", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform3f(uint,int,float,float,float)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3f(uint,int,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3f(uint,int,float,float,float)
            cppSelf->glProgramUniform3f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform3fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3fv(uint,int,int,const float*)
            cppSelf->glProgramUniform3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3i", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform3i(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3i(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3i(uint,int,int,int,int)
            cppSelf->glProgramUniform3i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform3iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3iv(uint,int,int,const int*)
            cppSelf->glProgramUniform3iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3ui", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform3ui(uint,int,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3ui(uint,int,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3ui(uint,int,uint,uint,uint)
            cppSelf->glProgramUniform3ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform3uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform3uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4f", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform4f(uint,int,float,float,float,float)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4f(uint,int,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        float cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4f(uint,int,float,float,float,float)
            cppSelf->glProgramUniform4f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform4fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4fv(uint,int,int,const float*)
            cppSelf->glProgramUniform4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4i", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform4i(uint,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4i(uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4i(uint,int,int,int,int,int)
            cppSelf->glProgramUniform4i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform4iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4iv(uint,int,int,const int*)
            cppSelf->glProgramUniform4iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4ui", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform4ui(uint,int,uint,uint,uint,uint)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4ui(uint,int,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4ui(uint,int,uint,uint,uint,uint)
            cppSelf->glProgramUniform4ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniform4uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform4uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix2fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix2fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2x3fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix2x3fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2x3fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2x3fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix2x3fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2x4fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix2x4fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2x4fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2x4fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix2x4fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix3fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix3fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3x2fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix3x2fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3x2fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3x2fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix3x2fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3x4fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix3x4fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3x4fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3x4fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix3x4fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix4fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix4fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4x2fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix4x2fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4x2fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4x2fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix4x2fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4x3fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glProgramUniformMatrix4x3fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4x3fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4x3fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix4x3fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glPushDebugGroup(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glPushDebugGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPushDebugGroup", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glPushDebugGroup(uint,uint,int,const char*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
        overloadId = 0; // glPushDebugGroup(uint,uint,int,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glPushDebugGroup_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glPushDebugGroup(uint,uint,int,const char*)
            cppSelf->glPushDebugGroup(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glPushDebugGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glReadBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glReadBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glReadBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glReadBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glReadBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glReadBuffer(uint)
            cppSelf->glReadBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glReadBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glReadnPixels(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glReadnPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glReadnPixels", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glReadnPixels(int,int,int,int,uint,uint,int,void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glReadnPixels(int,int,int,int,uint,uint,int,void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glReadnPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glReadnPixels(int,int,int,int,uint,uint,int,void*)
            cppSelf->glReadnPixels(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glReadnPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glRenderbufferStorageMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glRenderbufferStorageMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorageMultisample", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glRenderbufferStorageMultisample(uint,int,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glRenderbufferStorageMultisample(uint,int,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glRenderbufferStorageMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorageMultisample(uint,int,uint,int,int)
            cppSelf->glRenderbufferStorageMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glRenderbufferStorageMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSampleMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSampleMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSampleMaski", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSampleMaski(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glSampleMaski(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSampleMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSampleMaski(uint,uint)
            cppSelf->glSampleMaski(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSampleMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSamplerParameterIiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterIiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterIiv(uint,uint,const int*)
            cppSelf->glSamplerParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSamplerParameterIuiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterIuiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterIuiv(uint,uint,const uint*)
            cppSelf->glSamplerParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSamplerParameterf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterf(uint,uint,float)
            cppSelf->glSamplerParameterf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSamplerParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterfv(uint,uint,const float*)
            cppSelf->glSamplerParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSamplerParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameteri(uint,uint,int)
            cppSelf->glSamplerParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glSamplerParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameteriv(uint,uint,const int*)
            cppSelf->glSamplerParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexBuffer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexBuffer(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexBuffer(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexBuffer(uint,uint,uint)
            cppSelf->glTexBuffer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage3D", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[9])))) {
        overloadId = 0; // glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        void* cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexParameterIiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterIiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterIiv(uint,uint,const int*)
            cppSelf->glTexParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexParameterIuiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterIuiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterIuiv(uint,uint,const uint*)
            cppSelf->glTexParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage2D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexStorage2D(uint,int,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glTexStorage2D(uint,int,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glTexStorage2D(uint,int,uint,int,int)
            cppSelf->glTexStorage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2DMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage2DMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage2DMultisample", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexStorage2DMultisample(uint,int,uint,int,int,unsigned char)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[5])))) {
        overloadId = 0; // glTexStorage2DMultisample(uint,int,uint,int,int,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2DMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned char cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glTexStorage2DMultisample(uint,int,uint,int,int,unsigned char)
            cppSelf->glTexStorage2DMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2DMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage3D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexStorage3D(uint,int,uint,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glTexStorage3D(uint,int,uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glTexStorage3D(uint,int,uint,int,int,int)
            cppSelf->glTexStorage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3DMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage3DMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage3DMultisample", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexStorage3DMultisample(uint,int,uint,int,int,int,unsigned char)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && SbkChar_Check(pyArgs[6]) && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[6])))) {
        overloadId = 0; // glTexStorage3DMultisample(uint,int,uint,int,int,int,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3DMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned char cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glTexStorage3DMultisample(uint,int,uint,int,int,int,unsigned char)
            cppSelf->glTexStorage3DMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3DMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform1ui(int,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1ui(int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform1ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1ui(int,uint)
            cppSelf->glUniform1ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform1uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform1uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1uiv(int,int,const uint*)
            cppSelf->glUniform1uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform2ui(int,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2ui(int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform2ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2ui(int,uint,uint)
            cppSelf->glUniform2ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform2uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform2uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2uiv(int,int,const uint*)
            cppSelf->glUniform2uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform3ui(int,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3ui(int,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform3ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3ui(int,uint,uint,uint)
            cppSelf->glUniform3ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform3uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform3uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3uiv(int,int,const uint*)
            cppSelf->glUniform3uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4ui", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform4ui(int,uint,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4ui(int,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform4ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4ui(int,uint,uint,uint,uint)
            cppSelf->glUniform4ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniform4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniform4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniform4uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniform4uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4uiv(int,int,const uint*)
            cppSelf->glUniform4uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniform4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformBlockBinding(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformBlockBinding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformBlockBinding", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformBlockBinding(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniformBlockBinding(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformBlockBinding_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniformBlockBinding(uint,uint,uint)
            cppSelf->glUniformBlockBinding(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformBlockBinding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix2x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformMatrix2x3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2x3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix2x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformMatrix2x4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2x4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix3x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformMatrix3x2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3x2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix3x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformMatrix3x4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3x4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix4x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformMatrix4x2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4x2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix4x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUniformMatrix4x3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4x3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUnmapBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUnmapBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUnmapBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glUnmapBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUnmapBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glUnmapBuffer(uint)
            unsigned char cppResult = cppSelf->glUnmapBuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLExtraFunctionsFunc_glUnmapBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glUseProgramStages(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glUseProgramStages";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUseProgramStages", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glUseProgramStages(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUseProgramStages(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glUseProgramStages_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUseProgramStages(uint,uint,uint)
            cppSelf->glUseProgramStages(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glUseProgramStages_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glValidateProgramPipeline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glValidateProgramPipeline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glValidateProgramPipeline(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glValidateProgramPipeline(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glValidateProgramPipeline_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glValidateProgramPipeline(uint)
            cppSelf->glValidateProgramPipeline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glValidateProgramPipeline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribBinding(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribBinding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribBinding", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribBinding(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribBinding(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribBinding_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribBinding(uint,uint)
            cppSelf->glVertexAttribBinding(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribBinding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribDivisor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribDivisor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribDivisor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribDivisor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribDivisor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribDivisor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribDivisor(uint,uint)
            cppSelf->glVertexAttribDivisor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribDivisor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribFormat", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribFormat(uint,int,uint,unsigned char,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribFormat(uint,int,uint,unsigned char,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribFormat_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribFormat(uint,int,uint,unsigned char,uint)
            cppSelf->glVertexAttribFormat(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribI4i", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribI4i(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribI4i(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribI4i(uint,int,int,int,int)
            cppSelf->glVertexAttribI4i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribI4iv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribI4iv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribI4iv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribI4iv(uint,const int*)
            cppSelf->glVertexAttribI4iv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribI4ui", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribI4ui(uint,uint,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribI4ui(uint,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribI4ui(uint,uint,uint,uint,uint)
            cppSelf->glVertexAttribI4ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribI4uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribI4uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribI4uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribI4uiv(uint,const uint*)
            cppSelf->glVertexAttribI4uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribIFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribIFormat", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribIFormat(uint,int,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribIFormat(uint,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIFormat_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribIFormat(uint,int,uint,uint)
            cppSelf->glVertexAttribIFormat(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribIPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribIPointer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexAttribIPointer(uint,int,uint,int,const void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribIPointer(uint,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribIPointer(uint,int,uint,int,const void*)
            cppSelf->glVertexAttribIPointer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLExtraFunctionsFunc_glVertexBindingDivisor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLExtraFunctions *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLExtraFunctions.glVertexBindingDivisor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexBindingDivisor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLExtraFunctions::glVertexBindingDivisor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexBindingDivisor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLExtraFunctionsFunc_glVertexBindingDivisor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexBindingDivisor(uint,uint)
            cppSelf->glVertexBindingDivisor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLExtraFunctionsFunc_glVertexBindingDivisor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QOpenGLExtraFunctions_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLExtraFunctions_methods[] = {
    {"glActiveShaderProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glActiveShaderProgram), METH_VARARGS},
    {"glBeginQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBeginQuery), METH_VARARGS},
    {"glBeginTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBeginTransformFeedback), METH_O},
    {"glBindBufferBase", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBindBufferBase), METH_VARARGS},
    {"glBindImageTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBindImageTexture), METH_VARARGS},
    {"glBindProgramPipeline", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBindProgramPipeline), METH_O},
    {"glBindSampler", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBindSampler), METH_VARARGS},
    {"glBindTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBindTransformFeedback), METH_VARARGS},
    {"glBindVertexArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBindVertexArray), METH_O},
    {"glBlendBarrier", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBlendBarrier), METH_NOARGS},
    {"glBlendEquationSeparatei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationSeparatei), METH_VARARGS},
    {"glBlendEquationi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBlendEquationi), METH_VARARGS},
    {"glBlendFuncSeparatei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBlendFuncSeparatei), METH_VARARGS},
    {"glBlendFunci", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBlendFunci), METH_VARARGS},
    {"glBlitFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glBlitFramebuffer), METH_VARARGS},
    {"glClearBufferfi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfi), METH_VARARGS},
    {"glClearBufferfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glClearBufferfv), METH_VARARGS},
    {"glClearBufferiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glClearBufferiv), METH_VARARGS},
    {"glClearBufferuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glClearBufferuiv), METH_VARARGS},
    {"glColorMaski", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glColorMaski), METH_VARARGS},
    {"glCompressedTexImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexImage3D), METH_VARARGS},
    {"glCompressedTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glCompressedTexSubImage3D), METH_VARARGS},
    {"glCopyImageSubData", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glCopyImageSubData), METH_VARARGS},
    {"glCopyTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glCopyTexSubImage3D), METH_VARARGS},
    {"glDebugMessageControl", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageControl), METH_VARARGS},
    {"glDebugMessageInsert", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDebugMessageInsert), METH_VARARGS},
    {"glDeleteProgramPipelines", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDeleteProgramPipelines), METH_VARARGS},
    {"glDeleteQueries", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDeleteQueries), METH_VARARGS},
    {"glDeleteSamplers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDeleteSamplers), METH_VARARGS},
    {"glDeleteTransformFeedbacks", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDeleteTransformFeedbacks), METH_VARARGS},
    {"glDeleteVertexArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDeleteVertexArrays), METH_VARARGS},
    {"glDisablei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDisablei), METH_VARARGS},
    {"glDispatchCompute", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDispatchCompute), METH_VARARGS},
    {"glDrawArraysIndirect", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysIndirect), METH_VARARGS},
    {"glDrawArraysInstanced", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawArraysInstanced), METH_VARARGS},
    {"glDrawBuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawBuffers), METH_VARARGS},
    {"glDrawElementsBaseVertex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsBaseVertex), METH_VARARGS},
    {"glDrawElementsIndirect", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsIndirect), METH_VARARGS},
    {"glDrawElementsInstanced", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstanced), METH_VARARGS},
    {"glDrawElementsInstancedBaseVertex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawElementsInstancedBaseVertex), METH_VARARGS},
    {"glDrawRangeElements", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElements), METH_VARARGS},
    {"glDrawRangeElementsBaseVertex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glDrawRangeElementsBaseVertex), METH_VARARGS},
    {"glEnablei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glEnablei), METH_VARARGS},
    {"glEndQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glEndQuery), METH_O},
    {"glFramebufferParameteri", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glFramebufferParameteri), METH_VARARGS},
    {"glFramebufferTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTexture), METH_VARARGS},
    {"glFramebufferTextureLayer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glFramebufferTextureLayer), METH_VARARGS},
    {"glGenProgramPipelines", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGenProgramPipelines), METH_VARARGS},
    {"glGenQueries", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGenQueries), METH_VARARGS},
    {"glGenSamplers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGenSamplers), METH_VARARGS},
    {"glGenTransformFeedbacks", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGenTransformFeedbacks), METH_VARARGS},
    {"glGenVertexArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGenVertexArrays), METH_VARARGS},
    {"glGetActiveUniformBlockiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformBlockiv), METH_VARARGS},
    {"glGetActiveUniformsiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetActiveUniformsiv), METH_VARARGS},
    {"glGetFragDataLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetFragDataLocation), METH_VARARGS},
    {"glGetFramebufferParameteriv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetFramebufferParameteriv), METH_VARARGS},
    {"glGetGraphicsResetStatus", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetGraphicsResetStatus), METH_NOARGS},
    {"glGetIntegeri_v", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetIntegeri_v), METH_VARARGS},
    {"glGetInternalformativ", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetInternalformativ), METH_VARARGS},
    {"glGetMultisamplefv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetMultisamplefv), METH_VARARGS},
    {"glGetProgramBinary", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetProgramBinary), METH_VARARGS},
    {"glGetProgramInterfaceiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetProgramInterfaceiv), METH_VARARGS},
    {"glGetProgramPipelineiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetProgramPipelineiv), METH_VARARGS},
    {"glGetProgramResourceIndex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceIndex), METH_VARARGS},
    {"glGetProgramResourceLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceLocation), METH_VARARGS},
    {"glGetProgramResourceiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetProgramResourceiv), METH_VARARGS},
    {"glGetQueryObjectuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetQueryObjectuiv), METH_VARARGS},
    {"glGetQueryiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetQueryiv), METH_VARARGS},
    {"glGetSamplerParameterIiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIiv), METH_VARARGS},
    {"glGetSamplerParameterIuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterIuiv), METH_VARARGS},
    {"glGetSamplerParameterfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameterfv), METH_VARARGS},
    {"glGetSamplerParameteriv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetSamplerParameteriv), METH_VARARGS},
    {"glGetStringi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetStringi), METH_VARARGS},
    {"glGetTexLevelParameterfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameterfv), METH_VARARGS},
    {"glGetTexLevelParameteriv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetTexLevelParameteriv), METH_VARARGS},
    {"glGetTexParameterIiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIiv), METH_VARARGS},
    {"glGetTexParameterIuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetTexParameterIuiv), METH_VARARGS},
    {"glGetUniformBlockIndex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetUniformBlockIndex), METH_VARARGS},
    {"glGetUniformuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetUniformuiv), METH_VARARGS},
    {"glGetVertexAttribIiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIiv), METH_VARARGS},
    {"glGetVertexAttribIuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetVertexAttribIuiv), METH_VARARGS},
    {"glGetnUniformfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformfv), METH_VARARGS},
    {"glGetnUniformiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformiv), METH_VARARGS},
    {"glGetnUniformuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glGetnUniformuiv), METH_VARARGS},
    {"glInvalidateFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glInvalidateFramebuffer), METH_VARARGS},
    {"glInvalidateSubFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glInvalidateSubFramebuffer), METH_VARARGS},
    {"glIsEnabledi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glIsEnabledi), METH_VARARGS},
    {"glIsProgramPipeline", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glIsProgramPipeline), METH_O},
    {"glIsQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glIsQuery), METH_O},
    {"glIsSampler", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glIsSampler), METH_O},
    {"glIsTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glIsTransformFeedback), METH_O},
    {"glIsVertexArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glIsVertexArray), METH_O},
    {"glMemoryBarrier", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrier), METH_O},
    {"glMemoryBarrierByRegion", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glMemoryBarrierByRegion), METH_O},
    {"glMinSampleShading", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glMinSampleShading), METH_O},
    {"glObjectLabel", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glObjectLabel), METH_VARARGS},
    {"glObjectPtrLabel", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glObjectPtrLabel), METH_VARARGS},
    {"glPatchParameteri", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glPatchParameteri), METH_VARARGS},
    {"glPopDebugGroup", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glPopDebugGroup), METH_NOARGS},
    {"glPrimitiveBoundingBox", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glPrimitiveBoundingBox), METH_VARARGS},
    {"glProgramBinary", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramBinary), METH_VARARGS},
    {"glProgramParameteri", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramParameteri), METH_VARARGS},
    {"glProgramUniform1f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1f), METH_VARARGS},
    {"glProgramUniform1fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1fv), METH_VARARGS},
    {"glProgramUniform1i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1i), METH_VARARGS},
    {"glProgramUniform1iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1iv), METH_VARARGS},
    {"glProgramUniform1ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1ui), METH_VARARGS},
    {"glProgramUniform1uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform1uiv), METH_VARARGS},
    {"glProgramUniform2f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2f), METH_VARARGS},
    {"glProgramUniform2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2fv), METH_VARARGS},
    {"glProgramUniform2i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2i), METH_VARARGS},
    {"glProgramUniform2iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2iv), METH_VARARGS},
    {"glProgramUniform2ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2ui), METH_VARARGS},
    {"glProgramUniform2uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform2uiv), METH_VARARGS},
    {"glProgramUniform3f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3f), METH_VARARGS},
    {"glProgramUniform3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3fv), METH_VARARGS},
    {"glProgramUniform3i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3i), METH_VARARGS},
    {"glProgramUniform3iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3iv), METH_VARARGS},
    {"glProgramUniform3ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3ui), METH_VARARGS},
    {"glProgramUniform3uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform3uiv), METH_VARARGS},
    {"glProgramUniform4f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4f), METH_VARARGS},
    {"glProgramUniform4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4fv), METH_VARARGS},
    {"glProgramUniform4i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4i), METH_VARARGS},
    {"glProgramUniform4iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4iv), METH_VARARGS},
    {"glProgramUniform4ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4ui), METH_VARARGS},
    {"glProgramUniform4uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniform4uiv), METH_VARARGS},
    {"glProgramUniformMatrix2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2fv), METH_VARARGS},
    {"glProgramUniformMatrix2x3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x3fv), METH_VARARGS},
    {"glProgramUniformMatrix2x4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix2x4fv), METH_VARARGS},
    {"glProgramUniformMatrix3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3fv), METH_VARARGS},
    {"glProgramUniformMatrix3x2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x2fv), METH_VARARGS},
    {"glProgramUniformMatrix3x4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix3x4fv), METH_VARARGS},
    {"glProgramUniformMatrix4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4fv), METH_VARARGS},
    {"glProgramUniformMatrix4x2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x2fv), METH_VARARGS},
    {"glProgramUniformMatrix4x3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glProgramUniformMatrix4x3fv), METH_VARARGS},
    {"glPushDebugGroup", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glPushDebugGroup), METH_VARARGS},
    {"glReadBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glReadBuffer), METH_O},
    {"glReadnPixels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glReadnPixels), METH_VARARGS},
    {"glRenderbufferStorageMultisample", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glRenderbufferStorageMultisample), METH_VARARGS},
    {"glSampleMaski", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSampleMaski), METH_VARARGS},
    {"glSamplerParameterIiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIiv), METH_VARARGS},
    {"glSamplerParameterIuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterIuiv), METH_VARARGS},
    {"glSamplerParameterf", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterf), METH_VARARGS},
    {"glSamplerParameterfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameterfv), METH_VARARGS},
    {"glSamplerParameteri", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteri), METH_VARARGS},
    {"glSamplerParameteriv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glSamplerParameteriv), METH_VARARGS},
    {"glTexBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexBuffer), METH_VARARGS},
    {"glTexImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexImage3D), METH_VARARGS},
    {"glTexParameterIiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIiv), METH_VARARGS},
    {"glTexParameterIuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexParameterIuiv), METH_VARARGS},
    {"glTexStorage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2D), METH_VARARGS},
    {"glTexStorage2DMultisample", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexStorage2DMultisample), METH_VARARGS},
    {"glTexStorage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3D), METH_VARARGS},
    {"glTexStorage3DMultisample", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexStorage3DMultisample), METH_VARARGS},
    {"glTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glTexSubImage3D), METH_VARARGS},
    {"glUniform1ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform1ui), METH_VARARGS},
    {"glUniform1uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform1uiv), METH_VARARGS},
    {"glUniform2ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform2ui), METH_VARARGS},
    {"glUniform2uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform2uiv), METH_VARARGS},
    {"glUniform3ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform3ui), METH_VARARGS},
    {"glUniform3uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform3uiv), METH_VARARGS},
    {"glUniform4ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform4ui), METH_VARARGS},
    {"glUniform4uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniform4uiv), METH_VARARGS},
    {"glUniformBlockBinding", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformBlockBinding), METH_VARARGS},
    {"glUniformMatrix2x3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x3fv), METH_VARARGS},
    {"glUniformMatrix2x4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix2x4fv), METH_VARARGS},
    {"glUniformMatrix3x2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x2fv), METH_VARARGS},
    {"glUniformMatrix3x4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix3x4fv), METH_VARARGS},
    {"glUniformMatrix4x2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x2fv), METH_VARARGS},
    {"glUniformMatrix4x3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUniformMatrix4x3fv), METH_VARARGS},
    {"glUnmapBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUnmapBuffer), METH_O},
    {"glUseProgramStages", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glUseProgramStages), METH_VARARGS},
    {"glValidateProgramPipeline", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glValidateProgramPipeline), METH_O},
    {"glVertexAttribBinding", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribBinding), METH_VARARGS},
    {"glVertexAttribDivisor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribDivisor), METH_VARARGS},
    {"glVertexAttribFormat", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribFormat), METH_VARARGS},
    {"glVertexAttribI4i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4i), METH_VARARGS},
    {"glVertexAttribI4iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4iv), METH_VARARGS},
    {"glVertexAttribI4ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4ui), METH_VARARGS},
    {"glVertexAttribI4uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribI4uiv), METH_VARARGS},
    {"glVertexAttribIFormat", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIFormat), METH_VARARGS},
    {"glVertexAttribIPointer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexAttribIPointer), METH_VARARGS},
    {"glVertexBindingDivisor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLExtraFunctionsFunc_glVertexBindingDivisor), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QOpenGLExtraFunctions_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLExtraFunctions_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLExtraFunctions_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLExtraFunctions_TypeF(void)
{
    return _Sbk_QOpenGLExtraFunctions_Type;
}

static PyType_Slot Sbk_QOpenGLExtraFunctions_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLExtraFunctions_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLExtraFunctions_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLExtraFunctions_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLExtraFunctions_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLExtraFunctions_spec = {
    "2:PySide2.QtGui.QOpenGLExtraFunctions",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLExtraFunctions_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLExtraFunctions_PythonToCpp_QOpenGLExtraFunctions_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLExtraFunctions_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLExtraFunctions_PythonToCpp_QOpenGLExtraFunctions_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLExtraFunctions_TypeF())))
        return QOpenGLExtraFunctions_PythonToCpp_QOpenGLExtraFunctions_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLExtraFunctions_PTR_CppToPython_QOpenGLExtraFunctions(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLExtraFunctions *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLExtraFunctions_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLExtraFunctions_SignatureStrings[] = {
    "1:PySide2.QtGui.QOpenGLExtraFunctions(self)",
    "0:PySide2.QtGui.QOpenGLExtraFunctions(self,context:PySide2.QtGui.QOpenGLContext)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glActiveShaderProgram(self,pipeline:unsigned int,program:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBeginQuery(self,target:unsigned int,id:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBeginTransformFeedback(self,primitiveMode:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindBufferBase(self,target:unsigned int,index:unsigned int,buffer:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindImageTexture(self,unit:unsigned int,texture:unsigned int,level:int,layered:unsigned char,layer:int,access:unsigned int,format:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindProgramPipeline(self,pipeline:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindSampler(self,unit:unsigned int,sampler:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindTransformFeedback(self,target:unsigned int,id:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindVertexArray(self,array:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendBarrier(self)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendEquationSeparatei(self,buf:unsigned int,modeRGB:unsigned int,modeAlpha:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendEquationi(self,buf:unsigned int,mode:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendFuncSeparatei(self,buf:unsigned int,srcRGB:unsigned int,dstRGB:unsigned int,srcAlpha:unsigned int,dstAlpha:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendFunci(self,buf:unsigned int,src:unsigned int,dst:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlitFramebuffer(self,srcX0:int,srcY0:int,srcX1:int,srcY1:int,dstX0:int,dstY0:int,dstX1:int,dstY1:int,mask:unsigned int,filter:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferfi(self,buffer:unsigned int,drawbuffer:int,depth:float,stencil:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferfv(self,buffer:unsigned int,drawbuffer:int,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferiv(self,buffer:unsigned int,drawbuffer:int,value:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferuiv(self,buffer:unsigned int,drawbuffer:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glColorMaski(self,index:unsigned int,r:unsigned char,g:unsigned char,b:unsigned char,a:unsigned char)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glCompressedTexImage3D(self,target:unsigned int,level:int,internalformat:unsigned int,width:int,height:int,depth:int,border:int,imageSize:int,data:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glCompressedTexSubImage3D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,zoffset:int,width:int,height:int,depth:int,format:unsigned int,imageSize:int,data:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glCopyImageSubData(self,srcName:unsigned int,srcTarget:unsigned int,srcLevel:int,srcX:int,srcY:int,srcZ:int,dstName:unsigned int,dstTarget:unsigned int,dstLevel:int,dstX:int,dstY:int,dstZ:int,srcWidth:int,srcHeight:int,srcDepth:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glCopyTexSubImage3D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,zoffset:int,x:int,y:int,width:int,height:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDebugMessageControl(self,source:unsigned int,type:unsigned int,severity:unsigned int,count:int,ids:array unsigned int*,enabled:unsigned char)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDebugMessageInsert(self,source:unsigned int,type:unsigned int,id:unsigned int,severity:unsigned int,length:int,buf:char*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteProgramPipelines(self,n:int,pipelines:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteQueries(self,n:int,ids:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteSamplers(self,count:int,samplers:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteTransformFeedbacks(self,n:int,ids:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteVertexArrays(self,n:int,arrays:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDisablei(self,target:unsigned int,index:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDispatchCompute(self,num_groups_x:unsigned int,num_groups_y:unsigned int,num_groups_z:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawArraysIndirect(self,mode:unsigned int,indirect:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawArraysInstanced(self,mode:unsigned int,first:int,count:int,instancecount:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawBuffers(self,n:int,bufs:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsBaseVertex(self,mode:unsigned int,count:int,type:unsigned int,indices:void,basevertex:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsIndirect(self,mode:unsigned int,type:unsigned int,indirect:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsInstanced(self,mode:unsigned int,count:int,type:unsigned int,indices:void,instancecount:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsInstancedBaseVertex(self,mode:unsigned int,count:int,type:unsigned int,indices:void,instancecount:int,basevertex:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawRangeElements(self,mode:unsigned int,start:unsigned int,end:unsigned int,count:int,type:unsigned int,indices:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawRangeElementsBaseVertex(self,mode:unsigned int,start:unsigned int,end:unsigned int,count:int,type:unsigned int,indices:void,basevertex:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glEnablei(self,target:unsigned int,index:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glEndQuery(self,target:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferParameteri(self,target:unsigned int,pname:unsigned int,param:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferTexture(self,target:unsigned int,attachment:unsigned int,texture:unsigned int,level:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferTextureLayer(self,target:unsigned int,attachment:unsigned int,texture:unsigned int,level:int,layer:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenProgramPipelines(self,n:int,pipelines:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenQueries(self,n:int,ids:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenSamplers(self,count:int,samplers:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenTransformFeedbacks(self,n:int,ids:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenVertexArrays(self,n:int,arrays:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetActiveUniformBlockiv(self,program:unsigned int,uniformBlockIndex:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetActiveUniformsiv(self,program:unsigned int,uniformCount:int,uniformIndices:array unsigned int*,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetFragDataLocation(self,program:unsigned int,name:char*)->int",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetFramebufferParameteriv(self,target:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetGraphicsResetStatus(self)->unsigned int",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetIntegeri_v(self,target:unsigned int,index:unsigned int,data:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetInternalformativ(self,target:unsigned int,internalformat:unsigned int,pname:unsigned int,bufSize:int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetMultisamplefv(self,pname:unsigned int,index:unsigned int,val:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramBinary(self,program:unsigned int,bufSize:int,length:int*,binaryFormat:unsigned int*,binary:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramInterfaceiv(self,program:unsigned int,programInterface:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramPipelineiv(self,pipeline:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceIndex(self,program:unsigned int,programInterface:unsigned int,name:char*)->unsigned int",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceLocation(self,program:unsigned int,programInterface:unsigned int,name:char*)->int",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceiv(self,program:unsigned int,programInterface:unsigned int,index:unsigned int,propCount:int,props:array unsigned int*,bufSize:int,length:array int*,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetQueryObjectuiv(self,id:unsigned int,pname:unsigned int,params:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetQueryiv(self,target:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterIiv(self,sampler:unsigned int,pname:unsigned int,params:int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterIuiv(self,sampler:unsigned int,pname:unsigned int,params:unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterfv(self,sampler:unsigned int,pname:unsigned int,params:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameteriv(self,sampler:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetStringi(self,name:unsigned int,index:unsigned int)->unsigned char*",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexLevelParameterfv(self,target:unsigned int,level:int,pname:unsigned int,params:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexLevelParameteriv(self,target:unsigned int,level:int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexParameterIiv(self,target:unsigned int,pname:unsigned int,params:int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexParameterIuiv(self,target:unsigned int,pname:unsigned int,params:unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetUniformBlockIndex(self,program:unsigned int,uniformBlockName:char*)->unsigned int",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetUniformuiv(self,program:unsigned int,location:int,params:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetVertexAttribIiv(self,index:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetVertexAttribIuiv(self,index:unsigned int,pname:unsigned int,params:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformfv(self,program:unsigned int,location:int,bufSize:int,params:float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformiv(self,program:unsigned int,location:int,bufSize:int,params:int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformuiv(self,program:unsigned int,location:int,bufSize:int,params:unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glInvalidateFramebuffer(self,target:unsigned int,numAttachments:int,attachments:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glInvalidateSubFramebuffer(self,target:unsigned int,numAttachments:int,attachments:array unsigned int*,x:int,y:int,width:int,height:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsEnabledi(self,target:unsigned int,index:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsProgramPipeline(self,pipeline:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsQuery(self,id:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsSampler(self,sampler:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsTransformFeedback(self,id:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsVertexArray(self,array:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glMemoryBarrier(self,barriers:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glMemoryBarrierByRegion(self,barriers:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glMinSampleShading(self,value:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glObjectLabel(self,identifier:unsigned int,name:unsigned int,length:int,label:char*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glObjectPtrLabel(self,ptr:void,length:int,label:char*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glPatchParameteri(self,pname:unsigned int,value:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glPopDebugGroup(self)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glPrimitiveBoundingBox(self,minX:float,minY:float,minZ:float,minW:float,maxX:float,maxY:float,maxZ:float,maxW:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramBinary(self,program:unsigned int,binaryFormat:unsigned int,binary:void,length:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramParameteri(self,program:unsigned int,pname:unsigned int,value:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1f(self,program:unsigned int,location:int,v0:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1fv(self,program:unsigned int,location:int,count:int,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1i(self,program:unsigned int,location:int,v0:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1iv(self,program:unsigned int,location:int,count:int,value:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1ui(self,program:unsigned int,location:int,v0:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1uiv(self,program:unsigned int,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2f(self,program:unsigned int,location:int,v0:float,v1:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2fv(self,program:unsigned int,location:int,count:int,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2i(self,program:unsigned int,location:int,v0:int,v1:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2iv(self,program:unsigned int,location:int,count:int,value:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2ui(self,program:unsigned int,location:int,v0:unsigned int,v1:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2uiv(self,program:unsigned int,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3f(self,program:unsigned int,location:int,v0:float,v1:float,v2:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3fv(self,program:unsigned int,location:int,count:int,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3i(self,program:unsigned int,location:int,v0:int,v1:int,v2:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3iv(self,program:unsigned int,location:int,count:int,value:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3ui(self,program:unsigned int,location:int,v0:unsigned int,v1:unsigned int,v2:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3uiv(self,program:unsigned int,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4f(self,program:unsigned int,location:int,v0:float,v1:float,v2:float,v3:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4fv(self,program:unsigned int,location:int,count:int,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4i(self,program:unsigned int,location:int,v0:int,v1:int,v2:int,v3:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4iv(self,program:unsigned int,location:int,count:int,value:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4ui(self,program:unsigned int,location:int,v0:unsigned int,v1:unsigned int,v2:unsigned int,v3:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4uiv(self,program:unsigned int,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2x3fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2x4fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3x2fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3x4fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4x2fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4x3fv(self,program:unsigned int,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glPushDebugGroup(self,source:unsigned int,id:unsigned int,length:int,message:char*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glReadBuffer(self,mode:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glReadnPixels(self,x:int,y:int,width:int,height:int,format:unsigned int,type:unsigned int,bufSize:int,data:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glRenderbufferStorageMultisample(self,target:unsigned int,samples:int,internalformat:unsigned int,width:int,height:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSampleMaski(self,maskNumber:unsigned int,mask:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterIiv(self,sampler:unsigned int,pname:unsigned int,param:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterIuiv(self,sampler:unsigned int,pname:unsigned int,param:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterf(self,sampler:unsigned int,pname:unsigned int,param:float)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterfv(self,sampler:unsigned int,pname:unsigned int,param:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameteri(self,sampler:unsigned int,pname:unsigned int,param:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameteriv(self,sampler:unsigned int,pname:unsigned int,param:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexBuffer(self,target:unsigned int,internalformat:unsigned int,buffer:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexImage3D(self,target:unsigned int,level:int,internalformat:int,width:int,height:int,depth:int,border:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexParameterIiv(self,target:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexParameterIuiv(self,target:unsigned int,pname:unsigned int,params:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage2D(self,target:unsigned int,levels:int,internalformat:unsigned int,width:int,height:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage2DMultisample(self,target:unsigned int,samples:int,internalformat:unsigned int,width:int,height:int,fixedsamplelocations:unsigned char)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage3D(self,target:unsigned int,levels:int,internalformat:unsigned int,width:int,height:int,depth:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage3DMultisample(self,target:unsigned int,samples:int,internalformat:unsigned int,width:int,height:int,depth:int,fixedsamplelocations:unsigned char)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexSubImage3D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,zoffset:int,width:int,height:int,depth:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform1ui(self,location:int,v0:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform1uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform2ui(self,location:int,v0:unsigned int,v1:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform2uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform3ui(self,location:int,v0:unsigned int,v1:unsigned int,v2:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform3uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform4ui(self,location:int,v0:unsigned int,v1:unsigned int,v2:unsigned int,v3:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform4uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformBlockBinding(self,program:unsigned int,uniformBlockIndex:unsigned int,uniformBlockBinding:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix2x3fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix2x4fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix3x2fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix3x4fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix4x2fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix4x3fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUnmapBuffer(self,target:unsigned int)->unsigned char",
    "PySide2.QtGui.QOpenGLExtraFunctions.glUseProgramStages(self,pipeline:unsigned int,stages:unsigned int,program:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glValidateProgramPipeline(self,pipeline:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribBinding(self,attribindex:unsigned int,bindingindex:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribDivisor(self,index:unsigned int,divisor:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribFormat(self,attribindex:unsigned int,size:int,type:unsigned int,normalized:unsigned char,relativeoffset:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4i(self,index:unsigned int,x:int,y:int,z:int,w:int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4iv(self,index:unsigned int,v:array int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4ui(self,index:unsigned int,x:unsigned int,y:unsigned int,z:unsigned int,w:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4uiv(self,index:unsigned int,v:array unsigned int*)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribIFormat(self,attribindex:unsigned int,size:int,type:unsigned int,relativeoffset:unsigned int)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribIPointer(self,index:unsigned int,size:int,type:unsigned int,stride:int,pointer:void)",
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexBindingDivisor(self,bindingindex:unsigned int,divisor:unsigned int)",
    nullptr}; // Sentinel

void init_QOpenGLExtraFunctions(PyObject *module)
{
    _Sbk_QOpenGLExtraFunctions_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLExtraFunctions",
        "QOpenGLExtraFunctions*",
        &Sbk_QOpenGLExtraFunctions_spec,
        &Shiboken::callCppDestructor< ::QOpenGLExtraFunctions >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFUNCTIONS_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLExtraFunctions_Type);
    InitSignatureStrings(pyType, QOpenGLExtraFunctions_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLExtraFunctions_Type), Sbk_QOpenGLExtraFunctions_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLExtraFunctions_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLExtraFunctions_TypeF(),
        QOpenGLExtraFunctions_PythonToCpp_QOpenGLExtraFunctions_PTR,
        is_QOpenGLExtraFunctions_PythonToCpp_QOpenGLExtraFunctions_PTR_Convertible,
        QOpenGLExtraFunctions_PTR_CppToPython_QOpenGLExtraFunctions);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLExtraFunctions");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLExtraFunctions*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLExtraFunctions&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLExtraFunctions).name());


}
