/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglframebufferobject_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLFramebufferObjectWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLFramebufferObjectWrapper::QOpenGLFramebufferObjectWrapper(const ::QSize & size, ::QOpenGLFramebufferObject::Attachment attachment, unsigned int target, unsigned int internalFormat) : QOpenGLFramebufferObject(size, attachment, target, internalFormat)
{
    resetPyMethodCache();
    // ... middle
}

QOpenGLFramebufferObjectWrapper::QOpenGLFramebufferObjectWrapper(const ::QSize & size, const ::QOpenGLFramebufferObjectFormat & format) : QOpenGLFramebufferObject(size, format)
{
    resetPyMethodCache();
    // ... middle
}

QOpenGLFramebufferObjectWrapper::QOpenGLFramebufferObjectWrapper(const ::QSize & size, unsigned int target) : QOpenGLFramebufferObject(size, target)
{
    resetPyMethodCache();
    // ... middle
}

QOpenGLFramebufferObjectWrapper::QOpenGLFramebufferObjectWrapper(int width, int height, ::QOpenGLFramebufferObject::Attachment attachment, unsigned int target, unsigned int internalFormat) : QOpenGLFramebufferObject(width, height, attachment, target, internalFormat)
{
    resetPyMethodCache();
    // ... middle
}

QOpenGLFramebufferObjectWrapper::QOpenGLFramebufferObjectWrapper(int width, int height, const ::QOpenGLFramebufferObjectFormat & format) : QOpenGLFramebufferObject(width, height, format)
{
    resetPyMethodCache();
    // ... middle
}

QOpenGLFramebufferObjectWrapper::QOpenGLFramebufferObjectWrapper(int width, int height, unsigned int target) : QOpenGLFramebufferObject(width, height, target)
{
    resetPyMethodCache();
    // ... middle
}

QOpenGLFramebufferObjectWrapper::~QOpenGLFramebufferObjectWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLFramebufferObject_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLFramebufferObject >()))
        return -1;

    ::QOpenGLFramebufferObjectWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QOpenGLFramebufferObject", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLFramebufferObject::QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObject::Attachment,uint,uint)
    // 1: QOpenGLFramebufferObject::QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObjectFormat)
    // 2: QOpenGLFramebufferObject::QOpenGLFramebufferObject(QSize,uint)
    // 3: QOpenGLFramebufferObject::QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObject::Attachment,uint,uint)
    // 4: QOpenGLFramebufferObject::QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObjectFormat)
    // 5: QOpenGLFramebufferObject::QOpenGLFramebufferObject(int,int,uint)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 5; // QOpenGLFramebufferObject(int,int,uint)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArgs[2])))) {
            overloadId = 4; // QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObjectFormat)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 3; // QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObject::Attachment,uint,uint)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 3; // QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObject::Attachment,uint,uint)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
                    overloadId = 3; // QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObject::Attachment,uint,uint)
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
            overloadId = 5; // QOpenGLFramebufferObject(int,int,uint)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QOpenGLFramebufferObject(QSize,uint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObjectFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObject::Attachment,uint,uint)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObject::Attachment,uint,uint)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
                    overloadId = 0; // QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObject::Attachment,uint,uint)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            overloadId = 2; // QOpenGLFramebufferObject(QSize,uint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFramebufferObject_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOpenGLFramebufferObject(const QSize & size, QOpenGLFramebufferObject::Attachment attachment, unsigned int target, unsigned int internalFormat)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[2]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2]))))
                            goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                static PyObject *const key_internalFormat = Shiboken::String::createStaticString("internalFormat");
                if (PyDict_Contains(kwds, key_internalFormat)) {
                    value = PyDict_GetItem(kwds, key_internalFormat);
                    if (value && pyArgs[3]) {
                        errInfo = key_internalFormat;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3]))))
                            goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_internalFormat);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QOpenGLFramebufferObject::Attachment cppArg1{QOpenGLFramebufferObject::NoAttachment};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            unsigned int cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            unsigned int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObject::Attachment,uint,uint)
                cptr = new ::QOpenGLFramebufferObjectWrapper(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // QOpenGLFramebufferObject(const QSize & size, const QOpenGLFramebufferObjectFormat & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QOpenGLFramebufferObjectFormat cppArg1_local;
            ::QOpenGLFramebufferObjectFormat *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QOpenGLFramebufferObject(QSize,QOpenGLFramebufferObjectFormat)
                cptr = new ::QOpenGLFramebufferObjectWrapper(*cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // QOpenGLFramebufferObject(const QSize & size, unsigned int target)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[1]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1]))))
                            goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            unsigned int cppArg1 = GL_TEXTURE_2D;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QOpenGLFramebufferObject(QSize,uint)
                cptr = new ::QOpenGLFramebufferObjectWrapper(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QOpenGLFramebufferObject(int width, int height, QOpenGLFramebufferObject::Attachment attachment, unsigned int target, unsigned int internalFormat)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[3]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3]))))
                            goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                static PyObject *const key_internalFormat = Shiboken::String::createStaticString("internalFormat");
                if (PyDict_Contains(kwds, key_internalFormat)) {
                    value = PyDict_GetItem(kwds, key_internalFormat);
                    if (value && pyArgs[4]) {
                        errInfo = key_internalFormat;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4]))))
                            goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_internalFormat);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLFramebufferObject::Attachment cppArg2{QOpenGLFramebufferObject::NoAttachment};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            unsigned int cppArg3 = GL_TEXTURE_2D;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            unsigned int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObject::Attachment,uint,uint)
                cptr = new ::QOpenGLFramebufferObjectWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 4: // QOpenGLFramebufferObject(int width, int height, const QOpenGLFramebufferObjectFormat & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QOpenGLFramebufferObjectFormat cppArg2_local;
            ::QOpenGLFramebufferObjectFormat *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // QOpenGLFramebufferObject(int,int,QOpenGLFramebufferObjectFormat)
                cptr = new ::QOpenGLFramebufferObjectWrapper(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 5: // QOpenGLFramebufferObject(int width, int height, unsigned int target)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[2]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2]))))
                            goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObject_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            unsigned int cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QOpenGLFramebufferObject(int,int,uint)
                cptr = new ::QOpenGLFramebufferObjectWrapper(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLFramebufferObject >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLFramebufferObject_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLFramebufferObject_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.addColorAttachment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addColorAttachment", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFramebufferObject::addColorAttachment(QSize,uint)
    // 1: QOpenGLFramebufferObject::addColorAttachment(int,int,uint)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // addColorAttachment(int,int,uint)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
            overloadId = 1; // addColorAttachment(int,int,uint)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addColorAttachment(QSize,uint)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            overloadId = 0; // addColorAttachment(QSize,uint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addColorAttachment(const QSize & size, unsigned int internalFormat)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_internalFormat = Shiboken::String::createStaticString("internalFormat");
                if (PyDict_Contains(kwds, key_internalFormat)) {
                    value = PyDict_GetItem(kwds, key_internalFormat);
                    if (value && pyArgs[1]) {
                        errInfo = key_internalFormat;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1]))))
                            goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_internalFormat);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            unsigned int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addColorAttachment(QSize,uint)
                cppSelf->addColorAttachment(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // addColorAttachment(int width, int height, unsigned int internalFormat)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_internalFormat = Shiboken::String::createStaticString("internalFormat");
                if (PyDict_Contains(kwds, key_internalFormat)) {
                    value = PyDict_GetItem(kwds, key_internalFormat);
                    if (value && pyArgs[2]) {
                        errInfo = key_internalFormat;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2]))))
                            goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_internalFormat);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            unsigned int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // addColorAttachment(int,int,uint)
                cppSelf->addColorAttachment(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_attachment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.attachment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attachment()const
            QOpenGLFramebufferObject::Attachment cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->attachment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            bool cppResult = cppSelf->bind();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_bindDefault(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.bindDefault";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bindDefault()
            bool cppResult = ::QOpenGLFramebufferObject::bindDefault();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.blitFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 9) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
    } else if (numArgs == 7)
        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOOO:blitFramebuffer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject*,QOpenGLFramebufferObject*,uint,uint)
    // 1: static QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint)
    // 2: static QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint,int,int)
    // 3: static QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint,int,int,QOpenGLFramebufferObject::FramebufferRestorePolicy)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX]), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 1; // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 1; // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 1; // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint)
                    } else if (numArgs >= 8
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
                        if (numArgs == 8) {
                            overloadId = 2; // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint,int,int)
                        } else if (numArgs == 9
                            && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX])->converter, (pyArgs[8])))) {
                            overloadId = 3; // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint,int,int,QOpenGLFramebufferObject::FramebufferRestorePolicy)
                        }
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // blitFramebuffer(QOpenGLFramebufferObject*,QOpenGLFramebufferObject*,uint,uint)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // blitFramebuffer(QOpenGLFramebufferObject*,QOpenGLFramebufferObject*,uint,uint)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
                    overloadId = 0; // blitFramebuffer(QOpenGLFramebufferObject*,QOpenGLFramebufferObject*,uint,uint)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // blitFramebuffer(QOpenGLFramebufferObject * target, QOpenGLFramebufferObject * source, unsigned int buffers, unsigned int filter)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_buffers = Shiboken::String::createStaticString("buffers");
                if (PyDict_Contains(kwds, key_buffers)) {
                    value = PyDict_GetItem(kwds, key_buffers);
                    if (value && pyArgs[2]) {
                        errInfo = key_buffers;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2]))))
                            goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_buffers);
                }
                static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
                if (PyDict_Contains(kwds, key_filter)) {
                    value = PyDict_GetItem(kwds, key_filter);
                    if (value && pyArgs[3]) {
                        errInfo = key_filter;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3]))))
                            goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filter);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QOpenGLFramebufferObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QOpenGLFramebufferObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            unsigned int cppArg2 = GL_COLOR_BUFFER_BIT;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            unsigned int cppArg3 = GL_NEAREST;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // blitFramebuffer(QOpenGLFramebufferObject*,QOpenGLFramebufferObject*,uint,uint)
                ::QOpenGLFramebufferObject::blitFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // blitFramebuffer(QOpenGLFramebufferObject * target, const QRect & targetRect, QOpenGLFramebufferObject * source, const QRect & sourceRect, unsigned int buffers, unsigned int filter)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_buffers = Shiboken::String::createStaticString("buffers");
                if (PyDict_Contains(kwds, key_buffers)) {
                    value = PyDict_GetItem(kwds, key_buffers);
                    if (value && pyArgs[4]) {
                        errInfo = key_buffers;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4]))))
                            goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_buffers);
                }
                static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
                if (PyDict_Contains(kwds, key_filter)) {
                    value = PyDict_GetItem(kwds, key_filter);
                    if (value && pyArgs[5]) {
                        errInfo = key_filter;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5]))))
                            goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filter);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QOpenGLFramebufferObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QOpenGLFramebufferObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QRect cppArg3_local;
            ::QRect *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            unsigned int cppArg4 = GL_COLOR_BUFFER_BIT;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            unsigned int cppArg5 = GL_NEAREST;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint)
                ::QOpenGLFramebufferObject::blitFramebuffer(cppArg0, *cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 2: // blitFramebuffer(QOpenGLFramebufferObject * target, const QRect & targetRect, QOpenGLFramebufferObject * source, const QRect & sourceRect, unsigned int buffers, unsigned int filter, int readColorAttachmentIndex, int drawColorAttachmentIndex)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QOpenGLFramebufferObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QOpenGLFramebufferObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QRect cppArg3_local;
            ::QRect *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            unsigned int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            unsigned int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint,int,int)
                ::QOpenGLFramebufferObject::blitFramebuffer(cppArg0, *cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
            }
            break;
        }
        case 3: // blitFramebuffer(QOpenGLFramebufferObject * target, const QRect & targetRect, QOpenGLFramebufferObject * source, const QRect & sourceRect, unsigned int buffers, unsigned int filter, int readColorAttachmentIndex, int drawColorAttachmentIndex, QOpenGLFramebufferObject::FramebufferRestorePolicy restorePolicy)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QOpenGLFramebufferObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QOpenGLFramebufferObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QRect cppArg3_local;
            ::QRect *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            unsigned int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            unsigned int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QOpenGLFramebufferObject::FramebufferRestorePolicy cppArg8{QOpenGLFramebufferObject::DontRestoreFramebufferBinding};
            pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // blitFramebuffer(QOpenGLFramebufferObject*,QRect,QOpenGLFramebufferObject*,QRect,uint,uint,int,int,QOpenGLFramebufferObject::FramebufferRestorePolicy)
                ::QOpenGLFramebufferObject::blitFramebuffer(cppArg0, *cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QOpenGLFramebufferObjectFormat cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECTFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            unsigned int cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_hasOpenGLFramebufferBlit(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.hasOpenGLFramebufferBlit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGLFramebufferBlit()
            bool cppResult = ::QOpenGLFramebufferObject::hasOpenGLFramebufferBlit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_hasOpenGLFramebufferObjects(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.hasOpenGLFramebufferObjects";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGLFramebufferObjects()
            bool cppResult = ::QOpenGLFramebufferObject::hasOpenGLFramebufferObjects();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_isBound(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.isBound";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBound()const
            bool cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->isBound();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            bool cppResult = cppSelf->release();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_setAttachment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.setAttachment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFramebufferObject::setAttachment(QOpenGLFramebufferObject::Attachment)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAttachment(QOpenGLFramebufferObject::Attachment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFramebufferObjectFunc_setAttachment_TypeError;

    // Call function/method
    {
        ::QOpenGLFramebufferObject::Attachment cppArg0{QOpenGLFramebufferObject::NoAttachment};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAttachment(QOpenGLFramebufferObject::Attachment)
            cppSelf->setAttachment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFramebufferObjectFunc_setAttachment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_sizes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.sizes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizes()const
            QVector<QSize > cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->sizes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QSIZE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_takeTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.takeTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "takeTexture", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFramebufferObject::takeTexture()
    // 1: QOpenGLFramebufferObject::takeTexture(int)
    if (numArgs == 0) {
        overloadId = 0; // takeTexture()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // takeTexture(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFramebufferObjectFunc_takeTexture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // takeTexture()
        {

            if (!PyErr_Occurred()) {
                // takeTexture()
                unsigned int cppResult = cppSelf->takeTexture();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
            }
            break;
        }
        case 1: // takeTexture(int colorAttachmentIndex)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // takeTexture(int)
                unsigned int cppResult = cppSelf->takeTexture(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFramebufferObjectFunc_takeTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_texture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.texture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // texture()const
            unsigned int cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->texture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_textures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.textures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textures()const
            QVector<unsigned int > cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->textures();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_toImage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.toImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toImage", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFramebufferObject::toImage()const
    // 1: QOpenGLFramebufferObject::toImage(bool)const
    // 2: QOpenGLFramebufferObject::toImage(bool,int)const
    if (numArgs == 0) {
        overloadId = 0; // toImage()const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // toImage(bool)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 2; // toImage(bool,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFramebufferObjectFunc_toImage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toImage() const
        {

            if (!PyErr_Occurred()) {
                // toImage()const
                QImage cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->toImage();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toImage(bool flipped) const
        {
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toImage(bool)const
                QImage cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->toImage(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // toImage(bool flipped, int colorAttachmentIndex) const
        {
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toImage(bool,int)const
                QImage cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->toImage(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFramebufferObjectFunc_toImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFramebufferObjectFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLFramebufferObject.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QOpenGLFramebufferObject *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOpenGLFramebufferObject_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLFramebufferObject_methods[] = {
    {"addColorAttachment", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_addColorAttachment), METH_VARARGS|METH_KEYWORDS},
    {"attachment", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_attachment), METH_NOARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_bind), METH_NOARGS},
    {"bindDefault", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_bindDefault), METH_NOARGS|METH_STATIC},
    {"blitFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_blitFramebuffer), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_format), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_handle), METH_NOARGS},
    {"hasOpenGLFramebufferBlit", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_hasOpenGLFramebufferBlit), METH_NOARGS|METH_STATIC},
    {"hasOpenGLFramebufferObjects", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_hasOpenGLFramebufferObjects), METH_NOARGS|METH_STATIC},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_height), METH_NOARGS},
    {"isBound", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_isBound), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_isValid), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_release), METH_NOARGS},
    {"setAttachment", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_setAttachment), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_size), METH_NOARGS},
    {"sizes", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_sizes), METH_NOARGS},
    {"takeTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_takeTexture), METH_VARARGS},
    {"texture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_texture), METH_NOARGS},
    {"textures", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_textures), METH_NOARGS},
    {"toImage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_toImage), METH_VARARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFramebufferObjectFunc_width), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOpenGLFramebufferObject_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOpenGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOpenGLFramebufferObjectWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOpenGLFramebufferObject_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLFramebufferObject_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLFramebufferObject_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLFramebufferObject_TypeF(void)
{
    return _Sbk_QOpenGLFramebufferObject_Type;
}

static PyType_Slot Sbk_QOpenGLFramebufferObject_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOpenGLFramebufferObject_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLFramebufferObject_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLFramebufferObject_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLFramebufferObject_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLFramebufferObject_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLFramebufferObject_spec = {
    "2:PySide2.QtGui.QOpenGLFramebufferObject",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLFramebufferObject_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLFramebufferObject_Attachment_PythonToCpp_QOpenGLFramebufferObject_Attachment(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLFramebufferObject::Attachment *>(cppOut) =
        static_cast<::QOpenGLFramebufferObject::Attachment>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLFramebufferObject_Attachment_PythonToCpp_QOpenGLFramebufferObject_Attachment_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX]))
        return QOpenGLFramebufferObject_Attachment_PythonToCpp_QOpenGLFramebufferObject_Attachment;
    return {};
}
static PyObject *QOpenGLFramebufferObject_Attachment_CppToPython_QOpenGLFramebufferObject_Attachment(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLFramebufferObject::Attachment *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX], castCppIn);

}

static void QOpenGLFramebufferObject_FramebufferRestorePolicy_PythonToCpp_QOpenGLFramebufferObject_FramebufferRestorePolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLFramebufferObject::FramebufferRestorePolicy *>(cppOut) =
        static_cast<::QOpenGLFramebufferObject::FramebufferRestorePolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLFramebufferObject_FramebufferRestorePolicy_PythonToCpp_QOpenGLFramebufferObject_FramebufferRestorePolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX]))
        return QOpenGLFramebufferObject_FramebufferRestorePolicy_PythonToCpp_QOpenGLFramebufferObject_FramebufferRestorePolicy;
    return {};
}
static PyObject *QOpenGLFramebufferObject_FramebufferRestorePolicy_CppToPython_QOpenGLFramebufferObject_FramebufferRestorePolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLFramebufferObject::FramebufferRestorePolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLFramebufferObject_PythonToCpp_QOpenGLFramebufferObject_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLFramebufferObject_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLFramebufferObject_PythonToCpp_QOpenGLFramebufferObject_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLFramebufferObject_TypeF())))
        return QOpenGLFramebufferObject_PythonToCpp_QOpenGLFramebufferObject_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLFramebufferObject_PTR_CppToPython_QOpenGLFramebufferObject(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLFramebufferObject *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLFramebufferObject_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLFramebufferObject_SignatureStrings[] = {
    "5:PySide2.QtGui.QOpenGLFramebufferObject(self,size:PySide2.QtCore.QSize,attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment,target:unsigned int=GL_TEXTURE_2D,internalFormat:unsigned int=0)",
    "4:PySide2.QtGui.QOpenGLFramebufferObject(self,size:PySide2.QtCore.QSize,format:PySide2.QtGui.QOpenGLFramebufferObjectFormat)",
    "3:PySide2.QtGui.QOpenGLFramebufferObject(self,size:PySide2.QtCore.QSize,target:unsigned int=GL_TEXTURE_2D)",
    "2:PySide2.QtGui.QOpenGLFramebufferObject(self,width:int,height:int,attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment,target:unsigned int=GL_TEXTURE_2D,internalFormat:unsigned int=0)",
    "1:PySide2.QtGui.QOpenGLFramebufferObject(self,width:int,height:int,format:PySide2.QtGui.QOpenGLFramebufferObjectFormat)",
    "0:PySide2.QtGui.QOpenGLFramebufferObject(self,width:int,height:int,target:unsigned int=GL_TEXTURE_2D)",
    "1:PySide2.QtGui.QOpenGLFramebufferObject.addColorAttachment(self,size:PySide2.QtCore.QSize,internalFormat:unsigned int=0)",
    "0:PySide2.QtGui.QOpenGLFramebufferObject.addColorAttachment(self,width:int,height:int,internalFormat:unsigned int=0)",
    "PySide2.QtGui.QOpenGLFramebufferObject.attachment(self)->PySide2.QtGui.QOpenGLFramebufferObject.Attachment",
    "PySide2.QtGui.QOpenGLFramebufferObject.bind(self)->bool",
    "PySide2.QtGui.QOpenGLFramebufferObject.bindDefault()->bool",
    "3:PySide2.QtGui.QOpenGLFramebufferObject.blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject,source:PySide2.QtGui.QOpenGLFramebufferObject,buffers:unsigned int=GL_COLOR_BUFFER_BIT,filter:unsigned int=GL_NEAREST)",
    "2:PySide2.QtGui.QOpenGLFramebufferObject.blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject,targetRect:PySide2.QtCore.QRect,source:PySide2.QtGui.QOpenGLFramebufferObject,sourceRect:PySide2.QtCore.QRect,buffers:unsigned int=GL_COLOR_BUFFER_BIT,filter:unsigned int=GL_NEAREST)",
    "1:PySide2.QtGui.QOpenGLFramebufferObject.blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject,targetRect:PySide2.QtCore.QRect,source:PySide2.QtGui.QOpenGLFramebufferObject,sourceRect:PySide2.QtCore.QRect,buffers:unsigned int,filter:unsigned int,readColorAttachmentIndex:int,drawColorAttachmentIndex:int)",
    "0:PySide2.QtGui.QOpenGLFramebufferObject.blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject,targetRect:PySide2.QtCore.QRect,source:PySide2.QtGui.QOpenGLFramebufferObject,sourceRect:PySide2.QtCore.QRect,buffers:unsigned int,filter:unsigned int,readColorAttachmentIndex:int,drawColorAttachmentIndex:int,restorePolicy:PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy)",
    "PySide2.QtGui.QOpenGLFramebufferObject.format(self)->PySide2.QtGui.QOpenGLFramebufferObjectFormat",
    "PySide2.QtGui.QOpenGLFramebufferObject.handle(self)->unsigned int",
    "PySide2.QtGui.QOpenGLFramebufferObject.hasOpenGLFramebufferBlit()->bool",
    "PySide2.QtGui.QOpenGLFramebufferObject.hasOpenGLFramebufferObjects()->bool",
    "PySide2.QtGui.QOpenGLFramebufferObject.height(self)->int",
    "PySide2.QtGui.QOpenGLFramebufferObject.isBound(self)->bool",
    "PySide2.QtGui.QOpenGLFramebufferObject.isValid(self)->bool",
    "PySide2.QtGui.QOpenGLFramebufferObject.release(self)->bool",
    "PySide2.QtGui.QOpenGLFramebufferObject.setAttachment(self,attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment)",
    "PySide2.QtGui.QOpenGLFramebufferObject.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QOpenGLFramebufferObject.sizes(self)->QVector[PySide2.QtCore.QSize]",
    "1:PySide2.QtGui.QOpenGLFramebufferObject.takeTexture(self)->unsigned int",
    "0:PySide2.QtGui.QOpenGLFramebufferObject.takeTexture(self,colorAttachmentIndex:int)->unsigned int",
    "PySide2.QtGui.QOpenGLFramebufferObject.texture(self)->unsigned int",
    "PySide2.QtGui.QOpenGLFramebufferObject.textures(self)->QVector[unsigned int]",
    "2:PySide2.QtGui.QOpenGLFramebufferObject.toImage(self)->PySide2.QtGui.QImage",
    "1:PySide2.QtGui.QOpenGLFramebufferObject.toImage(self,flipped:bool)->PySide2.QtGui.QImage",
    "0:PySide2.QtGui.QOpenGLFramebufferObject.toImage(self,flipped:bool,colorAttachmentIndex:int)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QOpenGLFramebufferObject.width(self)->int",
    nullptr}; // Sentinel

void init_QOpenGLFramebufferObject(PyObject *module)
{
    _Sbk_QOpenGLFramebufferObject_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLFramebufferObject",
        "QOpenGLFramebufferObject*",
        &Sbk_QOpenGLFramebufferObject_spec,
        &Shiboken::callCppDestructor< ::QOpenGLFramebufferObject >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLFramebufferObject_Type);
    InitSignatureStrings(pyType, QOpenGLFramebufferObject_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLFramebufferObject_Type), Sbk_QOpenGLFramebufferObject_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLFramebufferObject_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLFramebufferObject_TypeF(),
        QOpenGLFramebufferObject_PythonToCpp_QOpenGLFramebufferObject_PTR,
        is_QOpenGLFramebufferObject_PythonToCpp_QOpenGLFramebufferObject_PTR_Convertible,
        QOpenGLFramebufferObject_PTR_CppToPython_QOpenGLFramebufferObject);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLFramebufferObject");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLFramebufferObject*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLFramebufferObject&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLFramebufferObject).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLFramebufferObjectWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'Attachment'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLFramebufferObject_TypeF(),
        "Attachment",
        "2:PySide2.QtGui.QOpenGLFramebufferObject.Attachment",
        "QOpenGLFramebufferObject::Attachment");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
        Sbk_QOpenGLFramebufferObject_TypeF(), "NoAttachment", (long) QOpenGLFramebufferObject::Attachment::NoAttachment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
        Sbk_QOpenGLFramebufferObject_TypeF(), "CombinedDepthStencil", (long) QOpenGLFramebufferObject::Attachment::CombinedDepthStencil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
        Sbk_QOpenGLFramebufferObject_TypeF(), "Depth", (long) QOpenGLFramebufferObject::Attachment::Depth))
        return;
    // Register converter for enum 'QOpenGLFramebufferObject::Attachment'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
            QOpenGLFramebufferObject_Attachment_CppToPython_QOpenGLFramebufferObject_Attachment);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLFramebufferObject_Attachment_PythonToCpp_QOpenGLFramebufferObject_Attachment,
            is_QOpenGLFramebufferObject_Attachment_PythonToCpp_QOpenGLFramebufferObject_Attachment_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLFramebufferObject::Attachment");
        Shiboken::Conversions::registerConverterName(converter, "Attachment");
    }
    // End of 'Attachment' enum.

    // Initialization of enum 'FramebufferRestorePolicy'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLFramebufferObject_TypeF(),
        "FramebufferRestorePolicy",
        "2:PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy",
        "QOpenGLFramebufferObject::FramebufferRestorePolicy");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX],
        Sbk_QOpenGLFramebufferObject_TypeF(), "DontRestoreFramebufferBinding", (long) QOpenGLFramebufferObject::FramebufferRestorePolicy::DontRestoreFramebufferBinding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX],
        Sbk_QOpenGLFramebufferObject_TypeF(), "RestoreFramebufferBindingToDefault", (long) QOpenGLFramebufferObject::FramebufferRestorePolicy::RestoreFramebufferBindingToDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX],
        Sbk_QOpenGLFramebufferObject_TypeF(), "RestoreFrameBufferBinding", (long) QOpenGLFramebufferObject::FramebufferRestorePolicy::RestoreFrameBufferBinding))
        return;
    // Register converter for enum 'QOpenGLFramebufferObject::FramebufferRestorePolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX],
            QOpenGLFramebufferObject_FramebufferRestorePolicy_CppToPython_QOpenGLFramebufferObject_FramebufferRestorePolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLFramebufferObject_FramebufferRestorePolicy_PythonToCpp_QOpenGLFramebufferObject_FramebufferRestorePolicy,
            is_QOpenGLFramebufferObject_FramebufferRestorePolicy_PythonToCpp_QOpenGLFramebufferObject_FramebufferRestorePolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_FRAMEBUFFERRESTOREPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLFramebufferObject::FramebufferRestorePolicy");
        Shiboken::Conversions::registerConverterName(converter, "FramebufferRestorePolicy");
    }
    // End of 'FramebufferRestorePolicy' enum.

    qRegisterMetaType< ::QOpenGLFramebufferObject::Attachment >("QOpenGLFramebufferObject::Attachment");
    qRegisterMetaType< ::QOpenGLFramebufferObject::FramebufferRestorePolicy >("QOpenGLFramebufferObject::FramebufferRestorePolicy");
}
