/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglshader_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLShaderWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLShaderWrapper::QOpenGLShaderWrapper(::QFlags<QOpenGLShader::ShaderTypeBit> type, ::QObject * parent) : QOpenGLShader(type, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QOpenGLShaderWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLShaderWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QOpenGLShaderWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLShaderWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QOpenGLShaderWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLShader.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QOpenGLShaderWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLShader.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QOpenGLShaderWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QOpenGLShaderWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QOpenGLShader::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QOpenGLShaderWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QOpenGLShader::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QOpenGLShaderWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QOpenGLShaderWrapper *>(this));
        return QOpenGLShader::qt_metacast(_clname);
}

QOpenGLShaderWrapper::~QOpenGLShaderWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLShader_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLShader >()))
        return -1;

    ::QOpenGLShaderWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShader_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QOpenGLShader", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLShader::QOpenGLShader(QFlags<QOpenGLShader::ShaderTypeBit>,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QOpenGLShader(QFlags<QOpenGLShader::ShaderTypeBit>,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QOpenGLShader(QFlags<QOpenGLShader::ShaderTypeBit>,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShader_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLShader_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QOpenGLShader_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QOpenGLShader(QFlags<QOpenGLShader::ShaderTypeBit>,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QOpenGLShaderWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QOpenGLShaderWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLShader >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLShader_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QOpenGLShader_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QOpenGLShader_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLShaderFunc_compileSourceCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.compileSourceCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShader::compileSourceCode(QByteArray)
    // 1: QOpenGLShader::compileSourceCode(QString)
    // 2: QOpenGLShader::compileSourceCode(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // compileSourceCode(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // compileSourceCode(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // compileSourceCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderFunc_compileSourceCode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // compileSourceCode(const QByteArray & source)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // compileSourceCode(QByteArray)
                bool cppResult = cppSelf->compileSourceCode(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // compileSourceCode(const QString & source)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // compileSourceCode(QString)
                bool cppResult = cppSelf->compileSourceCode(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // compileSourceCode(const char * source)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // compileSourceCode(const char*)
                bool cppResult = cppSelf->compileSourceCode(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderFunc_compileSourceCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderFunc_compileSourceFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.compileSourceFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShader::compileSourceFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // compileSourceFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderFunc_compileSourceFile_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // compileSourceFile(QString)
            bool cppResult = cppSelf->compileSourceFile(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderFunc_compileSourceFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderFunc_hasOpenGLShaders(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.hasOpenGLShaders";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:hasOpenGLShaders", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLShader::hasOpenGLShaders(QFlags<QOpenGLShader::ShaderTypeBit>,QOpenGLContext*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // hasOpenGLShaders(QFlags<QOpenGLShader::ShaderTypeBit>,QOpenGLContext*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // hasOpenGLShaders(QFlags<QOpenGLShader::ShaderTypeBit>,QOpenGLContext*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_context = Shiboken::String::createStaticString("context");
            if (PyDict_Contains(kwds, key_context)) {
                value = PyDict_GetItem(kwds, key_context);
                if (value && pyArgs[1]) {
                    errInfo = key_context;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[1]))))
                        goto Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_context);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError;
            }
        }
        ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QOpenGLContext *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // hasOpenGLShaders(QFlags<QOpenGLShader::ShaderTypeBit>,QOpenGLContext*)
            bool cppResult = ::QOpenGLShader::hasOpenGLShaders(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderFunc_hasOpenGLShaders_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderFunc_isCompiled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.isCompiled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCompiled()const
            bool cppResult = const_cast<const ::QOpenGLShader *>(cppSelf)->isCompiled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderFunc_log(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.log";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // log()const
            QString cppResult = const_cast<const ::QOpenGLShader *>(cppSelf)->log();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderFunc_shaderId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.shaderId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaderId()const
            unsigned int cppResult = const_cast<const ::QOpenGLShader *>(cppSelf)->shaderId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderFunc_shaderType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.shaderType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaderType()const
            QFlags<QOpenGLShader::ShaderTypeBit> cppResult = const_cast<const ::QOpenGLShader *>(cppSelf)->shaderType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderFunc_sourceCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShader.sourceCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceCode()const
            QByteArray cppResult = const_cast<const ::QOpenGLShader *>(cppSelf)->sourceCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOpenGLShader_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLShader_methods[] = {
    {"compileSourceCode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_compileSourceCode), METH_O},
    {"compileSourceFile", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_compileSourceFile), METH_O},
    {"hasOpenGLShaders", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_hasOpenGLShaders), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isCompiled", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_isCompiled), METH_NOARGS},
    {"log", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_log), METH_NOARGS},
    {"shaderId", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_shaderId), METH_NOARGS},
    {"shaderType", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_shaderType), METH_NOARGS},
    {"sourceCode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderFunc_sourceCode), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOpenGLShader_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOpenGLShader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOpenGLShaderWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOpenGLShader_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLShader_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLShader_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLShader_TypeF(void)
{
    return _Sbk_QOpenGLShader_Type;
}

static PyType_Slot Sbk_QOpenGLShader_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOpenGLShader_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLShader_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLShader_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLShader_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLShader_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLShader_spec = {
    "2:PySide2.QtGui.QOpenGLShader",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLShader_slots
};

} //extern "C"

static void *Sbk_QOpenGLShader_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QOpenGLShader *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___and__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLShader::ShaderType cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLShader::ShaderType>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLShader::ShaderType>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLShader::ShaderType>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLShader::ShaderType>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___or__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLShader::ShaderType cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLShader::ShaderType>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLShader::ShaderType>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLShader::ShaderType>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLShader::ShaderType>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___xor__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLShader::ShaderType cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLShader::ShaderType>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLShader::ShaderType>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLShader::ShaderType>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLShader::ShaderType>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___invert__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLShader::ShaderType cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, self, &cppSelf);
    ::QOpenGLShader::ShaderType cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLShader_ShaderTypeBit_PythonToCpp_QOpenGLShader_ShaderTypeBit(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLShader::ShaderTypeBit *>(cppOut) =
        static_cast<::QOpenGLShader::ShaderTypeBit>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLShader_ShaderTypeBit_PythonToCpp_QOpenGLShader_ShaderTypeBit_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX]))
        return QOpenGLShader_ShaderTypeBit_PythonToCpp_QOpenGLShader_ShaderTypeBit;
    return {};
}
static PyObject *QOpenGLShader_ShaderTypeBit_CppToPython_QOpenGLShader_ShaderTypeBit(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLShader::ShaderTypeBit *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX], castCppIn);

}

static void QFlags_QOpenGLShader_ShaderTypeBit__PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLShader::ShaderTypeBit> *>(cppOut) =
        ::QFlags<QOpenGLShader::ShaderTypeBit>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QOpenGLShader_ShaderTypeBit__PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX]))
        return QFlags_QOpenGLShader_ShaderTypeBit__PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_;
    return {};
}
static PyObject *QFlags_QOpenGLShader_ShaderTypeBit__CppToPython_QFlags_QOpenGLShader_ShaderTypeBit_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QOpenGLShader::ShaderTypeBit> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX]));

}

static void QOpenGLShader_ShaderTypeBit_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLShader::ShaderTypeBit> *>(cppOut) =
        ::QFlags<QOpenGLShader::ShaderTypeBit>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QOpenGLShader_ShaderTypeBit_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX]))
        return QOpenGLShader_ShaderTypeBit_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_;
    return {};
}
static void number_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QOpenGLShader::ShaderTypeBit> *>(cppOut) =
        ::QFlags<QOpenGLShader::ShaderTypeBit>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX]))
        return number_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLShader_PythonToCpp_QOpenGLShader_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLShader_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLShader_PythonToCpp_QOpenGLShader_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLShader_TypeF())))
        return QOpenGLShader_PythonToCpp_QOpenGLShader_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLShader_PTR_CppToPython_QOpenGLShader(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QOpenGLShader *>(const_cast<void *>(cppIn)), Sbk_QOpenGLShader_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLShader_SignatureStrings[] = {
    "PySide2.QtGui.QOpenGLShader(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,parent:PySide2.QtCore.QObject=nullptr)",
    "2:PySide2.QtGui.QOpenGLShader.compileSourceCode(self,source:PySide2.QtCore.QByteArray)->bool",
    "1:PySide2.QtGui.QOpenGLShader.compileSourceCode(self,source:QString)->bool",
    "0:PySide2.QtGui.QOpenGLShader.compileSourceCode(self,source:char*)->bool",
    "PySide2.QtGui.QOpenGLShader.compileSourceFile(self,fileName:QString)->bool",
    "PySide2.QtGui.QOpenGLShader.hasOpenGLShaders(type:PySide2.QtGui.QOpenGLShader.ShaderType,context:PySide2.QtGui.QOpenGLContext=nullptr)->bool",
    "PySide2.QtGui.QOpenGLShader.isCompiled(self)->bool",
    "PySide2.QtGui.QOpenGLShader.log(self)->QString",
    "PySide2.QtGui.QOpenGLShader.shaderId(self)->unsigned int",
    "PySide2.QtGui.QOpenGLShader.shaderType(self)->PySide2.QtGui.QOpenGLShader.ShaderType",
    "PySide2.QtGui.QOpenGLShader.sourceCode(self)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_QOpenGLShader(PyObject *module)
{
    _Sbk_QOpenGLShader_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLShader",
        "QOpenGLShader*",
        &Sbk_QOpenGLShader_spec,
        &Shiboken::callCppDestructor< ::QOpenGLShader >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLShader_Type);
    InitSignatureStrings(pyType, QOpenGLShader_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLShader_Type), Sbk_QOpenGLShader_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLShader_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLShader_TypeF(),
        QOpenGLShader_PythonToCpp_QOpenGLShader_PTR,
        is_QOpenGLShader_PythonToCpp_QOpenGLShader_PTR_Convertible,
        QOpenGLShader_PTR_CppToPython_QOpenGLShader);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLShader");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLShader*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLShader&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLShader).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLShaderWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QOpenGLShader_TypeF(), &Sbk_QOpenGLShader_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ShaderTypeBit'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QOpenGLShader.ShaderType", SbkPySide2_QtGui_QOpenGLShader_ShaderTypeBit_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLShader_TypeF(),
        "ShaderTypeBit",
        "2:PySide2.QtGui.QOpenGLShader.ShaderTypeBit",
        "QOpenGLShader::ShaderTypeBit",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
        Sbk_QOpenGLShader_TypeF(), "Vertex", (long) QOpenGLShader::ShaderTypeBit::Vertex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
        Sbk_QOpenGLShader_TypeF(), "Fragment", (long) QOpenGLShader::ShaderTypeBit::Fragment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
        Sbk_QOpenGLShader_TypeF(), "Geometry", (long) QOpenGLShader::ShaderTypeBit::Geometry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
        Sbk_QOpenGLShader_TypeF(), "TessellationControl", (long) QOpenGLShader::ShaderTypeBit::TessellationControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
        Sbk_QOpenGLShader_TypeF(), "TessellationEvaluation", (long) QOpenGLShader::ShaderTypeBit::TessellationEvaluation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
        Sbk_QOpenGLShader_TypeF(), "Compute", (long) QOpenGLShader::ShaderTypeBit::Compute))
        return;
    // Register converter for enum 'QOpenGLShader::ShaderTypeBit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX],
            QOpenGLShader_ShaderTypeBit_CppToPython_QOpenGLShader_ShaderTypeBit);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLShader_ShaderTypeBit_PythonToCpp_QOpenGLShader_ShaderTypeBit,
            is_QOpenGLShader_ShaderTypeBit_PythonToCpp_QOpenGLShader_ShaderTypeBit_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_SHADERTYPEBIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLShader::ShaderTypeBit");
        Shiboken::Conversions::registerConverterName(converter, "ShaderTypeBit");
    }
    // Register converter for flag 'QFlags<QOpenGLShader::ShaderTypeBit>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX],
            QFlags_QOpenGLShader_ShaderTypeBit__CppToPython_QFlags_QOpenGLShader_ShaderTypeBit_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLShader_ShaderTypeBit_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_,
            is_QOpenGLShader_ShaderTypeBit_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QOpenGLShader_ShaderTypeBit__PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_,
            is_QFlags_QOpenGLShader_ShaderTypeBit__PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit_,
            is_number_PythonToCpp_QFlags_QOpenGLShader_ShaderTypeBit__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLShader::ShaderType");
        Shiboken::Conversions::registerConverterName(converter, "ShaderType");
    }
    // End of 'ShaderTypeBit' enum/flags.

    PySide::Signal::registerSignals(Sbk_QOpenGLShader_TypeF(), &::QOpenGLShader::staticMetaObject);
    qRegisterMetaType< ::QOpenGLShader::ShaderTypeBit >("QOpenGLShader::ShaderTypeBit");
    qRegisterMetaType< ::QOpenGLShader::ShaderType >("QOpenGLShader::ShaderType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QOpenGLShader_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QOpenGLShader_TypeF(), &::QOpenGLShader::staticMetaObject, sizeof(QOpenGLShaderWrapper));
}
