/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QPAINTENGINEWRAPPER_H
#define SBK_QPAINTENGINEWRAPPER_H

#define protected public

#include <QtGui/qpaintengine.h>


// Extra includes
#include <QVarLengthArray>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qpaintengine.h>
#include <qrect.h>
#include <qline.h>
#include <QtGui/qpainterpath.h>
#include <qpoint.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qimage.h>
#include <QtGui/qregion.h>
#include <QtGui/qpainter.h>
class QPaintEngineWrapper : public QPaintEngine
{
public:
    QPaintEngineWrapper(::QFlags<QPaintEngine::PaintEngineFeature> features = QPaintEngine::PaintEngineFeatures());
    bool begin(::QPaintDevice * pdev) override;
    ::QPoint coordinateOffset() const override;
    void drawEllipse(const ::QRect & r) override;
    void drawEllipse(const ::QRectF & r) override;
    void drawImage(const ::QRectF & r, const ::QImage & pm, const ::QRectF & sr, ::QFlags<Qt::ImageConversionFlag> flags = Qt::AutoColor) override;
    void drawLines(const ::QLine * lines, int lineCount) override;
    void drawLines(const ::QLineF * lines, int lineCount) override;
    void drawPath(const ::QPainterPath & path) override;
    void drawPixmap(const ::QRectF & r, const ::QPixmap & pm, const ::QRectF & sr) override;
    void drawPoints(const ::QPoint * points, int pointCount) override;
    void drawPoints(const ::QPointF * points, int pointCount) override;
    void drawPolygon(const ::QPoint * points, int pointCount, ::QPaintEngine::PolygonDrawMode mode) override;
    void drawPolygon(const ::QPointF * points, int pointCount, ::QPaintEngine::PolygonDrawMode mode) override;
    void drawRects(const ::QRect * rects, int rectCount) override;
    void drawRects(const ::QRectF * rects, int rectCount) override;
    void drawTextItem(const ::QPointF & p, const ::QTextItem & textItem) override;
    void drawTiledPixmap(const ::QRectF & r, const ::QPixmap & pixmap, const ::QPointF & s) override;
    bool end() override;
    ::QPaintEngine::Type type() const override;
    void updateState(const ::QPaintEngineState & state) override;
    ~QPaintEngineWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[20];
};

#endif // SBK_QPAINTENGINEWRAPPER_H

