/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpainterpathstroker_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include <QtGui/qpainterpath.h>
#include <QtGui/qpen.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPainterPathStroker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPainterPathStroker >()))
        return -1;

    ::QPainterPathStroker *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPainterPathStroker", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPainterPathStroker::QPainterPathStroker()
    // 1: QPainterPathStroker::QPainterPathStroker(QPen)
    if (numArgs == 0) {
        overloadId = 0; // QPainterPathStroker()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPainterPathStroker(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStroker_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPainterPathStroker()
        {

            if (!PyErr_Occurred()) {
                // QPainterPathStroker()
                cptr = new ::QPainterPathStroker();
            }
            break;
        }
        case 1: // QPainterPathStroker(const QPen & pen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPen cppArg0_local;
            ::QPen *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPainterPathStroker(QPen)
                cptr = new ::QPainterPathStroker(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPainterPathStroker >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPainterPathStroker_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPainterPathStroker_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPainterPathStrokerFunc_capStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.capStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capStyle()const
            Qt::PenCapStyle cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->capStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterPathStrokerFunc_createStroke(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.createStroke";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::createStroke(QPainterPath)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArg)))) {
        overloadId = 0; // createStroke(QPainterPath)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_createStroke_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // createStroke(QPainterPath)const
            QPainterPath cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->createStroke(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainterPathStrokerFunc_createStroke_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_curveThreshold(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.curveThreshold";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // curveThreshold()const
            qreal cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->curveThreshold();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterPathStrokerFunc_dashOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.dashOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dashOffset()const
            qreal cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->dashOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterPathStrokerFunc_dashPattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.dashPattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dashPattern()const
            QVector<qreal > cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->dashPattern();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterPathStrokerFunc_joinStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.joinStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // joinStyle()const
            Qt::PenJoinStyle cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->joinStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterPathStrokerFunc_miterLimit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.miterLimit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // miterLimit()const
            qreal cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->miterLimit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterPathStrokerFunc_setCapStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setCapStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setCapStyle(Qt::PenCapStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCapStyle(Qt::PenCapStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setCapStyle_TypeError;

    // Call function/method
    {
        ::Qt::PenCapStyle cppArg0{Qt::FlatCap};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCapStyle(Qt::PenCapStyle)
            cppSelf->setCapStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setCapStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_setCurveThreshold(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setCurveThreshold";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setCurveThreshold(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setCurveThreshold(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setCurveThreshold_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurveThreshold(qreal)
            cppSelf->setCurveThreshold(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setCurveThreshold_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_setDashOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setDashOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setDashOffset(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDashOffset(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setDashOffset_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDashOffset(qreal)
            cppSelf->setDashOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setDashOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_setDashPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setDashPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setDashPattern(Qt::PenStyle)
    // 1: QPainterPathStroker::setDashPattern(QVector<qreal>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDashPattern(Qt::PenStyle)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX], (pyArg)))) {
        overloadId = 1; // setDashPattern(QVector<qreal>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setDashPattern_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setDashPattern(Qt::PenStyle arg__1)
        {
            ::Qt::PenStyle cppArg0{Qt::NoPen};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setDashPattern(Qt::PenStyle)
                cppSelf->setDashPattern(cppArg0);
            }
            break;
        }
        case 1: // setDashPattern(const QVector<qreal > & dashPattern)
        {
            ::QVector<qreal > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setDashPattern(QVector<qreal>)
                cppSelf->setDashPattern(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setDashPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_setJoinStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setJoinStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setJoinStyle(Qt::PenJoinStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setJoinStyle(Qt::PenJoinStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setJoinStyle_TypeError;

    // Call function/method
    {
        ::Qt::PenJoinStyle cppArg0{Qt::MiterJoin};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setJoinStyle(Qt::PenJoinStyle)
            cppSelf->setJoinStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setJoinStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_setMiterLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setMiterLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setMiterLimit(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMiterLimit(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setMiterLimit_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMiterLimit(qreal)
            cppSelf->setMiterLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setMiterLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainterPathStroker::setWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterPathStrokerFunc_setWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidth(qreal)
            cppSelf->setWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterPathStrokerFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterPathStrokerFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainterPathStroker *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainterPathStroker.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            qreal cppResult = const_cast<const ::QPainterPathStroker *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPainterPathStroker_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPainterPathStroker_methods[] = {
    {"capStyle", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_capStyle), METH_NOARGS},
    {"createStroke", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_createStroke), METH_O},
    {"curveThreshold", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_curveThreshold), METH_NOARGS},
    {"dashOffset", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_dashOffset), METH_NOARGS},
    {"dashPattern", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_dashPattern), METH_NOARGS},
    {"joinStyle", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_joinStyle), METH_NOARGS},
    {"miterLimit", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_miterLimit), METH_NOARGS},
    {"setCapStyle", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setCapStyle), METH_O},
    {"setCurveThreshold", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setCurveThreshold), METH_O},
    {"setDashOffset", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setDashOffset), METH_O},
    {"setDashPattern", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setDashPattern), METH_O},
    {"setJoinStyle", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setJoinStyle), METH_O},
    {"setMiterLimit", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setMiterLimit), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_setWidth), METH_O},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QPainterPathStrokerFunc_width), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPainterPathStroker_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPainterPathStroker_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPainterPathStroker_Type = nullptr;
static SbkObjectType *Sbk_QPainterPathStroker_TypeF(void)
{
    return _Sbk_QPainterPathStroker_Type;
}

static PyType_Slot Sbk_QPainterPathStroker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPainterPathStroker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPainterPathStroker_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPainterPathStroker_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPainterPathStroker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPainterPathStroker_spec = {
    "2:PySide2.QtGui.QPainterPathStroker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPainterPathStroker_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPainterPathStroker_PythonToCpp_QPainterPathStroker_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPainterPathStroker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPainterPathStroker_PythonToCpp_QPainterPathStroker_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPainterPathStroker_TypeF())))
        return QPainterPathStroker_PythonToCpp_QPainterPathStroker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPainterPathStroker_PTR_CppToPython_QPainterPathStroker(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPainterPathStroker *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPainterPathStroker_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPainterPathStroker_SignatureStrings[] = {
    "1:PySide2.QtGui.QPainterPathStroker(self)",
    "0:PySide2.QtGui.QPainterPathStroker(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtGui.QPainterPathStroker.capStyle(self)->PySide2.QtCore.Qt.PenCapStyle",
    "PySide2.QtGui.QPainterPathStroker.createStroke(self,path:PySide2.QtGui.QPainterPath)->PySide2.QtGui.QPainterPath",
    "PySide2.QtGui.QPainterPathStroker.curveThreshold(self)->qreal",
    "PySide2.QtGui.QPainterPathStroker.dashOffset(self)->qreal",
    "PySide2.QtGui.QPainterPathStroker.dashPattern(self)->QVector[qreal]",
    "PySide2.QtGui.QPainterPathStroker.joinStyle(self)->PySide2.QtCore.Qt.PenJoinStyle",
    "PySide2.QtGui.QPainterPathStroker.miterLimit(self)->qreal",
    "PySide2.QtGui.QPainterPathStroker.setCapStyle(self,style:PySide2.QtCore.Qt.PenCapStyle)",
    "PySide2.QtGui.QPainterPathStroker.setCurveThreshold(self,threshold:qreal)",
    "PySide2.QtGui.QPainterPathStroker.setDashOffset(self,offset:qreal)",
    "1:PySide2.QtGui.QPainterPathStroker.setDashPattern(self,arg__1:PySide2.QtCore.Qt.PenStyle)",
    "0:PySide2.QtGui.QPainterPathStroker.setDashPattern(self,dashPattern:QVector[qreal])",
    "PySide2.QtGui.QPainterPathStroker.setJoinStyle(self,style:PySide2.QtCore.Qt.PenJoinStyle)",
    "PySide2.QtGui.QPainterPathStroker.setMiterLimit(self,length:qreal)",
    "PySide2.QtGui.QPainterPathStroker.setWidth(self,width:qreal)",
    "PySide2.QtGui.QPainterPathStroker.width(self)->qreal",
    nullptr}; // Sentinel

void init_QPainterPathStroker(PyObject *module)
{
    _Sbk_QPainterPathStroker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPainterPathStroker",
        "QPainterPathStroker*",
        &Sbk_QPainterPathStroker_spec,
        &Shiboken::callCppDestructor< ::QPainterPathStroker >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPainterPathStroker_Type);
    InitSignatureStrings(pyType, QPainterPathStroker_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPainterPathStroker_Type), Sbk_QPainterPathStroker_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPainterPathStroker_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPainterPathStroker_TypeF(),
        QPainterPathStroker_PythonToCpp_QPainterPathStroker_PTR,
        is_QPainterPathStroker_PythonToCpp_QPainterPathStroker_PTR_Convertible,
        QPainterPathStroker_PTR_CppToPython_QPainterPathStroker);

    Shiboken::Conversions::registerConverterName(converter, "QPainterPathStroker");
    Shiboken::Conversions::registerConverterName(converter, "QPainterPathStroker*");
    Shiboken::Conversions::registerConverterName(converter, "QPainterPathStroker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPainterPathStroker).name());


}
