/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qradialgradient_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <qobject.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRadialGradient_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRadialGradient >()))
        return -1;

    ::QRadialGradient *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QRadialGradient", 0, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return -1;


    // Overloaded function decisor
    // 0: QRadialGradient::QRadialGradient()
    // 1: QRadialGradient::QRadialGradient(QPointF,qreal,QPointF,qreal)
    // 2: QRadialGradient::QRadialGradient(QPointF,qreal)
    // 3: QRadialGradient::QRadialGradient(QPointF,qreal,QPointF)
    // 4: QRadialGradient::QRadialGradient(QRadialGradient)
    // 5: QRadialGradient::QRadialGradient(qreal,qreal,qreal,qreal,qreal,qreal)
    // 6: QRadialGradient::QRadialGradient(qreal,qreal,qreal)
    // 7: QRadialGradient::QRadialGradient(qreal,qreal,qreal,qreal,qreal)
    if (numArgs == 0) {
        overloadId = 0; // QRadialGradient()
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 6; // QRadialGradient(qreal,qreal,qreal)
        } else if (numArgs >= 5
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 7; // QRadialGradient(qreal,qreal,qreal,qreal,qreal)
            } else if (numArgs == 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5])))) {
                overloadId = 5; // QRadialGradient(qreal,qreal,qreal,qreal,qreal,qreal)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QRadialGradient(QRadialGradient)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QRadialGradient(QPointF,qreal)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 3; // QRadialGradient(QPointF,qreal,QPointF)
            } else if (numArgs == 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
                overloadId = 1; // QRadialGradient(QPointF,qreal,QPointF,qreal)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadialGradient_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRadialGradient()
        {

            if (!PyErr_Occurred()) {
                // QRadialGradient()
                cptr = new ::QRadialGradient();
            }
            break;
        }
        case 1: // QRadialGradient(const QPointF & center, qreal centerRadius, const QPointF & focalPoint, qreal focalRadius)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPointF cppArg2_local;
            ::QPointF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QRadialGradient(QPointF,qreal,QPointF,qreal)
                cptr = new ::QRadialGradient(*cppArg0, cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
        case 2: // QRadialGradient(const QPointF & center, qreal radius)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRadialGradient(QPointF,qreal)
                cptr = new ::QRadialGradient(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QRadialGradient(const QPointF & center, qreal radius, const QPointF & focalPoint)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPointF cppArg2_local;
            ::QPointF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // QRadialGradient(QPointF,qreal,QPointF)
                cptr = new ::QRadialGradient(*cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 4: // QRadialGradient(const QRadialGradient & QRadialGradient)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRadialGradient cppArg0_local;
            ::QRadialGradient *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRadialGradient(QRadialGradient)
                cptr = new ::QRadialGradient(*cppArg0);
            }
            break;
        }
        case 5: // QRadialGradient(qreal cx, qreal cy, qreal centerRadius, qreal fx, qreal fy, qreal focalRadius)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            qreal cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            qreal cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QRadialGradient(qreal,qreal,qreal,qreal,qreal,qreal)
                cptr = new ::QRadialGradient(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 6: // QRadialGradient(qreal cx, qreal cy, qreal radius)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QRadialGradient(qreal,qreal,qreal)
                cptr = new ::QRadialGradient(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 7: // QRadialGradient(qreal cx, qreal cy, qreal radius, qreal fx, qreal fy)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            qreal cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QRadialGradient(qreal,qreal,qreal,qreal,qreal)
                cptr = new ::QRadialGradient(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRadialGradient >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRadialGradient_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRadialGradient_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRadialGradientFunc_center(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.center";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // center()const
            QPointF cppResult = const_cast<const ::QRadialGradient *>(cppSelf)->center();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadialGradientFunc_centerRadius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.centerRadius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // centerRadius()const
            qreal cppResult = const_cast<const ::QRadialGradient *>(cppSelf)->centerRadius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadialGradientFunc_focalPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.focalPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focalPoint()const
            QPointF cppResult = const_cast<const ::QRadialGradient *>(cppSelf)->focalPoint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadialGradientFunc_focalRadius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.focalRadius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focalRadius()const
            qreal cppResult = const_cast<const ::QRadialGradient *>(cppSelf)->focalRadius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadialGradientFunc_radius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.radius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // radius()const
            qreal cppResult = const_cast<const ::QRadialGradient *>(cppSelf)->radius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadialGradientFunc_setCenter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.setCenter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setCenter", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRadialGradient::setCenter(QPointF)
    // 1: QRadialGradient::setCenter(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setCenter(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setCenter(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadialGradientFunc_setCenter_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setCenter(const QPointF & center)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setCenter(QPointF)
                cppSelf->setCenter(*cppArg0);
            }
            break;
        }
        case 1: // setCenter(qreal x, qreal y)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setCenter(qreal,qreal)
                cppSelf->setCenter(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadialGradientFunc_setCenter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadialGradientFunc_setCenterRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.setCenterRadius";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadialGradient::setCenterRadius(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setCenterRadius(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadialGradientFunc_setCenterRadius_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCenterRadius(qreal)
            cppSelf->setCenterRadius(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadialGradientFunc_setCenterRadius_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadialGradientFunc_setFocalPoint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.setFocalPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFocalPoint", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRadialGradient::setFocalPoint(QPointF)
    // 1: QRadialGradient::setFocalPoint(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setFocalPoint(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setFocalPoint(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadialGradientFunc_setFocalPoint_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFocalPoint(const QPointF & focalPoint)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setFocalPoint(QPointF)
                cppSelf->setFocalPoint(*cppArg0);
            }
            break;
        }
        case 1: // setFocalPoint(qreal x, qreal y)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setFocalPoint(qreal,qreal)
                cppSelf->setFocalPoint(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadialGradientFunc_setFocalPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadialGradientFunc_setFocalRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.setFocalRadius";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadialGradient::setFocalRadius(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setFocalRadius(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadialGradientFunc_setFocalRadius_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFocalRadius(qreal)
            cppSelf->setFocalRadius(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadialGradientFunc_setFocalRadius_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadialGradientFunc_setRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRadialGradient.setRadius";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadialGradient::setRadius(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRadius(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadialGradientFunc_setRadius_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRadius(qreal)
            cppSelf->setRadius(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadialGradientFunc_setRadius_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadialGradient___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRadialGradient_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRadialGradient_methods[] = {
    {"center", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_center), METH_NOARGS},
    {"centerRadius", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_centerRadius), METH_NOARGS},
    {"focalPoint", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_focalPoint), METH_NOARGS},
    {"focalRadius", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_focalRadius), METH_NOARGS},
    {"radius", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_radius), METH_NOARGS},
    {"setCenter", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_setCenter), METH_VARARGS},
    {"setCenterRadius", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_setCenterRadius), METH_O},
    {"setFocalPoint", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_setFocalPoint), METH_VARARGS},
    {"setFocalRadius", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_setFocalRadius), METH_O},
    {"setRadius", reinterpret_cast<PyCFunction>(Sbk_QRadialGradientFunc_setRadius), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QRadialGradient___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QRadialGradient_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRadialGradient_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRadialGradient_Type = nullptr;
static SbkObjectType *Sbk_QRadialGradient_TypeF(void)
{
    return _Sbk_QRadialGradient_Type;
}

static PyType_Slot Sbk_QRadialGradient_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRadialGradient_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRadialGradient_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRadialGradient_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRadialGradient_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRadialGradient_spec = {
    "2:PySide2.QtGui.QRadialGradient",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRadialGradient_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRadialGradient_PythonToCpp_QRadialGradient_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRadialGradient_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRadialGradient_PythonToCpp_QRadialGradient_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRadialGradient_TypeF())))
        return QRadialGradient_PythonToCpp_QRadialGradient_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRadialGradient_PTR_CppToPython_QRadialGradient(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRadialGradient *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRadialGradient_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRadialGradient_COPY_CppToPython_QRadialGradient(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QRadialGradient_TypeF(), new ::QRadialGradient(*reinterpret_cast<const ::QRadialGradient *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRadialGradient_PythonToCpp_QRadialGradient_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadialGradient *>(cppOut) = *reinterpret_cast< ::QRadialGradient *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRadialGradient_PythonToCpp_QRadialGradient_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRadialGradient_TypeF())))
        return QRadialGradient_PythonToCpp_QRadialGradient_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRadialGradient_SignatureStrings[] = {
    "7:PySide2.QtGui.QRadialGradient(self)",
    "6:PySide2.QtGui.QRadialGradient(self,center:PySide2.QtCore.QPointF,centerRadius:qreal,focalPoint:PySide2.QtCore.QPointF,focalRadius:qreal)",
    "5:PySide2.QtGui.QRadialGradient(self,center:PySide2.QtCore.QPointF,radius:qreal)",
    "4:PySide2.QtGui.QRadialGradient(self,center:PySide2.QtCore.QPointF,radius:qreal,focalPoint:PySide2.QtCore.QPointF)",
    "3:PySide2.QtGui.QRadialGradient(self,QRadialGradient:PySide2.QtGui.QRadialGradient)",
    "2:PySide2.QtGui.QRadialGradient(self,cx:qreal,cy:qreal,centerRadius:qreal,fx:qreal,fy:qreal,focalRadius:qreal)",
    "1:PySide2.QtGui.QRadialGradient(self,cx:qreal,cy:qreal,radius:qreal)",
    "0:PySide2.QtGui.QRadialGradient(self,cx:qreal,cy:qreal,radius:qreal,fx:qreal,fy:qreal)",
    "PySide2.QtGui.QRadialGradient.center(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QRadialGradient.centerRadius(self)->qreal",
    "PySide2.QtGui.QRadialGradient.focalPoint(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QRadialGradient.focalRadius(self)->qreal",
    "PySide2.QtGui.QRadialGradient.radius(self)->qreal",
    "1:PySide2.QtGui.QRadialGradient.setCenter(self,center:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QRadialGradient.setCenter(self,x:qreal,y:qreal)",
    "PySide2.QtGui.QRadialGradient.setCenterRadius(self,radius:qreal)",
    "1:PySide2.QtGui.QRadialGradient.setFocalPoint(self,focalPoint:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QRadialGradient.setFocalPoint(self,x:qreal,y:qreal)",
    "PySide2.QtGui.QRadialGradient.setFocalRadius(self,radius:qreal)",
    "PySide2.QtGui.QRadialGradient.setRadius(self,radius:qreal)",
    "PySide2.QtGui.QRadialGradient.__copy__()",
    nullptr}; // Sentinel

void init_QRadialGradient(PyObject *module)
{
    _Sbk_QRadialGradient_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRadialGradient",
        "QRadialGradient",
        &Sbk_QRadialGradient_spec,
        &Shiboken::callCppDestructor< ::QRadialGradient >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRadialGradient_Type);
    InitSignatureStrings(pyType, QRadialGradient_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRadialGradient_Type), Sbk_QRadialGradient_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QRADIALGRADIENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRadialGradient_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRadialGradient_TypeF(),
        QRadialGradient_PythonToCpp_QRadialGradient_PTR,
        is_QRadialGradient_PythonToCpp_QRadialGradient_PTR_Convertible,
        QRadialGradient_PTR_CppToPython_QRadialGradient,
        QRadialGradient_COPY_CppToPython_QRadialGradient);

    Shiboken::Conversions::registerConverterName(converter, "QRadialGradient");
    Shiboken::Conversions::registerConverterName(converter, "QRadialGradient*");
    Shiboken::Conversions::registerConverterName(converter, "QRadialGradient&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRadialGradient).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRadialGradient_PythonToCpp_QRadialGradient_COPY,
        is_QRadialGradient_PythonToCpp_QRadialGradient_COPY_Convertible);

    qRegisterMetaType< ::QRadialGradient >("QRadialGradient");
}
