/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qsyntaxhighlighter_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSyntaxHighlighterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSyntaxHighlighterWrapper::QSyntaxHighlighterWrapper(::QObject * parent) : QSyntaxHighlighter(parent)
{
    resetPyMethodCache();
    // ... middle
}

QSyntaxHighlighterWrapper::QSyntaxHighlighterWrapper(::QTextDocument * parent) : QSyntaxHighlighter(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QSyntaxHighlighterWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSyntaxHighlighterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSyntaxHighlighterWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSyntaxHighlighterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSyntaxHighlighterWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSyntaxHighlighter.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSyntaxHighlighterWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSyntaxHighlighter.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QSyntaxHighlighterWrapper::highlightBlock(const ::QString & text)
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSyntaxHighlighter.highlightBlock()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "highlightBlock";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSyntaxHighlighter.highlightBlock()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &text)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSyntaxHighlighterWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSyntaxHighlighterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSyntaxHighlighter::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSyntaxHighlighterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSyntaxHighlighter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSyntaxHighlighterWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSyntaxHighlighterWrapper *>(this));
        return QSyntaxHighlighter::qt_metacast(_clname);
}

QSyntaxHighlighterWrapper::~QSyntaxHighlighterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSyntaxHighlighter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSyntaxHighlighter' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSyntaxHighlighter >()))
        return -1;

    ::QSyntaxHighlighterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSyntaxHighlighter", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSyntaxHighlighter::QSyntaxHighlighter(QObject*)
    // 1: QSyntaxHighlighter::QSyntaxHighlighter(QTextDocument*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSyntaxHighlighter(QTextDocument*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSyntaxHighlighter(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighter_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSyntaxHighlighter(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSyntaxHighlighter(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSyntaxHighlighterWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSyntaxHighlighterWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QSyntaxHighlighter(QTextDocument * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextDocument *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSyntaxHighlighter(QTextDocument*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSyntaxHighlighterWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSyntaxHighlighterWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSyntaxHighlighter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSyntaxHighlighter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSyntaxHighlighter_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSyntaxHighlighter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_currentBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.currentBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentBlock()const
            QTextBlock cppResult = const_cast<const ::QSyntaxHighlighter *>(cppSelf)->currentBlock();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_currentBlockState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.currentBlockState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentBlockState()const
            int cppResult = const_cast<const ::QSyntaxHighlighter *>(cppSelf)->currentBlockState();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_currentBlockUserData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.currentBlockUserData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentBlockUserData()const
            QTextBlockUserData * cppResult = const_cast<const ::QSyntaxHighlighter *>(cppSelf)->currentBlockUserData();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKUSERDATA_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_document(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.document";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // document()const
            QTextDocument * cppResult = const_cast<const ::QSyntaxHighlighter *>(cppSelf)->document();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), cppResult);
            Shiboken::Object::setParent(pyResult, self);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_format(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.format";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSyntaxHighlighter::format(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // format(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_format_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // format(int)const
            QTextCharFormat cppResult = const_cast<const ::QSyntaxHighlighter *>(cppSelf)->format(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSyntaxHighlighterFunc_format_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSyntaxHighlighterFunc_highlightBlock(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.highlightBlock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSyntaxHighlighter::highlightBlock(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // highlightBlock(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_highlightBlock_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // highlightBlock(QString)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSyntaxHighlighter.highlightBlock()' not implemented.");
                return {};
            }
            cppSelf->highlightBlock(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSyntaxHighlighterFunc_highlightBlock_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSyntaxHighlighterFunc_previousBlockState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.previousBlockState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // previousBlockState()const
            int cppResult = const_cast<const ::QSyntaxHighlighter *>(cppSelf)->previousBlockState();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_rehighlight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.rehighlight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rehighlight()
            cppSelf->rehighlight();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSyntaxHighlighterFunc_rehighlightBlock(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.rehighlightBlock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSyntaxHighlighter::rehighlightBlock(QTextBlock)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), (pyArg)))) {
        overloadId = 0; // rehighlightBlock(QTextBlock)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_rehighlightBlock_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextBlock cppArg0_local;
        ::QTextBlock *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // rehighlightBlock(QTextBlock)
            cppSelf->rehighlightBlock(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSyntaxHighlighterFunc_rehighlightBlock_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSyntaxHighlighterFunc_setCurrentBlockState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.setCurrentBlockState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSyntaxHighlighter::setCurrentBlockState(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentBlockState(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_setCurrentBlockState_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentBlockState(int)
            cppSelf->setCurrentBlockState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSyntaxHighlighterFunc_setCurrentBlockState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSyntaxHighlighterFunc_setCurrentBlockUserData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.setCurrentBlockUserData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSyntaxHighlighter::setCurrentBlockUserData(QTextBlockUserData*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKUSERDATA_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentBlockUserData(QTextBlockUserData*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_setCurrentBlockUserData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextBlockUserData *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentBlockUserData(QTextBlockUserData*)
            cppSelf->setCurrentBlockUserData(cppArg0);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSyntaxHighlighterFunc_setCurrentBlockUserData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSyntaxHighlighterFunc_setDocument(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.setDocument";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSyntaxHighlighter::setDocument(QTextDocument*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArg)))) {
        overloadId = 0; // setDocument(QTextDocument*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_setDocument_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextDocument *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDocument(QTextDocument*)
            cppSelf->setDocument(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSyntaxHighlighterFunc_setDocument_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSyntaxHighlighterFunc_setFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSyntaxHighlighter.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFormat", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QSyntaxHighlighter::setFormat(int,int,QColor)
    // 1: QSyntaxHighlighter::setFormat(int,int,QFont)
    // 2: QSyntaxHighlighter::setFormat(int,int,QTextCharFormat)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArgs[2])))) {
            overloadId = 2; // setFormat(int,int,QTextCharFormat)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // setFormat(int,int,QFont)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[2])))) {
            overloadId = 0; // setFormat(int,int,QColor)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSyntaxHighlighterFunc_setFormat_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFormat(int start, int count, const QColor & color)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QColor cppArg2_local;
            ::QColor *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setFormat(int,int,QColor)
                cppSelf->setFormat(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // setFormat(int start, int count, const QFont & font)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QFont cppArg2_local;
            ::QFont *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setFormat(int,int,QFont)
                cppSelf->setFormat(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 2: // setFormat(int start, int count, const QTextCharFormat & format)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTextCharFormat cppArg2_local;
            ::QTextCharFormat *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setFormat(int,int,QTextCharFormat)
                cppSelf->setFormat(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSyntaxHighlighterFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSyntaxHighlighter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSyntaxHighlighter_methods[] = {
    {"currentBlock", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_currentBlock), METH_NOARGS},
    {"currentBlockState", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_currentBlockState), METH_NOARGS},
    {"currentBlockUserData", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_currentBlockUserData), METH_NOARGS},
    {"document", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_document), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_format), METH_O},
    {"highlightBlock", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_highlightBlock), METH_O},
    {"previousBlockState", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_previousBlockState), METH_NOARGS},
    {"rehighlight", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_rehighlight), METH_NOARGS},
    {"rehighlightBlock", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_rehighlightBlock), METH_O},
    {"setCurrentBlockState", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_setCurrentBlockState), METH_O},
    {"setCurrentBlockUserData", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_setCurrentBlockUserData), METH_O},
    {"setDocument", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_setDocument), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QSyntaxHighlighterFunc_setFormat), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSyntaxHighlighter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSyntaxHighlighter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSyntaxHighlighterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSyntaxHighlighter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSyntaxHighlighter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSyntaxHighlighter_Type = nullptr;
static SbkObjectType *Sbk_QSyntaxHighlighter_TypeF(void)
{
    return _Sbk_QSyntaxHighlighter_Type;
}

static PyType_Slot Sbk_QSyntaxHighlighter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSyntaxHighlighter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSyntaxHighlighter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSyntaxHighlighter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSyntaxHighlighter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSyntaxHighlighter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSyntaxHighlighter_spec = {
    "2:PySide2.QtGui.QSyntaxHighlighter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSyntaxHighlighter_slots
};

} //extern "C"

static void *Sbk_QSyntaxHighlighter_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSyntaxHighlighter *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSyntaxHighlighter_PythonToCpp_QSyntaxHighlighter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSyntaxHighlighter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSyntaxHighlighter_PythonToCpp_QSyntaxHighlighter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSyntaxHighlighter_TypeF())))
        return QSyntaxHighlighter_PythonToCpp_QSyntaxHighlighter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSyntaxHighlighter_PTR_CppToPython_QSyntaxHighlighter(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSyntaxHighlighter *>(const_cast<void *>(cppIn)), Sbk_QSyntaxHighlighter_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSyntaxHighlighter_SignatureStrings[] = {
    "1:PySide2.QtGui.QSyntaxHighlighter(self,parent:PySide2.QtCore.QObject)",
    "0:PySide2.QtGui.QSyntaxHighlighter(self,parent:PySide2.QtGui.QTextDocument)",
    "PySide2.QtGui.QSyntaxHighlighter.currentBlock(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QSyntaxHighlighter.currentBlockState(self)->int",
    "PySide2.QtGui.QSyntaxHighlighter.currentBlockUserData(self)->PySide2.QtGui.QTextBlockUserData",
    "PySide2.QtGui.QSyntaxHighlighter.document(self)->PySide2.QtGui.QTextDocument",
    "PySide2.QtGui.QSyntaxHighlighter.format(self,pos:int)->PySide2.QtGui.QTextCharFormat",
    "PySide2.QtGui.QSyntaxHighlighter.highlightBlock(self,text:QString)",
    "PySide2.QtGui.QSyntaxHighlighter.previousBlockState(self)->int",
    "PySide2.QtGui.QSyntaxHighlighter.rehighlight(self)",
    "PySide2.QtGui.QSyntaxHighlighter.rehighlightBlock(self,block:PySide2.QtGui.QTextBlock)",
    "PySide2.QtGui.QSyntaxHighlighter.setCurrentBlockState(self,newState:int)",
    "PySide2.QtGui.QSyntaxHighlighter.setCurrentBlockUserData(self,data:PySide2.QtGui.QTextBlockUserData)",
    "PySide2.QtGui.QSyntaxHighlighter.setDocument(self,doc:PySide2.QtGui.QTextDocument)",
    "2:PySide2.QtGui.QSyntaxHighlighter.setFormat(self,start:int,count:int,color:PySide2.QtGui.QColor)",
    "1:PySide2.QtGui.QSyntaxHighlighter.setFormat(self,start:int,count:int,font:PySide2.QtGui.QFont)",
    "0:PySide2.QtGui.QSyntaxHighlighter.setFormat(self,start:int,count:int,format:PySide2.QtGui.QTextCharFormat)",
    nullptr}; // Sentinel

void init_QSyntaxHighlighter(PyObject *module)
{
    _Sbk_QSyntaxHighlighter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSyntaxHighlighter",
        "QSyntaxHighlighter*",
        &Sbk_QSyntaxHighlighter_spec,
        &Shiboken::callCppDestructor< ::QSyntaxHighlighter >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSyntaxHighlighter_Type);
    InitSignatureStrings(pyType, QSyntaxHighlighter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSyntaxHighlighter_Type), Sbk_QSyntaxHighlighter_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSyntaxHighlighter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSyntaxHighlighter_TypeF(),
        QSyntaxHighlighter_PythonToCpp_QSyntaxHighlighter_PTR,
        is_QSyntaxHighlighter_PythonToCpp_QSyntaxHighlighter_PTR_Convertible,
        QSyntaxHighlighter_PTR_CppToPython_QSyntaxHighlighter);

    Shiboken::Conversions::registerConverterName(converter, "QSyntaxHighlighter");
    Shiboken::Conversions::registerConverterName(converter, "QSyntaxHighlighter*");
    Shiboken::Conversions::registerConverterName(converter, "QSyntaxHighlighter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSyntaxHighlighter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSyntaxHighlighterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSyntaxHighlighter_TypeF(), &Sbk_QSyntaxHighlighter_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QSyntaxHighlighter_TypeF(), &::QSyntaxHighlighter::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSyntaxHighlighter_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSyntaxHighlighter_TypeF(), &::QSyntaxHighlighter::staticMetaObject, sizeof(QSyntaxHighlighterWrapper));
}
