/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextblock_wrapper.h"

// inner classes
#include "qtextblock_iterator_wrapper.h"

// Extra includes
#include <QTextBlock>
#include <QTextLayout>
#include <QVector>
#include <QtGui/qtextdocument.h>
#include <QtGui/qtextformat.h>
#include <QtGui/qtextlayout.h>
#include <QtGui/qtextlist.h>
#include <QtGui/qtextobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextBlock_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextBlock >()))
        return -1;

    ::QTextBlock *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextBlock", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextBlock::QTextBlock()
    // 1: QTextBlock::QTextBlock(QTextBlock)
    if (numArgs == 0) {
        overloadId = 0; // QTextBlock()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextBlock(QTextBlock)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlock_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextBlock()
        {

            if (!PyErr_Occurred()) {
                // QTextBlock()
                cptr = new ::QTextBlock();
            }
            break;
        }
        case 1: // QTextBlock(const QTextBlock & o)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextBlock cppArg0_local;
            ::QTextBlock *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextBlock(QTextBlock)
                cptr = new ::QTextBlock(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextBlock >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextBlock_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextBlock_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextBlockFunc___iter__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.__iter__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __iter__()
            // Begin code injection
            // TEMPLATE - __iter_parent__ - START
            QTextBlock::iterator _tmp = cppSelf->begin();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_ITERATOR_IDX]), &_tmp);
            // TEMPLATE - __iter_parent__ - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_begin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.begin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // begin()const
            QTextBlock::iterator cppResult = const_cast<const ::QTextBlock *>(cppSelf)->begin();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_ITERATOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_blockFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.blockFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockFormat()const
            QTextBlockFormat cppResult = const_cast<const ::QTextBlock *>(cppSelf)->blockFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_blockFormatIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.blockFormatIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockFormatIndex()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->blockFormatIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_blockNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.blockNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockNumber()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->blockNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_charFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.charFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // charFormat()const
            QTextCharFormat cppResult = const_cast<const ::QTextBlock *>(cppSelf)->charFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_charFormatIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.charFormatIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // charFormatIndex()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->charFormatIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_clearLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.clearLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearLayout()
            cppSelf->clearLayout();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextBlockFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlock::contains(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // contains(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFunc_contains_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contains(int)const
            bool cppResult = const_cast<const ::QTextBlock *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextBlockFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFunc_document(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.document";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // document()const
            const QTextDocument * cppResult = const_cast<const ::QTextBlock *>(cppSelf)->document();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_end(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.end";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // end()const
            QTextBlock::iterator cppResult = const_cast<const ::QTextBlock *>(cppSelf)->end();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_ITERATOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_firstLineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.firstLineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstLineNumber()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->firstLineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_fragmentIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.fragmentIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fragmentIndex()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->fragmentIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextBlock *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QTextBlock *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_layout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.layout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layout()const
            QTextLayout * cppResult = const_cast<const ::QTextBlock *>(cppSelf)->layout();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_lineCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.lineCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineCount()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->lineCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_next(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.next";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // next()const
            QTextBlock cppResult = const_cast<const ::QTextBlock *>(cppSelf)->next();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_previous(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.previous";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // previous()const
            QTextBlock cppResult = const_cast<const ::QTextBlock *>(cppSelf)->previous();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_revision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.revision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // revision()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->revision();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_setLineCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.setLineCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlock::setLineCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLineCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFunc_setLineCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLineCount(int)
            cppSelf->setLineCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFunc_setLineCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFunc_setRevision(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.setRevision";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlock::setRevision(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRevision(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFunc_setRevision_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRevision(int)
            cppSelf->setRevision(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFunc_setRevision_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFunc_setUserData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.setUserData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlock::setUserData(QTextBlockUserData*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKUSERDATA_IDX]), (pyArg)))) {
        overloadId = 0; // setUserData(QTextBlockUserData*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFunc_setUserData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextBlockUserData *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUserData(QTextBlockUserData*)
            cppSelf->setUserData(cppArg0);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qtextblock-setuserdata)]
            const QTextDocument *doc = cppSelf->document();
            if (doc) {
                Shiboken::AutoDecRef pyDocument(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), doc));
                Shiboken::Object::setParent(pyDocument, pyArg);
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qtextblock-setuserdata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFunc_setUserData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFunc_setUserState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.setUserState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlock::setUserState(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUserState(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFunc_setUserState_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUserState(int)
            cppSelf->setUserState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFunc_setUserState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlock::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QTextBlock *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_textDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.textDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textDirection()const
            Qt::LayoutDirection cppResult = const_cast<const ::QTextBlock *>(cppSelf)->textDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_textFormats(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.textFormats";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textFormats()const
            QVector<QTextLayout::FormatRange > cppResult = const_cast<const ::QTextBlock *>(cppSelf)->textFormats();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLAYOUT_FORMATRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_textList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.textList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textList()const
            QTextList * cppResult = const_cast<const ::QTextBlock *>(cppSelf)->textList();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLIST_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_userData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.userData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userData()const
            QTextBlockUserData * cppResult = const_cast<const ::QTextBlock *>(cppSelf)->userData();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKUSERDATA_IDX]), cppResult);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qtextblock-userdata)]
            const QTextDocument *doc = cppSelf->document();
            if (doc) {
                Shiboken::AutoDecRef pyDocument(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), doc));
                Shiboken::Object::setParent(pyDocument, pyResult);
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qtextblock-userdata)]
            // ========================================================================

            // End of code injection


            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFunc_userState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlock.userState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userState()const
            int cppResult = const_cast<const ::QTextBlock *>(cppSelf)->userState();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlock___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextBlock_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextBlock_methods[] = {
    {"begin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_begin), METH_NOARGS},
    {"blockFormat", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_blockFormat), METH_NOARGS},
    {"blockFormatIndex", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_blockFormatIndex), METH_NOARGS},
    {"blockNumber", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_blockNumber), METH_NOARGS},
    {"charFormat", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_charFormat), METH_NOARGS},
    {"charFormatIndex", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_charFormatIndex), METH_NOARGS},
    {"clearLayout", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_clearLayout), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_contains), METH_O},
    {"document", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_document), METH_NOARGS},
    {"end", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_end), METH_NOARGS},
    {"firstLineNumber", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_firstLineNumber), METH_NOARGS},
    {"fragmentIndex", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_fragmentIndex), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_isValid), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_isVisible), METH_NOARGS},
    {"layout", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_layout), METH_NOARGS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_length), METH_NOARGS},
    {"lineCount", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_lineCount), METH_NOARGS},
    {"next", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_next), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_position), METH_NOARGS},
    {"previous", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_previous), METH_NOARGS},
    {"revision", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_revision), METH_NOARGS},
    {"setLineCount", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_setLineCount), METH_O},
    {"setRevision", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_setRevision), METH_O},
    {"setUserData", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_setUserData), METH_O},
    {"setUserState", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_setUserState), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_setVisible), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_text), METH_NOARGS},
    {"textDirection", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_textDirection), METH_NOARGS},
    {"textFormats", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_textFormats), METH_NOARGS},
    {"textList", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_textList), METH_NOARGS},
    {"userData", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_userData), METH_NOARGS},
    {"userState", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFunc_userState), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextBlock___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QTextBlock_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), (pyArg)))) {
                // operator!=(const QTextBlock & o) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextBlock cppArg0_local;
                ::QTextBlock *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), (pyArg)))) {
                // operator<(const QTextBlock & o) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextBlock cppArg0_local;
                ::QTextBlock *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTextBlock_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), (pyArg)))) {
                // operator==(const QTextBlock & o) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextBlock cppArg0_local;
                ::QTextBlock *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QTextBlock_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QTextBlock_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QTextBlock_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextBlock_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextBlock_Type = nullptr;
static SbkObjectType *Sbk_QTextBlock_TypeF(void)
{
    return _Sbk_QTextBlock_Type;
}

static PyType_Slot Sbk_QTextBlock_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextBlock_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextBlock_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QTextBlock_richcompare)},
    {Py_tp_iter,        reinterpret_cast<void *>(Sbk_QTextBlockFunc___iter__)},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextBlock_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextBlock_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextBlock_spec = {
    "2:PySide2.QtGui.QTextBlock",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextBlock_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextBlock_PythonToCpp_QTextBlock_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextBlock_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextBlock_PythonToCpp_QTextBlock_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextBlock_TypeF())))
        return QTextBlock_PythonToCpp_QTextBlock_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextBlock_PTR_CppToPython_QTextBlock(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextBlock *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextBlock_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextBlock_COPY_CppToPython_QTextBlock(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextBlock_TypeF(), new ::QTextBlock(*reinterpret_cast<const ::QTextBlock *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextBlock_PythonToCpp_QTextBlock_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBlock *>(cppOut) = *reinterpret_cast< ::QTextBlock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextBlock_PythonToCpp_QTextBlock_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextBlock_TypeF())))
        return QTextBlock_PythonToCpp_QTextBlock_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextBlock_SignatureStrings[] = {
    "1:PySide2.QtGui.QTextBlock(self)",
    "0:PySide2.QtGui.QTextBlock(self,o:PySide2.QtGui.QTextBlock)",
    "PySide2.QtGui.QTextBlock.__iter__(self)->PyObject",
    "PySide2.QtGui.QTextBlock.begin(self)->PySide2.QtGui.QTextBlock.iterator",
    "PySide2.QtGui.QTextBlock.blockFormat(self)->PySide2.QtGui.QTextBlockFormat",
    "PySide2.QtGui.QTextBlock.blockFormatIndex(self)->int",
    "PySide2.QtGui.QTextBlock.blockNumber(self)->int",
    "PySide2.QtGui.QTextBlock.charFormat(self)->PySide2.QtGui.QTextCharFormat",
    "PySide2.QtGui.QTextBlock.charFormatIndex(self)->int",
    "PySide2.QtGui.QTextBlock.clearLayout(self)",
    "PySide2.QtGui.QTextBlock.contains(self,position:int)->bool",
    "PySide2.QtGui.QTextBlock.document(self)->PySide2.QtGui.QTextDocument",
    "PySide2.QtGui.QTextBlock.end(self)->PySide2.QtGui.QTextBlock.iterator",
    "PySide2.QtGui.QTextBlock.firstLineNumber(self)->int",
    "PySide2.QtGui.QTextBlock.fragmentIndex(self)->int",
    "PySide2.QtGui.QTextBlock.isValid(self)->bool",
    "PySide2.QtGui.QTextBlock.isVisible(self)->bool",
    "PySide2.QtGui.QTextBlock.layout(self)->PySide2.QtGui.QTextLayout",
    "PySide2.QtGui.QTextBlock.length(self)->int",
    "PySide2.QtGui.QTextBlock.lineCount(self)->int",
    "PySide2.QtGui.QTextBlock.next(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextBlock.position(self)->int",
    "PySide2.QtGui.QTextBlock.previous(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextBlock.revision(self)->int",
    "PySide2.QtGui.QTextBlock.setLineCount(self,count:int)",
    "PySide2.QtGui.QTextBlock.setRevision(self,rev:int)",
    "PySide2.QtGui.QTextBlock.setUserData(self,data:PySide2.QtGui.QTextBlockUserData)",
    "PySide2.QtGui.QTextBlock.setUserState(self,state:int)",
    "PySide2.QtGui.QTextBlock.setVisible(self,visible:bool)",
    "PySide2.QtGui.QTextBlock.text(self)->QString",
    "PySide2.QtGui.QTextBlock.textDirection(self)->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtGui.QTextBlock.textFormats(self)->QVector[PySide2.QtGui.QTextLayout.FormatRange]",
    "PySide2.QtGui.QTextBlock.textList(self)->PySide2.QtGui.QTextList",
    "PySide2.QtGui.QTextBlock.userData(self)->PySide2.QtGui.QTextBlockUserData",
    "PySide2.QtGui.QTextBlock.userState(self)->int",
    "PySide2.QtGui.QTextBlock.__copy__()",
    nullptr}; // Sentinel

void init_QTextBlock(PyObject *module)
{
    _Sbk_QTextBlock_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextBlock",
        "QTextBlock",
        &Sbk_QTextBlock_spec,
        &Shiboken::callCppDestructor< ::QTextBlock >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextBlock_Type);
    InitSignatureStrings(pyType, QTextBlock_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextBlock_Type), Sbk_QTextBlock_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextBlock_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextBlock_TypeF(),
        QTextBlock_PythonToCpp_QTextBlock_PTR,
        is_QTextBlock_PythonToCpp_QTextBlock_PTR_Convertible,
        QTextBlock_PTR_CppToPython_QTextBlock,
        QTextBlock_COPY_CppToPython_QTextBlock);

    Shiboken::Conversions::registerConverterName(converter, "QTextBlock");
    Shiboken::Conversions::registerConverterName(converter, "QTextBlock*");
    Shiboken::Conversions::registerConverterName(converter, "QTextBlock&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextBlock).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextBlock_PythonToCpp_QTextBlock_COPY,
        is_QTextBlock_PythonToCpp_QTextBlock_COPY_Convertible);

    qRegisterMetaType< ::QTextBlock >("QTextBlock");
}
